/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.SLFileMessageProcessor;
import com.streamscape.slex.file.SLFileMessageRaiser;
import com.streamscape.slex.slang.SLMessageListener;
import java.io.IOException;

public class SLFileMessageRaiserLocal
implements SLFileMessageRaiser {
    private String componentName;
    private String slSessionName;
    private SLFileMessageProcessor slFileMessageProcessor = new SLFileMessageProcessor();

    public SLFileMessageRaiserLocal(final String componentName, final String slSessionName) {
        if (slSessionName != null) {
            this.slFileMessageProcessor.setSLMessageListener(new SLMessageListener(){

                @Override
                public void onMessage(SLMessage message) {
                    if (message instanceof SLFileMessage) {
                        message = new SLMessage(message.getText(), componentName, slSessionName);
                    }
                    try {
                        SLFileMessageRaiserLocal.this.raiseSLMessage(message);
                    }
                    catch (FabricException exception) {
                        Trace.logException(this, exception, false);
                        Trace.logError(this, "Raising SL message '" + String.valueOf(message) + "' failed.");
                    }
                }
            });
        }
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() {
        this.slFileMessageProcessor.close();
    }

    @Override
    public SLFileMessage raise(SLFileMessage message, long timeout) throws IOException {
        message.setComponentName(this.componentName);
        message.setSLSessionName(this.slSessionName);
        return this.slFileMessageProcessor.process(message);
    }

    protected void raiseSLMessage(SLMessage message) throws FabricException {
        AbstractOperation.raiseSLMessage(message);
    }
}

