/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.local.LocalFileSystem;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.slex.lang.parameter.LocalPathCompleter;
import com.streamscape.slex.slang.SLMessageListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class SLFileMessageProcessor {
    private Map<String, FileDescriptor> files = new HashMap<String, FileDescriptor>();
    private SLMessageListener slMessageListener = null;
    private Map<String, SLMessageListener> slMessageListeners = new ConcurrentHashMap<String, SLMessageListener>();
    private boolean debug;

    public SLFileMessageProcessor() {
        this(true);
    }

    SLFileMessageProcessor(boolean debug) {
        this.debug = debug;
    }

    public synchronized void close() {
        for (FileDescriptor descriptor : this.files.values()) {
            descriptor.close();
        }
        this.files.clear();
    }

    public synchronized void close(String slSessionName) {
        Iterator<FileDescriptor> iterator = this.files.values().iterator();
        while (iterator.hasNext()) {
            FileDescriptor descriptor = iterator.next();
            if (descriptor.slSessionName == null || !descriptor.slSessionName.equals(slSessionName)) continue;
            iterator.remove();
        }
    }

    public synchronized SLFileMessage process(SLFileMessage message) throws IOException {
        SLFileMessage response = new SLFileMessage();
        response.setOperation(message.getOperation());
        response.setFilename(message.getFilename());
        response.setLengthProcessed(message.getLengthProcessed());
        response.setLengthTotal(message.getLengthTotal());
        response.setComponentName(message.getComponentName());
        response.setSLSessionName(message.getSLSessionName());
        response.setDstFilename(message.getDstFilename());
        response.setRecursive(message.isRecursive());
        response.setPermissions(message.getPermissions());
        response.setUsername(message.getUsername());
        response.setGroupname(message.getGroupname());
        response.setOverwrite(message.isOverwrite());
        this.logDebug("File operation '" + String.valueOf(message) + "' received.");
        FileDescriptor descriptor = this.files.get(message.getFilename());
        if (descriptor == null && message.getOperation() != SLFileMessage.FileOperation.EXISTS && message.getOperation() != SLFileMessage.FileOperation.IS_DIRECTORY && message.getOperation() != SLFileMessage.FileOperation.LIST_DIRECTORY && message.getOperation() != SLFileMessage.FileOperation.CREATE_DIRECTORY && message.getOperation() != SLFileMessage.FileOperation.REMOVE && message.getOperation() != SLFileMessage.FileOperation.COMPLETE && message.getOperation() != SLFileMessage.FileOperation.FILE_SYSTEM_GET_FILE_INFO && message.getOperation() != SLFileMessage.FileOperation.FILE_SYSTEM_LIST && message.getOperation() != SLFileMessage.FileOperation.FILE_SYSTEM_COPY && message.getOperation() != SLFileMessage.FileOperation.FILE_SYSTEM_MOVE && message.getOperation() != SLFileMessage.FileOperation.FILE_SYSTEM_RENAME && message.getOperation() != SLFileMessage.FileOperation.FILE_SYSTEM_SET_OWNER && message.getOperation() != SLFileMessage.FileOperation.FILE_SYSTEM_SET_PERMISSIONS && message.getOperation() != SLFileMessage.FileOperation.FILE_SYSTEM_CREATE_NEW_FILE) {
            descriptor = new FileDescriptor(message.getFilename(), message.getSLSessionName());
        }
        if (descriptor != null && !Utils.equalsNullSafe(descriptor.slSessionName, message.getSLSessionName())) {
            this.logDebug("Processing SL file message '" + String.valueOf(message) + "' failed.");
            String str = "File '" + message.getFilename() + "' locked by session '" + descriptor.slSessionName + "' but not '" + message.getSLSessionName() + "'. Close first session first.";
            Trace.logError(this, str);
            throw new IOException(str);
        }
        switch (message.getOperation()) {
            case OPEN_FOR_READ: {
                File file2 = new File(message.getFilename());
                if (!file2.exists()) {
                    throw new FileNotFoundException(message.getFilename());
                }
                descriptor.openInput(this.debug);
                this.files.put(descriptor.filename, descriptor);
                response.setLength(file2.length());
                message.setLengthTotal(response.getLength());
                this.raiseSLMessage(message);
                break;
            }
            case OPEN_FOR_WRITE: {
                descriptor.openOutput(this.debug);
                this.files.put(descriptor.filename, descriptor);
                this.raiseSLMessage(message);
                break;
            }
            case OPEN_FOR_APPEND: {
                File file3 = new File(message.getFilename());
                descriptor.openOutputForAppend(this.debug);
                this.files.put(descriptor.filename, descriptor);
                message.setLength(file3.length());
                this.raiseSLMessage(message);
                break;
            }
            case CREATE: {
                File file4 = new File(message.getFilename());
                if (file4.exists()) {
                    if (response.isOverwrite()) {
                        file4.delete();
                        if (file4.exists()) {
                            throw new IOException("Failed to overwrite file '" + message.getFilename() + "'.");
                        }
                    } else {
                        throw new IOException("File '" + message.getFilename() + "' already exists.");
                    }
                }
                this.logDebug("Creating file '" + descriptor.filename + "'...");
                new LocalFileSystem().createNewFile(file4.getAbsolutePath(), response.getPermissions());
                descriptor.openOutput(this.debug);
                this.files.put(descriptor.filename, descriptor);
                this.raiseSLMessage(message);
                break;
            }
            case READ: {
                if (descriptor.input == null) {
                    throw new IOException("File is not opened for reading.");
                }
                byte[] bytes = new byte[(int)message.getLength()];
                response.setLength(descriptor.input.read(bytes, 0, (int)message.getLength()));
                if (response.getLength() == -1L) {
                    bytes = null;
                } else if ((long)bytes.length > response.getLength()) {
                    bytes = Arrays.copyOfRange(bytes, 0, (int)response.getLength());
                }
                response.setBytes(bytes);
                message.setLength(response.getLength());
                if (message.getLength() == -1L) {
                    message.setLength(0L);
                }
                if (message.getLength() <= 0L) break;
                this.raiseSLMessage(message);
                break;
            }
            case WRITE: {
                if (descriptor.output == null) {
                    throw new IOException("File is not opened for writing.");
                }
                descriptor.output.write(message.getBytes(), 0, (int)message.getLength());
                descriptor.output.flush();
                response.setLength(message.getLength());
                if (message.getLength() <= 0L) break;
                this.raiseSLMessage(message);
                break;
            }
            case SKIP: {
                if (descriptor.input == null) {
                    throw new IOException("File is not opened for reading.");
                }
                response.setLength(descriptor.input.skip(message.getLength()));
                message.setLength(response.getLength());
                this.raiseSLMessage(message);
                break;
            }
            case AVAILABLE_FOR_READ: {
                if (descriptor.input == null) {
                    throw new IOException("File is not opened for reading.");
                }
                response.setLength(descriptor.input.available());
                break;
            }
            case CLOSE_READING: 
            case CLOSE_WRITING: {
                descriptor.close();
                this.files.remove(descriptor.filename);
                this.raiseSLMessage(message);
                break;
            }
            case EXISTS: {
                response.setLength(new File(response.getFilename()).exists() ? 1L : 0L);
                break;
            }
            case IS_DIRECTORY: {
                response.setLength(new File(response.getFilename()).isDirectory() ? 1L : 0L);
                break;
            }
            case LIST_DIRECTORY: {
                File dir = new File(response.getFilename());
                if (!dir.exists()) {
                    throw new FileNotFoundException(response.getFilename());
                }
                List<String> files = new ArrayList<String>();
                if (dir.isDirectory()) {
                    files = Arrays.stream(dir.list()).filter(file -> new File(response.getFilename(), (String)file).isFile()).collect(Collectors.toList());
                } else {
                    files.add(response.getFilename());
                }
                response.setFiles(files);
                break;
            }
            case FILE_SYSTEM_GET_FILE_INFO: {
                File filename = new File(response.getFilename());
                if (!filename.exists()) {
                    throw new FileNotFoundException(response.getFilename());
                }
                response.setFileInfos(new FileInfo[]{new LocalFileSystem().getInfo(filename.getAbsolutePath())});
                break;
            }
            case FILE_SYSTEM_LIST: {
                File filename = new File(response.getFilename());
                if (!filename.exists()) {
                    throw new FileNotFoundException(response.getFilename());
                }
                response.setFileInfos(new LocalFileSystem().list(filename.getAbsolutePath(), message.isRecursive()).toArray(new FileInfo[0]));
                break;
            }
            case FILE_SYSTEM_COPY: {
                new LocalFileSystem().copy(response.getFilename(), response.getDstFilename());
                break;
            }
            case FILE_SYSTEM_MOVE: {
                new LocalFileSystem().move(response.getFilename(), response.getDstFilename());
                break;
            }
            case FILE_SYSTEM_RENAME: {
                new LocalFileSystem().rename(response.getFilename(), response.getDstFilename());
                break;
            }
            case FILE_SYSTEM_SET_OWNER: {
                new LocalFileSystem().setOwner(response.getFilename(), response.getUsername(), response.getGroupname());
                break;
            }
            case FILE_SYSTEM_SET_PERMISSIONS: {
                new LocalFileSystem().setPermissions(response.getFilename(), response.getPermissions());
                break;
            }
            case FILE_SYSTEM_CREATE_NEW_FILE: {
                new LocalFileSystem().createNewFile(response.getFilename(), response.getPermissions());
                break;
            }
            case CREATE_DIRECTORY: {
                File file5 = new File(message.getFilename());
                if (file5.exists() && file5.isDirectory()) break;
                if (file5.exists() && !file5.isDirectory()) {
                    throw new IOException("File '" + message.getFilename() + "' already exists.");
                }
                this.logDebug("Creating directory '" + message.getFilename() + "'...");
                try {
                    new LocalFileSystem().mkdir(file5.getAbsolutePath(), message.getPermissions());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!file5.exists()) {
                    throw new IOException("Creating directory '" + message.getFilename() + "' failed.");
                }
                this.raiseSLMessage(message);
                break;
            }
            case REMOVE: {
                File file6 = new File(message.getFilename());
                if (!file6.exists()) break;
                this.logDebug("Removing file '" + message.getFilename() + "'...");
                new LocalFileSystem().delete(file6.getAbsolutePath(), message.isRecursive());
                if (file6.exists()) {
                    throw new IOException("Removing file '" + message.getFilename() + "' failed.");
                }
                this.raiseSLMessage(message);
                break;
            }
            case COMPLETE: {
                response.setDSLCompletion(new LocalPathCompleter().completePath(message.getFilename()));
            }
        }
        this.logDebug("Returning response '" + String.valueOf(response) + "'...");
        return response;
    }

    public void setSLMessageListener(SLMessageListener slMessageListener) {
        this.slMessageListener = slMessageListener;
    }

    public void addSLMessageListener(String name, SLMessageListener listener) {
        this.slMessageListeners.put(name, listener);
    }

    public void removeSLMessageListener(String name) {
        this.slMessageListeners.remove(name);
    }

    private void raiseSLMessage(SLFileMessage slFileMessage) {
        SLMessageListener listener;
        if (!slFileMessage.isVerbose()) {
            return;
        }
        if (slFileMessage.getSLSessionName() != null && (listener = this.slMessageListeners.get(slFileMessage.getSLSessionName())) != null) {
            listener.onMessage(slFileMessage);
        }
        if (this.slMessageListener != null) {
            this.slMessageListener.onMessage(slFileMessage);
        }
    }

    private void logDebug(String message) {
        SLFileMessageProcessor.logDebug(message, this.debug);
    }

    private static void logDebug(String message, boolean debug) {
        if (debug) {
            Trace.logDebug(SLFileMessageProcessor.class, message);
        }
    }

    private static class FileDescriptor {
        String filename;
        InputStream input;
        OutputStream output;
        String slSessionName;

        FileDescriptor(String filename, String slSessionName) {
            this.filename = filename;
            this.slSessionName = slSessionName;
        }

        void openInput(boolean debug) throws IOException {
            this.checkNotOpened();
            SLFileMessageProcessor.logDebug("Opening file " + this.filename + " for reading...", debug);
            this.input = new FileInputStream(this.filename);
        }

        void openOutput(boolean debug) throws IOException {
            this.checkNotOpened();
            SLFileMessageProcessor.logDebug("Opening file " + this.filename + " for writing...", debug);
            this.output = new FileOutputStream(this.filename);
        }

        void openOutputForAppend(boolean debug) throws IOException {
            this.checkNotOpened();
            SLFileMessageProcessor.logDebug("Opening file " + this.filename + " for append...", debug);
            this.output = new FileOutputStream(this.filename, true);
        }

        void checkNotOpened() throws IOException {
            if (this.input != null) {
                throw new IOException("File '" + this.filename + "' is already opened for reading.");
            }
            if (this.output != null) {
                throw new IOException("File '" + this.filename + "' is already opened for writing.");
            }
        }

        void closeInput() {
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (IOException exception) {
                Trace.logError(this, exception.getMessage());
            }
            this.input = null;
        }

        void closeOutput() {
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (IOException exception) {
                Trace.logError(this, exception.getMessage());
            }
            this.output = null;
        }

        void close() {
            this.closeInput();
            this.closeOutput();
        }
    }
}

