/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ClientState;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.dispatcher.SLFileMessageProcessor;
import java.io.FileNotFoundException;

public class SLFileMessageListener
implements FabricRequestListener {
    private SLFileMessageProcessor slFileMessageProcessor;
    private HTTPFabricConnection connection;

    public SLFileMessageListener(SLFileMessageProcessor slFileMessageProcessor) {
        this(slFileMessageProcessor, null);
    }

    public SLFileMessageListener(SLFileMessageProcessor slFileMessageProcessor, HTTPFabricConnection connection) {
        this.slFileMessageProcessor = slFileMessageProcessor;
        this.connection = connection;
    }

    @Override
    public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws FabricRequestException {
        if (event instanceof OpaqueDatagram) {
            try {
                SLFileMessage message = (SLFileMessage)((OpaqueDatagram)event).getData();
                SLFileMessage response = this.slFileMessageProcessor.process(message);
                return SLFileMessageListener.createSLFileMessageResponseEvent(this.connection, response);
            }
            catch (Exception exception) {
                if (!(exception instanceof FileNotFoundException)) {
                    Trace.logException(this, exception, true);
                }
                throw new FabricRequestException(exception);
            }
        }
        throw new FabricRequestException("Wrong event datagram '" + event.getClass().getSimpleName() + "' received (expected 'OpaqueDatagram').");
    }

    public static ImmutableEventDatagram createSLFileMessageResponseEvent(FabricConnection connection, SLFileMessage response) throws Exception {
        if (RuntimeState.isActive() || ClientState.isActive()) {
            return SDOUtils.createOpaqueEvent("e.sys.sl.FileMessage", response);
        }
        if (connection != null) {
            SemanticType semanticType = new SemanticType(OpaqueEvent.class.getSimpleName(), OpaqueEvent.class.getName());
            OpaqueEvent responseEvent = (OpaqueEvent)OpaqueDatagramFactory.getInstance().newEventInstance(semanticType);
            responseEvent.setEventId("e.sys.sl.FileMessage");
            responseEvent.setData(response);
            return responseEvent;
        }
        throw new Exception("Creation of event e.sys.sl.FileMessage failed.");
    }
}

