/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.operation.SLAudioMessage;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.dispatcher.ModeratorImpl;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.audio.SLAudioMessageRaiser;
import com.streamscape.slex.slang.SLMessageListener;
import java.io.IOException;

public class SLAudioMessageRaiserRemote
extends AbstractRuntimeFactory
implements SLAudioMessageRaiser {
    private RequestConsumerReference consumerReference;
    private String componentName;
    private String slSessionName;
    private MFSession mfSession;
    private SLMessageListener responseListener;

    public SLAudioMessageRaiserRemote(String componentName, String slSessionName, MFSession mfSession) {
        this.componentName = componentName;
        this.slSessionName = slSessionName;
        this.mfSession = mfSession;
    }

    public SLAudioMessageRaiserRemote(String componentName, SLMessageListener responseListener) {
        this.componentName = componentName;
        this.responseListener = responseListener;
    }

    @Override
    public void open() throws IOException {
        if (this.componentName == null) {
            throw new IOException("Component name is not set.");
        }
        try {
            if (this.consumerReference == null) {
                this.consumerReference = SLAudioMessageRaiserRemote.createRequestConsumerReference(this.componentName);
            }
        }
        catch (Exception exception) {
            throw new IOException("Opening SLAudioMessageRaiserRemote failed.", exception);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public SLAudioMessage raise(SLAudioMessage audioMessage, long timeout) throws IOException {
        try {
            audioMessage.setComponentName(this.componentName);
            audioMessage.setSLSessionName(this.slSessionName);
            if (this.mfSession != null) {
                audioMessage.setSessionName(this.mfSession.getName());
                audioMessage.setResourceName(this.mfSession.getResourceName());
            }
            audioMessage.setTimeout(timeout);
            OpaqueDatagram event = OpaqueDatagramFactory.getInstance().createEvent("e.sys.sl.AudioMessage");
            event.setData(audioMessage);
            event.setEventKey(this.componentName);
            ImmutableEventDatagram response = SLAudioMessageRaiserRemote.getConnection().raiseSystemRequest(this.consumerReference, event, timeout);
            if (response instanceof OpaqueDatagram) {
                SLAudioMessage message = (SLAudioMessage)((OpaqueDatagram)response).getData();
                if (this.responseListener != null) {
                    this.responseListener.onMessage(message);
                }
                return message;
            }
            throw new IOException("Wrong response received '" + response.getClass().getSimpleName() + "', but expected 'OpaqueDatagram'.");
        }
        catch (Exception exception) {
            if (!(exception instanceof FabricRequestException)) {
                Trace.logDebug(this, "Exception when raising SLAudioMessage.");
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logException(this, exception, true);
                }
            } else if (exception.getCause() instanceof IOException) {
                throw (IOException)exception.getCause();
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
    }

    public static RequestConsumerReference createRequestConsumerReference(String componentName) throws Exception {
        String consumerName = componentName + ":" + SLAudioMessage.getRequestConsumerName();
        RequestConsumerReference result = ((ModeratorImpl)SLAudioMessageRaiserRemote.getConnection().getModerator()).lookupRequestConsumer(consumerName, false);
        if (result == null) {
            throw new Exception("Consumer '" + consumerName + "' not found.");
        }
        return result;
    }

    private static AbstractFabricConnection getConnection() {
        return SLAudioMessageRaiserRemote.getContext().getSystemConnection();
    }
}

