/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.SLAudioMessage;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.SLAudioMessageProcessor;
import com.streamscape.slex.audio.SLAudioMessageRaiser;
import com.streamscape.slex.slang.SLMessageListener;
import java.io.IOException;

public class SLAudioMessageRaiserLocal
implements SLAudioMessageRaiser {
    private String componentName;
    private String slSessionName;
    private SLAudioMessageProcessor slAudioMessageProcessor;

    public SLAudioMessageRaiserLocal(final String componentName, final String slSessionName) {
        this.componentName = componentName;
        this.slSessionName = slSessionName;
        this.slAudioMessageProcessor = new SLAudioMessageProcessor();
        if (slSessionName != null) {
            this.slAudioMessageProcessor.setSLMessageListener(new SLMessageListener(){

                @Override
                public void onMessage(SLMessage message) {
                    if (message instanceof SLAudioMessage) {
                        message = new SLMessage(message.getText(), componentName, slSessionName);
                    }
                    try {
                        SLAudioMessageRaiserLocal.this.raiseSLMessage(message);
                    }
                    catch (FabricException exception) {
                        Trace.logException(this, exception, false);
                        Trace.logError(this, "Raising SL message '" + String.valueOf(message) + "' failed.");
                    }
                }
            });
        }
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() {
        this.slAudioMessageProcessor.close();
    }

    @Override
    public SLAudioMessage raise(SLAudioMessage message, long timeout) throws IOException {
        message.setComponentName(this.componentName);
        message.setSLSessionName(this.slSessionName);
        return this.slAudioMessageProcessor.process(message);
    }

    protected void raiseSLMessage(SLMessage message) throws FabricException {
        AbstractOperation.raiseSLMessage(message);
    }
}

