/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.SLAudioMessage;
import com.streamscape.slex.audio.AudioMicrophoneReader;
import com.streamscape.slex.slang.SLMessageListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SLAudioMessageProcessor {
    private SLMessageListener slMessageListener = null;
    private Map<String, SLMessageListener> slMessageListeners = new ConcurrentHashMap<String, SLMessageListener>();
    private Map<String, AudioMicrophoneReader> readers = new ConcurrentHashMap<String, AudioMicrophoneReader>();
    private boolean debug;

    public SLAudioMessageProcessor() {
        this(true);
    }

    SLAudioMessageProcessor(boolean debug) {
        this.debug = debug;
    }

    public synchronized void close() {
        this.logDebug("Close all readers...");
        for (AudioMicrophoneReader reader : this.readers.values()) {
            reader.stop();
        }
    }

    public synchronized void close(String slSessionName) {
        this.logDebug("Closing readers for session " + slSessionName);
        AudioMicrophoneReader reader = this.readers.remove(slSessionName);
        if (reader != null) {
            reader.stop();
        }
    }

    public synchronized SLAudioMessage process(SLAudioMessage message) throws IOException {
        SLAudioMessage response = new SLAudioMessage();
        response.setOperation(message.getOperation());
        response.setComponentName(message.getComponentName());
        response.setSLSessionName(message.getSLSessionName());
        response.setAudioFormat(message.getAudioFormat());
        if (message.getOperation() != SLAudioMessage.AudioOperation.READ) {
            this.logDebug("Audio operation '" + String.valueOf(message) + "' received.");
        }
        switch (message.getOperation()) {
            case OPEN_FOR_READ: {
                this.logDebug("Opening audio stream for session " + message.getSLSessionName() + " and format " + String.valueOf(message.getAudioFormat()));
                AudioMicrophoneReader reader = new AudioMicrophoneReader(message.getAudioFormat());
                reader.addListener(new SLAudioMicrophoneBytesListener());
                AudioMicrophoneReader oldReader = this.readers.put(message.getSLSessionName(), reader);
                if (oldReader != null) {
                    this.logDebug("There is already exist reader for session " + message.getSLSessionName() + " close it.");
                    oldReader.stop();
                }
                reader.start();
                break;
            }
            case READ: {
                AudioMicrophoneReader reader = this.readers.get(message.getSLSessionName());
                if (reader == null) {
                    throw new IOException("Audio stream is not opened in current session.");
                }
                if (!reader.isRunning()) {
                    throw new IOException("Audio stream is not started in current session.");
                }
                List<AudioMicrophoneReader.AudioMicrophoneBytesListener> listeners = reader.getListeners();
                if (listeners.size() == 0) {
                    throw new IOException("Audio stream doesn't have listeners.");
                }
                response.setBytes(((SLAudioMicrophoneBytesListener)listeners.get(0)).getBytes(message.getLength()));
                response.setLength(response.getBytes().length);
                break;
            }
            case CLOSE_READING: {
                this.close(message.getSLSessionName());
            }
        }
        if (message.getOperation() != SLAudioMessage.AudioOperation.READ) {
            this.logDebug("Returning response '" + String.valueOf(response) + "'...");
        }
        return response;
    }

    public void setSLMessageListener(SLMessageListener slMessageListener) {
        this.slMessageListener = slMessageListener;
    }

    public void addSLMessageListener(String name, SLMessageListener listener) {
        this.slMessageListeners.put(name, listener);
    }

    public void removeSLMessageListener(String name) {
        this.slMessageListeners.remove(name);
    }

    private void raiseSLMessage(SLAudioMessage slAudioMessage) {
        SLMessageListener listener;
        if (!slAudioMessage.isVerbose()) {
            return;
        }
        if (slAudioMessage.getSLSessionName() != null && (listener = this.slMessageListeners.get(slAudioMessage.getSLSessionName())) != null) {
            listener.onMessage(slAudioMessage);
        }
        if (this.slMessageListener != null) {
            this.slMessageListener.onMessage(slAudioMessage);
        }
    }

    private void logDebug(String message) {
        SLAudioMessageProcessor.logDebug(message, this.debug);
    }

    private static void logDebug(String message, boolean debug) {
        if (debug) {
            Trace.logInfo(SLAudioMessageProcessor.class, message);
        }
    }

    static class SLAudioMicrophoneBytesListener
    implements AudioMicrophoneReader.AudioMicrophoneBytesListener {
        private ByteArrayOutputStream stream = new ByteArrayOutputStream();
        private int bufferLengthInBytes;

        SLAudioMicrophoneBytesListener() {
        }

        @Override
        public synchronized void onBytes(byte[] bytes, int bufferLengthInBytes) throws IOException {
            this.bufferLengthInBytes = bufferLengthInBytes;
            this.stream.write(bytes);
        }

        public synchronized byte[] getBytes(int maxLength) {
            byte[] bytes = this.stream.toByteArray();
            this.stream.reset();
            if (bytes.length > maxLength) {
                int newLength = this.bufferLengthInBytes * (maxLength / this.bufferLengthInBytes);
                this.stream.write(bytes, newLength, bytes.length - newLength);
                bytes = Arrays.copyOf(bytes, newLength);
            }
            return bytes;
        }
    }
}

