/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ClientState;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.SLAudioMessage;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.dispatcher.SLAudioMessageProcessor;

public class SLAudioMessageListener
implements FabricRequestListener {
    private SLAudioMessageProcessor slAudioMessageProcessor;
    private HTTPFabricConnection connection;

    public SLAudioMessageListener(SLAudioMessageProcessor slAudioMessageProcessor) {
        this(slAudioMessageProcessor, null);
    }

    public SLAudioMessageListener(SLAudioMessageProcessor slAudioMessageProcessor, HTTPFabricConnection connection) {
        this.slAudioMessageProcessor = slAudioMessageProcessor;
        this.connection = connection;
    }

    @Override
    public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws FabricRequestException {
        if (event instanceof OpaqueDatagram) {
            try {
                SLAudioMessage message = (SLAudioMessage)((OpaqueDatagram)event).getData();
                SLAudioMessage response = this.slAudioMessageProcessor.process(message);
                return SLAudioMessageListener.createSLAudioMessageResponseEvent(this.connection, response);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                throw new FabricRequestException(exception);
            }
        }
        throw new FabricRequestException("Wrong event datagram '" + event.getClass().getSimpleName() + "' received (expected 'OpaqueDatagram').");
    }

    public static ImmutableEventDatagram createSLAudioMessageResponseEvent(FabricConnection connection, SLAudioMessage response) throws Exception {
        if (RuntimeState.isActive() || ClientState.isActive()) {
            return SDOUtils.createOpaqueEvent("e.sys.sl.AudioMessage", response);
        }
        if (connection != null) {
            SemanticType semanticType = new SemanticType(OpaqueEvent.class.getSimpleName(), OpaqueEvent.class.getName());
            OpaqueEvent responseEvent = (OpaqueEvent)OpaqueDatagramFactory.getInstance().newEventInstance(semanticType);
            responseEvent.setEventId("e.sys.sl.AudioMessage");
            responseEvent.setData(response);
            return responseEvent;
        }
        throw new Exception("Creation of event e.sys.sl.AudioMessage failed.");
    }
}

