/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.dispatcher.AbstractSemanticTypeFactory;
import com.streamscape.sef.utils.SemanticUtils;

class RuntimeSemanticTypeFactory
extends AbstractSemanticTypeFactory {
    RuntimeSemanticTypeFactory() {
    }

    @Override
    public void addSemanticType(SemanticType type) throws SemanticTypeFactoryException {
        this.doAddSemanticType(type, false, true);
        Trace.logInfo(this, "Semantic type [" + type.getTypeName() + "] registered.");
    }

    void doAddSemanticType(SemanticType semanticType, boolean force, boolean notify) throws SemanticTypeFactoryException {
        RuntimeContext runtimeContext = RuntimeSemanticTypeFactory.getRuntimeContext();
        if (notify && ((AbstractRuntimeContext)runtimeContext).isCoherenceAgentBound()) {
            try {
                runtimeContext.exchange.addSemanticType(this, semanticType, force);
            }
            catch (Exception exception) {
                if (exception instanceof SemanticTypeFactoryException) {
                    throw (SemanticTypeFactoryException)exception;
                }
                RuntimeSemanticTypeFactory.throwFactoryException(6011, "Unexpected exception.", exception);
            }
        } else {
            this.doAddSemanticTypeCore(semanticType, force);
        }
    }

    synchronized void doAddSemanticTypeCore(SemanticType type, boolean force) throws SemanticTypeFactoryException {
        this.checkOnAdd(type, force);
        if (type.isSystem()) {
            try {
                RuntimeSemanticTypeFactory.getRuntimeContext().omfManager.aliasManager.alias(type);
            }
            catch (FactoryManagerException exception) {
                RuntimeSemanticTypeFactory.throwFactoryException(exception.getErrorCode(), exception.getErrorMessage());
            }
        } else {
            try {
                SemanticObjectReferenceStore.beginXact();
                RuntimeSemanticTypeFactory.getRuntimeContext().getRepositoryContext().addSemanticType(type, false);
                SemanticObjectReferenceStore.commitXact();
            }
            catch (Throwable exception) {
                SemanticObjectReferenceStore.abortXactSafe();
                if (exception instanceof RepositoryException) {
                    if (exception.getCause() instanceof TFCacheException && ((RepositoryException)exception).getErrorCode() == 4002) {
                        exception = exception.getCause();
                    } else {
                        RuntimeSemanticTypeFactory.throwFactoryException(((RepositoryException)exception).getErrorCode(), exception);
                    }
                } else {
                    this.processException(exception);
                }
                RuntimeSemanticTypeFactory.throwFactoryException(4002, "Registering semantic type '" + type.getTypeName() + "' failed.", exception);
            }
        }
        if (RuntimeSemanticTypeFactory.getRuntimeContext().isDataspaceBound()) {
            RuntimeSemanticTypeFactory.getRuntimeContext().getDataspaceManager().addSemanticType(type);
        }
        if (Thread.currentThread().isInterrupted()) {
            RuntimeSemanticTypeFactory.throwFactoryException(6003, "Registering semantic type [" + type.getTypeName() + "] interrupted.");
        }
    }

    private void processException(Throwable exception) throws SemanticTypeFactoryException {
        while (!(exception instanceof DatagramFactoryException) && exception.getCause() != null) {
            exception = exception.getCause();
        }
        if (exception instanceof FactoryManagerException && ((FactoryManagerException)exception).getErrorCode() == 3026) {
            RuntimeSemanticTypeFactory.throwFactoryException(5015, exception);
        }
    }

    @Override
    public void removeSemanticType(String typeName, boolean force) throws SemanticTypeFactoryException {
        this.doRemoveSemanticType(typeName, force, true);
        Trace.logInfo(this, "Semantic type [" + typeName + "] unregistered.");
    }

    void doRemoveSemanticType(String typeName, boolean force, boolean notify) throws SemanticTypeFactoryException {
        RuntimeContext runtimeContext = RuntimeSemanticTypeFactory.getRuntimeContext();
        if (notify && ((AbstractRuntimeContext)runtimeContext).isCoherenceAgentBound()) {
            try {
                runtimeContext.exchange.removeSemanticType(this, typeName, force);
            }
            catch (Exception exception) {
                if (exception instanceof SemanticTypeFactoryException) {
                    throw (SemanticTypeFactoryException)exception;
                }
                RuntimeSemanticTypeFactory.throwFactoryException(6011, "Unexpected exception.", exception);
            }
        } else {
            this.doRemoveSemanticTypeCore(typeName, force, false);
        }
    }

    synchronized SemanticType doRemoveSemanticTypeCore(String typeName, boolean force, boolean noCheck) throws SemanticTypeFactoryException {
        SemanticType type = this.checkOnRemove(typeName, force, noCheck);
        if (type != null) {
            if (RuntimeSemanticTypeFactory.getRuntimeContext().isDataspaceBound()) {
                RuntimeSemanticTypeFactory.getRuntimeContext().getDataspaceManager().removeSemanticType(typeName);
            }
            try {
                SemanticObjectReferenceStore.beginXact();
                RuntimeSemanticTypeFactory.getRuntimeContext().getRepositoryContext().removeSemanticType(typeName, false, force);
                SemanticObjectReferenceStore.commitXact();
            }
            catch (Throwable exception) {
                SemanticObjectReferenceStore.abortXactSafe();
                if (exception instanceof RepositoryException) {
                    RuntimeSemanticTypeFactory.throwFactoryException(((RepositoryException)exception).getErrorCode(), exception);
                }
                RuntimeSemanticTypeFactory.throwFactoryException(4002, "Unregistering semantic type [" + typeName + "] failed.", exception);
            }
            try {
                RuntimeSemanticTypeFactory.getRuntimeContext().omfManager.aliasManager.unalias(typeName);
            }
            catch (FactoryManagerException exception) {
                RuntimeSemanticTypeFactory.throwFactoryException(exception.getErrorCode(), exception.getErrorMessage());
            }
            if (Thread.currentThread().isInterrupted()) {
                RuntimeSemanticTypeFactory.throwFactoryException(6003, "Unregistering semantic type [" + typeName + "] interrupted.");
            }
        }
        return type;
    }

    @Override
    public boolean hasDependencies(SemanticType type) {
        return RuntimeSemanticTypeFactory.getRuntimeContext().isCoherenceAgentBound() ? RuntimeSemanticTypeFactory.getRuntimeContext().exchange.hasDependenciesInSysplex(type) : SemanticUtils.hasDependencies(type, RuntimeSemanticTypeFactory.getRuntimeContext(), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized boolean updateSemanticType(SemanticType type) throws SemanticTypeFactoryException {
        SemanticType existingType = context.getSemanticTypeCache().lookupSemanticType(type.getTypeName());
        if (existingType != null) {
            if (existingType.equals(type)) return false;
            this.doUpdateSemanticType(type);
            if (!existingType.isValid() || type.isValid()) return true;
            Trace.logInfo(this, "WARNING: Semantic type [" + type.getTypeName() + "] invalidated (since it is invalid in Sysplex).");
            return true;
        } else {
            this.doAddSemanticTypeCore(type, true);
        }
        return true;
    }

    synchronized void doUpdateSemanticType(SemanticType type) throws SemanticTypeFactoryException {
        try {
            SemanticObjectReferenceStore.beginXact();
            RuntimeSemanticTypeFactory.getRuntimeContext().getRepositoryContext().updateSemanticType(type);
            SemanticObjectReferenceStore.commitXact();
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            if (exception instanceof RepositoryException) {
                RuntimeSemanticTypeFactory.throwFactoryException(((RepositoryException)exception).getErrorCode(), exception);
            }
            RuntimeSemanticTypeFactory.throwFactoryException(4002, "Updating semantic type [" + type.getTypeName() + "] failed.", exception);
        }
    }

    private static RuntimeContext getRuntimeContext() {
        return (RuntimeContext)context;
    }
}

