/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AbstractSecurityManagerProxy;
import com.streamscape.sef.dispatcher.SecurityManagerImpl;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.sef.security.UserState;
import java.util.List;
import java.util.Map;

class RuntimeSecurityManagerProxy
extends AbstractSecurityManagerProxy {
    SecurityManagerImpl managerImpl;

    RuntimeSecurityManagerProxy(SecurityManagerImpl managerImpl, String userName, String credentials, String key) throws SecurityManagerException {
        this(managerImpl, null);
        managerImpl.authenticate(userName, credentials, key);
    }

    RuntimeSecurityManagerProxy(SecurityManagerImpl managerImpl, AuthenticationType type, String userName, String credentials, Map<String, String> parameters, DigestCalculator calculator, AbstractFabricComponent component) throws SecurityManagerException {
        this(managerImpl, managerImpl.authenticate(type, userName, credentials, parameters, calculator, component));
    }

    RuntimeSecurityManagerProxy(SecurityManagerImpl managerImpl, User user, AbstractFabricComponent component) throws SecurityManagerException {
        this(managerImpl, user);
        this.managerImpl.bindSecurityContext(user, component);
    }

    RuntimeSecurityManagerProxy(SecurityManagerImpl managerImpl) {
        this(managerImpl, managerImpl.getAnonymousUser());
    }

    RuntimeSecurityManagerProxy(SecurityManagerImpl managerImpl, User user) {
        super(user, user != null ? managerImpl.getAnonymousUser() : null);
        this.managerImpl = managerImpl;
    }

    @Override
    public User createUser(String name, String password, String description, vCard vcard) throws SecurityManagerException {
        UserState state = null;
        if (this.currentUser != null && this.currentUser.isAnonymous()) {
            if (!this.managerImpl.getExchange().anonymousRegistration()) {
                throw new SecurityManagerException(6083, "Anonymous Registration is Currently Unavailable.");
            }
            state = this.managerImpl.getExchange().getAnonymousUser();
        }
        return (User)this.managerImpl.getExchange().updateSecurity(this, "doCreateUser", "doCreateUser", new Class[]{String.class, String.class, String.class, vCard.class, UserState.class}, new Object[]{name, password, description, vcard, state});
    }

    User doCreateUser(String name, String password, String description, vCard vcard, UserState state) throws SecurityManagerException {
        return this.managerImpl.createUser(this.currentUser, name, password, description, vcard, state);
    }

    @Override
    public void dropUser(String name) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doDropUser", "doDropUserNoCheck", name);
    }

    void doDropUser(String name) throws SecurityManagerException {
        this.managerImpl.dropUser(this.currentUser, name, true);
    }

    void doDropUserNoCheck(String name) throws SecurityManagerException {
        this.managerImpl.dropUser(this.currentUser, name, false);
    }

    @Override
    public void updateUser(User user) throws SecurityManagerException {
        this.doUpdateUser(this.currentUser, user);
    }

    void doUpdateUser(User actualUser, User user) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doUpdateUserCore", new Object[]{actualUser, user}, "doUpdateUser", user);
    }

    void doUpdateUserCore(User actualUser, User user) throws SecurityManagerException {
        this.managerImpl.updateUser(actualUser, user);
    }

    void doUpdateUser(User user) throws SecurityManagerException {
        this.managerImpl.doUpdateUser(user);
    }

    @Override
    public boolean existsUser(String name) {
        return this.managerImpl.existsUser(name);
    }

    @Override
    public User lookupUser(String name) {
        return this.managerImpl.lookupUser(name);
    }

    @Override
    public List<User> getUsers() {
        return this.managerImpl.getUsers();
    }

    @Override
    public List<String> listUsers() {
        return this.managerImpl.listUsers();
    }

    @Override
    public void addUserPermission(String userName, AccessControlOperation operation) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doAddUserPermission", "addUserPermission", new Object[]{userName, operation});
    }

    void doAddUserPermission(String userName, AccessControlOperation operation) throws SecurityManagerException {
        this.managerImpl.addUserPermission(this.currentUser, userName, operation);
    }

    @Override
    public void removeUserPermission(String userName, AccessControlOperation operation) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doRemoveUserPermission", "removeUserPermission", new Object[]{userName, operation});
    }

    void doRemoveUserPermission(String userName, AccessControlOperation operation) throws SecurityManagerException {
        this.managerImpl.removeUserPermission(this.currentUser, userName, operation);
    }

    @Override
    public void resetUserPermissions(String userName) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doResetUserPermissions", "resetUserPermissions", userName);
    }

    void doResetUserPermissions(String userName) throws SecurityManagerException {
        this.managerImpl.resetUserPermissions(this.currentUser, userName);
    }

    @Override
    public AccessControlList getUserPermissions(String userName) throws SecurityManagerException {
        return this.managerImpl.getUserPermissions(this.currentUser, userName);
    }

    @Override
    public void enableUser(String name) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doEnableUser", "enableUser", name);
    }

    void doEnableUser(String name) throws SecurityManagerException {
        this.managerImpl.enableUser(this.currentUser, name);
    }

    @Override
    public void disableUser(String name) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doDisableUser", "disableUser", name);
    }

    void doDisableUser(String name) throws SecurityManagerException {
        this.managerImpl.disableUser(this.currentUser, name);
    }

    @Override
    public vCard getVCard(String userName) throws SecurityManagerException {
        return this.managerImpl.getVCard(this.currentUser, userName);
    }

    @Override
    public void setVCard(String userName, vCard vcard) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doSetVCard", "doSetVCard", new Class[]{String.class, vCard.class}, new Object[]{userName, vcard});
    }

    void doSetVCard(String userName, vCard vcard) throws SecurityManagerException {
        this.managerImpl.setVCard(this.currentUser, userName, vcard);
    }

    @Override
    public Group createGroup(String name, String description) throws SecurityManagerException {
        return (Group)this.managerImpl.getExchange().updateSecurity(this, "doCreateGroup", "createGroup", name, description);
    }

    Group doCreateGroup(String name, String description) throws SecurityManagerException {
        return this.managerImpl.createGroup(this.currentUser, name, description);
    }

    @Override
    public void dropGroup(String name) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doDropGroup", "doDropGroupNoCheck", name);
    }

    void doDropGroup(String name) throws SecurityManagerException {
        this.managerImpl.dropGroup(this.currentUser, name, true);
    }

    void doDropGroupNoCheck(String name) throws SecurityManagerException {
        this.managerImpl.dropGroup(this.currentUser, name, false);
    }

    @Override
    public void updateGroup(Group group) throws SecurityManagerException {
        this.doUpdateGroup(this.currentUser, group);
    }

    void doUpdateGroup(User actualUser, Group group) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doUpdateGroupCore", new Object[]{actualUser, group}, "doUpdateGroup", group);
    }

    void doUpdateGroupCore(User actualUser, Group group) throws SecurityManagerException {
        this.managerImpl.updateGroup(actualUser, group);
    }

    void doUpdateGroup(Group group) throws SecurityManagerException {
        this.managerImpl.doUpdateGroup(group);
    }

    @Override
    public boolean existsGroup(String name) {
        return this.managerImpl.existsGroup(name);
    }

    @Override
    public Group lookupGroup(String name) {
        return this.managerImpl.lookupGroup(name);
    }

    @Override
    public List<Group> getGroups() {
        return this.managerImpl.getGroups();
    }

    @Override
    public List<String> listGroups() {
        return this.managerImpl.listGroups();
    }

    @Override
    public void addGroupPermission(String groupName, AccessControlOperation operation) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doAddGroupPermission", "addGroupPermission", new Object[]{groupName, operation});
    }

    void doAddGroupPermission(String groupName, AccessControlOperation operation) throws SecurityManagerException {
        this.managerImpl.addGroupPermission(this.currentUser, groupName, operation);
    }

    @Override
    public void removeGroupPermission(String groupName, AccessControlOperation operation) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doRemoveGroupPermission", "removeGroupPermission", new Object[]{groupName, operation});
    }

    @Override
    public AccessControlList getGroupPermissions(String groupName) throws SecurityManagerException {
        return this.managerImpl.getGroupPermissions(this.currentUser, groupName);
    }

    void doRemoveGroupPermission(String groupName, AccessControlOperation operation) throws SecurityManagerException {
        this.managerImpl.removeGroupPermission(this.currentUser, groupName, operation);
    }

    @Override
    public void addUserToGroup(String userName, String groupName) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doAddUserToGroup", "addUserToGroup", userName, groupName);
    }

    void doAddUserToGroup(String userName, String groupName) throws SecurityManagerException {
        this.managerImpl.addUserToGroup(this.currentUser, userName, groupName);
    }

    @Override
    public void removeUserFromGroup(String userName, String groupName) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doRemoveUserFromGroup", "removeUserFromGroup", userName, groupName);
    }

    void doRemoveUserFromGroup(String userName, String groupName) throws SecurityManagerException {
        this.managerImpl.removeUserFromGroup(this.currentUser, userName, groupName);
    }

    @Override
    public Organization createOrganization(String name, String description) throws SecurityManagerException {
        return (Organization)this.managerImpl.getExchange().updateSecurity(this, "doCreateOrganization", "createOrganization", name, description);
    }

    Organization doCreateOrganization(String name, String description) throws SecurityManagerException {
        return this.managerImpl.createOrganization(this.currentUser, name, description);
    }

    @Override
    public void dropOrganization(String name) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doDropOrganization", "dropOrganization", name);
    }

    void doDropOrganization(String name) throws SecurityManagerException {
        this.managerImpl.dropOrganization(this.currentUser, name);
    }

    @Override
    public void updateOrganization(Organization organization) throws SecurityManagerException {
        this.doUpdateOrganization(this.currentUser, organization);
    }

    void doUpdateOrganization(User actualUser, Organization organization) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doUpdateOrganizationCore", new Object[]{actualUser, organization}, "doUpdateOrganization", organization);
    }

    void doUpdateOrganizationCore(User actualUser, Organization organization) throws SecurityManagerException {
        this.managerImpl.updateOrganization(actualUser, organization);
    }

    void doUpdateOrganization(Organization organization) throws SecurityManagerException {
        this.managerImpl.doUpdateOrganization(organization);
    }

    @Override
    public boolean existsOrganization(String name) {
        return this.managerImpl.existsOrganization(name);
    }

    @Override
    public Organization lookupOrganization(String name) {
        return this.managerImpl.lookupOrganization(name);
    }

    @Override
    public List<Organization> getOrganizations() {
        return this.managerImpl.getOrganizations();
    }

    @Override
    public List<String> listOrganizations() {
        return this.managerImpl.listOrganizations();
    }

    @Override
    public void setOrganizationDomain(String organizationName, String domain) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doSetOrganizationDomain", "setOrganizationDomain", organizationName, domain);
    }

    void doSetOrganizationDomain(String organizationName, String domain) throws SecurityManagerException {
        this.managerImpl.setOrganizationDomain(this.currentUser, organizationName, domain);
    }

    @Override
    public void setUserOrganization(String userName, String organizationName) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doSetUserOrganization", "setUserOrganization", userName, organizationName);
    }

    void doSetUserOrganization(String userName, String organizationName) throws SecurityManagerException {
        this.managerImpl.setUserOrganization(this.currentUser, userName, organizationName);
    }

    @Override
    public void setGroupOrganization(String groupName, String organizationName) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doSetGroupOrganization", "setGroupOrganization", groupName, organizationName);
    }

    void doSetGroupOrganization(String groupName, String organizationName) throws SecurityManagerException {
        this.managerImpl.setGroupOrganization(this.currentUser, groupName, organizationName);
    }

    @Override
    public String resetPassword(String userName) throws SecurityManagerException {
        return (String)this.managerImpl.getExchange().updateSecurity(this, "doResetPassword", new Object[]{userName}, "setPassword", userName, null);
    }

    String doResetPassword(String userName) throws SecurityManagerException {
        return this.managerImpl.resetPassword(this.currentUser, userName);
    }

    @Override
    public void changePassword(String userName, String oldPassword, String newPassword) throws SecurityManagerException {
        this.doChangePassword(this.currentUser, userName, oldPassword, newPassword);
    }

    void doChangePassword(User actualUser, String userName, String oldPassword, String newPassword) throws SecurityManagerException {
        this.managerImpl.getExchange().updateSecurity(this, "doChangePasswordCore", new Object[]{actualUser, userName, oldPassword, newPassword}, "setPassword", userName, newPassword);
    }

    void doChangePasswordCore(User actualUser, String userName, String oldPassword, String newPassword) throws SecurityManagerException {
        this.managerImpl.changePassword(actualUser, userName, oldPassword, newPassword);
    }

    void setPassword(String userName, String password) throws SecurityManagerException {
        this.managerImpl.setPassword(userName, password);
    }

    @Override
    public List<ComponentReference> listBoundComponents(String ownerName, boolean inSysplex) throws SecurityManagerException {
        return this.managerImpl.listBoundComponents(ownerName, inSysplex);
    }
}

