/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.filesystem.FSFile;
import com.streamscape.repository.object.Binding;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.sys.SysId;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractRepositoryAccessor;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.transports.TransportFactory;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

class RuntimeRepositoryAccessorImpl
extends AbstractRepositoryAccessor {
    private RuntimeContext runtimeContext;
    private RepositoryContext repositoryContext;
    private String oldUserName;

    RuntimeRepositoryAccessorImpl(AbstractFabricConnection connection, FabricNodeReference node, RuntimeContext runtimeContext) throws RuntimeContextException {
        this(connection, connection.getCurrentUserName(), node, runtimeContext);
    }

    RuntimeRepositoryAccessorImpl(AbstractFabricConnection connection, String userName, FabricNodeReference node, RuntimeContext runtimeContext) {
        super(connection, userName, node);
        this.runtimeContext = runtimeContext;
        this.repositoryContext = runtimeContext.getRepositoryContext();
    }

    @Override
    public SysId getSystemId() throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.getSystemId();
    }

    @Override
    public String getProviderClass() throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.getProviderClass();
    }

    @Override
    public String getVendor() throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.getVendorString();
    }

    @Override
    public String getInstallRoot() throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.getInstallRoot();
    }

    @Override
    public boolean isTypeResolutionCapable() throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.isTypeResolutionCapable();
    }

    @Override
    public boolean isObjectReferenceCapable() throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.isObjectReferenceCapable();
    }

    @Override
    public boolean isGlobalsCapable() throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.isGlobalsCapable();
    }

    @Override
    public boolean isTransactionCapable() throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.isTransactionCapable();
    }

    @Override
    public Map<String, Object> getEnvironment() throws RepositoryAccessorException {
        this.checkOpened();
        return (HashMap)this.repositoryContext.getEnvironment().clone();
    }

    @Override
    public Object addEnvironmentVariable(String name, Object value) throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.addToEnvironment(name, value);
    }

    @Override
    public Object removeEnvironmentVariable(String name) throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.removeFromEnvironment(name);
    }

    @Override
    public synchronized boolean inXact() throws RepositoryAccessorException {
        this.checkOpened();
        return this.repositoryContext.inXact();
    }

    @Override
    public FSFile getRootDirectory() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getRootDirectory();
    }

    @Override
    public void createDirectory(FSFile baseDirectory, String subDirectoryName) throws RepositoryAccessorException, RepositoryException {
        this.createDirectory(this.userName, baseDirectory, subDirectoryName);
    }

    void createDirectory(String userName, FSFile baseDirectory, String subDirectoryName) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("createDirectory", userName, new Class[]{FSFile.class, String.class}, baseDirectory, subDirectoryName);
    }

    @Override
    public FSFile createDirectory(String path) throws RepositoryAccessorException, RepositoryException {
        return this.createDirectory(this.userName, path);
    }

    FSFile createDirectory(String userName, String path) throws RepositoryAccessorException, RepositoryException {
        return (FSFile)this.invokeOperation1("createDirectory", userName, new Class[]{String.class}, path);
    }

    @Override
    public void createFile(String path, byte[] content, long expiration) throws RepositoryAccessorException, RepositoryException {
        this.createFile(this.userName, path, content, expiration);
    }

    void createFile(String userName, String path, byte[] content, long expiration) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("createFile", userName, new Class[]{String.class, byte[].class, Long.TYPE}, path, content, expiration);
    }

    @Override
    public void createFile(String path, File contentFile, long expiration) throws RepositoryAccessorException, RepositoryException {
        this.createFile(this.userName, path, contentFile, expiration);
    }

    void createFile(String userName, String path, File contentFile, long expiration) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("createFile", userName, new Class[]{String.class, File.class, Long.TYPE}, path, contentFile, expiration);
    }

    @Override
    public void createFile(String path, InputStream stream, int size, long expiration) throws RepositoryAccessorException, RepositoryException {
        this.createFile(this.userName, path, stream, size, expiration);
    }

    void createFile(String userName, String path, InputStream stream, int size, long expiration) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("createFile", userName, new Class[]{String.class, InputStream.class, Integer.TYPE, Long.TYPE}, path, stream, size, expiration);
    }

    @Override
    public void deleteDirectory(String path, boolean isRecursive) throws RepositoryAccessorException, RepositoryException {
        this.deleteDirectory(this.userName, path, isRecursive);
    }

    void deleteDirectory(String userName, String path, boolean isRecursive) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("deleteDirectory", userName, new Class[]{String.class, Boolean.TYPE}, path, isRecursive);
    }

    @Override
    public void deleteFile(String path) throws RepositoryAccessorException, RepositoryException {
        this.deleteFile(this.userName, path);
    }

    void deleteFile(String userName, String path) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("deleteFile", userName, new Class[]{String.class}, path);
    }

    @Override
    public boolean existsFile(String path) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.exists(path);
    }

    @Override
    public String getFileContent(String path) throws RepositoryAccessorException, RepositoryException {
        return this.getFileContent(this.userName, path);
    }

    String getFileContent(String userName, String path) throws RepositoryAccessorException, RepositoryException {
        return (String)this.invokeOperation1("getContent", userName, new Class[]{String.class}, path);
    }

    @Override
    public byte[] getFileContentBytes(String path) throws RepositoryAccessorException, RepositoryException {
        return this.getFileContentBytes(this.userName, path);
    }

    byte[] getFileContentBytes(String userName, String path) throws RepositoryAccessorException, RepositoryException {
        return (byte[])this.invokeOperation1("getContentBytes", userName, new Class[]{String.class}, path);
    }

    @Override
    public void getFileContent(String path, OutputStream stream) throws RepositoryAccessorException, RepositoryException {
        this.getFileContent(this.userName, path, stream);
    }

    void getFileContent(String userName, String path, OutputStream stream) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("getContent", userName, new Class[]{String.class, OutputStream.class}, path, stream);
    }

    @Override
    public FSFile getDetails(String path) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getDetails(path);
    }

    @Override
    public List<FSFile> getDetails(Collection<String> paths) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getDetails(paths);
    }

    @Override
    public boolean isDirectory(String path) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.isDirectory(path);
    }

    @Override
    public boolean isFile(String path) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.isFile(path);
    }

    @Override
    public List<String> listFiles(String path) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listFiles(path);
    }

    @Override
    public List<String> listDirectories(String path) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listDirectories(path);
    }

    @Override
    public List<String> listAllArtifacts(String path) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listAll(path);
    }

    @Override
    public List<FSFile> getFilesDetails(String path) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getFilesDetails(path);
    }

    @Override
    public List<FSFile> getDirectoriesDetails(String path) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getDirectoriesDetails(path);
    }

    @Override
    public List<FSFile> getAllArtifactsDetails(String path) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getAllDetails(path);
    }

    @Override
    public FSFile renameArtifact(FSFile oldFile, String newName) throws RepositoryAccessorException, RepositoryException {
        return this.renameArtifact(this.userName, oldFile, newName);
    }

    FSFile renameArtifact(String userName, FSFile oldFile, String newName) throws RepositoryAccessorException, RepositoryException {
        return (FSFile)this.invokeOperation1("renameArtifact", userName, new Class[]{FSFile.class, String.class}, oldFile, newName);
    }

    @Override
    public void renameArtifact(String oldPath, String newName) throws RepositoryAccessorException, RepositoryException {
        this.renameArtifact(this.userName, oldPath, newName);
    }

    void renameArtifact(String userName, String oldPath, String newName) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("renameArtifact", userName, new Class[]{String.class, String.class}, oldPath, newName);
    }

    @Override
    public void updateFile(String path, byte[] content) throws RepositoryAccessorException, RepositoryException {
        this.updateFile(this.userName, path, content);
    }

    void updateFile(String userName, String path, byte[] content) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("updateFile", userName, new Class[]{String.class, byte[].class}, path, content);
    }

    @Override
    public void updateFile(String path, File contentFile) throws RepositoryAccessorException, RepositoryException {
        this.updateFile(this.userName, path, contentFile);
    }

    void updateFile(String userName, String path, File contentFile) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("updateFile", userName, new Class[]{String.class, File.class}, path, contentFile);
    }

    @Override
    public void updateFile(String path, InputStream stream, int size) throws RepositoryAccessorException, RepositoryException {
        this.updateFile(this.userName, path, stream, size);
    }

    void updateFile(String userName, String path, InputStream stream, int size) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("updateFile", userName, new Class[]{String.class, InputStream.class, Integer.TYPE}, path, stream, size);
    }

    @Override
    public void setFileExpiration(String path, long expiration) throws RepositoryAccessorException, RepositoryException {
        this.setFileExpiration(this.userName, path, expiration);
    }

    void setFileExpiration(String userName, String path, long expiration) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("setFileExpiration", userName, new Class[]{String.class, Long.TYPE}, path, expiration);
    }

    @Override
    public void appendFile(String path, byte[] content) throws RepositoryAccessorException, RepositoryException {
        this.appendFile(this.userName, path, content);
    }

    void appendFile(String userName, String path, byte[] content) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("appendFile", userName, new Class[]{String.class, byte[].class}, path, content);
    }

    @Override
    public void appendFile(String path, File contentFile) throws RepositoryAccessorException, RepositoryException {
        this.appendFile(this.userName, path, contentFile);
    }

    void appendFile(String userName, String path, File contentFile) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("appendFile", userName, new Class[]{String.class, File.class}, path, contentFile);
    }

    @Override
    public void appendFile(String path, InputStream stream, int size) throws RepositoryAccessorException, RepositoryException {
        this.appendFile(this.userName, path, stream, size);
    }

    void appendFile(String userName, String path, InputStream stream, int size) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("appendFile", userName, new Class[]{String.class, InputStream.class, Integer.TYPE}, path, stream, size);
    }

    @Override
    public void saveServiceConfiguration(ServiceConfigurationObject sco) throws RepositoryAccessorException, RepositoryException {
        this.saveServiceConfiguration(this.userName, sco);
    }

    void saveServiceConfiguration(String userName, ServiceConfigurationObject sco) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("saveServiceConfiguration", userName, new Class[]{ServiceConfigurationObject.class}, sco);
    }

    @Override
    public ServiceConfigurationObject loadServiceConfiguration(String serviceName, String serviceType) throws RepositoryAccessorException, RepositoryException {
        return this.loadServiceConfiguration(this.userName, serviceName, serviceType);
    }

    ServiceConfigurationObject loadServiceConfiguration(String userName, String serviceName, String serviceType) throws RepositoryAccessorException, RepositoryException {
        return (ServiceConfigurationObject)this.invokeOperation1("loadServiceConfiguration", userName, new Class[]{String.class, String.class}, serviceName, serviceType);
    }

    @Override
    public void removeServiceConfiguration(String serviceName, String serviceType) throws RepositoryAccessorException, RepositoryException {
        this.removeServiceConfiguration(this.userName, serviceName, serviceType);
    }

    void removeServiceConfiguration(String userName, String serviceName, String serviceType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("removeService", userName, new Class[]{String.class, String.class}, serviceName, serviceType);
    }

    @Override
    public boolean existsServiceConfiguration(String serviceName, String serviceType) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.existsService(serviceName, serviceType);
    }

    @Override
    public List<String> listServiceTypes() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listServiceTypes();
    }

    @Override
    public List<String> listServiceNames() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listServiceNames();
    }

    @Override
    public List<String> listServicesByType(String serviceType) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listServicesByType(serviceType);
    }

    @Override
    public void importServiceConfiguration(String directory, String serviceName, String serviceType, boolean validate) throws RepositoryAccessorException, RepositoryException {
        this.importServiceConfiguration(this.userName, directory, serviceName, serviceType, validate);
    }

    void importServiceConfiguration(String userName, String directory, String serviceName, String serviceType, boolean validate) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("importServiceConfigurationArtifact", userName, new Class[]{String.class, String.class, String.class, Boolean.TYPE}, directory, serviceName, serviceType, validate);
    }

    @Override
    public void exportServiceConfiguration(String directory, String serviceName, String serviceType) throws RepositoryAccessorException, RepositoryException {
        this.exportServiceConfiguration(this.userName, directory, serviceName, serviceType);
    }

    void exportServiceConfiguration(String userName, String directory, String serviceName, String serviceType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("exportServiceConfigurationArtifact", userName, new Class[]{String.class, String.class, String.class}, directory, serviceName, serviceType);
    }

    @Override
    public String resolveSemanticType(String typeName) throws RepositoryAccessorException, RepositoryException {
        return this.resolveSemanticType(this.userName, typeName);
    }

    String resolveSemanticType(String userName, String typeName) throws RepositoryAccessorException, RepositoryException {
        return (String)this.invokeOperation1("resolveSemanticType", userName, new Class[]{String.class}, typeName);
    }

    @Override
    public String resolveSemanticClass(String className) throws RepositoryAccessorException, RepositoryException {
        return this.resolveSemanticClass(this.userName, className);
    }

    String resolveSemanticClass(String userName, String className) throws RepositoryAccessorException, RepositoryException {
        return (String)this.invokeOperation1("resolveClass", userName, new Class[]{String.class}, className);
    }

    @Override
    public SemanticType getSemanticType(String typeName) throws RepositoryAccessorException, RepositoryException {
        return this.getSemanticType(this.userName, typeName);
    }

    SemanticType getSemanticType(String userName, String typeName) throws RepositoryAccessorException, RepositoryException {
        return (SemanticType)this.invokeOperation1("getSemanticType", userName, new Class[]{String.class}, typeName);
    }

    @Override
    public boolean existsSemanticType(String typeName) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.existsSemanticType(typeName);
    }

    @Override
    public List<String> listSemanticTypes() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listSemanticTypes(false);
    }

    @Override
    public List<SemanticType> getSemanticTypes() throws RepositoryAccessorException, RepositoryException {
        return this.getSemanticTypes(this.userName);
    }

    List<SemanticType> getSemanticTypes(String userName) throws RepositoryAccessorException, RepositoryException {
        return (List)this.invokeOperation1("getSemanticTypes", userName, new Class[]{Boolean.TYPE}, false);
    }

    @Override
    public ReferenceContext getRootContext() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getRootContext();
    }

    @Override
    public ReferenceContext createReferenceContext(String namespace) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.createReferenceContext(this.userName, namespace);
    }

    ReferenceContext createReferenceContext(String userName, String namespace) throws RepositoryAccessorException, NamingException, RepositoryException {
        return (ReferenceContext)this.invokeOperation2("createSubcontext", userName, new Class[]{String.class}, namespace);
    }

    @Override
    public ReferenceContext createReferenceContext(ReferenceContext parentContext, String namespace) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.createReferenceContext(this.userName, parentContext, namespace);
    }

    ReferenceContext createReferenceContext(String userName, ReferenceContext parentContext, String namespace) throws RepositoryAccessorException, NamingException, RepositoryException {
        return (ReferenceContext)this.invokeOperation2("createSubcontext", userName, new Class[]{ReferenceContext.class, String.class}, parentContext, namespace);
    }

    @Override
    public void destroyReferenceContext(ReferenceContext context) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.destroyReferenceContext(this.userName, context);
    }

    void destroyReferenceContext(String userName, ReferenceContext context) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.invokeOperation2("destroySubcontext", userName, new Class[]{ReferenceContext.class}, context);
    }

    @Override
    public void setReferenceContext(ReferenceContext context) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.setReferenceContext(this.userName, context);
    }

    @Override
    public void resetReferenceContext() throws RepositoryAccessorException, NamingException, RepositoryException {
        this.setReferenceContext(ReferenceContext.ROOT);
    }

    void setReferenceContext(String userName, ReferenceContext context) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.invokeOperation2("setReferenceContext", userName, new Class[]{ReferenceContext.class}, context);
    }

    @Override
    public ReferenceContext getReferenceContext() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getReferenceContext();
    }

    @Override
    public ReferenceContext lookupReferenceContext(String namespace) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.lookupReferenceContext(namespace);
    }

    @Override
    public boolean existsReferenceContext(String namespace) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.existsReferenceContext(namespace);
    }

    @Override
    public List<String> listReferenceContexts() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listSubcontexts();
    }

    @Override
    public void bindObject(String name, Object object) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.bindObject(this.userName, name, object);
    }

    void bindObject(String userName, String name, Object object) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.invokeOperation2("bind", userName, new Class[]{String.class, Object.class}, name, object);
    }

    @Override
    public void rebindObject(String name, Object object) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.rebindObject(this.userName, name, object);
    }

    void rebindObject(String userName, String name, Object object) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.invokeOperation2("rebind", userName, new Class[]{String.class, Object.class}, name, object);
    }

    @Override
    public void unbindObject(String name) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.unbindObject(this.userName, name);
    }

    void unbindObject(String userName, String name) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.invokeOperation2("unbind", userName, new Class[]{String.class}, name);
    }

    @Override
    public void renameObject(String oldName, String newName) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.renameObject(this.userName, oldName, newName);
    }

    void renameObject(String userName, String oldName, String newName) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.invokeOperation2("rename", userName, new Class[]{String.class, String.class}, oldName, newName);
    }

    @Override
    public Object lookupObject(String name) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.doLookupObject(this.userName, name);
    }

    Object doLookupObject(String userName, String name) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.invokeOperation2("lookup", userName, new Class[]{String.class}, name);
    }

    @Override
    public Object lookupObject(String namespace, String objectName) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.doLookupObject(this.userName, namespace, objectName);
    }

    Object doLookupObject(String userName, String namespace, String objectName) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.invokeOperation2("lookup", userName, new Class[]{String.class, String.class}, namespace, objectName);
    }

    @Override
    public Object lookupObject(ReferenceContext context, String objectName) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.doLookupObject(this.userName, context, objectName);
    }

    Object doLookupObject(String userName, ReferenceContext context, String objectName) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.invokeOperation2("lookup", userName, new Class[]{ReferenceContext.class, String.class}, context, objectName);
    }

    @Override
    public boolean existsObject(String name) throws RepositoryAccessorException, NamingException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.existsBinding(name);
    }

    @Override
    public List<String> listQualifiedObjectNames() throws RepositoryAccessorException, NamingException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listQualifiedBoundNames();
    }

    @Override
    public List<String> listQualifiedObjectNames(ReferenceContext context) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.listQualifiedObjectNames(this.userName, context);
    }

    List<String> listQualifiedObjectNames(String userName, ReferenceContext context) throws RepositoryAccessorException, NamingException, RepositoryException {
        return (List)this.invokeOperation2("listQualifiedBoundNames", userName, new Class[]{ReferenceContext.class}, context);
    }

    @Override
    public List<String> listObjectNames(String objectType) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listBoundNames(objectType);
    }

    @Override
    public List<String> listObjectNames(ReferenceContext context, String objectType) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.listObjectNames(this.userName, context, objectType);
    }

    List<String> listObjectNames(String userName, ReferenceContext context, String objectType) throws RepositoryAccessorException, NamingException, RepositoryException {
        return (List)this.invokeOperation2("listBoundNames", userName, new Class[]{ReferenceContext.class, String.class}, context, objectType);
    }

    @Override
    public List<Binding> listBindings() throws RepositoryAccessorException, RepositoryException {
        return this.listBindings(this.userName);
    }

    List<Binding> listBindings(String userName) throws RepositoryAccessorException, RepositoryException {
        return (List)this.invokeOperation1("listBindings", userName, null, new Object[0]);
    }

    @Override
    public List<Binding> listBindings(ReferenceContext context) throws RepositoryAccessorException, NamingException, RepositoryException {
        return this.listBindings(this.userName, context);
    }

    List<Binding> listBindings(String userName, ReferenceContext context) throws RepositoryAccessorException, NamingException, RepositoryException {
        return (List)this.invokeOperation2("listBindings", userName, new Class[]{ReferenceContext.class}, context);
    }

    @Override
    public void addPackage(Package pkg) throws RepositoryAccessorException, RepositoryException {
        this.addPackage(this.userName, pkg);
    }

    void addPackage(String userName, Package pkg) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("savePackage", userName, new Class[]{Package.class}, pkg);
    }

    @Override
    public void addPackage(Package pkg, File[] jars) throws RepositoryAccessorException, RepositoryException {
        this.addPackage(this.userName, pkg, jars);
    }

    void addPackage(String userName, Package pkg, File[] jars) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("savePackage", userName, new Class[]{Package.class, File[].class}, pkg, jars);
    }

    @Override
    public Package getPackage(PackageType type, String name) throws RepositoryAccessorException, RepositoryException {
        return this.getPackage(this.userName, type, name);
    }

    Package getPackage(String userName, PackageType type, String name) throws RepositoryAccessorException, RepositoryException {
        return (Package)this.invokeOperation1("loadPackage", userName, new Class[]{PackageType.class, String.class}, new Object[]{type, name});
    }

    @Override
    public Package getPackageByArchive(String jarName) throws RepositoryAccessorException, RepositoryException {
        return this.getPackageByArchive(this.userName, jarName);
    }

    Package getPackageByArchive(String userName, String jarName) throws RepositoryAccessorException, RepositoryException {
        return (Package)this.invokeOperation1("getPackageByArchive", userName, new Class[]{String.class}, jarName);
    }

    @Override
    public void removePackage(PackageType type, String name, boolean withJars) throws RepositoryAccessorException, RepositoryException {
        this.removePackage(this.userName, type, name, withJars);
    }

    public void removePackageForced(Package pkg) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("removePackageForced", this.userName, new Class[]{Package.class}, pkg);
    }

    void removePackage(String userName, PackageType type, String name, boolean withJars) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("removePackage", userName, new Class[]{PackageType.class, String.class, Boolean.TYPE}, new Object[]{type, name, withJars});
    }

    @Override
    public boolean existsPackage(PackageType type, String name) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.existsPackage(type, name);
    }

    @Override
    public void updatePackage(Package pkg) throws RepositoryAccessorException, RepositoryException {
        this.updatePackage(this.userName, pkg);
    }

    void updatePackage(String userName, Package pkg) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("updatePackage", userName, new Class[]{Package.class}, pkg);
    }

    void updatePackageForced(Package pkg) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("updatePackageForced", this.userName, new Class[]{Package.class}, pkg);
    }

    @Override
    public void importPackage(String workingDir, PackageType type, String name) throws RepositoryAccessorException, RepositoryException {
        this.importPackage(this.userName, workingDir, type, name);
    }

    void importPackage(String userName, String workingDir, PackageType type, String name) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("importPackage", userName, new Class[]{String.class, PackageType.class, String.class}, new Object[]{workingDir, type, name});
    }

    @Override
    public void exportPackage(String workingDir, PackageType type, String name) throws RepositoryAccessorException, RepositoryException {
        this.exportPackage(this.userName, workingDir, type, name);
    }

    void exportPackage(String userName, String workingDir, PackageType type, String name) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("exportPackage", userName, new Class[]{String.class, PackageType.class, String.class}, new Object[]{workingDir, type, name});
    }

    @Override
    public List<String> listPackages() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listPackages();
    }

    @Override
    public List<String> listPackagesByType(PackageType type) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listPackagesByType(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doAddArchive(String jarName, byte[] jarContent, AddArchiveMethod addMethod) throws RepositoryAccessorException, RepositoryException {
        File tmpDir = null;
        try {
            tmpDir = FileIOUtils.createTempDir(new File(this.runtimeContext.getStartupDir()));
            FileIOUtils.putFile(tmpDir.getPath(), jarName, jarContent);
            addMethod.execute(new File(tmpDir, jarName));
            if (tmpDir == null) return;
        }
        catch (UtilitiesException exception) {
            try {
                throw new RepositoryAccessorException(6025, "Saving archive to temporary directory failed.", exception);
            }
            catch (Throwable throwable) {
                if (tmpDir == null) throw throwable;
                FileIOUtils.deleteFileDir(tmpDir);
                throw throwable;
            }
        }
        FileIOUtils.deleteFileDir(tmpDir);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddArchiveFromTempDir(File tmpDir, String jarName, AddArchiveMethod addMethod) throws RepositoryAccessorException, RepositoryException {
        try {
            addMethod.execute(new File(tmpDir, jarName));
        }
        finally {
            FileIOUtils.deleteFileDir(tmpDir);
        }
    }

    void doAddArchive(File jarDir, String jarName) throws RepositoryAccessorException, RepositoryException {
        this.doAddArchiveFromTempDir(jarDir, jarName, this::doAddArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doAddArchives(File jarDir, List<String> jars) throws RepositoryAccessorException, RepositoryException {
        if (jarDir != null) {
            try {
                for (String jarName : jars) {
                    this.doAddArchiveForced(new File(jarDir, jarName));
                }
            }
            finally {
                FileIOUtils.deleteFileDir(jarDir);
            }
        }
    }

    void doAddArchiveForced(File jar) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("addArchiveForced", this.userName, new Class[]{File.class}, jar);
    }

    void doAddArchive(File jar) throws RepositoryAccessorException, RepositoryException {
        this.doAddArchiveCore(this.userName, jar);
    }

    @Override
    public void addArchive(File jar) throws RepositoryAccessorException, RepositoryException {
        this.addArchive(this.userName, jar);
    }

    @Override
    public void addArchive(String jarName, byte[] jarContent) throws RepositoryAccessorException, RepositoryException {
        this.doAddArchive(jarName, jarContent, jar -> this.addArchive(this.userName, jar));
    }

    void addArchive(String userName, String jarName, byte[] jarContent) throws RepositoryAccessorException, RepositoryException {
        this.doAddArchive(jarName, jarContent, jar -> this.addArchive(userName, jar));
    }

    void addArchive(String userName, File jar) throws RepositoryAccessorException, RepositoryException {
        if (this.runtimeContext.isCoherenceAgentBound()) {
            try {
                this.runtimeContext.exchange.addJar(this, userName, jar.getCanonicalFile());
            }
            catch (Exception exception) {
                if (exception instanceof RepositoryAccessorException) {
                    throw (RepositoryAccessorException)exception;
                }
                if (exception instanceof RepositoryException) {
                    throw (RepositoryException)exception;
                }
                throw new RepositoryAccessorException(6011, "Unexpected exception.", exception);
            }
        } else {
            this.doAddArchiveCore(userName, jar);
        }
    }

    synchronized Package doAddArchiveCore(String userName, File jar) throws RepositoryAccessorException, RepositoryException {
        return (Package)this.invokeOperation1("addArchive", userName, new Class[]{File.class}, jar);
    }

    void doRemoveArchive(String jarName) throws RepositoryAccessorException, RepositoryException {
        this.doRemoveArchiveCore(this.userName, jarName);
    }

    void doRemoveArchives(List<String> jars) throws RepositoryAccessorException, RepositoryException {
        for (String jarName : jars) {
            if (!this.existsArchive(jarName)) continue;
            this.doRemoveArchiveForced(jarName);
        }
    }

    void doRemoveArchiveForced(String jarName) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("removeArchiveForced", this.userName, new Class[]{String.class}, jarName);
    }

    @Override
    public void removeArchive(String jarName) throws RepositoryAccessorException, RepositoryException {
        this.removeArchive(this.userName, jarName);
    }

    void removeArchive(String userName, String jarName) throws RepositoryAccessorException, RepositoryException {
        if (this.runtimeContext.isCoherenceAgentBound()) {
            try {
                this.runtimeContext.exchange.removeJar(this, userName, jarName);
            }
            catch (Exception exception) {
                if (exception instanceof RepositoryAccessorException) {
                    throw (RepositoryAccessorException)exception;
                }
                if (exception instanceof RepositoryException) {
                    throw (RepositoryException)exception;
                }
                throw new RepositoryAccessorException(6011, "Unexpected exception.", exception);
            }
        } else {
            this.doRemoveArchiveCore(userName, jarName);
        }
    }

    synchronized Package doRemoveArchiveCore(String userName, String jarName) throws RepositoryAccessorException, RepositoryException {
        return (Package)this.invokeOperation1("removeArchive", userName, new Class[]{String.class}, jarName);
    }

    @Override
    public boolean existsArchive(String jarName) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.existsArchive(jarName);
    }

    @Override
    public byte[] getArchive(String jarName) throws RepositoryAccessorException, RepositoryException {
        return this.getArchive(this.userName, jarName);
    }

    byte[] getArchive(String userName, String jarName) throws RepositoryAccessorException, RepositoryException {
        return (byte[])this.invokeOperation1("getArchive", userName, new Class[]{String.class}, jarName);
    }

    @Override
    public InputStream getArchiveStream(String jarName) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getArchiveStream(jarName);
    }

    @Override
    public URL getArchiveURL(String jarName) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getArchiveURL(jarName);
    }

    @Override
    public List<URL> getArchiveURLs() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getArchiveURLs();
    }

    @Override
    public List<String> listArchives() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listArchives();
    }

    void doAddExtensionArchive(File jarDir, String jarName) throws RepositoryAccessorException, RepositoryException {
        this.doAddArchiveFromTempDir(jarDir, jarName, this::doAddExtensionArchive);
    }

    synchronized void doAddExtensionArchive(File jar) throws RepositoryAccessorException, RepositoryException {
        List relatedTypes = (List)this.invokeOperation1("addExtensionArchive", this.userName, new Class[]{File.class}, jar);
        InternalUtils.checkRelatedEntities(this.runtimeContext, relatedTypes, true, false);
    }

    @Override
    public void addExtensionArchive(File jar) throws RepositoryAccessorException, RepositoryException {
        this.addExtensionArchive(this.userName, jar);
    }

    @Override
    public void addExtensionArchive(String jarName, byte[] jarContent) throws RepositoryAccessorException, RepositoryException {
        this.doAddArchive(jarName, jarContent, jar -> this.addExtensionArchive(this.userName, jar));
    }

    void addExtensionArchive(String userName, String jarName, byte[] jarContent) throws RepositoryAccessorException, RepositoryException {
        this.doAddArchive(jarName, jarContent, jar -> this.addExtensionArchive(userName, jar));
    }

    void addExtensionArchive(String userName, File jar) throws RepositoryAccessorException, RepositoryException {
        if (this.runtimeContext.isCoherenceAgentBound()) {
            try {
                this.runtimeContext.exchange.addExtensionJar(this, userName, jar.getCanonicalFile());
            }
            catch (Exception exception) {
                if (exception instanceof RepositoryAccessorException) {
                    throw (RepositoryAccessorException)exception;
                }
                if (exception instanceof RepositoryException) {
                    throw (RepositoryException)exception;
                }
                throw new RepositoryAccessorException(6011, "Unexpected exception.", exception);
            }
        } else {
            this.doAddExtensionArchiveCore(userName, jar);
        }
    }

    synchronized void doAddExtensionArchiveCore(String userName, File jar) throws RepositoryAccessorException, RepositoryException {
        List relatedTypes = (List)this.invokeOperation1("addExtensionArchive", userName, new Class[]{File.class}, jar);
        InternalUtils.checkRelatedEntities(this.runtimeContext, relatedTypes, true, false);
    }

    void doRemoveExtensionArchive(String jarName, boolean force) throws RepositoryAccessorException, RepositoryException {
        this.doRemoveExtensionArchiveCore(this.userName, jarName, force);
    }

    @Override
    public void removeExtensionArchive(String jarName, boolean force) throws RepositoryAccessorException, RepositoryException {
        this.removeExtensionArchive(this.userName, jarName, force);
    }

    void removeExtensionArchive(String userName, String jarName, boolean force) throws RepositoryAccessorException, RepositoryException {
        if (this.runtimeContext.isCoherenceAgentBound()) {
            try {
                this.runtimeContext.exchange.removeExtensionJar(this, userName, jarName, force);
            }
            catch (Exception exception) {
                if (exception instanceof RepositoryAccessorException) {
                    throw (RepositoryAccessorException)exception;
                }
                if (exception instanceof RepositoryException) {
                    throw (RepositoryException)exception;
                }
                throw new RepositoryAccessorException(6011, "Unexpected exception.", exception);
            }
        } else {
            this.doRemoveExtensionArchiveCore(userName, jarName, force);
        }
    }

    synchronized void doRemoveExtensionArchiveCore(String userName, String jarName, boolean force) throws RepositoryAccessorException, RepositoryException {
        List relatedTypes = (List)this.invokeOperation1("removeExtensionArchive", userName, new Class[]{String.class, Boolean.TYPE}, jarName, force);
        InternalUtils.checkRelatedEntities(this.runtimeContext, relatedTypes, false, false);
    }

    @Override
    public boolean existsExtensionArchive(String jarName) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.existsExtensionArchive(jarName);
    }

    @Override
    public byte[] getExtensionArchive(String jarName) throws RepositoryAccessorException, RepositoryException {
        return this.getExtensionArchive(this.userName, jarName);
    }

    byte[] getExtensionArchive(String userName, String jarName) throws RepositoryAccessorException, RepositoryException {
        return (byte[])this.invokeOperation1("getExtensionArchive", userName, new Class[]{String.class}, jarName);
    }

    @Override
    public URL getExtensionArchiveURL(String jarName) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getExtensionArchiveURL(jarName);
    }

    @Override
    public List<URL> getExtensionArchiveURLs() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.getExtensionArchiveURLs();
    }

    @Override
    public List<String> listExtensionArchives() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listExtensionArchives();
    }

    @Override
    public void saveTransportFactory(TransportFactory factory) throws RepositoryAccessorException, RepositoryException {
        this.saveTransportFactory(this.userName, factory);
    }

    void saveTransportFactory(String userName, TransportFactory factory) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("saveTransportFactory", userName, new Class[]{TransportFactory.class}, factory);
    }

    @Override
    public TransportFactory loadTransportFactory(String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        return this.loadTransportFactory(this.userName, factoryName, factoryType);
    }

    TransportFactory loadTransportFactory(String userName, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        return (TransportFactory)this.invokeOperation1("loadTransportFactory", userName, new Class[]{String.class, String.class}, factoryName, factoryType);
    }

    @Override
    public void removeTransportFactory(String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.removeTransportFactory(this.userName, factoryName, factoryType);
    }

    void removeTransportFactory(String userName, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("removeTransportFactory", userName, new Class[]{String.class, String.class}, factoryName, factoryType);
    }

    @Override
    public boolean existsTransportFactory(String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.existsTransportFactory(factoryName, factoryType);
    }

    @Override
    public List<String> listTransportFactoryNames() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listTransportFactoryNames();
    }

    @Override
    public List<String> listTransportFactoryTypes() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listTransportFactoryTypes();
    }

    @Override
    public List<String> listTransportFactoriesByType(String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listTransportFactoriesByType(factoryType);
    }

    @Override
    public void importTransportFactory(String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.importTransportFactory(this.userName, directory, factoryName, factoryType);
    }

    void importTransportFactory(String userName, String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("importTransportFactoryArtifact", userName, new Class[]{String.class, String.class, String.class}, directory, factoryName, factoryType);
    }

    @Override
    public void exportTransportFactory(String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.exportTransportFactory(this.userName, directory, factoryName, factoryType);
    }

    void exportTransportFactory(String userName, String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("exportTransportFactoryArtifact", userName, new Class[]{String.class, String.class, String.class}, directory, factoryName, factoryType);
    }

    @Override
    public void saveJDBCFactory(JDBCFactory factory) throws RepositoryAccessorException, RepositoryException {
        this.saveJDBCFactory(this.userName, factory);
    }

    void saveJDBCFactory(String userName, JDBCFactory factory) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("saveJDBCFactory", userName, new Class[]{JDBCFactory.class}, factory);
    }

    @Override
    public JDBCFactory loadJDBCFactory(String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        return this.loadJDBCFactory(this.userName, factoryName, factoryType);
    }

    JDBCFactory loadJDBCFactory(String userName, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        return (JDBCFactory)this.invokeOperation1("loadJDBCFactory", userName, new Class[]{String.class, String.class}, factoryName, factoryType);
    }

    @Override
    public void removeJDBCFactory(String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.removeJDBCFactory(this.userName, factoryName, factoryType);
    }

    void removeJDBCFactory(String userName, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("removeJDBCFactory", userName, new Class[]{String.class, String.class}, factoryName, factoryType);
    }

    @Override
    public boolean existsJDBCFactory(String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.existsJDBCFactory(factoryName, factoryType);
    }

    @Override
    public List<String> listJDBCFactoryNames() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listJDBCFactoryNames();
    }

    @Override
    public List<String> listJDBCFactoryTypes() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listJDBCFactoryTypes();
    }

    @Override
    public List<String> listJDBCFactoriesByType(String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listJDBCFactoriesByType(factoryType);
    }

    @Override
    public void importJDBCFactory(String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.importJDBCFactory(this.userName, directory, factoryName, factoryType);
    }

    void importJDBCFactory(String userName, String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("importJDBCFactoryArtifact", userName, new Class[]{String.class, String.class, String.class}, directory, factoryName, factoryType);
    }

    @Override
    public void exportJDBCFactory(String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.exportJDBCFactory(this.userName, directory, factoryName, factoryType);
    }

    void exportJDBCFactory(String userName, String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("exportJDBCFactoryArtifact", userName, new Class[]{String.class, String.class, String.class}, directory, factoryName, factoryType);
    }

    @Override
    public void saveClientFactory(ClientFactory factory) throws RepositoryAccessorException, RepositoryException {
        this.saveClientFactory(this.userName, factory);
    }

    void saveClientFactory(String userName, ClientFactory factory) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("saveClientFactory", userName, new Class[]{ClientFactory.class}, factory);
    }

    @Override
    public ClientFactory loadClientFactory(String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        return this.loadClientFactory(this.userName, factoryName, factoryType);
    }

    ClientFactory loadClientFactory(String userName, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        return (ClientFactory)this.invokeOperation1("loadClientFactory", userName, new Class[]{String.class, String.class}, factoryName, factoryType);
    }

    @Override
    public void removeClientFactory(String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.removeClientFactory(this.userName, factoryName, factoryType);
    }

    void removeClientFactory(String userName, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("removeClientFactory", userName, new Class[]{String.class, String.class}, factoryName, factoryType);
    }

    @Override
    public boolean existsClientFactory(String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.existsClientFactory(factoryName, factoryType);
    }

    @Override
    public List<String> listClientFactoryNames() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listClientFactoryNames();
    }

    @Override
    public List<String> listClientFactoryTypes() throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listClientFactoryTypes();
    }

    @Override
    public List<String> listClientFactoriesByType(String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.checkOpened();
        return this.repositoryContext.listClientFactoriesByType(factoryType);
    }

    @Override
    public void importClientFactory(String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.importClientFactory(this.userName, directory, factoryName, factoryType);
    }

    void importClientFactory(String userName, String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("importClientFactoryArtifact", userName, new Class[]{String.class, String.class, String.class}, directory, factoryName, factoryType);
    }

    @Override
    public void exportClientFactory(String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.exportClientFactory(this.userName, directory, factoryName, factoryType);
    }

    void exportClientFactory(String userName, String directory, String factoryName, String factoryType) throws RepositoryAccessorException, RepositoryException {
        this.invokeOperation1("exportClientFactoryArtifact", userName, new Class[]{String.class, String.class, String.class}, directory, factoryName, factoryType);
    }

    Object invokeOperation1(String methodName, String userName, Class[] parameterTypes, Object ... parameters) throws RepositoryAccessorException, RepositoryException {
        try {
            return this.doInvokeOperation(methodName, userName, parameterTypes, parameters);
        }
        catch (Throwable exception) {
            if (exception instanceof RepositoryAccessorException) {
                throw (RepositoryAccessorException)exception;
            }
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)exception;
            }
            throw new RepositoryAccessorException(4000, "Unexpected exception.", exception);
        }
    }

    Object invokeOperation2(String methodName, String userName, Class[] parameterTypes, Object ... parameters) throws RepositoryAccessorException, NamingException, RepositoryException {
        try {
            return this.doInvokeOperation(methodName, userName, parameterTypes, parameters);
        }
        catch (Throwable exception) {
            if (exception instanceof RepositoryAccessorException) {
                throw (RepositoryAccessorException)exception;
            }
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)exception;
            }
            throw new RepositoryAccessorException(4000, "Unexpected exception.", exception);
        }
    }

    synchronized Object doInvokeOperation(String methodName, String userName, Class[] parameterTypes, Object ... parameters) throws Throwable {
        this.checkOpened();
        Method method = this.repositoryContext.getClass().getDeclaredMethod(methodName, parameterTypes);
        method.setAccessible(true);
        this.doBeginXact(userName);
        try {
            Object result = method.invoke((Object)this.repositoryContext, parameters);
            this.doCommitXact();
            return result;
        }
        catch (InvocationTargetException exception) {
            throw exception.getCause();
        }
        finally {
            if (this.repositoryContext.inXactByCurrentThread()) {
                this.doAbortXact();
            }
        }
    }

    private void doBeginXact(String userName) throws RepositoryAccessorException, RepositoryException {
        try {
            this.repositoryContext.beginXact(this.connection != null ? this.connection.component : this.runtimeContext, this.runtimeContext.getRepositoryContextTxTimeout());
        }
        catch (InterruptedException exception) {
            throw new RepositoryException(4023, "Thread '" + String.valueOf(Thread.currentThread()) + "' interrupted.");
        }
        this.oldUserName = this.repositoryContext.setCurrentUser(userName);
    }

    private void doCommitXact() throws RepositoryException {
        this.repositoryContext.setCurrentUser(this.oldUserName);
        this.repositoryContext.commitXact();
        this.oldUserName = null;
    }

    void doAbortXact() throws RepositoryAccessorException {
        try {
            this.repositoryContext.setCurrentUser(this.oldUserName);
            this.doAbortXactCore();
        }
        catch (RepositoryException exception) {
            this.doAbortXactCore();
            throw new RepositoryAccessorException(4000, "Unexpected exception.", exception);
        }
    }

    private void doAbortXactCore() {
        this.repositoryContext.abortXact();
        this.oldUserName = null;
    }

    public static interface AddArchiveMethod {
        public void execute(File var1) throws RepositoryAccessorException, RepositoryException;
    }
}

