/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.loader.ClassLoaderReference;
import com.streamscape.lib.loader.FabricClassLoader;
import com.streamscape.lib.utils.ArchiveException;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dispatcher.ComponentLoaderRegistry;
import com.streamscape.sef.dispatcher.LoaderRegistry;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.pkg.PackageManifestException;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.sef.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;

public class RuntimeLoaderRegistryImpl
extends LoaderRegistry {
    private RuntimeContext context;

    public RuntimeLoaderRegistryImpl(RuntimeContext context, ClassLoader loader) throws PackageManifestException {
        super("Runtime.Context", loader, true);
        this.context = context;
        this.registerExtClassLoader();
    }

    private void registerExtClassLoader() throws PackageManifestException {
        ClassLoader parentLoader = ClassLoaderReference.getRealClassLoader(this.systemClassLoader);
        try {
            ExtFabricClassLoader loader = new ExtFabricClassLoader(parentLoader, this);
            this.addClassLoader("SYS$ExtClassLoader", loader, parentLoader, true);
            this.setSystemClassLoaderChain(loader);
        }
        catch (Exception exception) {
            throw new PackageManifestException("Registering of system class loader 'SYS$ExtClassLoader' failed.", exception);
        }
    }

    List<SemanticType> addToExtClassLoader(String jarName, URL jarURL) throws Exception {
        ClassLoader loader = this.lookupClassLoader("SYS$ExtClassLoader");
        if (loader == null) {
            throw new UtilitiesException("Class loader 'SYS$ExtClassLoader' is not registered.");
        }
        return ((ExtFabricClassLoader)loader).addArchive(jarName, jarURL);
    }

    List<SemanticType> removeFromExtClassLoader(String jarName, boolean force) throws Exception {
        ClassLoader loader = this.lookupClassLoader("SYS$ExtClassLoader");
        if (loader == null) {
            throw new UtilitiesException("Class loader 'SYS$ExtClassLoader' is not registered.");
        }
        return ((ExtFabricClassLoader)loader).removeArchive(jarName, force);
    }

    synchronized LoaderRegistry addComponentRegistry(String name) {
        return new ComponentLoaderRegistry(name, this.systemClassLoader);
    }

    @Override
    public List<String> listArchivesByClass(String className) throws ArchiveException {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.listExtArchivesByClass(className));
        result.addAll(this.listLibArchivesByClass(className, null));
        return result;
    }

    @Override
    public List<String> listExtArchivesByClass(String className) throws ArchiveException {
        return this.doListArchivesByClass(className, null, () -> this.context.repositoryAccessor.listExtensionArchives(), jarName -> this.context.repositoryAccessor.getExtensionArchiveURL((String)jarName));
    }

    @Override
    public List<String> listLibArchivesByClass(String className, Set<String> excludedArchives) throws ArchiveException {
        return this.doListArchivesByClass(className, excludedArchives, () -> this.context.repositoryAccessor.listArchives(), jarName -> this.context.repositoryAccessor.getArchiveURL((String)jarName));
    }

    private List<String> doListArchivesByClass(String className, Set<String> excludedJars, Utils.Supplier<List<String>> jarsGetter, Utils.Function<String, URL> urlGetter) throws ArchiveException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (String jarName : jarsGetter.get()) {
                if (excludedJars != null && excludedJars.contains(jarName) || !SemanticUtils.existsClassInArchive(className, urlGetter.apply(jarName))) continue;
                result.add(jarName);
            }
            return result;
        }
        catch (Throwable exception) {
            throw new ArchiveException("Operation with archives in Repository failed.", exception);
        }
    }

    private static class ExtFabricClassLoader
    extends FabricClassLoader {
        private RuntimeLoaderRegistryImpl registry;
        private final Map<String, FabricClassLoader> loaders = new ConcurrentHashMap<String, FabricClassLoader>();
        private final Map<String, FabricClassLoader> cachedClasses = new ConcurrentHashMap<String, FabricClassLoader>();
        private final ReadWriteLock archivesLock = new ReentrantReadWriteLock();
        private final Set<Long> loadingInProgressMap = Collections.synchronizedSet(new HashSet());
        private boolean operationInProgress = false;
        private final Object operationMutex = new Object();

        ExtFabricClassLoader(ClassLoader parent, RuntimeLoaderRegistryImpl registry) throws Exception {
            super("SYS$ExtClassLoader", new URL[0], parent);
            this.registry = registry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<SemanticType> addArchive(String jarName, URL jarURL) throws Exception {
            this.archivesLock.writeLock().lock();
            try {
                if (this.loaders.containsKey(jarName)) {
                    throw new UtilitiesException("Archive '" + jarName + "' already exists in class loader 'SYS$ExtClassLoader' .");
                }
                ChildExtFabricClassLoader loader = new ChildExtFabricClassLoader(jarName, new URL[]{jarURL}, this);
                this.loaders.put(jarName, loader);
                List<SemanticType> list = SemanticUtils.getRelatedSemanticTypes(Arrays.asList(loader.getURLs()), (FabricContext)this.registry.context);
                return list;
            }
            finally {
                this.archivesLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<SemanticType> removeArchive(String jarName, boolean force) throws Exception {
            FabricClassLoader loader = null;
            List<SemanticType> relatedTypes = null;
            this.archivesLock.writeLock().lock();
            try {
                loader = this.loaders.get(jarName);
                if (loader == null) {
                    throw new UtilitiesException("Archive '" + jarName + "' does not exist in class loader 'SYS$ExtClassLoader'.");
                }
                relatedTypes = SemanticUtils.getRelatedSemanticTypes(Arrays.asList(loader.getURLs()), (FabricContext)this.registry.context);
                if (!relatedTypes.isEmpty() && !force) {
                    throw new TFCacheException("Extension archive '" + jarName + "' has dependencies and cannot be removed.");
                }
                this.loaders.remove(jarName);
                Iterator<Map.Entry<String, FabricClassLoader>> iter = this.cachedClasses.entrySet().iterator();
                while (iter.hasNext()) {
                    if (iter.next().getValue() != loader) continue;
                    iter.remove();
                }
            }
            finally {
                this.archivesLock.writeLock().unlock();
            }
            this.registry.onRemoveFabricClassLoader(loader, relatedTypes);
            return relatedTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            this.archivesLock.readLock().lock();
            try {
                if (this.isLoadingAllowed()) {
                    try {
                        Class result = this.doLoadClass(name, resolve);
                        if (result != null) {
                            Class clazz = result;
                            return clazz;
                        }
                    }
                    finally {
                        this.loadingInProgressMap.remove(Thread.currentThread().getId());
                    }
                }
                Class<?> clazz = this.getParent().loadClass(name);
                return clazz;
            }
            finally {
                this.archivesLock.readLock().unlock();
            }
        }

        private synchronized boolean isLoadingAllowed() {
            if (!this.loaders.isEmpty() && !this.loadingInProgressMap.contains(Thread.currentThread().getId())) {
                this.loadingInProgressMap.add(Thread.currentThread().getId());
                return true;
            }
            return false;
        }

        private Class doLoadClass(String className, boolean resolve) {
            Class result = null;
            FabricClassLoader cachedLoader = this.cachedClasses.get(className);
            if (cachedLoader != null) {
                try {
                    result = cachedLoader.loadClass(className, resolve);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (result == null) {
                for (FabricClassLoader loader : this.loaders.values()) {
                    try {
                        result = loader.loadClass(className, resolve);
                        if (result == null) continue;
                        if (result.getClassLoader() == loader) {
                            this.cachedClasses.put(className, loader);
                        }
                        return result;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
            return result;
        }

        @Override
        public URL[] getURLs() {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (FabricClassLoader loader : this.loaders.values()) {
                urls.addAll(Arrays.asList(loader.getURLs()));
            }
            return urls.toArray(new URL[0]);
        }

        @Override
        public URL getResource(String name) {
            return this.get(name, (loader, s) -> loader.getResource(name));
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return this.get(name, (loader, s) -> loader.getResourceAsStream(name));
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            try {
                return this.get(name, (loader, s) -> {
                    try {
                        return loader.getResources(name);
                    }
                    catch (IOException exception) {
                        throw new RuntimeException(exception);
                    }
                });
            }
            catch (RuntimeException exception) {
                if (exception.getCause() instanceof IOException) {
                    throw (IOException)exception.getCause();
                }
                throw exception;
            }
        }

        private <Result> Result get(String name, BiFunction<ClassLoader, String, Result> getter) {
            Result result = this.doGet(name, getter);
            return result != null ? result : getter.apply(this.getParent(), name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <Result> Result doGet(String name, BiFunction<ClassLoader, String, Result> getter) {
            Object object = this.operationMutex;
            synchronized (object) {
                if (this.operationInProgress) return null;
                if (this.loaders.isEmpty()) return null;
                this.operationInProgress = true;
                Result result = this.findInChildLoaders(name, getter);
                if (result == null) return null;
                Result Result2 = result;
                return Result2;
                finally {
                    this.operationInProgress = false;
                }
            }
        }

        private <Result> Result findInChildLoaders(String name, BiFunction<ClassLoader, String, Result> getter) {
            return this.loaders.values().stream().map(loader -> getter.apply((ClassLoader)loader, name)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    private static class ChildExtFabricClassLoader
    extends FabricClassLoader {
        ChildExtFabricClassLoader(String name, URL[] urls, ClassLoader parent) throws Exception {
            super(name, urls, parent);
        }

        @Override
        protected Object getClassLoadingLock(String className) {
            return this.getParent();
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

