/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.numalloc.NumberAllocatorException;
import com.streamscape.lib.numalloc.ShortNumberAllocator;
import com.streamscape.sef.dispatcher.AbstractFabricGroup;
import com.streamscape.sef.dispatcher.AbstractFabricGroupManager;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.dispatcher.RuntimeFabricGroup;
import com.streamscape.sef.group.FabricGroup;
import com.streamscape.sef.group.FabricGroupManagerException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

class RuntimeFabricGroupManager
extends AbstractFabricGroupManager {
    RuntimeExchange exchange;
    ShortNumberAllocator uidAllocator = new ShortNumberAllocator();
    boolean hasToken = true;
    final Object tokenMutex = new Object();

    RuntimeFabricGroupManager(RuntimeExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public FabricGroup createGroup(String name, String description) throws FabricGroupManagerException {
        return this.exchange.createGroup(name, description, null);
    }

    RuntimeFabricGroup doCreateGroup(String name, String description) throws FabricGroupManagerException {
        this.checkGroupExistence(name);
        try {
            RuntimeFabricGroup group = new RuntimeFabricGroup(name, description, this.uidAllocator.getNumber(), this);
            this.addGroup(group);
            return group;
        }
        catch (NumberAllocatorException exception) {
            throw new FabricGroupManagerException(6127, "Too many groups in sysplex (32767).");
        }
    }

    @Override
    void createGroup(AbstractFabricGroup other) {
        this.addGroup(new RuntimeFabricGroup(other, this));
        try {
            this.uidAllocator.getNumber();
        }
        catch (NumberAllocatorException numberAllocatorException) {
            // empty catch block
        }
    }

    @Override
    public void dropGroup(String name) throws FabricGroupManagerException {
        this.exchange.dropGroup(name, null);
    }

    FabricGroup doDropGroup(String name) throws FabricGroupManagerException {
        FabricGroup group = this.lookupGroup(name);
        if (group != null) {
            if (group.hasMembers()) {
                throw new FabricGroupManagerException(6091, "Group '" + name + "' has members and cannot be dropped.");
            }
            return this.removeGroup(name);
        }
        return null;
    }

    @Override
    AbstractFabricGroup removeGroup(String name) {
        AbstractFabricGroup group = super.removeGroup(name);
        if (group != null) {
            this.uidAllocator.releaseNumber(group.uid);
            group.destroy();
        }
        return group;
    }

    RuntimeFabricGroup getGroup(String name) {
        FabricGroup result = this.lookupGroup(name);
        return result != null ? (RuntimeFabricGroup)result : null;
    }

    void onToken(ByteBuffer tokenBuffer) {
        if (this.hasGroups()) {
            while (tokenBuffer.remaining() > 0) {
                RuntimeFabricGroup group = (RuntimeFabricGroup)this.doGetGroup(tokenBuffer.getShort());
                if (group == null) continue;
                group.setEventNumber(tokenBuffer.getLong());
            }
            this.notifyOnToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOnToken() {
        Object object = this.tokenMutex;
        synchronized (object) {
            this.hasToken = true;
            this.tokenMutex.notifyAll();
        }
    }

    byte[] updateToken(byte[] token) {
        this.hasToken = false;
        if (this.hasGroups()) {
            ArrayList<ByteBuffer> tokenChunks = new ArrayList<ByteBuffer>(this.groups.size());
            for (AbstractFabricGroup group : this.groups.values()) {
                ByteBuffer tokenChunk = ((RuntimeFabricGroup)group).getTokenChunk();
                if (tokenChunk == null) continue;
                tokenChunks.add(tokenChunk);
            }
            if (!tokenChunks.isEmpty()) {
                ByteBuffer result = ByteBuffer.allocate(token.length + tokenChunks.size() * 10);
                result.put(token);
                for (ByteBuffer tokenChunk : tokenChunks) {
                    result.put(tokenChunk);
                }
                return result.array();
            }
        }
        return token;
    }

    @Override
    void clear() {
        super.clear();
    }
}

