/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.dispatcher.EventException;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricGroup;
import com.streamscape.sef.dispatcher.EndpointReferenceImpl;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.NetworkExchangeConsumer;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.dispatcher.RuntimeExchangeEventPublisher;
import com.streamscape.sef.dispatcher.RuntimeFabricGroupManager;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

class RuntimeFabricGroup
extends AbstractFabricGroup
implements RuntimeExchangeEventPublisher {
    long iEvent = 0L;
    transient long iLastEvent = 0L;
    transient RuntimeFabricGroupManager manager;
    transient NetworkEventDispatcher networkDispatcher;
    transient ClientEventDispatcher clientDispatcher;
    transient EventQueue eventQueue = new EventQueue();
    transient ByteBuffer tokenChunk = ByteBuffer.allocate(10);
    final transient Object mutex = new Object();
    static final int TOKEN_CHUNK_SIZE = 10;

    RuntimeFabricGroup(String name, String description, short uid, RuntimeFabricGroupManager manager) {
        super(name, description, uid);
        this.init(manager);
    }

    RuntimeFabricGroup(AbstractFabricGroup other, RuntimeFabricGroupManager manager) {
        super(other);
        this.init(manager);
        this.setEventNumbers(other);
    }

    private void init(RuntimeFabricGroupManager manager) {
        this.manager = manager;
        this.tokenChunk.putShort(this.uid);
    }

    @Override
    synchronized void initDispatchers() {
        if (this.dispatcher == null) {
            this.initDispatcher(this.manager.exchange);
            this.networkDispatcher = new NetworkEventDispatcher(this.manager.exchange);
            this.clientDispatcher = new ClientEventDispatcher(this.manager.exchange);
        }
    }

    @Override
    void update(AbstractFabricGroup other) {
        super.update(other);
        this.setEventNumbers(other);
    }

    void setEventNumbers(AbstractFabricGroup other) {
        if (other instanceof RuntimeFabricGroup) {
            this.iLastEvent = this.iEvent = ((RuntimeFabricGroup)other).iEvent;
            this.eventQueue.activate(this.iEvent);
        }
    }

    @Override
    RuntimeExchange.NetworkEventDispatcher getNetworkDispatcher() {
        this.initDispatchers();
        return this.networkDispatcher;
    }

    RuntimeExchange.ClientNetworkEventDispatcher getClientDispatcher() {
        this.initDispatchers();
        return this.clientDispatcher;
    }

    @Override
    public void addToDispatcher(EndpointReferenceImpl reference, NamedObject consumer, boolean isSystem, boolean fromClient) {
        if (fromClient) {
            this.clientDispatcher.addConsumer(reference);
        } else {
            this.dispatcher.addConsumer(consumer, isSystem);
        }
    }

    @Override
    public void removeFromDispatcher(EndpointReferenceImpl reference, NamedObject consumer, boolean fromClient) {
        if (fromClient) {
            this.clientDispatcher.removeConsumer(reference);
        } else {
            this.dispatcher.dropConsumer(consumer);
        }
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, FabricAddress componentAddress, EventScope eventScope) throws EventException, FabricException, FabricEventSourceException, FabricEventException {
        this.raiseEvent(event, componentAddress, eventScope, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void raiseEvent(ImmutableEventDatagram event, FabricAddress componentAddress, EventScope eventScope, ByteBuffer eventBuffer) throws EventException, FabricException, FabricEventSourceException, FabricEventException {
        long eventNumber;
        if (eventScope == EventScope.OBSERVABLE) {
            RuntimeFabricGroup runtimeFabricGroup = this;
            synchronized (runtimeFabricGroup) {
                this.dispatcher.raiseEvent(event, componentAddress, eventScope);
                this.clientDispatcher.raiseEvent(event, componentAddress, eventBuffer);
            }
        }
        Object object = this.manager.tokenMutex;
        synchronized (object) {
            this.waitForToken();
            eventNumber = this.incrementEventNumber();
        }
        object = this;
        synchronized (object) {
            this.eventQueue.putEvent(eventNumber, event, componentAddress, eventBuffer, false);
            if (eventBuffer != null) {
                eventBuffer.position(3);
            }
            this.networkDispatcher.raiseEvent(new GroupEvent(eventNumber, event), eventScope, eventBuffer);
        }
    }

    void raiseNetworkEvent(long eventNumber, ImmutableEventDatagram event, FabricAddress componentAddress, ByteBuffer eventBuffer) throws EventException, FabricEventSourceException, FabricEventException, FabricException {
        this.eventQueue.putEvent(eventNumber, event, componentAddress, eventBuffer, true);
    }

    private void waitForToken() throws FabricException {
        try {
            while (!this.manager.hasToken) {
                this.manager.tokenMutex.wait();
            }
        }
        catch (InterruptedException exception) {
            Thread thread = Thread.currentThread();
            throw new FabricException("Waiting token interrupted (in thread '<" + thread.getId() + ", " + thread.getName() + ">'.)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrementEventNumber() {
        Object object = this.mutex;
        synchronized (object) {
            return ++this.iEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEventNumber(long iEvent) {
        Object object = this.mutex;
        synchronized (object) {
            this.iEvent = iEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getTokenChunk() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.iEvent > this.iLastEvent) {
                this.tokenChunk.position(2);
                this.tokenChunk.putLong(this.iEvent);
                this.iLastEvent = this.iEvent;
                return this.tokenChunk.flip();
            }
            return null;
        }
    }

    @Override
    void clear() {
        if (this.networkDispatcher != null) {
            this.networkDispatcher.clear();
        }
        if (this.eventQueue != null) {
            this.eventQueue.deactivate();
        }
    }

    private class EventQueue {
        boolean active = false;
        long iReceivedEvent = 0L;
        Map<Long, GroupEvent> queue = new TreeMap<Long, GroupEvent>();

        private EventQueue() {
        }

        synchronized void activate(long iEvent) {
            this.active = true;
            this.iReceivedEvent = iEvent;
            this.flush();
        }

        synchronized void deactivate() {
            this.active = false;
            this.iReceivedEvent = 0L;
            this.flush();
        }

        synchronized void flush() {
            for (GroupEvent event : this.queue.values()) {
                try {
                    this.deliverEvent(event);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    Trace.logError(this, "Flush of event [" + event.getEventId() + "] from queue failed.");
                }
            }
        }

        synchronized void putEvent(long iEvent, ImmutableEventDatagram event, FabricAddress componentAddress, ByteBuffer eventBuffer, boolean network) throws FabricEventSourceException, FabricException, FabricEventException, EventException {
            if (this.active) {
                if (iEvent <= this.iReceivedEvent) {
                    this.deliverEvent(event, componentAddress, eventBuffer, network);
                } else if (iEvent == this.iReceivedEvent + 1L) {
                    ++this.iReceivedEvent;
                    this.deliverEvent(event, componentAddress, eventBuffer, network);
                    this.checkQueue();
                } else {
                    this.queue.put(iEvent, new GroupEvent(iEvent, event, componentAddress, eventBuffer, network));
                }
            } else {
                this.deliverEvent(event, componentAddress, eventBuffer, network);
            }
        }

        private void checkQueue() throws FabricEventSourceException, FabricException, FabricEventException, EventException {
            if (!this.queue.isEmpty()) {
                Iterator<Map.Entry<Long, GroupEvent>> iter = this.queue.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Long, GroupEvent> entry = iter.next();
                    if (entry.getKey() != this.iReceivedEvent + 1L) continue;
                    ++this.iReceivedEvent;
                    iter.remove();
                    this.deliverEvent(entry.getValue());
                }
            }
        }

        private void deliverEvent(GroupEvent event) throws FabricEventSourceException, FabricEventException, EventException, FabricException {
            this.deliverEvent(event.event, event.componentAddress, event.eventBuffer, event.network);
        }

        private void deliverEvent(ImmutableEventDatagram event, FabricAddress componentAddress, ByteBuffer eventBuffer, boolean network) throws FabricEventSourceException, FabricEventException, FabricException, EventException {
            if (event != null) {
                if (network) {
                    RuntimeFabricGroup.this.dispatcher.raiseNetworkEvent(event, componentAddress);
                    RuntimeFabricGroup.this.clientDispatcher.raiseNetworkEvent(event, componentAddress, eventBuffer);
                } else {
                    RuntimeFabricGroup.this.dispatcher.raiseEvent(event, componentAddress, EventScope.GLOBAL);
                    RuntimeFabricGroup.this.clientDispatcher.raiseEvent(event, componentAddress, eventBuffer);
                }
            }
        }
    }

    private class NetworkEventDispatcher
    extends RuntimeExchange.NetworkEventDispatcher {
        NetworkEventDispatcher(RuntimeExchange exchange) {
        }

        @Override
        void raiseEvent(ImmutableEventDatagram event, EventScope eventScope, ByteBuffer eventBuffer) throws FabricException, FabricEventSourceException, FabricEventException {
            this.publish(event, this.getConsumersWithCheckCluster(event, eventScope), eventBuffer);
        }

        @Override
        void publish(ImmutableEventDatagram event, Collection<NetworkExchangeConsumer> consumers, ByteBuffer eventBuffer) throws FabricException, FabricEventSourceException, FabricEventException {
            Map<FabricAddress, Boolean> destinations;
            Map<FabricAddress, Boolean> map = destinations = consumers != null ? this.getDestinations(consumers, event) : null;
            if (destinations == null || destinations.isEmpty()) {
                eventBuffer = ByteBuffer.allocate(0);
            }
            Pair<Integer, byte[]> packetData = this.packEvent(6, event, eventBuffer);
            for (FabricAddress nodeAddress : RuntimeFabricGroup.this.manager.exchange.getNodeAddresses()) {
                Boolean async = destinations != null ? destinations.get(nodeAddress) : null;
                this.publishRemote(nodeAddress, event, (Integer)packetData.first, (byte[])packetData.second, eventBuffer, async != null ? async : true);
            }
        }

        @Override
        boolean matches(NetworkExchangeConsumer consumer, ImmutableEventDatagram event) {
            return super.matches(consumer, ((GroupEvent)event).event);
        }

        @Override
        byte[] serialize(ImmutableEventDatagram event) throws ExchangeException {
            return super.serialize(((GroupEvent)event).event);
        }

        @Override
        int getPacketSize(byte[] eventBytes) {
            return super.getPacketSize(eventBytes) + 2 + 8;
        }

        @Override
        int getPacketSize(ByteBuffer eventBuffer) {
            return super.getPacketSize(eventBuffer) + 2 + 8;
        }

        @Override
        void putPacketHeader(ImmutableEventDatagram event, ByteBuffer result) {
            result.put((byte)9).putShort(RuntimeFabricGroup.this.uid).putLong(((GroupEvent)event).eventNumber);
        }
    }

    private class ClientEventDispatcher
    extends RuntimeExchange.ClientNetworkEventDispatcher {
        ClientEventDispatcher(RuntimeExchange exchange) {
            super(exchange);
        }

        @Override
        synchronized void raiseEvent(ImmutableEventDatagram event, FabricAddress componentAddress, ByteBuffer eventBuffer) throws FabricException, FabricEventSourceException, FabricEventException {
            super.raiseEvent(event, componentAddress, eventBuffer);
        }

        @Override
        synchronized void raiseNetworkEvent(ImmutableEventDatagram event, FabricAddress componentAddress, ByteBuffer eventBuffer) throws FabricException, FabricEventSourceException, FabricEventException {
            super.raiseNetworkEvent(event, componentAddress, eventBuffer);
        }

        @Override
        int getPacketSize(byte[] eventBytes) {
            return super.getPacketSize(eventBytes) + 2;
        }

        @Override
        int getPacketSize(ByteBuffer eventBuffer) {
            return super.getPacketSize(eventBuffer) + 2;
        }

        @Override
        void putPacketHeader(ImmutableEventDatagram event, ByteBuffer result) {
            result.put((byte)9).putShort(RuntimeFabricGroup.this.uid);
        }
    }

    private static class GroupEvent
    extends AbstractExchange.PseudoEvent {
        long eventNumber;
        ImmutableEventDatagram event;
        FabricAddress componentAddress;
        ByteBuffer eventBuffer;
        boolean network;

        GroupEvent(long eventNumber, ImmutableEventDatagram event) {
            this.eventNumber = eventNumber;
            this.event = event;
        }

        GroupEvent(long eventNumber, ImmutableEventDatagram event, FabricAddress componentAddress, ByteBuffer eventBuffer, boolean network) {
            this(eventNumber, event);
            this.componentAddress = componentAddress;
            this.eventBuffer = eventBuffer;
            this.network = network;
        }

        @Override
        public String getEventId() {
            return this.event.getEventId();
        }
    }
}

