/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.session.DataspaceSessionInfo;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.lib.concurrent.worker.Worker;
import com.streamscape.lib.dispatcher.EventCache;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.EventException;
import com.streamscape.lib.dispatcher.RequestException;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.loader.TFCacheJarStorage;
import com.streamscape.lib.numalloc.ByteNumberAllocator;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.numalloc.NumberAllocatorException;
import com.streamscape.lib.numalloc.ShortNumberAllocator;
import com.streamscape.lib.utils.Banner;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.OrderedMap;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.globals.UnresolvedVariableException;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.ContextId;
import com.streamscape.runtime.PeerState;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.glv.GlobalVariableFactoryException;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.operation.stats.AbstractShowUsageOperation;
import com.streamscape.runtime.mf.operation.stats.ShowStatsOperation;
import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.runtime.stats.StatsMonitor;
import com.streamscape.runtime.stats.threshold.ThresholdAdvisoryType;
import com.streamscape.sdo.AbstractNamedObject;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.StructuredDataObject;
import com.streamscape.sdo.advisory.AdvisoryEvent;
import com.streamscape.sdo.advisory.BlockedDataspaceSessionAdvisory;
import com.streamscape.sdo.advisory.BlockedThreadAdvisory;
import com.streamscape.sdo.advisory.ThreadDeadlockAdvisory;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.event.SystemEvents;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.coherence.CoherenceAgentAdvisory;
import com.streamscape.sef.coherence.CoherenceAgentAdvisoryType;
import com.streamscape.sef.coherence.ReplicationRules;
import com.streamscape.sef.dataspace.DataspaceManagerException;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.discovery.DiscoveryModule;
import com.streamscape.sef.discovery.DiscoveryModuleException;
import com.streamscape.sef.discovery.RuntimeDiscoveryModule;
import com.streamscape.sef.dispatcher.AbstractApiKeyManager;
import com.streamscape.sef.dispatcher.AbstractDatagramPrototypeCache;
import com.streamscape.sef.dispatcher.AbstractDataspaceManager;
import com.streamscape.sef.dispatcher.AbstractDirectoryTable;
import com.streamscape.sef.dispatcher.AbstractDynamicFabricComponent;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AbstractFabricConnectionFactory;
import com.streamscape.sef.dispatcher.AbstractFabricDataConstraint;
import com.streamscape.sef.dispatcher.AbstractFabricGroup;
import com.streamscape.sef.dispatcher.AbstractFabricGroupManager;
import com.streamscape.sef.dispatcher.AbstractHTTPServerFabricConnection;
import com.streamscape.sef.dispatcher.AbstractPackage;
import com.streamscape.sef.dispatcher.AbstractPackageDescriptor;
import com.streamscape.sef.dispatcher.AbstractPackageManifestManager;
import com.streamscape.sef.dispatcher.AbstractSchedulerImpl;
import com.streamscape.sef.dispatcher.AbstractSpecialSLSession;
import com.streamscape.sef.dispatcher.AbstractTLPAcceptorFactory;
import com.streamscape.sef.dispatcher.AbstractXMPPFabricConnection;
import com.streamscape.sef.dispatcher.AccessorSessionReferenceImpl;
import com.streamscape.sef.dispatcher.AsyncConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.ComponentReferenceImpl;
import com.streamscape.sef.dispatcher.DataConstraintPersistentStore;
import com.streamscape.sef.dispatcher.DataspaceGranteeManager;
import com.streamscape.sef.dispatcher.DiagnosticSLSessionImpl;
import com.streamscape.sef.dispatcher.DirectConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.DomainConstraintReferenceImpl;
import com.streamscape.sef.dispatcher.DynamicComponentsManager;
import com.streamscape.sef.dispatcher.EndpointReferenceImpl;
import com.streamscape.sef.dispatcher.EntityReferenceImpl;
import com.streamscape.sef.dispatcher.EventCacheReferenceImpl;
import com.streamscape.sef.dispatcher.EventConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.EventFlowMapImpl;
import com.streamscape.sef.dispatcher.ExchangeConsumer;
import com.streamscape.sef.dispatcher.ExchangeConsumerReference;
import com.streamscape.sef.dispatcher.ExchangeDataConstraintStore;
import com.streamscape.sef.dispatcher.ExchangeEventDispatcher;
import com.streamscape.sef.dispatcher.ExchangeEventRequestConsumerImpl;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.ExtendedEventDispatcher;
import com.streamscape.sef.dispatcher.FabricEventAsyncConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventDirectConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventReceiverImpl;
import com.streamscape.sef.dispatcher.FabricEventRequestConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventSourceFactoryImpl;
import com.streamscape.sef.dispatcher.FabricGroupLinkImpl;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.sef.dispatcher.LocalClientComponent;
import com.streamscape.sef.dispatcher.LocalFabricConnection;
import com.streamscape.sef.dispatcher.ModeratorImpl;
import com.streamscape.sef.dispatcher.NetworkExchangeConsumer;
import com.streamscape.sef.dispatcher.PseudoExchangeException;
import com.streamscape.sef.dispatcher.RangeConstraintReferenceImpl;
import com.streamscape.sef.dispatcher.ReceiverReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationEntityReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationSourceReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationTargetReferenceImpl;
import com.streamscape.sef.dispatcher.RequestConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.RuntimeDataConstraintStore;
import com.streamscape.sef.dispatcher.RuntimeDatagramPrototypeFactory;
import com.streamscape.sef.dispatcher.RuntimeExchangeEventPublisher;
import com.streamscape.sef.dispatcher.RuntimeFabricGroup;
import com.streamscape.sef.dispatcher.RuntimeFabricGroupManager;
import com.streamscape.sef.dispatcher.RuntimeRepositoryAccessorImpl;
import com.streamscape.sef.dispatcher.RuntimeSecurityManagerProxy;
import com.streamscape.sef.dispatcher.RuntimeSemanticTypeFactory;
import com.streamscape.sef.dispatcher.SLCompleteRequest;
import com.streamscape.sef.dispatcher.SLStatementWrapper;
import com.streamscape.sef.dispatcher.SLTextWrapper;
import com.streamscape.sef.dispatcher.SecurityManagerImpl;
import com.streamscape.sef.dispatcher.ShowExchangeStateOperation;
import com.streamscape.sef.dispatcher.SysGlobals;
import com.streamscape.sef.dropbox.DropBoxTable;
import com.streamscape.sef.dropbox.DropBoxTableManager;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.ClientThresholdAdvisory;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.exchange.FabricExchange;
import com.streamscape.sef.exchange.FabricExchangeAdvisory;
import com.streamscape.sef.exchange.FabricExchangeException;
import com.streamscape.sef.exchange.FabricExchangeState;
import com.streamscape.sef.exchange.OutOfMemoryErrorHandler;
import com.streamscape.sef.exchange.TopologyLink;
import com.streamscape.sef.group.FabricGroup;
import com.streamscape.sef.group.FabricGroupManagerException;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EntityReference;
import com.streamscape.sef.moderator.EventCacheReference;
import com.streamscape.sef.moderator.EventFlowMap;
import com.streamscape.sef.moderator.ExchangeRole;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.Address;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.tlp.ClientConnectionChannel;
import com.streamscape.sef.network.tlp.Connection;
import com.streamscape.sef.network.tlp.DefaultConnectionStateHandler;
import com.streamscape.sef.network.tlp.PacketHandler;
import com.streamscape.sef.network.tlp.ServerConnectionChannel;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptor;
import com.streamscape.sef.network.tlp.impl.ConnectionChannelFactory;
import com.streamscape.sef.network.tlp.impl.ServerConnectionChannelImpl;
import com.streamscape.sef.network.tlp.impl.TLPPacketHandler;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pkg.PackageManifestException;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.security.Groups;
import com.streamscape.sef.security.Organizations;
import com.streamscape.sef.security.SecurityAdvisory;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.sef.security.UserState;
import com.streamscape.sef.security.Users;
import com.streamscape.sef.utils.RepositoryUtils;
import com.streamscape.sef.utils.SemanticTypeInfo;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.tools.mnode.ManagementNode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.naming.NamingException;

class RuntimeExchange
extends AbstractExchange
implements FabricExchange,
RuntimeExchangeEventPublisher,
OutOfMemoryErrorHandler {
    Scavenger scavenger = new Scavenger();
    boolean anonymousRegistration = true;
    UserState anonymousUser = DEFAULT_ANONYMOUS_USER;
    Long threadMonitorInterval = 60L;
    Long blockedThreadAdvisoryThreshold = 900L;
    Map<String, String> advancedParameters = new HashMap<String, String>();
    UUID fabricUid = UUID.randomUUID();
    Long globalCounter = 0L;
    Map<String, Integer> clientThresholds = null;
    transient long broadcastReplyTimeout = 15L;
    transient long tokenDelay = 10L;
    transient long tokenMonitorInterval = 60L;
    transient long fastFailTimeout = 120L;
    transient boolean webAppTokenAuthentication = true;
    transient long groupEventQueueMaxDepth = 1000L;
    transient long groupEventQueueFlushInterval = 60L;
    transient RuntimeContext context;
    transient AbstractTLPAcceptorFactory acceptorFactory;
    transient MacroProcessor macroProcessor;
    transient DataspaceGranteeManager granteeManager;
    transient Map<FabricAddress, NodeExchangeConnection> nodeConnections;
    transient Map<FabricAddress, ClientExchangeConnection> clientConnections;
    transient Map<Long, DiagnosticExchangeConnection> diagnosticConnections;
    transient Map<Address, ExchangeConnection> unboundConnections;
    transient Map<String, Pair<FabricNode, ExchangeConnection>> disconnectedNodes;
    transient SysplexSynchronizer sysplexSynchronizer;
    transient RoutingTable routingTable;
    transient ShortNumberAllocator nodeNumberAllocator;
    transient ShortNumberAllocator componentNumberAllocator;
    transient ByteNumberAllocator clusterNumberAllocator;
    transient Map<String, Byte> clusterNumbers;
    transient Map<String, Set<String>> clusterNodes;
    transient ClientNetworkEventDispatcher clientDispatcher;
    transient NetworkEventDispatcher networkDispatcher;
    transient Map<String, LocalFabricConnection> tlpFabricConnections;
    transient Map<String, AbstractHTTPServerFabricConnection> httpFabricConnections;
    transient Map<String, AbstractXMPPFabricConnection> xmppFabricConnections;
    transient Map<String, ClientThresholdProcessor> clientThresholdProcessors;
    transient RuntimeFabricGroupManager groupManager;
    transient EventFlowMapImpl eventFlowMap;
    transient long iBroadcastEvent;
    transient BroadcastAckListener broadcastAckListener;
    transient ConcurrentBroadcastAckListener userBroadcastAckListener;
    transient ConcurrentBroadcastAckListener clientBroadcastAckListener;
    transient long clientBroadcastReplyTimeout;
    volatile transient PeerState peerState;
    transient Pair<FabricAddress, ExchangeConnection> joinConnection;
    volatile transient boolean isJoinInProgress = false;
    volatile transient boolean isDetachInProgress = false;
    volatile transient boolean isShuttingDown = false;
    transient Object clientMutex;
    volatile transient boolean isClientConnecting = false;
    transient ThreadMonitor threadMonitor;
    transient boolean outOfMemory = false;
    transient File jarsDir;
    static final int JOIN_ID = 101;
    static final int JOIN_CONFIRM_ID = 102;
    static final int SYNC_LEVEL_1_ID = 103;
    static final int SYNC_LEVEL_2_ID = 104;
    static final int SYNC_LEVEL_3_ID = 105;
    static final int SYNC_LEVEL_1_BACKWARD_ID = 106;
    static final int SYNC_LEVEL_2_BACKWARD_ID = 107;
    static final int SYNC_FORWARD_ID = 108;
    static final int SYNC_LEVEL_1_2_FORWARD_ID = 109;
    static final int NODE_DISCONNECT_CONFIRM_ID = 110;
    static final int NODE_FORCED_DISCONNECT_ID = 111;
    static final int NODE_FORCED_DISCONNECT_CONFIRM_ID = 112;
    static final int ESTABLISH_CONNECTION_ID = 113;
    static final int RELEASE_CONNECTION_ID = 114;
    static final int ADD_ROUTING_LINK_ID = 115;
    static final int REMOVE_ROUTING_LINK_ID = 116;
    static final int UPDATE_GLOBAL_VARIABLES_ID = 117;
    static final int UPDATE_EXCLUSION_LIST_ID = 118;
    static final int UPDATE_SECURITY_ID = 119;
    static final int SET_ANONYMOUS_REGISTRATION_ID = 120;
    static final int ADD_EXTENSION_JAR_ID = 121;
    static final int REMOVE_EXTENSION_JAR_ID = 122;
    static final int ADD_PACKAGE_ID = 123;
    static final int REMOVE_PACKAGE_ID = 124;
    static final int LOAD_PACKAGE_ID = 125;
    static final int UNLOAD_PACKAGE_ID = 126;
    static final int ADD_SEMANTIC_TYPE_ID = 127;
    static final int REMOVE_SEMANTIC_TYPE_ID = 128;
    static final int ADD_EVENT_PROTOTYPE_ID = 129;
    static final int REMOVE_EVENT_PROTOTYPE_ID = 130;
    static final int GET_MANAGEMENT_NODE_OBJECT_ID = 131;
    static final int IS_OWNER_ACTIVE_ID = 132;
    static final int GET_OWNER_COMPONENTS_ID = 133;
    static final int SURVEY_ID = 134;
    static final int TOKEN_RESTART_ID = 135;
    static final int TOKEN_MONITOR_ID = 136;
    static final int ADD_TIME_WINDOW_ID = 137;
    static final int REMOVE_TIME_WINDOW_ID = 138;
    static final int CHANGE_TIME_WINDOW_ID = 139;
    static final int SCHEDULER_OPERATION_ID = 140;
    static final int UPDATE_DIRECTORY_TABLE_ID = 141;
    static final int STATS_MONITOR_OPERATION_ID = 142;
    static final int SLANG_OPERATION_ID = 143;
    static final int SET_ADVANCED_PARAMETER_ID = 144;
    static final int NODE_DETACH_ID = 145;
    static final int CONTAINER_REQUEST_ID = 146;
    static final int ROUTED_CONTAINER_REQUEST_ID = 147;
    static final int API_KEY_REPLICATION_ID = 148;
    static final int CHECK_EVENT_FLOWS_ID = 149;
    static final int SET_TIMEZONE_ID = 150;
    static final int GET_SEMANTIC_TYPE_DEPENDENCIES_ID = 151;
    static final int CHECK_SEMANTIC_TYPE_DEPENDENCIES_ID = 152;
    static final int UPDATE_GLOBAL_COUNTER_ID = 153;
    static final int DROPBOX_TABLE_SYNC_ID = 154;
    static final int DROPBOX_TABLE_SYNC_REQUEST_ID = 155;
    static final int VALIDATE_PACKAGE_ID = 156;
    static final int GET_EXCLUSION_LIST_ID = 157;
    static final int UPDATE_PACKAGE_ID = 158;
    static final int SET_ANONYMOUS_USER_ID = 159;
    static final int ADD_JAR_ID = 160;
    static final int REMOVE_JAR_ID = 161;
    private static final Method JOIN_SYSPLEX_METHOD;
    private static final Method ON_JOIN_REQUEST_METHOD;
    private static final Method DETACH_FROM_SYSPLEX_METHOD;
    private static final Method DETACH_NODE_METHOD;
    private static final Method UNLINK_NODE_METHOD;
    private static final Method EXECUTE_SCAVENGER_METHOD;
    private static final Method ADD_COMPONENT_METHOD;
    private static final Method RE_ADD_COMPONENT_METHOD;
    private static final Method REMOVE_COMPONENT_METHOD;
    private static final Method ADD_CONSUMER_METHOD;
    private static final Method REMOVE_CONSUMER_METHOD;
    private static final Method CHANGE_COMPONENT_METHOD;
    private static final Method CHANGE_CONSUMER_METHOD;
    private static final Method ADD_EVENT_CACHE_METHOD;
    private static final Method REMOVE_EVENT_CACHE_METHOD;
    private static final Method CHANGE_EVENT_CACHE_METHOD;
    private static final Method ADD_DATA_CONSTRAINT_METHOD;
    private static final Method REMOVE_DATA_CONSTRAINT_METHOD;
    private static final Method CHANGE_DATA_CONSTRAINT_METHOD;
    private static final Method ADD_REPLICATION_ENTITY_METHOD;
    private static final Method REMOVE_REPLICATION_ENTITY_METHOD;
    private static final Method CHANGE_REPLICATION_ENTITY_METHOD;
    private static final Method ADD_TIME_WINDOW_METHOD;
    private static final Method REMOVE_TIME_WINDOW_METHOD;
    private static final Method CHANGE_TIME_WINDOW_METHOD;
    private static final Method ON_START_ACCEPTOR_METHOD;
    private static final Method ON_STOP_ACCEPTOR_METHOD;
    private static final Method ADD_EXTENSION_JAR_METHOD;
    private static final Method REMOVE_EXTENSION_JAR_METHOD;
    private static final Method ADD_JAR_METHOD;
    private static final Method REMOVE_JAR_METHOD;
    private static final Method ADD_PACKAGE_METHOD;
    private static final Method UPDATE_PACKAGE_METHOD;
    private static final Method SET_PACKAGE_SCOPE_METHOD;
    private static final Method REMOVE_PACKAGE_METHOD;
    private static final Method LOAD_PACKAGE_METHOD;
    private static final Method UNLOAD_PACKAGE_METHOD;
    private static final Method VALIDATE_PACKAGE_METHOD;
    private static final Method ADD_SEMANTIC_TYPE_METHOD;
    private static final Method REMOVE_SEMANTIC_TYPE_METHOD;
    private static final Method ADD_EVENT_PROTOTYPE_METHOD;
    private static final Method REMOVE_EVENT_PROTOTYPE_METHOD;
    private static final Method UPDATE_GLOBAL_VARIABLES_METHOD;
    private static final Method UPDATE_DIRECTORY_TABLE_METHOD;
    private static final Method UPDATE_SECURITY_METHOD1;
    private static final Method UPDATE_SECURITY_METHOD2;
    private static final Method UPDATE_SECURITY_METHOD3;
    private static final Method SET_ANONYMOUS_REGISTRATION_METHOD;
    private static final Method SET_ANONYMOUS_USER_METHOD;
    private static final Method SET_ADVANCED_PARAMETER_METHOD;
    private static final Method CREATE_GROUP_METHOD;
    private static final Method DROP_GROUP_METHOD;
    private static final Method ADD_GROUP_MEMBER_METHOD;
    private static final Method REMOVE_GROUP_MEMBER_METHOD;
    private static final Method SET_TIMEZONE_METHOD;
    private static final Method NEXT_GLOBAL_COUNT;
    private static final Method SHOW_GLOBAL_COUNTER;
    private static final Method RESET_GLOBAL_COUNTER;
    private static final String EVENT_CACHE_NAMESPACE = "/sys/event/cache/";
    private static final int BROADCAST_PACKET_HEADER_SIZE = 19;
    private static final int BROADCAST_PACKET_SPECIAL_HEADER_SIZE = 17;
    private static final byte[] PSEUDO_EVENT_BYTES;
    private static final SimpleDateFormat TIME_FORMAT;
    private static final AbstractExchange.VersionData PROTOCOL_VERSION;
    private static final SimpleDateFormat DATE_FORMAT;

    private static Method getMethod(String name, Class ... parameterTypes) throws Exception {
        Method result = RuntimeExchange.class.getDeclaredMethod(name, parameterTypes);
        result.setAccessible(true);
        return result;
    }

    RuntimeExchange() {
        this.addDefaultAdvancedParameters();
    }

    protected boolean init(String nodeName, DiscoveryModule discoveryModule, AbstractTLPAcceptorFactory acceptorFactory) throws Exception {
        boolean needSave = super.init();
        needSave |= this.initAdvancedParameters();
        if (this.fabricUid == null) {
            this.fabricUid = UUID.randomUUID();
            needSave = true;
        }
        if (this.globalCounter == null) {
            this.globalCounter = 0L;
            needSave = true;
        }
        if (needSave) {
            this.context.saveExchange();
        }
        this.printParameters();
        this.acceptorFactory = acceptorFactory;
        this.acceptorFactory.setConnectionFactory(this.connectionFactory);
        this.node = new FabricNode(this, nodeName, this.context.getNodeRole(), new ContextId(new FabricAddress()), this.resolveAdvancedParameter("nodeWeight"));
        this.moderator = new ModeratorImpl(this);
        this.dispatcher = new ExchangeEventDispatcher(this);
        this.clientDispatcher = new ClientNetworkEventDispatcher(this);
        this.networkDispatcher = new NetworkEventDispatcher();
        this.nodeConnections = new ConcurrentHashMap<FabricAddress, NodeExchangeConnection>();
        this.clientConnections = new ConcurrentHashMap<FabricAddress, ClientExchangeConnection>();
        this.diagnosticConnections = new ConcurrentHashMap<Long, DiagnosticExchangeConnection>();
        this.unboundConnections = new ConcurrentHashMap<Address, ExchangeConnection>();
        this.disconnectedNodes = new ConcurrentHashMap<String, Pair<FabricNode, ExchangeConnection>>();
        this.routingTable = new RoutingTable(this);
        this.nodeNumberAllocator = new ShortNumberAllocator();
        this.componentNumberAllocator = new ShortNumberAllocator();
        if (this.isClustered()) {
            this.clusterNumberAllocator = new ByteNumberAllocator();
            this.clusterNumbers = new ConcurrentHashMap<String, Byte>();
            this.clusterNumbers.put(this.context.getClusterName(), (byte)0);
            this.clusterNodes = new ConcurrentHashMap<String, Set<String>>();
        }
        this.tlpFabricConnections = new ConcurrentHashMap<String, LocalFabricConnection>();
        this.httpFabricConnections = new ConcurrentHashMap<String, AbstractHTTPServerFabricConnection>();
        this.xmppFabricConnections = new ConcurrentHashMap<String, AbstractXMPPFabricConnection>();
        this.clientThresholdProcessors = new ConcurrentHashMap<String, ClientThresholdProcessor>();
        this.groupManager = new RuntimeFabricGroupManager(this);
        this.eventFlowMap = new EventFlowMapImpl(this);
        this.broadcastAckListener = new NodeBroadcastAckListener(0);
        this.userBroadcastAckListener = new ConcurrentBroadcastAckListener();
        this.clientBroadcastAckListener = new ConcurrentBroadcastAckListener();
        this.addInternalEventListener(49, this.broadcastAckListener);
        this.addInternalEventListener(51, this.userBroadcastAckListener);
        this.addInternalEventListener(50, this.clientBroadcastAckListener);
        this.setClientBroadcastReplyTimeout();
        this.peerState = PeerState.UNDEFINED;
        this.sysplexSynchronizer = new SysplexSynchronizer();
        this.clientMutex = new Object();
        this.setThreadMonitor(false);
        this.setAccessorMonitor(false);
        this.initEventCaches();
        this.jarsDir = FileIOUtils.newFileDir(this.context.getFileInStartupDir(".libs").getPath());
        return needSave;
    }

    @Override
    boolean initConfigurationParameters() throws FabricExchangeException {
        boolean needSave = super.initConfigurationParameters();
        if (this.scavenger == null) {
            this.scavenger = new Scavenger();
        }
        this.scavenger.init(this);
        if (this.scavenger.reconnectInterval == null) {
            needSave = this.logWarningOnNullParameter("scavenger.reconnectInterval", 30L);
            this.scavenger.reconnectInterval = 30L;
        }
        this.checkScavengerReconnectInterval(this.scavenger.reconnectInterval);
        if (this.threadMonitorInterval == null) {
            needSave = this.logWarningOnNullParameter("threadMonitorInterval", 60L);
            this.threadMonitorInterval = 60L;
        }
        if (this.blockedThreadAdvisoryThreshold == null) {
            needSave = this.logWarningOnNullParameter("blockedThreadAdvisoryThreshold", 900L);
            this.blockedThreadAdvisoryThreshold = 900L;
        }
        if (this.anonymousUser == null) {
            needSave = this.logWarningOnNullParameter("anonymousUser", (Object)DEFAULT_ANONYMOUS_USER);
            this.anonymousUser = DEFAULT_ANONYMOUS_USER;
        }
        if (this.clientThresholds != null && this.clientThresholds.isEmpty()) {
            this.clientThresholds = null;
            needSave = true;
        }
        return needSave;
    }

    private boolean initAdvancedParameters() throws FabricExchangeException {
        this.macroProcessor = new MacroProcessor();
        boolean needSave = false;
        if (this.advancedParameters == null) {
            this.advancedParameters = new HashMap<String, String>();
            this.addDefaultAdvancedParameters();
            needSave = true;
        }
        if (!this.isAllAdvancedParametersSet()) {
            needSave = true;
        }
        this.connectionTimeout = this.initPositiveParameter("connectionTimeout", 10L) * 1000L;
        this.replyTimeout = this.initPositiveParameter("replyTimeout", 10L) * 1000L;
        this.fastReplyTimeout = this.initPositiveParameter("fastReplyTimeout", 5L) * 1000L;
        this.longReplyTimeout = this.initPositiveParameter("longReplyTimeout", 30L) * 1000L;
        this.broadcastReplyTimeout = this.initPositiveParameter("broadcastReplyTimeout", 15L) * 1000L;
        this.tokenDelay = this.initPositiveParameter("tokenDelay", 10L);
        this.tokenMonitorInterval = this.initPositiveParameter("tokenMonitorInterval", 60L) * 1000L;
        this.fastFailTimeout = this.initParameter("fastFailTimeout", 120L) * 1000L;
        this.accessorMonitorInterval = this.initParameter("accessorMonitorInterval", 60L);
        this.initParameter("accessorPoolSize", -1L);
        this.initParameter("accessorPoolExpirationTimeout", -1L);
        this.initParameter("nodeWeight", 0L, NumericParameterType.NON_NEGATIVE);
        this.webAppTokenAuthentication = this.initParameter("webAppTokenAuthentication", true);
        this.groupEventQueueMaxDepth = this.initPositiveParameter("groupEventQueueMaxDepth", 1000L);
        this.groupEventQueueFlushInterval = this.initPositiveParameter("groupEventQueueFlushInterval", 60L) * 1000L;
        return needSave;
    }

    private void addDefaultAdvancedParameters() {
        this.advancedParameters.put("connectionTimeout", Long.toString(10L));
        this.advancedParameters.put("replyTimeout", Long.toString(10L));
        this.advancedParameters.put("fastReplyTimeout", Long.toString(5L));
        this.advancedParameters.put("longReplyTimeout", Long.toString(30L));
        this.advancedParameters.put("broadcastReplyTimeout", Long.toString(15L));
        this.advancedParameters.put("tokenDelay", Long.toString(10L));
        this.advancedParameters.put("tokenMonitorInterval", Long.toString(60L));
        this.advancedParameters.put("fastFailTimeout", Long.toString(120L));
        this.advancedParameters.put("accessorMonitorInterval", Long.toString(60L));
        this.advancedParameters.put("accessorPoolSize", Long.toString(-1L));
        this.advancedParameters.put("accessorPoolExpirationTimeout", Long.toString(-1L));
        this.advancedParameters.put("nodeWeight", Long.toString(0L));
        this.advancedParameters.put("webAppTokenAuthentication", Boolean.toString(true));
    }

    private boolean isAllAdvancedParametersSet() {
        return this.advancedParameters.containsKey("connectionTimeout") && this.advancedParameters.containsKey("replyTimeout") && this.advancedParameters.containsKey("fastReplyTimeout") && this.advancedParameters.containsKey("longReplyTimeout") && this.advancedParameters.containsKey("broadcastReplyTimeout") && this.advancedParameters.containsKey("tokenDelay") && this.advancedParameters.containsKey("tokenMonitorInterval") && this.advancedParameters.containsKey("fastFailTimeout") && this.advancedParameters.containsKey("accessorPoolSize") && this.advancedParameters.containsKey("accessorPoolExpirationTimeout") && this.advancedParameters.containsKey("accessorMonitorInterval") && this.advancedParameters.containsKey("nodeWeight") && this.advancedParameters.containsKey("webAppTokenAuthentication");
    }

    private long initParameter(String name, long defaultValue, NumericParameterType type) throws FabricExchangeException {
        String value = this.advancedParameters.get(name);
        if (value == null) {
            this.logWarningOnNullParameter(name, defaultValue, true);
            this.advancedParameters.put(name, Long.toString(defaultValue));
            return defaultValue;
        }
        return this.resolveAdvancedParameter(name, value, type);
    }

    private boolean initParameter(String name, boolean defaultValue) throws FabricExchangeException {
        String value = this.advancedParameters.get(name);
        if (value == null) {
            this.logWarningOnNullParameter(name, defaultValue, true);
            this.advancedParameters.put(name, Boolean.toString(defaultValue));
            return defaultValue;
        }
        return this.resolveAdvancedParameter(name, value);
    }

    private long initParameter(String name, long defaultValue) throws FabricExchangeException {
        return this.initParameter(name, defaultValue, NumericParameterType.ANY);
    }

    private long initPositiveParameter(String name, long defaultValue) throws FabricExchangeException {
        return this.initParameter(name, defaultValue, NumericParameterType.POSITIVE);
    }

    @Override
    public int getScavengerReconnectAttempts() {
        return this.scavenger.reconnectAttempts;
    }

    @Override
    public synchronized void setScavengerReconnectAttempts(int reconnectAttempts) {
        if (this.scavenger.reconnectAttempts != reconnectAttempts) {
            this.scavenger.setReconnectAttempts(reconnectAttempts);
            this.context.saveExchange();
        }
    }

    @Override
    public long getScavengerReconnectInterval() {
        return this.scavenger.reconnectInterval;
    }

    @Override
    public synchronized void setScavengerReconnectInterval(long reconnectInterval) throws FabricExchangeException {
        this.checkScavengerReconnectInterval(reconnectInterval);
        if (this.scavenger.reconnectInterval != reconnectInterval) {
            this.scavenger.setReconnectInterval(reconnectInterval);
            this.context.saveExchange();
        }
    }

    private void checkScavengerReconnectInterval(long interval) throws FabricExchangeException {
        if (interval <= 0L) {
            throw new FabricExchangeException(6007, "Scavenger reconnect interval must be positive.");
        }
    }

    @Override
    public boolean anonymousRegistration() {
        return this.anonymousRegistration;
    }

    @Override
    public void setAnonymousRegistration(boolean anonymousRegistration) throws FabricExchangeException {
        try {
            this.sysplexSynchronizer.invoke(SET_ANONYMOUS_REGISTRATION_METHOD, anonymousRegistration);
        }
        catch (Exception exception) {
            if (exception instanceof FabricExchangeException) {
                throw (FabricExchangeException)exception;
            }
            throw new FabricExchangeException(6011, "Unexpected exception", exception);
        }
    }

    private void doSetAnonymousRegistration(boolean anonymousRegistration) throws FabricExchangeException {
        if (this.anonymousRegistration != anonymousRegistration) {
            if (this.inSysplex() && !this.context.securityContext.getUser().isAdministrator()) {
                throw new FabricExchangeException(6092, "User '" + this.context.getUserName() + "' has insufficient rights to change 'anonymousRegistration' parameter.");
            }
            this.doSetAnonymousRegistrationCore(anonymousRegistration);
            this.broadcastWithAckToNodes(120, anonymousRegistration);
        }
    }

    private void doSetAnonymousRegistrationCore(boolean anonymousRegistration) {
        this.anonymousRegistration = anonymousRegistration;
        this.context.saveExchange();
    }

    @Override
    public UserState getAnonymousUser() {
        return this.anonymousUser;
    }

    @Override
    public void setAnonymousUser(UserState anonymousUser) throws FabricExchangeException {
        try {
            this.sysplexSynchronizer.invoke(SET_ANONYMOUS_USER_METHOD, new Object[]{anonymousUser});
        }
        catch (Exception exception) {
            if (exception instanceof FabricExchangeException) {
                throw (FabricExchangeException)exception;
            }
            throw new FabricExchangeException(6011, "Unexpected exception", exception);
        }
    }

    private void doSetAnonymousUser(UserState anonymousUser) throws FabricExchangeException {
        if (this.anonymousUser != anonymousUser) {
            if (this.inSysplex() && !this.context.securityContext.getUser().isAdministrator()) {
                throw new FabricExchangeException(6092, "User '" + this.context.getUserName() + "' has insufficient rights to change 'anonymousUser' parameter.");
            }
            if (anonymousUser != UserState.ENABLED && anonymousUser != UserState.DISABLED) {
                throw new FabricExchangeException(6007, "Invalid value '" + String.valueOf((Object)anonymousUser) + "' for parameter 'anonymousUser'.");
            }
            this.doSetAnonymousUserCore(anonymousUser);
            this.broadcastWithAckToNodes(159, (Object)anonymousUser);
        }
    }

    private void doSetAnonymousUserCore(UserState anonymousUser) {
        this.anonymousUser = anonymousUser;
        this.context.saveExchange();
    }

    @Override
    public long getThreadMonitorInterval() {
        return this.threadMonitorInterval;
    }

    @Override
    public synchronized void setThreadMonitorInterval(long monitorInterval) {
        if (this.threadMonitorInterval != monitorInterval && (this.threadMonitorInterval > 0L || monitorInterval > 0L)) {
            if (this.threadMonitorInterval > 0L && monitorInterval <= 0L) {
                this.logWarning("Parameter 'threadMonitorInterval' is non-positive. Thread monitor will be disabled.");
            }
            this.threadMonitorInterval = monitorInterval;
            this.setThreadMonitor(true);
            this.context.saveExchange();
        }
    }

    private void setThreadMonitor(boolean start) {
        try {
            if (this.threadMonitor != null) {
                if (this.threadMonitorInterval <= 0L) {
                    this.destroyThreadMonitor();
                } else {
                    this.threadMonitor.setTimeout(this.threadMonitorInterval * 1000L);
                }
            } else if (this.threadMonitorInterval > 0L) {
                this.threadMonitor = new ThreadMonitor(this.threadMonitorInterval * 1000L);
                if (start) {
                    this.threadMonitor.start();
                }
            }
        }
        catch (FabricException fabricException) {
            // empty catch block
        }
    }

    private void destroyThreadMonitor() {
        if (this.threadMonitor != null) {
            this.threadMonitor.stop();
            this.threadMonitor = null;
        }
    }

    @Override
    public long getBlockedThreadAdvisoryThreshold() {
        return this.blockedThreadAdvisoryThreshold;
    }

    @Override
    public synchronized void setBlockedThreadAdvisoryThreshold(long advisoryThreshold) {
        if (this.blockedThreadAdvisoryThreshold != advisoryThreshold && (this.blockedThreadAdvisoryThreshold > 0L || advisoryThreshold > 0L)) {
            if (this.blockedThreadAdvisoryThreshold > 0L && advisoryThreshold <= 0L) {
                this.logWarning("Parameter 'blockedThreadAdvisoryThreshold' is non-positive. Raising of BlockedThreadAdvisory will be disabled.");
            }
            this.blockedThreadAdvisoryThreshold = advisoryThreshold;
            this.context.saveExchange();
        }
    }

    @Override
    public Map<String, Integer> getClientThresholds() {
        return this.clientThresholds != null ? new HashMap<String, Integer>(this.clientThresholds) : null;
    }

    @Override
    public synchronized void setClientThresholds(Map<String, Integer> thresholds) throws FabricExchangeException {
        if (thresholds == null || thresholds.isEmpty()) {
            if (this.clientThresholds != null) {
                this.clientThresholds = null;
                this.clientThresholdProcessors.clear();
                this.context.saveExchange();
            }
        } else {
            boolean needSave = false;
            if (this.clientThresholds == null) {
                this.clientThresholds = new HashMap<String, Integer>();
            }
            for (Map.Entry<String, Integer> entry : thresholds.entrySet()) {
                String protocol = this.checkClientProtocol(entry.getKey());
                int threshold = this.checkClientThreshold(entry.getValue());
                if (threshold > 0) {
                    if (!this.clientThresholds.containsKey(protocol)) {
                        needSave = this.updateClientThreshold(() -> this.addClientThreshold(protocol, threshold));
                        continue;
                    }
                    if (this.clientThresholds.get(protocol) == threshold) continue;
                    needSave = this.updateClientThreshold(() -> this.addClientThreshold(protocol, threshold));
                    continue;
                }
                if (!this.clientThresholds.containsKey(protocol)) continue;
                needSave = this.updateClientThreshold(() -> {
                    this.clientThresholds.remove(protocol);
                    this.clientThresholdProcessors.remove(protocol);
                });
            }
            if (this.clientThresholds.isEmpty()) {
                this.clientThresholds = null;
            }
            if (needSave) {
                this.context.saveExchange();
            }
        }
    }

    private String checkClientProtocol(String protocol) throws FabricExchangeException {
        if (protocol != null && (protocol.equals("*") || protocol.equalsIgnoreCase("TLP") || protocol.equalsIgnoreCase("HTTP") || protocol.equalsIgnoreCase("XMPP"))) {
            return protocol.toUpperCase();
        }
        throw new FabricExchangeException(6007, "Invalid protocol '" + protocol + "' in parameter 'clientThresholds'.");
    }

    private int checkClientThreshold(Integer threshold) throws FabricExchangeException {
        if (threshold != null) {
            return threshold;
        }
        throw new FabricExchangeException(6004, "Null threshold in parameter 'clientThresholds'.");
    }

    private void addClientThreshold(String protocol, Integer threshold) {
        this.clientThresholds.put(protocol, threshold);
        this.clientThresholdProcessors.put(protocol, new ClientThresholdProcessor(protocol, threshold));
    }

    private boolean updateClientThreshold(Runnable updater) {
        updater.run();
        return true;
    }

    private synchronized String getClientThresholdsString() {
        if (this.clientThresholds == null) {
            return "n/a";
        }
        StringBuilder builder = new StringBuilder();
        this.addThreshold("*", builder);
        this.addThreshold("TLP", builder);
        this.addThreshold("HTTP", builder);
        this.addThreshold("XMPP", builder);
        builder.deleteCharAt(builder.lastIndexOf(","));
        return builder.toString();
    }

    private void addThreshold(String protocol, StringBuilder result) {
        if (this.clientThresholds.containsKey(protocol)) {
            result.append(protocol).append(":").append(this.clientThresholds.get(protocol)).append(',');
        }
    }

    @Override
    public synchronized String getAdvancedParameter(String name) {
        return this.advancedParameters.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAdvancedParameter(String name, String newValue) throws FabricExchangeException {
        String oldValue = this.getAdvancedParameter(name);
        if (oldValue == null) {
            throw new FabricExchangeException(6008, "Unknown Exchange parameter '" + name + "'.");
        }
        RuntimeExchange runtimeExchange = this;
        synchronized (runtimeExchange) {
            if (name.equals("connectionTimeout")) {
                if (!oldValue.equals(newValue)) {
                    this.connectionTimeout = this.resolvePositiveAdvancedParameter(name, newValue) * 1000L;
                    this.saveAdvancedParameter(name, newValue);
                }
                return;
            }
            if (name.equals("tokenMonitorInterval")) {
                if (!oldValue.equals(newValue)) {
                    this.tokenMonitorInterval = this.resolvePositiveAdvancedParameter(name, newValue) * 1000L;
                    this.sysplexSynchronizer.setTokenMonitorInterval(this.tokenMonitorInterval, true);
                    this.saveAdvancedParameter(name, newValue);
                }
                return;
            }
            if (name.equals("fastFailTimeout")) {
                if (!oldValue.equals(newValue)) {
                    this.fastFailTimeout = this.resolveAdvancedParameter(name, newValue, NumericParameterType.ANY) * 1000L;
                    this.sysplexSynchronizer.setTokenMonitorInterval(this.fastFailTimeout, false);
                    this.saveAdvancedParameter(name, newValue);
                }
                return;
            }
            if (name.equals("accessorMonitorInterval")) {
                if (!oldValue.equals(newValue)) {
                    this.accessorMonitorInterval = this.resolveAdvancedParameter(name, newValue, NumericParameterType.ANY);
                    this.setAccessorMonitor(true);
                    this.saveAdvancedParameter(name, newValue);
                }
                return;
            }
            if (name.equals("accessorPoolSize") || name.equals("accessorPoolExpirationTimeout")) {
                if (!oldValue.equals(newValue)) {
                    this.saveAdvancedParameter(name, newValue);
                }
                return;
            }
            if (name.equals("groupEventQueueMaxDepth")) {
                if (!oldValue.equals(newValue)) {
                    this.groupEventQueueMaxDepth = this.resolvePositiveAdvancedParameter(name, newValue);
                }
                return;
            }
            if (name.equals("groupEventQueueFlushInterval")) {
                if (!oldValue.equals(newValue)) {
                    this.groupEventQueueFlushInterval = this.resolvePositiveAdvancedParameter(name, newValue) * 1000L;
                }
                return;
            }
        }
        try {
            this.sysplexSynchronizer.invoke(SET_ADVANCED_PARAMETER_METHOD, name, newValue);
        }
        catch (Exception exception) {
            if (exception instanceof FabricExchangeException) {
                throw (FabricExchangeException)exception;
            }
            throw new FabricExchangeException(6011, "Unexpected exception", exception);
        }
    }

    private void doSetAdvancedParameter(String name, String newValue) throws FabricExchangeException {
        String oldValue = this.advancedParameters.get(name);
        if (oldValue == null) {
            throw new FabricExchangeException(6008, "Unknown Exchange parameter '" + name + "'.");
        }
        if (!oldValue.equals(newValue)) {
            if (this.inSysplex() && !this.context.securityContext.getUser().isAdministrator()) {
                throw new FabricExchangeException(6092, "User '" + this.context.getUserName() + "' has insufficient rights to change '" + name + "' parameter.");
            }
            long resolvedValue = name.equals("webAppTokenAuthentication") ? RuntimeExchange.toLong(this.resolveAdvancedParameter(name, newValue)) : this.resolveAdvancedParameter(name, newValue, name.equals("nodeWeight") ? NumericParameterType.NON_NEGATIVE : NumericParameterType.POSITIVE);
            this.doSetAdvancedParameterCore(name, newValue, resolvedValue, null);
            this.broadcastWithAckToNodes(144, new SetAdvancedParameterData(name, newValue, resolvedValue));
        }
    }

    private void doSetAdvancedParameterCore(String name, String value, long resolvedValue, FabricAddress sourceAddress) {
        if (name.equals("nodeWeight")) {
            if (sourceAddress == null) {
                this.node.setWeight(resolvedValue);
                this.saveAdvancedParameter(name, value);
            } else {
                FabricNode fabricNode = this.getFabricNode(sourceAddress);
                if (sourceAddress != null) {
                    fabricNode.setWeight(resolvedValue);
                }
            }
        } else {
            if (name.equals("replyTimeout")) {
                this.replyTimeout = resolvedValue * 1000L;
            } else if (name.equals("fastReplyTimeout")) {
                this.fastReplyTimeout = resolvedValue * 1000L;
            } else if (name.equals("longReplyTimeout")) {
                this.longReplyTimeout = resolvedValue * 1000L;
            } else if (name.equals("broadcastReplyTimeout")) {
                this.broadcastReplyTimeout = resolvedValue * 1000L;
                this.setClientBroadcastReplyTimeout();
            } else if (name.equals("tokenDelay")) {
                this.tokenDelay = resolvedValue;
            } else if (name.equals("webAppTokenAuthentication")) {
                this.webAppTokenAuthentication = RuntimeExchange.toBoolean(resolvedValue);
            }
            this.saveAdvancedParameter(name, value);
        }
    }

    private void saveAdvancedParameter(String name, String value) {
        this.advancedParameters.put(name, value);
        this.context.saveExchange();
    }

    @Override
    public synchronized List<String> listAdvancedParameters() {
        return new ArrayList<String>(this.advancedParameters.keySet());
    }

    private long resolvePositiveAdvancedParameter(String name, String value) throws FabricExchangeException {
        return this.resolveAdvancedParameter(name, value, NumericParameterType.POSITIVE);
    }

    private long resolveAdvancedParameter(String name, String value, NumericParameterType type) throws FabricExchangeException {
        value = this.macroProcessor.process(value);
        try {
            long result = Long.parseLong(value);
            type.validate(name, result);
            return result;
        }
        catch (NumberFormatException exception) {
            throw new FabricExchangeException(6006, "Parameter '" + name + "' has invalid format.", exception);
        }
    }

    private long resolveAdvancedParameter(String name) {
        return Long.parseLong(this.macroProcessor.process(this.advancedParameters.get(name)));
    }

    private boolean resolveAdvancedParameter(String name, String value) throws FabricExchangeException {
        return Boolean.parseBoolean(this.macroProcessor.process(value));
    }

    private static long toLong(boolean value) {
        return value ? 1L : 0L;
    }

    private static boolean toBoolean(long value) {
        return value != 0L;
    }

    private boolean synchronizeAdvancedParameters(Map<String, String> parameters) {
        boolean needSave = false;
        long value = this.updateParameter("replyTimeout", parameters);
        if (value > 0L) {
            this.replyTimeout = value * 1000L;
            needSave = true;
        }
        if ((value = this.updateParameter("fastReplyTimeout", parameters)) > 0L) {
            this.fastReplyTimeout = value * 1000L;
            needSave = true;
        }
        if ((value = this.updateParameter("longReplyTimeout", parameters)) > 0L) {
            this.longReplyTimeout = value * 1000L;
            needSave = true;
        }
        if ((value = this.updateParameter("broadcastReplyTimeout", parameters)) > 0L) {
            this.broadcastReplyTimeout = value * 1000L;
            this.setClientBroadcastReplyTimeout();
            needSave = true;
        }
        if ((value = this.updateParameter("tokenDelay", parameters)) > 0L) {
            this.tokenDelay = value;
            needSave = true;
        }
        return needSave;
    }

    private long updateParameter(String name, Map<String, String> newParameters) {
        String oldValue = this.advancedParameters.get(name);
        String newValue = newParameters.get(name);
        if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
            this.advancedParameters.put(name, newValue);
            try {
                return Long.parseLong(this.macroProcessor.process(newValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    private void printParameters() {
        List<ConfigurationParameter> parameters = this.getConfigurationParameters();
        int maxNameLength = 0;
        int maxValueLength = 0;
        for (ConfigurationParameter parameter : parameters) {
            if (parameter.name.length() > maxNameLength) {
                maxNameLength = parameter.name.length();
            }
            if (parameter.value.length() <= maxValueLength) continue;
            maxValueLength = parameter.value.length();
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(buffer);
        char[] borderArray = new char[maxNameLength + maxValueLength + 3];
        Arrays.fill(borderArray, '-');
        String border = new String(borderArray);
        String format = "\t%1$-" + maxNameLength + "s   %2$s \n";
        stream.println("\t" + border);
        for (ConfigurationParameter parameter : parameters) {
            stream.printf(format, parameter.name, parameter.value);
        }
        stream.println("\t" + border);
        stream.close();
        this.logInfo("Fabric Exchange parameters:\n" + buffer.toString());
    }

    List<ConfigurationParameter> getConfigurationParameters() {
        ArrayList<ConfigurationParameter> parameters = new ArrayList<ConfigurationParameter>();
        Object accessorPoolExpirationTimeout = this.getAdvancedParameter("accessorPoolExpirationTimeout");
        if (Long.parseLong((String)accessorPoolExpirationTimeout) > 0L) {
            accessorPoolExpirationTimeout = (String)accessorPoolExpirationTimeout + " seconds";
        }
        RuntimeExchange.addParameter("anonymousRegistration", this.anonymousRegistration, true, "Enables or disables anonymous registration of new users.", parameters);
        RuntimeExchange.addParameter("anonymousUser", (Object)this.anonymousUser, true, "Initial state of anonymously registered users.", parameters);
        RuntimeExchange.addParameter("replyTimeout", this.replyTimeout / 1000L, "seconds", true, "Waiting time for reply for internal standard requests.", parameters);
        RuntimeExchange.addParameter("fastReplyTimeout", this.fastReplyTimeout / 1000L, "seconds", true, "Waiting time for reply for internal fast requests.", parameters);
        RuntimeExchange.addParameter("longReplyTimeout", this.longReplyTimeout / 1000L, "seconds", true, "Waiting time for reply for internal long requests.", parameters);
        RuntimeExchange.addParameter("broadcastReplyTimeout", this.broadcastReplyTimeout / 1000L, "seconds", true, "Waiting time for reply for internal broadcast requests.", parameters);
        RuntimeExchange.addParameter("tokenDelay", this.tokenDelay, "milliseconds", true, "Delay (in milliseconds) before passing the synchronization token to the next node.", parameters);
        RuntimeExchange.addParameter("webAppTokenAuthentication", this.webAppTokenAuthentication, true, "Enables or disables user authentication with a Web Application Token.", parameters);
        RuntimeExchange.addParameter("workerPoolSize", this.workerPoolSize, false, "Size of the main thread pool (number of threads in the pool).", parameters);
        RuntimeExchange.addParameter("workerPoolType", (Object)this.workerPoolType, false, "Type of the main thread pool.", parameters);
        RuntimeExchange.addParameter("systemWorkerPoolSize", this.systemWorkerPoolSize, false, "Size of the internal thread pool (number of thread in the pool).", parameters);
        RuntimeExchange.addParameter("systemWorkerPoolType", (Object)this.systemWorkerPoolType, false, "Type of the internal thread pool.", parameters);
        RuntimeExchange.addParameter("scavenger.reconnectAttempts", this.scavenger.reconnectAttempts, false, "Number of reconnect attempts which will be made by the Scavenger thread.\nZero value means that the Scavenger will not attempt to reconnect.\nNegative value means that the Scavenger will try to reconnect infinitely (until successful connection).", parameters);
        RuntimeExchange.addParameter("scavenger.reconnectInterval", this.scavenger.reconnectInterval, "seconds", false, "Time between successive reconnect attempts which will be made by the Scavenger thread.", parameters);
        RuntimeExchange.addParameter("threadMonitorInterval", this.threadMonitorInterval, "seconds", false, "Time between iterations in the monitor that observes a state of the JVM threads.\nNon-positive value means that this monitor is disabled.", parameters);
        RuntimeExchange.addParameter("blockedThreadAdvisoryThreshold", this.blockedThreadAdvisoryThreshold, "seconds", false, "Timeout for a blocked thread, after which [advisory.BlockedThread] advisory is raised.\nNon-positive value means that the advisory will not be raised.", parameters);
        RuntimeExchange.addParameter("connectionTimeout", this.connectionTimeout / 1000L, "seconds", false, "Waiting time for establishing outgoing connections.", parameters);
        RuntimeExchange.addParameter("tokenMonitorInterval", this.tokenMonitorInterval / 1000L, "seconds", false, "Time between iterations in the monitor that observes a state of the synchronization token.", parameters);
        RuntimeExchange.addParameter("fastFailTimeout", this.fastFailTimeout / 1000L, "seconds", false, "Waiting time for a synchronization token before moving the node to a standalone mode).", parameters);
        RuntimeExchange.addParameter("accessorMonitorInterval", this.accessorMonitorInterval, "seconds", false, "Time between successive repeats in the monitor which observes a state of accessors in the node.\nNon-positive value means that this monitor is disabled.", parameters);
        RuntimeExchange.addParameter("accessorPoolSize", this.getAdvancedParameter("accessorPoolSize"), false, "Maximum number of accessors in the pool of a component (dataspace or service).\nSuch pools are used in RPL scripts. Non-positive value means that the pool is not be used.", parameters);
        RuntimeExchange.addParameter("accessorPoolExpirationTimeout", accessorPoolExpirationTimeout, false, "Waiting time before closing an idle accessor in the pool.\nNon-positive value means that idle accessors in the pool will not be closed.", parameters);
        RuntimeExchange.addParameter("nodeWeight", this.getAdvancedParameter("nodeWeight"), false, "Weight of the node in Sysplex. It specifies a priority of the node in various situations.\nParticularly, it is used by accessors to select a specific node if the node name is not specified.", parameters);
        RuntimeExchange.addParameter("clientThresholds", this.getClientThresholdsString(), false, "Set of thresholds for the number of external (remote) clients currently connected to the node.\nUpon reaching the threshold, the advisory [advisory.fabric.ClientThreshold] is raised.\nSupported protocol values are TLP, HTTP, XMPP and * (means any client).\nNon-positive threshold value means that the advisory will not be raised for the specified protocol.", parameters);
        return parameters;
    }

    private static void addParameter(String name, Object value, List<ConfigurationParameter> parameters) {
        RuntimeExchange.addParameter(name, value, false, null, parameters);
    }

    private static void addParameter(String name, Object value, String description, List<ConfigurationParameter> parameters) {
        RuntimeExchange.addParameter(name, value, false, description, parameters);
    }

    private static void addParameter(String name, Object value, boolean global, String description, List<ConfigurationParameter> parameters) {
        parameters.add(new ConfigurationParameter(name, value != null ? value.toString() : null, global, description));
    }

    private static void addParameter(String name, Object value, String suffix, boolean global, String description, List<ConfigurationParameter> parameters) {
        parameters.add(new ConfigurationParameter(name, (String)(value != null ? value.toString() + " " : " ") + suffix, global, description));
    }

    void setClientBroadcastReplyTimeout() {
        this.clientBroadcastReplyTimeout = Math.max(this.broadcastReplyTimeout / 2L, this.fastReplyTimeout);
    }

    @Override
    void addInternalListeners() {
        this.addInternalEventListener(102, new JoinConfirmEventListener());
        this.addInternalEventListener(106, new SyncLevel1BackwardEventListener());
        this.addInternalEventListener(107, new SyncLevel2BackwardEventListener());
        this.addInternalEventListener(109, new SyncLevel12ForwardEventListener());
        this.addInternalEventListener(105, new SyncLevel3EventListener());
        this.addInternalEventListener(5, new NodeDisconnectEventListener());
        this.addInternalEventListener(110, new NodeDisconnectConfirmEventListener());
        this.addInternalEventListener(111, new NodeForcedDisconnectEventListener());
        this.addInternalEventListener(112, new NodeForcedDisconnectConfirmEventListener());
        this.addInternalEventListener(115, new AddRoutingLinkEventListener());
        this.addInternalEventListener(116, new RemoveRoutingLinkEventListener());
        this.addInternalEventListener(8, new AddEndpointEventListener());
        this.addInternalEventListener(9, new RemoveEndpointEventListener());
        this.addInternalEventListener(10, new AddComponentEventListener());
        this.addInternalEventListener(11, new ChangeComponentEventListener());
        this.addInternalEventListener(12, new ChangeConsumerEventListener());
        this.addInternalEventListener(13, new ChangeEventCacheEventListener());
        this.addInternalEventListener(18, new AddDataConstraintEventListener());
        this.addInternalEventListener(19, new RemoveDataConstraintEventListener());
        this.addInternalEventListener(20, new ChangeDataConstraintEventListener());
        this.addInternalEventListener(117, new UpdateGlobalVariablesEventListener());
        this.addInternalEventListener(120, new SetAnonymousRegistrationEventListener());
        this.addInternalEventListener(159, new SetAnonymousUserEventListener());
        this.addInternalEventListener(35, new RuntimeStartAcceptorEventListener());
        this.addInternalEventListener(36, new RuntimeStopAcceptorEventListener());
        this.addInternalEventListener(121, new AddExtensionJarEventListener());
        this.addInternalEventListener(122, new RemoveExtensionJarEventListener());
        this.addInternalEventListener(160, new AddJarEventListener());
        this.addInternalEventListener(161, new RemoveJarEventListener());
        this.addInternalEventListener(123, new AddPackageEventListener());
        this.addInternalEventListener(124, new RemovePackageEventListener());
        this.addInternalEventListener(125, new LoadPackageEventListener());
        this.addInternalEventListener(126, new UnloadPackageEventListener());
        this.addInternalEventListener(156, new ValidatePackageEventListener());
        this.addInternalEventListener(127, new AddSemanticTypeEventListener());
        this.addInternalEventListener(128, new RemoveSemanticTypeEventListener());
        this.addInternalEventListener(129, new AddEventPrototypeEventListener());
        this.addInternalEventListener(130, new RemoveEventPrototypeEventListener());
        this.addInternalEventListener(24, new AddReplicationEntityEventListener());
        this.addInternalEventListener(25, new RemoveReplicationEntityEventListener());
        this.addInternalEventListener(26, new ChangeReplicationEntityEventListener());
        this.addInternalEventListener(137, new AddTimeWindowEventListener());
        this.addInternalEventListener(138, new RemoveTimeWindowEventListener());
        this.addInternalEventListener(139, new ChangeTimeWindowEventListener());
        this.addInternalEventListener(135, new TokenRestartEventListener());
        this.addInternalEventListener(136, new TokenMonitorEventListener());
        this.addInternalEventListener(141, new UpdateDirectoryTableEventListener());
        this.addInternalEventListener(44, new CreateGroupEventListener());
        this.addInternalEventListener(45, new DropGroupEventListener());
        this.addInternalEventListener(46, new AddGroupMemberEventListener());
        this.addInternalEventListener(47, new RemoveGroupMemberEventListener());
        this.addInternalEventListener(140, new SchedulerOperationEventListener());
        this.addInternalEventListener(142, new StatsMonitorOperationEventListener());
        this.addInternalEventListener(143, new SlangOperationEventListener());
        this.addInternalEventListener(144, new SetAdvancedParameterEventListener());
        this.addInternalEventListener(145, new NodeDetachEventListener());
        this.addInternalEventListener(134, new SurveyEventListener());
        this.addInternalEventListener(147, new RoutedContainerRequestEventListener());
        this.addInternalEventListener(148, new ApiKeyReplicationRequestEventListener());
        this.addInternalEventListener(54, new ModeratorOperationEventListener());
        this.addInternalEventListener(149, new CheckEventFlowsEventListener());
        this.addInternalEventListener(150, new SetTimezoneEventListener());
        this.addInternalEventListener(151, new GetSemanticTypeDependenciesEventListener());
        this.addInternalEventListener(152, new CheckSemanticTypeDependenciesEventListener());
        this.addInternalEventListener(153, new UpdateGlobalCounterEventListener());
        this.addInternalEventListener(154, new DropBoxTableSynchronizationEventListener());
        this.addInternalEventListener(157, new GetExclusionListEventListener());
        this.addInternalEventListener(158, new UpdatePackageEventListener());
        this.addInternalRequestListener(101, new JoinRequestListener());
        this.addInternalRequestListener(103, new SyncLevel1RequestListener());
        this.addInternalRequestListener(104, new SyncLevel2RequestListener());
        this.addInternalRequestListener(105, new SyncLevel3RequestListener());
        this.addInternalRequestListener(108, new SyncForwardRequestListener());
        this.addInternalRequestListener(113, new EstablishConnectionRequestListener());
        this.addInternalRequestListener(2, new ClientConnectRequestListener());
        this.addInternalRequestListener(4, new ClientConnectConfirmRequestListener());
        this.addInternalRequestListener(3, new ClientDisconnectRequestListener());
        this.addInternalRequestListener(14, new ClientAddEndpointRequestListener());
        this.addInternalRequestListener(15, new ClientRemoveEndpointRequestListener(this));
        this.addInternalRequestListener(16, new ClientChangeComponentRequestListener());
        this.addInternalRequestListener(17, new ClientChangeConsumerRequestListener());
        this.addInternalRequestListener(21, new ClientAddDataConstraintRequestListener());
        this.addInternalRequestListener(22, new ClientRemoveDataConstraintRequestListener());
        this.addInternalRequestListener(23, new ClientChangeDataConstraintRequestListener());
        this.addInternalRequestListener(27, new NodeGetCachedEventsRequestListener());
        this.addInternalRequestListener(28, new ClientGetCachedEventsRequestListener());
        this.addInternalRequestListener(30, new PingRequestListener());
        this.addInternalRequestListener(31, new IsSecurityEnabledRequestListener());
        this.addInternalRequestListener(34, new RepositoryAccessorRequestListener());
        this.addInternalRequestListener(131, new GetManagementNodeObjectRequestListener());
        this.addInternalRequestListener(37, new ExportSemanticTypeRequestListener());
        this.addInternalRequestListener(38, new ImportSemanticTypeRequestListener());
        this.addInternalRequestListener(39, new ExportEventPrototypeRequestListener());
        this.addInternalRequestListener(40, new ImportEventPrototypeRequestListener());
        this.addInternalRequestListener(42, new EventCacheOperationRequestListener());
        this.addInternalRequestListener(41, new EventConsumerOperationRequestListener());
        this.addInternalRequestListener(140, new SchedulerOperationRequestListener());
        this.addInternalRequestListener(44, new ClientCreateGroupRequestListener());
        this.addInternalRequestListener(45, new ClientDropGroupRequestListener());
        this.addInternalRequestListener(46, new ClientAddGroupMemberRequestListener());
        this.addInternalRequestListener(47, new ClientRemoveGroupMemberRequestListener());
        this.addInternalRequestListener(143, new SlangOperationRequestListener());
        this.addInternalRequestListener(52, new CreateFactoryConnectionComponentRequestListener());
        this.addInternalRequestListener(53, new FactoryConnectionComponentAccessorCreatedRequestListener());
        this.addInternalRequestListener(135, new TokenRestartRequestListener());
        this.addInternalRequestListener(54, new ModeratorOperationRequestListener());
        this.addInternalRequestListener(147, new RoutedContainerRequestRequestListener());
        this.addInternalRequestListener(56, new CloseAccessorsRequestListener());
        this.addInternalRequestListener(57, new GlobalCounterOperationRequestListener());
        this.addInternalRequestListener(155, new DropBoxTableSynchronizationRequestListener());
        if (this.context.isSecurityEnabled()) {
            this.addInternalEventListener(119, new SecurityUpdateEventListener());
            this.addInternalEventListener(132, new IsOwnerActiveEventListener());
            this.addInternalEventListener(133, new GetOwnerComponentsEventListener());
            this.addInternalRequestListener(32, new SecurityManagerOperationRequestListener());
            this.addInternalRequestListener(33, new AnonymousRegistrationRequestListener());
        }
        if (this.context.getNodeRole() == FabricNodeRole.MANAGEMENT_NODE) {
            this.addInternalRequestListener(58, new DropBoxItemJoinToMNodeRequestListener());
        }
    }

    @Override
    protected void doDestroy() {
        FileIOUtils.deleteFileDir(this.jarsDir);
    }

    @Override
    protected boolean isRuntime() {
        return true;
    }

    void setContext(RuntimeContext context) {
        this.context = context;
    }

    protected PeerState getPeerState() {
        return this.peerState;
    }

    @Override
    void doStart() {
        this.logDebug("Runtime Exchange starting...");
        this.dispatcher.start();
        if (this.threadMonitor != null) {
            this.threadMonitor.start();
        }
        this.startAccessorMonitor();
        this.logInfo("Runtime Exchange started.");
    }

    @Override
    void doStop() {
        Trace.logDebug(this, "Runtime Exchange stopping...");
        super.doStop();
        this.destroyAccessorMonitor();
        this.destroyThreadMonitor();
        this.dispatcher.stop();
        Trace.logInfo(this, "Runtime Exchange stopped.");
    }

    void detach(long timeout) {
        this.isShuttingDown = true;
        this.detachFromSysplex(false, timeout);
        this.detachClients();
        this.closeDiagnosticSessions();
    }

    protected List<LinkAddress> getAcceptors(LinkProtocol protocol) {
        return this.node.getAcceptors().stream().filter(linkAddress -> linkAddress.getProtocol() == protocol).collect(Collectors.toList());
    }

    protected List<LinkAddress> getTLPAcceptors() {
        return this.getAcceptors(LinkProtocol.TLP);
    }

    private short acquireNodeNumber() throws ExchangeException {
        try {
            return this.nodeNumberAllocator.getNumber();
        }
        catch (NumberAllocatorException exception) {
            throw new ExchangeException("Allocation of node number failed.", (Throwable)exception);
        }
    }

    private FabricAddress acquireAddress() throws ExchangeException {
        try {
            return new FabricAddress(this.node.getFabricAddress(), this.componentNumberAllocator.getNumber());
        }
        catch (NumberAllocatorException exception) {
            throw new ExchangeException("Acquiring of Fabric Address failed.", (Throwable)exception);
        }
    }

    private void acquireAddress(AbstractFabricComponent component) throws ExchangeException {
        component.getContextId().acquire(this.acquireAddress());
    }

    private void releaseAddress(FabricAddress address) {
        this.componentNumberAllocator.releaseNumber(address.getComponentNumber());
    }

    private void releaseAddress(FabricComponent component) {
        this.releaseAddress(component.getFabricAddress());
        component.getContextId().release();
    }

    boolean isJoinInProgress() {
        return this.sysplexSynchronizer.joinInProgress;
    }

    Pair<Boolean, Throwable> joinSysplex(boolean firstTime, boolean noJoin) throws Exception {
        return (Pair)this.sysplexSynchronizer.invoke(JOIN_SYSPLEX_METHOD, false, firstTime, noJoin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Boolean, Throwable> doJoinSysplex(boolean fromScavenger, boolean firstTime, boolean noJoin) {
        this.isJoinInProgress = true;
        try {
            if (!fromScavenger) {
                this.scavenger.stop();
                this.scavenger.calculateDiscoveryLinks();
                this.scavenger.findMissingLinks();
            }
            boolean isRealJoin = false;
            Throwable joinError = null;
            if (!noJoin) {
                while (!this.scavenger.absentNodes.isEmpty()) {
                    isRealJoin = true;
                    this.peerState = this.inSysplex() ? PeerState.MERGING_SPX : (fromScavenger ? PeerState.REJOINING_SPX : PeerState.JOINING_SPX);
                    this.onSysplexUpdate(ModeratorAdvisoryType.ATTACHING_TO_SYSPLEX, null);
                    this.logInfo("Node " + this.getNodePrintName() + " is " + this.getPeerStateInfo() + "...");
                    try {
                        this.doJoinSysplex();
                        joinError = null;
                    }
                    catch (Throwable exception) {
                        joinError = this.processJoinFailure(exception);
                    }
                }
            }
            this.processJoinCompletion(fromScavenger, firstTime, noJoin, isRealJoin);
            Pair<Boolean, Object> pair = new Pair<Boolean, Object>(isRealJoin, joinError);
            return pair;
        }
        finally {
            this.isJoinInProgress = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doJoinSysplex() throws Throwable {
        block12: {
            File jarDir = null;
            ExchangeConnection connection = this.connectToFirstNode();
            try {
                List<FabricNode> fabricNodesCopy = this.getFabricNodesForReply(false);
                List<FabricGroup> fabricGroups = this.groupManager.getGroups();
                SyncLevel1ReplyData sync1Data = (SyncLevel1ReplyData)connection.raiseLongInternalRequest(103, this.createSyncLevel1Data(connection, fabricNodesCopy, fabricGroups));
                Map<String, TimeWindow> newTimeWindows = Utils.removeAll(this.getTimeWindowsCopy(), sync1Data.timeWindows);
                Map<String, DomainConstraintReferenceImpl> newDomains = Utils.removeAll(this.getDomainConstraintsCopy(), sync1Data.domains);
                Map<String, RangeConstraintReferenceImpl> newRanges = Utils.removeAll(this.getRangeConstraintsCopy(), sync1Data.ranges);
                this.synchronizeLevel1Entities(sync1Data);
                FabricNode nodeToJoin = (FabricNode)sync1Data.fabricNodes.get(0);
                List<FabricNode> sysplexNodes = this.getFabricNodes();
                this.joinConnection = new Pair<FabricAddress, ExchangeConnection>(nodeToJoin.getFabricAddress(), connection);
                this.addFabricNodeStep1(nodeToJoin);
                SyncSemanticData semanticData = null;
                Map<Prototype, ImmutableEventDatagram> prototypesForSysplex = null;
                SyncSemanticData sync2Data = null;
                SyncLevel3Data sync3Data = null;
                List<String> duplicatedExtJARs = null;
                List<String> duplicatedLibJARs = null;
                if (this.context.isCoherenceAgentBound()) {
                    Map<String, SemanticType> typesForSysplex = null;
                    try {
                        duplicatedExtJARs = this.removeDuplicatedExtJARs(sync1Data.libJARs);
                        duplicatedLibJARs = this.removeDuplicatedLibJARs(sync1Data.extJARs);
                        List<String> extJarsForSysplex = this.getExtJARsForSysplex(sync1Data.extJARs, nodeToJoin, sync1Data.getJarDir());
                        this.updatePackagesScope(sync1Data.exclusionList, sync1Data.packages);
                        int chainRebuildIndex = this.getChainRebuildIndex(sync1Data.packages);
                        this.getPackagesForSysplex(sync1Data.packages, nodeToJoin, sync1Data.getJarDir());
                        typesForSysplex = this.getSemanticTypesForSysplex(extJarsForSysplex, sync1Data);
                        jarDir = FileIOUtils.newFileDir(new File(this.jarsDir, System.currentTimeMillis() + "_node").getPath());
                        semanticData = new SyncSemanticData(jarDir.getName(), extJarsForSysplex, sync1Data.packages, typesForSysplex);
                        sync2Data = (SyncSemanticData)connection.raiseLongInternalRequest(104, new SyncLevel2Data(semanticData, sync1Data));
                        sync2Data.jarDir = jarDir.getName();
                        this.synchronizeExtJARs(sync2Data.extJARs, jarDir);
                        this.synchronizePackagesInNode(sync2Data, chainRebuildIndex, jarDir);
                        this.synchronizeSemanticTypes(sync2Data.semanticTypes);
                    }
                    catch (Throwable exception) {
                        this.logInternalRequestError(exception, 104);
                        this.logError("Synchronization of JARs, packages and semantic types failed.");
                        this.doRemoveFabricNodeStep1(nodeToJoin);
                        throw exception;
                    }
                    prototypesForSysplex = this.getPrototypesForSysplex(sync1Data.eventPrototypes, typesForSysplex);
                    try {
                        sync3Data = (SyncLevel3Data)connection.raiseLongInternalRequest(105, new SyncLevel3RequestData(prototypesForSysplex, sync1Data.eventPrototypes));
                        this.synchronizeEventPrototypes(sync3Data.eventPrototypes);
                    }
                    catch (Throwable exception) {
                        this.logInternalRequestError(exception, 105);
                        this.logError("Synchronization of event prototypes failed.");
                        this.doRemoveFabricNodeStep1(nodeToJoin);
                        throw exception;
                    }
                }
                List sysplexRoutingLinks = sync1Data.routingLinks;
                RoutingTable.Link firstNodeLink = this.routingTable.addLink(this.node, nodeToJoin, connection);
                if (!sysplexNodes.isEmpty()) {
                    sync1Data.routingLinks.add(firstNodeLink);
                    this.synchronizeNodesBackward(sysplexNodes, sync1Data, sync2Data, duplicatedExtJARs, duplicatedLibJARs, sync3Data);
                }
                this.bindConnection(connection, nodeToJoin.getFabricAddress());
                this.addFabricNode(nodeToJoin, true, true);
                this.sysplexSynchronizer.resetToken(sync1Data.tokenId);
                ArrayList<RoutingTable.Link> newRoutingLinks = new ArrayList<RoutingTable.Link>();
                if (sync1Data.fabricNodes.size() > 1) {
                    newRoutingLinks.addAll(this.synchronizeNodesForward(connection, sync1Data.fabricNodes.subList(1, sync1Data.fabricNodes.size()), this.createSyncLevel12ForwardData(sync1Data, fabricNodesCopy, fabricGroups, this.routingTable.getLinks(), newTimeWindows, newDomains, newRanges, semanticData), prototypesForSysplex));
                    this.routingTable.addLinks(sysplexRoutingLinks);
                    this.routingTable.addLinks(newRoutingLinks);
                }
                ((AbstractApiKeyManager)((Object)this.context.getHTTPAuthenticationManager().getApiKeyManager())).propagateDataToSysplex(sync1Data.apiKeyReplicatedData);
                this.context.getDropBoxManagerRemote().getDropBoxTableManager().propagateDropBoxTableToSysplex(sync1Data.dropBoxTable);
                this.broadcastWithAckToNodes(102, newRoutingLinks);
                if (jarDir == null) break block12;
            }
            catch (Throwable exception) {
                try {
                    connection.close(false);
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (jarDir != null) {
                        FileIOUtils.deleteFileDir(jarDir);
                    }
                    this.joinConnection = null;
                    throw throwable;
                }
            }
            FileIOUtils.deleteFileDir(jarDir);
        }
        this.joinConnection = null;
    }

    private Throwable processJoinFailure(Throwable exception) {
        Throwable joinError;
        if (exception instanceof OutOfMemoryError) {
            this.handle((OutOfMemoryError)exception);
        }
        if (!(exception instanceof PseudoExchangeException)) {
            joinError = exception;
            if (!(exception instanceof OutOfMemoryError)) {
                this.logException(exception, true);
            }
        } else {
            joinError = exception.getCause();
        }
        this.onSysplexUpdate(ModeratorAdvisoryType.ATTACH_TO_SYSPLEX_FAILED, null);
        this.logError("Node " + this.getNodePrintName() + " failed " + this.getPeerStateFailed() + ".");
        this.peerState = this.peerState == PeerState.JOINING_SPX ? PeerState.JOIN_SPX_FAILED : (this.peerState == PeerState.MERGING_SPX ? PeerState.MERGE_SPX_FAILED : PeerState.REJOIN_SPX_FAILED);
        return joinError;
    }

    private void processJoinCompletion(boolean fromScavenger, boolean firstTime, boolean noJoin, boolean isRealJoin) {
        if (firstTime || isRealJoin) {
            if (!this.inSysplex()) {
                this.peerState = PeerState.STANDALONE;
                if (!fromScavenger) {
                    if (firstTime) {
                        this.logInfo("FAIR: No active Fabric Nodes detected. Assuming the role of a standalone root.");
                        try {
                            this.updateNodeAddress(this.acquireClusterNumber(), this.acquireNodeNumber());
                            this.addFabricNodeToCluster(this.node, true);
                        }
                        catch (FabricException fabricException) {
                            // empty catch block
                        }
                    }
                    if (!noJoin) {
                        this.scavenger.start();
                    }
                }
            } else {
                this.onSysplexUpdate(ModeratorAdvisoryType.ATTACHED_TO_SYSPLEX, null);
                this.logInfo(this.peerState == PeerState.MERGING_SPX ? "Sysplexes [" + this.getDomain() + "] merged." : "Node " + this.getNodePrintName() + " joined " + this.getSysplexPrintName() + ".");
                this.peerState = PeerState.JOINED_SPX;
            }
        }
    }

    private ExchangeConnection connectToFirstNode() throws Exception {
        Pair<ExchangeConnection, Exception> primaryResult = this.doFirstConnect(this.scavenger.absentNodes, this.scavenger.primaryLinks, null);
        if (primaryResult.first != null) {
            return (ExchangeConnection)primaryResult.first;
        }
        Pair<ExchangeConnection, Exception> backupResult = this.doFirstConnect(this.scavenger.backupAbsentNodes, this.scavenger.backupLinks, (Exception)primaryResult.second);
        if (backupResult.first != null) {
            return (ExchangeConnection)backupResult.first;
        }
        throw new PseudoExchangeException(backupResult.second != null ? (Exception)backupResult.second : new ExchangeException("Suitable discovery links not found."));
    }

    private Pair<ExchangeConnection, Exception> doFirstConnect(Set<String> nodes, Map<String, List<DiscoveryLink>> links, Exception resultError) {
        Iterator<String> iter = nodes.iterator();
        while (iter.hasNext()) {
            String nodeName = iter.next();
            iter.remove();
            this.logInfo("Connecting to node " + FabricNode.getPrintName(nodeName) + "...");
            for (DiscoveryLink link : links.get(nodeName)) {
                ExchangeConnection connection;
                try {
                    connection = (ExchangeConnection)this.establishConnection(link.getLinkAddress(), this.connectionTimeout);
                }
                catch (Exception exception) {
                    resultError = exception;
                    this.logException(exception, false, "Connecting to " + String.valueOf(link.getLinkAddress()) + " failed.");
                    continue;
                }
                try {
                    connection.raiseLongInternalRequest(101, new JoinData(this.node.getName(), nodeName));
                }
                catch (Exception exception) {
                    resultError = exception;
                    if (exception instanceof ExchangeException && ((ExchangeException)exception).getErrorCode() == 6014) {
                        this.logWarning(exception.getMessage());
                    } else {
                        this.logInternalRequestError(exception, 101);
                    }
                    connection.close(true);
                    continue;
                }
                try {
                    connection.calculateLatency();
                }
                catch (Exception exception) {
                    resultError = exception;
                    this.logException(exception, true, "Calculation of latency failed.");
                    connection.close(true);
                    continue;
                }
                return new Pair<ExchangeConnection, Object>(connection, null);
            }
        }
        return new Pair<Object, Exception>(null, resultError);
    }

    private void synchronizeNodesBackward(List<FabricNode> fabricNodes, SyncLevel1ReplyData sync1Data, SyncSemanticData semanticData, List<String> duplicatedExtJARs, List<String> duplicatedLibJARs, SyncLevel3Data sync3Data) throws Exception {
        this.doRemoveFabricNodeStep1((FabricNode)sync1Data.fabricNodes.get(0));
        this.broadcastWithAckToNodesSpecial(106, this.createSyncLevel1BackwardData(sync1Data));
        if (this.context.isCoherenceAgentBound()) {
            this.copyJARsToNodes(fabricNodes, semanticData.getJarDir());
            this.broadcastWithAckToNodes(107, new SyncLevel2BackwardData(sync1Data.exclusionList, semanticData, duplicatedExtJARs, duplicatedLibJARs), this.longReplyTimeout);
            this.broadcastWithAckToNodes(105, new SyncLevel3Data(sync3Data.eventPrototypes), this.longReplyTimeout);
        }
    }

    private JoinReplyData onJoinRequest(JoinData data, NodeExchangeConnection connection) throws Exception {
        if (connection.isValid) {
            if (!this.node.getName().equals(data.sysplexNodeName)) {
                throw new ExchangeException("Node names mismatch: " + FabricNode.getPrintName(data.sysplexNodeName) + " discovered, but " + this.getNodePrintName() + " connected.");
            }
            this.logInfo("Node " + FabricNode.getPrintName(data.sysplexNodeName) + " is in Join.");
            this.sysplexSynchronizer.startJoin(connection, data.joiningNodeName);
            return new JoinReplyData(this.node.getFabricAddress());
        }
        throw new ExchangeException("Connection is not valid.");
    }

    private String getPeerStateInfo() {
        switch (this.peerState) {
            case JOINING_SPX: {
                return "joining " + this.getSysplexPrintName();
            }
            case REJOINING_SPX: {
                return "rejoining " + this.getSysplexPrintName();
            }
            case MERGING_SPX: {
                return "merging " + this.getSysplexPrintName("Sysplexes");
            }
        }
        return "Undefined";
    }

    private String getPeerStateFailed() {
        switch (this.peerState) {
            case JOINING_SPX: {
                return "to join " + this.getSysplexPrintName();
            }
            case REJOINING_SPX: {
                return "to rejoin " + this.getSysplexPrintName();
            }
            case MERGING_SPX: {
                return "to merge " + this.getSysplexPrintName("Sysplexes");
            }
        }
        return "Undefined";
    }

    List<Object> getJoinInfo() {
        return this.sysplexSynchronizer.getJoinInfo();
    }

    private List<RoutingTable.Link> synchronizeNodesForward(ExchangeConnection connection, List<FabricNode> newNodes, SyncLevel12ForwardData syncData, Map<Prototype, ImmutableEventDatagram> eventPrototypes) throws Exception {
        if (!this.context.isCoherenceAgentBound() || eventPrototypes != null && eventPrototypes.isEmpty()) {
            eventPrototypes = null;
        }
        try {
            connection.raiseLongInternalRequest(108, syncData != null ? new SyncForwardData(syncData, eventPrototypes) : null);
        }
        catch (Exception exception) {
            this.logInternalRequestError(exception, 108);
            this.logError("Forward synchronization failed.");
            throw exception;
        }
        return this.addNewNodes(newNodes);
    }

    private List<RoutingTable.Link> addNewNodes(List<FabricNode> fabricNodes) {
        ArrayList<RoutingTable.Link> newRoutingLinks = new ArrayList<RoutingTable.Link>();
        for (FabricNode fabricNode : fabricNodes) {
            this.logDebug("Adding node " + fabricNode.getPrintName() + "...");
            RoutingTable.Link routingLink = null;
            ExchangeConnection connection = this.establishConnection(fabricNode.getName());
            if (connection != null) {
                try {
                    routingLink = this.routingTable.makeLink(this.node, fabricNode, connection);
                    connection.raiseInternalRequest(113, routingLink);
                    this.bindConnection(connection, fabricNode.getFabricAddress());
                    this.scavenger.absentNodes.remove(fabricNode.getName());
                }
                catch (Exception exception) {
                    this.logInternalRequestError(exception, 113);
                    connection.close(false);
                }
            }
            this.addFabricNode(fabricNode, true, true);
            if (connection == null) continue;
            newRoutingLinks.add(routingLink);
        }
        return newRoutingLinks;
    }

    private void connectToNode(String nodeName) {
        this.doConnectToNode(nodeName, this.establishConnection(nodeName));
    }

    void connectToNode(DiscoveryLink link) throws Exception {
        this.doConnectToNode(link.getNodeName(), this.establishConnection(link));
    }

    private void doConnectToNode(String nodeName, ExchangeConnection connection) {
        if (connection != null) {
            try {
                FabricNode fabricNode = this.getFabricNode(nodeName);
                RoutingTable.Link routingLink = this.routingTable.makeLink(this.node, fabricNode, connection);
                connection.raiseInternalRequest(113, routingLink);
                this.bindConnection(connection, fabricNode.getFabricAddress());
                this.logInfo("Peer link created: Node " + this.node.getFullPrintName() + " <==> Node " + fabricNode.getFullPrintName() + ", DIRECT.");
                this.broadcastWithAckToNodes(115, routingLink);
            }
            catch (Exception exception) {
                this.logInternalRequestError(exception, 113);
                connection.close(false);
            }
        }
    }

    private ExchangeConnection establishConnection(String nodeName) {
        List<DiscoveryLink> discoveryLinks = this.scavenger.primaryLinks.get(nodeName);
        if (discoveryLinks != null) {
            for (DiscoveryLink link : discoveryLinks) {
                try {
                    return this.establishConnection(link);
                }
                catch (Exception exception) {
                    this.logException(exception, false);
                    this.logError("Connecting to " + String.valueOf(link.getLinkAddress()) + " failed.");
                }
            }
        }
        return null;
    }

    private ExchangeConnection establishConnection(DiscoveryLink link) throws Exception {
        ExchangeConnection connection = (ExchangeConnection)this.establishConnection(link.getLinkAddress(), this.connectionTimeout);
        connection.calculateLatency();
        return connection;
    }

    private void bindConnection(ExchangeConnection connection, FabricAddress fabricAddress) {
        this.unboundConnections.remove(connection.getNetworkAddress());
        this.doBindConnection(connection, fabricAddress);
    }

    private void bindConnection(Address networkAddress, FabricAddress fabricAddress) throws FabricException {
        ExchangeConnection connection = this.unboundConnections.remove(networkAddress);
        if (connection != null) {
            this.doBindConnection(connection, fabricAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBindConnection(ExchangeConnection connection, FabricAddress fabricAddress) {
        connection.bind(fabricAddress);
        Map<FabricAddress, NodeExchangeConnection> map = this.nodeConnections;
        synchronized (map) {
            this.nodeConnections.put(fabricAddress, (NodeExchangeConnection)connection);
        }
    }

    private void addFabricNode(FabricNode fabricNode, boolean notify, boolean outgoing) {
        this.addFabricNodeStep1(fabricNode);
        this.addFabricNodeStep2(fabricNode, notify, outgoing);
    }

    private void addFabricNodeStep1(FabricNode fabricNode) {
        fabricNode.resolve(this);
        this.addFabricNodeInstance(fabricNode);
        this.addConsumers(fabricNode);
    }

    private void addFabricNodeStep2(FabricNode fabricNode, boolean notify, boolean outgoing) {
        this.addFabricNodeToCluster(fabricNode, false);
        this.routingTable.addNode(fabricNode);
        this.sysplexSynchronizer.addNode(fabricNode);
        if (notify) {
            this.notifyOnAddNode(fabricNode);
        }
        this.logInfo("Connection " + (outgoing ? "to" : "from") + " node " + fabricNode.getPrintName() + " " + (outgoing ? "established." : "accepted."));
        this.logInfo("Peer link created: Node " + this.node.getFullPrintName() + " <==> Node " + fabricNode.getFullPrintName() + ", " + (this.nodeConnections.containsKey(fabricNode.getFabricAddress()) ? "DIRECT." : "ROUTED."));
    }

    private void addConsumers(FabricNode fabricNode) {
        fabricNode.doGetDirectConsumers().forEach(this::addNetworkConsumer);
        fabricNode.doGetAsyncConsumers().forEach(this::addNetworkConsumer);
        fabricNode.doGetReceivers().forEach(this::addNetworkConsumer);
        fabricNode.doGetEventCaches().forEach(this::addNetworkConsumer);
    }

    private void addNetworkConsumer(NetworkExchangeConsumer consumer) {
        this.getNetworkDispatcher(consumer).addConsumer(consumer);
    }

    private void notifyOnAddNode(FabricNode fabricNode) {
        this.broadcastWithAckToClients(6, new AbstractExchange.NodeChangeEventData(fabricNode, ModeratorAdvisoryType.NODE_CONNECTED), null);
        this.onSysplexUpdate(ModeratorAdvisoryType.NODE_CONNECTED, fabricNode.getName());
        this.notifyContextOnNode(fabricNode, ModeratorAdvisoryType.NODE_CONNECTED);
    }

    void detachFromSysplex(boolean startScavenger, long timeout) {
        try {
            this.sysplexSynchronizer.invokeWithTimeout(timeout * 1000L, DETACH_FROM_SYSPLEX_METHOD, startScavenger, false);
        }
        catch (TimeoutException exception) {
            this.logError(exception.getMessage());
            this.logError("Normal detaching from the sysplex failed.");
            this.doDetachFromSysplex(startScavenger, true);
        }
    }

    void detachFromSysplexForced(String message) {
        this.logError(message + " Transferring node " + this.getNodePrintName() + " to standalone mode...");
        this.doDetachFromSysplex(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDetachFromSysplex(boolean startScavenger, boolean forced) {
        RuntimeExchange runtimeExchange = this;
        synchronized (runtimeExchange) {
            if (this.isDetachInProgress) {
                return;
            }
            this.isDetachInProgress = true;
        }
        try {
            this.scavenger.stop();
            if (this.inSysplex()) {
                this.logInfo((forced ? "Forced detaching" : "Detaching") + " node " + this.getNodePrintName() + " from " + this.getSysplexPrintName() + "...");
                if (!forced) {
                    this.broadcastWithAckToNodesSpecial(5, this.node.getFabricAddress());
                    this.broadcastToNodesSpecial(110, this.node.getName());
                    this.sysplexSynchronizer.handOverToken();
                }
                this.removeAllNodeConnections();
                this.resetNode(true, false);
                this.logInfo("FAIR: Node " + this.getNodePrintName() + " detached from " + this.getSysplexPrintName() + ".");
            }
            if (startScavenger) {
                this.scavenger.start();
            }
        }
        finally {
            this.isDetachInProgress = false;
        }
    }

    private void removeAllNodeConnections() {
        for (ExchangeConnection exchangeConnection : this.nodeConnections.values()) {
            exchangeConnection.close(true);
        }
        this.nodeConnections.clear();
    }

    void detachNode(FabricNode node, long timeout) {
        try {
            this.sysplexSynchronizer.invokeWithTimeout(timeout * 1000L, DETACH_NODE_METHOD, node, true, false);
        }
        catch (TimeoutException exception) {
            this.logError(exception.getMessage());
            this.logError("Normal detaching node " + node.getFullPrintName() + " from " + this.getSysplexPrintName() + " failed.");
            this.doDetachNode(node, true, true);
        }
    }

    private void doDetachNode(FabricNode fabricNode, boolean startScavenger, boolean forced) {
        this.doDetachNodeCore(fabricNode.getFabricAddress(), startScavenger, forced);
        this.broadcastWithAckToNodes(145, new NodeDetachData(fabricNode.getFabricAddress(), startScavenger));
    }

    private void doDetachNodeCore(FabricAddress nodeAddress, boolean startScavenger, boolean forced) {
        FabricNode removedNode = this.getFabricNode(nodeAddress);
        if (removedNode != null) {
            this.logInfo((forced ? "Forced detaching" : "Detaching") + " node " + removedNode.getPrintName() + " from " + this.getSysplexPrintName() + "...");
            NodeExchangeConnection nodeConnection = this.nodeConnections.remove(nodeAddress);
            if (nodeConnection != null) {
                nodeConnection.close(true);
            }
            this.removeFabricNode(removedNode, false, false);
            this.logInfo("Node " + removedNode.getPrintName() + " detached from " + this.getSysplexPrintName() + ".");
            if (startScavenger) {
                this.scavenger.start();
            }
        }
    }

    private boolean detachBadNodes(FabricAddress badNodeAddress) {
        boolean result = false;
        this.logInfo("Node " + this.getNodePrintName() + " is detecting unreachable nodes...");
        Map<FabricAddress, Object> nodeAddresses = this.survey();
        if (badNodeAddress != null) {
            nodeAddresses.put(badNodeAddress, MissingAck.OBJECT);
        }
        if (nodeAddresses != null) {
            List<Map.Entry> badNodes = nodeAddresses.entrySet().stream().filter(entry -> this.existsNodeConnection((FabricAddress)entry.getKey())).collect(Collectors.toList());
            badNodes.forEach(entry -> nodeAddresses.remove(entry.getKey()));
            badNodes.addAll(nodeAddresses.entrySet());
            for (Map.Entry badNodeEntry : badNodes) {
                FabricNode fabricNode = this.getFabricNode((FabricAddress)badNodeEntry.getKey());
                if (fabricNode == null) continue;
                if (badNodeAddress == null || !((FabricAddress)badNodeEntry.getKey()).equals(badNodeAddress)) {
                    this.logError("Node " + fabricNode.getPrintName() + (badNodeEntry.getValue() instanceof MissingAck ? " is unreachable." : " is reachable, but in a bad state."));
                }
                this.doDetachNode(fabricNode, false, false);
                result = true;
            }
        }
        return result;
    }

    void unlinkNode(FabricNode fabricNode, boolean forced, long timeout, boolean startScavenger) {
        if (forced) {
            this.closeNodeConnectionForced(fabricNode, startScavenger);
        } else {
            try {
                this.sysplexSynchronizer.invokeWithTimeout(timeout * 1000L, UNLINK_NODE_METHOD, fabricNode, startScavenger);
            }
            catch (TimeoutException exception) {
                this.logError(exception.getMessage());
                this.logError("Normal closing connection with node " + fabricNode.getPrintName() + " failed.");
                this.closeNodeConnectionForced(fabricNode, startScavenger);
            }
        }
    }

    private void closeNodeConnectionForced(FabricNode fabricNode, boolean startScavenger) {
        NodeExchangeConnection connection = this.getNodeConnection(fabricNode.getFabricAddress());
        if (connection != null) {
            this.logInfo("Forced closing connection with node " + fabricNode.getPrintName() + "...");
            connection.close(false);
            if (startScavenger) {
                this.scavenger.start();
            }
        }
    }

    private void doUnlinkNode(FabricNode fabricNode, boolean startScavenger) {
        NodeExchangeConnection connection = this.getNodeConnection(fabricNode.getFabricAddress());
        if (connection != null) {
            this.logInfo("Closing connection with node " + fabricNode.getPrintName() + "...");
            if (this.nodeConnections.size() == 1) {
                this.doDetachFromSysplex(true, false);
            } else {
                this.removeRoutingLink(connection.routingLink);
                this.broadcastWithAckToNodes(116, connection.routingLink);
                if (this.routingTable.getDestination(fabricNode.getFabricAddress()) == null) {
                    this.sysplexSynchronizer.raiseTokenRequest(fabricNode.getFabricAddress());
                }
                connection.isDisconnected = true;
                connection.close(true);
                if (startScavenger) {
                    this.scavenger.start();
                }
            }
        }
    }

    private void removeRoutingLink(RoutingTable.Link link) {
        this.routingTable.removeLink(link);
        this.removeRoutedNodes(true, false);
    }

    private void removeFabricNode(FabricNode removedNode, boolean normal, boolean joinInterrupted) {
        this.doRemoveFabricNode(removedNode, normal, joinInterrupted);
        this.removeRoutedNodes(normal, joinInterrupted);
    }

    private void doRemoveFabricNode(FabricNode removedNode, boolean normal, boolean joinInterrupted) {
        this.doRemoveFabricNode(removedNode);
        this.notifyOnRemoveNode(removedNode, normal, true, joinInterrupted);
        if (!this.inSysplex()) {
            this.logInfo("FAIR: All connections to " + this.getSysplexPrintName() + " closed. Transferring node " + this.getNodePrintName() + " to standalone state.");
            this.resetNode(true, joinInterrupted);
            this.logInfo("FAIR: Node " + this.getNodePrintName() + " assumed the role of a standalone root.");
        }
    }

    private void doRemoveFabricNode(FabricNode fabricNode) {
        this.doRemoveFabricNodeStep1(fabricNode);
        this.doRemoveFabricNodeStep2(fabricNode);
    }

    private void doRemoveFabricNodeStep1(FabricNode fabricNode) {
        if (fabricNode != null) {
            this.removeConsumers(fabricNode);
            this.removeFabricNodeInstance(fabricNode);
        }
    }

    private void doRemoveFabricNodeStep2(FabricNode fabricNode) {
        if (fabricNode != null) {
            this.removeFabricNodeFromCluster(fabricNode);
            this.nodeNumberAllocator.releaseNumber(fabricNode.getFabricAddress().getNodeNumber());
            this.sysplexSynchronizer.removeNode(fabricNode);
            this.routingTable.removeNode(fabricNode);
            this.logInfo("Peer link dropped: Node " + this.node.getFullPrintName() + " <=/=> Node " + fabricNode.getFullPrintName() + ".");
        }
    }

    private void removeConsumers(FabricNode fabricNode) {
        fabricNode.doGetDirectConsumers().forEach(this::removeNetworkConsumer);
        fabricNode.doGetAsyncConsumers().forEach(this::removeNetworkConsumer);
        fabricNode.doGetReceivers().forEach(this::removeNetworkConsumer);
        fabricNode.doGetEventCaches().forEach(this::removeNetworkConsumer);
    }

    private void removeNetworkConsumer(NetworkExchangeConsumer consumer) {
        this.getNetworkDispatcher(consumer).removeConsumer(consumer);
    }

    private void removeRoutedNodes(boolean normal, boolean joinInterrupted) {
        List removedNodes = this.getNodeAddresses().stream().filter(nodeAddress -> this.routingTable.getDestination((FabricAddress)nodeAddress) == null).collect(Collectors.toList());
        for (FabricAddress nodeAddress2 : removedNodes) {
            FabricNode removedNode = this.getFabricNode(nodeAddress2);
            if (removedNode == null) continue;
            this.doRemoveFabricNode(removedNode, normal, joinInterrupted);
        }
    }

    private void switchToStandaloneRole(boolean joinInterrupted) {
        this.logWarning("Node " + this.getNodePrintName() + " lost all connections with other nodes. Detaching...");
        this.resetNode(false, joinInterrupted);
        this.logInfo("FAIR: Node " + this.getNodePrintName() + " detached from " + this.getSysplexPrintName() + ". Assuming the role of a standalone root.");
        this.scavenger.start();
    }

    private void resetNode(boolean normal, boolean joinInterrupted) {
        this.networkDispatcher.clear();
        this.groupManager.clear();
        this.clearNodeNumberAllocator();
        for (FabricNode fabricNode : this.getFabricNodes()) {
            this.notifyOnRemoveNode(fabricNode, normal, false, joinInterrupted);
        }
        this.clearFabricNodes();
        this.routingTable.reset();
        this.sysplexSynchronizer.reset();
        this.peerState = PeerState.STANDALONE;
        this.broadcastWithAckToClients(1, new AbstractExchange.DetachFromSysplexData(normal, this.isShuttingDown, joinInterrupted), null);
        this.onSysplexUpdate(normal ? ModeratorAdvisoryType.DETACHED_FROM_SYSPLEX : ModeratorAdvisoryType.DETACHED_FROM_SYSPLEX_FORCIBLY, null);
    }

    private void clearNodeNumberAllocator() {
        for (FabricAddress nodeAddress : this.getNodeAddresses()) {
            this.nodeNumberAllocator.releaseNumber(nodeAddress.getNodeNumber());
        }
    }

    private void notifyOnRemoveNode(FabricNode fabricNode, boolean normal, boolean notifyClients, boolean joinInterrupted) {
        ModeratorAdvisoryType advisoryType = RuntimeExchange.getNodeDisconnectAdvisoryType(normal, joinInterrupted);
        if (notifyClients) {
            this.broadcastWithAckToClients(7, new AbstractExchange.NodeChangeEventData(fabricNode, advisoryType), null);
        }
        this.onSysplexUpdate(advisoryType, fabricNode.getName());
        this.notifyContextOnNode(fabricNode, advisoryType);
    }

    private void removeConnection(FabricAddress nodeAddress, boolean closeConnection) {
        if (this.nodeConnections.containsKey(nodeAddress)) {
            this.routingTable.removeLink(this.node, this.getFabricNode(nodeAddress));
            AbstractExchange.NetworkConnectionImpl removedConnection = this.nodeConnections.remove((Object)nodeAddress).networkConnection;
            if (closeConnection && removedConnection != null) {
                removedConnection.close(true);
            }
        }
    }

    private void notifyContextOnNode(FabricNodeReference node, ModeratorAdvisoryType type) {
        try {
            this.systemThreadPool.addTask(() -> {
                Utils.sleep(500L);
                if (type == ModeratorAdvisoryType.NODE_CONNECTED) {
                    this.context.onNodeConnect(node);
                } else if (type == ModeratorAdvisoryType.NODE_DISCONNECTED || type == ModeratorAdvisoryType.NODE_DISCONNECTED_FORCIBLY) {
                    this.context.onNodeDisconnect(node, type == ModeratorAdvisoryType.NODE_DISCONNECTED);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    void resync(boolean forced) throws Exception {
        if (!this.sysplexSynchronizer.isRoot) {
            throw new ExchangeException("Operation can be executed only in a root node.");
        }
        this.doResync(forced);
    }

    private void doResync(boolean forced) {
        FabricThreadManager.getInstance().createThread("EXCH:Token.Restart", "Restarts the synchronization token.", () -> {
            Utils.sleep(100L);
            this.sysplexSynchronizer.forceTokenMonitor(forced);
        }).start();
    }

    void bind(FabricComponent component) throws Exception {
        if (component instanceof AbstractFabricComponent) {
            if (component.getEventScope() == EventScope.CLUSTER && !this.isClustered()) {
                throw new ExchangeException("Event scope CLUSTER is not allowed.");
            }
            AbstractFabricComponent fabricComponent = (AbstractFabricComponent)component;
            this.addComponent(fabricComponent, component.getEventScope() == EventScope.GLOBAL && component instanceof LocalClientComponent ? ComponentModel.LOCAL_CLIENT : null);
            if (component instanceof LocalClientComponent) {
                LocalFabricConnection connection = ((LocalClientComponent)component).connection;
                if (((LocalClientComponent)component).isHTTP()) {
                    this.httpFabricConnections.put(fabricComponent.getFullName(), (AbstractHTTPServerFabricConnection)connection);
                    this.processClientThreshold("HTTP", this.httpFabricConnections.size());
                } else if (((LocalClientComponent)component).isXMPP()) {
                    this.xmppFabricConnections.put(fabricComponent.getFullName(), (AbstractXMPPFabricConnection)connection);
                    this.processClientThreshold("XMPP", this.xmppFabricConnections.size());
                } else {
                    this.tlpFabricConnections.put(fabricComponent.getFullName(), connection);
                }
            }
        }
    }

    private void addComponent(AbstractFabricComponent component, ComponentModel model) throws Exception {
        if (component.getEventScope() != EventScope.OBSERVABLE) {
            this.sysplexSynchronizer.invoke(ADD_COMPONENT_METHOD, new Object[]{component, model});
        } else {
            this.doAddComponent(component, model);
        }
    }

    private void doAddComponent(AbstractFabricComponent component, ComponentModel model) throws FabricException {
        this.checkComponentUniqueness(component.getType(), component.getName(), model);
        this.acquireAddress(component);
        this.setTimestamp(component);
        this.addComponent(component, model == ComponentModel.REMOTE_CLIENT);
    }

    @Override
    void notifyOnAddComponent(ComponentReferenceImpl component) {
        this.notifyOnAddEndpoint(component);
    }

    private void checkComponentUniqueness(String type, String name, ComponentModel model) throws FabricException {
        String fullComponentName = this.node.getComponentFullName(type, name);
        for (ComponentReference component : this.moderator.getFabricNode().getComponents(EventScope.INHERITED)) {
            if (!component.getName().equals(fullComponentName)) continue;
            throw new ExchangeException("Component with type '" + type + "' and name '" + name + "' already bound.");
        }
        if (model != null) {
            List<ComponentReference> components = this.moderator.getComponents(EventScope.GLOBAL);
            for (ComponentReference component : components) {
                List<String> nameTokens;
                if (component.getModel() != model || !(nameTokens = ModeratorUtils.splitComponentFullName(component.getName())).get(1).equals(type) || !nameTokens.get(2).equals(name)) continue;
                throw new ExchangeException("GLOBAL component with type '" + type + "' and name '" + name + "' already bound to node " + FabricNode.getPrintName(nameTokens.get(0)) + ".");
            }
        }
    }

    void unbind(FabricComponent component) {
        if (component instanceof AbstractFabricComponent) {
            this.removeComponent((AbstractFabricComponent)component);
            if (component instanceof LocalClientComponent) {
                if (((LocalClientComponent)component).isHTTP()) {
                    this.httpFabricConnections.remove(((AbstractFabricComponent)component).getFullName());
                    this.processClientThreshold("HTTP", this.httpFabricConnections.size());
                } else if (((LocalClientComponent)component).isXMPP()) {
                    this.xmppFabricConnections.remove(((AbstractFabricComponent)component).getFullName());
                    this.processClientThreshold("XMPP", this.xmppFabricConnections.size());
                } else {
                    this.tlpFabricConnections.remove(((AbstractFabricComponent)component).getFullName());
                }
            }
            this.eventFlowMap.removeComponentFlows((AbstractFabricComponent)component);
        }
    }

    private void removeComponent(AbstractFabricComponent component) {
        if (component.getEventScope() == EventScope.GLOBAL) {
            this.sysplexSynchronizer.invokeWithoutException(REMOVE_COMPONENT_METHOD, component);
        } else {
            this.doRemoveComponent(component);
        }
    }

    private void doRemoveComponent(AbstractFabricComponent component) {
        this.removeComponent(component.getFabricAddress());
        this.releaseAddress(component);
    }

    @Override
    void notifyOnRemoveComponent(ComponentReferenceImpl component) {
        this.notifyOnRemoveEndpoint(component);
    }

    @Override
    void changeComponent(ComponentReferenceImpl reference, ModeratorAdvisoryType type, Object parameter) {
        if (reference.getEventScope() == EventScope.GLOBAL) {
            this.sysplexSynchronizer.invokeWithoutException(CHANGE_COMPONENT_METHOD, new Object[]{reference, type, parameter, true});
        } else {
            this.doChangeComponent(reference, type, parameter, false);
        }
    }

    @Override
    void doChangeComponent(ComponentReferenceImpl reference, ModeratorAdvisoryType type, Object parameter, boolean notifyNodes) {
        super.doChangeComponent(reference, type, parameter, notifyNodes);
    }

    @Override
    void notifyOnChangeComponent(AbstractExchange.ChangeComponentData data, ComponentReferenceImpl reference, boolean notifyNodes) {
        this.notifyOnUpdate(11, (Object)data, reference.componentAddress, notifyNodes, data.type, reference.getName(), data.type == ModeratorAdvisoryType.COMPONENT_CHANGED ? null : (String)data.parameter);
    }

    @Override
    void addDirectConsumer(FabricEventDirectConsumerImpl consumer, FabricAddress componentAddress, EventScope scope, boolean noLocal, boolean isSystem, FabricGroupLinkImpl groupLink) throws Exception {
        this.addConsumer(new DirectConsumerReferenceImpl(consumer, componentAddress, scope, this.acquireAddress(), noLocal, groupLink), consumer.underlyingConsumer, isSystem, false, groupLink != null ? (RuntimeFabricGroup)groupLink.group : null);
    }

    @Override
    void addAsyncConsumer(FabricEventAsyncConsumerImpl consumer, FabricAddress componentAddress, EventScope scope, boolean noLocal, boolean isSystem, FabricGroupLinkImpl groupLink) throws Exception {
        this.addConsumer(new AsyncConsumerReferenceImpl(consumer, componentAddress, scope, this.acquireAddress(), noLocal, groupLink), consumer.underlyingConsumer, isSystem, false, groupLink != null ? (RuntimeFabricGroup)groupLink.group : null);
    }

    @Override
    void addRequestConsumer(FabricEventRequestConsumerImpl consumer, FabricAddress componentAddress, EventScope scope, boolean isAccessorSession) throws Exception {
        if (isAccessorSession) {
            this.addAccessorSession(new AccessorSessionReferenceImpl(consumer, componentAddress, scope, this.acquireAddress()));
        } else {
            this.addConsumer(new RequestConsumerReferenceImpl(consumer, componentAddress, scope, this.acquireAddress()), consumer.underlyingConsumer, false, false, null);
        }
    }

    private void addAccessorSession(AccessorSessionReferenceImpl reference) {
        reference.bind(this);
        this.node.addAccessorSession(reference);
        this.addToDispatcher(reference, reference.underlyingConsumer, true, false);
    }

    @Override
    void addReceiver(FabricEventReceiverImpl consumer, FabricAddress componentAddress, EventScope scope, boolean noLocal, boolean isSystem, FabricGroupLinkImpl groupLink) throws Exception {
        this.addConsumer(new ReceiverReferenceImpl(consumer, componentAddress, scope, this.acquireAddress(), noLocal, groupLink), consumer.underlyingConsumer, isSystem, false, groupLink != null ? (RuntimeFabricGroup)groupLink.group : null);
    }

    @Override
    void addReplyConsumer(ExtendedEventDispatcher.ReplyConsumer consumer, FabricAddress componentAddress, EventScope eventScope) throws Exception {
        this.addConsumer(new DirectConsumerReferenceImpl(consumer.getUnderlyingConsumer(), componentAddress, eventScope, this.acquireAddress(), false), consumer, false, false, null);
    }

    private void addConsumer(EndpointReferenceImpl reference, NamedObject consumer, boolean isSystem, boolean fromClient, RuntimeFabricGroup group) throws Exception {
        if (reference.eventScope != EventScope.OBSERVABLE) {
            this.sysplexSynchronizer.invoke(ADD_CONSUMER_METHOD, reference, consumer, isSystem, fromClient, group);
        } else {
            this.doAddConsumer(reference, consumer, isSystem, fromClient, group);
        }
    }

    private void doAddConsumer(EndpointReferenceImpl reference, NamedObject consumer, boolean isSystem, boolean fromClient, RuntimeFabricGroup group) {
        reference.bind(this);
        this.node.addEndpoint(reference);
        ((RuntimeExchangeEventPublisher)((Object)(group != null ? group : this))).addToDispatcher(reference, consumer, isSystem, fromClient);
        this.notifyOnAddEndpoint(reference);
    }

    @Override
    public void addToDispatcher(EndpointReferenceImpl reference, NamedObject consumer, boolean isSystem, boolean fromClient) {
        if (fromClient) {
            this.clientDispatcher.addConsumer(reference);
        } else if (consumer instanceof ExtendedEventDispatcher.ReplyConsumer) {
            this.dispatcher.addReplyConsumer((ExtendedEventDispatcher.ReplyConsumer)consumer);
        } else if (consumer instanceof ExchangeEventRequestConsumerImpl || reference.eventScope == EventScope.OBSERVABLE) {
            this.dispatcher.addConsumer(consumer, isSystem);
        } else {
            this.dispatcher.addConsumer(consumer, isSystem ? null : this.requestCachedEvents(((ExchangeConsumer)((Object)reference)).getCompositeFilter()));
        }
    }

    @Override
    void removeDirectConsumer(FabricEventDirectConsumerImpl consumer, FabricGroupLinkImpl groupLink) {
        this.removeConsumer(consumer.reference, consumer.underlyingConsumer, false, groupLink != null ? (RuntimeFabricGroup)groupLink.group : null);
    }

    @Override
    void removeAsyncConsumer(FabricEventAsyncConsumerImpl consumer, FabricGroupLinkImpl groupLink) {
        this.removeConsumer(consumer.reference, consumer.underlyingConsumer, false, groupLink != null ? (RuntimeFabricGroup)groupLink.group : null);
    }

    @Override
    void removeRequestConsumer(FabricEventRequestConsumerImpl consumer) {
        if (consumer.reference instanceof AccessorSessionReferenceImpl) {
            this.removeAccessorSession((AccessorSessionReferenceImpl)consumer.reference, consumer.underlyingConsumer);
        } else {
            this.removeConsumer(consumer.reference, consumer.underlyingConsumer, false, null);
        }
    }

    private void removeAccessorSession(AccessorSessionReferenceImpl reference, NamedObject consumer) {
        if (this.node.removeAccessorSession(reference) != null) {
            this.removeFromDispatcher(reference, consumer, false);
            this.releaseAddress(reference.getAddress());
        }
    }

    @Override
    void removeReceiver(FabricEventReceiverImpl receiver, FabricGroupLinkImpl groupLink) {
        this.removeConsumer(receiver.reference, receiver.underlyingConsumer, false, groupLink != null ? (RuntimeFabricGroup)groupLink.group : null);
    }

    @Override
    void removeReplyConsumer(ExtendedEventDispatcher.ReplyConsumer consumer) {
        this.removeConsumer(consumer.getUnderlyingConsumer().reference, consumer, false, null);
    }

    private void removeConsumer(EndpointReferenceImpl reference, NamedObject consumer, boolean fromClient, RuntimeFabricGroup group) {
        if (reference == null) {
            (group != null ? group.dispatcher : this.dispatcher).dropConsumer(consumer);
        } else if (reference.eventScope != EventScope.OBSERVABLE) {
            this.sysplexSynchronizer.invokeWithoutException(REMOVE_CONSUMER_METHOD, reference, consumer, fromClient, group);
        } else {
            this.doRemoveConsumer(reference, consumer, fromClient, group);
        }
    }

    private void doRemoveConsumer(EndpointReferenceImpl reference, NamedObject consumer, boolean fromClient, RuntimeFabricGroup group) {
        if (this.node.removeEndpoint(reference) != null) {
            ((RuntimeExchangeEventPublisher)((Object)(group != null ? group : this))).removeFromDispatcher(reference, consumer, fromClient);
            this.notifyOnRemoveEndpoint(reference);
            this.releaseAddress(reference.getAddress());
        }
    }

    @Override
    public void removeFromDispatcher(EndpointReferenceImpl reference, NamedObject consumer, boolean fromClient) {
        if (fromClient) {
            this.clientDispatcher.removeConsumer(reference);
        } else if (consumer instanceof ExtendedEventDispatcher.ReplyConsumer) {
            this.dispatcher.removeReplyConsumer((ExtendedEventDispatcher.ReplyConsumer)consumer);
        } else {
            this.dispatcher.dropConsumer(consumer);
        }
    }

    @Override
    EndpointReferenceImpl changeConsumer(AbstractExchange.ChangeConsumerData data) {
        if (data.reference.getEventScope() != EventScope.OBSERVABLE) {
            return (EndpointReferenceImpl)this.sysplexSynchronizer.invokeWithoutException(CHANGE_CONSUMER_METHOD, this.node, data, true);
        }
        return this.doChangeConsumer(this.node, data, false);
    }

    @Override
    EndpointReferenceImpl doChangeConsumer(FabricNode fabricNode, AbstractExchange.ChangeConsumerData data, boolean notifyNodes) {
        return super.doChangeConsumer(fabricNode, data, notifyNodes);
    }

    @Override
    void notifyOnChangeConsumer(AbstractExchange.ChangeConsumerData data, boolean notifyNodes) {
        this.notifyOnUpdate(12, data, data.reference.componentAddress, notifyNodes, data.reference, AbstractExchange.UpdateType.CHANGE);
    }

    @Override
    void addEventCache(Filter eventFilter, int maxSize, CacheThresholdAction thresholdAction, FabricAddress componentAddress) throws Exception {
        this.addEventCache(new EventCacheReferenceImpl(componentAddress, this.acquireAddress(), eventFilter, maxSize, thresholdAction), false);
    }

    private void addEventCache(EventCacheReferenceImpl reference, boolean fromClient) throws Exception {
        this.sysplexSynchronizer.invoke(ADD_EVENT_CACHE_METHOD, reference, fromClient);
    }

    private void doAddEventCache(EventCacheReferenceImpl reference, boolean fromClient) throws ExchangeException {
        this.checkEventCacheUniqueness(reference.cache.getEventFilter());
        if (fromClient) {
            ExchangeEventDispatcher.initQueue(reference.cache);
        }
        reference.bind(this);
        this.addEventCacheToRepository(reference);
        this.node.addEndpoint(reference);
        this.dispatcher.addEventCache(reference.cache);
        this.notifyOnAddEndpoint(reference);
    }

    @Override
    void removeEventCache(String eventFilter) {
        this.doRemoveEventCache(eventFilter, null);
    }

    private void removeEventCache(String eventFilter, FabricAddress clientAddress) {
        this.sysplexSynchronizer.invokeWithoutException(REMOVE_EVENT_CACHE_METHOD, eventFilter, clientAddress);
    }

    private void doRemoveEventCache(String eventFilter, FabricAddress clientAddress) {
        EventCacheReferenceImpl reference = this.removeEventCacheReference(eventFilter);
        if (reference != null) {
            if (this.isLocal(reference.address)) {
                this.doRemoveEventCache(reference);
            }
            this.notifyOnUpdate(9, reference, clientAddress, AbstractExchange.UpdateType.REMOVE, true);
        }
    }

    private void doRemoveEventCache(EventCacheReferenceImpl reference) {
        this.dispatcher.removeEventCache(reference.cache.getEventFilter());
        this.removeEventCacheFromRepository(reference.repositoryName);
        this.releaseAddress(reference.address);
    }

    void changeEventCache(EventCacheReferenceImpl reference, FabricAddress clientAddress) {
        this.sysplexSynchronizer.invokeWithoutException(CHANGE_EVENT_CACHE_METHOD, this.node, reference, clientAddress, true);
    }

    private void doChangeEventCache(FabricNode fabricNode, EventCacheReferenceImpl reference, FabricAddress clientAddress, boolean notifyNodes) {
        fabricNode.changeEventCache(reference);
        this.notifyOnUpdate(13, reference, clientAddress, AbstractExchange.UpdateType.CHANGE, notifyNodes);
    }

    private List<ImmutableEventDatagram> requestCachedEvents(CompositeFilter filter) {
        ArrayList<ImmutableEventDatagram> result = new ArrayList<ImmutableEventDatagram>();
        this.getFabricNodes().stream().filter(FabricNode::hasEventCaches).forEach(fabricNode -> {
            try {
                result.addAll((Collection)this.raiseInternalRequest(fabricNode.getFabricAddress(), 27, (Object)filter));
            }
            catch (Exception exception) {
                this.onError(exception, "Obtaining cached events failed.");
            }
        });
        return result;
    }

    void addEventCacheToRepository(EventCacheReferenceImpl reference) throws ExchangeException {
        try {
            if (reference.repositoryName == null) {
                reference.repositoryName = UUID.randomUUID().toString();
            }
            RepositoryUtils.bindObject(EVENT_CACHE_NAMESPACE, reference.repositoryName, (Object)reference.cache);
        }
        catch (ObjectConfigurationException exception) {
            throw new ExchangeException(6025, (Throwable)exception);
        }
    }

    private void removeEventCacheFromRepository(String name) {
        try {
            RepositoryUtils.unbindObject(EVENT_CACHE_NAMESPACE, name);
        }
        catch (ObjectConfigurationException exception) {
            this.logException(exception, true);
            this.logError("Removing event cache '" + name + "' from repository failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEventCaches() throws ExchangeException {
        block6: {
            try {
                ReferenceContext oldReferenceContext = this.context.repositoryAccessor.getReferenceContext();
                ReferenceContext referenceContext = this.context.repositoryAccessor.lookupReferenceContext(EVENT_CACHE_NAMESPACE);
                if (referenceContext == null) break block6;
                this.context.repositoryAccessor.setReferenceContext(referenceContext);
                try {
                    for (String name : this.context.repositoryAccessor.listObjectNames(null)) {
                        EventCache cache = (EventCache)this.context.repositoryAccessor.lookupObject(name);
                        this.checkEventCacheUniqueness(cache.getEventFilter());
                        EventCacheReferenceImpl reference = new EventCacheReferenceImpl(this.node.getFabricAddress(), this.acquireAddress(), cache.getEventFilter(), cache.getMaxSize(), cache.getThresholdAction());
                        reference.bind(this);
                        reference.repositoryName = name;
                        this.dispatcher.addEventCache(reference.cache);
                        this.node.addEventCache(reference);
                    }
                }
                finally {
                    this.context.repositoryAccessor.setReferenceContext(oldReferenceContext);
                }
            }
            catch (Exception exception) {
                throw new ExchangeException("Loading Event Caches failed.", (Throwable)exception);
            }
        }
    }

    private void notifyOnAddEndpoint(EndpointReferenceImpl reference) {
        this.notifyOnUpdate(8, reference, AbstractExchange.UpdateType.ADD);
    }

    private void notifyOnRemoveEndpoint(EndpointReferenceImpl reference) {
        this.notifyOnUpdate(9, reference, AbstractExchange.UpdateType.REMOVE);
    }

    private void notifyOnRemoveEndpoint(EndpointReferenceImpl reference, FabricAddress clientAddress) {
        this.notifyOnUpdate(9, reference, AbstractExchange.UpdateType.REMOVE);
    }

    private void setTimestamp(AbstractFabricComponent component) {
        component.setTimestamp();
        if (component.getOwnerName() != null) {
            this.setLastAccessTimestamp(ComponentReferenceImpl.getComponentModel(component), component.getType(), component.getOwnerName(), component.timestamp);
        }
    }

    private void setLastAccessTimestamp(ComponentReferenceImpl component) {
        if (component.getOwnerName() != null) {
            this.setLastAccessTimestamp(component.getModel(), ModeratorUtils.extractComponentNameType(component.getName()), component.getOwnerName(), component.getTimestamp());
        }
    }

    private void setLastAccessTimestamp(ComponentModel model, String componentType, String userName, long timestamp) {
        if (this.isRemoteClient(model, componentType)) {
            this.context.securityManagerImpl.setLastAccessTimestamp(userName, timestamp);
        }
    }

    void setLastFailedAttemptTimestamp(ComponentModel model, String componentType, String userName, SecurityManagerException exception) {
        if (this.isRemoteClient(model, componentType)) {
            this.context.securityManagerImpl.setLastFailedAttemptTimestamp(userName, System.currentTimeMillis());
            this.raiseSystemException(exception, EventScope.GLOBAL);
        }
    }

    private boolean isRemoteClient(ComponentModel model, String componentType) {
        return model == ComponentModel.REMOTE_CLIENT || model == ComponentModel.LOCAL_CLIENT && (componentType.equals("Client_HTTP") || componentType.equals("Client_HTTPS") || componentType.equals("Client_REST") || componentType.equals("Client_XMPP"));
    }

    @Override
    protected ExchangeDataConstraintStore createDataConstraintStore() {
        return new RuntimeDataConstraintStore(this);
    }

    void loadDataConstraints() throws Exception {
        DataConstraintPersistentStore persistentStore = new DataConstraintPersistentStore((RuntimeDataConstraintStore)this.globalDataConstraintStore);
        ((RuntimeDataConstraintStore)this.globalDataConstraintStore).load();
    }

    @Override
    EntityReferenceImpl addDataConstraint(AbstractExchange.DataConstraintReferenceCreator creator) throws Exception {
        return (EntityReferenceImpl)this.sysplexSynchronizer.invoke(ADD_DATA_CONSTRAINT_METHOD, creator);
    }

    private EntityReferenceImpl doAddDataConstraint(AbstractExchange.DataConstraintReferenceCreator creator) throws EventDispatcherException, ExchangeException {
        EntityReferenceImpl reference = creator.create();
        this.addDataConstraintReference(reference);
        this.notifyOnUpdate(18, reference, AbstractExchange.UpdateType.ADD);
        return reference;
    }

    @Override
    void removeDataConstraint(String name, ExchangeRole role) {
        this.removeDataConstraint(name, role, null);
    }

    private void removeDataConstraint(String name, ExchangeRole role, FabricAddress clientAddress) {
        this.sysplexSynchronizer.invokeWithoutException(REMOVE_DATA_CONSTRAINT_METHOD, new Object[]{name, role, clientAddress});
    }

    private void doRemoveDataConstraint(String name, ExchangeRole role, FabricAddress clientAddress) {
        EntityReferenceImpl reference = this.removeDataConstraintReference(name, role);
        if (reference != null) {
            this.removeDataConstraintFromStore(name, role);
            this.notifyOnUpdate(19, reference, clientAddress, AbstractExchange.UpdateType.REMOVE, reference.eventScope != EventScope.OBSERVABLE);
        }
    }

    @Override
    void changeDataConstraint(AbstractFabricDataConstraint.Updater updater, boolean notifyNode) throws Exception {
        this.changeDataConstraint(updater, null);
    }

    private void changeDataConstraint(AbstractFabricDataConstraint.Updater updater, FabricAddress clientAddress) throws Exception {
        this.sysplexSynchronizer.invoke(CHANGE_DATA_CONSTRAINT_METHOD, updater, clientAddress, true);
    }

    private void doChangeDataConstraint(AbstractFabricDataConstraint.Updater updater, FabricAddress clientAddress, boolean notifyNodes) throws Exception {
        if (this.updateDataConstraintInStore(updater)) {
            this.notifyOnUpdate(20, (Object)updater, clientAddress, notifyNodes, updater.name, updater.exchangeRole, AbstractExchange.UpdateType.CHANGE);
        }
    }

    private void synchronizeDataConstraintsInSysplex(Map<String, DomainConstraintReferenceImpl> nodeDomainConstraints, Map<String, RangeConstraintReferenceImpl> nodeRangeConstraints, boolean newOnly) {
        this.logDebug("Data Constraints synchronization...");
        if (!newOnly) {
            Utils.removeAll(nodeDomainConstraints, this.globalDomainConstraints);
            Utils.removeAll(nodeRangeConstraints, this.globalRangeConstraints);
        }
        this.globalDataConstraintStore.synchronizeInSysplex(nodeDomainConstraints, nodeRangeConstraints);
        this.globalDomainConstraints.putAll(nodeDomainConstraints);
        this.globalRangeConstraints.putAll(nodeRangeConstraints);
        this.logInfo("Data Constraints synchronized.");
    }

    private void synchronizeDataConstraintsInNode(Map<String, DomainConstraintReferenceImpl> sysplexDomainConstraints, Map<String, RangeConstraintReferenceImpl> sysplexRangeConstraints) {
        this.logDebug("Data Constraints synchronization...");
        this.globalDataConstraintStore.synchronizeInNode(sysplexDomainConstraints, sysplexRangeConstraints);
        this.globalDomainConstraints.putAll(sysplexDomainConstraints);
        this.globalRangeConstraints.putAll(sysplexRangeConstraints);
        this.logInfo("Data Constraints synchronized.");
    }

    private Map<String, DomainConstraintReferenceImpl> getDomainConstraintsCopy() {
        return new HashMap<String, DomainConstraintReferenceImpl>(this.globalDomainConstraints);
    }

    private Map<String, RangeConstraintReferenceImpl> getRangeConstraintsCopy() {
        return new HashMap<String, RangeConstraintReferenceImpl>(this.globalRangeConstraints);
    }

    private void notifyOnUpdate(int eventId, EntityReferenceImpl reference, AbstractExchange.UpdateType updateType) {
        this.notifyOnUpdate(eventId, reference, updateType, reference.eventScope != EventScope.OBSERVABLE);
    }

    private void notifyOnUpdate(int eventId, EntityReferenceImpl reference, AbstractExchange.UpdateType updateType, boolean notifyNodes) {
        this.notifyOnUpdate(eventId, reference, reference.componentAddress, updateType, notifyNodes);
    }

    private void notifyOnUpdate(int eventId, EntityReferenceImpl reference, FabricAddress clientAddress, AbstractExchange.UpdateType updateType, boolean notifyNodes) {
        this.notifyOnUpdate(eventId, reference, clientAddress, notifyNodes, reference, updateType);
    }

    private void notifyOnUpdate(int eventId, Object data, FabricAddress clientAddress, boolean notifyNodes, ModeratorAdvisoryType advisoryType, String advisoryEntity, String advisoryInfo) {
        this.doNotifyOnUpdate(eventId, data, clientAddress, notifyNodes);
        this.onSysplexUpdate(advisoryType, advisoryEntity, advisoryInfo);
    }

    private void notifyOnUpdate(int eventId, Object data, FabricAddress clientAddress, boolean notifyNodes, String advisoryEntity, ExchangeRole entityRole, AbstractExchange.UpdateType updateType) {
        this.doNotifyOnUpdate(eventId, data, clientAddress, notifyNodes);
        this.onSysplexUpdate(advisoryEntity, entityRole, updateType);
    }

    private void notifyOnUpdate(int eventId, Object data, FabricAddress clientAddress, boolean notifyNodes, EntityReference entity, AbstractExchange.UpdateType updateType) {
        this.doNotifyOnUpdate(eventId, data, clientAddress, notifyNodes);
        this.onSysplexUpdate(entity, updateType);
    }

    private void doNotifyOnUpdate(int eventId, Object data, FabricAddress clientAddress, boolean notifyNodes) {
        this.broadcastWithAckToClients(eventId, data, clientAddress);
        if (notifyNodes) {
            this.broadcastWithAckToNodes(eventId, data);
        }
    }

    private Map<FabricAddress, Object> broadcastWithAckToNodes(int eventId, Object data) {
        return this.doBroadcastWithAckToNodes(this.broadcastAckListener, eventId, data, this.broadcastReplyTimeout, false, false);
    }

    private Map<FabricAddress, Object> broadcastWithAckToNodes(int eventId, Object data, long timeout) {
        return this.doBroadcastWithAckToNodes(this.broadcastAckListener, eventId, data, timeout, false, false);
    }

    private Map<FabricAddress, Object> broadcastWithAckToNodesSpecial(int eventId, Object data) {
        return this.doBroadcastWithAckToNodes(this.broadcastAckListener, eventId, data, this.broadcastReplyTimeout, true, false);
    }

    private Map<FabricAddress, Object> broadcastWithAckToNodesUser(int eventId, Object data) {
        return this.doBroadcastWithAckToNodesUser(eventId, data, this.broadcastReplyTimeout, false);
    }

    private synchronized Map<FabricAddress, Object> doBroadcastWithAckToNodes(BroadcastAckListener ackListener, int eventId, Object data, long timeout, boolean special, boolean mnodesOnly) {
        try {
            if (!this.nodeConnections.isEmpty()) {
                ackListener.reset(eventId, data, timeout, this.getNodesNumber(mnodesOnly));
                this.doBroadcastToNodes(eventId, data, special, mnodesOnly);
                ackListener.waitAck();
                ackListener.processAcks();
                return ackListener.acks;
            }
        }
        catch (Exception exception) {
            this.logException(exception, true, "Broadcast of internal event [" + this.broadcastAckListener.eventName + "] failed.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<FabricAddress, Object> doBroadcastWithAckToNodesUser(int eventId, Object data, long timeout, boolean mnodesOnly) {
        if (!this.nodeConnections.isEmpty()) {
            UserNodeBroadcastAckListener ackListener = new UserNodeBroadcastAckListener(eventId, data, timeout, this.getNodesNumber(mnodesOnly));
            long iEvent = this.userBroadcastAckListener.addListener(ackListener);
            try {
                this.doBroadcastToNodes(eventId, this.createConcurrentInternalEvent(eventId, data, iEvent, mnodesOnly), false, mnodesOnly);
                ackListener.waitAck();
                ackListener.processAcks();
            }
            catch (Exception exception) {
                this.logException(exception, true, "Broadcast of internal event [" + (String)INTERNAL_EVENT_NAMES.get(eventId) + "] failed.");
            }
            finally {
                this.userBroadcastAckListener.removeListener(iEvent);
            }
            return ackListener.acks;
        }
        return null;
    }

    private int getNodesNumber(boolean mnodesOnly) {
        return mnodesOnly ? this.getMNodesNumber() : this.getFabricNodesNumber();
    }

    private void broadcastToNodesSpecial(int eventId, Object data) {
        this.broadcastToNodes(eventId, data, true);
    }

    private void broadcastToNodes(int eventId, Object data, boolean special) {
        this.broadcastToNodes(eventId, data, special, false);
    }

    private void broadcastToNodes(int eventId, Object data, boolean special, boolean mnodesOnly) {
        try {
            if (!this.nodeConnections.isEmpty()) {
                this.doBroadcastToNodes(eventId, data, special, mnodesOnly);
            }
        }
        catch (Exception exception) {
            this.logException(exception, true, "Broadcast of internal event [" + (String)INTERNAL_EVENT_NAMES.get(eventId) + "] failed.");
        }
    }

    private void doBroadcastToNodes(int eventId, Object data, boolean special, boolean mnodesOnly) throws Exception {
        this.doBroadcastToNodes(eventId, this.createInternalEvent(eventId, data), special, mnodesOnly);
    }

    private synchronized void doBroadcastToNodes(int eventId, AbstractExchange.InternalEvent event, boolean special, boolean mnodesOnly) throws Exception {
        ByteBuffer packet;
        this.logBroadcast(eventId, event);
        ByteBuffer byteBuffer = packet = special ? this.packBroadcastEventSpecial(RuntimeExchange.getSpecialEventType(eventId), event) : this.packBroadcastEvent(event);
        if (mnodesOnly) {
            this.doBroadcastToMNodes(eventId, packet);
        } else {
            this.doBroadcastToNodes(eventId, packet);
        }
    }

    private void logBroadcast(int eventId, AbstractExchange.InternalEvent event) {
        if (event.data instanceof SlangData) {
            SlangData data = (SlangData)event.data;
            if (!RuntimeExchange.suppressLog(data)) {
                this.logDebug("Broadcasting SLANG operation '" + data.statement.getName() + "' (by user " + data.session.getOwnerName() + ") to nodes...");
            }
        } else if (!this.suppressLog(event.data)) {
            this.logDebug("Broadcasting event [" + this.getInternalEventName(eventId) + "] to nodes...");
        }
    }

    private void doBroadcastToNodes(int eventId, ByteBuffer packet) {
        this.doBroadcastToNodes(eventId, packet, new ArrayList<ExchangeConnection>(this.nodeConnections.values()));
    }

    private void doBroadcastToNodes(int eventId, ByteBuffer packet, List<ExchangeConnection> connections) {
        for (ExchangeConnection connection : connections) {
            try {
                connection.raiseInternalEvent(packet);
            }
            catch (Exception exception) {
                this.logInternalEventError(exception, eventId);
            }
        }
    }

    private void doBroadcastToMNodes(int eventId, ByteBuffer packet) {
        for (Map.Entry<FabricAddress, NodeExchangeConnection> entry : new ArrayList<Map.Entry<FabricAddress, NodeExchangeConnection>>(this.nodeConnections.entrySet())) {
            try {
                FabricNode node = this.getFabricNode(entry.getKey());
                if (node.getRole() != FabricNodeRole.MANAGEMENT_NODE) continue;
                entry.getValue().raiseInternalEvent(packet);
            }
            catch (Exception exception) {
                this.logInternalEventError(exception, eventId);
            }
        }
    }

    private static byte getSpecialEventType(int eventId) {
        return (byte)(eventId == 5 || eventId == 110 ? 4 : 3);
    }

    private ByteBuffer packBroadcastEvent(AbstractExchange.InternalEvent event) throws FabricException {
        byte[] source = this.node.getFabricAddress().toBinary();
        ByteBuffer header = ByteBuffer.allocate(19);
        header.put((byte)2).put(source).putLong(++this.iBroadcastEvent);
        return this.doPackBroadcastEvent(event, header);
    }

    private ByteBuffer packBroadcastEventSpecial(byte eventType, AbstractExchange.InternalEvent event) throws FabricException {
        byte[] source = this.node.getName().getBytes();
        ByteBuffer header = ByteBuffer.allocate(17 + source.length);
        header.put(eventType).putInt(source.length).put(source).putLong(++this.iBroadcastEvent);
        return this.doPackBroadcastEvent(event, header);
    }

    private ByteBuffer doPackBroadcastEvent(AbstractExchange.InternalEvent event, ByteBuffer header) throws FabricException {
        ByteBuffer packet = this.serialize(event, header);
        return packet.putInt(header.limit() - 4, packet.limit() - header.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<FabricAddress, Object> broadcastWithAckToClients(int eventId, Object data, FabricAddress excludedAddress) {
        if (!this.clientConnections.isEmpty()) {
            ClientBroadcastAckListener ackListener = new ClientBroadcastAckListener(eventId, excludedAddress);
            long iEvent = this.clientBroadcastAckListener.addListener(ackListener);
            try {
                ackListener.setRecipients(this.doBroadcastToClients(eventId, data, iEvent, excludedAddress));
                ackListener.waitAck();
                ackListener.processAcks();
            }
            catch (Exception exception) {
                this.logException(exception, true, "Broadcast of internal event [" + (String)INTERNAL_EVENT_NAMES.get(eventId) + "] failed.");
            }
            finally {
                this.clientBroadcastAckListener.removeListener(iEvent);
            }
            return ackListener.acks;
        }
        return null;
    }

    private int doBroadcastToClients(int eventId, Object data, long iEvent, FabricAddress excludedAddress) throws Exception {
        if (!this.suppressLog(data)) {
            this.logDebug("Broadcasting event [" + this.getInternalEventName(eventId) + "] to clients...");
        }
        int nSentEvents = 0;
        byte[] packet = this.pack((byte)0, FabricAddress.NULL, this.node.getFabricAddress(), this.serialize(this.createConcurrentInternalEvent(eventId, data, iEvent)));
        for (AbstractExchange.AbstractExchangeConnection abstractExchangeConnection : new ArrayList<ClientExchangeConnection>(this.clientConnections.values())) {
            try {
                if (!abstractExchangeConnection.isSuitableForBroadcast(excludedAddress)) continue;
                abstractExchangeConnection.raiseInternalEvent(packet);
                ++nSentEvents;
            }
            catch (Exception exception) {
                this.logInternalEventError(exception, eventId);
            }
        }
        return nSentEvents;
    }

    private Map<String, Object> convertBroadcastResponse(Map<FabricAddress, Object> responses) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        responses.forEach((key, value) -> result.put(this.getFabricNodeName((FabricAddress)key), value));
        return result;
    }

    void raiseSystemAdvisory(AdvisoryEvent advisory, EventScope eventScope, boolean forClients) throws EventDispatcherException, FabricException, EventException, FabricEventSourceException, FabricEventException {
        this.coalesce(advisory);
        this.dispatcher.raiseEvent(advisory);
        if (forClients) {
            this.clientDispatcher.raiseEvent((ImmutableEventDatagram)advisory, (FabricAddress)null, null);
        }
        if (eventScope != EventScope.OBSERVABLE) {
            this.networkDispatcher.raiseEvent(advisory, eventScope, null);
        }
    }

    private void raiseSystemAdvisory(AdvisoryEvent advisory) {
        try {
            this.raiseSystemAdvisory(advisory, EventScope.GLOBAL, true);
        }
        catch (Exception exception) {
            this.logException(exception, true);
            this.logError("Raising [" + advisory.getEventId() + "] advisory failed.");
        }
    }

    void raiseSystemException(ExceptionEventDatagram exception, EventScope scope) {
        this.coalesce(exception);
        this.raiseException(exception, scope, this.getNodeAddress(), true);
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, FabricAddress componentAddress, EventScope eventScope) throws EventException, FabricException, FabricEventSourceException, FabricEventException {
        this.raiseEvent(event, componentAddress, eventScope, null);
    }

    void raiseEvent(ImmutableEventDatagram event, FabricAddress componentAddress, EventScope eventScope, ByteBuffer eventBuffer) throws EventException, FabricException, FabricEventSourceException, FabricEventException {
        this.dispatcher.raiseEvent(event, componentAddress, eventScope);
        this.raiseEventToNetwork(event, componentAddress, eventScope, eventBuffer);
    }

    @Override
    ImmutableEventDatagram raiseRequest(RequestConsumerReferenceImpl consumer, ImmutableEventDatagram request, long timeout) throws EventDispatcherException, RequestException, FabricException, TimeoutException {
        if (this.isLocal(consumer.address)) {
            if (consumer instanceof AbstractExchange.ClientRequestConsumer) {
                return ((AbstractExchange.ClientRequestConsumer)consumer).raiseRequest(consumer.address, request, timeout);
            }
            return this.raiseRequestLocal(consumer, request, timeout);
        }
        if (this.isEventGlobal(request)) {
            return this.networkDispatcher.raiseRequest(consumer.address, request, timeout, consumer.skipCheck());
        }
        throw new EventDispatcherException("Semantic type of event payload is not global. Request cannot be raised to remote node.");
    }

    @Override
    RequestConsumerReferenceImpl getRequestConsumer(FabricAddress consumerAddress) {
        AccessorSessionReferenceImpl result = this.node.doGetAccessorSession(consumerAddress);
        return result != null ? result : super.getRequestConsumer(consumerAddress);
    }

    @Override
    void deliverEvent(EventDatagram event, FabricAddress componentAddress, EventScope eventScope) throws FabricException, EventException, FabricEventSourceException, FabricEventException {
        this.dispatcher.deliverEvent(event, componentAddress);
        this.raiseEventToNetwork(event, componentAddress, eventScope, null);
    }

    void raiseEventToNetwork(ImmutableEventDatagram event, FabricAddress componentAddress, EventScope eventScope, ByteBuffer eventBuffer) throws FabricException, FabricEventSourceException, FabricEventException {
        this.clientDispatcher.raiseEvent(event, componentAddress, eventBuffer);
        if (eventScope != EventScope.OBSERVABLE && this.isEventGlobal(event)) {
            if (eventBuffer != null) {
                eventBuffer.position(1);
            }
            this.networkDispatcher.raiseEvent(event, eventScope, eventBuffer);
        }
    }

    private boolean isEventGlobal(ImmutableEventDatagram event) {
        return ((RuntimeDatagramPrototypeFactory)this.context.datagramPrototypeFactory).isPrototypeGlobal(null, event);
    }

    @Override
    void initConnectionFactory() {
        this.connectionFactory = new ExchangeConnectionFactoryImpl(this.workerPoolType, (int)this.workerPoolSize);
        this.connectionFactory.addConnectionStateHandler((byte)1, new NodeConnectionStateHandler());
        this.connectionFactory.addConnectionStateHandler((byte)2, new ClientConnectionStateHandler());
        this.connectionFactory.addConnectionStateHandler((byte)3, new DiagnosticConnectionStateHandler());
    }

    @Override
    AbstractExchange.AbstractExchangeConnection establishConnection(LinkAddress address, long timeout) throws FabricException {
        return this.establishConnection(address, timeout, (byte)1);
    }

    @Override
    ExchangeConnection createConnection(Connection networkConnection) {
        return new NodeExchangeConnection(networkConnection);
    }

    @Override
    AbstractExchange.NetworkConsumersStore getNetworkDispatcher() {
        return this.networkDispatcher;
    }

    private ClientNetworkEventDispatcher getClientDispatcher(NetworkExchangeConsumer consumer) {
        RuntimeFabricGroup group;
        if (consumer.getGroupName() != null && (group = (RuntimeFabricGroup)this.groupManager.lookupGroup(consumer.getGroupName())) != null) {
            return group.getClientDispatcher();
        }
        return this.clientDispatcher;
    }

    @Override
    protected ExchangeConnection getConnection(FabricAddress address) throws ExchangeException {
        ExchangeConnection result;
        if (this.isLocal(address)) {
            result = this.getClient(address);
            if (result == null) {
                throw new ExchangeException(6015, "Connection to client '" + String.valueOf(address) + "' not established.");
            }
        } else {
            FabricAddress nodeAddress = address.getNodeAddress();
            result = this.getNodeConnection(nodeAddress);
            if (result == null) {
                FabricAddress destination = this.routingTable.getDestination(nodeAddress);
                if (destination != null) {
                    result = this.getNodeConnection(destination);
                } else if (this.joinConnection != null && ((FabricAddress)this.joinConnection.first).equals(nodeAddress)) {
                    result = (ExchangeConnection)this.joinConnection.second;
                } else if (this.sysplexSynchronizer.joiningConnection != null) {
                    result = this.sysplexSynchronizer.joiningConnection;
                }
                if (result == null) {
                    throw new ExchangeException(6015, "Connection to node " + this.getFabricNodePrintName(nodeAddress) + " not established.");
                }
            }
        }
        return result;
    }

    NodeExchangeConnection getNodeConnection(FabricAddress address) {
        return this.nodeConnections.get(address);
    }

    List<FabricAddress> getNodeConnectionAddresses() {
        return new ArrayList<FabricAddress>(this.nodeConnections.keySet());
    }

    private void reAddComponent(AbstractFabricComponent component, AbstractExchange.ReAddComponentData data, ClientExchangeConnection connection) throws Exception {
        if (component.getEventScope() == EventScope.GLOBAL) {
            this.sysplexSynchronizer.invoke(RE_ADD_COMPONENT_METHOD, component, data, connection);
        } else {
            this.doReAddComponent(component, data, connection);
        }
    }

    private void doReAddComponent(AbstractFabricComponent component, AbstractExchange.ReAddComponentData data, ClientExchangeConnection connection) throws Exception {
        this.checkComponentUniqueness(component.getType(), component.getName(), ComponentModel.REMOTE_CLIENT);
        this.acquireAddress(component);
        this.setTimestamp(component);
        data.reference.update(this, ModeratorUtils.makeComponentFullName(this.node.getName(), component), component.getFabricAddress());
        this.addConsumers(data, connection);
        data.reference.updateConsumers(data, false);
        component.bind(this, data.reference);
        this.node.addComponent(data.reference);
        this.notifyOnUpdate(10, data.copyWithGlobalScope(), data.reference.componentAddress, data.reference.eventScope != EventScope.OBSERVABLE, data.reference, AbstractExchange.UpdateType.ADD);
        this.logDebug("Component '" + data.reference.getName() + "' added.");
    }

    private void addConsumers(AbstractExchange.ReAddComponentData data, ClientExchangeConnection connection) throws Exception {
        this.doAddConsumers(data.reference, data.directConsumers, connection);
        this.doAddConsumers(data.reference, data.asyncConsumers, connection);
        this.doAddConsumers(data.reference, data.requestConsumers, connection);
        this.doAddConsumers(data.reference, data.receivers, connection);
    }

    private <T extends EndpointReferenceImpl> void doAddConsumers(ComponentReferenceImpl component, Map<String, T> consumers, ClientExchangeConnection connection) throws Exception {
        if (consumers != null) {
            for (EndpointReferenceImpl consumer : consumers.values()) {
                connection.addClientConsumer(component, consumer);
            }
        }
    }

    private void bindClientConnection(Address address, FabricAddress fabricAddress) {
        ClientExchangeConnection connection = (ClientExchangeConnection)this.unboundConnections.remove(address);
        if (connection != null) {
            connection.isValid = false;
            connection.bind(fabricAddress);
            this.clientConnections.put(fabricAddress, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForClientConnection() throws InterruptedException {
        Object object = this.clientMutex;
        synchronized (object) {
            while (this.isClientConnecting) {
                this.clientMutex.wait();
            }
            this.isClientConnecting = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnClientConnectionCompletion() {
        Object object = this.clientMutex;
        synchronized (object) {
            this.isClientConnecting = false;
            this.clientMutex.notifyAll();
        }
    }

    ClientExchangeConnection getClient(FabricAddress address) {
        return this.clientConnections.get(address);
    }

    private void detachClients() {
        this.logDebug("Detaching clients...");
        this.broadcastWithAckToClients(5, null, null);
        for (AbstractExchange.AbstractExchangeConnection abstractExchangeConnection : this.clientConnections.values()) {
            abstractExchangeConnection.close(true);
        }
        this.clientConnections.clear();
        this.logInfo("All clients detached.");
    }

    void detachClient(ClientExchangeConnection client, boolean kill) {
        this.logDebug("Detaching client '" + String.valueOf(client) + "'...");
        try {
            if (kill) {
                client.raiseInternalRequest(55, null, this.fastReplyTimeout);
            }
        }
        catch (Throwable exception) {
            this.logInternalRequestError(exception, 55);
        }
        client.close(true);
        this.logDebug("Client '" + String.valueOf(client) + "' detached.");
    }

    private void detachClient(FabricAddress address, boolean kill) {
        ClientExchangeConnection client = this.getClient(address);
        if (client != null) {
            this.detachClient(client, kill);
        }
    }

    private void removeClient(FabricAddress address, boolean forcibly) {
        ClientExchangeConnection connection = this.clientConnections.remove(address);
        if (connection != null) {
            connection.isValid = false;
            connection.removeClient();
            this.onSysplexUpdate(forcibly ? ModeratorAdvisoryType.CLIENT_DISCONNECTED_FORCIBLY : ModeratorAdvisoryType.CLIENT_DISCONNECTED, connection.component.reference.getName());
            this.processClientThreshold("TLP", this.clientConnections.size());
        }
    }

    List<ClientInfo> getTLPClients() {
        return new ArrayList<ClientExchangeConnection>(this.clientConnections.values()).stream().map(RuntimeExchange::makeClientInfo).collect(Collectors.toList());
    }

    List<ClientInfo> getHTTPClients() {
        return new ArrayList<AbstractHTTPServerFabricConnection>(this.httpFabricConnections.values()).stream().map(AbstractHTTPServerFabricConnection::getClientInfo).collect(Collectors.toList());
    }

    List<ClientInfo> getXMPPClients() {
        return new ArrayList<AbstractXMPPFabricConnection>(this.xmppFabricConnections.values()).stream().map(AbstractXMPPFabricConnection::getClientInfo).collect(Collectors.toList());
    }

    ClientInfo getClientInfo(ComponentReference component) {
        if (component.getModel() == ComponentModel.REMOTE_CLIENT) {
            ClientExchangeConnection client = this.getClient(component.getAddress());
            if (client != null) {
                return RuntimeExchange.makeClientInfo(client);
            }
        } else {
            LocalFabricConnection connection = this.getExternalConnection(component);
            if (connection != null) {
                return connection.getClientInfo();
            }
        }
        return null;
    }

    private static ClientInfo makeClientInfo(ClientExchangeConnection client) {
        return new ClientInfo(client.component.reference, LinkProtocol.TLP, client.getAcceptorName(), client.getNetworkAddress().getAddress());
    }

    LocalFabricConnection getExternalConnection(ComponentReference component) {
        LocalFabricConnection connection = null;
        if (component.getModel() == ComponentModel.LOCAL_CLIENT && (connection = (LocalFabricConnection)this.httpFabricConnections.get(component.getName())) == null) {
            connection = this.xmppFabricConnections.get(component.getName());
        }
        return connection;
    }

    private void executeScavenger() {
        if (this.outOfMemory) {
            this.logWarning("OutOfMemoryError was caught earlier. Scavenger will not be executed.");
        } else {
            this.sysplexSynchronizer.invokeWithoutException(EXECUTE_SCAVENGER_METHOD, new Object[0]);
        }
    }

    private void doExecuteScavenger() {
        this.scavenger.execute();
    }

    private void synchronizeGlobalVariablesInSysplex(SysGlobals nodeSysGlobals) {
        try {
            this.logDebug("Global Variables synchronization...");
            this.context.globalVariableFactory.mergeSysGlobals(nodeSysGlobals);
            this.logInfo("Global Variables synchronized.");
        }
        catch (Exception exception) {
            this.logException(exception, true, "Synchronization of Global Variables failed.");
        }
    }

    void updateGlobalVariables(String methodName, Object ... parameters) throws UnresolvedVariableException, GlobalVariableFactoryException {
        try {
            this.sysplexSynchronizer.invoke(UPDATE_GLOBAL_VARIABLES_METHOD, methodName, parameters);
        }
        catch (Exception exception) {
            if (exception instanceof UnresolvedVariableException) {
                throw (UnresolvedVariableException)exception;
            }
            if (exception instanceof GlobalVariableFactoryException) {
                throw (GlobalVariableFactoryException)exception;
            }
            throw new GlobalVariableFactoryException("Unexpected exception", exception);
        }
    }

    private void doUpdateGlobalVariables(String methodName, Object ... parameters) throws UnresolvedVariableException, GlobalVariableFactoryException {
        this.context.globalVariableFactory.invokeOperation(methodName, parameters);
        this.broadcastWithAckToNodes(117, this.context.globalVariableFactory.sysGlobals);
    }

    private SysGlobals getSysGlobals() {
        return this.context.globalVariableFactory.sysGlobals;
    }

    private void synchronizeSysGlobals(SysGlobals sysGlobals, boolean compare) {
        try {
            this.logDebug("Global Variables synchronization...");
            this.context.globalVariableFactory.replaceSysGlobals(sysGlobals, compare);
            this.logInfo("Global Variables synchronized.");
        }
        catch (Exception exception) {
            this.logException(exception, true, "Updating global variables in repository failed.");
        }
    }

    Object updateSecurity(RuntimeSecurityManagerProxy proxy, String coreMethodName, String methodName, Object ... parameters) throws SecurityManagerException {
        try {
            if (proxy.currentUser != null) {
                return this.sysplexSynchronizer.invoke(UPDATE_SECURITY_METHOD1, proxy, coreMethodName, methodName, parameters);
            }
            return this.doUpdateSecurityCore(proxy, coreMethodName, parameters);
        }
        catch (Throwable exception) {
            throw this.processSecurityException(exception);
        }
    }

    private Object doUpdateSecurity(RuntimeSecurityManagerProxy proxy, String coreMethodName, String methodName, Object ... parameters) throws Exception {
        Object result = this.doUpdateSecurityCore(proxy, coreMethodName, parameters);
        this.broadcastWithAckToNodes(119, new AbstractExchange.OperationData(methodName, parameters));
        return result;
    }

    Object updateSecurity(RuntimeSecurityManagerProxy proxy, String coreMethodName, String methodName, Class[] parameterTypes, Object ... parameters) throws SecurityManagerException {
        try {
            if (proxy.currentUser != null) {
                return this.sysplexSynchronizer.invoke(UPDATE_SECURITY_METHOD2, proxy, coreMethodName, methodName, parameterTypes, parameters);
            }
            return this.doUpdateSecurityCore(proxy, coreMethodName, parameterTypes, parameters);
        }
        catch (Throwable exception) {
            throw this.processSecurityException(exception);
        }
    }

    private Object doUpdateSecurity(RuntimeSecurityManagerProxy proxy, String coreMethodName, String methodName, Class[] parameterTypes, Object ... parameters) throws Exception {
        Object result = this.doUpdateSecurityCore(proxy, coreMethodName, parameterTypes, parameters);
        this.broadcastWithAckToNodes(119, new AbstractExchange.OperationData(methodName, parameterTypes, parameters));
        return result;
    }

    Object updateSecurity(RuntimeSecurityManagerProxy proxy, String coreMethodName, Object[] coreParameters, String methodName, Object ... parameters) throws SecurityManagerException {
        try {
            if (proxy.currentUser != null) {
                return this.sysplexSynchronizer.invoke(UPDATE_SECURITY_METHOD3, proxy, coreMethodName, coreParameters, methodName, parameters);
            }
            return this.doUpdateSecurityCore(proxy, coreMethodName, coreParameters);
        }
        catch (Throwable exception) {
            throw this.processSecurityException(exception);
        }
    }

    private Object doUpdateSecurity(RuntimeSecurityManagerProxy proxy, String coreMethodName, Object[] coreParameters, String methodName, Object ... parameters) throws Exception {
        Object result = this.doUpdateSecurityCore(proxy, coreMethodName, coreParameters);
        if (parameters.length > 1 && parameters[1] == null) {
            parameters[1] = result;
        }
        this.broadcastWithAckToNodes(119, new AbstractExchange.OperationData(methodName, parameters));
        return result;
    }

    private Object doUpdateSecurityCore(RuntimeSecurityManagerProxy proxy, String methodName, Object[] parameters) throws Exception {
        return this.doUpdateSecurityCore(proxy, methodName, this.getParameterTypes(parameters), parameters);
    }

    private Object doUpdateSecurityCore(RuntimeSecurityManagerProxy proxy, String methodName, Class[] parameterTypes, Object[] parameters) throws Exception {
        return RuntimeSecurityManagerProxy.class.getDeclaredMethod(methodName, parameterTypes).invoke((Object)proxy, parameters);
    }

    private SecurityManagerException processSecurityException(Throwable exception) {
        if (exception instanceof InvocationTargetException) {
            exception = ((InvocationTargetException)exception).getTargetException();
        }
        if (exception instanceof SecurityManagerException) {
            return (SecurityManagerException)exception;
        }
        return new SecurityManagerException(6011, "Unexpected exception", exception);
    }

    Object invokeSecurityOperation(AbstractExchange.OperationData data, ExchangeConnection connection, boolean isEvent) throws ExchangeException {
        try {
            Method method = RuntimeSecurityManagerProxy.class.getDeclaredMethod(data.methodName, this.getParameterTypes(data));
            return method.invoke((Object)connection.securityManager, data.parameters);
        }
        catch (InvocationTargetException exception) {
            if (exception.getCause() instanceof SecurityManagerException && !isEvent) {
                return exception.getCause();
            }
            throw new ExchangeException("Processing of internal " + (isEvent ? "event [" + (String)INTERNAL_EVENT_NAMES.get(119) : "request [" + (String)INTERNAL_EVENT_NAMES.get(32)) + "] failed.", exception.getCause());
        }
        catch (Exception exception) {
            throw new ExchangeException("Processing of internal " + (isEvent ? "event [" + (String)INTERNAL_EVENT_NAMES.get(119) : "request [" + (String)INTERNAL_EVENT_NAMES.get(32)) + "] failed.", (Throwable)exception);
        }
    }

    void onSecurityUpdate(SecurityAdvisory advisory) {
        try {
            this.granteeManager.onSecurityUpdate(advisory);
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Update security operation '" + String.valueOf((Object)advisory.getType()) + "(" + advisory.getEntity() + ")' in Dataspace failed.");
        }
        this.executeInSystemThreadPool(() -> this.doOnSecurityUpdate(advisory));
    }

    private void doOnSecurityUpdate(SecurityAdvisory advisory) {
        if (this.isStarted) {
            this.coalesce(advisory);
            try {
                this.dispatcher.raiseEvent(advisory);
                this.clientDispatcher.raiseEvent((ImmutableEventDatagram)advisory, (FabricAddress)null, null);
            }
            catch (Exception exception) {
                this.logException(exception, true, "Raising of system advisory 'advisory.Security' failed.");
            }
        }
    }

    boolean isOwnerActive(String ownerName) {
        Map<FabricAddress, Object> acks = this.broadcastWithAckToNodes(132, ownerName);
        return acks != null && acks.values().stream().anyMatch(ack -> ack instanceof Boolean && (Boolean)ack != false);
    }

    List<ComponentReference> getOwnerComponents(String ownerName) {
        ArrayList<ComponentReference> result = new ArrayList<ComponentReference>();
        Map<FabricAddress, Object> acks = this.broadcastWithAckToNodes(133, ownerName);
        if (acks != null) {
            for (Object ack : acks.values()) {
                if (!(ack instanceof List)) continue;
                result.addAll((List)ack);
            }
        }
        return result;
    }

    private User doAuthenticate(String userName, String credentials, AbstractExchange.NetworkConnectionImpl connection) throws SecurityManagerException {
        try {
            return userName != null ? this.context.securityManagerImpl.authenticate(userName, credentials, connection.getSecurityKey()) : this.context.securityManagerImpl.authenticate(credentials);
        }
        catch (SecurityManagerException exception) {
            this.setLastFailedAttemptTimestamp(ComponentModel.REMOTE_CLIENT, null, userName, exception);
            throw exception;
        }
    }

    Object invokeRepositoryOperation(AbstractExchange.OperationData data, ExchangeConnection connection) throws FabricException {
        try {
            Method method = RuntimeRepositoryAccessorImpl.class.getDeclaredMethod(data.methodName, this.getParameterTypes(data));
            return method.invoke((Object)connection.repositoryAccessor, data.parameters);
        }
        catch (InvocationTargetException exception) {
            if (exception.getCause() instanceof RepositoryException) {
                return exception.getCause();
            }
            if (exception.getCause() instanceof InterruptedException) {
                return exception.getCause();
            }
            throw new FabricException("Processing of internal request [" + (String)INTERNAL_EVENT_NAMES.get(34) + "] failed.", exception.getCause());
        }
        catch (Exception exception) {
            throw new FabricException("Processing of internal request [" + (String)INTERNAL_EVENT_NAMES.get(34) + "] failed.", exception);
        }
    }

    void onStartAcceptor(LinkAddress address, boolean isTLP) {
        this.sysplexSynchronizer.invokeWithoutException(ON_START_ACCEPTOR_METHOD, address, isTLP);
    }

    private void doOnStartAcceptor(LinkAddress address, boolean isTLP) {
        this.node.addAcceptor(address);
        if (isTLP && this.context.discoveryModule instanceof RuntimeDiscoveryModule) {
            ((RuntimeDiscoveryModule)this.context.discoveryModule).addAcceptor(address);
        }
        this.notifyOnStartAcceptor(new AbstractExchange.ChangeAcceptorData(this.node.getFabricAddress(), address), this.node.getName(), true);
    }

    private void notifyOnStartAcceptor(AbstractExchange.ChangeAcceptorData data, String entity, boolean notifyNodes) {
        this.notifyOnAcceptorChange(35, data, ModeratorAdvisoryType.ACCESS_POINT_ADDED, entity, notifyNodes);
    }

    void onStopAcceptor(LinkAddress address, boolean isTLP) {
        this.sysplexSynchronizer.invokeWithoutException(ON_STOP_ACCEPTOR_METHOD, address, isTLP);
    }

    private void doOnStopAcceptor(LinkAddress address, boolean isTLP) {
        this.node.removeAcceptor(address);
        if (isTLP && this.context.discoveryModule instanceof RuntimeDiscoveryModule) {
            ((RuntimeDiscoveryModule)this.context.discoveryModule).removeAcceptor(address);
        }
        this.notifyOnStopAcceptor(new AbstractExchange.ChangeAcceptorData(this.node.getFabricAddress(), address), this.node.getName(), true);
    }

    private void notifyOnStopAcceptor(AbstractExchange.ChangeAcceptorData data, String entity, boolean notifyNodes) {
        this.notifyOnAcceptorChange(36, data, ModeratorAdvisoryType.ACCESS_POINT_REMOVED, entity, notifyNodes);
    }

    private void notifyOnAcceptorChange(int eventId, AbstractExchange.ChangeAcceptorData data, ModeratorAdvisoryType advisoryType, String entity, boolean notifyNodes) {
        this.notifyOnUpdate(eventId, (Object)data, null, notifyNodes, advisoryType, entity, data.linkAddress.toString());
    }

    private SyncLevel1Data createSyncLevel1Data(ExchangeConnection connection, List<FabricNode> fabricNodes, List<FabricGroup> fabricGroups) throws Exception {
        SyncLevel1Data result = new SyncLevel1Data(fabricNodes, fabricGroups, this.routingTable.getLinks(), this.getSysGlobals(), this.getDirectoryTable(), this.getTimeWindows(), this.globalDomainConstraints, this.globalRangeConstraints, this.globalCounter);
        result.latency = connection.latency;
        result.version = AbstractExchange.VersionData.fromRuntimeVersion();
        result.domain = this.context.domain;
        result.clusters = this.listClusters();
        result.discoveryModuleClass = this.context.discoveryModule.getClass().getName();
        result.timezone = this.getTimezone();
        result.coherenceEnabled = this.context.isCoherenceAgentBound();
        if (result.coherenceEnabled) {
            result.exclusionList = this.getExclusionList();
        }
        if (this.context.isSecurityEnabled()) {
            result.authenticationModuleClass = this.context.securityManagerImpl.getAuthenticationModule().getClass().getName();
            result.userName = this.context.getUserName();
            result.digest = this.context.securityManagerImpl.createRuntimeUserDigest(connection.networkConnection.getSecurityKey());
            result.presence = this.context.isPresenceEnabled();
            result.anonymousRegistration = this.anonymousRegistration;
            result.webAppTokenAuthentication = this.webAppTokenAuthentication;
        }
        return result;
    }

    private void checkVersion(AbstractExchange.VersionData version, String entity) throws ExchangeException {
        if (PROTOCOL_VERSION.compareTo(version) > 0) {
            throw new ExchangeException("Protocol version incompatibility. Connecting " + entity + " version " + String.valueOf(version) + " is older than protocol version " + String.valueOf(PROTOCOL_VERSION) + ".");
        }
    }

    private void checkDomain(String nodeDomain) throws ExchangeException {
        if (!this.context.domain.equalsIgnoreCase(nodeDomain)) {
            throw new ExchangeException("Node domain '" + nodeDomain + "' does not match the sysplex domain '" + this.context.domain + "'.");
        }
    }

    private void checkClusters(List<String> clusters) throws ExchangeException {
        if (this.isClustered()) {
            if (clusters == null) {
                throw new ExchangeException("Unclustered node cannot join the clustered sysplex.");
            }
        } else if (clusters != null) {
            throw new ExchangeException("Clustered node cannot join the unclustered sysplex.");
        }
    }

    private void checkNodeNames(List<FabricNode> newFabricNodes) throws ExchangeException {
        for (FabricNode fabricNode : newFabricNodes) {
            if (!this.node.getName().equals(fabricNode.getName()) && !this.containsFabricNode(fabricNode.getName())) continue;
            throw new ExchangeException("Node with name '" + fabricNode.getName() + "' already exists in the sysplex.");
        }
    }

    private void checkDiscovery(String discoveryModuleClass) throws ExchangeException {
        if (!discoveryModuleClass.equals(this.context.discoveryModule.getClass().getName())) {
            throw new ExchangeException("Node Discovery Module differs from the sysplex Discovery Module.");
        }
    }

    private void checkCoherence(boolean coherenceEnabled) throws ExchangeException {
        if (this.context.isCoherenceAgentBound()) {
            if (!coherenceEnabled) {
                throw new ExchangeException("Node with coherence disabled cannot join the sysplex with coherence enabled.");
            }
        } else if (coherenceEnabled) {
            throw new ExchangeException("Node with coherence enabled cannot join the sysplex with coherence disabled.");
        }
    }

    private void checkTimezone(String nodeTimezone) throws ExchangeException {
        TimeZone nodeTZ = TimeZone.getTimeZone(nodeTimezone);
        TimeZone sysplexTZ = TimeZone.getTimeZone(this.getTimezone());
        if (nodeTZ.getRawOffset() != sysplexTZ.getRawOffset() || nodeTZ.useDaylightTime() != sysplexTZ.useDaylightTime()) {
            throw new ExchangeException("Node timezone '" + nodeTZ.getID() + "' does not match the sysplex timezone '" + sysplexTZ.getID() + "'.");
        }
    }

    private void checkSecurity(SyncLevel1Data nodeData, NodeExchangeConnection connection) throws Exception {
        if (this.context.isSecurityEnabled()) {
            if (nodeData.authenticationModuleClass == null) {
                throw new ExchangeException("Node with security disabled cannot join the sysplex with security enabled.");
            }
            if (!nodeData.authenticationModuleClass.equals(this.context.securityManagerImpl.getAuthenticationModule().getClass().getName())) {
                throw new ExchangeException("Node Authentication Module differs from the sysplex Authentication Module.");
            }
            connection.authenticate(nodeData.userName, nodeData.digest);
            if (this.context.isPresenceEnabled() && !nodeData.presence) {
                throw new ExchangeException("Node with presence disabled cannot join the sysplex with presence enabled.");
            }
            if (!this.context.isPresenceEnabled() && nodeData.presence) {
                throw new ExchangeException("Node with presence enabled cannot join the sysplex with presence disabled.");
            }
            if (this.anonymousRegistration && !nodeData.anonymousRegistration) {
                throw new ExchangeException("Node with anonymous registration disabled cannot join the sysplex with anonymous registration enabled.");
            }
            if (!this.anonymousRegistration && nodeData.anonymousRegistration) {
                throw new ExchangeException("Node with anonymous registration enabled cannot join the sysplex with anonymous registration disabled.");
            }
            if (this.webAppTokenAuthentication && !nodeData.webAppTokenAuthentication) {
                throw new ExchangeException("Node with Web App Token authentication disabled cannot join the sysplex with Web App Token authentication enabled.");
            }
            if (!this.webAppTokenAuthentication && nodeData.webAppTokenAuthentication) {
                throw new ExchangeException("Node with Web App Token authentication enabled cannot join the sysplex with Web App Token authentication disabled.");
            }
        } else if (nodeData.userName != null) {
            throw new ExchangeException("Node with security enabled cannot join the sysplex with security disabled.");
        }
    }

    private void addFabricNodes(List<FabricNode> fabricNodes, boolean outgoing) {
        this.sysplexSynchronizer.joiningNodes = fabricNodes;
        for (FabricNode fabricNode : fabricNodes) {
            fabricNode.setReady(false);
            this.addFabricNode(fabricNode, false, outgoing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeAddress(byte clusterNumber, short nodeNumber) {
        if (this.getNodeAddress().needUpdate(clusterNumber, nodeNumber)) {
            this.node.updateAddress(clusterNumber, nodeNumber);
            Map<FabricAddress, ClientExchangeConnection> map = this.clientConnections;
            synchronized (map) {
                if (!this.clientConnections.isEmpty()) {
                    Utils.recreate(this.clientConnections);
                }
            }
            this.broadcastWithAckToClients(29, new Pair<Byte, Short>(clusterNumber, nodeNumber), null);
        }
    }

    private Map<String, Short> synchronizeNodeAddresses(List<FabricNode> fabricNodes) throws ExchangeException {
        HashMap<String, Short> result = new HashMap<String, Short>();
        for (FabricNode fabricNode : fabricNodes) {
            short nodeNumber = this.acquireNodeNumber();
            fabricNode.updateAddress(this.getClusterNumber(fabricNode), nodeNumber);
            result.put(fabricNode.getName(), nodeNumber);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeNodeAddressesInNode(Map<String, Short> nodeNumbers) {
        this.updateNodeAddress(this.getClusterNumber(this.node), nodeNumbers.get(this.node.getName()));
        if (this.inSysplex()) {
            for (FabricNode fabricNode : this.getFabricNodes()) {
                fabricNode.updateAddress(this.getClusterNumber(fabricNode), nodeNumbers.get(fabricNode.getName()));
            }
            this.recreateFabricNodes();
            this.sysplexSynchronizer.recreateTokenRing();
        }
        Map<FabricAddress, NodeExchangeConnection> map = this.nodeConnections;
        synchronized (map) {
            if (!this.nodeConnections.isEmpty()) {
                Utils.recreate(this.nodeConnections);
            }
        }
    }

    private AbstractExchange.InternalEvent createSyncLevel1Reply(List<FabricGroup> sysplexGroups, DirectoryTable directoryTable, Map<String, TimeWindow> timeWindows, Map<String, DomainConstraintReferenceImpl> domains, Map<String, RangeConstraintReferenceImpl> ranges, Map<String, Short> nodeNumbers) throws Exception {
        SyncLevel1ReplyData data = new SyncLevel1ReplyData(this.getFabricNodesForReply(false), sysplexGroups, this.routingTable.getLinks(), this.getSysGlobals(), directoryTable, timeWindows, domains, ranges, this.globalCounter, this.clusterNumberAllocator, this.nodeNumberAllocator, this.advancedParameters, this.clusterNumbers, nodeNumbers, this.fabricUid, this.sysplexSynchronizer.getTokenId());
        if (this.context.isSecurityEnabled()) {
            data.anonymousUser = this.getAnonymousUser();
            data.users = this.context.securityManagerImpl.getUsersStore();
            data.groups = this.context.securityManagerImpl.getGroupsStore();
            data.organizations = this.context.securityManagerImpl.getOrganizationsStore();
            data.vCardTable = this.context.securityManagerImpl.getVCardTable();
            data.vCardPhotoTable = this.context.securityManagerImpl.getVCardPhotoTable();
        }
        data.apiKeyReplicatedData = ((AbstractApiKeyManager)((Object)this.context.getHTTPAuthenticationManager().getApiKeyManager())).getApiKeyReplicatedData();
        data.dropBoxTable = this.context.getDropBoxManagerRemote().getDropBoxTableManager().getDropBoxTable();
        if (this.context.isCoherenceAgentBound()) {
            this.fillCoherenceEntities(data);
        }
        return this.createInternalEvent(data);
    }

    private List<FabricNode> getFabricNodesForReply(boolean forClient) {
        ArrayList<FabricNode> result = new ArrayList<FabricNode>(this.getFabricNodesNumber() + 1);
        result.add(forClient ? this.node.copyWithNonLocalScope() : this.node.copyWithGlobalScope());
        result.addAll(this.getFabricNodes());
        return result;
    }

    private void fillCoherenceEntities(SyncLevel1ReplyData data) throws Exception {
        File jarDir;
        this.sysplexSynchronizer.joinJarDir = jarDir = FileIOUtils.newFileDir(new File(this.jarsDir, System.currentTimeMillis() + "_sysplex").getPath());
        data.exclusionList = this.getExclusionList();
        data.jarDir = jarDir.getName();
        data.extJARs = new HashSet<String>();
        data.libJARs = new HashSet<String>();
        data.packages = new OrderedMap<String, SyncPackageData>();
        data.semanticTypes = new HashSet<String>();
        data.eventPrototypes = new HashSet<String>();
        try {
            for (String jarName : this.context.repositoryAccessor.listExtensionArchives()) {
                data.extJARs.add(jarName);
                SemanticUtils.getRelatedSemanticTypes(jarName, true, this.context).stream().map(SemanticType::getTypeName).forEach(t -> data.semanticTypes.add((String)t));
            }
            data.libJARs.addAll(this.context.repositoryAccessor.listArchives());
            for (PackageDescriptor descriptor : this.context.manifestManager.getPackages()) {
                String pkgName = descriptor.getFullName();
                if (!descriptor.isReplicable()) continue;
                data.packages.put(pkgName, new SyncPackageData(this.context.repositoryAccessor.getPackage(pkgName), descriptor, this.context.manifestManager.isPackageLoaded(pkgName)));
                SemanticUtils.getRelatedSemanticTypes(descriptor, this.context).stream().map(SemanticType::getTypeName).forEach(t -> data.semanticTypes.add((String)t));
            }
            AbstractDatagramPrototypeCache cache = (AbstractDatagramPrototypeCache)((Object)this.context.getDatagramPrototypeCache());
            for (Map.Entry<Prototype, ImmutableEventDatagram> entry : cache.getPrototypeEntries()) {
                String dataType;
                String eventId = entry.getValue().getEventId();
                if (!RuntimeExchange.isPrototypeSynchronizable(eventId) || (dataType = cache.getDataType(entry.getKey(), entry.getValue())) != null && !data.semanticTypes.contains(dataType)) continue;
                data.eventPrototypes.add(eventId);
            }
        }
        catch (Exception exception) {
            throw new ExchangeException("Obtaining Coherence Agent entities failed.", (Throwable)exception);
        }
    }

    private void synchronizeLevel1Entities(AbstractSyncLevel12BackwardData data) {
        boolean needSave = this.synchronizeAdvancedParameters(data.advancedParameters);
        if (!this.fabricUid.equals(data.fabricUid)) {
            this.fabricUid = data.fabricUid;
            needSave = true;
        }
        if (needSave) {
            this.context.saveExchange();
        }
        this.clusterNumberAllocator = data.clusterNumberAllocator;
        this.clusterNumbers = data.clusterNumbers;
        this.nodeNumberAllocator = data.nodeNumberAllocator;
        this.synchronizeNodeAddressesInNode(data.nodeNumbers);
        this.synchronizeFabricGroups(data.fabricGroups);
        this.synchronizeSysGlobals(data.sysGlobals, true);
        this.synchronizeDirectoryTable(data.directoryTable);
        this.synchronizeTimeWindowsInNode(data.timeWindows);
        this.synchronizeDataConstraintsInNode(data.domains, data.ranges);
        this.synchronizeGlobalCounter(data.globalCounter);
        if (this.context.isSecurityEnabled()) {
            if (data.anonymousUser != this.anonymousUser) {
                this.doSetAnonymousUserCore(data.anonymousUser);
            }
            this.context.securityManagerImpl.synchronize(data.users, data.groups, data.organizations);
            if (this.context.isPresenceEnabled()) {
                this.context.securityManagerImpl.synchronize(data.vCardTable, data.vCardPhotoTable);
            }
        }
        ((AbstractApiKeyManager)((Object)this.context.getHTTPAuthenticationManager().getApiKeyManager())).synchronize(data.apiKeyReplicatedData);
        this.context.getDropBoxManagerRemote().getDropBoxTableManager().mergeDropBoxTableFromMNode(data.dropBoxTable);
    }

    private SyncLevel1BackwardData createSyncLevel1BackwardData(SyncLevel1ReplyData sync1Data) {
        SyncLevel1BackwardData result = new SyncLevel1BackwardData(sync1Data);
        if (this.context.isSecurityEnabled()) {
            result.anonymousUser = sync1Data.anonymousUser;
            result.users = sync1Data.users;
            result.groups = sync1Data.groups;
            result.organizations = sync1Data.organizations;
            result.vCardTable = sync1Data.vCardTable;
            result.vCardPhotoTable = sync1Data.vCardPhotoTable;
        }
        result.apiKeyReplicatedData = sync1Data.apiKeyReplicatedData;
        result.dropBoxTable = sync1Data.dropBoxTable;
        return result;
    }

    private SyncLevel12ForwardData createSyncLevel12ForwardData(SyncLevel1ReplyData sync1Data, List<FabricNode> fabricNodes, List<FabricGroup> fabricGroups, List<RoutingTable.Link> routingLinks, Map<String, TimeWindow> timeWindows, Map<String, DomainConstraintReferenceImpl> domains, Map<String, RangeConstraintReferenceImpl> ranges, SyncSemanticData semanticData) {
        SyncLevel12ForwardData result = new SyncLevel12ForwardData(fabricNodes, fabricGroups, routingLinks, sync1Data.sysGlobals, sync1Data.directoryTable, timeWindows, domains, ranges, sync1Data.globalCounter, this.clusterNumberAllocator, this.nodeNumberAllocator, this.clusterNumbers);
        if (this.context.isCoherenceAgentBound()) {
            result.exclusionList = this.getExclusionList();
            result.semanticData = semanticData;
        }
        return result;
    }

    private List<String> removeDuplicatedExtJARs(Set<String> sysplexLibJARs) {
        return sysplexLibJARs.stream().filter(this::doRemoveDuplicatedExtJAR).collect(Collectors.toList());
    }

    private boolean doRemoveDuplicatedExtJAR(String jarName) {
        try {
            if (this.context.repositoryAccessor.existsExtensionArchive(jarName)) {
                this.logWarning("Ext archive '" + jarName + "' duplicates existing lib archive of Sysplex. Removing...");
                this.context.repositoryAccessor.doRemoveExtensionArchive(jarName, true);
                return true;
            }
        }
        catch (Exception exception) {
            this.logException(exception, true, "Removing duplicated ext archive '" + jarName + "' failed.");
        }
        return false;
    }

    private List<String> getExtJARsForSysplex(Set<String> sysplexJARs, FabricNode sysplexNode, File jarDir) throws Exception {
        return this.copyExtJARs(this.context.repositoryAccessor.listExtensionArchives().stream().filter(jar -> !sysplexJARs.contains(jar)).collect(Collectors.toList()), sysplexNode, jarDir);
    }

    private List<String> getExtJARsForNode(Set<String> requestedJARs, FabricNode targetNode, File jarDir) throws Exception {
        return this.copyExtJARs(this.context.repositoryAccessor.listExtensionArchives().stream().filter(requestedJARs::contains).collect(Collectors.toList()), targetNode, jarDir);
    }

    private void synchronizeExtJARs(List<String> receivedJars, File jarDir) {
        this.logDebug("Extension archives synchronization...");
        for (String jarName : receivedJars) {
            try {
                File jarFile = new File(jarDir, jarName);
                if (this.context.repositoryAccessor.existsExtensionArchive(jarName)) {
                    URLConnection repositoryJarConnection = this.context.repositoryAccessor.getExtensionArchiveURL(jarName).openConnection();
                    InputStream receivedJarStream = Files.newInputStream(jarFile.toPath(), new OpenOption[0]);
                    try {
                        if (FileIOUtils.equalsByContent(repositoryJarConnection, receivedJarStream)) continue;
                        this.context.repositoryAccessor.doRemoveExtensionArchive(jarName, true);
                        this.context.repositoryAccessor.doAddExtensionArchive(jarFile);
                        this.logInfo("Extension archive '" + jarName + "' synchronized.");
                        continue;
                    }
                    finally {
                        if (receivedJarStream != null) {
                            receivedJarStream.close();
                        }
                        continue;
                    }
                }
                this.context.repositoryAccessor.doAddExtensionArchive(jarFile);
                this.logInfo("Extension archive '" + jarName + "' synchronized.");
            }
            catch (Exception exception) {
                this.logException(exception, true, "Synchronization of extension archive '" + jarName + "' failed.");
            }
        }
        this.logInfo("Extension archives synchronized.");
    }

    void addExtensionJar(RuntimeRepositoryAccessorImpl accessor, String userName, File jar) throws Exception {
        this.sysplexSynchronizer.invoke(ADD_EXTENSION_JAR_METHOD, accessor, userName, jar);
    }

    private void doAddExtensionJar(RuntimeRepositoryAccessorImpl accessor, String userName, File jar) throws Exception {
        accessor.doAddExtensionArchiveCore(userName, jar);
        this.copyJARsToAllNodes(jar.getParentFile());
        this.broadcastWithAckToNodes(121, new AddJarData(jar));
        this.onCoherenceUpdate(CoherenceAgentAdvisoryType.EXT_ARCHIVE_ADDED, jar.getName());
    }

    void removeExtensionJar(RuntimeRepositoryAccessorImpl accessor, String userName, String jarName, boolean force) throws Exception {
        this.sysplexSynchronizer.invoke(REMOVE_EXTENSION_JAR_METHOD, accessor, userName, jarName, force);
    }

    private void doRemoveExtensionJar(RuntimeRepositoryAccessorImpl accessor, String userName, String jarName, boolean force) throws Exception {
        accessor.doRemoveExtensionArchiveCore(userName, jarName, force);
        this.broadcastWithAckToNodes(122, new RemoveExtensionJarData(jarName, force));
        this.onCoherenceUpdate(CoherenceAgentAdvisoryType.EXT_ARCHIVE_REMOVED, jarName);
    }

    void addJar(RuntimeRepositoryAccessorImpl accessor, String userName, File jar) throws Exception {
        this.sysplexSynchronizer.invoke(ADD_JAR_METHOD, accessor, userName, jar);
    }

    private void doAddJar(RuntimeRepositoryAccessorImpl accessor, String userName, File jar) throws Exception {
        Package pkg = accessor.doAddArchiveCore(userName, jar);
        if (pkg != null && pkg.isGlobal()) {
            this.copyJARsToAllNodes(jar.getParentFile());
            this.broadcastWithAckToNodes(160, new AddJarData(jar));
            this.onCoherenceUpdate(CoherenceAgentAdvisoryType.ARCHIVE_ADDED, jar.getName());
        }
    }

    void removeJar(RuntimeRepositoryAccessorImpl accessor, String userName, String jarName) throws Exception {
        this.sysplexSynchronizer.invoke(REMOVE_JAR_METHOD, accessor, userName, jarName);
    }

    private void doRemoveJar(RuntimeRepositoryAccessorImpl accessor, String userName, String jarName) throws Exception {
        Package pkg = accessor.doRemoveArchiveCore(userName, jarName);
        if (pkg != null && pkg.isGlobal()) {
            this.broadcastWithAckToNodes(161, new RemoveJarData(jarName));
            this.onCoherenceUpdate(CoherenceAgentAdvisoryType.ARCHIVE_REMOVED, jarName);
        }
    }

    private List<String> removeDuplicatedLibJARs(Set<String> sysplexExtJARs) {
        return sysplexExtJARs.stream().filter(this::doRemoveDuplicatedLibJAR).collect(Collectors.toList());
    }

    private boolean doRemoveDuplicatedLibJAR(String jarName) {
        try {
            if (this.context.repositoryAccessor.existsArchive(jarName)) {
                this.logWarning("Lib archive '" + jarName + "' duplicates existing ext archive of Sysplex. Removing...");
                Package pkg = this.context.repositoryAccessor.getPackageByArchive(jarName);
                if (pkg != null) {
                    String pkgName = pkg.getFullName();
                    this.logWarning("Duplicated lib archive '" + jarName + "' belongs to '" + pkgName + "' package. Removing package...");
                    if (this.context.manifestManager.existsPackage(pkgName)) {
                        if (this.context.manifestManager.isPackageLoaded(pkgName)) {
                            this.context.manifestManager.doUnloadPackageCore(pkgName, true);
                        }
                        this.context.manifestManager.doRemovePackageCore(pkgName);
                    }
                    this.context.repositoryAccessor.removePackage(pkgName, false);
                }
                this.context.repositoryAccessor.doRemoveArchive(jarName);
                return true;
            }
        }
        catch (Exception exception) {
            this.logException(exception, true, "Removing duplicated lib archive '" + jarName + "' failed.");
        }
        return false;
    }

    private void updatePackagesScope(ReplicationRules.ExclusionList exclusionList, Map<String, SyncPackageData> sysplexPackages) {
        try {
            boolean needSave = false;
            needSave |= this.doUpdatePackageScope(exclusionList.getPackages(), false);
            if (needSave |= this.doUpdatePackageScope(sysplexPackages.keySet(), true)) {
                this.context.manifestManager.doSaveManifest();
            }
        }
        catch (Exception exception) {
            this.logException(exception, true, "Update packages global status failed.");
        }
    }

    private boolean doUpdatePackageScope(Set<String> packages, boolean global) throws Exception {
        boolean needSave = false;
        for (String pkgName : packages) {
            PackageDescriptor descriptor = this.context.manifestManager.getPackageFromManifestSafe(pkgName);
            if (descriptor == null || descriptor.isGlobal() == global) continue;
            ((AbstractPackageDescriptor)descriptor).setGlobal(global);
            this.updatePackageScopeInRepository(descriptor, global);
            needSave = true;
        }
        return needSave;
    }

    private int getChainRebuildIndex(Map<String, SyncPackageData> sysplexPackages) {
        boolean hasSharedPackages = false;
        int iFirstChangedPackage = -1;
        int iFirstPrivatePackage = -1;
        Iterator<Map.Entry<String, SyncPackageData>> sysplexPkgIter = sysplexPackages.entrySet().iterator();
        List<PackageDescriptor> nodePackages = this.context.manifestManager.getPackages();
        for (int i = 0; i < nodePackages.size() && sysplexPkgIter.hasNext(); ++i) {
            PackageDescriptor nodePkgDescr = nodePackages.get(i);
            String nodePkgName = nodePkgDescr.getFullName();
            if (this.isPackageExcluded(nodePkgDescr)) {
                if (iFirstPrivatePackage != -1) continue;
                iFirstPrivatePackage = i;
                continue;
            }
            hasSharedPackages = true;
            Map.Entry<String, SyncPackageData> sysplexPkgEntry = sysplexPkgIter.next();
            if (nodePkgName.equals(sysplexPkgEntry.getKey()) && (sysplexPkgEntry.getValue().descriptor == null || nodePkgDescr.equals(sysplexPkgEntry.getValue().descriptor))) continue;
            iFirstChangedPackage = i;
            break;
        }
        if (iFirstChangedPackage != -1) {
            return iFirstPrivatePackage != -1 ? Math.min(iFirstChangedPackage, iFirstPrivatePackage) : iFirstChangedPackage;
        }
        if (iFirstPrivatePackage != -1) {
            return hasSharedPackages ? iFirstPrivatePackage : -1;
        }
        return -1;
    }

    private void getPackagesForSysplex(Map<String, SyncPackageData> sysplexPackages, FabricNode targetNode, File targetDir) {
        AbstractPackageManifestManager manager = this.context.manifestManager;
        try {
            List<PackageDescriptor> nodePackages = manager.getPackages();
            for (PackageDescriptor nodePkgDescr : nodePackages) {
                String pkgName = nodePkgDescr.getFullName();
                if (this.isPackageExcluded(pkgName)) continue;
                Package nodePkg = this.context.repositoryAccessor.getPackage(pkgName);
                SyncPackageData sysplexPkgData = sysplexPackages.get(pkgName);
                if (sysplexPkgData != null) {
                    this.checkPackageVersion(nodePkg, sysplexPkgData, targetNode, targetDir);
                    continue;
                }
                sysplexPackages.put(pkgName, new SyncPackageData(nodePkg, this.getPackageJARs(nodePkg, targetNode, targetDir), nodePkgDescr, PackageSource.NODE, manager.isPackageLoaded(pkgName)));
            }
        }
        catch (Exception exception) {
            this.logException(exception, true, "Obtaining packages from Repository failed.");
        }
    }

    private void checkPackageVersion(Package nodePkg, SyncPackageData sysplexPkgData, FabricNode targetNode, File targetDir) throws Exception {
        if (nodePkg.getVersion() > sysplexPkgData.pkg.getVersion()) {
            sysplexPkgData.pkg = nodePkg;
            sysplexPkgData.jars = this.getPackageJARs(nodePkg, targetNode, targetDir);
            sysplexPkgData.source = PackageSource.NODE;
        }
    }

    private void synchronizePackagesInSysplex(SyncSemanticData data, File jarDir, boolean needReply, FabricNode joiningNode, File joiningNodeJarDir) throws Exception {
        this.logDebug("Packages synchronization...");
        for (SyncPackageData pkgData : data.packages.values()) {
            if (pkgData.source == PackageSource.NODE) {
                this.checkPackageJARsForChanges(pkgData, jarDir);
                this.updatePackage(pkgData.pkg.getFullName(), pkgData, jarDir, pkgData.pkg != null || pkgData.descriptor != null || pkgData.jars != null && !pkgData.jars.isEmpty());
                continue;
            }
            if (!needReply || pkgData.source != PackageSource.SYSPLEX) continue;
            pkgData.jars = this.getPackageJARs(pkgData.pkg, joiningNode, joiningNodeJarDir);
        }
        this.logInfo("Packages synchronized.");
    }

    private void synchronizePackagesInNode(SyncSemanticData data, int chainRebuildIndex, File jarDir) {
        this.logDebug("Packages synchronization...");
        try {
            ArrayList<String> movedPackages = new ArrayList<String>();
            ArrayList<SyncPackageData> privatePackages = new ArrayList<SyncPackageData>();
            this.rebuildPackageManifestChain(chainRebuildIndex, movedPackages, privatePackages);
            this.checkPackagesForChanges(data.packages, jarDir);
            for (Map.Entry<String, SyncPackageData> entry : data.packages.entrySet()) {
                SyncPackageData pkgData = entry.getValue();
                if (pkgData.source == PackageSource.SYSPLEX) {
                    this.updatePackage(entry.getKey(), pkgData, jarDir, pkgData.pkg != null || pkgData.descriptor != null || pkgData.jars != null && !pkgData.jars.isEmpty());
                    continue;
                }
                if (pkgData.source != PackageSource.NODE || !movedPackages.contains(entry.getKey())) continue;
                this.doAddPackageToRuntimeManifest(pkgData);
            }
            for (SyncPackageData pkgData : privatePackages) {
                this.doAddPackageToRuntimeManifest(pkgData);
            }
        }
        catch (Exception exception) {
            this.logException(exception, true);
            this.logError("Synchronization of packages failed.");
        }
        this.logInfo("Packages synchronized.");
    }

    private void rebuildPackageManifestChain(int chainRebuildIndex, List<String> movedPackages, List<SyncPackageData> privatePackages) throws Exception {
        if (chainRebuildIndex != -1) {
            List<PackageDescriptor> nodePackages = this.context.manifestManager.getPackages();
            for (int i = chainRebuildIndex; i < nodePackages.size(); ++i) {
                PackageDescriptor nodePkgDescr = nodePackages.get(i);
                String pkgName = nodePkgDescr.getFullName();
                movedPackages.add(pkgName);
                if (!this.isPackageExcluded(pkgName)) continue;
                privatePackages.add(new SyncPackageData(nodePkgDescr, this.context.manifestManager.isPackageLoaded(pkgName)));
            }
            Collections.reverse(movedPackages);
            for (String pkgName : movedPackages) {
                if (this.context.manifestManager.isPackageLoaded(pkgName)) {
                    this.context.manifestManager.doUnloadPackageCore(pkgName, true);
                }
                this.context.manifestManager.doRemovePackageCore(pkgName);
            }
            Collections.reverse(movedPackages);
        }
    }

    private void checkPackagesForChanges(Map<String, SyncPackageData> packages, File jarDir) throws Exception {
        for (SyncPackageData pkgData : packages.values()) {
            PackageDescriptor nodeDescriptor;
            Package existingPkg;
            if (pkgData.source != PackageSource.SYSPLEX) continue;
            this.checkPackageJARsForChanges(pkgData, jarDir);
            if (pkgData.pkg != null && this.context.repositoryAccessor.existsPackage(pkgData.pkg.getType(), pkgData.pkg.getName()) && (existingPkg = this.context.repositoryAccessor.getPackage(pkgData.pkg.getType(), pkgData.pkg.getName())).equalsFully(pkgData.pkg)) {
                pkgData.pkg = null;
            }
            if (pkgData.descriptor == null || (nodeDescriptor = this.context.manifestManager.getPackage(pkgData.descriptor.getFullName())) == null || !nodeDescriptor.equals(pkgData.descriptor) || !nodeDescriptor.isValid() && pkgData.isLoaded) continue;
            pkgData.descriptor = null;
        }
    }

    private void checkPackageJARsForChanges(SyncPackageData pkgData, File jarDir) {
        ArrayList<String> changedJars = new ArrayList<String>();
        if (pkgData.jars != null) {
            for (String jarName : pkgData.jars) {
                try {
                    if (this.context.repositoryAccessor.existsArchive(jarName)) {
                        InputStream repositoryJarStream = this.context.repositoryAccessor.getArchiveStream(jarName);
                        try {
                            InputStream pkgJarStream = Files.newInputStream(new File(jarDir, jarName).toPath(), new OpenOption[0]);
                            try {
                                if (FileIOUtils.equalsByContent(repositoryJarStream, pkgJarStream)) continue;
                                changedJars.add(jarName);
                                continue;
                            }
                            finally {
                                if (pkgJarStream != null) {
                                    pkgJarStream.close();
                                }
                                continue;
                            }
                        }
                        finally {
                            if (repositoryJarStream == null) continue;
                            repositoryJarStream.close();
                            continue;
                        }
                    }
                    changedJars.add(jarName);
                }
                catch (Exception exception) {
                    this.logException(exception, true, "Obtaining lib archive '" + jarName + "' failed.");
                }
            }
        }
        pkgData.jars = !changedJars.isEmpty() ? changedJars : null;
    }

    private void updatePackage(String pkgName, SyncPackageData pkgData, File jarDir, boolean updateCondition) {
        try {
            boolean loadPackage = false;
            if (updateCondition && this.context.manifestManager.isPackageLoaded(pkgName)) {
                this.context.manifestManager.doUnloadPackageCore(pkgName, true);
                loadPackage = true;
            }
            this.doUpdatePackage(pkgData, jarDir);
            if (loadPackage) {
                this.context.manifestManager.doLoadPackageCore(pkgName, true);
            }
        }
        catch (Exception exception) {
            this.logException(exception, true, "Synchronization of package '" + pkgName + "' failed.");
        }
    }

    private void doUpdatePackage(SyncPackageData pkgData, File jarDir) {
        if (pkgData.jars != null) {
            for (String jarName : pkgData.jars) {
                File jarFile = new File(jarDir, jarName);
                try {
                    if (this.context.repositoryAccessor.existsArchive(jarName)) {
                        this.context.repositoryAccessor.doRemoveArchive(jarName);
                    }
                    this.context.repositoryAccessor.doAddArchive(jarFile);
                    this.logInfo("Lib archive '" + jarName + "' synchronized.");
                }
                catch (Exception exception) {
                    this.logException(exception, true, "Synchronization of lib archive '" + jarName + "' failed.");
                }
            }
        }
        if (pkgData.pkg != null) {
            String pkgName = pkgData.pkg.getFullName();
            try {
                if (!this.context.repositoryAccessor.existsPackage(pkgData.pkg.getType(), pkgData.pkg.getName())) {
                    this.context.repositoryAccessor.addPackage(pkgData.pkg);
                } else {
                    this.context.repositoryAccessor.updatePackageForced(pkgData.pkg);
                }
                this.logInfo("Package '" + pkgName + "' synchronized.");
            }
            catch (Exception exception) {
                this.logException(exception, true, "Synchronizing package '" + pkgName + "' failed.'");
            }
        }
        if (pkgData.descriptor != null) {
            this.doAddPackageToRuntimeManifest(pkgData);
        }
    }

    private void doAddPackageToRuntimeManifest(SyncPackageData pkgData) {
        String pkgName = pkgData.descriptor.getFullName();
        try {
            if (!this.context.manifestManager.existsPackage(pkgName)) {
                this.context.manifestManager.doAddPackageAtCore(-1, pkgData.descriptor, false);
                if (pkgData.isLoaded && !pkgData.descriptor.isAutoload()) {
                    this.context.manifestManager.doLoadPackageCore(pkgName, true);
                }
            }
        }
        catch (Exception exception) {
            this.logException(exception, true, "Synchronizing package '" + pkgName + "' in Runtime Package Manifest failed.'");
        }
    }

    private List<String> getPackageJARs(Package pkg, FabricNode targetNode, File targetDir) throws Exception {
        return this.copyLibJARs(pkg.listJARs(), targetNode, targetDir);
    }

    void addPackage(AbstractPackageManifestManager manager, int position, PackageDescriptor descriptor) throws Exception {
        this.sysplexSynchronizer.invoke(ADD_PACKAGE_METHOD, manager, position, descriptor);
    }

    private void doAddPackage(AbstractPackageManifestManager manager, int position, PackageDescriptor descriptor) throws Exception {
        PackageData data = manager.doAddPackageAtCore(position, descriptor, true);
        if (!this.isPackageExcluded(descriptor)) {
            data.jarDir = this.copyLibJARsToAllNodes(data.jars);
            this.broadcastWithAckToNodes(123, data);
        }
        if (descriptor.isAutoload()) {
            this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_ADDED, CoherenceAgentAdvisoryType.PACKAGE_LOADED, descriptor.getFullName());
        } else {
            this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_ADDED, descriptor.getFullName());
        }
    }

    void updatePackage(AbstractPackageManifestManager manager, Integer position, PackageDescriptor descriptor, Package pkg) throws Exception {
        this.sysplexSynchronizer.invoke(UPDATE_PACKAGE_METHOD, manager, position, descriptor, pkg);
    }

    private void doUpdatePackage(AbstractPackageManifestManager manager, Integer position, PackageDescriptor descriptor, Package pkg) throws Exception {
        UpdatePackageData data = manager.doUpdatePackageAtCore(position, descriptor, pkg);
        if (data != null && !data.isEmpty()) {
            if (!this.isPackageExcluded(data.descriptor, data.pkg)) {
                data.jarDir = this.copyLibJARsToAllNodes(data.jars);
                this.broadcastWithAckToNodes(158, data);
            }
            this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_UPDATED, RuntimeExchange.getPackageName(data.descriptor, data.pkg));
        }
    }

    void setPackageScope(AbstractPackageManifestManager manager, String pkgName, boolean global) throws Exception {
        this.sysplexSynchronizer.invoke(SET_PACKAGE_SCOPE_METHOD, manager, pkgName, global);
    }

    private void doSetPackageScope(AbstractPackageManifestManager manager, String pkgName, boolean global) throws Exception {
        PackageDescriptor descriptor = manager.doSetPackageScopeCore(pkgName, global);
        if (descriptor != null) {
            if (global) {
                UpdatePackageData data = this.createPackageDataForSetScope(manager, descriptor);
                this.updatePackageScopeInRepository(data.pkg, global);
                data.types = SemanticUtils.getRelatedSemanticTypes(data.pkg, this.context);
                data.jarDir = this.copyLibJARsToAllNodes(data.jars);
                this.broadcastWithAckToNodes(158, data);
                Map<Prototype, ImmutableEventDatagram> prototypes = this.getPrototypes(data.types);
                if (prototypes != null && !prototypes.isEmpty()) {
                    data = UpdatePackageData.createForSetScope(descriptor);
                    data.prototypes = prototypes;
                    this.broadcastWithAckToNodes(158, data);
                }
            } else {
                this.updatePackageScopeInRepository(descriptor, global);
                this.broadcastWithAckToNodes(158, UpdatePackageData.createForSetScope(descriptor));
            }
            this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_UPDATED, pkgName);
        }
    }

    private Map<Prototype, ImmutableEventDatagram> getPrototypes(List<SemanticType> types) {
        if (!types.isEmpty()) {
            HashMap<Prototype, ImmutableEventDatagram> result = new HashMap<Prototype, ImmutableEventDatagram>();
            AbstractDatagramPrototypeCache cache = (AbstractDatagramPrototypeCache)((Object)this.context.getDatagramPrototypeCache());
            Set typeNames = types.stream().map(SemanticType::getTypeName).collect(Collectors.toSet());
            for (Map.Entry<Prototype, ImmutableEventDatagram> entry : cache.getPrototypeEntries()) {
                String dataType;
                if (!RuntimeExchange.isPrototypeSynchronizable(entry.getValue().getEventId()) || (dataType = cache.getDataType(entry.getKey(), entry.getValue())) == null || !typeNames.contains(dataType)) continue;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
        return null;
    }

    private UpdatePackageData createPackageDataForSetScope(AbstractPackageManifestManager manager, PackageDescriptor descriptor) throws Exception {
        Package pkg = manager.getPackageData(descriptor, true);
        UpdatePackageData result = UpdatePackageData.createForSetScope(descriptor);
        result.position = manager.getPosition(descriptor);
        result.pkg = pkg;
        result.jars = pkg.listJARs();
        return result;
    }

    private static String getPackageName(PackageDescriptor descriptor, Package pkg) {
        return descriptor != null ? descriptor.getFullName() : pkg.getFullName();
    }

    private void replacePackage(PackageData data) throws Exception {
        this.doRemoveExistingPackage(data);
        this.context.repositoryAccessor.doAddArchives(this.getJarDir(data.jarDir), data.jars);
        this.context.repositoryAccessor.addPackage(data.pkg);
        this.context.manifestManager.doAddPackageAtCore(data.position, data.descriptor, false);
    }

    private void updatePackageScopeInRepository(PackageDescriptor descriptor, boolean global) throws Exception {
        this.updatePackageScopeInRepository(this.context.manifestManager.getPackageData(descriptor, false), global);
    }

    private void updatePackageScopeInRepository(Package pkg, boolean global) throws Exception {
        ((AbstractPackage)pkg).setGlobal(global);
        this.context.repositoryAccessor.updatePackageForced(pkg);
    }

    private void doRemoveExistingPackage(PackageData data) throws Exception {
        if (this.context.manifestManager.existsPackage(data.descriptor.getPackageType(), data.descriptor.getPackageName())) {
            String pkgName = data.descriptor.getFullName();
            if (this.context.manifestManager.isPackageLoaded(pkgName)) {
                this.context.manifestManager.doUnloadPackageCore(pkgName, false);
            }
            this.context.manifestManager.doRemovePackageCore(pkgName);
        }
        if (this.context.repositoryAccessor.existsPackage(data.descriptor.getPackageType(), data.descriptor.getPackageName())) {
            Package pkg = this.context.repositoryAccessor.getPackage(data.descriptor.getPackageType(), data.descriptor.getPackageName());
            for (String jarName : pkg.listJARs()) {
                this.doRemoveArchiveDependentEntities(jarName);
            }
            this.context.repositoryAccessor.removePackageForced(pkg);
        }
        for (String jarName : data.jars) {
            if (!this.context.repositoryAccessor.existsArchive(jarName)) continue;
            this.doRemoveArchiveDependentEntities(jarName);
            this.context.repositoryAccessor.doRemoveArchiveForced(jarName);
        }
    }

    private void doRemoveArchiveDependentEntities(String jarName) throws Exception {
        List<SemanticType> types = SemanticUtils.getRelatedSemanticTypes(jarName, false, this.context);
        SemanticUtils.listDependentEventIds(types, (FabricContext)this.context).forEach(eventId -> {
            try {
                this.removeEventPrototype((String)eventId, true);
            }
            catch (Exception exception) {
                this.logException(exception, true);
            }
        });
        types.forEach(type -> {
            try {
                ((RuntimeSemanticTypeFactory)this.context.semanticTypeFactory).doRemoveSemanticTypeCore(type.getTypeName(), true, true);
            }
            catch (Exception exception) {
                this.logException(exception, true);
            }
        });
    }

    void removePackage(AbstractPackageManifestManager manager, String pkgName) throws Exception {
        this.sysplexSynchronizer.invoke(REMOVE_PACKAGE_METHOD, manager, pkgName);
    }

    private void doRemovePackage(AbstractPackageManifestManager manager, String pkgName) throws PackageManifestException, NamingException {
        PackageDescriptor descriptor = manager.doRemovePackageCore(pkgName);
        if (!this.isPackageExcluded(descriptor)) {
            this.broadcastWithAckToNodes(124, pkgName);
        }
        this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_REMOVED, pkgName);
    }

    void loadPackage(AbstractPackageManifestManager manager, String pkgName, boolean checkDependencies) throws Exception {
        this.sysplexSynchronizer.invoke(LOAD_PACKAGE_METHOD, manager, pkgName, checkDependencies);
    }

    private void doLoadPackage(AbstractPackageManifestManager manager, String pkgName, boolean checkDependencies) throws PackageManifestException, NamingException {
        LoadPackageData data = manager.doLoadPackageCore(pkgName, checkDependencies);
        if (!this.isPackageExcluded(data.descriptor)) {
            this.broadcastWithAckToNodes(125, data);
        }
        this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_LOADED, pkgName);
    }

    void unloadPackage(AbstractPackageManifestManager manager, String pkgName, boolean checkDependencies) throws Exception {
        this.sysplexSynchronizer.invoke(UNLOAD_PACKAGE_METHOD, manager, pkgName, checkDependencies);
    }

    private void doUnloadPackage(AbstractPackageManifestManager manager, String pkgName, boolean checkDependencies) throws PackageManifestException, NamingException {
        PackageDescriptor descriptor = manager.doUnloadPackageCore(pkgName, checkDependencies);
        if (!this.isPackageExcluded(descriptor)) {
            this.broadcastWithAckToNodes(126, new Pair<String, Boolean>(pkgName, checkDependencies));
        }
        this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_UNLOADED, pkgName);
    }

    void validatePackage(AbstractPackageManifestManager manager, String pkgName) throws Exception {
        this.sysplexSynchronizer.invoke(VALIDATE_PACKAGE_METHOD, manager, pkgName);
    }

    private void doValidatePackage(AbstractPackageManifestManager manager, String pkgName) throws PackageManifestException, NamingException {
        manager.doValidatePackageCore(pkgName);
        this.broadcastWithAckToNodes(156, pkgName);
    }

    private boolean isPackageExcluded(String pkgName) throws Exception {
        return !this.context.manifestManager.isPackageSynchronizable(pkgName);
    }

    private boolean isPackageExcluded(PackageDescriptor descriptor) {
        return !AbstractPackageManifestManager.isPackageSynchronizable(descriptor);
    }

    private boolean isPackageExcluded(PackageDescriptor descriptor, Package pkg) {
        return !AbstractPackageManifestManager.isPackageSynchronizable(descriptor, pkg);
    }

    private void copyJARsToAllNodes(File jarDir) throws Exception {
        this.copyJARsToNodes(this.getFabricNodes(), jarDir);
    }

    private void copyJARsToNodes(List<FabricNode> fabricNodes, File jarDir) throws Exception {
        for (FabricNode targetNode : fabricNodes) {
            this.copyJARsToNode(jarDir, targetNode);
        }
    }

    private void copyJARsToNode(File jarDir, FabricNode targetNode) throws Exception {
        List<File> jars = Arrays.asList(jarDir.listFiles());
        if (!Utils.isEmpty(jars)) {
            SLFileUtils remoteStream = this.createFileStream(targetNode);
            remoteStream.createDirectory(this.getJarDirName(jarDir));
            for (File jar : jars) {
                try (InputStream inputStream = Files.newInputStream(jar.toPath(), new OpenOption[0]);){
                    this.logInfo("Copying archive '" + jar.getName() + "' to node " + targetNode.getPrintName() + "...");
                    remoteStream.createFile(new File(this.getJarDirName(jarDir), jar.getName()).getPath(), inputStream, true);
                    this.logInfo("Archive '" + jar.getName() + "' copied to node " + targetNode.getPrintName() + ".");
                }
                catch (Exception exception) {
                    this.logException(exception, true, "Copying archive '" + jar.getName() + "' to node " + targetNode.getPrintName() + " failed.");
                }
            }
        }
    }

    private List<String> copyExtJARs(List<String> jars, FabricNode targetNode, File targetDir) throws Exception {
        return this.copyJARs(jars, targetNode, targetDir, "extension ", (String jarName) -> this.context.repositoryAccessor.getExtensionArchiveURL((String)jarName).openStream());
    }

    private String copyLibJARsToAllNodes(List<String> jars) throws Exception {
        if (!Utils.isEmpty(jars)) {
            String jarDir = UUID.randomUUID().toString();
            for (FabricNode targetNode : this.getFabricNodes()) {
                this.copyLibJARs(jars, targetNode, jarDir);
            }
            return jarDir;
        }
        return null;
    }

    private List<String> copyLibJARs(List<String> jars, FabricNode targetNode, File targetDir) throws Exception {
        return this.copyLibJARs(jars, targetNode, targetDir.getName());
    }

    private List<String> copyLibJARs(List<String> jars, FabricNode targetNode, String targetDir) throws Exception {
        return this.copyJARs(jars, targetNode, targetDir, "", (String jarName) -> this.context.repositoryAccessor.getArchiveStream((String)jarName));
    }

    private List<String> copyJARs(List<String> jars, FabricNode targetNode, File targetDir, String jarType, Utils.Function<String, InputStream> jarGetter) throws Exception {
        return this.copyJARs(jars, targetNode, targetDir.getName(), jarType, jarGetter);
    }

    private List<String> copyJARs(List<String> jars, FabricNode targetNode, String targetDir, String jarType, Utils.Function<String, InputStream> jarGetter) throws Exception {
        if (!Utils.isEmpty(jars)) {
            SLFileUtils remoteStream = this.createFileStream(targetNode);
            remoteStream.createDirectory(this.getJarDirName(targetDir));
            for (String jarName : jars) {
                try (InputStream inputStream = jarGetter.apply(jarName);){
                    this.logInfo("Copying " + jarType + "archive '" + jarName + "' to node " + targetNode.getPrintName() + "...");
                    remoteStream.createFile(new File(this.getJarDirName(targetDir), jarName).getPath(), inputStream, true);
                    this.logInfo(StringUtils.toCapitalized(jarType + "archive") + " '" + jarName + "' copied to node " + targetNode.getPrintName() + ".");
                }
            }
        }
        return jars;
    }

    String getJarDirName(File jarDir) {
        return this.getJarDirName(jarDir.getName());
    }

    String getJarDirName(String jarDirName) {
        return jarDirName != null ? this.jarsDir.getName() + "/" + jarDirName : null;
    }

    File getJarDir(String jarDirName) {
        return jarDirName != null ? new File(this.jarsDir, jarDirName) : null;
    }

    private SLFileUtils createFileStream(FabricNode fabricNode) {
        return (SLFileUtils)new SLFileUtilsFactory().create(ModeratorUtils.makeComponentFullName(fabricNode.getName(), this.context.getSystemConnection()), null, null, 0x500000);
    }

    private Map<String, SemanticType> getSemanticTypesForSysplex(List<String> extJarsForSysplex, SyncLevel1ReplyData data) throws Exception {
        HashMap<String, SemanticType> result = new HashMap<String, SemanticType>();
        for (String jarName : extJarsForSysplex) {
            SemanticUtils.getRelatedSemanticTypes(jarName, true, this.context).forEach(type -> result.put(type.getTypeName(), (SemanticType)type));
        }
        List packagesForSysplex = data.packages.values().stream().filter(pkg -> pkg.source == PackageSource.NODE).collect(Collectors.toList());
        for (SyncPackageData pkgData : packagesForSysplex) {
            SemanticUtils.getRelatedSemanticTypes(pkgData.descriptor, this.context).forEach(type -> {
                result.put(type.getTypeName(), (SemanticType)type);
                data.semanticTypes.remove(type.getTypeName());
            });
        }
        return result;
    }

    private Map<String, SemanticType> getSemanticTypesForNode(Set<String> requestedTypes) {
        HashMap<String, SemanticType> result = new HashMap<String, SemanticType>();
        for (String typeName : this.context.getSemanticTypeCache().listSemanticTypes()) {
            if (!requestedTypes.contains(typeName)) continue;
            result.put(typeName, this.context.getSemanticTypeCache().lookupSemanticType(typeName));
        }
        return result;
    }

    private void synchronizeSemanticTypes(Map<String, SemanticType> receivedTypes) {
        this.logDebug("Semantic types synchronization...");
        for (SemanticType type : receivedTypes.values()) {
            try {
                if (!((RuntimeSemanticTypeFactory)this.context.semanticTypeFactory).updateSemanticType(type)) continue;
                this.logInfo("Semantic type '" + type.getTypeName() + "' (class '" + type.getClassName() + "') synchronized.");
            }
            catch (Exception exception) {
                this.logException(exception, true);
                this.logError("Synchronization of semantic type '" + type.getTypeName() + "' (class '" + type.getClassName() + "') failed.");
            }
        }
        this.logInfo("Semantic types synchronized.");
    }

    void addSemanticType(RuntimeSemanticTypeFactory factory, SemanticType type, boolean force) throws Exception {
        this.sysplexSynchronizer.invoke(ADD_SEMANTIC_TYPE_METHOD, factory, type, force);
    }

    private void doAddSemanticType(RuntimeSemanticTypeFactory factory, SemanticType type, boolean force) throws SemanticTypeFactoryException {
        factory.doAddSemanticTypeCore(type, force);
        if (!type.isSystem() && SemanticUtils.isSemanticTypeGlobal(type, this.context)) {
            boolean failed = false;
            Object error = "";
            Map<FabricAddress, Object> acks = this.broadcastWithAckToNodes(127, type);
            if (acks != null) {
                for (Map.Entry<FabricAddress, Object> entry : acks.entrySet()) {
                    if (!(entry.getValue() instanceof Throwable)) continue;
                    failed = true;
                    error = (String)error + "\n       Cause (in node " + this.getFabricNodeName(entry.getKey()) + "): " + ((Throwable)entry.getValue()).getMessage();
                }
            }
            if (failed) {
                try {
                    factory.doRemoveSemanticTypeCore(type.getTypeName(), true, true);
                    this.broadcastWithAckToNodes(128, new RemoveSemanticTypeData(type.getTypeName(), true));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RuntimeExchange.throwFactoryException(6011, "Synchronization in Sysplex failed." + (String)error);
            }
        }
        this.onCoherenceUpdate(CoherenceAgentAdvisoryType.SEMANTIC_TYPE_ADDED, type.getTypeName());
    }

    void removeSemanticType(RuntimeSemanticTypeFactory factory, String typeName, boolean force) throws Exception {
        this.sysplexSynchronizer.invoke(REMOVE_SEMANTIC_TYPE_METHOD, factory, typeName, force);
    }

    private void doRemoveSemanticType(RuntimeSemanticTypeFactory factory, String typeName, boolean force) throws SemanticTypeFactoryException {
        SemanticType type = factory.doRemoveSemanticTypeCore(typeName, force, false);
        if (type != null) {
            if (!type.isSystem() && SemanticUtils.isSemanticTypeGlobal(type, this.context)) {
                this.broadcastWithAckToNodes(128, new RemoveSemanticTypeData(typeName, force));
            }
            this.onCoherenceUpdate(CoherenceAgentAdvisoryType.SEMANTIC_TYPE_REMOVED, typeName);
        }
    }

    protected AbstractExchange.ImportSemanticTypeData invokeImportSemanticTypeRequest(String typeName, Map<String, Long> remoteJarTimestamps) throws Exception {
        SemanticTypeCache cache = this.context.getSemanticTypeCache();
        SemanticType type = cache.lookupSemanticType(typeName);
        RuntimeExchange.checkTypeExistence(typeName, type);
        if (!type.isValid()) {
            throw new ExchangeException(6024, "Semantic type not valid.");
        }
        Set<SemanticType> types = cache.listComponentSemanticTypes(typeName).stream().map(cache::lookupSemanticType).filter(Objects::nonNull).collect(Collectors.toSet());
        types.add(type);
        HashMap<String, Pair<byte[], Long>> jars = new HashMap<String, Pair<byte[], Long>>();
        for (SemanticType semanticType : types) {
            SemanticTypeInfo typeInfo = SemanticUtils.getSemanticTypeInfo(semanticType, this.context);
            if (typeInfo == null) continue;
            if (typeInfo.getExtJar() != null) {
                this.addJarData(typeInfo.getExtJar(), new ExtJarGetter(), remoteJarTimestamps, jars);
                continue;
            }
            if (typeInfo.getLibJar() != null) {
                this.addJarData(typeInfo.getLibJar(), new LibJarGetter(), remoteJarTimestamps, jars);
                continue;
            }
            if (typeInfo.getPackage() == null) continue;
            Package pkg = this.context.repositoryAccessor.getPackage(typeInfo.getPackage().getPackageType(), typeInfo.getPackage().getPackageName());
            String jar = SemanticUtils.getLibArchiveByClass(semanticType.getClassName(), pkg, this.context);
            if (jar == null) continue;
            this.addJarData(jar, new LibJarGetter(), remoteJarTimestamps, jars);
        }
        return new AbstractExchange.ImportSemanticTypeData(types, jars);
    }

    private void addJarData(String jarName, JarGetter getter, Map<String, Long> remoteTimestamps, Map<String, Pair<byte[], Long>> result) throws Exception {
        Long remoteTimestamp;
        long timestamp = TFCacheJarStorage.getInstance().getJarFileInfo(getter.getURL(jarName)).getFile().lastModified();
        Long l = remoteTimestamp = remoteTimestamps != null ? remoteTimestamps.get(jarName) : null;
        if (remoteTimestamp == null || remoteTimestamp != timestamp) {
            result.put(jarName, new Pair<byte[], Long>(getter.getContent(jarName), timestamp));
        }
    }

    Map<String, Map<String, List<String>>> getSemanticTypeDependenciesInSysplex(String typeName) throws Exception {
        Map<FabricAddress, Object> acks;
        SemanticType type;
        HashMap<String, Map<String, List<String>>> result = new HashMap<String, Map<String, List<String>>>();
        Map<String, List<String>> nodeDependencies = this.getSemanticTypeDependencies(typeName, false);
        if (!nodeDependencies.isEmpty()) {
            result.put(this.getNodeName(), nodeDependencies);
        }
        if ((type = this.context.getSemanticTypeCache().lookupSemanticType(typeName)) != null && SemanticUtils.isSemanticTypeGlobal(type, this.context) && (acks = this.broadcastWithAckToNodes(151, typeName)) != null) {
            for (Map.Entry<FabricAddress, Object> entry : acks.entrySet()) {
                if (!(entry.getValue() instanceof Map) || ((Map)entry.getValue()).isEmpty()) continue;
                result.put(this.getFabricNodeName(entry.getKey()), (Map)entry.getValue());
            }
        }
        return result;
    }

    Map<String, List<String>> getSemanticTypeDependencies(String typeName, boolean localOnly) throws Exception {
        return SemanticUtils.getDependencies(this.context.getSemanticTypeCache().lookupSemanticType(typeName), this.context, localOnly);
    }

    boolean hasDependenciesInSysplex(SemanticType type) {
        if (SemanticUtils.hasDependencies(type, this.context, false)) {
            return true;
        }
        if (SemanticUtils.isSemanticTypeGlobal(type, this.context)) {
            Map<FabricAddress, Object> acks = this.broadcastWithAckToNodes(152, type);
            return acks != null && acks.values().stream().filter(ack -> ack instanceof Boolean).anyMatch(ack -> (Boolean)ack);
        }
        return false;
    }

    private Map<Prototype, ImmutableEventDatagram> getPrototypesForSysplex(Set<String> sysplexPrototypes, Map<String, SemanticType> typesForSysplex) {
        AbstractDatagramPrototypeCache cache = (AbstractDatagramPrototypeCache)((Object)this.context.getDatagramPrototypeCache());
        HashMap<Prototype, ImmutableEventDatagram> result = new HashMap<Prototype, ImmutableEventDatagram>();
        for (Map.Entry<Prototype, ImmutableEventDatagram> entry : cache.getPrototypeEntries()) {
            String eventId = entry.getValue().getEventId();
            if (!RuntimeExchange.isPrototypeSynchronizable(eventId)) continue;
            String dataType = cache.getDataType(entry.getKey(), entry.getValue());
            if (dataType == null) {
                if (sysplexPrototypes.contains(eventId)) continue;
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!typesForSysplex.containsKey(dataType)) continue;
            result.put(entry.getKey(), entry.getValue());
            sysplexPrototypes.remove(eventId);
        }
        return result;
    }

    private Map<Prototype, ImmutableEventDatagram> getEventPrototypesForNode(Set<String> requestedPrototypes) {
        HashMap<Prototype, ImmutableEventDatagram> result = new HashMap<Prototype, ImmutableEventDatagram>();
        for (Map.Entry<Prototype, ImmutableEventDatagram> entry : ((AbstractDatagramPrototypeCache)((Object)this.context.getDatagramPrototypeCache())).getPrototypeEntries()) {
            String eventId = entry.getValue().getEventId();
            if (!requestedPrototypes.contains(eventId)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private void synchronizeEventPrototypes(Map<Prototype, ImmutableEventDatagram> receivedPrototypes) {
        this.logDebug("Event prototypes synchronization...");
        for (Map.Entry<Prototype, ImmutableEventDatagram> entry : receivedPrototypes.entrySet()) {
            try {
                FabricEventSourceFactoryImpl.resolveAnnotations(entry.getValue());
                if (!this.context.getRuntimeDatagramPrototypeFactory().updatePrototype(entry.getKey(), entry.getValue())) continue;
                this.logInfo("Event prototype [" + entry.getValue().getEventId() + "] synchronized.");
            }
            catch (Exception exception) {
                this.logException(exception, true);
                this.logError("Synchronization of event prototype [" + entry.getValue().getEventId() + "] failed.");
            }
        }
        this.logInfo("Event prototypes synchronized.");
    }

    private static boolean isPrototypeSynchronizable(String eventId) {
        return !SDOUtils.isSystemEventId(eventId) && !SystemEvents.isPredefined(eventId);
    }

    void addEventPrototype(RuntimeDatagramPrototypeFactory prototypeFactory, IAbstractDatagramFactory factory, Prototype prototype, String eventId, ImmutableEventDatagram event) throws Exception {
        this.sysplexSynchronizer.invoke(ADD_EVENT_PROTOTYPE_METHOD, prototypeFactory, factory, prototype, eventId, event);
    }

    private void doAddEventPrototype(RuntimeDatagramPrototypeFactory prototypeFactory, IAbstractDatagramFactory factory, Prototype prototype, String eventId, ImmutableEventDatagram event) throws DatagramFactoryException {
        if (prototypeFactory.isPrototypeGlobal(prototype, event = prototypeFactory.doAddPrototypeCore(factory, prototype, eventId, event))) {
            this.broadcastWithAckToNodes(129, new AbstractExchange.EventPrototypeData(prototype, event));
        }
        this.onCoherenceUpdate(CoherenceAgentAdvisoryType.EVENT_PROTOTYPE_ADDED, eventId);
    }

    void removeEventPrototype(RuntimeDatagramPrototypeFactory prototypeFactory, IAbstractDatagramFactory factory, String eventId, boolean force) throws Exception {
        this.sysplexSynchronizer.invoke(REMOVE_EVENT_PROTOTYPE_METHOD, prototypeFactory, factory, eventId, force);
    }

    private void doRemoveEventPrototype(RuntimeDatagramPrototypeFactory protoFactory, IAbstractDatagramFactory factory, String eventId, boolean force) throws DatagramFactoryException {
        boolean isGlobal = protoFactory.isPrototypeGlobal(eventId);
        protoFactory.doRemovePrototypeCore(factory, eventId, force, true);
        if (isGlobal) {
            this.broadcastWithAckToNodes(130, new Pair<String, Boolean>(eventId, force));
        }
        this.onCoherenceUpdate(CoherenceAgentAdvisoryType.EVENT_PROTOTYPE_REMOVED, eventId);
    }

    protected Object invokeImportEventPrototypeRequest(AbstractExchange.ImportEventPrototypeData data) throws Exception {
        Pair<Prototype, ImmutableEventDatagram> result = this.context.getRuntimeDatagramPrototypeFactory().getPrototype(data.eventId);
        if (data.archiveTimestamps != null && result.second instanceof PayloadEvent) {
            if (!((Prototype)result.first).isValid()) {
                throw new ExchangeException("Event prototype not valid. Cause: " + ((Prototype)result.first).getError());
            }
            String typeName = this.context.getSemanticTypeCache().resolveSemanticClass(((PayloadEvent)result.second).getPayloadClass());
            if (typeName == null) {
                throw new ExchangeException(6024, "Semantic type not found for event [" + data.eventId + "].");
            }
            return this.invokeImportSemanticTypeRequest(typeName, data.archiveTimestamps);
        }
        return new AbstractExchange.EventPrototypeData(result);
    }

    private void addEventPrototype(Prototype prototype, ImmutableEventDatagram event, boolean notify) throws DatagramFactoryException {
        this.context.getRuntimeDatagramPrototypeFactory().doAddEventPrototype(prototype, event, notify);
    }

    private void removeEventPrototype(String eventId, boolean force) throws Exception {
        this.context.getRuntimeDatagramPrototypeFactory().doRemovePrototype(eventId, force, false);
    }

    private static <T> Map<String, T> getSubMap(Map<String, T> map, Set<String> keys) {
        HashMap result = new HashMap();
        map.entrySet().stream().filter(entry -> keys.contains(entry.getKey())).forEach(entry -> result.put((String)entry.getKey(), entry.getValue()));
        return result;
    }

    private ReplicationRules.ExclusionList getExclusionList() {
        ReplicationRules.ExclusionList result = this.doGetExclusionList();
        Map<FabricAddress, Object> acks = this.broadcastWithAckToNodes(157, null);
        if (acks != null) {
            for (Object ack : acks.values()) {
                if (!(ack instanceof ReplicationRules.ExclusionList)) continue;
                result.merge((ReplicationRules.ExclusionList)ack);
            }
        }
        return result;
    }

    private ReplicationRules.ExclusionList doGetExclusionList() {
        ReplicationRules.ExclusionList result = new ReplicationRules.ExclusionList();
        this.context.manifestManager.getPackages().stream().filter(pkg -> pkg.isGeneric() && !pkg.isGlobal()).map(PackageDescriptor::getFullName).forEach(result::addPackage);
        return result;
    }

    void addReplicationSource(ReplicationSourceReferenceImpl reference) {
        this.addReplicationEntity(reference);
    }

    void addReplicationTarget(ReplicationTargetReferenceImpl reference) {
        this.addReplicationEntity(reference);
    }

    private void addReplicationEntity(ReplicationEntityReferenceImpl reference) {
        if (reference.eventScope != EventScope.OBSERVABLE) {
            this.sysplexSynchronizer.invokeWithoutException(ADD_REPLICATION_ENTITY_METHOD, reference);
        } else {
            this.doAddReplicationEntity(reference);
        }
    }

    private void doAddReplicationEntity(ReplicationEntityReferenceImpl reference) {
        this.node.addReplicationEntity(reference);
        this.notifyOnUpdate(24, reference, AbstractExchange.UpdateType.ADD);
    }

    void removeReplicationSource(ReplicationSourceReferenceImpl reference) {
        this.removeReplicationEntity(reference);
    }

    void removeReplicationTarget(ReplicationTargetReferenceImpl reference) {
        this.removeReplicationEntity(reference);
    }

    private void removeReplicationEntity(ReplicationEntityReferenceImpl reference) {
        if (reference.eventScope != EventScope.OBSERVABLE) {
            this.sysplexSynchronizer.invokeWithoutException(REMOVE_REPLICATION_ENTITY_METHOD, reference);
        } else {
            this.doRemoveReplicationEntity(reference);
        }
    }

    private void doRemoveReplicationEntity(ReplicationEntityReferenceImpl reference) {
        this.node.removeReplicationEntity(reference);
        this.notifyOnUpdate(25, reference, AbstractExchange.UpdateType.REMOVE);
    }

    void changeReplicationSource(ReplicationSourceReferenceImpl reference) {
        this.changeReplicationEntity(reference);
    }

    void changeReplicationTarget(ReplicationTargetReferenceImpl reference) {
        this.changeReplicationEntity(reference);
    }

    private void changeReplicationEntity(ReplicationEntityReferenceImpl reference) {
        if (reference.eventScope != EventScope.OBSERVABLE) {
            this.sysplexSynchronizer.invokeWithoutException(CHANGE_REPLICATION_ENTITY_METHOD, reference);
        } else {
            this.doChangeReplicationEntity(reference);
        }
    }

    private void doChangeReplicationEntity(ReplicationEntityReferenceImpl reference) {
        this.node.changeReplicationEntity(reference);
        this.notifyOnUpdate(26, reference, AbstractExchange.UpdateType.CHANGE);
    }

    private Map<FabricAddress, Object> survey() {
        HashMap<FabricAddress, Object> result = new HashMap<FabricAddress, Object>();
        Map<FabricAddress, Object> acks = this.broadcastWithAckToNodes(134, null, this.fastReplyTimeout);
        if (acks != null) {
            acks.entrySet().stream().filter(entry -> entry.getValue() instanceof MissingAck || entry.getValue() instanceof Boolean && (Boolean)entry.getValue() == false).forEach(entry -> result.put((FabricAddress)entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private void setExtendedData(TokenMonitorResult result) {
        result.parameters = this.getDynamicParameters(true);
        result.jvmStats = this.doInvokeSlangRequest(new ShowStatsOperation.Definition());
    }

    private RowSet doInvokeSlangRequest(SLStatement statement) {
        try {
            return this.invokeSlangRequest(statement, this.fastReplyTimeout).getRowSet();
        }
        catch (Exception exception) {
            this.logException(exception, true);
            return null;
        }
    }

    void onCoherenceUpdate(CoherenceAgentAdvisoryType type, String entity) {
        CoherenceAgentAdvisory advisory = new CoherenceAgentAdvisory(type, entity);
        this.broadcastWithAckToClients(43, advisory, null);
        this.onCoherenceUpdate(advisory);
    }

    void onCoherenceUpdate(CoherenceAgentAdvisoryType type1, CoherenceAgentAdvisoryType type2, String entity) {
        CoherenceAgentAdvisory advisory1 = new CoherenceAgentAdvisory(type1, entity);
        CoherenceAgentAdvisory advisory2 = new CoherenceAgentAdvisory(type2, entity);
        this.broadcastWithAckToClients(43, advisory1, null);
        this.broadcastWithAckToClients(43, advisory2, null);
        this.onCoherenceUpdate(advisory1, advisory2);
    }

    private Map<String, TimeWindow> getTimeWindows() {
        return this.context.schedulerImpl.getTimeWindowsMap();
    }

    private Map<String, TimeWindow> getTimeWindowsCopy() {
        return new HashMap<String, TimeWindow>(this.context.schedulerImpl.getTimeWindowsMap());
    }

    private void synchronizeTimeWindowsInSysplex(Map<String, TimeWindow> nodeTimeWindows, boolean newOnly) {
        try {
            this.logDebug("Time Windows synchronization...");
            this.context.schedulerImpl.synchronizeTimeWindowsInSysplex(nodeTimeWindows, newOnly);
            this.logInfo("Time Windows synchronized.");
        }
        catch (SchedulerException exception) {
            this.logException(exception, true, "Synchronization of Time Windows failed.");
        }
    }

    private void synchronizeTimeWindowsInNode(Map<String, TimeWindow> sysplexTimeWindows) {
        try {
            this.logDebug("Time Windows synchronization...");
            this.context.schedulerImpl.synchronizeTimeWindowsInNode(sysplexTimeWindows);
            this.logInfo("Time Windows synchronized.");
        }
        catch (SchedulerException exception) {
            this.logException(exception, true, "Synchronization of Time Windows failed.");
        }
    }

    void addTimeWindow(AbstractSchedulerImpl scheduler, TimeWindow window) throws Exception {
        this.sysplexSynchronizer.invoke(ADD_TIME_WINDOW_METHOD, scheduler, window);
    }

    private void doAddTimeWindow(AbstractSchedulerImpl scheduler, TimeWindow window) throws SchedulerException {
        scheduler.doAddTimeWindow(window);
        this.notifyOnUpdateTimeWindow(137, window, ModeratorAdvisoryType.TIME_WINDOW_ADDED, window.getName());
    }

    void removeTimeWindow(AbstractSchedulerImpl scheduler, String windowName) throws Exception {
        this.sysplexSynchronizer.invoke(REMOVE_TIME_WINDOW_METHOD, scheduler, windowName);
    }

    private void doRemoveTimeWindow(AbstractSchedulerImpl scheduler, String windowName) throws SchedulerException {
        if (scheduler.doRemoveTimeWindow(windowName)) {
            this.notifyOnUpdateTimeWindow(138, windowName, ModeratorAdvisoryType.TIME_WINDOW_REMOVED, windowName);
        }
    }

    void changeTimeWindow(AbstractSchedulerImpl scheduler, TimeWindow window) throws Exception {
        this.sysplexSynchronizer.invoke(CHANGE_TIME_WINDOW_METHOD, scheduler, window);
    }

    private void doChangeTimeWindow(AbstractSchedulerImpl scheduler, TimeWindow window) throws SchedulerException {
        if (scheduler.doSetTimeWindow(window)) {
            this.notifyOnUpdateTimeWindow(139, window, ModeratorAdvisoryType.TIME_WINDOW_CHANGED, window.getName());
        }
    }

    private void notifyOnUpdateTimeWindow(int eventId, Object data, ModeratorAdvisoryType advisoryType, String advisoryEntity) {
        this.broadcastWithAckToNodes(eventId, data);
        this.onSysplexUpdate(advisoryType, advisoryEntity);
    }

    <T> List<T> broadcastSchedulerRequest(AbstractExchange.OperationData data) {
        ArrayList result = new ArrayList();
        Map<FabricAddress, Object> acks = this.broadcastWithAckToNodesUser(140, data);
        if (acks != null) {
            acks.entrySet().stream().filter(entry -> entry.getValue() instanceof List).forEach(entry -> result.addAll((List)entry.getValue()));
        }
        return result;
    }

    private Object invokeSchedulerOperation(AbstractExchange.OperationData data, ExchangeConnection connection, boolean isEvent) throws ExchangeException {
        try {
            Method method = Scheduler.class.getDeclaredMethod(data.methodName, this.getParameterTypes(data));
            return method.invoke((Object)this.context.scheduler, data.parameters);
        }
        catch (InvocationTargetException exception) {
            if (exception.getCause() instanceof SchedulerException && !isEvent) {
                return exception.getCause();
            }
            throw new ExchangeException("Processing of internal " + (isEvent ? "event [" : "request [") + (String)INTERNAL_EVENT_NAMES.get(140) + "] failed.", exception.getCause());
        }
        catch (Exception exception) {
            throw new ExchangeException("Processing of internal " + (isEvent ? "event [" : "request [") + (String)INTERNAL_EVENT_NAMES.get(140) + "] failed.", (Throwable)exception);
        }
    }

    @Override
    public List<TopologyLink> getTopology() {
        return this.routingTable.getLinks().stream().map(link -> new TopologyLink(link.node1.getName(), link.node2.getName(), link.address)).collect(Collectors.toList());
    }

    boolean existsNodeConnection(FabricAddress nodeAddress) {
        return this.nodeConnections.containsKey(nodeAddress);
    }

    boolean existsNodeConnection(String nodeName) {
        FabricNode fabricNode = this.getFabricNode(nodeName);
        return fabricNode != null && this.existsNodeConnection(fabricNode);
    }

    boolean existsNodeConnection(FabricNodeReference fabricNode) {
        return this.existsNodeConnection(fabricNode.getFabricAddress());
    }

    private DirectoryTable getDirectoryTable() {
        return this.context.discoveryModule.getDirectoryTable();
    }

    private DirectoryTable synchronizeDirectoryTableInSysplex(DirectoryTable tableInNode) {
        DirectoryTable result = null;
        this.logDebug("Directory Table synchronization...");
        DirectoryTable tableInSysplex = this.getDirectoryTable();
        if (tableInSysplex != null && tableInNode != null && (((AbstractDirectoryTable)tableInSysplex).merge(tableInNode) || !tableInSysplex.equals(tableInNode))) {
            result = tableInSysplex;
        }
        this.logInfo("Directory Table synchronized.");
        return result;
    }

    private void synchronizeDirectoryTable(DirectoryTable newTable) {
        try {
            this.logDebug("Directory Table synchronization...");
            this.updateDirectoryTable(newTable);
            this.logInfo("Directory Table synchronized.");
        }
        catch (DiscoveryModuleException exception) {
            this.logException(exception, true, "Synchronization of Directory Table failed.");
        }
    }

    void updateDirectoryTable(AbstractDirectoryTable table, Method method, Object ... parameters) throws DiscoveryModuleException {
        try {
            this.sysplexSynchronizer.invoke(UPDATE_DIRECTORY_TABLE_METHOD, table, method, parameters);
        }
        catch (Throwable exception) {
            if (exception instanceof InvocationTargetException) {
                exception = ((InvocationTargetException)exception).getTargetException();
            }
            if (exception instanceof DiscoveryModuleException) {
                throw (DiscoveryModuleException)exception;
            }
            throw new DiscoveryModuleException(6011, "Unexpected exception", exception);
        }
    }

    private void doUpdateDirectoryTable(AbstractDirectoryTable table, Method method, Object ... parameters) throws Exception {
        if (((Boolean)method.invoke((Object)table, parameters)).booleanValue()) {
            this.broadcastWithAckToNodes(141, table);
        }
    }

    private void updateDirectoryTable(DirectoryTable newTable) throws DiscoveryModuleException {
        DirectoryTable oldTable = this.getDirectoryTable();
        if (oldTable != null && newTable != null) {
            ((AbstractDirectoryTable)oldTable).doReplace(newTable);
        }
    }

    @Override
    AbstractFabricGroupManager getGroupManager() {
        return this.groupManager;
    }

    AbstractFabricGroup createGroup(String name, String description, FabricAddress clientAddress) throws FabricGroupManagerException {
        try {
            return (AbstractFabricGroup)this.sysplexSynchronizer.invoke(CREATE_GROUP_METHOD, name, description, clientAddress);
        }
        catch (Exception exception) {
            if (exception instanceof FabricGroupManagerException) {
                throw (FabricGroupManagerException)exception;
            }
            throw new FabricGroupManagerException(6011, "Unexpected exception.", exception);
        }
    }

    private AbstractFabricGroup doCreateGroup(String name, String description, FabricAddress clientAddress) throws FabricGroupManagerException {
        RuntimeFabricGroup result = this.groupManager.doCreateGroup(name, description);
        this.notifyOnCreateGroup(result, clientAddress, true);
        return result;
    }

    private void notifyOnCreateGroup(FabricGroup group, FabricAddress excludedClientAddress, boolean notifyNodes) {
        this.notifyOnUpdate(44, (Object)group, excludedClientAddress, notifyNodes, ModeratorAdvisoryType.GROUP_CREATED, group.getName(), null);
    }

    void dropGroup(String groupName, FabricAddress clientAddress) throws FabricGroupManagerException {
        try {
            this.sysplexSynchronizer.invoke(DROP_GROUP_METHOD, groupName, clientAddress);
        }
        catch (Exception exception) {
            if (exception instanceof FabricGroupManagerException) {
                throw (FabricGroupManagerException)exception;
            }
            throw new FabricGroupManagerException(6011, "Unexpected exception.", exception);
        }
    }

    private void doDropGroup(String groupName, FabricAddress clientAddress) throws FabricGroupManagerException {
        if (this.groupManager.doDropGroup(groupName) != null) {
            this.notifyOnDropGroup(groupName, clientAddress, true);
        }
    }

    private void notifyOnDropGroup(String groupName, FabricAddress excludedClientAddress, boolean notifyNodes) {
        this.notifyOnUpdate(45, (Object)groupName, excludedClientAddress, notifyNodes, ModeratorAdvisoryType.GROUP_DROPPED, groupName, null);
    }

    private void synchronizeFabricGroups(List<FabricGroup> nodeGroups) {
        this.groupManager.synchronizeGroups(nodeGroups);
        this.broadcastWithAckToClients(48, nodeGroups, null);
    }

    @Override
    AbstractFabricGroup addGroupMember(String groupName, ComponentReferenceImpl component, boolean notifyNodes) throws FabricGroupManagerException {
        try {
            return (AbstractFabricGroup)this.sysplexSynchronizer.invoke(ADD_GROUP_MEMBER_METHOD, groupName, component, notifyNodes);
        }
        catch (Exception exception) {
            if (exception instanceof FabricGroupManagerException) {
                throw (FabricGroupManagerException)exception;
            }
            throw new FabricGroupManagerException(6011, "Unexpected exception.", exception);
        }
    }

    @Override
    AbstractFabricGroup doAddGroupMember(String groupName, ComponentReferenceImpl component, boolean notifyNodes) throws FabricGroupManagerException {
        return super.doAddGroupMember(groupName, component, notifyNodes);
    }

    @Override
    void removeGroupMember(String groupName, ComponentReferenceImpl component, boolean notifyNodes) throws FabricGroupManagerException {
        try {
            this.sysplexSynchronizer.invoke(REMOVE_GROUP_MEMBER_METHOD, groupName, component, notifyNodes);
        }
        catch (Exception exception) {
            if (exception instanceof FabricGroupManagerException) {
                throw (FabricGroupManagerException)exception;
            }
            throw new FabricGroupManagerException(6011, "Unexpected exception.", exception);
        }
    }

    @Override
    void doRemoveGroupMember(String groupName, ComponentReferenceImpl component, boolean notifyNodes) throws FabricGroupManagerException {
        super.doRemoveGroupMember(groupName, component, notifyNodes);
    }

    @Override
    void notifyOnChangeGroupMember(int eventId, String groupName, ComponentReferenceImpl component, boolean notifyNodes, ModeratorAdvisoryType advisoryType) {
        this.notifyOnUpdate(eventId, (Object)new AbstractExchange.GroupMemberData(groupName, component.address), component.getModel() == ComponentModel.REMOTE_CLIENT ? component.address : null, notifyNodes, advisoryType, groupName, component.getName());
    }

    void closeDiagnosticSessions() {
        for (AbstractExchange.AbstractExchangeConnection abstractExchangeConnection : this.diagnosticConnections.values()) {
            abstractExchangeConnection.close(true);
        }
        this.diagnosticConnections.clear();
    }

    List<RuntimeStats> getRuntimeStats(AbstractExchange.OperationData data) {
        ArrayList<RuntimeStats> result = new ArrayList<RuntimeStats>();
        Map<FabricAddress, Object> acks = this.broadcastWithAckToNodesUser(142, data);
        if (acks != null) {
            result.addAll(acks.values().stream().filter(o -> o instanceof RuntimeStats).map(o -> (RuntimeStats)o).collect(Collectors.toList()));
        }
        return result;
    }

    private Object invokeStatsMonitorOperation(AbstractExchange.OperationData data, ExchangeConnection connection) throws ExchangeException {
        try {
            Method method = StatsMonitor.class.getDeclaredMethod(data.methodName, this.getParameterTypes(data));
            return method.invoke((Object)this.context.statsMonitor, data.parameters);
        }
        catch (InvocationTargetException exception) {
            throw new ExchangeException("Processing of internal event [" + (String)INTERNAL_EVENT_NAMES.get(142) + "] failed.", exception.getCause());
        }
        catch (Exception exception) {
            throw new ExchangeException("Processing of internal event [" + (String)INTERNAL_EVENT_NAMES.get(142) + "] failed.", (Throwable)exception);
        }
    }

    SLResponse invokeSlangRequest(String nodeName, SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.doSlangRequest(nodeName, statement, session, timeout);
    }

    private SLResponse doSlangRequest(String nodeName, SLStatement statement, MFSession session, long timeout) throws Exception {
        return (SLResponse)this.raiseInternalRequest(nodeName, 143, (Object)new SlangData(statement, session, timeout), timeout);
    }

    Map<String, Object> broadcastSlangRequest(SLStatement statement, MFSession session, long timeout, boolean mnodesOnly) throws Exception {
        Map<FabricAddress, Object> acks = this.doBroadcastWithAckToNodesUser(143, new SlangData(statement, session, timeout), timeout, mnodesOnly);
        return acks != null ? this.convertBroadcastResponse(acks) : null;
    }

    @Override
    boolean suppressLog(Object data) {
        return data instanceof SlangData || data instanceof DropBoxTableManager.DropBoxTableSynchronizationData;
    }

    private static boolean suppressLog(SlangData data) {
        return SecurityManagerImpl.isSysadmin(data.session.getOwnerName()) || data.statement instanceof AbstractShowUsageOperation.Definition;
    }

    private SLResponse invokeSlangRequest(SlangData data) throws Exception {
        User user = this.getUser(data.session.getOwnerName());
        return this.context.getLexiconProcessor().invoke(data.statement, (MFSession)(data.session.isDiagnostic() ? new DiagnosticInstantMFSession(user, this.getNodeName()) : new InstantMFSession(data.session, user, this.getNodeName())), data.timeout);
    }

    SLResponse invokeSlangRequest(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.context.getLexiconProcessor().invoke(statement, (MFSession)new InstantMFSession(session, this.getUser(session.getOwnerName()), this.getNodeName()), timeout);
    }

    private SLResponse invokeSlangRequest(SLStatement statement, long timeout) throws Exception {
        return this.context.getLexiconProcessor().invoke(statement, (MFSession)new InstantMFSession(this.getUser(this.context.getUserName()), this.getNodeName()), timeout);
    }

    private User getUser(String userName) throws Exception {
        return this.context.isSecurityEnabled() ? this.context.securityManagerImpl.doGetUser(userName) : null;
    }

    List<ConfigurationParameter> getDynamicParameters(boolean skipThreadIds) {
        ArrayList<ConfigurationParameter> parameters = new ArrayList<ConfigurationParameter>();
        RuntimeExchange.addParameter("Node Name", this.getNodeName(), parameters);
        RuntimeExchange.addParameter("Peer State", (Object)this.getPeerState(), parameters);
        RuntimeExchange.addParameter("Node Address", this.getNodeAddress(), parameters);
        if (this.sysplexSynchronizer.isTokenActive) {
            RuntimeExchange.addParameter("Is Root", this.sysplexSynchronizer.isRoot, parameters);
            RuntimeExchange.addParameter("Has Token", this.sysplexSynchronizer.hasToken, parameters);
            RuntimeExchange.addParameter("Token Id", this.sysplexSynchronizer.tokenId, parameters);
            RuntimeExchange.addParameter("Token Packet", Utils.toString(this.sysplexSynchronizer.tokenPacket, ""), parameters);
            RuntimeExchange.addParameter("Token Destination", this.formatTokenDestination(), parameters);
            RuntimeExchange.addParameter("Token Receipt Time", RuntimeExchange.getTokenTimestamp(this.sysplexSynchronizer.tokenReceiptTime), parameters);
            RuntimeExchange.addParameter("Token Holding Time", RuntimeExchange.getTokenTime(this.sysplexSynchronizer.getTokenHoldingTime()), parameters);
            RuntimeExchange.addParameter("Token Sending Time", RuntimeExchange.getTokenTimestamp(this.sysplexSynchronizer.tokenSendingTime), parameters);
            RuntimeExchange.addParameter("Token Absence Time", RuntimeExchange.getTokenTime(this.sysplexSynchronizer.getTokenAbsenceTime()), parameters);
            RuntimeExchange.addWorkerParameter("Token Sender", this.sysplexSynchronizer.tokenSender, parameters, skipThreadIds);
            RuntimeExchange.addWorkerParameter("Token Processor", this.sysplexSynchronizer.tokenProcessor, parameters, skipThreadIds);
            RuntimeExchange.addWorkerParameter("Token Monitor", this.sysplexSynchronizer.tokenMonitor, parameters, skipThreadIds);
            RuntimeExchange.addParameter("Join", RuntimeExchange.formatInProgress(this.sysplexSynchronizer.joinInProgress), parameters);
            this.addForcedDisconnectionParameter(parameters, skipThreadIds);
        }
        return parameters;
    }

    private String formatTokenDestination() {
        FabricNode fabricNode = this.getFabricNode(this.sysplexSynchronizer.tokenDestination);
        return fabricNode != null ? fabricNode.getName() + "(" + String.valueOf(this.sysplexSynchronizer.tokenDestination) + ")" : this.sysplexSynchronizer.tokenDestination.toString();
    }

    private static String convertActive(boolean isActive) {
        return isActive ? "Active" : "Inactive";
    }

    private static String formatInProgress(boolean inProgress) {
        return inProgress ? "In Progress" : "Absent";
    }

    private static void addWorkerParameter(String name, IWorker worker, List<ConfigurationParameter> parameters, boolean skipThreadId) {
        RuntimeExchange.addParameter(name, RuntimeExchange.convertActive(worker != null), parameters);
        if (!skipThreadId && worker != null) {
            RuntimeExchange.addParameter(name + " Thread Id", worker.getThread().getId(), parameters);
        }
    }

    private void addForcedDisconnectionParameter(List<ConfigurationParameter> parameters, boolean skipThreadId) {
        RuntimeExchange.addParameter("Forced Disconnection", RuntimeExchange.formatInProgress(this.sysplexSynchronizer.forcedDisconnectInProgress), parameters);
        if (this.sysplexSynchronizer.forcedDisconnectInProgress) {
            RuntimeExchange.addWorkerParameter("Forced Disconnection Processor", this.sysplexSynchronizer.forcedDisconnectProcessor, parameters, skipThreadId);
        }
    }

    List<ConfigurationParameter> getDynamicParametersSummary() {
        return this.getDynamicParametersSummary(null);
    }

    private List<ConfigurationParameter> getDynamicParametersSummary(List<TokenMonitorResult> results) {
        TokenMonitorData.Action action = results != null ? TokenMonitorData.Action.ADVISORY : TokenMonitorData.Action.SLANG;
        ArrayList<ConfigurationParameter> parameters = new ArrayList<ConfigurationParameter>();
        RuntimeExchange.addParameter("Peer State", (Object)this.getPeerState(), parameters);
        if (this.inSysplex()) {
            TokenMonitorResult result = new TokenMonitorResult(this.sysplexSynchronizer.hasToken, this.sysplexSynchronizer.tokenReceiptTime, this.sysplexSynchronizer.getTokenHoldingTime(), this.sysplexSynchronizer.tokenSendingTime, this.sysplexSynchronizer.getTokenAbsenceTime());
            if (action == TokenMonitorData.Action.ADVISORY) {
                this.setExtendedData(result);
                results.add(result);
            }
            long tokenAbsenceTime = Long.MAX_VALUE;
            FabricAddress tokenLocation = this.sysplexSynchronizer.hasToken ? this.node.getFabricAddress() : null;
            FabricAddress tokenLastLocation = this.node.getFabricAddress();
            HashSet<FabricAddress> missingNodes = new HashSet<FabricAddress>();
            if (tokenLocation != null && action == TokenMonitorData.Action.SLANG) {
                this.getMissingNodes(missingNodes);
            } else {
                Map<FabricAddress, Object> acks = this.broadcastWithAckToNodes(136, new TokenMonitorData(this.sysplexSynchronizer.tokenId, action), this.fastReplyTimeout);
                if (acks != null) {
                    for (Map.Entry<FabricAddress, Object> entry : acks.entrySet()) {
                        if (entry.getValue() instanceof MissingAck) {
                            missingNodes.add(entry.getKey());
                            continue;
                        }
                        if (!(entry.getValue() instanceof TokenMonitorResult)) continue;
                        TokenMonitorResult currentResult = (TokenMonitorResult)entry.getValue();
                        if (currentResult.hasToken) {
                            result = currentResult;
                            tokenLastLocation = tokenLocation = entry.getKey();
                        } else if (tokenLocation == null) {
                            if (currentResult.tokenAbsenceTime < tokenAbsenceTime) {
                                tokenAbsenceTime = currentResult.tokenAbsenceTime;
                            }
                            if (currentResult.tokenReceiptTime > result.tokenReceiptTime) {
                                result = currentResult;
                                tokenLastLocation = entry.getKey();
                            }
                        }
                        if (action != TokenMonitorData.Action.ADVISORY) continue;
                        results.add(currentResult);
                    }
                }
            }
            RuntimeExchange.addParameter("Root Node", this.getFabricNodeName(this.sysplexSynchronizer.getRootNode()), parameters);
            RuntimeExchange.addParameter("Token Id", this.sysplexSynchronizer.tokenId, parameters);
            if (tokenLocation != null) {
                RuntimeExchange.addParameter("Token State", "Active", parameters);
                RuntimeExchange.addParameter("Token Location", this.getFabricNodeName(tokenLocation), parameters);
            } else {
                RuntimeExchange.addParameter("Token State", tokenAbsenceTime > this.fastReplyTimeout ? "Lost" : "Uncertain", parameters);
                RuntimeExchange.addParameter("Token Last Location", this.getFabricNodeName(tokenLastLocation), parameters);
            }
            RuntimeExchange.addTokenTimes(result, parameters);
            List unreachableNodes = missingNodes.stream().map(this::getFabricNodeName).collect(Collectors.toList());
            RuntimeExchange.addParameter("Unreachable Nodes", unreachableNodes, parameters);
        }
        return parameters;
    }

    private static void addTokenTimes(TokenMonitorResult data, List<ConfigurationParameter> parameters) {
        RuntimeExchange.addParameter("Token Receipt Time", RuntimeExchange.getTokenTimestamp(data.tokenReceiptTime), parameters);
        RuntimeExchange.addParameter("Token Holding Time", RuntimeExchange.getTokenTime(data.tokenHoldingTime), parameters);
        RuntimeExchange.addParameter("Token Sending Time", RuntimeExchange.getTokenTimestamp(data.tokenSendingTime), parameters);
        RuntimeExchange.addParameter("Token Absence Time", RuntimeExchange.getTokenTime(data.tokenAbsenceTime), parameters);
    }

    private void getMissingNodes(Set<FabricAddress> missingNodes) {
        Map<FabricAddress, Object> acks = this.broadcastWithAckToNodes(134, null);
        if (acks != null) {
            missingNodes.addAll(acks.entrySet().stream().filter(entry -> entry.getValue() instanceof MissingAck).map(Map.Entry::getKey).collect(Collectors.toList()));
        }
    }

    private String getFabricNodeName(FabricAddress address) {
        if (address.equals(this.getNodeAddress())) {
            return this.getNodeName();
        }
        FabricNode node = this.getFabricNode(address);
        return node != null ? node.getName() : "N/A";
    }

    private String getFabricNodePrintName(FabricAddress address) {
        if (address.equals(this.getNodeAddress())) {
            return this.getNodePrintName();
        }
        FabricNode node = this.getFabricNode(address);
        return node != null ? this.getNodePrintName() : FabricNode.getPrintName(address.toString());
    }

    private static String getTokenTimestamp(long timestamp) {
        return timestamp > 0L ? TIME_FORMAT.format(new Date(timestamp)) : "N/A";
    }

    private static String getTokenTime(long time) {
        return time > 0L ? time + " milliseconds" : "N/A";
    }

    private Object invokeModeratorOperation(FabricAddress sourceAddress, AbstractExchange.ModeratorOperationData data) throws ExchangeException {
        try {
            if (data.generic) {
                return ModeratorImpl.class.getDeclaredMethod(data.methodName, data.parameterTypes).invoke((Object)this.moderator, data.parameters);
            }
            if (data.parameterTypes.length > 0 && data.parameterTypes[0] == FabricAddress.class && data.parameters[0] == null) {
                data.parameters[0] = sourceAddress;
            }
            return FabricNode.class.getDeclaredMethod(data.methodName, data.parameterTypes).invoke((Object)this.node, data.parameters);
        }
        catch (Throwable exception) {
            throw new ExchangeException("Processing of internal request [" + (String)INTERNAL_EVENT_NAMES.get(54) + "] failed.", exception);
        }
    }

    <TReply> List<TReply> broadcastModeratorRequest(FabricAddress excludedAddress, String methodName, Class[] parameterTypes, Object ... parameters) {
        ArrayList result = new ArrayList();
        Map<FabricAddress, Object> acks = this.broadcastWithAckToClients(54, new AbstractExchange.ModeratorOperationData(methodName, parameterTypes, parameters), excludedAddress);
        if (acks != null) {
            acks.entrySet().stream().filter(entry -> entry.getValue() instanceof List).forEach(entry -> result.addAll((List)entry.getValue()));
        }
        return result;
    }

    @Override
    EventFlowMap getEventFlowMap(boolean all) {
        return this.eventFlowMap.normalize(all);
    }

    @Override
    EventFlowMap getMergedEventFlowMap(boolean all) {
        EventFlowMapImpl result = (EventFlowMapImpl)this.getEventFlowMap(all);
        Map<FabricAddress, Object> acks = this.broadcastWithAckToNodes(54, new AbstractExchange.ModeratorOperationData(true, "doGetEventFlowMap", new Class[]{Boolean.TYPE}, all));
        if (acks != null) {
            acks.values().stream().filter(ack -> ack instanceof EventFlowMapImpl).forEach(ack -> result.merge((EventFlowMapImpl)ack));
        }
        return result;
    }

    boolean existsEventFlows(String eventId, boolean inSysplex) {
        if (this.doExistsEventFlows(eventId)) {
            return true;
        }
        if (inSysplex) {
            Map<FabricAddress, Object> acks = this.broadcastWithAckToNodes(149, eventId);
            return acks != null && acks.values().stream().anyMatch(ack -> ack instanceof Boolean && (Boolean)ack != false);
        }
        return false;
    }

    private boolean doExistsEventFlows(String eventId) {
        return this.getEventFlowMap(true).existsEventFlows(eventId);
    }

    void closeAccessors(List<String> accessors) {
        this.doCloseAccessors(accessors, false);
    }

    private void doCloseAccessors(List<String> accessors, boolean inLocalNodeOnly) {
        HashMap<ComponentReference, List<String>> nodeAccessors = new HashMap<ComponentReference, List<String>>();
        HashMap<ComponentReference, List<String>> clientAccessors = new HashMap<ComponentReference, List<String>>();
        HashMap<FabricAddress, List<String>> remoteNodeAccessors = inLocalNodeOnly ? null : new HashMap<FabricAddress, List<String>>();
        this.resolveAccessors(accessors, nodeAccessors, clientAccessors, remoteNodeAccessors);
        this.closeLocalAccessors(nodeAccessors);
        this.closeRemoteClientAccessors(clientAccessors);
        if (!inLocalNodeOnly) {
            this.closeRemoteNodeAccessors(remoteNodeAccessors);
        }
    }

    private void resolveAccessors(List<String> accessors, Map<ComponentReference, List<String>> nodeAccessors, Map<ComponentReference, List<String>> clientAccessors, Map<FabricAddress, List<String>> remoteNodeAccessors) {
        for (String accessor : accessors) {
            ComponentReference client = this.moderator.lookupComponent(ModeratorUtils.extractComponentNameFromConsumerName(accessor));
            if (client == null) continue;
            if (this.isLocal(client.getAddress())) {
                this.addLocalNodeAccessor(accessor, client, client.getModel() == ComponentModel.REMOTE_CLIENT ? clientAccessors : nodeAccessors);
                continue;
            }
            if (remoteNodeAccessors == null) continue;
            this.addRemoteNodeAccessor(accessor, client, remoteNodeAccessors);
        }
    }

    private void addLocalNodeAccessor(String accessor, ComponentReference client, Map<ComponentReference, List<String>> result) {
        if (!result.containsKey(client)) {
            result.put(client, new ArrayList());
        }
        result.get(client).add(accessor);
    }

    private void addRemoteNodeAccessor(String accessor, ComponentReference client, Map<FabricAddress, List<String>> result) {
        FabricAddress nodeAddress = client.getAddress().getNodeAddress();
        if (!result.containsKey(nodeAddress)) {
            result.put(nodeAddress, new ArrayList());
        }
        result.get(nodeAddress).add(accessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLocalAccessors(Map<ComponentReference, List<String>> accessors) {
        Object object = this.accessorsMutex;
        synchronized (object) {
            for (Map.Entry<ComponentReference, List<String>> entry : accessors.entrySet()) {
                this.closeLocalAccessors((ComponentReferenceImpl)entry.getKey(), entry.getValue());
            }
        }
    }

    private void closeRemoteClientAccessors(Map<ComponentReference, List<String>> accessors) {
        for (Map.Entry<ComponentReference, List<String>> entry : accessors.entrySet()) {
            try {
                ClientExchangeConnection connection = this.getClient(entry.getKey().getAddress());
                if (connection == null) continue;
                connection.raiseInternalRequest(56, entry.getValue());
            }
            catch (Exception exception) {
                this.logInternalRequestError(exception, 56);
            }
        }
    }

    private void closeRemoteNodeAccessors(Map<FabricAddress, List<String>> accessors) {
        for (Map.Entry<FabricAddress, List<String>> entry : accessors.entrySet()) {
            try {
                this.raiseInternalRequest(entry.getKey(), 56, entry.getValue());
            }
            catch (Exception exception) {
                this.logInternalRequestError(exception, 56);
            }
        }
    }

    private FabricExchangeAdvisory onExchangeUpdate(FabricExchangeState state, String message, String detailedMessage, boolean withFullInfo) {
        RowSet summaryInfo = null;
        RowSet fullInfo = null;
        RowSet jvmStats = null;
        if (withFullInfo) {
            try {
                ArrayList<TokenMonitorResult> results = new ArrayList<TokenMonitorResult>();
                List<ConfigurationParameter> summaryParameters = this.getDynamicParametersSummary(results);
                summaryInfo = ShowExchangeStateOperation.addParameters(summaryParameters);
                fullInfo = new RowSet(ShowExchangeStateOperation.createResultDescriptor());
                jvmStats = new RowSet(ShowStatsOperation.createResultDescriptor());
                boolean firstIteration = true;
                for (TokenMonitorResult result : results) {
                    ShowExchangeStateOperation.addParameters(result.parameters, fullInfo, !firstIteration);
                    jvmStats.addAll(result.jvmStats);
                    firstIteration = false;
                }
            }
            catch (Exception exception) {
                this.logException(exception, true, "Obtaining global Exchange state failed.");
            }
        }
        FabricExchangeAdvisory result = new FabricExchangeAdvisory(this.getNodeName(), state, message, detailedMessage, summaryInfo, fullInfo, jvmStats);
        this.onExchangeUpdate(result);
        return result;
    }

    private void onExchangeUpdate(FabricExchangeAdvisory advisory) {
        this.executeInSystemThreadPool(() -> {
            try {
                this.coalesce(advisory);
                this.raiseEvent(advisory, this.node.getFabricAddress(), EventScope.GLOBAL);
            }
            catch (Throwable exception) {
                this.logException(exception, true);
                this.logError("Raising advisory '" + advisory.getEventId() + "' failed.");
            }
        });
    }

    List<Pair<String, String>> getTokenRing() {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        TreeSet<FabricAddress> addresses = new TreeSet<FabricAddress>(this.getNodeAddresses());
        if (!addresses.isEmpty()) {
            String sourceNode;
            addresses.add(this.getNodeAddress());
            Iterator iter = addresses.iterator();
            String firstNode = sourceNode = this.getFabricNodeName((FabricAddress)iter.next());
            String destinationNode = "N/A";
            while (iter.hasNext()) {
                destinationNode = this.getFabricNodeName((FabricAddress)iter.next());
                result.add(new Pair<String, String>(sourceNode, destinationNode));
                sourceNode = destinationNode;
            }
            result.add(new Pair<String, String>(sourceNode, firstNode));
        }
        return result;
    }

    Object invokeRoutedContainerRequest(String nodeName, byte[] data, long timeout) throws Exception {
        return this.raiseInternalRequest(nodeName, 147, (Object)new RoutedContainerRequestData(data, timeout), timeout);
    }

    Map<String, Object> broadcastRoutedContainerRequest(byte[] data, long timeout, boolean mnodesOnly) throws Exception {
        Map<FabricAddress, Object> acks = this.doBroadcastWithAckToNodesUser(147, new RoutedContainerRequestData(data, timeout), timeout, mnodesOnly);
        return acks != null ? this.convertBroadcastResponse(acks) : null;
    }

    void invokeApiKeyReplicationRequest(AbstractApiKeyManager.ApiKeyReplicationRequestData data) throws Exception {
        this.broadcastToNodes(148, data, false);
    }

    void invokeDropBoxTableSynchronizationEvent(DropBoxTableManager.DropBoxTableSynchronizationData data) throws Exception {
        this.broadcastToNodes(154, data, false);
    }

    Object invokeDropBoxTableSynchronizationRequest(FabricNode node, DropBoxTableManager.DropBoxTableSynchronizationData data) throws Exception {
        return this.raiseInternalRequest(node.getName(), 155, (Object)data);
    }

    List<DropBoxTable.DropBoxTableItem> invokeDropBoxItemJoinToMNodeRequest(FabricNode mnode, DropBoxTableManager.DropBoxTableSynchronizationData data) throws Exception {
        return (List)this.raiseInternalRequest(mnode.getName(), 58, (Object)data);
    }

    @Override
    public void handle(OutOfMemoryError error) {
        this.logException(error, true);
        this.outOfMemory = true;
        this.logError("OutOfMemoryError caught. Scavenger will be stopped.");
        this.scavenger.stop();
    }

    private String getTimezone() {
        TimeZone tz = this.context.getNodeTimezone();
        return tz != null ? tz.getID() : TimeZone.getDefault().getID();
    }

    void setTimezone(AbstractDataspaceManager manager, TimeZone timezone) throws Exception {
        this.sysplexSynchronizer.invoke(SET_TIMEZONE_METHOD, manager, timezone);
    }

    private void doSetTimezone(AbstractDataspaceManager manager, TimeZone timezone) throws DataspaceManagerException {
        manager.doSetTimezone(timezone);
        this.broadcastWithAckToNodes(150, timezone.getID());
    }

    private void doSetTimezone(String timezone) {
        ((AbstractDataspaceManager)this.context.getDataspaceManager()).doSetTimezone(TimeZone.getTimeZone(timezone));
    }

    @Override
    boolean isClustered() {
        return this.context.isClustered();
    }

    List<String> listClusters() {
        return this.clusterNumbers != null ? new ArrayList<String>(this.clusterNumbers.keySet()) : null;
    }

    private byte getClusterNumber(String clusterName) {
        return this.clusterNumbers != null && clusterName != null ? this.clusterNumbers.get(clusterName) : (byte)-1;
    }

    private byte getClusterNumber(FabricNode fabricNode) {
        return this.getClusterNumber(fabricNode.getClusterName());
    }

    private void synchronizeClusterNumbers(List<String> nodeClusters) throws ExchangeException {
        if (nodeClusters != null) {
            for (String clusterName : nodeClusters) {
                if (this.clusterNumbers.containsKey(clusterName)) continue;
                this.clusterNumbers.put(clusterName, this.acquireClusterNumber());
            }
        }
    }

    private byte acquireClusterNumber() throws ExchangeException {
        try {
            return this.clusterNumberAllocator != null ? this.clusterNumberAllocator.getNumber() : (byte)-1;
        }
        catch (NumberAllocatorException exception) {
            throw new ExchangeException("Allocation of cluster number failed.", (Throwable)exception);
        }
    }

    private void addFabricNodeToCluster(FabricNode fabricNode, boolean updateNumbers) {
        if (this.isClustered()) {
            if (updateNumbers) {
                this.clusterNumbers.put(fabricNode.getClusterName(), fabricNode.getFabricAddress().getClusterNumber());
            }
            this.clusterNodes.computeIfAbsent(fabricNode.getClusterName(), k -> new HashSet()).add(fabricNode.getName());
        }
    }

    private void removeFabricNodeFromCluster(FabricNode fabricNode) {
        Set<String> nodes;
        if (this.isClustered() && (nodes = this.clusterNodes.get(fabricNode.getClusterName())) != null) {
            nodes.remove(fabricNode.getName());
            if (nodes.isEmpty()) {
                this.clusterNodes.remove(fabricNode.getClusterName());
                this.clusterNumbers.remove(fabricNode.getClusterName());
                this.clusterNumberAllocator.releaseNumber(fabricNode.getFabricAddress().getClusterNumber());
            }
        }
    }

    private void synchronizeGlobalCounter(long newValue) {
        if (newValue > this.globalCounter) {
            this.doUpdateGlobalCounter(newValue);
        }
    }

    @Override
    public long nextGlobalCount() {
        return (Long)this.sysplexSynchronizer.invokeWithoutException(NEXT_GLOBAL_COUNT, new Object[0]);
    }

    protected long nextGlobalCountNotSync() {
        return this.doNextGlobalCount();
    }

    private long doNextGlobalCount() {
        return this.updateGlobalCounter(this.globalCounter + 1L);
    }

    @Override
    public long showGlobalCounter() {
        return (Long)this.sysplexSynchronizer.invokeWithoutException(SHOW_GLOBAL_COUNTER, new Object[0]);
    }

    private long doShowGlobalCounter() {
        return this.globalCounter;
    }

    @Override
    public long resetGlobalCounter() throws FabricExchangeException {
        if (this.inSysplex() && !this.context.securityContext.getUser().isAdministrator()) {
            throw new FabricExchangeException(6092, "User '" + this.context.getUserName() + "' has insufficient rights to reset the global counter.");
        }
        return this.resetGlobalCounterNoCheck();
    }

    long resetGlobalCounterNoCheck() {
        return (Long)this.sysplexSynchronizer.invokeWithoutException(RESET_GLOBAL_COUNTER, new Object[0]);
    }

    private long doResetGlobalCounter() {
        return this.updateGlobalCounter(0L);
    }

    private long updateGlobalCounter(long newValue) {
        this.doUpdateGlobalCounter(newValue);
        this.broadcastWithAckToNodes(153, this.globalCounter);
        return this.globalCounter;
    }

    private void doUpdateGlobalCounter(long newValue) {
        this.globalCounter = newValue;
        this.context.saveExchange();
    }

    private void processClientThreshold(String protocol, int currentValue) {
        if (!this.clientThresholdProcessors.isEmpty()) {
            this.doProcessClientThreshold("*", currentValue);
            this.doProcessClientThreshold(protocol, currentValue);
        }
    }

    private void doProcessClientThreshold(String protocol, int currentValue) {
        ClientThresholdProcessor processor = this.clientThresholdProcessors.get(protocol);
        if (processor != null) {
            processor.process(currentValue);
        }
    }

    public static synchronized void printDebug(String message) {
        System.out.println("{" + DATE_FORMAT.format(new Date(System.currentTimeMillis())) + "} {" + String.valueOf(Thread.currentThread()) + "(" + Thread.currentThread().getId() + ")} " + message);
    }

    private static synchronized void pressAnyKey(String where) throws Exception {
        System.out.print("Press any key in '" + where + "':");
        System.in.read();
        RuntimeExchange.printDebug("Key pressed.");
    }

    FabricAddress getTokenDestination() {
        return this.sysplexSynchronizer.tokenDestination;
    }

    void setTokenDestination(FabricAddress tokenDestination) {
        this.sysplexSynchronizer.tokenDestination = tokenDestination;
    }

    static {
        RuntimeExchange.addInternalEventName(101, "Join");
        RuntimeExchange.addInternalEventName(102, "JoinConfirm");
        RuntimeExchange.addInternalEventName(103, "SyncLevel1");
        RuntimeExchange.addInternalEventName(104, "SyncLevel2");
        RuntimeExchange.addInternalEventName(105, "SyncLevel3");
        RuntimeExchange.addInternalEventName(106, "SyncLevel1Backward");
        RuntimeExchange.addInternalEventName(107, "SyncLevel2Backward");
        RuntimeExchange.addInternalEventName(108, "SyncForward");
        RuntimeExchange.addInternalEventName(109, "SyncLevel12Forward");
        RuntimeExchange.addInternalEventName(5, "NodeDisconnect");
        RuntimeExchange.addInternalEventName(111, "NodeForcedDisconnect");
        RuntimeExchange.addInternalEventName(112, "NodeForcedDisconnectConfirm");
        RuntimeExchange.addInternalEventName(110, "NodeDisconnectConfirm");
        RuntimeExchange.addInternalEventName(113, "EstablishConnection");
        RuntimeExchange.addInternalEventName(114, "ReleaseConnection");
        RuntimeExchange.addInternalEventName(115, "AddRoutingLink");
        RuntimeExchange.addInternalEventName(116, "RemoveRoutingLink");
        RuntimeExchange.addInternalEventName(117, "UpdateGlobalVariables");
        RuntimeExchange.addInternalEventName(118, "UpdateExclusionList");
        RuntimeExchange.addInternalEventName(119, "UpdateSecurity");
        RuntimeExchange.addInternalEventName(120, "SetAnonymousRegistration");
        RuntimeExchange.addInternalEventName(121, "AddExtensionJar");
        RuntimeExchange.addInternalEventName(122, "RemoveExtensionJar");
        RuntimeExchange.addInternalEventName(123, "AddPackage");
        RuntimeExchange.addInternalEventName(124, "RemovePackage");
        RuntimeExchange.addInternalEventName(125, "LoadPackage");
        RuntimeExchange.addInternalEventName(126, "UnloadPackage");
        RuntimeExchange.addInternalEventName(127, "AddSemanticType");
        RuntimeExchange.addInternalEventName(128, "RemoveSemanticType");
        RuntimeExchange.addInternalEventName(129, "AddEventPrototype");
        RuntimeExchange.addInternalEventName(130, "RemoveEventPrototype");
        RuntimeExchange.addInternalEventName(131, "GetManagementNodeObject");
        RuntimeExchange.addInternalEventName(132, "IsOwnerActive");
        RuntimeExchange.addInternalEventName(133, "GetOwnerComponents");
        RuntimeExchange.addInternalEventName(134, "Survey");
        RuntimeExchange.addInternalEventName(135, "TokenRestart");
        RuntimeExchange.addInternalEventName(136, "TokenMonitor");
        RuntimeExchange.addInternalEventName(137, "AddTimeWindow");
        RuntimeExchange.addInternalEventName(138, "RemoveTimeWindow");
        RuntimeExchange.addInternalEventName(139, "ChangeTimeWindow");
        RuntimeExchange.addInternalEventName(140, "SchedulerOperation");
        RuntimeExchange.addInternalEventName(141, "UpdateDirectoryTable");
        RuntimeExchange.addInternalEventName(142, "StatsMonitorOperation");
        RuntimeExchange.addInternalEventName(143, "SlangOperation");
        RuntimeExchange.addInternalEventName(144, "SetAdvancedParameter");
        RuntimeExchange.addInternalEventName(145, "NodeDetach");
        RuntimeExchange.addInternalEventName(146, "ContainerRequest");
        RuntimeExchange.addInternalEventName(147, "RoutedContainerRequest");
        RuntimeExchange.addInternalEventName(148, "ApiKeyReplication");
        RuntimeExchange.addInternalEventName(149, "CheckEventFlows");
        RuntimeExchange.addInternalEventName(150, "SetTimezone");
        RuntimeExchange.addInternalEventName(151, "GetSemanticTypeDependencies");
        RuntimeExchange.addInternalEventName(152, "CheckSemanticTypeDependencies");
        RuntimeExchange.addInternalEventName(153, "UpdateGlobalCounter");
        RuntimeExchange.addInternalEventName(154, "DropBoxTableSynchronization");
        RuntimeExchange.addInternalEventName(155, "DropBoxTableSynchronizationRequest");
        RuntimeExchange.addInternalEventName(156, "ValidatePackage");
        RuntimeExchange.addInternalEventName(157, "GetExclusionList");
        RuntimeExchange.addInternalEventName(158, "UpdatePackage");
        RuntimeExchange.addInternalEventName(159, "SetAnonymousUser");
        RuntimeExchange.addInternalEventName(160, "AddJar");
        RuntimeExchange.addInternalEventName(161, "RemoveJar");
        try {
            JOIN_SYSPLEX_METHOD = RuntimeExchange.getMethod("doJoinSysplex", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            ON_JOIN_REQUEST_METHOD = RuntimeExchange.getMethod("onJoinRequest", JoinData.class, NodeExchangeConnection.class);
            DETACH_FROM_SYSPLEX_METHOD = RuntimeExchange.getMethod("doDetachFromSysplex", Boolean.TYPE, Boolean.TYPE);
            DETACH_NODE_METHOD = RuntimeExchange.getMethod("doDetachNode", FabricNode.class, Boolean.TYPE, Boolean.TYPE);
            UNLINK_NODE_METHOD = RuntimeExchange.getMethod("doUnlinkNode", FabricNode.class, Boolean.TYPE);
            EXECUTE_SCAVENGER_METHOD = RuntimeExchange.getMethod("doExecuteScavenger", new Class[0]);
            ADD_COMPONENT_METHOD = RuntimeExchange.getMethod("doAddComponent", AbstractFabricComponent.class, ComponentModel.class);
            RE_ADD_COMPONENT_METHOD = RuntimeExchange.getMethod("doReAddComponent", AbstractFabricComponent.class, AbstractExchange.ReAddComponentData.class, ClientExchangeConnection.class);
            REMOVE_COMPONENT_METHOD = RuntimeExchange.getMethod("doRemoveComponent", AbstractFabricComponent.class);
            ADD_CONSUMER_METHOD = RuntimeExchange.getMethod("doAddConsumer", EndpointReferenceImpl.class, NamedObject.class, Boolean.TYPE, Boolean.TYPE, RuntimeFabricGroup.class);
            REMOVE_CONSUMER_METHOD = RuntimeExchange.getMethod("doRemoveConsumer", EndpointReferenceImpl.class, NamedObject.class, Boolean.TYPE, RuntimeFabricGroup.class);
            CHANGE_COMPONENT_METHOD = RuntimeExchange.getMethod("doChangeComponent", ComponentReferenceImpl.class, ModeratorAdvisoryType.class, Object.class, Boolean.TYPE);
            CHANGE_CONSUMER_METHOD = RuntimeExchange.getMethod("doChangeConsumer", FabricNode.class, AbstractExchange.ChangeConsumerData.class, Boolean.TYPE);
            ADD_EVENT_CACHE_METHOD = RuntimeExchange.getMethod("doAddEventCache", EventCacheReferenceImpl.class, Boolean.TYPE);
            REMOVE_EVENT_CACHE_METHOD = RuntimeExchange.getMethod("doRemoveEventCache", String.class, FabricAddress.class);
            CHANGE_EVENT_CACHE_METHOD = RuntimeExchange.getMethod("doChangeEventCache", FabricNode.class, EventCacheReferenceImpl.class, FabricAddress.class, Boolean.TYPE);
            ADD_DATA_CONSTRAINT_METHOD = RuntimeExchange.getMethod("doAddDataConstraint", AbstractExchange.DataConstraintReferenceCreator.class);
            REMOVE_DATA_CONSTRAINT_METHOD = RuntimeExchange.getMethod("doRemoveDataConstraint", String.class, ExchangeRole.class, FabricAddress.class);
            CHANGE_DATA_CONSTRAINT_METHOD = RuntimeExchange.getMethod("doChangeDataConstraint", AbstractFabricDataConstraint.Updater.class, FabricAddress.class, Boolean.TYPE);
            ADD_REPLICATION_ENTITY_METHOD = RuntimeExchange.getMethod("doAddReplicationEntity", ReplicationEntityReferenceImpl.class);
            REMOVE_REPLICATION_ENTITY_METHOD = RuntimeExchange.getMethod("doRemoveReplicationEntity", ReplicationEntityReferenceImpl.class);
            CHANGE_REPLICATION_ENTITY_METHOD = RuntimeExchange.getMethod("doChangeReplicationEntity", ReplicationEntityReferenceImpl.class);
            ADD_TIME_WINDOW_METHOD = RuntimeExchange.getMethod("doAddTimeWindow", AbstractSchedulerImpl.class, TimeWindow.class);
            REMOVE_TIME_WINDOW_METHOD = RuntimeExchange.getMethod("doRemoveTimeWindow", AbstractSchedulerImpl.class, String.class);
            CHANGE_TIME_WINDOW_METHOD = RuntimeExchange.getMethod("doChangeTimeWindow", AbstractSchedulerImpl.class, TimeWindow.class);
            ON_START_ACCEPTOR_METHOD = RuntimeExchange.getMethod("doOnStartAcceptor", LinkAddress.class, Boolean.TYPE);
            ON_STOP_ACCEPTOR_METHOD = RuntimeExchange.getMethod("doOnStopAcceptor", LinkAddress.class, Boolean.TYPE);
            ADD_EXTENSION_JAR_METHOD = RuntimeExchange.getMethod("doAddExtensionJar", RuntimeRepositoryAccessorImpl.class, String.class, File.class);
            REMOVE_EXTENSION_JAR_METHOD = RuntimeExchange.getMethod("doRemoveExtensionJar", RuntimeRepositoryAccessorImpl.class, String.class, String.class, Boolean.TYPE);
            ADD_JAR_METHOD = RuntimeExchange.getMethod("doAddJar", RuntimeRepositoryAccessorImpl.class, String.class, File.class);
            REMOVE_JAR_METHOD = RuntimeExchange.getMethod("doRemoveJar", RuntimeRepositoryAccessorImpl.class, String.class, String.class);
            ADD_PACKAGE_METHOD = RuntimeExchange.getMethod("doAddPackage", AbstractPackageManifestManager.class, Integer.TYPE, PackageDescriptor.class);
            UPDATE_PACKAGE_METHOD = RuntimeExchange.getMethod("doUpdatePackage", AbstractPackageManifestManager.class, Integer.class, PackageDescriptor.class, Package.class);
            SET_PACKAGE_SCOPE_METHOD = RuntimeExchange.getMethod("doSetPackageScope", AbstractPackageManifestManager.class, String.class, Boolean.TYPE);
            REMOVE_PACKAGE_METHOD = RuntimeExchange.getMethod("doRemovePackage", AbstractPackageManifestManager.class, String.class);
            LOAD_PACKAGE_METHOD = RuntimeExchange.getMethod("doLoadPackage", AbstractPackageManifestManager.class, String.class, Boolean.TYPE);
            UNLOAD_PACKAGE_METHOD = RuntimeExchange.getMethod("doUnloadPackage", AbstractPackageManifestManager.class, String.class, Boolean.TYPE);
            VALIDATE_PACKAGE_METHOD = RuntimeExchange.getMethod("doValidatePackage", AbstractPackageManifestManager.class, String.class);
            ADD_SEMANTIC_TYPE_METHOD = RuntimeExchange.getMethod("doAddSemanticType", RuntimeSemanticTypeFactory.class, SemanticType.class, Boolean.TYPE);
            REMOVE_SEMANTIC_TYPE_METHOD = RuntimeExchange.getMethod("doRemoveSemanticType", RuntimeSemanticTypeFactory.class, String.class, Boolean.TYPE);
            ADD_EVENT_PROTOTYPE_METHOD = RuntimeExchange.getMethod("doAddEventPrototype", RuntimeDatagramPrototypeFactory.class, IAbstractDatagramFactory.class, Prototype.class, String.class, ImmutableEventDatagram.class);
            REMOVE_EVENT_PROTOTYPE_METHOD = RuntimeExchange.getMethod("doRemoveEventPrototype", RuntimeDatagramPrototypeFactory.class, IAbstractDatagramFactory.class, String.class, Boolean.TYPE);
            UPDATE_GLOBAL_VARIABLES_METHOD = RuntimeExchange.getMethod("doUpdateGlobalVariables", String.class, Object[].class);
            UPDATE_DIRECTORY_TABLE_METHOD = RuntimeExchange.getMethod("doUpdateDirectoryTable", AbstractDirectoryTable.class, Method.class, Object[].class);
            UPDATE_SECURITY_METHOD1 = RuntimeExchange.getMethod("doUpdateSecurity", RuntimeSecurityManagerProxy.class, String.class, String.class, Object[].class);
            UPDATE_SECURITY_METHOD2 = RuntimeExchange.getMethod("doUpdateSecurity", RuntimeSecurityManagerProxy.class, String.class, String.class, Class[].class, Object[].class);
            UPDATE_SECURITY_METHOD3 = RuntimeExchange.getMethod("doUpdateSecurity", RuntimeSecurityManagerProxy.class, String.class, Object[].class, String.class, Object[].class);
            SET_ANONYMOUS_REGISTRATION_METHOD = RuntimeExchange.getMethod("doSetAnonymousRegistration", Boolean.TYPE);
            SET_ANONYMOUS_USER_METHOD = RuntimeExchange.getMethod("doSetAnonymousUser", UserState.class);
            SET_ADVANCED_PARAMETER_METHOD = RuntimeExchange.getMethod("doSetAdvancedParameter", String.class, String.class);
            CREATE_GROUP_METHOD = RuntimeExchange.getMethod("doCreateGroup", String.class, String.class, FabricAddress.class);
            DROP_GROUP_METHOD = RuntimeExchange.getMethod("doDropGroup", String.class, FabricAddress.class);
            ADD_GROUP_MEMBER_METHOD = RuntimeExchange.getMethod("doAddGroupMember", String.class, ComponentReferenceImpl.class, Boolean.TYPE);
            REMOVE_GROUP_MEMBER_METHOD = RuntimeExchange.getMethod("doRemoveGroupMember", String.class, ComponentReferenceImpl.class, Boolean.TYPE);
            SET_TIMEZONE_METHOD = RuntimeExchange.getMethod("doSetTimezone", AbstractDataspaceManager.class, TimeZone.class);
            NEXT_GLOBAL_COUNT = RuntimeExchange.getMethod("doNextGlobalCount", new Class[0]);
            SHOW_GLOBAL_COUNTER = RuntimeExchange.getMethod("doShowGlobalCounter", new Class[0]);
            RESET_GLOBAL_COUNTER = RuntimeExchange.getMethod("doResetGlobalCounter", new Class[0]);
        }
        catch (Throwable exception) {
            throw new RuntimeException("RuntimeExchange initialization failed.", exception);
        }
        PSEUDO_EVENT_BYTES = new byte[0];
        TIME_FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm:ss.SSS");
        PROTOCOL_VERSION = new AbstractExchange.VersionData(3, 8, 32, 27);
        DATE_FORMAT = new SimpleDateFormat("kk:mm:ss.SSS");
    }

    static class Scavenger {
        int reconnectAttempts = -1;
        Long reconnectInterval = 30L;
        transient Map<String, List<DiscoveryLink>> primaryLinks;
        transient Set<String> absentNodes;
        transient Set<String> unconnectedNodes;
        transient Map<String, List<DiscoveryLink>> backupLinks;
        transient Set<String> backupAbsentNodes;
        private transient RuntimeExchange exchange;
        private transient Worker worker;
        private transient int iAttempt;

        Scavenger() {
        }

        void init(RuntimeExchange exchange) {
            this.exchange = exchange;
            this.absentNodes = new HashSet<String>();
            this.unconnectedNodes = new HashSet<String>();
            this.backupAbsentNodes = new HashSet<String>();
        }

        synchronized void setReconnectAttempts(int reconnectAttempts) {
            this.reconnectAttempts = reconnectAttempts;
            if (!this.hasRemainingAttempts()) {
                this.stop();
            }
        }

        boolean hasRemainingAttempts() {
            return this.reconnectAttempts == -1 || this.iAttempt < this.reconnectAttempts;
        }

        int getRemainingAttempts() {
            return this.reconnectAttempts == -1 ? -1 : this.reconnectAttempts - this.iAttempt;
        }

        synchronized void setReconnectInterval(long reconnectInterval) {
            this.reconnectInterval = reconnectInterval;
            if (this.worker != null) {
                try {
                    this.worker.setTimeout(reconnectInterval * 1000L);
                }
                catch (FabricException fabricException) {
                    // empty catch block
                }
            }
        }

        synchronized String start() {
            if (this.exchange.outOfMemory) {
                String message = "OutOfMemoryError was caught earlier. Scavenger will not be started.";
                this.exchange.logWarning("OutOfMemoryError was caught earlier. Scavenger will not be started.");
                return message;
            }
            if (this.reconnectAttempts != 0 && this.worker == null) {
                this.exchange.logDebug("Initiating Scavenger process...");
                this.iAttempt = 0;
                try {
                    this.worker = new Worker();
                }
                catch (FabricException fabricException) {
                    // empty catch block
                }
                this.worker.start();
                this.exchange.logInfo("Scavenger process initiated.");
            }
            return null;
        }

        synchronized void stop() {
            if (this.worker != null) {
                this.exchange.logInfo("Scavenger process completed.");
                this.worker.stop();
                this.worker = null;
            }
        }

        synchronized boolean isRunning() {
            return this.worker != null;
        }

        void execute() {
            this.calculateDiscoveryLinks();
            if (this.findMissingLinks()) {
                this.exchange.logInfo("Scavenger is running (attempt #" + ++this.iAttempt + ")...");
                if (!this.unconnectedNodes.isEmpty()) {
                    for (String nodeName : this.unconnectedNodes) {
                        this.exchange.connectToNode(nodeName);
                    }
                }
                if (!this.absentNodes.isEmpty()) {
                    this.exchange.doJoinSysplex(true, false, false);
                }
                if (!this.findMissingLinks() || !this.hasRemainingAttempts()) {
                    this.stop();
                }
            } else {
                this.stop();
            }
        }

        void calculateDiscoveryLinks() {
            this.primaryLinks = new HashMap<String, List<DiscoveryLink>>();
            this.backupLinks = new HashMap<String, List<DiscoveryLink>>();
            List<LinkAddress> tlpAcceptors = this.exchange.getTLPAcceptors();
            for (DiscoveryLink link : this.exchange.context.discoveryModule.discover()) {
                Scavenger.addLink(link, link.isBackup() ? this.backupLinks : this.primaryLinks, tlpAcceptors);
            }
        }

        private static void addLink(DiscoveryLink link, Map<String, List<DiscoveryLink>> links, List<LinkAddress> tlpAcceptors) {
            if (!links.containsKey(link.getNodeName())) {
                links.put(link.getNodeName(), new ArrayList());
            }
            if (!tlpAcceptors.contains(link.getLinkAddress())) {
                links.get(link.getNodeName()).add(link);
            }
        }

        boolean findMissingLinks() {
            this.absentNodes.clear();
            this.unconnectedNodes.clear();
            for (String nodeName2 : this.primaryLinks.keySet()) {
                FabricNode fabricNode = this.exchange.getFabricNode(nodeName2);
                if (fabricNode == null) {
                    this.absentNodes.add(nodeName2);
                    continue;
                }
                if (this.exchange.nodeConnections.containsKey(fabricNode.getFabricAddress())) continue;
                this.unconnectedNodes.add(nodeName2);
            }
            this.backupAbsentNodes.clear();
            this.backupAbsentNodes.addAll(this.backupLinks.keySet().stream().filter(nodeName -> this.exchange.getFabricNode((String)nodeName) == null).collect(Collectors.toList()));
            return !this.absentNodes.isEmpty() || !this.unconnectedNodes.isEmpty();
        }

        private boolean hasMissingLinks() {
            return !this.absentNodes.isEmpty() || !this.unconnectedNodes.isEmpty();
        }

        private class Worker
        extends MonitorWorker {
            Worker() throws FabricException {
                super("EXCH:Scavenger.Thread", "Performs recovery of lost connections with the sysplex.", Scavenger.this.reconnectInterval * 1000L);
            }

            @Override
            protected void doExecute() throws FabricException {
                Scavenger.this.exchange.executeScavenger();
            }
        }
    }

    class ClientNetworkEventDispatcher
    extends NetworkEventDispatcher {
        private Map<FabricAddress, AbstractExchange.ClientRequestConsumer> requestConsumers = new ConcurrentHashMap<FabricAddress, AbstractExchange.ClientRequestConsumer>();

        ClientNetworkEventDispatcher(RuntimeExchange this$0) {
        }

        void addConsumer(EndpointReferenceImpl consumer) {
            if (consumer instanceof NetworkExchangeConsumer) {
                this.addConsumer((NetworkExchangeConsumer)((Object)consumer));
            } else if (consumer instanceof AbstractExchange.ClientRequestConsumer) {
                this.addRequestConsumer(consumer.getAddress(), (AbstractExchange.ClientRequestConsumer)consumer);
            }
        }

        void removeConsumer(EndpointReferenceImpl consumer) {
            if (consumer instanceof NetworkExchangeConsumer) {
                this.removeConsumer((NetworkExchangeConsumer)((Object)consumer));
            } else if (consumer instanceof AbstractExchange.ClientRequestConsumer) {
                this.removeRequestConsumer(consumer.getAddress());
            }
        }

        void addRequestConsumer(FabricAddress address, AbstractExchange.ClientRequestConsumer consumer) {
            this.requestConsumers.put(address, consumer);
        }

        void removeRequestConsumer(FabricAddress address) {
            this.requestConsumers.remove(address);
        }

        AbstractExchange.ClientRequestConsumer getRequestConsumer(FabricAddress address) {
            return this.requestConsumers.get(address);
        }

        @Override
        void clear() {
            super.clear();
            this.requestConsumers.clear();
        }

        void raiseEvent(ImmutableEventDatagram event, FabricAddress componentAddress, ByteBuffer eventBuffer) throws FabricException, FabricEventSourceException, FabricEventException {
            Collection<NetworkExchangeConsumer> consumers = this.getConsumers(event);
            if (consumers != null) {
                this.publish(event, consumers, componentAddress, false, eventBuffer);
            }
        }

        void raiseNetworkEvent(ImmutableEventDatagram event, FabricAddress componentAddress, ByteBuffer eventBuffer) throws FabricException, FabricEventSourceException, FabricEventException {
            Collection<NetworkExchangeConsumer> consumers = this.getConsumers(event);
            if (consumers != null) {
                this.publish(event, consumers, componentAddress, true, eventBuffer);
            }
        }

        void publish(ImmutableEventDatagram event, Collection<NetworkExchangeConsumer> consumers, FabricAddress componentAddress, boolean fromNetwork, ByteBuffer eventBuffer) throws FabricException, FabricEventSourceException, FabricEventException {
            Map<FabricAddress, Boolean> destinations = this.getDestinations(consumers, event, componentAddress, fromNetwork);
            if (!destinations.isEmpty()) {
                Pair<Integer, byte[]> packetData = this.packEvent(0, event, eventBuffer);
                for (Map.Entry<FabricAddress, Boolean> entry : destinations.entrySet()) {
                    this.publishRemote(entry.getKey(), event, (Integer)packetData.first, (byte[])packetData.second, eventBuffer, entry.getValue());
                }
            }
        }

        Map<FabricAddress, Boolean> getDestinations(Collection<NetworkExchangeConsumer> consumers, ImmutableEventDatagram event, FabricAddress componentAddress, boolean fromNetwork) {
            HashMap<FabricAddress, Boolean> result = new HashMap<FabricAddress, Boolean>();
            consumers.stream().filter(consumer -> this.matches((NetworkExchangeConsumer)consumer, event, componentAddress, fromNetwork)).forEach(consumer -> {
                Boolean async = (Boolean)result.get(consumer.getComponentAddress());
                if (async == null || async.booleanValue()) {
                    result.put(consumer.getComponentAddress(), !(consumer instanceof DirectConsumerReferenceImpl));
                }
            });
            return result;
        }

        boolean matches(NetworkExchangeConsumer consumer, ImmutableEventDatagram event, FabricAddress componentAddress, boolean fromNetwork) {
            return (!fromNetwork || consumer.getEventScope() != EventScope.OBSERVABLE) && consumer.isSuitable(componentAddress) && consumer.matches(event);
        }

        @Override
        void pack(ByteBuffer packet, FabricAddress address, ImmutableEventDatagram event, byte[] eventBytes, ByteBuffer eventBuffer) {
            this.pack(packet, event, eventBytes, eventBuffer);
        }
    }

    class NetworkEventDispatcher
    extends AbstractExchange.NetworkConsumersStore {
        NetworkEventDispatcher() {
        }

        void raiseEvent(ImmutableEventDatagram event, EventScope eventScope, ByteBuffer eventBuffer) throws FabricException, FabricEventSourceException, FabricEventException {
            Collection<NetworkExchangeConsumer> consumers = this.getConsumersWithCheckCluster(event, eventScope);
            if (consumers != null) {
                this.publish(event, consumers, eventBuffer);
            }
        }

        void publish(ImmutableEventDatagram event, Collection<NetworkExchangeConsumer> consumers, ByteBuffer eventBuffer) throws FabricException, FabricEventSourceException, FabricEventException {
            Map<FabricAddress, Boolean> destinations = this.getDestinations(consumers, event);
            if (!destinations.isEmpty()) {
                Pair<Integer, byte[]> packetData = this.packEvent(6, event, eventBuffer);
                for (Map.Entry<FabricAddress, Boolean> entry : destinations.entrySet()) {
                    this.publishRemote(entry.getKey(), event, (Integer)packetData.first, (byte[])packetData.second, eventBuffer, entry.getValue());
                }
            }
        }

        Map<FabricAddress, Boolean> getDestinations(Collection<NetworkExchangeConsumer> consumers, ImmutableEventDatagram event) {
            HashMap<FabricAddress, Boolean> result = new HashMap<FabricAddress, Boolean>();
            consumers.stream().filter(consumer -> this.matches((NetworkExchangeConsumer)consumer, event)).forEach(consumer -> {
                Boolean async = (Boolean)result.get(consumer.getAddress().getNodeAddress());
                if (async == null) {
                    result.put(consumer.getAddress().getNodeAddress(), !(consumer instanceof DirectConsumerReferenceImpl));
                } else if (async.booleanValue() && consumer instanceof DirectConsumerReferenceImpl) {
                    result.put(consumer.getAddress().getNodeAddress(), false);
                }
            });
            return result;
        }

        boolean matches(NetworkExchangeConsumer consumer, ImmutableEventDatagram event) {
            return consumer.matches(event);
        }

        Pair<Integer, byte[]> packEvent(int packetSize, ImmutableEventDatagram event, ByteBuffer eventBuffer) throws ExchangeException {
            Pair<Integer, Object> result = new Pair<Integer, Object>(packetSize, null);
            if (eventBuffer == null) {
                result.second = this.serialize(event);
                Pair<Integer, Object> pair = result;
                pair.first = (Integer)pair.first + this.getPacketSize((byte[])result.second);
            } else {
                Pair<Integer, Object> pair = result;
                pair.first = (Integer)pair.first + this.getPacketSize(eventBuffer);
            }
            return result;
        }

        byte[] serialize(ImmutableEventDatagram event) throws ExchangeException {
            return RuntimeExchange.this.serialize(event);
        }

        int getPacketSize(byte[] eventBytes) {
            return 5 + eventBytes.length;
        }

        int getPacketSize(ByteBuffer eventBuffer) {
            return 1 + eventBuffer.remaining();
        }

        void publishRemote(FabricAddress address, ImmutableEventDatagram event, int packetSize, byte[] eventBytes, ByteBuffer eventBuffer, boolean async) throws FabricException, FabricEventSourceException, FabricEventException {
            ExchangeConnection connection = this.getConnection(address);
            if (async) {
                ByteBuffer packet = connection.networkConnection.createPacketForPublish(packetSize);
                this.pack(packet, address, event, eventBytes, eventBuffer);
                connection.networkConnection.publishDirect(packet);
            } else {
                Pair<Long, ByteBuffer> packet = connection.networkConnection.createPacketForPublishRequest(packetSize);
                this.pack((ByteBuffer)packet.second, address, event, eventBytes, eventBuffer);
                connection.publishRequestDirect(packet);
            }
        }

        private ExchangeConnection getConnection(FabricAddress address) throws ExchangeException {
            ExchangeConnection connection = RuntimeExchange.this.getConnection(address);
            connection.checkValidity();
            return connection;
        }

        void pack(ByteBuffer packet, FabricAddress address, ImmutableEventDatagram event, byte[] eventBytes, ByteBuffer eventBuffer) {
            packet.put(address.toBinary());
            this.pack(packet, event, eventBytes, eventBuffer);
        }

        void pack(ByteBuffer packet, ImmutableEventDatagram event, byte[] eventBytes, ByteBuffer eventBuffer) {
            this.putPacketHeader(event, packet);
            if (eventBytes != null) {
                packet.putInt(eventBytes.length).put(eventBytes).flip();
            } else {
                int position = eventBuffer.position();
                packet.put(eventBuffer).flip();
                eventBuffer.position(position);
            }
        }

        void putPacketHeader(ImmutableEventDatagram event, ByteBuffer result) {
            result.put((byte)0);
        }

        ImmutableEventDatagram raiseRequest(FabricAddress address, ImmutableEventDatagram request, long timeout, boolean skipCheck) throws FabricException, TimeoutException {
            if (skipCheck || this.existsRequestConsumer(address)) {
                return this.getConnection(address).raiseRequest(address, request, timeout);
            }
            throw new ExchangeException("Request consumer not found.");
        }

        private boolean existsRequestConsumer(FabricAddress address) {
            FabricNode fabricNode = RuntimeExchange.this.getFabricNode(address);
            return fabricNode != null && fabricNode.getRequestConsumer(address) != null;
        }
    }

    private static class RoutingTable {
        private RuntimeExchange exchange;
        private ArrayList<Node> nodes = new ArrayList();
        private Set<Link> links = new HashSet<Link>();
        private Map<FabricAddress, FabricAddress> destinations = new HashMap<FabricAddress, FabricAddress>();
        private int[][] distances;
        private Map<String, Path> paths;

        RoutingTable(RuntimeExchange exchange) {
            this.exchange = exchange;
            this.init();
        }

        private void init() {
            this.addNode(this.exchange.node);
        }

        Node addNode(FabricNode fabricNode) {
            return this.addNode(fabricNode.getName());
        }

        private Node addNode(String name) {
            Node result = new Node(name);
            if (!this.nodes.contains(result)) {
                this.nodes.add(result);
            }
            return result;
        }

        void removeNode(FabricNode fabricNode) {
            Node node = new Node(fabricNode);
            this.nodes.remove(node);
            this.links.removeIf(link -> link.contains(node));
            this.calculate();
        }

        private Node getNode(String name) {
            return this.getNode(name, false);
        }

        private Node getNode(String name, boolean addNew) {
            for (Node node : this.nodes) {
                if (!node.getName().equals(name)) continue;
                return node;
            }
            return addNew ? this.addNode(name) : null;
        }

        private List<Node> getNodes() {
            return new ArrayList<Node>(this.nodes);
        }

        Link addLink(FabricNode node1, FabricNode node2, ExchangeConnection connection) {
            Link result = this.makeLink(node1, node2, connection);
            this.doAddLink(result);
            return result;
        }

        void addLink(Link link) {
            this.doAddLink(this.makeLink(link));
        }

        private void doAddLink(Link link) {
            this.addLinkToList(link);
            this.calculate();
        }

        void addLinks(List<Link> otherLinks) {
            if (otherLinks != null && !otherLinks.isEmpty()) {
                for (Link link : otherLinks) {
                    this.addLinkToList(this.makeLink(link));
                }
                this.calculate();
            }
        }

        private void addLinkToList(Link link) {
            this.links.add(link);
            this.exchange.logDebug("Routing link '" + link.toString() + "' added.");
        }

        private Link makeLink(Link baseLink) {
            return this.doMakeLink(baseLink.node1.getName(), baseLink.node2.getName(), baseLink.distance, baseLink.address);
        }

        Link makeLink(FabricNode node1, FabricNode node2, ExchangeConnection connection) {
            Link result = this.doMakeLink(node1.getName(), node2.getName(), connection.latency, connection.getLinkAddress());
            ((NodeExchangeConnection)connection).bind(result);
            return result;
        }

        private Link doMakeLink(String node1Name, String node2Name, int latency, LinkAddress address) {
            return new Link(this.getNode(node1Name, true), this.getNode(node2Name, true), latency, address);
        }

        private Link removeLink(FabricNode node1, FabricNode node2) {
            Link result = new Link(this.getNode(node1.getName()), this.getNode(node2.getName()));
            this.removeLink(result);
            return result;
        }

        void removeLink(Link link) {
            this.removeLinkFromList(link);
            this.calculate();
        }

        private void removeLinkFromList(Link link) {
            this.links.remove(link);
            this.exchange.logDebug("Routing link '" + link.toString() + "' removed.");
        }

        private List<Link> getLinks() {
            return new ArrayList<Link>(this.links);
        }

        void reset() {
            this.nodes.clear();
            this.links.clear();
            this.destinations.clear();
            this.init();
        }

        public String toString() {
            return this.links.toString() + "\n : " + this.destinations.toString() + (String)(this.paths != null ? "\n : " + this.paths.toString() : "");
        }

        synchronized FabricAddress getDestination(FabricAddress nodeAddress) {
            return this.destinations.get(nodeAddress);
        }

        synchronized void calculate() {
            this.prepareCalculation();
            this.doCalculate();
        }

        private void prepareCalculation() {
            for (int i = 0; i < this.nodes.size(); ++i) {
                this.nodes.get((int)i).index = i;
            }
            this.distances = new int[this.nodes.size()][this.nodes.size()];
            for (Link link : this.links) {
                this.distances[link.node1.index][link.node2.index] = link.distance;
                this.distances[link.node2.index][link.node1.index] = link.distance;
            }
        }

        private void doCalculate() {
            this.paths = new HashMap<String, Path>();
            for (FabricNode fabricNode : this.exchange.getFabricNodes()) {
                this.paths.put(fabricNode.getName(), this.calculateShortestPath(this.getNode(this.exchange.getNodeName()), this.getNode(fabricNode.getName())));
            }
            this.destinations.clear();
            for (Map.Entry entry : this.paths.entrySet()) {
                FabricNode fabricNode = this.exchange.getFabricNode((String)entry.getKey());
                Path path = (Path)entry.getValue();
                if (path.nodes.size() < 2) {
                    this.exchange.logDebug("WARNING: Calculating routing path to node " + fabricNode.getFullPrintName() + " failed.");
                    continue;
                }
                this.destinations.put(fabricNode.getFabricAddress(), this.exchange.getFabricNode(path.nodes.get(1).getName()).getFabricAddress());
            }
        }

        private void calculateTokenRing() {
            int size = this.exchange.getFabricNodesNumber();
            if (size > 0) {
                ArrayList<Path> paths = new ArrayList<Path>(size);
                FabricNode previous = this.exchange.getNode();
                for (FabricAddress address : this.exchange.sysplexSynchronizer.tokenRing) {
                    FabricNode next = this.exchange.getFabricNode(address);
                    paths.add(this.calculateShortestPath(this.getNode(previous.getName()), this.getNode(next.getName())));
                    previous = next;
                }
                paths.add(this.calculateShortestPath(this.getNode(previous.getName()), this.getNode(this.exchange.getNodeName())));
                this.exchange.sysplexSynchronizer.setTokenRingPaths(paths);
            }
        }

        private Path calculateShortestPath(Node from, Node to) {
            PathNode[] path = new PathNode[this.nodes.size()];
            for (int i = 0; i < path.length; ++i) {
                path[i] = new PathNode();
            }
            path[to.index].distance = 0;
            path[to.index].isPermanent = true;
            int iWorkingNode = to.index;
            while (iWorkingNode != from.index) {
                this.processAdjacentNodes(path, iWorkingNode);
                int iNewWorkingNode = this.findNewWorkingNode(path, iWorkingNode);
                if (iNewWorkingNode == iWorkingNode) break;
                iWorkingNode = iNewWorkingNode;
                path[iWorkingNode].isPermanent = true;
            }
            long distance = 0L;
            ArrayList<Node> result = new ArrayList<Node>();
            if (iWorkingNode == from.index) {
                int iNode = from.index;
                while (iNode != -1) {
                    result.add(this.nodes.get(iNode));
                    iNode = path[iNode].iNextNode;
                }
                distance = path[from.index].distance;
            }
            return new Path(result, distance);
        }

        private void processAdjacentNodes(PathNode[] path, int iWorkingNode) {
            PathNode workingNode = path[iWorkingNode];
            for (int iNode = 0; iNode < this.nodes.size(); ++iNode) {
                int adjacentNodeDistance;
                PathNode adjacentNode = path[iNode];
                if (this.distances[iWorkingNode][iNode] == 0 || adjacentNode.isPermanent || (adjacentNodeDistance = workingNode.distance + this.distances[iWorkingNode][iNode]) >= adjacentNode.distance) continue;
                adjacentNode.iNextNode = iWorkingNode;
                adjacentNode.distance = adjacentNodeDistance;
            }
        }

        private int findNewWorkingNode(PathNode[] path, int iWorkingNode) {
            int minDistance = 0x3FFFFFFF;
            for (int iNode = 0; iNode < this.nodes.size(); ++iNode) {
                PathNode node = path[iNode];
                if (node.isPermanent || node.distance >= minDistance) continue;
                minDistance = node.distance;
                iWorkingNode = iNode;
            }
            return iWorkingNode;
        }

        static class Node
        extends AbstractNamedObject {
            int index = -1;

            private Node(String name) {
                super(name);
            }

            private Node(FabricNode fabricNode) {
                this(fabricNode.getName());
            }

            @Override
            public String toString() {
                return this.getName();
            }
        }

        static class Link
        implements Comparable<Link> {
            private Node node1;
            private Node node2;
            private int distance;
            private LinkAddress address;

            private Link(Node node1, Node node2) {
                this(node1, node2, -1, null);
            }

            private Link(Node node1, Node node2, int distance, LinkAddress address) {
                this.node1 = node1;
                this.node2 = node2;
                this.distance = distance;
                this.address = address;
            }

            private boolean contains(Node node) {
                return this.node1.equals(node) || this.node2.equals(node);
            }

            public boolean equals(Object other) {
                return this == other || other instanceof Link && this.node1.equals(((Link)other).node1) && this.node2.equals(((Link)other).node2);
            }

            public int hashCode() {
                return (this.node1.getName() + this.node2.getName()).hashCode();
            }

            @Override
            public int compareTo(Link other) {
                int result = this.node1.compareTo(other.node1);
                return result != 0 ? result : this.node2.compareTo(other.node2);
            }

            public String toString() {
                return this.node1.toString() + "---" + this.node2.toString() + "(" + this.distance + ")";
            }
        }

        private static class Path {
            List<Node> nodes = new ArrayList<Node>();
            long distance;

            Path(List<Node> nodes, long distance) {
                this.nodes = nodes;
                this.distance = distance;
            }

            void addNode(Node node) {
                this.nodes.add(node);
            }

            public String toString() {
                return this.nodes.toString() + " : " + this.distance;
            }
        }

        private static class PathNode {
            static final int INFINITY = 0x3FFFFFFF;
            int iNextNode = -1;
            int distance = 0x3FFFFFFF;
            boolean isPermanent = false;

            private PathNode() {
            }
        }
    }

    private class NodeBroadcastAckListener
    extends BroadcastAckListener {
        NodeBroadcastAckListener(int eventId) {
            super(eventId);
        }

        NodeBroadcastAckListener(int eventId, Object eventData, long timeout, int nRecipients) {
            super(eventId, eventData, timeout, nRecipients);
        }

        @Override
        void logReceived(FabricAddress sourceAddress, Object data) {
        }

        @Override
        String getRecipient(FabricAddress address) {
            return this.getNodeRecipient(address);
        }

        @Override
        Set<FabricAddress> getMissingRecipients() {
            return RuntimeExchange.this.getNodeAddresses();
        }

        @Override
        String logSuffix() {
            return "from nodes.";
        }
    }

    private abstract class BroadcastAckListener
    extends AbstractExchange.InternalEventListener<Object, ExchangeConnection> {
        Object eventData;
        long timeout;
        int nRecipients;
        int nReceivedAcks;
        Map<FabricAddress, Object> acks;
        Map<FabricAddress, Throwable> errorAcks;

        BroadcastAckListener(int eventId) {
            this(eventId, null, runtimeExchange.broadcastReplyTimeout, 0);
        }

        BroadcastAckListener(int eventId, Object eventData, long timeout, int nRecipients) {
            this.reset(eventId, eventData, timeout, nRecipients);
        }

        @Override
        synchronized void onEvent(FabricAddress sourceAddress, Object data, ExchangeConnection connection) throws FabricException {
            if (data instanceof Throwable) {
                this.errorAcks.put(sourceAddress, (Throwable)data);
            } else {
                this.acks.put(sourceAddress, data);
            }
            if (++this.nReceivedAcks >= this.nRecipients) {
                this.notify();
            }
        }

        synchronized void waitAck() throws InterruptedException {
            long endTime;
            long l = endTime = this.timeout > 0L ? System.currentTimeMillis() + this.timeout : Long.MAX_VALUE;
            while (this.nReceivedAcks < this.nRecipients && System.currentTimeMillis() < endTime) {
                this.wait(this.timeout > 0L ? this.timeout : 0L);
            }
        }

        synchronized void removeRecipient() {
            --this.nRecipients;
            if (this.nReceivedAcks >= this.nRecipients) {
                this.notify();
            }
        }

        synchronized void setRecipients(int nRecipients) {
            this.nRecipients = nRecipients;
        }

        private void reset(int eventId, Object eventData, long timeout, int nRecipients) {
            this.init(eventId, RuntimeExchange.this.getInternalEventName(eventId));
            this.eventData = eventData;
            this.timeout = timeout;
            this.nRecipients = nRecipients;
            this.nReceivedAcks = 0;
            this.acks = new HashMap<FabricAddress, Object>();
            this.errorAcks = new HashMap<FabricAddress, Throwable>();
        }

        synchronized void processAcks() {
            for (Map.Entry<FabricAddress, Throwable> entry : this.errorAcks.entrySet()) {
                RuntimeExchange.this.logError("Processing of internal event [" + this.eventName + "] failed in " + this.getRecipient(entry.getKey()) + "\nCause: " + Utils.formatException(entry.getValue(), "\n"));
            }
            this.acks.putAll(this.errorAcks);
            if (this.nReceivedAcks < this.nRecipients) {
                Set<FabricAddress> missingRecipients = this.getMissingRecipients();
                missingRecipients.removeAll(this.acks.keySet());
                missingRecipients.removeAll(this.errorAcks.keySet());
                for (FabricAddress address : missingRecipients) {
                    RuntimeExchange.this.logError("Acknowledgement on internal event [" + this.eventName + "] not received from " + this.getRecipient(address));
                    this.acks.put(address, MissingAck.OBJECT);
                }
                this.processMissingRecipients(missingRecipients);
            } else if (!RuntimeExchange.this.suppressLog(this.eventData)) {
                RuntimeExchange.this.logDebug("Acknowledgement on broadcast event [" + this.eventName + "] received " + this.logSuffix());
            }
        }

        abstract String getRecipient(FabricAddress var1);

        abstract Set<FabricAddress> getMissingRecipients();

        void processMissingRecipients(Set<FabricAddress> missingRecipients) {
        }

        @Override
        void logReceived(String recipient) {
            RuntimeExchange.this.logDebug("Acknowledgement on broadcast event [" + this.eventName + "] received" + (String)(recipient != null ? " from " + recipient : "."));
        }

        @Override
        void logReceived(FabricAddress sourceAddress, Object data) {
            this.doLogReceived(sourceAddress, data);
        }

        void doLogReceived(FabricAddress sourceAddress, Object data) {
            this.logReceived(this.getRecipient(sourceAddress));
        }

        abstract String logSuffix();
    }

    private class ConcurrentBroadcastAckListener
    extends AbstractExchange.InternalEventListener<Object, ExchangeConnection> {
        Map<Long, BroadcastAckListener> listeners = new HashMap<Long, BroadcastAckListener>();
        LongNumberAllocatorSimple iEventAllocator = new LongNumberAllocatorSimple();

        private ConcurrentBroadcastAckListener() {
        }

        @Override
        void processEvent(FabricAddress sourceAddress, AbstractExchange.InternalEvent event, ExchangeConnection connection) {
            try {
                BroadcastAckListener listener = this.getListener(((AbstractExchange.ConcurrentInternalEvent)event).iEvent);
                listener.logReceived(sourceAddress, event.data);
                listener.onEvent(sourceAddress, event.data, connection);
            }
            catch (Exception exception) {
                RuntimeExchange.this.logException(exception, true, "Processing of internal event [" + this.eventName + "] failed.");
            }
        }

        @Override
        void logReceived(FabricAddress sourceAddress, Object data) {
        }

        private synchronized long addListener(BroadcastAckListener listener) {
            long iEvent = this.iEventAllocator.getNumber();
            this.listeners.put(iEvent, listener);
            return iEvent;
        }

        private synchronized void removeListener(long iEvent) {
            this.listeners.remove(iEvent);
        }

        private synchronized BroadcastAckListener getListener(long iEvent) throws ExchangeException {
            BroadcastAckListener listener = this.listeners.get(iEvent);
            if (listener == null) {
                throw new ExchangeException("Broadcast ack listener for event [" + iEvent + "] not found.");
            }
            return listener;
        }
    }

    class SysplexSynchronizer {
        private final Object tokenMutex = new Object();
        private long tokenId = 0L;
        private byte[] tokenPacket;
        private long tokenReceiptTime = -1L;
        private long tokenSendingTime = -1L;
        private TreeSet<FabricAddress> tokenRing = new TreeSet();
        private FabricAddress tokenDestination;
        private List<RoutingTable.Path> tokenRingPaths;
        private volatile boolean isRoot = false;
        private volatile boolean isTokenActive = false;
        private volatile boolean hasToken = false;
        private TokenSender tokenSender;
        private TokenProcessor tokenProcessor;
        private TokenMonitor tokenMonitor;
        private volatile boolean joinInProgress = false;
        private final Object joinMutex = new Object();
        private NodeExchangeConnection joiningConnection;
        private FabricNode joiningNode;
        private List<FabricNode> joiningNodes;
        private JoinMonitor joinMonitor;
        private File joinJarDir;
        private volatile boolean forcedDisconnectInProgress = false;
        private final Object forcedDisconnectMutex = new Object();
        private ForcedDisconnectProcessor forcedDisconnectProcessor;
        private Set<Long> completedForcedDisconnectProcessors = Collections.synchronizedSet(new HashSet());
        private volatile boolean needForcedCheckToken = false;
        private static final long MAX_TOKEN_SEND_ATTEMPTS = 3L;
        private static final String TIMEOUT_EXPIRED_MESSAGE = " Cause: Timeout expired.";
        int counter = 0;

        SysplexSynchronizer() {
        }

        private void setTokenActive(boolean isTokenActive) {
            this.isTokenActive = isTokenActive;
        }

        private synchronized void setTokenId(long tokenId) {
            this.tokenId = tokenId;
            this.setTokenPacket();
        }

        long getTokenId() {
            return this.tokenId != 0L ? this.tokenId : 1L;
        }

        private byte[] setTokenPacket() {
            this.tokenPacket = ByteBuffer.allocate(8).putLong(this.tokenId).array();
            return this.tokenPacket;
        }

        private boolean hasToken(long tokenId) {
            return this.hasToken && this.tokenId == tokenId;
        }

        private synchronized boolean hasToken() {
            return this.isTokenActive && this.hasToken;
        }

        private boolean isTokenAbsent() {
            return this.isTokenActive && !this.hasToken;
        }

        private boolean isTokenAbsent(long timeout) {
            return this.isTokenAbsent() && System.currentTimeMillis() - this.tokenSendingTime >= timeout;
        }

        private long getTokenHoldingTime() {
            return this.hasToken && this.tokenReceiptTime > 0L ? System.currentTimeMillis() - this.tokenReceiptTime : -1L;
        }

        private long getTokenAbsenceTime() {
            return !this.hasToken && this.tokenSendingTime > 0L ? System.currentTimeMillis() - this.tokenSendingTime : -1L;
        }

        void checkTokenDelay(boolean error) {
            long tokenHoldingTime = this.getTokenHoldingTime();
            if (tokenHoldingTime > RuntimeExchange.this.longReplyTimeout) {
                String message = "Node holds synchronization token too long (" + tokenHoldingTime + " msec).";
                if (error) {
                    RuntimeExchange.this.logError(message);
                } else {
                    RuntimeExchange.this.logWarning(message);
                }
            }
        }

        synchronized void checkTokenThreads() {
            if (this.tokenMonitor != null && !this.tokenMonitor.getThread().isRunning()) {
                RuntimeExchange.this.logError("Token Monitor thread is dead. Recreating...");
                this.tokenMonitor = null;
                this.createTokenMonitor();
            }
            if (this.tokenProcessor != null && !this.tokenProcessor.getThread().isRunning()) {
                RuntimeExchange.this.detachFromSysplexForced("Token Processor thread is dead.");
            }
            if (this.tokenSender != null && !this.tokenSender.getThread().isRunning()) {
                RuntimeExchange.this.detachFromSysplexForced("Token Sender thread is dead.");
            }
        }

        synchronized void addNode(FabricNode fabricNode) {
            this.tokenRing.add(fabricNode.getFabricAddress());
            this.onNodeAdd();
        }

        private void onNodeAdd() {
            this.updateTokenDestination();
            if (this.shouldBecomeRoot()) {
                this.takeOverRootRole(true);
            } else if (this.shouldReleaseRoot()) {
                this.handOverRootRole();
            }
            this.createTokenProcessor();
            this.createTokenSender();
            this.createTokenMonitor();
        }

        synchronized void removeNode(FabricNode fabricNode) {
            this.tokenRing.remove(fabricNode.getFabricAddress());
            this.onNodeRemove();
        }

        private void onNodeRemove() {
            if (!this.tokenRing.isEmpty()) {
                this.updateTokenDestination();
                if (this.shouldBecomeRoot()) {
                    this.takeOverRootRole(false);
                }
            }
        }

        void recreateTokenRing() {
            this.tokenRing.clear();
            this.tokenRing.addAll(RuntimeExchange.this.getNodeAddresses());
            this.updateTokenDestination();
        }

        void setTokenRingPaths(List<RoutingTable.Path> paths) {
            this.tokenRingPaths = paths;
            this.changeTokenMonitorInterval();
        }

        synchronized void reset() {
            this.tokenRing.clear();
            this.doReset();
        }

        synchronized Set<FabricAddress> getTokenRing() {
            return new TreeSet<FabricAddress>((SortedSet<FabricAddress>)this.tokenRing);
        }

        private void doReset() {
            if (this.tokenProcessor != null) {
                this.isTokenActive = false;
                this.destroyTokenMonitor();
                this.destroyTokenProcessor();
                this.destroyTokenSender();
                this.tokenDestination = null;
                if (this.isRoot) {
                    this.handOverRootRole();
                }
                this.tokenId = 0L;
                this.tokenPacket = null;
                this.tokenReceiptTime = -1L;
                this.tokenSendingTime = -1L;
                this.hasToken = false;
                RuntimeExchange.this.groupManager.notifyOnToken();
                FabricThreadManager.getInstance().createThread("EXCH:SysplexSynchronizer.Reset", "Completes the SysplexSynchronizer reset.", () -> this.notifyOnToken(true)).start();
            }
        }

        private void updateTokenDestination() {
            this.tokenDestination = this.tokenRing.higher(RuntimeExchange.this.node.getFabricAddress());
            if (this.tokenDestination == null) {
                this.tokenDestination = this.tokenRing.first();
            }
        }

        private boolean shouldBecomeRoot() {
            return !this.isRoot && this.tokenRing.lower(RuntimeExchange.this.node.getFabricAddress()) == null;
        }

        private void takeOverRootRole(boolean onAddNode) {
            this.isRoot = true;
            this.destroyTokenMonitor();
            this.createTokenMonitor();
            if (onAddNode) {
                Utils.sleep(10L);
                this.suspendTokenMonitor();
            } else {
                this.needForcedCheckToken = true;
            }
            RuntimeExchange.this.logInfo("FAIR: Node " + RuntimeExchange.this.getNodePrintName() + " assumed the role of a root.");
        }

        private void forcedCheckToken() {
            if (this.isRoot && this.needForcedCheckToken) {
                this.needForcedCheckToken = false;
                FabricThreadManager.getInstance().createThread("EXCH:Token.ForcedCheck", "Checks the synchronization token urgently.", () -> {
                    Utils.sleep(RuntimeExchange.this.fastReplyTimeout);
                    RuntimeExchange.this.sysplexSynchronizer.forceTokenMonitor(false);
                }).start();
            }
        }

        private boolean shouldReleaseRoot() {
            return this.isRoot && this.tokenRing.lower(RuntimeExchange.this.node.getFabricAddress()) != null;
        }

        private void handOverRootRole() {
            this.isRoot = false;
            this.destroyTokenMonitor();
            RuntimeExchange.this.logInfo("FAIR: Node " + RuntimeExchange.this.getNodePrintName() + " is not a root anymore.");
        }

        synchronized FabricAddress getRootNode() {
            return this.tokenRing.lower(RuntimeExchange.this.getNodeAddress()) == null ? RuntimeExchange.this.getNodeAddress() : this.tokenRing.first();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object invoke(Method method, Object ... parameters) throws Exception {
            try {
                Object object = this.tokenMutex;
                synchronized (object) {
                    this.waitForToken();
                    this.waitForJoin();
                    this.waitForForcedDisconnect();
                    RuntimeExchange.this.logDebug("Invoking synchronized method '" + method.getName() + "'...");
                    return method.invoke((Object)RuntimeExchange.this, parameters);
                }
            }
            catch (InvocationTargetException exception) {
                if (exception.getTargetException() instanceof Exception) {
                    throw (Exception)exception.getTargetException();
                }
                if (exception.getTargetException() instanceof OutOfMemoryError) {
                    RuntimeExchange.this.handle((OutOfMemoryError)exception.getTargetException());
                }
                throw new ExchangeException("Unexpected exception.", exception.getTargetException());
            }
            catch (InterruptedException exception) {
                throw new ExchangeException("Waiting for synchronization token interrupted.", (Throwable)exception);
            }
            catch (Throwable exception) {
                throw new ExchangeException("Unexpected exception.", exception);
            }
        }

        Object invokeWithoutException(Method method, Object ... parameters) {
            try {
                return this.invoke(method, parameters);
            }
            catch (Throwable exception) {
                RuntimeExchange.this.logException(exception, true);
                return null;
            }
        }

        private void waitForToken() throws InterruptedException {
            while (this.isTokenAbsent()) {
                this.tokenMutex.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object invokeWithTimeout(long timeout, Method method, Object ... parameters) throws TimeoutException {
            if (timeout <= 0L) {
                return this.invokeWithoutException(method, parameters);
            }
            try {
                Object object = this.tokenMutex;
                synchronized (object) {
                    this.waitForToken(timeout);
                    this.waitForJoin();
                    this.waitForForcedDisconnect();
                    RuntimeExchange.this.logDebug("Invoking synchronized method '" + method.getName() + "'...");
                    return method.invoke((Object)RuntimeExchange.this, parameters);
                }
            }
            catch (InvocationTargetException exception) {
                if (exception.getTargetException() instanceof Exception) {
                    RuntimeExchange.this.logException(exception.getTargetException(), true);
                } else {
                    RuntimeExchange.this.logException(exception.getTargetException(), true, "Unexpected exception.");
                }
                return null;
            }
            catch (InterruptedException exception) {
                throw new TimeoutException("Waiting for synchronization token interrupted.");
            }
            catch (TimeoutException exception) {
                throw exception;
            }
            catch (Throwable exception) {
                RuntimeExchange.this.logException(exception, true, "Unexpected exception.");
                return null;
            }
        }

        private void waitForToken(long timeout) throws InterruptedException, TimeoutException {
            long endTime = System.currentTimeMillis() + timeout;
            while (this.isTokenAbsent() && System.currentTimeMillis() < endTime) {
                this.tokenMutex.wait(timeout);
            }
            if (this.isTokenAbsent()) {
                throw new TimeoutException("Waiting time for synchronization token expired.");
            }
        }

        synchronized boolean checkState() {
            return this.tokenSender != null && this.tokenSender.isStarted() && !this.tokenSender.isSent && this.tokenProcessor != null && this.tokenProcessor.isStarted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startTokenPassing() {
            SysplexSynchronizer sysplexSynchronizer = this;
            synchronized (sysplexSynchronizer) {
                if (!this.isTokenAbsent() || this.tokenRing.isEmpty()) {
                    return;
                }
                this.setTokenId(1L);
            }
            this.activateToken();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void restartTokenPassing() {
            SysplexSynchronizer sysplexSynchronizer = this;
            synchronized (sysplexSynchronizer) {
                if (!this.isRoot || !this.isTokenAbsent() || this.tokenRing.isEmpty()) {
                    return;
                }
                this.isTokenActive = false;
            }
            boolean startScavenger = RuntimeExchange.this.scavenger.isRunning();
            if (startScavenger) {
                RuntimeExchange.this.scavenger.stop();
            }
            RuntimeExchange.this.logInfo("Synchronization token is lost. Node " + RuntimeExchange.this.getNodePrintName() + " is restarting token...");
            boolean nodesDetached = RuntimeExchange.this.detachBadNodes(this.tokenMonitor.badNodeAddress);
            if (this.tokenProcessor != null) {
                this.setTokenId(this.tokenId + 1L);
                RuntimeExchange.this.broadcastWithAckToNodes(135, new TokenRestartData(this.tokenId, nodesDetached));
                if (this.activateToken()) {
                    RuntimeExchange.this.logInfo("Synchronization token restarted by node " + RuntimeExchange.this.getNodePrintName() + ".");
                    RuntimeExchange.this.onExchangeUpdate(FabricExchangeState.TOKEN_RESTARTED, "Synchronization token restarted.", null, false);
                } else {
                    RuntimeExchange.this.logError("Restarting synchronization token failed in node " + RuntimeExchange.this.getNodePrintName() + ".");
                    RuntimeExchange.this.onExchangeUpdate(FabricExchangeState.TOKEN_RESTART_FAILED, "Restarting synchronization token failed.", "Critical error. Probably the node should be restarted.", true);
                }
            }
            if (startScavenger || nodesDetached) {
                RuntimeExchange.this.scavenger.start();
            }
        }

        synchronized void onTokenRestart(Long tokenId) {
            this.hasToken = false;
            this.setTokenId(tokenId);
        }

        private boolean activateToken() {
            this.isTokenActive = true;
            this.hasToken = true;
            return this.passToken();
        }

        synchronized void resetToken(long tokenId) {
            this.setTokenId(tokenId);
            this.isTokenActive = true;
            this.hasToken = false;
        }

        private void handOverToken() {
            if (this.hasToken) {
                this.hasToken = false;
                this.raiseTokenRequest(this.tokenDestination);
            }
        }

        private void raiseTokenRequest(FabricAddress nodeAddress) {
            try {
                RuntimeExchange.this.getConnection(nodeAddress).raiseTokenRequest(nodeAddress, this.packToken());
            }
            catch (Exception exception) {
                RuntimeExchange.this.logException(exception, true, "Handing over synchronization token (ID=" + this.tokenId + ") failed.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean passToken() {
            boolean result = true;
            if (this.hasToken()) {
                Utils.sleep(RuntimeExchange.this.tokenDelay);
                Object object = this.tokenMutex;
                synchronized (object) {
                    this.waitForJoin();
                    this.waitForForcedDisconnect();
                    if (this.hasToken) {
                        this.hasToken = false;
                        result = this.raiseTokenEvent();
                    }
                }
                this.resumeTokenMonitor();
            }
            return result;
        }

        private boolean raiseTokenEvent() {
            this.checkTokenSender();
            Throwable exception = null;
            int iAttempt = 0;
            do {
                exception = this.doRaiseTokenEvent();
                ++iAttempt;
                if (this.tokenSender.isSent || this.tokenSender.exception != null || exception != null) continue;
                RuntimeExchange.this.logError(this.getPassingTokenErrorMessage(iAttempt) + TIMEOUT_EXPIRED_MESSAGE);
                RuntimeExchange.this.onExchangeUpdate(FabricExchangeState.TOKEN_PASSING_TIMEOUT, "Timeout expired for passing synchronization token (attempt #" + iAttempt + ").", "Node " + RuntimeExchange.this.getNodePrintName() + " could not pass the token during " + RuntimeExchange.this.fastReplyTimeout + " milliseconds." + ((long)iAttempt < 3L ? "\nNode will repeat the token passing." : ""), iAttempt == 1);
            } while (!this.tokenSender.isSent && exception == null && this.tokenSender.exception == null && (long)iAttempt < 3L);
            if (!this.tokenSender.isSent) {
                this.processTokenPassingError(exception, iAttempt);
                return false;
            }
            return true;
        }

        private Throwable doRaiseTokenEvent() {
            block3: {
                this.tokenSender.execute();
                try {
                    if (++this.counter > 100 && RuntimeExchange.this.node.getName().equals("TestNode1")) {
                        Utils.sleep(5L);
                    }
                    this.tokenSender.waitForCompletion(RuntimeExchange.this.fastReplyTimeout);
                }
                catch (InterruptedException interruptedException) {
                    if (this.tokenSender.isSent) break block3;
                    return interruptedException;
                }
            }
            return null;
        }

        private void processTokenPassingError(Throwable exception, int iAttempt) {
            String errorMessage = this.getPassingTokenErrorMessage(iAttempt) + TIMEOUT_EXPIRED_MESSAGE;
            if (this.tokenSender.exception != null) {
                exception = this.tokenSender.exception;
            }
            if (exception != null) {
                RuntimeExchange.this.logException(exception, true, this.getPassingTokenErrorMessage(iAttempt));
                errorMessage = this.getPassingTokenErrorMessage(iAttempt) + " Cause: " + exception.getMessage();
            } else {
                RuntimeExchange.this.logError(errorMessage);
            }
            this.tokenSender.reset();
            Utils.sleep(100L);
            if (!this.forcedDisconnectInProgress) {
                if (this.tokenSender.errorCount >= 10L) {
                    String message = "Passing synchronization token failed " + this.tokenSender.errorCount + " times in a row.";
                    String detailedMessage = message + "\nNode will be transferred to standalone mode.";
                    FabricThreadManager.getInstance().createThread("EXCH:ForcedDetach", "Detaches node " + RuntimeExchange.this.getNodePrintName() + " from Sysplex.", () -> {
                        Utils.sleep(100L);
                        RuntimeExchange.this.onExchangeUpdate(FabricExchangeState.FORCED_DETACH_FROM_SYSPLEX, "Node is forcibly detached from sysplex.", detailedMessage, true);
                        RuntimeExchange.this.detachFromSysplexForced(message);
                    }).start();
                } else if (this.isRoot) {
                    RuntimeExchange.this.doResync(true);
                } else {
                    try {
                        RuntimeExchange.this.logInfo("Node " + RuntimeExchange.this.getNodePrintName() + " is notifying root node " + RuntimeExchange.this.getFabricNodePrintName(RuntimeExchange.this.sysplexSynchronizer.getRootNode()) + " about loss of synchronization token...");
                        RuntimeExchange.this.raiseFastInternalRequest(RuntimeExchange.this.sysplexSynchronizer.getRootNode(), 135, errorMessage);
                    }
                    catch (Exception internalError) {
                        RuntimeExchange.this.logInternalRequestError(internalError, 135);
                    }
                }
            }
        }

        private String getPassingTokenErrorMessage(int iAttempt) {
            return "Node " + RuntimeExchange.this.getNodePrintName() + " failed to pass synchronization token (ID=" + this.tokenId + ") " + this.getDestination() + " (attempt #" + iAttempt + ").";
        }

        private String getDestination() {
            return "to node " + RuntimeExchange.this.getFabricNodePrintName(this.tokenDestination);
        }

        private byte[] packToken() {
            return RuntimeExchange.this.groupManager.updateToken(this.tokenPacket);
        }

        private void createTokenSender() {
            if (this.tokenSender == null) {
                this.doCreateTokenSender();
            }
        }

        private synchronized void destroyTokenSender() {
            if (this.tokenSender != null) {
                this.tokenSender.stop(true);
                this.tokenSender = null;
            }
        }

        private void checkTokenSender() {
            if (this.tokenSender != null && !this.tokenSender.isStarted()) {
                this.doCreateTokenSender();
            }
        }

        private void doCreateTokenSender() {
            this.tokenSender = new TokenSender();
            this.tokenSender.start();
        }

        private void onToken(ByteBuffer tokenBuffer) {
            if (this.tokenProcessor != null) {
                this.tokenProcessor.wakeUp(tokenBuffer);
            }
        }

        private synchronized boolean hasToken(ByteBuffer tokenBuffer) {
            if (this.isTokenAbsent()) {
                long tokenId = tokenBuffer.getLong();
                if (this.tokenId != tokenId) {
                    if (this.tokenId == 0L) {
                        this.setTokenId(tokenId);
                    } else {
                        RuntimeExchange.this.logError("Wrong synchronization token (ID=" + tokenId + ") received (expected ID=" + this.tokenId + "). Ignoring...");
                        return false;
                    }
                }
                this.hasToken = true;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyOnToken(boolean all) {
            Object object = this.tokenMutex;
            synchronized (object) {
                if (all) {
                    this.tokenMutex.notifyAll();
                } else {
                    this.tokenMutex.notify();
                }
            }
        }

        private void createTokenProcessor() {
            if (this.tokenProcessor == null) {
                this.tokenProcessor = new TokenProcessor();
                this.tokenProcessor.start();
            }
        }

        private synchronized void destroyTokenProcessor() {
            if (this.tokenProcessor != null) {
                this.tokenProcessor.stop(true);
                this.tokenProcessor = null;
            }
        }

        private void createTokenMonitor() {
            if (this.tokenMonitor == null) {
                if (this.isRoot) {
                    this.doCreateTokenMonitor(RuntimeExchange.this.tokenMonitorInterval);
                } else if (RuntimeExchange.this.fastFailTimeout > 0L) {
                    this.doCreateTokenMonitor(RuntimeExchange.this.fastFailTimeout);
                }
            }
        }

        private void doCreateTokenMonitor(long timeout) {
            try {
                this.tokenMonitor = new TokenMonitor(timeout);
                this.tokenMonitor.start();
            }
            catch (FabricException fabricException) {
                // empty catch block
            }
        }

        private synchronized void destroyTokenMonitor() {
            if (this.tokenMonitor != null) {
                this.tokenMonitor.stop(true);
                this.tokenMonitor = null;
            }
        }

        private synchronized void suspendTokenMonitor() {
            if (this.tokenMonitor != null) {
                this.tokenMonitor.sleep();
            }
        }

        private synchronized void resumeTokenMonitor() {
            if (this.tokenMonitor != null) {
                this.tokenMonitor.wakeUp();
            }
        }

        private synchronized void resetTokenMonitor() {
            this.suspendTokenMonitor();
            Utils.sleep(10L);
            this.resumeTokenMonitor();
        }

        private void forceTokenMonitor(boolean skipCheck) {
            this.suspendTokenMonitor();
            this.tokenMonitor.execute(true, skipCheck);
            this.resumeTokenMonitor();
        }

        private synchronized void setTokenMonitorInterval(long interval, boolean forRoot) {
            if (forRoot) {
                if (this.isRoot && this.tokenMonitor != null) {
                    this.tokenMonitor.setTimeout(interval);
                }
            } else if (!this.isRoot) {
                if (interval <= 0L) {
                    this.destroyTokenMonitor();
                } else if (this.tokenMonitor != null) {
                    this.tokenMonitor.setTimeout(interval);
                }
            }
        }

        private synchronized void changeTokenMonitorInterval() {
            this.setTokenMonitorInterval(this.calculateTokenMonitorInterval(), true);
        }

        private long calculateTokenMonitorInterval() {
            double result = 0.0;
            if (this.tokenRingPaths != null) {
                result = this.tokenRingPaths.stream().mapToDouble(path -> path.distance).sum();
            }
            result /= 1000.0;
            return Math.max((long)(result += (double)((long)(this.tokenRing.size() + 1) * RuntimeExchange.this.tokenDelay)) * 2L, RuntimeExchange.this.tokenMonitorInterval);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForJoin() {
            Object object = this.joinMutex;
            synchronized (object) {
                while (this.joinInProgress) {
                    try {
                        this.joinMutex.wait();
                    }
                    catch (InterruptedException exception) {
                        if (!RuntimeExchange.this.inSysplex()) continue;
                        throw new RuntimeException("Method 'waitForJoin' interrupted.");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startJoin(NodeExchangeConnection connection, String nodeName) {
            Object object = this.joinMutex;
            synchronized (object) {
                this.joinInProgress = true;
                this.joiningConnection = connection;
                this.joiningConnection.onStartJoin(nodeName);
                if (this.isRoot && this.isTokenActive) {
                    this.suspendTokenMonitor();
                }
                this.setTokenActive(true);
                this.createJoinMonitor(nodeName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean completeJoin(NodeExchangeConnection connection, boolean isNormal) {
            Object object = this.joinMutex;
            synchronized (object) {
                if (this.joinInProgress && connection == this.joiningConnection) {
                    this.destroyJoinMonitor();
                    if (this.joinJarDir != null) {
                        FileIOUtils.deleteFileDir(this.joinJarDir);
                        this.joinJarDir = null;
                    }
                    this.joiningConnection.onCompleteJoin(isNormal);
                    this.joiningConnection = null;
                    this.joiningNode = null;
                    this.joiningNodes = null;
                    this.joinInProgress = false;
                    if (!isNormal && !RuntimeExchange.this.inSysplex()) {
                        RuntimeExchange.this.sysplexSynchronizer.setTokenActive(false);
                    }
                    this.joinMutex.notifyAll();
                    return true;
                }
            }
            return false;
        }

        private synchronized List<Object> getJoinInfo() {
            ArrayList<Object> result = null;
            if (this.joinInProgress) {
                result = new ArrayList<Object>();
                result.add(this.joiningConnection.joinNodeName);
                result.add(this.joiningConnection.joinThreadId);
                result.add(Utils.toTimeString(System.currentTimeMillis() - this.joiningConnection.joinStartTime));
                result.add(RuntimeExchange.convertActive(this.joinMonitor != null));
                if (this.joinMonitor != null) {
                    result.add(this.joinMonitor.getThread().getId());
                }
            }
            return result;
        }

        private long getJoinMonitorTimeout() {
            return RuntimeExchange.this.longReplyTimeout * 2L;
        }

        private void createJoinMonitor(String joiningNode) {
            if (this.joinMonitor == null) {
                try {
                    this.joinMonitor = new JoinMonitor(joiningNode);
                    this.joinMonitor.start();
                }
                catch (FabricException fabricException) {
                    // empty catch block
                }
            }
        }

        private void destroyJoinMonitor() {
            if (this.joinMonitor != null) {
                this.joinMonitor.stop(true);
                this.joinMonitor = null;
            }
        }

        private void suspendJoinMonitor() {
            if (this.joinMonitor != null) {
                this.joinMonitor.sleep();
            }
        }

        private void resumeJoinMonitor() {
            if (this.joinMonitor != null) {
                this.joinMonitor.wakeUp();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startForcedDisconnect(FabricAddress directTask, boolean joinInterrupted) {
            if (!this.forcedDisconnectInProgress) {
                Object object = this.forcedDisconnectMutex;
                synchronized (object) {
                    if (!this.forcedDisconnectInProgress) {
                        this.forcedDisconnectInProgress = true;
                        this.waitForJoin();
                        this.forcedDisconnectProcessor = new ForcedDisconnectProcessor(joinInterrupted);
                        this.forcedDisconnectProcessor.addDirectTask(directTask);
                        this.forcedDisconnectProcessor.start();
                    } else {
                        this.forcedDisconnectProcessor.addDirectTask(directTask);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startForcedDisconnect(List<FabricAddress> routedTasks, boolean joinInterrupted) {
            if (!this.forcedDisconnectInProgress) {
                Object object = this.forcedDisconnectMutex;
                synchronized (object) {
                    if (!this.forcedDisconnectInProgress) {
                        this.forcedDisconnectInProgress = true;
                        this.waitForJoin();
                        this.forcedDisconnectProcessor = new ForcedDisconnectProcessor(joinInterrupted);
                        this.forcedDisconnectProcessor.addRoutedTasks(routedTasks);
                        this.forcedDisconnectProcessor.start();
                    } else {
                        this.forcedDisconnectProcessor.addRoutedTasks(routedTasks);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopForcedDisconnect() {
            Object object = this.forcedDisconnectMutex;
            synchronized (object) {
                if (this.forcedDisconnectInProgress) {
                    this.forcedDisconnectProcessor.stop();
                    this.forcedDisconnectProcessor = null;
                    this.forcedDisconnectInProgress = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForForcedDisconnect() {
            Object object = this.forcedDisconnectMutex;
            synchronized (object) {
                while (this.forcedDisconnectInProgress) {
                    if (this.completedForcedDisconnectProcessors.contains(Thread.currentThread().getId())) {
                        return;
                    }
                    try {
                        this.forcedDisconnectMutex.wait();
                    }
                    catch (InterruptedException exception) {
                        if (RuntimeExchange.this.inSysplex()) {
                            throw new RuntimeException("Method 'waitForForcedDisconnect' interrupted.");
                        }
                        return;
                    }
                }
            }
        }

        private boolean isForcedDisconnectCompleted() {
            return this.forcedDisconnectProcessor == null || this.forcedDisconnectProcessor.isCompleted;
        }

        private void onForcedDisconnectComplete() {
            if (this.isTokenActive && this.isRoot && !this.hasToken) {
                this.forceTokenMonitor(false);
            }
        }

        private class TokenMonitor
        extends MonitorWorker
        implements IWorker {
            FabricAddress badNodeAddress;

            TokenMonitor(long timeout) throws FabricException {
                super("EXCH:Token.Monitor", "Monitors a synchronization token.", timeout);
                this.badNodeAddress = null;
            }

            @Override
            public void setTimeout(long timeout) {
                try {
                    super.setTimeout(timeout);
                }
                catch (FabricException fabricException) {
                    // empty catch block
                }
            }

            @Override
            protected void doExecute() throws FabricException {
                if (this.isTokenAbsent(true)) {
                    long tokenAbsenceTime = RuntimeExchange.this.sysplexSynchronizer.getTokenAbsenceTime();
                    RuntimeExchange.this.logWarning("Synchronization token is absent in node " + RuntimeExchange.this.getNodePrintName() + " for at least " + RuntimeExchange.getTokenTime(tokenAbsenceTime) + ". Attempting to recover if possible...");
                    RuntimeExchange.this.onExchangeUpdate(FabricExchangeState.TOKEN_DELAYED, "Synchronization token is delayed.", "Token is absent in node " + RuntimeExchange.this.getNodePrintName() + " for at least " + RuntimeExchange.getTokenTime(tokenAbsenceTime) + ".\nNode will try to recover the token if possible.", false);
                    this.execute(false, false);
                }
            }

            void execute(boolean forced, boolean skipCheck) {
                if (SysplexSynchronizer.this.isRoot) {
                    if (skipCheck || !this.checkToken(!forced, true)) {
                        RuntimeExchange.this.onExchangeUpdate(FabricExchangeState.TOKEN_LOST, "Synchronization token is lost.", "Node could not find the token. Token will be restarted.", true);
                        SysplexSynchronizer.this.restartTokenPassing();
                    }
                } else if (this.isTokenAbsent(true)) {
                    RuntimeExchange.this.onExchangeUpdate(FabricExchangeState.TOKEN_LOST, "Synchronization token is lost.", "Node will be forcibly detached from sysplex (due to fast-fail strategy).", true);
                    RuntimeExchange.this.onExchangeUpdate(FabricExchangeState.FORCED_DETACH_FROM_SYSPLEX, "Node is forcibly detached from sysplex.", "Node will be transferred to standalone mode", false);
                    RuntimeExchange.this.detachFromSysplexForced("Synchronization token is lost.");
                }
                this.badNodeAddress = null;
            }

            private boolean checkToken(boolean checkTime, boolean firstTime) {
                RuntimeExchange.this.logInfo("Node " + RuntimeExchange.this.getNodePrintName() + " is checking state of synchronization token " + (firstTime ? "" : "one more time") + "...");
                if (this.isTokenAbsent(checkTime)) {
                    long lastTokenSendingTime = SysplexSynchronizer.this.tokenSendingTime;
                    long tokenAbsenceTime = Long.MAX_VALUE;
                    FabricAddress tokenNodeAddress = null;
                    TokenMonitorResult tokenData = null;
                    Map<FabricAddress, Object> acks = RuntimeExchange.this.broadcastWithAckToNodes(136, new TokenMonitorData(SysplexSynchronizer.this.tokenId), RuntimeExchange.this.fastReplyTimeout);
                    if (acks != null) {
                        for (Map.Entry<FabricAddress, Object> entry : acks.entrySet()) {
                            if (!(entry.getValue() instanceof TokenMonitorResult)) continue;
                            TokenMonitorResult result = (TokenMonitorResult)entry.getValue();
                            if (result.hasToken) {
                                tokenNodeAddress = entry.getKey();
                                tokenData = result;
                                break;
                            }
                            if (result.tokenAbsenceTime >= tokenAbsenceTime) continue;
                            tokenAbsenceTime = result.tokenAbsenceTime;
                        }
                    }
                    if (tokenData != null) {
                        if (tokenData.tokenHoldingTime > RuntimeExchange.this.longReplyTimeout) {
                            this.badNodeAddress = tokenNodeAddress;
                            FabricNode badNode = RuntimeExchange.this.getFabricNode(this.badNodeAddress);
                            if (badNode != null) {
                                RuntimeExchange.this.logError("Node " + badNode.getPrintName() + " holds synchronization token too long (for at least " + RuntimeExchange.getTokenTime(tokenData.tokenHoldingTime) + ").");
                            }
                            return false;
                        }
                        RuntimeExchange.this.logInfo("Synchronization token is in node " + RuntimeExchange.this.getFabricNodePrintName(tokenNodeAddress) + " (for at least " + RuntimeExchange.getTokenTime(tokenData.tokenHoldingTime) + ").");
                    } else {
                        if (this.isTokenAbsent(checkTime) && lastTokenSendingTime == SysplexSynchronizer.this.tokenSendingTime && tokenAbsenceTime > RuntimeExchange.this.fastReplyTimeout) {
                            return false;
                        }
                        RuntimeExchange.this.logInfo("Synchronization token was not found anywhere in Sysplex (absent for at least " + RuntimeExchange.getTokenTime(tokenAbsenceTime) + ").");
                        return firstTime && this.checkToken(checkTime, false);
                    }
                }
                RuntimeExchange.this.logDebug("Synchronization token is active.");
                return true;
            }

            private boolean isTokenAbsent(boolean checkTime) {
                return checkTime ? SysplexSynchronizer.this.isTokenAbsent(this.getTimeout()) : SysplexSynchronizer.this.isTokenAbsent();
            }
        }

        private class TokenProcessor
        extends Worker
        implements IWorker {
            private ByteBuffer tokenBuffer;

            TokenProcessor() {
                super("EXCH:Token.Processor", "Processes a synchronization token.");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doExecute() throws FabricException {
                TokenProcessor tokenProcessor = this;
                synchronized (tokenProcessor) {
                    block7: {
                        try {
                            if (SysplexSynchronizer.this.hasToken(this.tokenBuffer)) {
                                SysplexSynchronizer.this.tokenReceiptTime = System.currentTimeMillis();
                                SysplexSynchronizer.this.suspendTokenMonitor();
                                RuntimeExchange.this.groupManager.onToken(this.tokenBuffer);
                                break block7;
                            }
                            return;
                        }
                        finally {
                            this.tokenBuffer = null;
                        }
                    }
                }
                SysplexSynchronizer.this.notifyOnToken(false);
                SysplexSynchronizer.this.passToken();
            }

            @Override
            protected synchronized boolean hasTasks() {
                return this.tokenBuffer != null;
            }

            synchronized void wakeUp(ByteBuffer tokenBuffer) {
                this.tokenBuffer = tokenBuffer;
                this.wakeUp();
            }
        }

        private class TokenSender
        extends Worker
        implements IWorker {
            volatile boolean isSent;
            Throwable exception;
            long iAttempt;
            long errorCount;
            private static final long MAX_ERROR_COUNT = 10L;

            TokenSender() {
                super("EXCH:Token.Sender", "Passes a synchronization token.");
                this.isSent = true;
                this.iAttempt = 0L;
                this.errorCount = 0L;
            }

            void execute() {
                this.reset();
                this.wakeUp();
            }

            void reset() {
                this.isSent = false;
                this.exception = null;
            }

            synchronized void waitForCompletion(long timeout) throws InterruptedException {
                long endTime = System.currentTimeMillis() + timeout;
                long remainingTime = timeout;
                while (!this.isSent && remainingTime > 0L) {
                    this.wait(remainingTime);
                    remainingTime = endTime - System.currentTimeMillis();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doExecute() throws FabricException, InterruptedException {
                try {
                    RuntimeExchange.this.getConnection(SysplexSynchronizer.this.tokenDestination).raiseTokenEvent(SysplexSynchronizer.this.tokenDestination, SysplexSynchronizer.this.packToken());
                    SysplexSynchronizer.this.tokenSendingTime = System.currentTimeMillis();
                    this.isSent = true;
                    this.iAttempt = 0L;
                    this.errorCount = 0L;
                }
                catch (Throwable exception) {
                    if (!this.isStarted()) {
                        if (exception instanceof InterruptedException) {
                            throw (InterruptedException)exception;
                        }
                        throw new FabricException(exception);
                    }
                    this.exception = exception;
                    ++this.errorCount;
                }
                TokenSender tokenSender = this;
                synchronized (tokenSender) {
                    this.notifyAll();
                }
            }

            @Override
            protected boolean hasTasks() {
                return !this.isSent && this.exception == null;
            }
        }

        private class JoinMonitor
        extends MonitorWorker
        implements IWorker {
            private String joiningNode;

            protected JoinMonitor(String joiningNode) throws FabricException {
                super("EXCH:JoinMonitor", "Monitors the current Join operation.", SysplexSynchronizer.this.getJoinMonitorTimeout());
                this.joiningNode = joiningNode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doExecute() throws FabricException, InterruptedException {
                Object object = SysplexSynchronizer.this.joinMutex;
                synchronized (object) {
                    if (SysplexSynchronizer.this.joinInProgress && SysplexSynchronizer.this.joiningConnection != null && this.joiningNode.equals(SysplexSynchronizer.this.joiningConnection.joinNodeName)) {
                        RuntimeExchange.this.logWarning("Join of node " + FabricNode.getPrintName(SysplexSynchronizer.this.joiningConnection.joinNodeName) + " hung for at least " + this.getTimeoutSec() + " seconds and will be cancelled.");
                        RuntimeExchange.this.onExchangeUpdate(FabricExchangeState.JOIN_FAILED, "Join operation cancelled.", "Join of node " + FabricNode.getPrintName(SysplexSynchronizer.this.joiningConnection.joinNodeName) + " hung for at least " + this.getTimeoutSec() + " seconds.\nJoining node did not send a request to the next step. Operation will be cancelled.", false);
                        SysplexSynchronizer.this.joiningConnection.close(false);
                    }
                }
            }

            private long getTimeoutSec() {
                return this.getTimeout() / 1000L;
            }
        }

        private class ForcedDisconnectProcessor
        extends SingleTaskWorker
        implements IWorker {
            private Set<FabricAddress> directTasks;
            private Set<FabricAddress> routedTasks;
            private boolean joinInterrupted;
            volatile boolean isCompleted;

            ForcedDisconnectProcessor(boolean joinInterrupted) {
                super("EXCH:ForcedDisconnect.Processor", "Processes a forced disconnect (i.e. unexpected release of network link with the node).");
                this.directTasks = new HashSet<FabricAddress>();
                this.routedTasks = new HashSet<FabricAddress>();
                this.joinInterrupted = false;
                this.isCompleted = false;
                this.joinInterrupted = joinInterrupted;
            }

            void addDirectTask(FabricAddress task) {
                this.directTasks.add(task);
            }

            void addRoutedTasks(List<FabricAddress> tasks) {
                this.routedTasks.addAll(tasks);
            }

            @Override
            protected void doExecute() throws FabricException {
                try {
                    ArrayList<FabricAddress> currentDirectTasks = new ArrayList<FabricAddress>();
                    ArrayList<FabricAddress> currentRoutedTasks = new ArrayList<FabricAddress>();
                    while (this.hasTasks(currentDirectTasks, currentRoutedTasks)) {
                        this.doDisconnect(currentDirectTasks, currentRoutedTasks);
                        currentDirectTasks.clear();
                        currentRoutedTasks.clear();
                    }
                    SysplexSynchronizer.this.onForcedDisconnectComplete();
                    RuntimeExchange.this.scavenger.start();
                }
                catch (Throwable exception) {
                    throw new FabricException("Unexpected exception.", exception);
                }
                finally {
                    this.doComplete();
                    SysplexSynchronizer.this.completedForcedDisconnectProcessors.remove(Thread.currentThread().getId());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasTasks(List<FabricAddress> currentDirectTasks, List<FabricAddress> currentRoutedTasks) {
                if (!RuntimeExchange.this.inSysplex()) {
                    return this.doComplete();
                }
                Utils.sleep(1000L);
                Object object = SysplexSynchronizer.this.forcedDisconnectMutex;
                synchronized (object) {
                    if (!this.directTasks.isEmpty() || !this.routedTasks.isEmpty()) {
                        currentDirectTasks.addAll(this.directTasks);
                        this.directTasks.clear();
                        currentRoutedTasks.addAll(this.routedTasks);
                        this.routedTasks.clear();
                        return true;
                    }
                    this.isCompleted = true;
                    this.askSysplexForCompletion();
                    return this.doComplete();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean doComplete() {
                Object object = SysplexSynchronizer.this.forcedDisconnectMutex;
                synchronized (object) {
                    if (SysplexSynchronizer.this.forcedDisconnectInProgress && SysplexSynchronizer.this.forcedDisconnectProcessor == this) {
                        SysplexSynchronizer.this.completedForcedDisconnectProcessors.add(Thread.currentThread().getId());
                        SysplexSynchronizer.this.forcedDisconnectInProgress = false;
                        SysplexSynchronizer.this.forcedDisconnectProcessor = null;
                        SysplexSynchronizer.this.forcedDisconnectMutex.notifyAll();
                    }
                }
                return false;
            }

            private void askSysplexForCompletion() {
                Utils.sleep(1000L);
                while (!Thread.currentThread().isInterrupted()) {
                    boolean completed = true;
                    Map<FabricAddress, Object> acks = RuntimeExchange.this.broadcastWithAckToNodes(112, null);
                    if (acks != null) {
                        for (Object value : acks.values()) {
                            if (!(value instanceof Boolean) || ((Boolean)value).booleanValue()) continue;
                            completed = false;
                            break;
                        }
                    }
                    if (!completed && Utils.sleep(1000L)) continue;
                    break;
                }
            }

            private void doDisconnect(List<FabricAddress> currentDirectTasks, List<FabricAddress> currentRoutedTasks) {
                if (RuntimeExchange.this.nodeConnections.isEmpty() && RuntimeExchange.this.peerState != PeerState.STANDALONE) {
                    RuntimeExchange.this.switchToStandaloneRole(this.joinInterrupted);
                } else {
                    if (!currentDirectTasks.isEmpty()) {
                        RuntimeExchange.this.broadcastToNodes(111, new NodeForcedDisconnectEventData(currentDirectTasks, this.joinInterrupted), false);
                    }
                    HashSet<FabricNode> removedNodes = new HashSet<FabricNode>();
                    this.addRemovedNodes(currentDirectTasks, removedNodes);
                    this.addRemovedNodes(currentRoutedTasks, removedNodes);
                    for (FabricNode fabricNode : removedNodes) {
                        RuntimeExchange.this.removeFabricNode(fabricNode, false, this.joinInterrupted);
                    }
                }
            }

            private void addRemovedNodes(List<FabricAddress> addresses, Set<FabricNode> result) {
                for (FabricAddress address : addresses) {
                    FabricNode fabricNode = RuntimeExchange.this.getFabricNode(address);
                    if (fabricNode == null) continue;
                    result.add(fabricNode);
                }
            }
        }
    }

    private static enum NumericParameterType {
        POSITIVE,
        NON_NEGATIVE,
        ANY;


        void validate(String name, long value) throws FabricExchangeException {
            switch (this.ordinal()) {
                case 0: {
                    if (value > 0L) break;
                    throw new FabricExchangeException(6007, "Parameter '" + name + "' must be positive.");
                }
                case 1: {
                    if (value >= 0L) break;
                    throw new FabricExchangeException(6007, "Parameter '" + name + "' must not be negative.");
                }
            }
        }
    }

    private class ThreadMonitor
    extends MonitorWorker {
        private Map<Long, BlockedThreadInfo> blockedThreads;
        private Set<ThreadDeadlock> reportedDeadlocks;
        private List<DataspaceSessionInfo> reportedSessions;

        ThreadMonitor(long timeout) throws FabricException {
            super("EXCH:ThreadMonitor", "Monitors a state of threads and Dataspace sessions in the current node.", timeout);
            this.blockedThreads = new HashMap<Long, BlockedThreadInfo>();
            this.reportedDeadlocks = new HashSet<ThreadDeadlock>();
            this.reportedSessions = null;
        }

        @Override
        protected void doExecute() throws FabricException {
            this.processDeadlocks();
            if (RuntimeExchange.this.blockedThreadAdvisoryThreshold > 0L) {
                this.processBlockedThreads();
            }
            this.processBlockedDataspaceSessions();
            RuntimeExchange.this.sysplexSynchronizer.checkTokenDelay(false);
            RuntimeExchange.this.sysplexSynchronizer.checkTokenThreads();
        }

        private void processDeadlocks() {
            Map<Long, Boolean> deadlockedThreads = this.getDeadlockedThreads();
            if (!deadlockedThreads.isEmpty()) {
                HashSet<ThreadDeadlock> newReportedDeadlocks = new HashSet<ThreadDeadlock>();
                deadlockedThreads.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).forEach(entry -> {
                    ThreadInfo secondThreadInfo;
                    ThreadInfo firstThreadInfo = FabricThreadManager.getInstance().getThreadBean().getThreadInfo((Long)entry.getKey());
                    if (firstThreadInfo != null && deadlockedThreads.containsKey(firstThreadInfo.getLockOwnerId()) && (secondThreadInfo = FabricThreadManager.getInstance().getThreadBean().getThreadInfo(firstThreadInfo.getLockOwnerId())) != null) {
                        ThreadDeadlock deadlock = new ThreadDeadlock(firstThreadInfo.getThreadId(), secondThreadInfo.getThreadId());
                        if (!this.reportedDeadlocks.contains(deadlock)) {
                            RuntimeExchange.this.logError("Thread deadlock found (first thread <" + deadlock.first + "," + firstThreadInfo.getThreadName() + ">, second thread <" + deadlock.second + "," + secondThreadInfo.getThreadName() + ">).");
                            this.raiseAdvisory(ThreadDeadlockAdvisory.class, firstThreadInfo, secondThreadInfo);
                            deadlockedThreads.put(deadlock.second, true);
                        }
                        newReportedDeadlocks.add(deadlock);
                    }
                });
                this.reportedDeadlocks = newReportedDeadlocks;
            } else {
                this.reportedDeadlocks.clear();
            }
        }

        private Map<Long, Boolean> getDeadlockedThreads() {
            HashMap<Long, Boolean> result = new HashMap<Long, Boolean>();
            long[] deadlockedThreadIds = FabricThreadManager.getInstance().getThreadBean().findDeadlockedThreads();
            if (deadlockedThreadIds != null) {
                for (long threadId : deadlockedThreadIds) {
                    result.put(threadId, false);
                }
            }
            return result;
        }

        private void processBlockedThreads() {
            HashMap<Long, BlockedThreadInfo> newBlockedThreads = new HashMap<Long, BlockedThreadInfo>();
            List<ThreadInfo> threadsInfo = FabricThreadManager.getInstance().getThreadsInfo();
            for (ThreadInfo info : threadsInfo) {
                ThreadInfo blockedByInfo;
                if (info.getThreadState() != Thread.State.BLOCKED && info.getThreadState() != Thread.State.WAITING || info.getLockOwnerId() == -1L || (blockedByInfo = FabricThreadManager.getInstance().getThreadBean().getThreadInfo(info.getLockOwnerId())) == null) continue;
                long blockedTime = 0L;
                BlockedThreadInfo previousInfo = this.blockedThreads.get(info.getThreadId());
                if (previousInfo != null && previousInfo.info.getLockOwnerId() == info.getLockOwnerId() && !previousInfo.isReported && (blockedTime = previousInfo.blockedTime + this.getTimeout()) >= RuntimeExchange.this.blockedThreadAdvisoryThreshold * 1000L) {
                    RuntimeExchange.this.logError("Blocked thread found (thread <" + info.getThreadId() + "," + info.getThreadName() + ">, blocked by thread <" + blockedByInfo.getThreadId() + "," + blockedByInfo.getThreadName() + ">).");
                    this.raiseAdvisory(BlockedThreadAdvisory.class, info, blockedByInfo);
                    previousInfo.isReported = true;
                }
                newBlockedThreads.put(info.getThreadId(), new BlockedThreadInfo(info, blockedTime, previousInfo != null && previousInfo.isReported));
            }
            this.blockedThreads = newBlockedThreads;
        }

        private void raiseAdvisory(Class<? extends AdvisoryEvent> advisoryClass, ThreadInfo info1, ThreadInfo info2) {
            FabricThread thread1 = FabricThreadManager.getInstance().lookupThread(info1.getThreadId());
            FabricThread thread2 = FabricThreadManager.getInstance().lookupThread(info2.getThreadId());
            try {
                Constructor<? extends AdvisoryEvent> constructor = advisoryClass.getConstructor(Long.TYPE, String.class, StackTraceElement[].class, Long.TYPE, String.class, StackTraceElement[].class);
                AdvisoryEvent advisory = constructor.newInstance(info1.getThreadId(), info1.getThreadName(), thread1 != null ? thread1.getStackTrace() : (info1.getStackTrace().length != 0 ? info1.getStackTrace() : null), info2.getThreadId(), info2.getThreadName(), thread2 != null ? thread2.getStackTrace() : (info2.getStackTrace().length != 0 ? info2.getStackTrace() : null));
                RuntimeExchange.this.raiseSystemAdvisory(advisory);
            }
            catch (Exception exception) {
                RuntimeExchange.this.logException(exception, true);
                RuntimeExchange.this.logError("Creating " + advisoryClass.getSimpleName() + " instance failed.");
            }
        }

        private void processBlockedDataspaceSessions() {
            List<DataspaceSessionInfo> sessions = null;
            try {
                sessions = RuntimeExchange.this.context.getDataspaceManager().getBlockedSessions();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (sessions != null) {
                if (this.reportedSessions == null || !Utils.equals(sessions, this.reportedSessions)) {
                    this.raiseAdvisory(sessions);
                }
            } else {
                this.reportedSessions = null;
            }
        }

        private void raiseAdvisory(List<DataspaceSessionInfo> sessions) {
            RuntimeExchange.this.logError("Blocked Dataspace sessions found (" + String.valueOf(sessions.stream().map(DataspaceSessionInfo::toString).collect(Collectors.toList())) + ").");
            RuntimeExchange.this.raiseSystemAdvisory(new BlockedDataspaceSessionAdvisory(sessions));
            this.reportedSessions = sessions;
        }
    }

    private class ClientThresholdProcessor {
        String protocol;
        int threshold;
        ThresholdAdvisoryType type = ThresholdAdvisoryType.BELOW_THRESHOLD;

        ClientThresholdProcessor(String protocol, int threshold) {
            this.protocol = protocol;
            this.threshold = threshold;
        }

        void process(int currentValue) {
            if (this.type == ThresholdAdvisoryType.BELOW_THRESHOLD) {
                if (currentValue >= this.threshold) {
                    this.type = ThresholdAdvisoryType.ABOVE_THRESHOLD;
                    this.raiseAdvisory(currentValue);
                }
            } else if (currentValue < this.threshold) {
                this.type = ThresholdAdvisoryType.BELOW_THRESHOLD;
                this.raiseAdvisory(currentValue);
            }
        }

        private void raiseAdvisory(int currentValue) {
            RuntimeExchange.this.raiseSystemAdvisory(new ClientThresholdAdvisory(this.protocol, this.type, this.threshold, currentValue));
        }
    }

    private static class SetAdvancedParameterData
    extends CloneableDataObject {
        String name;
        String value;
        long resolvedValue;

        SetAdvancedParameterData(String name, String value, long resolvedValue) {
            this.name = name;
            this.value = value;
            this.resolvedValue = resolvedValue;
        }
    }

    static class ConfigurationParameter {
        String name;
        String value;
        boolean global;
        String description;

        ConfigurationParameter(String name, String value, boolean global, String description) {
            this.name = name;
            this.value = value;
            this.global = global;
            this.description = description;
        }
    }

    private class JoinConfirmEventListener
    extends AbstractExchange.InternalEventListener<List<RoutingTable.Link>, NodeExchangeConnection> {
        private JoinConfirmEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, List<RoutingTable.Link> routingLinks, NodeExchangeConnection connection) throws Exception {
            RuntimeExchange.this.sysplexSynchronizer.suspendJoinMonitor();
            RuntimeExchange.this.routingTable.addLinks(routingLinks);
            if (RuntimeExchange.this.sysplexSynchronizer.joiningNodes != null) {
                RuntimeExchange.this.sysplexSynchronizer.joiningNodes.forEach(node -> node.setReady(true));
                RuntimeExchange.this.sysplexSynchronizer.joiningNodes.forEach(RuntimeExchange.this::notifyOnAddNode);
                RuntimeExchange.this.sysplexSynchronizer.joiningNodes = null;
            }
            Utils.sleep(100L);
            this.acknowledgeBroadcast(routingLinks, connection, sourceAddress);
            if (RuntimeExchange.this.sysplexSynchronizer.completeJoin(connection, true)) {
                RuntimeExchange.this.sysplexSynchronizer.startTokenPassing();
            }
            RuntimeExchange.this.logInfo("Node " + RuntimeExchange.this.getFabricNodePrintName(sourceAddress) + " joined " + RuntimeExchange.this.getSysplexPrintName() + ".");
        }
    }

    private class SyncLevel1BackwardEventListener
    extends SpecialInternalEventListenerWithAck<SyncLevel1BackwardData, ExchangeConnection> {
        private SyncLevel1BackwardEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, SyncLevel1BackwardData data, ExchangeConnection connection) throws Exception {
            this.setAcknowledgementParameters((byte)1, RuntimeExchange.this.getFabricNode(sourceAddress).getName());
            RuntimeExchange.this.synchronizeLevel1Entities(data);
            RuntimeExchange.this.addFabricNodes(data.fabricNodes, true);
            RuntimeExchange.this.routingTable.addLinks(data.routingLinks);
            RuntimeExchange.this.sysplexSynchronizer.resetToken(data.tokenId);
            Utils.sleep(500L);
        }
    }

    private class SyncLevel2BackwardEventListener
    extends AbstractExchange.InternalEventListenerWithAck<SyncLevel2BackwardData, ExchangeConnection> {
        private SyncLevel2BackwardEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, SyncLevel2BackwardData data, ExchangeConnection connection) throws Exception {
            if (RuntimeExchange.this.context.isCoherenceAgentBound()) {
                RuntimeExchange.this.updatePackagesScope(data.exclusionList, data.semanticData.packages);
                data.duplicatedExtJARs.forEach(RuntimeExchange.this::doRemoveDuplicatedExtJAR);
                data.duplicatedLibJARs.forEach(RuntimeExchange.this::doRemoveDuplicatedLibJAR);
                File jarDir = data.semanticData.getJarDir();
                RuntimeExchange.this.synchronizeExtJARs(data.semanticData.extJARs, jarDir);
                RuntimeExchange.this.synchronizePackagesInNode(data.semanticData, RuntimeExchange.this.getChainRebuildIndex(data.semanticData.packages), jarDir);
                RuntimeExchange.this.synchronizeSemanticTypes(data.semanticData.semanticTypes);
                FileIOUtils.deleteFileDir(jarDir);
            }
        }
    }

    private class SyncLevel12ForwardEventListener
    extends AbstractExchange.InternalEventListenerWithAck<SyncLevel12ForwardData, ExchangeConnection> {
        private SyncLevel12ForwardEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, SyncLevel12ForwardData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.clusterNumberAllocator = data.clusterNumberAllocator;
            RuntimeExchange.this.clusterNumbers = data.clusterNumbers;
            RuntimeExchange.this.nodeNumberAllocator = data.nodeNumberAllocator;
            RuntimeExchange.this.synchronizeFabricGroups(data.fabricGroups);
            RuntimeExchange.this.synchronizeSysGlobals(data.sysGlobals, true);
            RuntimeExchange.this.synchronizeDirectoryTable(data.directoryTable);
            RuntimeExchange.this.synchronizeTimeWindowsInSysplex(data.timeWindows, true);
            RuntimeExchange.this.synchronizeDataConstraintsInSysplex(data.domains, data.ranges, true);
            RuntimeExchange.this.synchronizeGlobalCounter(data.globalCounter);
            if (RuntimeExchange.this.context.isCoherenceAgentBound()) {
                RuntimeExchange.this.synchronizeExtJARs(data.semanticData.extJARs, data.semanticData.getJarDir());
                RuntimeExchange.this.synchronizePackagesInSysplex(data.semanticData, data.semanticData.getJarDir(), false, null, null);
                RuntimeExchange.this.synchronizeSemanticTypes(data.semanticData.semanticTypes);
                FileIOUtils.deleteFileDir(data.semanticData.getJarDir());
            }
            RuntimeExchange.this.addFabricNodes(data.fabricNodes, false);
            RuntimeExchange.this.routingTable.addLinks(data.routingLinks);
        }

        @Override
        String getNodeName(FabricAddress sourceAddress, SyncLevel12ForwardData data) {
            return ((FabricNode)data.fabricNodes.get(0)).getName();
        }
    }

    private class SyncLevel3EventListener
    extends AbstractExchange.InternalEventListenerWithAck<SyncLevel3Data, ExchangeConnection> {
        private SyncLevel3EventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, SyncLevel3Data data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.synchronizeEventPrototypes(data.eventPrototypes);
        }
    }

    private class NodeDisconnectEventListener
    extends SpecialInternalEventListenerWithAck<FabricAddress, ExchangeConnection> {
        private NodeDisconnectEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, FabricAddress nodeAddress, ExchangeConnection connection) throws Exception {
            FabricNode removedNode;
            if (RuntimeExchange.this.nodeConnections.containsKey(nodeAddress)) {
                connection.isDisconnected = true;
            }
            if ((removedNode = RuntimeExchange.this.getFabricNode(nodeAddress)) != null) {
                this.setAcknowledgementParameters((byte)5, removedNode.getName());
                RuntimeExchange.this.removeFabricNode(removedNode, true, false);
                RuntimeExchange.this.scavenger.start();
            }
        }
    }

    private class NodeDisconnectConfirmEventListener
    extends AbstractExchange.InternalEventListener<String, ExchangeConnection> {
        private NodeDisconnectConfirmEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, String nodeName, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.disconnectedNodes.remove(nodeName);
            RuntimeExchange.this.sysplexSynchronizer.forcedCheckToken();
        }
    }

    private class NodeForcedDisconnectEventListener
    extends AbstractExchange.InternalEventListener<NodeForcedDisconnectEventData, ExchangeConnection> {
        private NodeForcedDisconnectEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, NodeForcedDisconnectEventData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.sysplexSynchronizer.startForcedDisconnect(data.routedTasks, data.joinInterrupted);
        }
    }

    private class NodeForcedDisconnectConfirmEventListener
    extends AbstractExchange.InternalEventListenerWithAck<Void, ExchangeConnection> {
        private NodeForcedDisconnectConfirmEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, Void data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.sysplexSynchronizer.forcedCheckToken();
            return RuntimeExchange.this.sysplexSynchronizer.isForcedDisconnectCompleted();
        }
    }

    private class AddRoutingLinkEventListener
    extends AbstractExchange.InternalEventListenerWithAck<RoutingTable.Link, ExchangeConnection> {
        private AddRoutingLinkEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, RoutingTable.Link link, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.routingTable.addLink(link);
        }
    }

    private class RemoveRoutingLinkEventListener
    extends AbstractExchange.InternalEventListenerWithAck<RoutingTable.Link, ExchangeConnection> {
        private RemoveRoutingLinkEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, RoutingTable.Link link, ExchangeConnection connection) throws Exception {
            if (link.equals(((NodeExchangeConnection)connection).routingLink)) {
                connection.isDisconnected = true;
            }
            RuntimeExchange.this.removeRoutingLink(link);
            RuntimeExchange.this.scavenger.start();
        }
    }

    private class AddEndpointEventListener
    extends AbstractExchange.InternalEventListenerWithAck<EndpointReferenceImpl, ExchangeConnection> {
        private AddEndpointEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, EndpointReferenceImpl reference, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode;
            if (RuntimeExchange.this.matchesClusterEventScope(reference) && (fabricNode = RuntimeExchange.this.getFabricNode(reference.getAddress())) != null) {
                if (reference instanceof NetworkExchangeConsumer) {
                    RuntimeExchange.this.addNetworkConsumer((NetworkExchangeConsumer)((Object)reference));
                }
                reference.bind(RuntimeExchange.this);
                fabricNode.addEndpoint(reference);
                if (reference instanceof ComponentReferenceImpl) {
                    RuntimeExchange.this.setLastAccessTimestamp((ComponentReferenceImpl)reference);
                }
                RuntimeExchange.this.notifyOnUpdate(8, reference, AbstractExchange.UpdateType.ADD, false);
            }
        }
    }

    private class RemoveEndpointEventListener
    extends AbstractExchange.InternalEventListenerWithAck<EndpointReferenceImpl, ExchangeConnection> {
        private RemoveEndpointEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, EndpointReferenceImpl reference, ExchangeConnection connection) throws Exception {
            if (RuntimeExchange.this.matchesClusterEventScope(reference)) {
                if (reference.getExchangeRole() == ExchangeRole.EVENT_CACHE && RuntimeExchange.this.isLocal(reference.address)) {
                    RuntimeExchange.this.networkDispatcher.removeConsumer((NetworkExchangeConsumer)((Object)reference));
                    RuntimeExchange.this.doRemoveEventCache(RuntimeExchange.this.node.removeEventCache((EventCacheReferenceImpl)reference));
                } else {
                    FabricNode fabricNode = RuntimeExchange.this.getFabricNode(reference.getAddress());
                    if (fabricNode != null) {
                        if (reference instanceof NetworkExchangeConsumer) {
                            RuntimeExchange.this.removeNetworkConsumer((NetworkExchangeConsumer)((Object)reference));
                        }
                        fabricNode.removeEndpoint(reference);
                    }
                }
                RuntimeExchange.this.notifyOnUpdate(9, reference, AbstractExchange.UpdateType.REMOVE, false);
            }
        }
    }

    private class AddComponentEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractExchange.ReAddComponentData, ExchangeConnection> {
        private AddComponentEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.ReAddComponentData data, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode;
            if (RuntimeExchange.this.matchesClusterEventScope(data.reference) && (fabricNode = RuntimeExchange.this.getFabricNode(data.reference.getAddress())) != null) {
                data.reference.bind(RuntimeExchange.this);
                fabricNode.addEndpoint(data.reference);
                this.doAddConsumers(data.reference, data.directConsumers, fabricNode);
                this.doAddConsumers(data.reference, data.asyncConsumers, fabricNode);
                this.doAddConsumers(data.reference, data.requestConsumers, fabricNode);
                this.doAddConsumers(data.reference, data.receivers, fabricNode);
                RuntimeExchange.this.setLastAccessTimestamp(data.reference);
                RuntimeExchange.this.notifyOnUpdate(10, data, data.reference.componentAddress, false, data.reference, AbstractExchange.UpdateType.ADD);
            }
        }

        private <T extends EndpointReferenceImpl> void doAddConsumers(ComponentReferenceImpl component, Map<String, T> consumers, FabricNode fabricNode) throws Exception {
            if (consumers != null) {
                for (EndpointReferenceImpl consumer : consumers.values()) {
                    if (consumer instanceof NetworkExchangeConsumer) {
                        RuntimeExchange.this.addNetworkConsumer((NetworkExchangeConsumer)((Object)consumer));
                    }
                    consumer.bind(RuntimeExchange.this);
                    fabricNode.addEndpoint(consumer);
                }
            }
        }
    }

    private class ChangeComponentEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractExchange.ChangeComponentData, ExchangeConnection> {
        private ChangeComponentEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.ChangeComponentData data, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = RuntimeExchange.this.getFabricNode(data.address);
            if (fabricNode != null) {
                RuntimeExchange.this.doChangeComponent(fabricNode.getComponent(data.address), data.type, data.parameter, false);
            }
        }
    }

    private class ChangeConsumerEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractExchange.ChangeConsumerData, ExchangeConnection> {
        private ChangeConsumerEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.ChangeConsumerData data, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = RuntimeExchange.this.getFabricNode(data.reference.getAddress());
            if (fabricNode != null) {
                EndpointReferenceImpl reference = RuntimeExchange.this.doChangeConsumer(fabricNode, data, false);
                if (data.deepChange && reference instanceof NetworkExchangeConsumer) {
                    RuntimeExchange.this.getNetworkDispatcher((NetworkExchangeConsumer)((Object)reference)).changeConsumer((NetworkExchangeConsumer)((Object)reference));
                }
            }
        }
    }

    private class ChangeEventCacheEventListener
    extends AbstractExchange.InternalEventListenerWithAck<EventCacheReferenceImpl, ExchangeConnection> {
        private ChangeEventCacheEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, EventCacheReferenceImpl reference, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = RuntimeExchange.this.getFabricNode(reference.getAddress());
            if (fabricNode != null) {
                RuntimeExchange.this.doChangeEventCache(fabricNode, reference, null, false);
            }
        }
    }

    private class AddDataConstraintEventListener
    extends AbstractExchange.InternalEventListenerWithAck<EntityReferenceImpl, ExchangeConnection> {
        private AddDataConstraintEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, EntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            reference = RuntimeExchange.this.createDataConstraintReferenceCreator(reference).create();
            RuntimeExchange.this.addDataConstraintReference(reference);
            RuntimeExchange.this.notifyOnUpdate(18, reference, AbstractExchange.UpdateType.ADD, false);
        }
    }

    private class RemoveDataConstraintEventListener
    extends AbstractExchange.InternalEventListenerWithAck<EntityReferenceImpl, ExchangeConnection> {
        private RemoveDataConstraintEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, EntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.removeDataConstraintFromStore(reference.getName(), reference.getExchangeRole());
            RuntimeExchange.this.removeDataConstraintReference(reference.getName(), reference.getExchangeRole());
            RuntimeExchange.this.notifyOnUpdate(19, reference, AbstractExchange.UpdateType.REMOVE, false);
        }
    }

    private class ChangeDataConstraintEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractFabricDataConstraint.Updater, ExchangeConnection> {
        private ChangeDataConstraintEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractFabricDataConstraint.Updater updater, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.doChangeDataConstraint(updater, null, false);
        }
    }

    private class UpdateGlobalVariablesEventListener
    extends AbstractExchange.InternalEventListenerWithAck<SysGlobals, ExchangeConnection> {
        private UpdateGlobalVariablesEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, SysGlobals data, ExchangeConnection connection) throws FabricException {
            RuntimeExchange.this.synchronizeSysGlobals(data, false);
        }
    }

    private class SetAnonymousRegistrationEventListener
    extends AbstractExchange.InternalEventListenerWithAck<Boolean, ExchangeConnection> {
        private SetAnonymousRegistrationEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, Boolean anonymousRegistration, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.doSetAnonymousRegistrationCore(anonymousRegistration);
        }
    }

    private class SetAnonymousUserEventListener
    extends AbstractExchange.InternalEventListenerWithAck<UserState, ExchangeConnection> {
        private SetAnonymousUserEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, UserState anonymousUser, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.doSetAnonymousUserCore(anonymousUser);
        }
    }

    private class RuntimeStartAcceptorEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractExchange.ChangeAcceptorData, AbstractExchange.AbstractExchangeConnection> {
        private RuntimeStartAcceptorEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.ChangeAcceptorData data, AbstractExchange.AbstractExchangeConnection connection) throws Exception {
            FabricNode fabricNode = RuntimeExchange.this.getFabricNode(data.nodeAddress);
            if (fabricNode != null) {
                fabricNode.addAcceptor(data.linkAddress);
                RuntimeExchange.this.notifyOnStartAcceptor(data, fabricNode.getName(), false);
            }
        }
    }

    private class RuntimeStopAcceptorEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractExchange.ChangeAcceptorData, AbstractExchange.AbstractExchangeConnection> {
        private RuntimeStopAcceptorEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.ChangeAcceptorData data, AbstractExchange.AbstractExchangeConnection connection) throws Exception {
            FabricNode fabricNode = RuntimeExchange.this.getFabricNode(data.nodeAddress);
            if (fabricNode != null) {
                fabricNode.removeAcceptor(data.linkAddress);
                RuntimeExchange.this.notifyOnStopAcceptor(data, fabricNode.getName(), false);
            }
        }
    }

    private class AddExtensionJarEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AddJarData, ExchangeConnection> {
        private AddExtensionJarEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AddJarData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.repositoryAccessor.doAddExtensionArchive(RuntimeExchange.this.getJarDir(data.jarDir), data.jarName);
            RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.EXT_ARCHIVE_ADDED, data.jarName);
        }
    }

    private class RemoveExtensionJarEventListener
    extends AbstractExchange.InternalEventListenerWithAck<RemoveExtensionJarData, ExchangeConnection> {
        private RemoveExtensionJarEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, RemoveExtensionJarData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.repositoryAccessor.doRemoveExtensionArchive(data.jarName, data.force);
            RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.EXT_ARCHIVE_REMOVED, data.jarName);
        }
    }

    private class AddJarEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AddJarData, ExchangeConnection> {
        private AddJarEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AddJarData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.repositoryAccessor.doAddArchive(RuntimeExchange.this.getJarDir(data.jarDir), data.jarName);
            RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.ARCHIVE_ADDED, data.jarName);
        }
    }

    private class RemoveJarEventListener
    extends AbstractExchange.InternalEventListenerWithAck<RemoveJarData, ExchangeConnection> {
        private RemoveJarEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, RemoveJarData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.repositoryAccessor.doRemoveArchive(data.jarName);
            RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.ARCHIVE_REMOVED, data.jarName);
        }
    }

    private class AddPackageEventListener
    extends AbstractExchange.InternalEventListenerWithAck<PackageData, ExchangeConnection> {
        private AddPackageEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, PackageData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.replacePackage(data);
            if (data.descriptor.isAutoload()) {
                RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_ADDED, CoherenceAgentAdvisoryType.PACKAGE_LOADED, data.descriptor.getFullName());
            } else {
                RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_ADDED, data.descriptor.getFullName());
            }
        }
    }

    private class RemovePackageEventListener
    extends AbstractExchange.InternalEventListenerWithAck<String, ExchangeConnection> {
        private RemovePackageEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, String pkgName, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.manifestManager.doRemovePackageCore(pkgName);
            RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_REMOVED, pkgName);
        }
    }

    private class LoadPackageEventListener
    extends AbstractExchange.InternalEventListenerWithAck<LoadPackageData, ExchangeConnection> {
        private LoadPackageEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, LoadPackageData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.manifestManager.doLoadPackageCore(data.pkg.getFullName(), data.checkDependencies);
            RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_LOADED, data.pkg.getFullName());
        }
    }

    private class UnloadPackageEventListener
    extends AbstractExchange.InternalEventListenerWithAck<Pair<String, Boolean>, ExchangeConnection> {
        private UnloadPackageEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, Pair<String, Boolean> data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.manifestManager.doUnloadPackageCore((String)data.first, (Boolean)data.second);
            RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_UNLOADED, (String)data.first);
        }
    }

    private class ValidatePackageEventListener
    extends AbstractExchange.InternalEventListenerWithAck<String, ExchangeConnection> {
        private ValidatePackageEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, String pkgName, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.manifestManager.doValidatePackageCore(pkgName);
        }
    }

    private class AddSemanticTypeEventListener
    extends AbstractExchange.InternalEventListenerWithAck<SemanticType, ExchangeConnection> {
        private AddSemanticTypeEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, SemanticType semanticType, ExchangeConnection connection) throws Exception {
            ((RuntimeSemanticTypeFactory)RuntimeExchange.this.context.semanticTypeFactory).doAddSemanticTypeCore(semanticType, false);
        }
    }

    private class RemoveSemanticTypeEventListener
    extends AbstractExchange.InternalEventListenerWithAck<RemoveSemanticTypeData, ExchangeConnection> {
        private RemoveSemanticTypeEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, RemoveSemanticTypeData data, ExchangeConnection connection) throws Exception {
            ((RuntimeSemanticTypeFactory)RuntimeExchange.this.context.semanticTypeFactory).doRemoveSemanticTypeCore(data.typeName, data.force, true);
        }
    }

    private class AddEventPrototypeEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractExchange.EventPrototypeData, ExchangeConnection> {
        private AddEventPrototypeEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.EventPrototypeData data, ExchangeConnection connection) throws Exception {
            FabricEventSourceFactoryImpl.resolveAnnotations(data.event);
            RuntimeExchange.this.addEventPrototype(data.prototype, data.event, false);
            RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.EVENT_PROTOTYPE_ADDED, data.event.getEventId());
        }
    }

    private class RemoveEventPrototypeEventListener
    extends AbstractExchange.InternalEventListenerWithAck<Pair<String, Boolean>, ExchangeConnection> {
        private RemoveEventPrototypeEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, Pair<String, Boolean> data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.removeEventPrototype((String)data.first, (Boolean)data.second);
            RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.EVENT_PROTOTYPE_REMOVED, (String)data.first);
        }
    }

    private class AddReplicationEntityEventListener
    extends AbstractExchange.InternalEventListenerWithAck<ReplicationEntityReferenceImpl, ExchangeConnection> {
        private AddReplicationEntityEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, ReplicationEntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = RuntimeExchange.this.getFabricNode(reference.getComponentAddress());
            if (fabricNode != null) {
                fabricNode.addReplicationEntity(reference);
                RuntimeExchange.this.notifyOnUpdate(24, reference, AbstractExchange.UpdateType.ADD, false);
            }
        }
    }

    private class RemoveReplicationEntityEventListener
    extends AbstractExchange.InternalEventListenerWithAck<ReplicationEntityReferenceImpl, ExchangeConnection> {
        private RemoveReplicationEntityEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, ReplicationEntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = RuntimeExchange.this.getFabricNode(reference.getComponentAddress());
            if (fabricNode != null) {
                fabricNode.removeReplicationEntity(reference);
                RuntimeExchange.this.notifyOnUpdate(25, reference, AbstractExchange.UpdateType.REMOVE, false);
            }
        }
    }

    private class ChangeReplicationEntityEventListener
    extends AbstractExchange.InternalEventListenerWithAck<ReplicationEntityReferenceImpl, ExchangeConnection> {
        private ChangeReplicationEntityEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, ReplicationEntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = RuntimeExchange.this.getFabricNode(reference.getComponentAddress());
            if (fabricNode != null) {
                fabricNode.changeReplicationEntity(reference);
                RuntimeExchange.this.notifyOnUpdate(26, reference, AbstractExchange.UpdateType.CHANGE, false);
            }
        }
    }

    private class AddTimeWindowEventListener
    extends AbstractExchange.InternalEventListenerWithAck<TimeWindow, ExchangeConnection> {
        private AddTimeWindowEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, TimeWindow window, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.schedulerImpl.doAddTimeWindow(window);
        }
    }

    private class RemoveTimeWindowEventListener
    extends AbstractExchange.InternalEventListenerWithAck<String, ExchangeConnection> {
        private RemoveTimeWindowEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, String windowName, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.schedulerImpl.doRemoveTimeWindow(windowName);
        }
    }

    private class ChangeTimeWindowEventListener
    extends AbstractExchange.InternalEventListenerWithAck<TimeWindow, ExchangeConnection> {
        private ChangeTimeWindowEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, TimeWindow window, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.schedulerImpl.doSetTimeWindow(window);
        }
    }

    private class TokenRestartEventListener
    extends AbstractExchange.InternalEventListenerWithAck<TokenRestartData, ExchangeConnection> {
        private TokenRestartEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, TokenRestartData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.sysplexSynchronizer.onTokenRestart(data.tokenId);
            if (data.startScavenger) {
                RuntimeExchange.this.scavenger.start();
            }
        }
    }

    private class TokenMonitorEventListener
    extends AbstractExchange.InternalEventListenerWithAck<TokenMonitorData, ExchangeConnection> {
        private TokenMonitorEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, TokenMonitorData data, ExchangeConnection connection) throws Exception {
            TokenMonitorResult result = new TokenMonitorResult(RuntimeExchange.this.sysplexSynchronizer.hasToken(data.tokenId), RuntimeExchange.this.sysplexSynchronizer.tokenReceiptTime, RuntimeExchange.this.sysplexSynchronizer.getTokenHoldingTime(), RuntimeExchange.this.sysplexSynchronizer.tokenSendingTime, RuntimeExchange.this.sysplexSynchronizer.getTokenAbsenceTime());
            if (data.action != TokenMonitorData.Action.STANDARD) {
                if (data.action == TokenMonitorData.Action.ADVISORY) {
                    RuntimeExchange.this.setExtendedData(result);
                } else {
                    result.parameters = RuntimeExchange.this.getDynamicParameters(false);
                }
            } else {
                RuntimeExchange.this.sysplexSynchronizer.resetTokenMonitor();
            }
            return result;
        }
    }

    private class UpdateDirectoryTableEventListener
    extends AbstractExchange.InternalEventListenerWithAck<DirectoryTable, ExchangeConnection> {
        private UpdateDirectoryTableEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, DirectoryTable table, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.updateDirectoryTable(table);
        }
    }

    private class CreateGroupEventListener
    extends AbstractExchange.InternalEventListenerWithAck<RuntimeFabricGroup, ExchangeConnection> {
        private CreateGroupEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, RuntimeFabricGroup group, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.groupManager.createGroup(group);
            RuntimeExchange.this.notifyOnCreateGroup(group, null, false);
        }
    }

    private class DropGroupEventListener
    extends AbstractExchange.InternalEventListenerWithAck<String, ExchangeConnection> {
        private DropGroupEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, String groupName, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.groupManager.removeGroup(groupName);
            RuntimeExchange.this.notifyOnDropGroup(groupName, null, false);
        }
    }

    private class AddGroupMemberEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractExchange.GroupMemberData, ExchangeConnection> {
        private AddGroupMemberEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.GroupMemberData data, ExchangeConnection connection) throws Exception {
            ComponentReferenceImpl component = (ComponentReferenceImpl)RuntimeExchange.this.moderator.lookupComponent(data.memberAddress);
            if (component != null) {
                RuntimeExchange.this.doAddGroupMember(data.groupName, component, false);
            }
        }
    }

    private class RemoveGroupMemberEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractExchange.GroupMemberData, ExchangeConnection> {
        private RemoveGroupMemberEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.GroupMemberData data, ExchangeConnection connection) throws Exception {
            ComponentReferenceImpl component = (ComponentReferenceImpl)RuntimeExchange.this.moderator.lookupComponent(data.memberAddress);
            if (component != null) {
                RuntimeExchange.this.doRemoveGroupMember(data.groupName, component, false);
            }
        }
    }

    private class SchedulerOperationEventListener
    extends UserInternalEventListenerWithAck<AbstractExchange.OperationData, ExchangeConnection> {
        private SchedulerOperationEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, AbstractExchange.OperationData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.invokeSchedulerOperation(data, connection, true);
        }
    }

    private class StatsMonitorOperationEventListener
    extends UserInternalEventListenerWithAck<AbstractExchange.OperationData, ExchangeConnection> {
        private StatsMonitorOperationEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, AbstractExchange.OperationData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.invokeStatsMonitorOperation(data, connection);
        }
    }

    private class SlangOperationEventListener
    extends UserInternalEventListenerWithAck<SlangData, ExchangeConnection> {
        private SlangOperationEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, SlangData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.invokeSlangRequest(data);
        }

        @Override
        void logReceived(FabricAddress sourceAddress, SlangData data) {
            if (!RuntimeExchange.suppressLog(data)) {
                RuntimeExchange.this.logDebug("SLANG broadcast operation '" + data.statement.getName() + "' (by user " + data.session.getOwnerName() + ") received from " + this.getNodeRecipient(sourceAddress));
            }
        }

        @Override
        void logReplied(SlangData data) {
        }
    }

    private class SetAdvancedParameterEventListener
    extends AbstractExchange.InternalEventListenerWithAck<SetAdvancedParameterData, ExchangeConnection> {
        private SetAdvancedParameterEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, SetAdvancedParameterData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.doSetAdvancedParameterCore(data.name, data.value, data.resolvedValue, sourceAddress);
        }
    }

    private class NodeDetachEventListener
    extends AbstractExchange.InternalEventListenerWithAck<NodeDetachData, ExchangeConnection> {
        private NodeDetachEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, NodeDetachData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.doDetachNodeCore(data.nodeAddress, data.startScavenger, false);
        }
    }

    private class SurveyEventListener
    extends AbstractExchange.InternalEventListenerWithAck<Void, ExchangeConnection> {
        private SurveyEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, Void data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.sysplexSynchronizer.checkState();
        }
    }

    private class RoutedContainerRequestEventListener
    extends UserInternalEventListenerWithAck<RoutedContainerRequestData, ExchangeConnection> {
        private RoutedContainerRequestEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, RoutedContainerRequestData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.context.container.invokeRoutedRequest(data.data, data.timeout);
        }
    }

    private class ApiKeyReplicationRequestEventListener
    extends AbstractExchange.InternalEventListener<AbstractApiKeyManager.ApiKeyReplicationRequestData, ExchangeConnection> {
        private ApiKeyReplicationRequestEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractApiKeyManager.ApiKeyReplicationRequestData data, ExchangeConnection connection) throws Exception {
            ((AbstractApiKeyManager)((Object)RuntimeExchange.this.context.getHTTPAuthenticationManager().getApiKeyManager())).invokeApiKeyReplicationRequest(data);
        }
    }

    private class ModeratorOperationEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractExchange.ModeratorOperationData, ExchangeConnection> {
        private ModeratorOperationEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, AbstractExchange.ModeratorOperationData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.invokeModeratorOperation(sourceAddress, data);
        }
    }

    private class CheckEventFlowsEventListener
    extends AbstractExchange.InternalEventListenerWithAck<String, ExchangeConnection> {
        private CheckEventFlowsEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, String eventId, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.doExistsEventFlows(eventId);
        }
    }

    private class SetTimezoneEventListener
    extends AbstractExchange.InternalEventListenerWithAck<String, ExchangeConnection> {
        private SetTimezoneEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, String timezone, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.doSetTimezone(timezone);
        }
    }

    private class GetSemanticTypeDependenciesEventListener
    extends AbstractExchange.InternalEventListenerWithAck<String, ExchangeConnection> {
        private GetSemanticTypeDependenciesEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, String typeName, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.getSemanticTypeDependencies(typeName, true);
        }
    }

    private class CheckSemanticTypeDependenciesEventListener
    extends AbstractExchange.InternalEventListenerWithAck<SemanticType, ExchangeConnection> {
        private CheckSemanticTypeDependenciesEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, SemanticType type, ExchangeConnection connection) throws Exception {
            return SemanticUtils.hasDependencies(type, RuntimeExchange.this.context, true);
        }
    }

    private class UpdateGlobalCounterEventListener
    extends AbstractExchange.InternalEventListenerWithAck<Long, ExchangeConnection> {
        private UpdateGlobalCounterEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, Long data, ExchangeConnection connection) throws FabricException {
            RuntimeExchange.this.doUpdateGlobalCounter(data);
        }
    }

    private class DropBoxTableSynchronizationEventListener
    extends AbstractExchange.InternalEventListener<DropBoxTableManager.DropBoxTableSynchronizationData, ExchangeConnection> {
        private DropBoxTableSynchronizationEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, DropBoxTableManager.DropBoxTableSynchronizationData data, ExchangeConnection connection) throws Exception {
            if (!RuntimeExchange.this.isJoinInProgress) {
                RuntimeExchange.this.context.getDropBoxManagerRemote().getDropBoxTableManager().invokeDropBoxTableSynchronizationRequest(data);
            }
        }
    }

    private class GetExclusionListEventListener
    extends AbstractExchange.InternalEventListenerWithAck<Void, ExchangeConnection> {
        private GetExclusionListEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, Void data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.doGetExclusionList();
        }
    }

    private class UpdatePackageEventListener
    extends AbstractExchange.InternalEventListenerWithAck<UpdatePackageData, ExchangeConnection> {
        private UpdatePackageEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, UpdatePackageData data, ExchangeConnection connection) throws Exception {
            if (data.isSetScope) {
                if (data.descriptor.isGlobal()) {
                    if (data.types != null) {
                        RuntimeExchange.this.replacePackage(data);
                        for (SemanticType type : data.types) {
                            ((RuntimeSemanticTypeFactory)RuntimeExchange.this.context.semanticTypeFactory).doAddSemanticTypeCore(type, true);
                        }
                    } else {
                        for (Map.Entry<Prototype, ImmutableEventDatagram> entry : data.prototypes.entrySet()) {
                            RuntimeExchange.this.addEventPrototype(entry.getKey(), entry.getValue(), false);
                        }
                    }
                } else {
                    RuntimeExchange.this.updatePackageScopeInRepository(data.descriptor, false);
                    RuntimeExchange.this.context.manifestManager.doSetPackageScopeCore(data.descriptor.getFullName(), false);
                }
            } else {
                RuntimeExchange.this.context.manifestManager.doUpdatePackage(data);
            }
            RuntimeExchange.this.onCoherenceUpdate(CoherenceAgentAdvisoryType.PACKAGE_UPDATED, RuntimeExchange.getPackageName(data.descriptor, data.pkg));
        }
    }

    private class JoinRequestListener
    extends AbstractExchange.InternalRequestListener<JoinData, ExchangeConnection> {
        private JoinRequestListener() {
            super(RuntimeExchange.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, JoinData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.logInfo("Node " + FabricNode.getPrintName(data.joiningNodeName) + " is attempting to join node " + this.getNodePrintName() + " in " + RuntimeExchange.this.getSysplexPrintName() + "...");
            JoinRequestListener joinRequestListener = this;
            synchronized (joinRequestListener) {
                if (!connection.isValid) {
                    throw new ExchangeException("Connection is not valid.");
                }
                if (RuntimeExchange.this.peerState == PeerState.UNDEFINED) {
                    RuntimeExchange.this.logWarning("Initialization of node " + this.getNodePrintName() + " still not completed.");
                    throw new ExchangeException(6014, "Initialization of node " + this.getNodePrintName() + " still not completed.");
                }
                if (RuntimeExchange.this.isJoinInProgress) {
                    throw new ExchangeException("Joining node " + this.getNodePrintName() + " to " + RuntimeExchange.this.getSysplexPrintName() + " is in progress.");
                }
                if (RuntimeExchange.this.isDetachInProgress) {
                    throw new ExchangeException("Detaching node " + this.getNodePrintName() + " from " + RuntimeExchange.this.getSysplexPrintName() + " is in progress.");
                }
            }
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.sysplexSynchronizer.invoke(ON_JOIN_REQUEST_METHOD, data, connection));
        }

        @Override
        String getNodeName(FabricAddress sourceAddress, JoinData data) {
            return data.joiningNodeName;
        }
    }

    private class SyncLevel1RequestListener
    extends AbstractJoinRequestListener<SyncLevel1Data, NodeExchangeConnection> {
        private SyncLevel1RequestListener() {
        }

        @Override
        AbstractExchange.InternalEvent doOnRequest(FabricAddress sourceAddress, SyncLevel1Data data, NodeExchangeConnection connection) throws Exception {
            connection.latency = data.latency;
            FabricNode joiningNode = (FabricNode)data.fabricNodes.get(0);
            try {
                RuntimeExchange.this.checkVersion(data.version, "node");
                RuntimeExchange.this.checkDomain(data.domain);
                RuntimeExchange.this.checkClusters(data.clusters);
                RuntimeExchange.this.checkNodeNames(data.fabricNodes);
                RuntimeExchange.this.checkDiscovery(data.discoveryModuleClass);
                RuntimeExchange.this.checkCoherence(data.coherenceEnabled);
                RuntimeExchange.this.checkTimezone(data.timezone);
                RuntimeExchange.this.checkSecurity(data, connection);
                RuntimeExchange.this.synchronizeClusterNumbers(data.clusters);
                Map<String, Short> nodeNumbers = RuntimeExchange.this.synchronizeNodeAddresses(data.fabricNodes);
                List<FabricGroup> sysplexGroups = RuntimeExchange.this.groupManager.getGroups();
                RuntimeExchange.this.synchronizeFabricGroups(data.fabricGroups);
                RuntimeExchange.this.synchronizeGlobalVariablesInSysplex(data.sysGlobals);
                DirectoryTable sysplexDirectoryTable = RuntimeExchange.this.synchronizeDirectoryTableInSysplex(data.directoryTable);
                Map<String, TimeWindow> sysplexTimeWindows = RuntimeExchange.this.getTimeWindowsCopy();
                RuntimeExchange.this.synchronizeTimeWindowsInSysplex(data.timeWindows, false);
                Map<String, DomainConstraintReferenceImpl> sysplexDomains = RuntimeExchange.this.getDomainConstraintsCopy();
                Map<String, RangeConstraintReferenceImpl> sysplexRanges = RuntimeExchange.this.getRangeConstraintsCopy();
                RuntimeExchange.this.synchronizeDataConstraintsInSysplex(data.domains, data.ranges, false);
                RuntimeExchange.this.synchronizeGlobalCounter(data.globalCounter);
                AbstractExchange.InternalEvent reply = RuntimeExchange.this.createSyncLevel1Reply(sysplexGroups, sysplexDirectoryTable, sysplexTimeWindows, sysplexDomains, sysplexRanges, nodeNumbers);
                RoutingTable.Link routingLink = RuntimeExchange.this.routingTable.makeLink(joiningNode, RuntimeExchange.this.node, connection);
                if (!RuntimeExchange.this.inSysplex()) {
                    RuntimeExchange.this.bindConnection(connection.getNetworkAddress(), joiningNode.getFabricAddress());
                    RuntimeExchange.this.addFabricNodes(data.fabricNodes, false);
                    data.routingLinks.add(routingLink);
                    RuntimeExchange.this.routingTable.addLinks(data.routingLinks);
                } else {
                    RuntimeExchange.this.addFabricNodeStep1(joiningNode);
                    RuntimeExchange.this.sysplexSynchronizer.joiningNode = joiningNode;
                }
                RuntimeExchange.this.peerState = PeerState.JOINED_SPX;
                return reply;
            }
            catch (Exception exception) {
                RuntimeExchange.this.sysplexSynchronizer.completeJoin(connection, false);
                throw exception;
            }
        }

        @Override
        String getNodeName(FabricAddress sourceAddress, SyncLevel1Data data) {
            return ((FabricNode)data.fabricNodes.get(0)).getName();
        }
    }

    private class SyncLevel2RequestListener
    extends AbstractJoinRequestListener<SyncLevel2Data, ExchangeConnection> {
        private SyncLevel2RequestListener() {
        }

        @Override
        AbstractExchange.InternalEvent doOnRequest(FabricAddress sourceAddress, SyncLevel2Data data, ExchangeConnection connection) throws Exception {
            SyncSemanticData replyData = new SyncSemanticData(data);
            FabricNode sourceNode = RuntimeExchange.this.getFabricNode(sourceAddress);
            File sourceNodeDir = new File(data.jarDir);
            RuntimeExchange.this.synchronizeExtJARs(data.extJARs, RuntimeExchange.this.sysplexSynchronizer.joinJarDir);
            replyData.extJARs = RuntimeExchange.this.getExtJARsForNode(data.requestedExtJARs, sourceNode, sourceNodeDir);
            RuntimeExchange.this.synchronizePackagesInSysplex(data, RuntimeExchange.this.sysplexSynchronizer.joinJarDir, true, sourceNode, sourceNodeDir);
            RuntimeExchange.this.synchronizeSemanticTypes(data.semanticTypes);
            replyData.semanticTypes = RuntimeExchange.this.getSemanticTypesForNode(data.requestedSemanticTypes);
            return RuntimeExchange.this.createInternalEvent(replyData);
        }
    }

    private class SyncLevel3RequestListener
    extends AbstractJoinRequestListener<SyncLevel3RequestData, ExchangeConnection> {
        private SyncLevel3RequestListener() {
        }

        @Override
        AbstractExchange.InternalEvent doOnRequest(FabricAddress sourceAddress, SyncLevel3RequestData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.synchronizeEventPrototypes(data.eventPrototypes);
            return RuntimeExchange.this.createInternalEvent(new SyncLevel3Data(RuntimeExchange.this.getEventPrototypesForNode(data.requestedEventPrototypes)));
        }
    }

    private class SyncForwardRequestListener
    extends AbstractJoinRequestListener<SyncForwardData, ExchangeConnection> {
        private SyncForwardRequestListener() {
        }

        @Override
        AbstractExchange.InternalEvent doOnRequest(FabricAddress sourceAddress, SyncForwardData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.doRemoveFabricNodeStep1((FabricNode)data.level12Data.fabricNodes.get(0));
            RuntimeExchange.this.copyJARsToAllNodes(RuntimeExchange.this.sysplexSynchronizer.joinJarDir);
            data.level12Data.semanticData.jarDir = RuntimeExchange.this.sysplexSynchronizer.joinJarDir.getName();
            RuntimeExchange.this.broadcastWithAckToNodes(109, data.level12Data, RuntimeExchange.this.longReplyTimeout);
            if (data.eventPrototypes != null) {
                RuntimeExchange.this.broadcastWithAckToNodes(105, new SyncLevel3Data(data.eventPrototypes), RuntimeExchange.this.longReplyTimeout);
            }
            RuntimeExchange.this.bindConnection(connection.getNetworkAddress(), ((FabricNode)data.level12Data.fabricNodes.get(0)).getFabricAddress());
            RuntimeExchange.this.addFabricNodes(data.level12Data.fabricNodes, false);
            RuntimeExchange.this.routingTable.addLinks(data.level12Data.routingLinks);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class EstablishConnectionRequestListener
    extends AbstractExchange.InternalRequestListener<RoutingTable.Link, ExchangeConnection> {
        private EstablishConnectionRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, RoutingTable.Link link, ExchangeConnection connection) throws FabricException {
            RuntimeExchange.this.bindConnection(connection, sourceAddress);
            ((NodeExchangeConnection)connection).bind(link);
            RuntimeExchange.this.logInfo("Peer link created: Node " + RuntimeExchange.this.node.getFullPrintName() + " <==> Node " + this.getNodePrintName(sourceAddress) + ", DIRECT.");
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ClientConnectRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.ClientConnectRequestData, ClientExchangeConnection> {
        private ClientConnectRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.ClientConnectRequestData data, ClientExchangeConnection connection) throws Exception {
            try {
                RuntimeExchange.this.waitForClientConnection();
                connection.isConnecting = true;
                connection.component = data.component;
                RuntimeExchange.this.checkVersion(data.version, "client");
                if (data.domain != null && !RuntimeExchange.this.context.domain.equals(data.domain) || data.fabricUid != null && !RuntimeExchange.this.fabricUid.equals(data.fabricUid)) {
                    throw new ExchangeException("Opening connections to several sysplexes is not allowed in one JVM.");
                }
                if (data.component.getName() == null) {
                    data.component.setAutogeneratedName(AbstractFabricConnectionFactory.getClientName(data.component.getType()), false);
                }
                if (!data.anonymous) {
                    connection.authenticate(data.userName, data.digest);
                    connection.initRepositoryAccessor();
                }
                if (data.reAddData != null) {
                    RuntimeExchange.this.reAddComponent(data.component, data.reAddData, connection);
                } else {
                    RuntimeExchange.this.addComponent((AbstractFabricComponent)data.component, ComponentModel.REMOTE_CLIENT);
                }
                RuntimeExchange.this.bindClientConnection(connection.getNetworkAddress(), data.component.getFabricAddress());
                AbstractExchange.ClientConnectReplyData replyData = new AbstractExchange.ClientConnectReplyData(RuntimeExchange.this.context.domain, RuntimeExchange.this.fabricUid, data.component, data.reAddData, connection.getUser(data.anonymous), RuntimeExchange.this.context.getHostTimezone(), RuntimeExchange.this.context.getNodeTimezone(), RuntimeExchange.this.context.getCCSID());
                if (!data.anonymous) {
                    replyData.fabricNodes = RuntimeExchange.this.getFabricNodesForReply(true);
                    replyData.fabricGroups = RuntimeExchange.this.groupManager.getGroups();
                    replyData.domainConstraints = RuntimeExchange.this.globalDomainConstraints;
                    replyData.rangeConstraints = RuntimeExchange.this.globalRangeConstraints;
                }
                if (data.forSlangTool) {
                    replyData.banner = Banner.getBanner();
                    if (data.anonymous) {
                        replyData.nodeName = RuntimeExchange.this.node.getName();
                    }
                }
                return RuntimeExchange.this.createInternalEvent(replyData);
            }
            catch (Exception exception) {
                RuntimeExchange.this.notifyOnClientConnectionCompletion();
                connection.isConnecting = false;
                throw exception;
            }
        }
    }

    private class ClientConnectConfirmRequestListener
    extends AbstractExchange.InternalRequestListener<Boolean, ClientExchangeConnection> {
        private ClientConnectConfirmRequestListener() {
            super(RuntimeExchange.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, Boolean reconnect, ClientExchangeConnection connection) throws FabricException {
            try {
                connection.isValid = true;
                RuntimeExchange.this.onSysplexUpdate(reconnect != false ? ModeratorAdvisoryType.CLIENT_RECONNECTED : ModeratorAdvisoryType.CLIENT_CONNECTED, connection.component.getFullName());
                RuntimeExchange.this.processClientThreshold("TLP", RuntimeExchange.this.clientConnections.size());
                RuntimeExchange.this.logInfo("Remote client '" + connection.component.getFullName() + "' [" + String.valueOf(connection.networkConnection) + "] connected.");
                AbstractExchange.EmptyEvent emptyEvent = AbstractExchange.EmptyEvent.defaultInstance;
                return emptyEvent;
            }
            finally {
                RuntimeExchange.this.notifyOnClientConnectionCompletion();
                connection.isConnecting = false;
            }
        }
    }

    private class ClientDisconnectRequestListener
    extends AbstractExchange.InternalRequestListener<Void, ClientExchangeConnection> {
        private ClientDisconnectRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, Void data, ClientExchangeConnection connection) throws Exception {
            RuntimeExchange.this.removeClient(connection.address, false);
            RuntimeExchange.this.logInfo("Remote client '" + connection.component.getFullName() + "' [" + String.valueOf(connection.networkConnection) + "] disconnected.");
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ClientAddEndpointRequestListener
    extends AbstractExchange.InternalRequestListener<EndpointReferenceImpl, ClientExchangeConnection> {
        private ClientAddEndpointRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, EndpointReferenceImpl endpoint, ClientExchangeConnection connection) throws Exception {
            connection.addClientEndpoint(endpoint);
            return RuntimeExchange.this.createInternalEvent(endpoint.address);
        }
    }

    private class ClientRemoveEndpointRequestListener
    extends AbstractExchange.InternalRequestListener<EndpointReferenceImpl, ClientExchangeConnection> {
        private ClientRemoveEndpointRequestListener(RuntimeExchange runtimeExchange) {
            super(runtimeExchange);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, EndpointReferenceImpl endpoint, ClientExchangeConnection connection) throws Exception {
            connection.removeClientEndpoint(endpoint, true);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ClientChangeComponentRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.ChangeComponentData, ExchangeConnection> {
        private ClientChangeComponentRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.ChangeComponentData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.changeComponent(RuntimeExchange.this.node.getComponent(data.address), data.type, data.parameter);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ClientChangeConsumerRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.ChangeConsumerData, ExchangeConnection> {
        private ClientChangeConsumerRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.ChangeConsumerData data, ExchangeConnection connection) throws Exception {
            EndpointReferenceImpl reference = RuntimeExchange.this.changeConsumer(data);
            if (data.deepChange) {
                RuntimeExchange.this.getClientDispatcher((NetworkExchangeConsumer)((Object)reference)).changeConsumer((NetworkExchangeConsumer)((Object)reference));
            }
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ClientAddDataConstraintRequestListener
    extends AbstractExchange.InternalRequestListener<EntityReferenceImpl, ExchangeConnection> {
        private ClientAddDataConstraintRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, EntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.addDataConstraint(RuntimeExchange.this.createDataConstraintReferenceCreator(reference));
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ClientRemoveDataConstraintRequestListener
    extends AbstractExchange.InternalRequestListener<EntityReferenceImpl, ExchangeConnection> {
        private ClientRemoveDataConstraintRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, EntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.removeDataConstraint(reference.getName(), reference.getExchangeRole(), sourceAddress);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ClientChangeDataConstraintRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractFabricDataConstraint.Updater, ExchangeConnection> {
        private ClientChangeDataConstraintRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractFabricDataConstraint.Updater updater, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.changeDataConstraint(updater, sourceAddress);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class NodeGetCachedEventsRequestListener
    extends AbstractExchange.InternalRequestListener<CompositeFilter, ExchangeConnection> {
        private NodeGetCachedEventsRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, CompositeFilter filter, ExchangeConnection connection) throws FabricException {
            List<ImmutableEventDatagram> cachedEvents = RuntimeExchange.this.dispatcher.getCachedEvents(filter, ExchangeEventDispatcher.CachedEvent.Scope.NETWORK);
            return RuntimeExchange.this.createInternalEvent(cachedEvents);
        }
    }

    private class ClientGetCachedEventsRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.ClientGetCachedEventsRequestData, ExchangeConnection> {
        private ClientGetCachedEventsRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.ClientGetCachedEventsRequestData data, ExchangeConnection connection) throws FabricException {
            List<ImmutableEventDatagram> cachedEvents = RuntimeExchange.this.requestCachedEvents(data.filter);
            cachedEvents.addAll(RuntimeExchange.this.dispatcher.getCachedEvents(data.filter, data.scope == EventScope.OBSERVABLE ? ExchangeEventDispatcher.CachedEvent.Scope.OBSERVABLE : ExchangeEventDispatcher.CachedEvent.Scope.GLOBAL));
            return RuntimeExchange.this.createInternalEvent(cachedEvents);
        }
    }

    private class PingRequestListener
    extends AbstractExchange.InternalRequestListener<String, ExchangeConnection> {
        private PingRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, String version, ExchangeConnection connection) throws FabricException {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.context.ping(version));
        }
    }

    private class IsSecurityEnabledRequestListener
    extends AbstractExchange.InternalRequestListener<Void, ExchangeConnection> {
        private IsSecurityEnabledRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, Void data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.context.isSecurityEnabled());
        }
    }

    private class RepositoryAccessorRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.OperationData, ExchangeConnection> {
        private RepositoryAccessorRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.OperationData data, ExchangeConnection connection) throws FabricException {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.invokeRepositoryOperation(data, connection));
        }
    }

    private class GetManagementNodeObjectRequestListener
    extends AbstractExchange.InternalRequestListener<Void, ExchangeConnection> {
        private GetManagementNodeObjectRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, Void data, ExchangeConnection connection) throws Exception {
            try {
                ManagementNode result = (ManagementNode)RepositoryUtils.lookupObject("sys/mf", "ManagementNode");
                return RuntimeExchange.this.createInternalEvent(result);
            }
            catch (ObjectConfigurationException exception) {
                throw new ExchangeException("Obtaining ManagementNode object from Repository failed.", (Throwable)exception);
            }
        }
    }

    private class ExportSemanticTypeRequestListener
    extends AbstractExchange.InternalRequestListener<SemanticType, ExchangeConnection> {
        private ExportSemanticTypeRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, SemanticType semanticType, ExchangeConnection connection) throws Exception {
            try {
                RuntimeExchange.this.context.semanticTypeFactory.addSemanticType(semanticType);
                return AbstractExchange.EmptyEvent.defaultInstance;
            }
            catch (SemanticTypeFactoryException exception) {
                throw new ExchangeException(exception);
            }
        }
    }

    private class ImportSemanticTypeRequestListener
    extends AbstractExchange.InternalRequestListener<Pair<String, Map<String, Long>>, ExchangeConnection> {
        private ImportSemanticTypeRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, Pair<String, Map<String, Long>> data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.invokeImportSemanticTypeRequest((String)data.first, (Map)data.second));
        }
    }

    private class ExportEventPrototypeRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.EventPrototypeData, ExchangeConnection> {
        private ExportEventPrototypeRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.EventPrototypeData data, ExchangeConnection connection) throws Exception {
            FabricEventSourceFactoryImpl.resolveAnnotations(data.event);
            RuntimeExchange.this.addEventPrototype(data.prototype, data.event, true);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ImportEventPrototypeRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.ImportEventPrototypeData, ExchangeConnection> {
        private ImportEventPrototypeRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.ImportEventPrototypeData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.invokeImportEventPrototypeRequest(data));
        }
    }

    private class EventCacheOperationRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.EndpointOperationData, ExchangeConnection> {
        private EventCacheOperationRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.EndpointOperationData data, ExchangeConnection connection) throws Exception {
            EventCacheReferenceImpl reference = RuntimeExchange.this.node.getEventCache(data.address);
            if (data.methodName.equals("setMaxSize")) {
                reference.doSetMaxSize((Integer)data.parameters[0], connection instanceof ClientExchangeConnection ? sourceAddress : null);
                return AbstractExchange.EmptyEvent.defaultInstance;
            }
            try {
                Method method = EventCacheReferenceImpl.class.getDeclaredMethod(data.methodName, data.parameterTypes);
                return RuntimeExchange.this.createInternalEvent(method.invoke((Object)reference, data.parameters));
            }
            catch (Throwable exception) {
                if (exception instanceof InvocationTargetException) {
                    exception = exception.getCause();
                }
                if (exception instanceof FabricEventDispatcherException) {
                    throw (FabricEventDispatcherException)exception;
                }
                throw new ExchangeException("Processing of internal request [" + RuntimeExchange.this.getInternalEventName(42) + "] failed." + String.valueOf(exception));
            }
        }
    }

    private class EventConsumerOperationRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.EndpointOperationData, ExchangeConnection> {
        private EventConsumerOperationRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.EndpointOperationData data, ExchangeConnection connection) throws Exception {
            EventConsumerReferenceImpl reference = (EventConsumerReferenceImpl)RuntimeExchange.this.node.lookupEventConsumer(data.address);
            try {
                Method method = ClassUtils.getDeclaredOrInheritedMethod(reference.getClass(), data.methodName, data.parameterTypes, false);
                return RuntimeExchange.this.createInternalEvent(method.invoke((Object)reference, data.parameters));
            }
            catch (Throwable exception) {
                if (exception instanceof InvocationTargetException) {
                    exception = exception.getCause();
                }
                if (exception instanceof FabricEventDispatcherException) {
                    throw (FabricEventDispatcherException)exception;
                }
                throw new ExchangeException("Processing of internal request [" + RuntimeExchange.this.getInternalEventName(41) + "] failed." + String.valueOf(exception));
            }
        }
    }

    private class SchedulerOperationRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.OperationData, ExchangeConnection> {
        private SchedulerOperationRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.OperationData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.invokeSchedulerOperation(data, connection, false));
        }
    }

    private class ClientCreateGroupRequestListener
    extends AbstractExchange.InternalRequestListener<FabricGroup, ExchangeConnection> {
        private ClientCreateGroupRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, FabricGroup group, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.createGroup((String)group.getName(), (String)group.getDescription(), (FabricAddress)connection.address).uid);
        }
    }

    private class ClientDropGroupRequestListener
    extends AbstractExchange.InternalRequestListener<String, ExchangeConnection> {
        private ClientDropGroupRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, String groupName, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.dropGroup(groupName, connection.address);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ClientAddGroupMemberRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.GroupMemberData, ExchangeConnection> {
        private ClientAddGroupMemberRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.GroupMemberData data, ExchangeConnection connection) throws Exception {
            ComponentReferenceImpl component = (ComponentReferenceImpl)RuntimeExchange.this.moderator.lookupComponent(data.memberAddress);
            if (component != null) {
                RuntimeExchange.this.addGroupMember(data.groupName, component, true);
            }
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ClientRemoveGroupMemberRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.GroupMemberData, ExchangeConnection> {
        private ClientRemoveGroupMemberRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.GroupMemberData data, ExchangeConnection connection) throws Exception {
            ComponentReferenceImpl component = (ComponentReferenceImpl)RuntimeExchange.this.moderator.lookupComponent(data.memberAddress);
            if (component != null) {
                RuntimeExchange.this.removeGroupMember(data.groupName, component, true);
            }
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class SlangOperationRequestListener
    extends AbstractExchange.InternalRequestListener<SlangData, ExchangeConnection> {
        private SlangOperationRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, SlangData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.invokeSlangRequest(data));
        }

        @Override
        void logReceived(FabricAddress sourceAddress, SlangData data) {
            if (!RuntimeExchange.suppressLog(data)) {
                RuntimeExchange.this.logDebug("SLANG operation '" + data.statement.getName() + "' (by user " + data.session.getOwnerName() + ") received from " + this.getNodeRecipient(sourceAddress));
            }
        }

        @Override
        void logReplied(SlangData data) {
        }
    }

    private class CreateFactoryConnectionComponentRequestListener
    extends AbstractExchange.InternalRequestListener<DynamicComponentsManager.ComponentData, ExchangeConnection> {
        private CreateFactoryConnectionComponentRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, DynamicComponentsManager.ComponentData data, ExchangeConnection connection) throws Exception {
            try {
                AbstractDynamicFabricComponent component = RuntimeExchange.this.context.getDynamicComponentsManager().createComponent(data);
                return RuntimeExchange.this.createInternalEvent(((AbstractFabricComponent)component).getName());
            }
            catch (Exception exception) {
                throw new ExchangeException(exception);
            }
        }
    }

    private class FactoryConnectionComponentAccessorCreatedRequestListener
    extends AbstractExchange.InternalRequestListener<DynamicComponentsManager.AccessorData, ExchangeConnection> {
        private FactoryConnectionComponentAccessorCreatedRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, DynamicComponentsManager.AccessorData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.context.getDynamicComponentsManager().onAccessorCreated(data);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class TokenRestartRequestListener
    extends AbstractExchange.InternalRequestListener<String, ExchangeConnection> {
        private TokenRestartRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, String message, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.logInfo("Token is lost in " + this.getNodeRecipient(sourceAddress) + " Cause: " + message);
            RuntimeExchange.this.resync(true);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class ModeratorOperationRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.ModeratorOperationData, ExchangeConnection> {
        private ModeratorOperationRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.ModeratorOperationData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.invokeModeratorOperation(sourceAddress, data));
        }
    }

    private class RoutedContainerRequestRequestListener
    extends AbstractExchange.InternalRequestListener<RoutedContainerRequestData, ExchangeConnection> {
        private RoutedContainerRequestRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, RoutedContainerRequestData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.context.container.invokeRoutedRequest(data.data, data.timeout));
        }
    }

    private class CloseAccessorsRequestListener
    extends AbstractExchange.InternalRequestListener<List<String>, ExchangeConnection> {
        private CloseAccessorsRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, List<String> accessors, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.doCloseAccessors(accessors, true);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class GlobalCounterOperationRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.GlobalCounterOperation, ExchangeConnection> {
        private GlobalCounterOperationRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.GlobalCounterOperation operation, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.createInternalEvent(this.doInvoke(operation));
        }

        private long doInvoke(AbstractExchange.GlobalCounterOperation operation) {
            switch (operation) {
                case NEXT: {
                    return RuntimeExchange.this.nextGlobalCount();
                }
                case SHOW: {
                    return RuntimeExchange.this.showGlobalCounter();
                }
                case RESET: {
                    return RuntimeExchange.this.resetGlobalCounterNoCheck();
                }
            }
            return -1L;
        }
    }

    private class DropBoxTableSynchronizationRequestListener
    extends AbstractExchange.InternalRequestListener<DropBoxTableManager.DropBoxTableSynchronizationData, ExchangeConnection> {
        private DropBoxTableSynchronizationRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, DropBoxTableManager.DropBoxTableSynchronizationData data, ExchangeConnection connection) throws Exception {
            Object result = RuntimeExchange.this.context.getDropBoxManagerRemote().getDropBoxTableManager().invokeDropBoxTableSynchronizationRequest(data);
            return RuntimeExchange.this.createInternalEvent(result);
        }
    }

    private class SecurityUpdateEventListener
    extends AbstractExchange.InternalEventListenerWithAck<AbstractExchange.OperationData, ExchangeConnection> {
        private SecurityUpdateEventListener() {
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.OperationData data, ExchangeConnection connection) throws Exception {
            RuntimeExchange.this.invokeSecurityOperation(data, connection, true);
        }
    }

    private class IsOwnerActiveEventListener
    extends AbstractExchange.InternalEventListenerWithAck<String, ExchangeConnection> {
        private IsOwnerActiveEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, String ownerName, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.context.securityManagerImpl.hasSecurityContext(ownerName);
        }
    }

    private class GetOwnerComponentsEventListener
    extends AbstractExchange.InternalEventListenerWithAck<String, ExchangeConnection> {
        private GetOwnerComponentsEventListener() {
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, String ownerName, ExchangeConnection connection) throws Exception {
            SecurityContext securityContext = RuntimeExchange.this.context.securityManagerImpl.getSecurityContext(ownerName);
            return securityContext != null ? securityContext.listBoundComponents() : null;
        }
    }

    private class SecurityManagerOperationRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.OperationData, ExchangeConnection> {
        private SecurityManagerOperationRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.OperationData data, ExchangeConnection connection) throws Exception {
            return RuntimeExchange.this.createInternalEvent(RuntimeExchange.this.invokeSecurityOperation(data, connection, false));
        }
    }

    private class AnonymousRegistrationRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.AnonymousRegistrationRequestData, ExchangeConnection> {
        RuntimeSecurityManagerProxy securityManager;

        private AnonymousRegistrationRequestListener() {
            super(RuntimeExchange.this);
            this.securityManager = new RuntimeSecurityManagerProxy(RuntimeExchange.this.context.securityManagerImpl);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.AnonymousRegistrationRequestData data, ExchangeConnection connection) throws Exception {
            StructuredDataObject result;
            try {
                result = !RuntimeExchange.this.acceptorFactory.lookupAcceptor(connection.getAcceptorName()).anonymousRegistration() ? new SecurityManagerException(6083, "Anonymous Registration is Currently Unavailable.") : this.securityManager.createUser(data.userName, data.password, data.description, data.vcard);
            }
            catch (SecurityManagerException exception) {
                result = exception;
            }
            return RuntimeExchange.this.createInternalEvent(result);
        }
    }

    private class DropBoxItemJoinToMNodeRequestListener
    extends AbstractExchange.InternalRequestListener<DropBoxTableManager.DropBoxTableSynchronizationData, ExchangeConnection> {
        private DropBoxItemJoinToMNodeRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, DropBoxTableManager.DropBoxTableSynchronizationData data, ExchangeConnection connection) throws Exception {
            Object result = RuntimeExchange.this.context.getDropBoxManagerRemote().getDropBoxTableManager().invokeDropBoxTableSynchronizationRequest(data);
            return RuntimeExchange.this.createInternalEvent(result);
        }
    }

    private abstract class ExchangeConnection
    extends AbstractExchange.AbstractExchangeConnection {
        RuntimeSecurityManagerProxy securityManager;
        RuntimeRepositoryAccessorImpl repositoryAccessor;
        private static final int TOKEN_PACKET_HEADER_SIZE = 7;

        ExchangeConnection(Connection networkConnection) {
            super(networkConnection);
        }

        String getAcceptorName() {
            return this.networkConnection.getAcceptorName();
        }

        void initRepositoryAccessor() {
            this.repositoryAccessor = new RuntimeRepositoryAccessorImpl(null, this.securityManager != null ? this.securityManager.getCurrentUserName() : null, RuntimeExchange.this.moderator.getFabricNode(), RuntimeExchange.this.context);
        }

        void raiseTokenEvent(FabricAddress address, byte[] tokenBytes) throws FabricException {
            ByteBuffer tokenBuffer = ByteBuffer.allocate(7 + tokenBytes.length);
            this.raiseInternalEvent(tokenBuffer.put((byte)6).put(address.toBinary()).put(tokenBytes).array());
        }

        void raiseTokenRequest(FabricAddress address, byte[] tokenBytes) throws FabricException, TimeoutException {
            ByteBuffer tokenBuffer = ByteBuffer.allocate(7 + tokenBytes.length);
            this.raiseRequest(tokenBuffer.put(address.toBinary()).put((byte)6).put(tokenBytes).array(), RuntimeExchange.this.fastReplyTimeout);
        }

        @Override
        void raiseInternalEvent(ByteBuffer packet) throws FabricException {
            if (this.isValid) {
                super.raiseInternalEvent(packet);
            }
        }

        @Override
        ImmutableEventDatagram raiseRequest(byte[] packet, long timeout) throws FabricException, TimeoutException {
            this.checkValidity();
            return super.raiseRequest(packet, timeout);
        }

        @Override
        ImmutableEventDatagram raiseRequestDirect(Pair<Long, ByteBuffer> packet, long timeout) throws FabricException, TimeoutException {
            this.checkValidity();
            return super.raiseRequestDirect(packet, timeout);
        }

        @Override
        byte[] raiseRoutedRequest(byte[] packet, long timeout) throws FabricException, TimeoutException {
            this.checkValidity();
            return super.raiseRoutedRequest(packet, timeout);
        }

        void publish(byte[] packet) throws FabricException {
            this.checkValidity();
            this.networkConnection.publish(packet);
        }

        @Override
        byte[] publishRoutedRequest(byte[] packet) throws FabricException {
            this.checkValidity();
            return super.publishRoutedRequest(packet);
        }

        void checkValidity() throws ExchangeException {
            if (!this.isValid) {
                throw new ExchangeException("Connection '" + this.networkConnection.toString() + "' is not valid.");
            }
        }

        public String toString() {
            return "(" + String.valueOf(this.address) + ")";
        }

        abstract class AbstractPacketHandler
        implements PacketHandler {
            AbstractPacketHandler() {
            }

            @Override
            public void onPacket(byte[] packet) {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(packet);
                    byte eventType = buffer.get();
                    if (eventType == 7) {
                        ExchangeConnection.this.onLatencyRequest();
                    } else if (eventType == 8) {
                        ExchangeConnection.this.onLatencyReply();
                    } else if (eventType == 2) {
                        this.onBroadcastEvent(buffer, false, false);
                    } else if (eventType == 3) {
                        this.onBroadcastEvent(buffer, true, false);
                    } else if (eventType == 4) {
                        this.onBroadcastEvent(buffer, true, true);
                    } else if (eventType == 5) {
                        String nodeName = new String(ExchangeConnection.this.unpackObjectBytes(buffer));
                        if (RuntimeExchange.this.node.getName().equals(nodeName)) {
                            RuntimeExchange.this.onInternalEvent(this.getAddress(buffer, true), ExchangeConnection.this.unpackInternalEvent(buffer), ExchangeConnection.this);
                        } else {
                            ((ExchangeConnection)RuntimeExchange.this.disconnectedNodes.get((Object)nodeName).second).raiseInternalEvent(packet);
                        }
                    } else {
                        FabricAddress consumerAddress = this.getAddress(buffer, eventType == 1);
                        if (consumerAddress.isNull() || consumerAddress.equals(RuntimeExchange.this.node.getFabricAddress())) {
                            if (eventType == 6) {
                                RuntimeExchange.this.sysplexSynchronizer.onToken(buffer);
                            } else {
                                RuntimeExchange.this.onInternalEvent(this.getAddress(buffer, eventType == 1), ExchangeConnection.this.unpackInternalEvent(buffer), ExchangeConnection.this);
                            }
                        } else if (RuntimeExchange.this.isLocal(consumerAddress)) {
                            RuntimeExchange.this.raiseDirectEventLocal(consumerAddress, ExchangeConnection.this.unpackEvent(buffer));
                        } else {
                            RuntimeExchange.this.getConnection((FabricAddress)consumerAddress).networkConnection.send(packet);
                        }
                    }
                }
                catch (Throwable exception) {
                    RuntimeExchange.this.onError(exception, "Packet processing failed.");
                }
            }

            private FabricAddress getAddress(ByteBuffer buffer, boolean special) throws Exception {
                if (special) {
                    FabricNode fabricNode;
                    String nodeName = new String(ExchangeConnection.this.unpackObjectBytes(buffer));
                    FabricNode fabricNode2 = fabricNode = RuntimeExchange.this.node.getName().equals(nodeName) ? RuntimeExchange.this.node : RuntimeExchange.this.getFabricNode(nodeName);
                    if (fabricNode == null) {
                        throw new ExchangeException("Node " + FabricNode.getPrintName(nodeName) + " not found.");
                    }
                    return fabricNode.getFabricAddress();
                }
                return ExchangeConnection.this.unpackAddress(buffer);
            }

            private void onBroadcastEvent(ByteBuffer buffer, boolean special, boolean disconnect) throws Exception {
                FabricNode sourceNode;
                if (special) {
                    Pair<FabricNode, ExchangeConnection> pair;
                    String sourceNodeName = new String(ExchangeConnection.this.unpackObjectBytes(buffer));
                    sourceNode = RuntimeExchange.this.getFabricNode(sourceNodeName);
                    if (sourceNode == null && disconnect && (pair = RuntimeExchange.this.disconnectedNodes.get(sourceNodeName)) != null) {
                        sourceNode = (FabricNode)pair.first;
                    }
                } else {
                    sourceNode = RuntimeExchange.this.getFabricNode(ExchangeConnection.this.unpackAddress(buffer));
                }
                if (sourceNode != null && sourceNode.isNewBroadcastEvent(buffer.getLong())) {
                    if (disconnect && !RuntimeExchange.this.disconnectedNodes.containsKey(sourceNode.getName())) {
                        RuntimeExchange.this.disconnectedNodes.put(sourceNode.getName(), new Pair<FabricNode, ExchangeConnection>(sourceNode, ExchangeConnection.this));
                    }
                    for (ExchangeConnection exchangeConnection : RuntimeExchange.this.nodeConnections.values()) {
                        if (exchangeConnection.equals(ExchangeConnection.this) || exchangeConnection.isDisconnected) continue;
                        exchangeConnection.raiseInternalEvent(buffer.array());
                    }
                    RuntimeExchange.this.onInternalEvent(sourceNode.getFabricAddress(), ExchangeConnection.this.unpackInternalEvent(buffer), ExchangeConnection.this);
                }
            }

            private FabricNode getSourceNode(ByteBuffer buffer, boolean special) throws Exception {
                return special ? RuntimeExchange.this.getFabricNode(new String(ExchangeConnection.this.unpackObjectBytes(buffer))) : RuntimeExchange.this.getFabricNode(ExchangeConnection.this.unpackAddress(buffer));
            }

            @Override
            public ByteBuffer onRequest(long requestId, byte[] packet, long timeout) throws FabricException {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(packet);
                    FabricAddress consumerAddress = ExchangeConnection.this.unpackAddress(buffer);
                    if (consumerAddress.isNull() || consumerAddress.equals(RuntimeExchange.this.node.getFabricAddress())) {
                        byte eventType = buffer.get();
                        if (eventType == 6) {
                            RuntimeExchange.this.sysplexSynchronizer.onToken(buffer);
                            return ExchangeConnection.this.packReply(requestId, AbstractExchange.EmptyEvent.defaultInstance);
                        }
                        if (eventType == 10) {
                            return ExchangeConnection.this.packReply(requestId, AbstractExchange.EmptyEvent.defaultInstance);
                        }
                        return ExchangeConnection.this.packReply(requestId, RuntimeExchange.this.onInternalRequest(ExchangeConnection.this.unpackAddress(buffer), ExchangeConnection.this.unpackInternalEvent(buffer), ExchangeConnection.this));
                    }
                    if (RuntimeExchange.this.isLocal(consumerAddress)) {
                        AbstractExchange.ClientRequestConsumer consumer = RuntimeExchange.this.clientDispatcher.getRequestConsumer(consumerAddress);
                        return consumer != null ? ExchangeConnection.this.packReply(requestId, consumer.raiseRoutedRequest(packet, timeout)) : ExchangeConnection.this.packReply(requestId, RuntimeExchange.this.raiseRequestLocal(consumerAddress, ExchangeConnection.this.unpackEvent(buffer)));
                    }
                    return ExchangeConnection.this.packReply(requestId, RuntimeExchange.this.getConnection(consumerAddress).raiseRoutedRequest(packet, timeout));
                }
                catch (Throwable exception) {
                    if (!(exception instanceof ExchangeException) || !((ExchangeException)exception).isWrapper() && ((ExchangeException)exception).getErrorCode() != 6014) {
                        if (exception instanceof SecurityManagerException && ((SecurityManagerException)exception).getErrorCode() == 6084) {
                            RuntimeExchange.this.logInfo(exception.toString());
                        } else {
                            RuntimeExchange.this.logException(exception, !(exception instanceof ExchangeException));
                        }
                    }
                    return ExchangeConnection.this.packReply(requestId, new FabricEventSourceException(6043, "Network request processing failed.", exception));
                }
            }
        }
    }

    private static class SyncLevel1Data
    extends AbstractSyncData {
        int latency;
        AbstractExchange.VersionData version;
        String domain;
        List<String> clusters;
        String discoveryModuleClass;
        boolean coherenceEnabled;
        String timezone;
        String authenticationModuleClass;
        String userName;
        String digest;
        boolean presence;
        private boolean anonymousRegistration;
        private boolean webAppTokenAuthentication;

        SyncLevel1Data(List<FabricNode> fabricNodes, List<FabricGroup> fabricGroups, List<RoutingTable.Link> routingLinks, SysGlobals sysGlobals, DirectoryTable directoryTable, Map<String, TimeWindow> timeWindows, Map<String, DomainConstraintReferenceImpl> domains, Map<String, RangeConstraintReferenceImpl> ranges, long globalCounter) {
            super(fabricNodes, fabricGroups, routingLinks, sysGlobals, directoryTable, timeWindows, domains, ranges, globalCounter);
        }
    }

    private static class SyncLevel1ReplyData
    extends AbstractSyncLevel12BackwardData {
        String jarDir;
        Set<String> extJARs;
        Set<String> libJARs;
        Map<String, SyncPackageData> packages;
        Set<String> semanticTypes;
        Set<String> eventPrototypes;

        SyncLevel1ReplyData(List<FabricNode> fabricNodes, List<FabricGroup> fabricGroups, List<RoutingTable.Link> routingLinks, SysGlobals sysGlobals, DirectoryTable directoryTable, Map<String, TimeWindow> timeWindows, Map<String, DomainConstraintReferenceImpl> domains, Map<String, RangeConstraintReferenceImpl> ranges, long globalCounter, ByteNumberAllocator clusterNumberAllocator, ShortNumberAllocator nodeNumberAllocator, Map<String, String> advancedParameters, Map<String, Byte> clusterNumbers, Map<String, Short> nodeNumbers, UUID fabricUid, long tokenId) {
            super(fabricNodes, fabricGroups, routingLinks, sysGlobals, directoryTable, timeWindows, domains, ranges, globalCounter, clusterNumberAllocator, nodeNumberAllocator, advancedParameters, clusterNumbers, nodeNumbers, fabricUid, tokenId);
        }

        File getJarDir() {
            return new File(this.jarDir);
        }
    }

    private static class AbstractSyncLevel12BackwardData
    extends AbstractSyncLevel12Data {
        Map<String, String> advancedParameters;
        Map<String, Byte> clusterNumbers;
        Map<String, Short> nodeNumbers;
        UUID fabricUid;
        long tokenId;
        UserState anonymousUser;
        Users users;
        Groups groups;
        Organizations organizations;
        RowSet vCardTable;
        RowSet vCardPhotoTable;
        AbstractApiKeyManager.ApiKeyReplicatedData apiKeyReplicatedData;
        DropBoxTable dropBoxTable;

        AbstractSyncLevel12BackwardData(List<FabricNode> fabricNodes, List<FabricGroup> fabricGroups, List<RoutingTable.Link> routingLinks, SysGlobals sysGlobals, DirectoryTable directoryTable, Map<String, TimeWindow> timeWindows, Map<String, DomainConstraintReferenceImpl> domains, Map<String, RangeConstraintReferenceImpl> ranges, long globalCounter, ByteNumberAllocator clusterNumberAllocator, ShortNumberAllocator nodeNumberAllocator, Map<String, String> advancedParameters, Map<String, Byte> clusterNumbers, Map<String, Short> nodeNumbers, UUID fabricUid, long tokenId) {
            super(fabricNodes, fabricGroups, routingLinks, sysGlobals, directoryTable, timeWindows, domains, ranges, globalCounter, clusterNumberAllocator, nodeNumberAllocator);
            this.advancedParameters = advancedParameters;
            this.clusterNumbers = clusterNumbers;
            this.nodeNumbers = nodeNumbers;
            this.fabricUid = fabricUid;
            this.tokenId = tokenId;
        }
    }

    private static class SyncSemanticData
    extends CloneableDataObject {
        String jarDir;
        List<String> extJARs;
        Map<String, SyncPackageData> packages;
        Map<String, SemanticType> semanticTypes;

        SyncSemanticData(SyncSemanticData other) {
            this.packages = other.packages;
        }

        SyncSemanticData(String jarDir, List<String> extJARs, Map<String, SyncPackageData> packages, Map<String, SemanticType> semanticTypes) {
            this.jarDir = jarDir;
            this.extJARs = extJARs;
            this.semanticTypes = semanticTypes;
            this.packages = packages;
        }

        File getJarDir() {
            return new File(this.jarDir);
        }
    }

    private static class SyncLevel2Data
    extends SyncSemanticData {
        Set<String> requestedExtJARs;
        Set<String> requestedSemanticTypes;

        SyncLevel2Data(SyncSemanticData semanticData, SyncLevel1ReplyData sync1Data) {
            super(semanticData.jarDir, semanticData.extJARs, semanticData.packages, semanticData.semanticTypes);
            this.requestedExtJARs = sync1Data.extJARs;
            this.requestedSemanticTypes = sync1Data.semanticTypes;
        }
    }

    private static class SyncLevel3RequestData
    extends SyncLevel3Data {
        Set<String> requestedEventPrototypes;

        SyncLevel3RequestData(Map<Prototype, ImmutableEventDatagram> eventPrototypes, Set<String> requestedEventPrototypes) {
            super(eventPrototypes);
            this.requestedEventPrototypes = requestedEventPrototypes;
        }
    }

    private static class SyncLevel3Data
    extends CloneableDataObject {
        Map<Prototype, ImmutableEventDatagram> eventPrototypes;

        SyncLevel3Data(Map<Prototype, ImmutableEventDatagram> eventPrototypes) {
            this.eventPrototypes = eventPrototypes;
        }
    }

    private static class SyncLevel12ForwardData
    extends AbstractSyncLevel12Data {
        Map<String, Byte> clusterNumbers;
        SyncSemanticData semanticData;

        SyncLevel12ForwardData(List<FabricNode> fabricNodes, List<FabricGroup> fabricGroups, List<RoutingTable.Link> routingLinks, SysGlobals sysGlobals, DirectoryTable table, Map<String, TimeWindow> timeWindows, Map<String, DomainConstraintReferenceImpl> domains, Map<String, RangeConstraintReferenceImpl> ranges, long globalCounter, ByteNumberAllocator clusterNumberAllocator, ShortNumberAllocator nodeNumberAllocator, Map<String, Byte> clusterNumbers) {
            super(fabricNodes, fabricGroups, routingLinks, sysGlobals, table, timeWindows, domains, ranges, globalCounter, clusterNumberAllocator, nodeNumberAllocator);
            this.clusterNumbers = clusterNumbers;
        }
    }

    private static class JoinData
    extends CloneableDataObject {
        String joiningNodeName;
        String sysplexNodeName;

        JoinData(String joiningNodeName, String sysplexNodeName) {
            this.joiningNodeName = joiningNodeName;
            this.sysplexNodeName = sysplexNodeName;
        }
    }

    private static class SyncLevel1BackwardData
    extends AbstractSyncLevel12BackwardData {
        SyncLevel1BackwardData(SyncLevel1ReplyData sync1Data) {
            super(sync1Data.fabricNodes, sync1Data.fabricGroups, sync1Data.routingLinks, sync1Data.sysGlobals, sync1Data.directoryTable, sync1Data.timeWindows, sync1Data.domains, sync1Data.ranges, sync1Data.globalCounter, sync1Data.clusterNumberAllocator, sync1Data.nodeNumberAllocator, sync1Data.advancedParameters, sync1Data.clusterNumbers, sync1Data.nodeNumbers, sync1Data.fabricUid, sync1Data.tokenId);
        }
    }

    private static class SyncLevel2BackwardData
    extends CloneableDataObject {
        ReplicationRules.ExclusionList exclusionList;
        SyncSemanticData semanticData;
        List<String> duplicatedExtJARs;
        List<String> duplicatedLibJARs;

        SyncLevel2BackwardData(ReplicationRules.ExclusionList exclusionList, SyncSemanticData semanticData, List<String> duplicatedExtJARs, List<String> duplicatedLibJARs) {
            this.exclusionList = exclusionList;
            this.semanticData = semanticData;
            this.duplicatedExtJARs = duplicatedExtJARs;
            this.duplicatedLibJARs = duplicatedLibJARs;
        }
    }

    private class NodeExchangeConnection
    extends ExchangeConnection {
        RoutingTable.Link routingLink;
        String joinNodeName;
        long joinStartTime;
        long joinThreadId;

        NodeExchangeConnection(Connection networkConnection) {
            super(networkConnection);
        }

        @Override
        void bind(FabricAddress address) {
            super.bind(address);
            if (RuntimeExchange.this.context.isSecurityEnabled() && this.securityManager == null) {
                this.securityManager = new RuntimeSecurityManagerProxy(RuntimeExchange.this.context.securityManagerImpl, null);
            }
            this.initRepositoryAccessor();
        }

        void bind(RoutingTable.Link routingLink) {
            this.routingLink = routingLink;
        }

        @Override
        PacketHandler createPacketHandler() {
            return new NodePacketHandler();
        }

        void authenticate(String userName, String digest) throws SecurityManagerException {
            if (RuntimeExchange.this.context.isSecurityEnabled()) {
                this.securityManager = new RuntimeSecurityManagerProxy(RuntimeExchange.this.context.securityManagerImpl, userName, digest, this.networkConnection.getSecurityKey());
            }
        }

        void onStartJoin(String nodeName) {
            this.joinNodeName = nodeName;
            this.joinStartTime = System.currentTimeMillis();
            this.joinThreadId = Thread.currentThread().getId();
        }

        void onCompleteJoin(boolean isNormal) {
            FabricNode fabricNode;
            if (!isNormal && this.address == null && (fabricNode = RuntimeExchange.this.getFabricNode(this.joinNodeName)) != null) {
                this.address = fabricNode.getFabricAddress();
            }
            this.joinNodeName = null;
            this.joinStartTime = -1L;
            this.joinThreadId = -1L;
        }

        private class NodePacketHandler
        extends ExchangeConnection.AbstractPacketHandler {
            private NodePacketHandler() {
            }

            @Override
            public void onPublication(byte[] packet) {
                try {
                    ByteBuffer packetBuffer = ByteBuffer.wrap(packet);
                    FabricAddress nodeAddress = NodeExchangeConnection.this.unpackAddress(packetBuffer);
                    if (RuntimeExchange.this.isLocal(nodeAddress)) {
                        this.publishLocal(packetBuffer);
                    } else {
                        RuntimeExchange.this.getConnection(nodeAddress).publish(packet);
                    }
                }
                catch (Throwable exception) {
                    RuntimeExchange.this.onError(exception, "Packet processing failed.");
                }
            }

            @Override
            public byte[] onPublicationRequest(byte[] packet) throws FabricException {
                try {
                    ByteBuffer packetBuffer = ByteBuffer.wrap(packet);
                    FabricAddress nodeAddress = NodeExchangeConnection.this.unpackAddress(packetBuffer);
                    if (!RuntimeExchange.this.isLocal(nodeAddress)) {
                        return RuntimeExchange.this.getConnection(nodeAddress).publishRoutedRequest(packet);
                    }
                    this.publishLocal(packetBuffer);
                }
                catch (EventException exception) {
                    return NodeExchangeConnection.this.pack((FabricEventException)exception.getCause());
                }
                catch (FabricEventSourceException exception) {
                    return NodeExchangeConnection.this.pack(exception);
                }
                catch (FabricEventException exception) {
                    return NodeExchangeConnection.this.pack(exception);
                }
                catch (Throwable exception) {
                    if (!(exception instanceof ExchangeException) || !((ExchangeException)exception).isWrapper()) {
                        RuntimeExchange.this.logException(exception, true);
                    }
                    return NodeExchangeConnection.this.pack(new FabricEventSourceException(6043, "Network request processing failed.", exception));
                }
                return null;
            }

            private void publishLocal(ByteBuffer packetBuffer) throws Exception {
                byte eventType = packetBuffer.get();
                if (eventType == 0) {
                    int position = packetBuffer.position();
                    ImmutableEventDatagram event = NodeExchangeConnection.this.unpackEvent(packetBuffer);
                    FabricAddress sourceAddress = new FabricAddress(event.getEventSource());
                    RuntimeExchange.this.dispatcher.raiseNetworkEvent(event, sourceAddress);
                    RuntimeExchange.this.clientDispatcher.raiseNetworkEvent(event, sourceAddress, packetBuffer.position(position));
                } else {
                    RuntimeFabricGroup group = (RuntimeFabricGroup)RuntimeExchange.this.groupManager.getGroup(packetBuffer.getShort());
                    long eventNumber = packetBuffer.getLong();
                    int position = packetBuffer.position();
                    ImmutableEventDatagram event = packetBuffer.remaining() > 0 ? NodeExchangeConnection.this.unpackEvent(packetBuffer) : null;
                    group.raiseNetworkEvent(eventNumber, event, event != null ? new FabricAddress(event.getEventSource()) : null, packetBuffer.position(position));
                }
            }
        }
    }

    private static class JoinReplyData
    extends CloneableDataObject {
        FabricAddress fabricAddress;

        JoinReplyData(FabricAddress fabricAddress) {
            this.fabricAddress = fabricAddress;
        }
    }

    private static class SyncForwardData
    extends CloneableDataObject {
        SyncLevel12ForwardData level12Data;
        Map<Prototype, ImmutableEventDatagram> eventPrototypes;

        SyncForwardData(SyncLevel12ForwardData level12Data, Map<Prototype, ImmutableEventDatagram> eventPrototypes) {
            this.level12Data = level12Data;
            this.eventPrototypes = eventPrototypes;
        }
    }

    private static class NodeDetachData
    extends CloneableDataObject {
        FabricAddress nodeAddress;
        boolean startScavenger;

        NodeDetachData(FabricAddress nodeAddress, boolean startScavenger) {
            this.nodeAddress = nodeAddress;
            this.startScavenger = startScavenger;
        }
    }

    private static class MissingAck {
        static final MissingAck OBJECT = new MissingAck();

        private MissingAck() {
        }
    }

    private class UserNodeBroadcastAckListener
    extends NodeBroadcastAckListener {
        UserNodeBroadcastAckListener(int eventId, Object eventData, long timeout, int nRecipients) {
            super(eventId, eventData, timeout, nRecipients);
        }

        @Override
        void logReceived(FabricAddress sourceAddress, Object data) {
            if (!RuntimeExchange.this.suppressLog(this.eventData)) {
                this.doLogReceived(sourceAddress, data);
            }
        }
    }

    private static class SlangData
    extends CloneableDataObject {
        SLStatement statement;
        MFSession session;
        long timeout;

        SlangData(SLStatement statement, MFSession session, long timeout) {
            this.statement = statement;
            this.session = session;
            this.timeout = timeout;
        }
    }

    private class ClientBroadcastAckListener
    extends BroadcastAckListener {
        FabricAddress excludedAddress;

        ClientBroadcastAckListener(int eventId, FabricAddress excludedAddress) {
            super(eventId, null, RuntimeExchange.this.clientBroadcastReplyTimeout, 0);
            this.excludedAddress = excludedAddress;
        }

        @Override
        void logReceived(FabricAddress sourceAddress, Object data) {
        }

        @Override
        String getRecipient(FabricAddress address) {
            return "client '" + String.valueOf(RuntimeExchange.this.getClient(address)) + "'.";
        }

        @Override
        Set<FabricAddress> getMissingRecipients() {
            HashSet<FabricAddress> result = new HashSet<FabricAddress>(RuntimeExchange.this.clientConnections.keySet());
            if (this.excludedAddress != null) {
                result.remove(this.excludedAddress);
            }
            return result;
        }

        @Override
        void processMissingRecipients(Set<FabricAddress> missingRecipients) {
            missingRecipients.forEach(address -> {
                ClientExchangeConnection client = RuntimeExchange.this.getClient((FabricAddress)address);
                if (client != null) {
                    client.isValid = false;
                }
            });
            FabricThreadManager.getInstance().createThread("EXCH:Detach.Clients", "Detaches unreachable clients.", () -> {
                Utils.sleep(100L);
                missingRecipients.forEach(address -> RuntimeExchange.this.detachClient((FabricAddress)address, true));
            }).start();
        }

        @Override
        String logSuffix() {
            return "from clients.";
        }
    }

    private class ExchangeConnectionFactoryImpl
    extends AbstractExchange.ExchangeConnectionFactory {
        ExchangeConnectionFactoryImpl(ThreadPoolType requestThreadPoolType, int requestThreadPoolSize) {
            super(requestThreadPoolType, requestThreadPoolSize);
        }

        @Override
        protected ConnectionChannelFactory createConnectionChannelFactory() {
            return new ExchangeConnectionChannelFactoryImpl();
        }
    }

    private class NodeConnectionStateHandler
    extends ExchangeConnectionStateHandler {
        private NodeConnectionStateHandler() {
        }

        @Override
        ExchangeConnection createExchangeConnection(Connection networkConnection) {
            return new NodeExchangeConnection(networkConnection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void doOnClose(ExchangeConnection connection, boolean isNormal) {
            connection.cancelLatencyCalculation();
            if (connection.isDisconnected) {
                Map<FabricAddress, NodeExchangeConnection> map = RuntimeExchange.this.nodeConnections;
                synchronized (map) {
                    if (RuntimeExchange.this.getNodeConnection(connection.address) == connection) {
                        RuntimeExchange.this.nodeConnections.remove(connection.address);
                    }
                }
            } else if (!isNormal) {
                boolean joinInterrupted = RuntimeExchange.this.sysplexSynchronizer.completeJoin((NodeExchangeConnection)connection, false);
                if (connection.address != null) {
                    RuntimeExchange.this.nodeConnections.remove(connection.address);
                    RuntimeExchange.this.sysplexSynchronizer.checkTokenDelay(true);
                    RuntimeExchange.this.sysplexSynchronizer.startForcedDisconnect(connection.address, joinInterrupted);
                }
            }
        }
    }

    private class ClientConnectionStateHandler
    extends ExchangeConnectionStateHandler {
        private ClientConnectionStateHandler() {
        }

        @Override
        ExchangeConnection createExchangeConnection(Connection networkConnection) {
            return new ClientExchangeConnection(networkConnection);
        }

        @Override
        void doOnClose(ExchangeConnection connection, boolean isNormal) {
            if (connection.address != null) {
                RuntimeExchange.this.removeClient(connection.address, !isNormal);
            }
            if (((ClientExchangeConnection)connection).isConnecting) {
                RuntimeExchange.this.notifyOnClientConnectionCompletion();
                ((ClientExchangeConnection)connection).isConnecting = false;
            }
        }
    }

    private class DiagnosticConnectionStateHandler
    extends ExchangeConnectionStateHandler {
        final LongNumberAllocatorSimple ID_ALLOCATOR;

        private DiagnosticConnectionStateHandler() {
            this.ID_ALLOCATOR = new LongNumberAllocatorSimple();
        }

        @Override
        ExchangeConnection createExchangeConnection(Connection networkConnection) {
            return new DiagnosticExchangeConnection(networkConnection, this.ID_ALLOCATOR.getNumber());
        }

        @Override
        void doOnClose(ExchangeConnection connection, boolean isNormal) {
            ((DiagnosticExchangeConnection)connection).disconnect();
        }
    }

    class ClientExchangeConnection
    extends ExchangeConnection {
        AbstractFabricComponent component;
        Set<EndpointReferenceImpl> clientEndpoints;
        boolean isConnecting;

        ClientExchangeConnection(Connection networkConnection) {
            super(networkConnection);
            this.clientEndpoints = new HashSet<EndpointReferenceImpl>();
            this.isConnecting = false;
        }

        @Override
        <TReplyData> AbstractExchange.InternalEvent<TReplyData> raiseInternalRequest(FabricAddress address, AbstractExchange.InternalEvent request, long timeout) throws Exception {
            return super.raiseInternalRequest(FabricAddress.NULL, request, timeout);
        }

        @Override
        PacketHandler createPacketHandler() {
            return new ClientPacketHandler();
        }

        void authenticate(String userName, String digest) throws SecurityManagerException {
            if (RuntimeExchange.this.context.isSecurityEnabled()) {
                this.securityManager = new RuntimeSecurityManagerProxy(RuntimeExchange.this.context.securityManagerImpl, RuntimeExchange.this.doAuthenticate(userName, digest, this.networkConnection), this.component);
            }
        }

        User getUser(boolean anonymous) {
            return anonymous ? (RuntimeExchange.this.context.isSecurityEnabled() ? RuntimeExchange.this.context.securityManagerImpl.getAnonymousUser() : null) : (RuntimeExchange.this.context.isSecurityEnabled() ? this.securityManager.currentUser : null);
        }

        synchronized void addClientEndpoint(EndpointReferenceImpl reference) throws Exception {
            ComponentReferenceImpl component = RuntimeExchange.this.node.getComponent(reference.componentAddress);
            if (component == null) {
                throw new FabricException("Component '" + String.valueOf(reference.componentAddress) + "' not found.");
            }
            reference.update(component.componentAddress, RuntimeExchange.this.acquireAddress(), RuntimeExchange.this);
            if (reference instanceof AbstractExchange.ClientRequestConsumer) {
                ((AbstractExchange.ClientRequestConsumer)reference).bind(this);
            }
            switch (reference.getExchangeRole()) {
                case DIRECT_CONSUMER: 
                case ASYNC_CONSUMER: 
                case REQUEST_CONSUMER: 
                case RECEIVER: {
                    EventConsumerReferenceImpl consumer = reference instanceof EventConsumerReferenceImpl ? (EventConsumerReferenceImpl)reference : null;
                    RuntimeExchange.this.addConsumer(reference, null, false, true, consumer != null && consumer.groupName != null ? RuntimeExchange.this.groupManager.getGroup(consumer.groupName) : null);
                    this.clientEndpoints.add(reference);
                    break;
                }
                case EVENT_CACHE: {
                    RuntimeExchange.this.addEventCache((EventCacheReferenceImpl)reference, true);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid ExchangeRole!");
                }
            }
        }

        synchronized void addClientConsumer(ComponentReferenceImpl component, EndpointReferenceImpl reference) throws Exception {
            ((ExchangeConsumerReference)((Object)reference)).update(ModeratorUtils.makeConsumerFullName(component, ModeratorUtils.extractConsumerName(reference.getName())), component.componentAddress, RuntimeExchange.this.acquireAddress(), RuntimeExchange.this);
            if (reference instanceof AbstractExchange.ClientRequestConsumer) {
                ((AbstractExchange.ClientRequestConsumer)reference).bind(this);
            }
            RuntimeExchange.this.node.addEndpoint(reference);
            EventConsumerReferenceImpl consumer = reference instanceof EventConsumerReferenceImpl ? (EventConsumerReferenceImpl)reference : null;
            RuntimeExchange group = consumer != null && consumer.groupName != null ? RuntimeExchange.this.groupManager.getGroup(consumer.groupName) : null;
            ((RuntimeExchangeEventPublisher)(group != null ? group : RuntimeExchange.this)).addToDispatcher(reference, null, false, true);
            this.clientEndpoints.add(reference);
        }

        synchronized void removeClient() {
            for (EndpointReferenceImpl endpoint : this.clientEndpoints) {
                this.removeClientEndpoint(endpoint, false);
            }
            this.clientEndpoints.clear();
            this.component.unbindSecurityContext();
            RuntimeExchange.this.removeComponent(this.component);
        }

        synchronized void removeClientEndpoint(EndpointReferenceImpl reference, boolean separateOperation) {
            switch (reference.getExchangeRole()) {
                case DIRECT_CONSUMER: 
                case ASYNC_CONSUMER: 
                case REQUEST_CONSUMER: 
                case RECEIVER: {
                    RuntimeFabricGroup group;
                    EventConsumerReferenceImpl consumer = reference instanceof EventConsumerReferenceImpl ? (EventConsumerReferenceImpl)reference : null;
                    RuntimeFabricGroup runtimeFabricGroup = group = consumer != null && consumer.groupName != null ? RuntimeExchange.this.groupManager.getGroup(consumer.groupName) : null;
                    if (separateOperation) {
                        RuntimeExchange.this.removeConsumer(reference, null, true, group);
                        this.clientEndpoints.remove(reference);
                        break;
                    }
                    RuntimeExchange.this.doRemoveConsumer(reference, null, true, group);
                    break;
                }
                case EVENT_CACHE: {
                    RuntimeExchange.this.removeEventCache(((EventCacheReference)((Object)reference)).getEventFilter(), this.address);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid ExchangeRole!");
                }
            }
        }

        @Override
        public String toString() {
            return ModeratorUtils.makeComponentFullName(this.component) + super.toString();
        }

        private class ClientPacketHandler
        extends ExchangeConnection.AbstractPacketHandler {
            private ClientPacketHandler() {
            }

            @Override
            public void onPublication(byte[] packet) {
                try {
                    this.publishLocal(packet);
                }
                catch (Throwable exception) {
                    RuntimeExchange.this.onError(exception, "Packet processing failed.");
                }
            }

            @Override
            public byte[] onPublicationRequest(byte[] packet) throws FabricException {
                try {
                    this.publishLocal(packet);
                }
                catch (EventException exception) {
                    return ClientExchangeConnection.this.pack((FabricEventException)exception.getCause());
                }
                catch (FabricEventSourceException exception) {
                    return ClientExchangeConnection.this.pack(exception);
                }
                catch (FabricEventException exception) {
                    return ClientExchangeConnection.this.pack(exception);
                }
                catch (Throwable exception) {
                    if (!(exception instanceof ExchangeException) || !((ExchangeException)exception).isWrapper()) {
                        RuntimeExchange.this.logException(exception, true);
                    }
                    return ClientExchangeConnection.this.pack(new FabricEventSourceException(6043, "Network request processing failed.", exception));
                }
                return null;
            }

            private void publishLocal(byte[] packet) throws Exception {
                ByteBuffer packetBuffer = ByteBuffer.wrap(packet);
                byte eventType = packetBuffer.get();
                if (eventType == 0) {
                    RuntimeExchange.this.raiseEvent(ClientExchangeConnection.this.unpackEvent(packetBuffer), ClientExchangeConnection.this.address, ClientExchangeConnection.this.unpackEventScope(packetBuffer), packetBuffer.position(1));
                } else {
                    RuntimeFabricGroup group = (RuntimeFabricGroup)RuntimeExchange.this.groupManager.getGroup(packetBuffer.getShort());
                    group.raiseEvent(ClientExchangeConnection.this.unpackEvent(packetBuffer), ClientExchangeConnection.this.address, ClientExchangeConnection.this.unpackEventScope(packetBuffer), packetBuffer.position(3));
                }
            }
        }
    }

    static class ClientInfo {
        ComponentReference component;
        LinkProtocol protocol;
        String acceptor;
        String host;
        String ip;

        ClientInfo(ComponentReference component, LinkProtocol protocol, String acceptor, InetAddress address) {
            this(component, protocol, acceptor, address != null ? address.getHostName() : null, address != null ? address.getHostAddress() : null);
        }

        ClientInfo(ComponentReference component, LinkProtocol protocol, String acceptor, String host, String ip) {
            this.component = component;
            this.protocol = protocol;
            this.acceptor = acceptor;
            this.host = host;
            this.ip = ip;
        }
    }

    private static class SyncPackageData
    extends AbstractPackageData {
        private List<String> jars;
        private PackageSource source = PackageSource.SYSPLEX;
        private boolean isLoaded = false;

        SyncPackageData(PackageDescriptor descriptor, boolean isLoaded) {
            super(descriptor);
            this.isLoaded = isLoaded;
            this.source = PackageSource.NODE;
        }

        SyncPackageData(Package pkg, PackageDescriptor descriptor, boolean isLoaded) {
            super(descriptor, pkg);
            this.isLoaded = isLoaded;
        }

        SyncPackageData(Package pkg, List<String> jars, PackageDescriptor descriptor, PackageSource source, boolean isLoaded) {
            this(pkg, descriptor, isLoaded);
            this.jars = jars;
            this.source = source;
        }
    }

    private static class AddJarData
    extends CloneableDataObject {
        String jarName;
        String jarDir;

        AddJarData(File jar) {
            this(jar.getName(), jar.getParentFile().getName());
        }

        AddJarData(String jarName, String jarDir) {
            this.jarName = jarName;
            this.jarDir = jarDir;
        }
    }

    private static class RemoveExtensionJarData
    extends RemoveJarData {
        boolean force;

        RemoveExtensionJarData(String jarName, boolean force) {
            super(jarName);
            this.force = force;
        }
    }

    private static class RemoveJarData
    extends CloneableDataObject {
        String jarName;

        RemoveJarData(String jarName) {
            this.jarName = jarName;
        }
    }

    static enum PackageSource {
        SYSPLEX,
        NODE;

    }

    static class LoadPackageData
    extends AbstractPackageData {
        boolean checkDependencies;

        LoadPackageData(PackageDescriptor descriptor, Package pkg, boolean checkDependencies) {
            super(descriptor, pkg);
            this.checkDependencies = checkDependencies;
        }
    }

    static class PackageData
    extends AbstractPackageData {
        Integer position;
        String jarDir;
        List<String> jars;

        PackageData(PackageDescriptor descriptor) {
            super(descriptor);
        }

        PackageData(PackageDescriptor descriptor, Package pkg, Integer position) {
            super(descriptor, pkg);
            this.position = position;
        }

        PackageData(PackageDescriptor descriptor, Integer position, Package pkg, List<String> jars) {
            this(descriptor, pkg, position);
            this.jars = jars;
        }
    }

    static class UpdatePackageData
    extends PackageData {
        boolean isSetScope = false;
        List<SemanticType> types;
        Map<Prototype, ImmutableEventDatagram> prototypes;

        UpdatePackageData(PackageDescriptor descriptor) {
            super(descriptor);
        }

        UpdatePackageData(PackageDescriptor descriptor, Package pkg, Integer position) {
            super(descriptor, pkg, position);
        }

        UpdatePackageData(PackageDescriptor descriptor, Integer position, Package pkg, List<String> jars) {
            super(descriptor, position, pkg, jars);
        }

        static UpdatePackageData createForSetScope(PackageDescriptor descriptor) {
            UpdatePackageData result = new UpdatePackageData(descriptor);
            result.isSetScope = true;
            return result;
        }
    }

    private static class RemoveSemanticTypeData
    extends CloneableDataObject {
        String typeName;
        boolean force;

        RemoveSemanticTypeData(String typeName, boolean force) {
            this.typeName = typeName;
            this.force = force;
        }
    }

    private class ExtJarGetter
    implements JarGetter {
        private ExtJarGetter() {
        }

        @Override
        public URL getURL(String jarName) throws Exception {
            return RuntimeExchange.this.context.repositoryAccessor.getExtensionArchiveURL(jarName);
        }

        @Override
        public byte[] getContent(String jarName) throws Exception {
            return RuntimeExchange.this.context.repositoryAccessor.getExtensionArchive(jarName);
        }
    }

    private static interface JarGetter {
        public URL getURL(String var1) throws Exception;

        public byte[] getContent(String var1) throws Exception;
    }

    private class LibJarGetter
    implements JarGetter {
        private LibJarGetter() {
        }

        @Override
        public URL getURL(String jarName) throws Exception {
            return RuntimeExchange.this.context.repositoryAccessor.getArchiveURL(jarName);
        }

        @Override
        public byte[] getContent(String jarName) throws Exception {
            return RuntimeExchange.this.context.repositoryAccessor.getArchive(jarName);
        }
    }

    private static class TokenMonitorResult
    extends CloneableDataObject {
        boolean hasToken;
        long tokenReceiptTime;
        long tokenHoldingTime;
        long tokenSendingTime;
        long tokenAbsenceTime;
        List<ConfigurationParameter> parameters;
        RowSet jvmStats;
        RowSet threads;

        TokenMonitorResult(boolean hasToken, long tokenReceiptTime, long tokenHoldingTime, long tokenSendingTime, long tokenAbsenceTime) {
            this.hasToken = hasToken;
            this.tokenReceiptTime = tokenReceiptTime;
            this.tokenHoldingTime = tokenHoldingTime;
            this.tokenSendingTime = tokenSendingTime;
            this.tokenAbsenceTime = tokenAbsenceTime;
        }
    }

    private static class DiagnosticInstantMFSession
    extends InstantMFSession {
        DiagnosticInstantMFSession(User user, String resourceName) {
            super(user, resourceName);
        }

        @Override
        public boolean isDiagnostic() {
            return true;
        }
    }

    private static class InstantMFSession
    extends AbstractMFSession {
        InstantMFSession(User user, String resourceName) {
            super("Instant", "RuntimeContext", user, true, null, resourceName);
        }

        InstantMFSession(MFSession session, User user, String resourceName) {
            super("Instant", session.getComponentName(), user, session.isRouted(), session.getSLSessionName(), resourceName);
        }

        @Override
        public boolean isInstant() {
            return true;
        }
    }

    private static interface IWorker {
        public FabricThread getThread();
    }

    private static class TokenMonitorData
    extends CloneableDataObject {
        long tokenId;
        Action action;

        TokenMonitorData(long tokenId) {
            this(tokenId, Action.STANDARD);
        }

        TokenMonitorData(long tokenId, Action action) {
            this.tokenId = tokenId;
            this.action = action;
        }

        private static enum Action {
            STANDARD,
            ADVISORY,
            SLANG;

        }
    }

    private static class RoutedContainerRequestData
    extends CloneableDataObject {
        byte[] data;
        long timeout;

        RoutedContainerRequestData(byte[] data, long timeout) {
            this.data = data;
            this.timeout = timeout;
        }
    }

    private static class InternalMFSession
    extends AbstractMFSession {
        InternalMFSession(User user, String resourceName) {
            super("Internal", "RuntimeContext", user, false, null, resourceName);
        }
    }

    private class DiagnosticExchangeConnection
    extends ExchangeConnection {
        long id;
        User user;
        DiagnosticMFSession mfSession;

        DiagnosticExchangeConnection(Connection networkConnection, long id) {
            super(networkConnection);
            this.id = id;
        }

        @Override
        PacketHandler createPacketHandler() {
            return new DiagnosticPacketHandler();
        }

        private AbstractExchange.InternalEvent connect(AbstractSpecialSLSession.ConnectRequestData data) throws SecurityManagerException {
            if (RuntimeExchange.this.context.isSecurityEnabled()) {
                if (data.userName == null) {
                    throw new SecurityManagerException(6004, "Null user name specified.");
                }
                this.user = RuntimeExchange.this.doAuthenticate(data.userName, data.digest, this.networkConnection);
            }
            RuntimeExchange.this.unboundConnections.remove(this.getNetworkAddress());
            RuntimeExchange.this.diagnosticConnections.put(this.id, this);
            this.mfSession = new DiagnosticMFSession(DiagnosticSLSessionImpl.getMFSessionName(this.id), data.componentName, this.user, data.slSessionName, this.getNodeName(), data.fromSlangTool);
            RuntimeExchange.this.logInfo("Diagnostic session '" + this.mfSession.getName() + "' [" + String.valueOf(this.networkConnection) + "] established.");
            return RuntimeExchange.this.createInternalEvent(new AbstractSpecialSLSession.ConnectReplyData(this.user, RuntimeExchange.this.context.domain, this.getNodeName(), Banner.getBanner()));
        }

        private AbstractExchange.InternalEvent disconnect() {
            if (RuntimeExchange.this.diagnosticConnections.remove(this.id) != null) {
                RuntimeExchange.this.logInfo("Diagnostic session '" + DiagnosticSLSessionImpl.getMFSessionName(this.id) + "' [" + String.valueOf(this.networkConnection) + "] closed.");
            }
            return AbstractExchange.EmptyEvent.defaultInstance;
        }

        private ImmutableEventDatagram invokeRequest(Object wrapper, long timeout) throws FabricRequestException {
            SLResponse response = null;
            try {
                if (wrapper instanceof SLTextWrapper) {
                    response = RuntimeExchange.this.context.getLexiconProcessor().invoke(((SLTextWrapper)wrapper).getText(), (MFSession)this.mfSession, timeout);
                } else if (wrapper instanceof SLStatementWrapper) {
                    response = RuntimeExchange.this.context.getLexiconProcessor().invoke(((SLStatementWrapper)wrapper).getStatement(), (MFSession)this.mfSession, timeout);
                } else if (wrapper instanceof SLCompleteRequest) {
                    DSLCompletion completion = RuntimeExchange.this.context.getLexiconProcessor().completeDsl(((SLCompleteRequest)wrapper).getCommand(), this.mfSession);
                    response = new SLResponse();
                    response.setObject(completion);
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof UnsupportedRequestException || exception instanceof ParsingException || exception instanceof DataspaceException)) {
                    RuntimeExchange.this.logException(exception, true);
                    RuntimeExchange.this.logError("Processing SLANG operation failed.");
                }
                return new FabricRequestException(exception);
            }
            return RuntimeExchange.this.createInternalEvent(response);
        }

        private class DiagnosticPacketHandler
        extends ExchangeConnection.AbstractPacketHandler {
            private DiagnosticPacketHandler() {
            }

            @Override
            public ByteBuffer onRequest(long requestId, byte[] packet, long timeout) throws FabricException {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(packet);
                    byte eventType = buffer.get();
                    switch (eventType) {
                        case 1: {
                            return DiagnosticExchangeConnection.this.packReply(requestId, DiagnosticExchangeConnection.this.connect((AbstractSpecialSLSession.ConnectRequestData)DiagnosticExchangeConnection.this.unpackInternalEvent((ByteBuffer)buffer).data));
                        }
                        case 10: {
                            return DiagnosticExchangeConnection.this.packReply(requestId, AbstractExchange.EmptyEvent.defaultInstance);
                        }
                    }
                    return DiagnosticExchangeConnection.this.packReply(requestId, DiagnosticExchangeConnection.this.invokeRequest(DiagnosticExchangeConnection.this.unpackInternalEvent((ByteBuffer)buffer).data, timeout));
                }
                catch (Throwable exception) {
                    if (!(exception instanceof ExchangeException) || !((ExchangeException)exception).isWrapper()) {
                        if (exception instanceof SecurityManagerException && ((SecurityManagerException)exception).getErrorCode() == 6084) {
                            RuntimeExchange.this.logInfo(exception.toString());
                        } else {
                            RuntimeExchange.this.logException(exception, true);
                        }
                    }
                    return DiagnosticExchangeConnection.this.packReply(requestId, new FabricEventSourceException(6043, "Network request processing failed.", exception));
                }
            }

            @Override
            public void onPublication(byte[] packet) {
            }

            @Override
            public byte[] onPublicationRequest(byte[] packet) throws FabricException {
                return null;
            }
        }
    }

    private static class DiagnosticMFSession
    extends AbstractMFSession {
        private boolean fromSlangTool = false;

        DiagnosticMFSession(String name, String componentName, User user, String slSessionName, String resourceName, boolean fromSlangTool) {
            super(name, componentName, user, false, slSessionName, resourceName);
            this.fromSlangTool = fromSlangTool;
        }

        @Override
        public boolean isDiagnostic() {
            return true;
        }

        @Override
        public boolean isFromSlangTool() {
            return this.fromSlangTool;
        }
    }

    private static class TokenRestartData
    extends CloneableDataObject {
        long tokenId;
        boolean startScavenger;

        private TokenRestartData(long tokenId, boolean startScavenger) {
            this.tokenId = tokenId;
            this.startScavenger = startScavenger;
        }
    }

    private static class ThreadDeadlock {
        long first;
        long second;

        ThreadDeadlock(long first, long second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ThreadDeadlock && (this.first == ((ThreadDeadlock)other).first && this.second == ((ThreadDeadlock)other).second || this.first == ((ThreadDeadlock)other).second && this.second == ((ThreadDeadlock)other).first);
        }

        public int hashCode() {
            return Long.hashCode(this.first + this.second);
        }
    }

    private static class BlockedThreadInfo {
        ThreadInfo info;
        long blockedTime;
        boolean isReported;

        BlockedThreadInfo(ThreadInfo info, long blockedTime, boolean isReported) {
            this.info = info;
            this.blockedTime = blockedTime;
            this.isReported = isReported;
        }
    }

    static class AbstractPackageData
    extends CloneableDataObject {
        PackageDescriptor descriptor;
        Package pkg;

        AbstractPackageData(PackageDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        AbstractPackageData(PackageDescriptor descriptor, Package pkg) {
            this.descriptor = descriptor;
            this.pkg = pkg;
        }

        boolean isEmpty() {
            return this.descriptor == null && this.pkg == null;
        }
    }

    private static class AbstractSyncLevel12Data
    extends AbstractSyncData {
        ByteNumberAllocator clusterNumberAllocator;
        ShortNumberAllocator nodeNumberAllocator;

        AbstractSyncLevel12Data(List<FabricNode> fabricNodes, List<FabricGroup> fabricGroups, List<RoutingTable.Link> routingLinks, SysGlobals sysGlobals, DirectoryTable directoryTable, Map<String, TimeWindow> timeWindows, Map<String, DomainConstraintReferenceImpl> domains, Map<String, RangeConstraintReferenceImpl> ranges, long globalCounter, ByteNumberAllocator clusterNumberAllocator, ShortNumberAllocator nodeNumberAllocator) {
            super(fabricNodes, fabricGroups, routingLinks, sysGlobals, directoryTable, timeWindows, domains, ranges, globalCounter);
            this.clusterNumberAllocator = clusterNumberAllocator;
            this.nodeNumberAllocator = nodeNumberAllocator;
        }
    }

    private static class AbstractSyncData
    extends CloneableDataObject {
        List<FabricNode> fabricNodes;
        List<FabricGroup> fabricGroups;
        List<RoutingTable.Link> routingLinks;
        SysGlobals sysGlobals;
        DirectoryTable directoryTable;
        Map<String, TimeWindow> timeWindows;
        Map<String, DomainConstraintReferenceImpl> domains;
        Map<String, RangeConstraintReferenceImpl> ranges;
        long globalCounter;
        ReplicationRules.ExclusionList exclusionList;

        AbstractSyncData(List<FabricNode> fabricNodes, List<FabricGroup> fabricGroups, List<RoutingTable.Link> routingLinks, SysGlobals sysGlobals, DirectoryTable directoryTable, Map<String, TimeWindow> timeWindows, Map<String, DomainConstraintReferenceImpl> domains, Map<String, RangeConstraintReferenceImpl> ranges, long globalCounter) {
            this.fabricNodes = fabricNodes;
            this.fabricGroups = fabricGroups;
            this.routingLinks = routingLinks;
            this.sysGlobals = sysGlobals;
            this.directoryTable = directoryTable;
            this.timeWindows = timeWindows;
            this.domains = domains;
            this.ranges = ranges;
            this.globalCounter = globalCounter;
        }
    }

    static class HTTPClientInfo
    extends ClientInfo {
        boolean isActive = false;
        long expirationTime = -1L;

        HTTPClientInfo(ComponentReference component, LinkProtocol protocol, String acceptor) {
            super(component, protocol, acceptor, null);
        }

        void setExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
            this.isActive = expirationTime > 0L;
        }
    }

    private abstract class ExchangeConnectionStateHandler
    extends DefaultConnectionStateHandler {
        private ExchangeConnectionStateHandler() {
        }

        @Override
        public void onOpen(Connection networkConnection, boolean isOutgoing) {
            ExchangeConnection connection = isOutgoing ? (ExchangeConnection)((AbstractExchange.NetworkConnectionImpl)networkConnection).exchangeConnection : this.createExchangeConnection(networkConnection);
            RuntimeExchange.this.unboundConnections.put(networkConnection.getAddress(), connection);
            this.doOnOpen(connection);
        }

        void doOnOpen(ExchangeConnection connection) {
        }

        abstract ExchangeConnection createExchangeConnection(Connection var1);

        @Override
        public void onClose(Connection networkConnection, boolean isNormal) {
            ExchangeConnection connection = (ExchangeConnection)((AbstractExchange.NetworkConnectionImpl)networkConnection).exchangeConnection;
            connection.isValid = false;
            RuntimeExchange.this.unboundConnections.remove(networkConnection.getAddress());
            this.doOnClose(connection, isNormal);
        }

        abstract void doOnClose(ExchangeConnection var1, boolean var2);
    }

    private class ExchangeConnectionChannelFactoryImpl
    extends AbstractExchange.ExchangeConnectionChannelFactory {
        private ExchangeConnectionChannelFactoryImpl() {
        }

        @Override
        protected ClientConnectionChannel doCreateClientChannel(boolean isSSL) throws FabricException {
            TLPAcceptor acceptor = RuntimeExchange.this.acceptorFactory.lookupAcceptor("Default");
            return acceptor != null ? (ClientConnectionChannel)ExchangeConnectionChannelFactoryImpl.cloneChannel(acceptor.getOutgoingConnectionChannel(), isSSL) : super.doCreateClientChannel(isSSL);
        }

        @Override
        protected ServerConnectionChannel doCreateServerChannel(boolean isSSL) {
            TLPAcceptor acceptor = RuntimeExchange.this.acceptorFactory.lookupAcceptor("Default");
            return acceptor != null ? (ServerConnectionChannel)ExchangeConnectionChannelFactoryImpl.cloneChannel(acceptor.getIncomingConnectionChannel(), isSSL) : super.doCreateServerChannel(isSSL);
        }

        @Override
        protected TLPPacketHandler createTlpPacketHandler(ServerConnectionChannelImpl channel) throws FabricException {
            TLPPacketHandler handler = super.createTlpPacketHandler(channel);
            handler.setOutOfMemoryErrorHandler(RuntimeExchange.this);
            return handler;
        }
    }

    private static class NodeForcedDisconnectEventData
    extends CloneableDataObject {
        List<FabricAddress> routedTasks;
        boolean joinInterrupted;

        public NodeForcedDisconnectEventData(List<FabricAddress> routedTasks, boolean joinInterrupted) {
            this.routedTasks = routedTasks;
            this.joinInterrupted = joinInterrupted;
        }
    }

    abstract class AbstractJoinRequestListener<TRequestData, TConnection extends AbstractExchange.AbstractExchangeConnection>
    extends AbstractExchange.InternalRequestListener<TRequestData, TConnection> {
        AbstractJoinRequestListener() {
            super(RuntimeExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, TRequestData data, TConnection connection) throws Exception {
            RuntimeExchange.this.sysplexSynchronizer.suspendJoinMonitor();
            AbstractExchange.InternalEvent reply = this.doOnRequest(sourceAddress, data, connection);
            RuntimeExchange.this.sysplexSynchronizer.resumeJoinMonitor();
            return reply;
        }

        abstract AbstractExchange.InternalEvent doOnRequest(FabricAddress var1, TRequestData var2, TConnection var3) throws Exception;
    }

    abstract class UserInternalEventListenerWithAck<TEventData, TConnection extends AbstractExchange.AbstractExchangeConnection>
    extends AbstractExchange.ConcurrentInternalEventListenerWithAck<TEventData, TConnection> {
        UserInternalEventListenerWithAck() {
        }

        @Override
        void processEvent(FabricAddress sourceAddress, AbstractExchange.InternalEvent<TEventData> event, TConnection connection) {
            try {
                RuntimeExchange.this.systemThreadPool.addTask(() -> super.processEvent(sourceAddress, event, connection));
            }
            catch (RejectedExecutionException exception) {
                super.processEvent(sourceAddress, event, connection);
            }
        }

        @Override
        int getAckEventId() {
            return 51;
        }
    }

    abstract class SpecialInternalEventListenerWithAck<TEventData, TConnection extends AbstractExchange.AbstractExchangeConnection>
    extends AbstractExchange.InternalEventListenerWithAck<TEventData, TConnection> {
        byte eventType;
        String sourceNodeName;

        SpecialInternalEventListenerWithAck() {
        }

        void setAcknowledgementParameters(byte eventType, String sourceNodeName) {
            this.eventType = eventType;
            this.sourceNodeName = sourceNodeName;
        }

        @Override
        void acknowledgeBroadcast(TEventData eventData, TConnection connection, FabricAddress nodeAddress, Object data) throws FabricException {
            ((AbstractExchange.AbstractExchangeConnection)connection).raiseInternalEventSpecial(this.eventType, this.sourceNodeName, RuntimeExchange.this.createInternalEvent(49, data));
            this.logReplied(eventData);
        }
    }
}

