/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AbstractDatagramPrototypeFactory;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.dispatcher.AbstractDatagramPrototypeCache;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.lang.AbstractDSLOperation;

class RuntimeDatagramPrototypeFactory
extends AbstractDatagramPrototypeFactory {
    private AbstractRuntimeContext context = null;

    RuntimeDatagramPrototypeFactory(AbstractRuntimeContext context) {
        super(context);
        this.context = context;
    }

    @Override
    protected FabricContext getContext() {
        return this.context;
    }

    @Override
    protected void addPrototype(IAbstractDatagramFactory factory, Prototype prototype, String eventId, ImmutableEventDatagram event, boolean notify) throws DatagramFactoryException {
        if (notify && this.context.isCoherenceAgentBound()) {
            try {
                this.context.exchange.addEventPrototype(this, factory, prototype, eventId, event);
            }
            catch (Exception exception) {
                if (exception instanceof DatagramFactoryException) {
                    throw (DatagramFactoryException)exception;
                }
                throw new DatagramFactoryException(6011, "Unexpected exception.", exception);
            }
        } else {
            this.doAddPrototypeCore(factory, prototype, eventId, event);
        }
    }

    @Override
    protected ImmutableEventDatagram doAddPrototypeCore(IAbstractDatagramFactory factory, Prototype prototype, String eventId, ImmutableEventDatagram event) throws DatagramFactoryException {
        return super.doAddPrototypeCore(factory, prototype, eventId, event);
    }

    @Override
    protected void doAddEventPrototype(Prototype prototype, ImmutableEventDatagram event, boolean notify) throws DatagramFactoryException {
        super.doAddEventPrototype(prototype, event, notify);
    }

    @Override
    protected void removePrototype(IAbstractDatagramFactory factory, String eventId, boolean force, boolean notify) throws DatagramFactoryException {
        if (notify && this.context.isCoherenceAgentBound()) {
            try {
                this.context.exchange.removeEventPrototype(this, factory, eventId, force);
            }
            catch (Exception exception) {
                if (exception instanceof DatagramFactoryException) {
                    throw (DatagramFactoryException)exception;
                }
                throw new DatagramFactoryException(6011, "Unexpected exception.", exception);
            }
        } else {
            this.doRemovePrototypeCore(factory, eventId, force, false);
        }
    }

    void removeOldEventPrototype(IAbstractDatagramFactory factory, String eventId) throws DatagramFactoryException {
        this.unregisterPrototype(factory, eventId);
        super.doRemovePrototypeCore(factory, eventId, true, false);
    }

    @Override
    protected synchronized void doRemovePrototypeCore(IAbstractDatagramFactory factory, String eventId, boolean force, boolean inSysplex) throws DatagramFactoryException {
        this.checkOnRemove(eventId, force, inSysplex);
        this.unregisterPrototype(factory, eventId);
        super.doRemovePrototypeCore(factory, eventId, force, inSysplex);
    }

    @Override
    protected void removePrototypeSpecial(IAbstractDatagramFactory factory, String eventId) throws DatagramFactoryException {
        super.removePrototypeSpecial(factory, eventId);
    }

    @Override
    protected void doRemovePrototype(String eventId, boolean force, boolean notify) throws DatagramFactoryException {
        super.doRemovePrototype(eventId, force, notify);
    }

    @Override
    protected void checkOnRemove(String eventId, boolean force, boolean inSysplex) throws DatagramFactoryException {
        super.checkOnRemove(eventId, force, inSysplex);
        if (!force && this.context.exchange.existsEventFlows(eventId, inSysplex)) {
            throw new DatagramFactoryException(5077, "Event [" + eventId + "] has active flows and cannot be removed.");
        }
    }

    @Override
    protected Pair<Prototype, ImmutableEventDatagram> getPrototype(String eventId) throws DatagramFactoryException {
        return super.getPrototype(eventId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean updatePrototype(Prototype prototype, ImmutableEventDatagram event) throws DatagramFactoryException {
        if (this.existsPrototype(event.getEventId())) {
            Pair<Prototype, ImmutableEventDatagram> existingPrototype = this.getPrototype(event.getEventId());
            if (((Prototype)existingPrototype.first).equals(prototype) && ((ImmutableEventDatagram)existingPrototype.second).equals(event)) return false;
            this.doRemovePrototype(event.getEventId(), true, false);
            this.doAddEventPrototype(prototype, event, false);
            if (!((Prototype)existingPrototype.first).isValid() || prototype.isValid()) return true;
            Trace.logInfo(this, "WARNING: Event prototype [" + event.getEventId() + "] invalidated (since it is invalid in Sysplex).");
            return true;
        } else {
            this.unregisterInvalidPrototype(prototype, event);
            this.doAddEventPrototype(prototype, event, false);
        }
        return true;
    }

    @Override
    public boolean isPrototypeGlobal(String eventId) {
        try {
            Pair<Prototype, ImmutableEventDatagram> prototype = this.getPrototype(eventId);
            return this.isPrototypeGlobal((Prototype)prototype.first, (ImmutableEventDatagram)prototype.second);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected boolean isPrototypeGlobal(Prototype prototype, ImmutableEventDatagram event) {
        if (AbstractDSLOperation.isUserEvent(event.getEventId()) && event instanceof PayloadEvent) {
            Class payloadClass = ((PayloadEvent)((Object)event)).getPayloadClass();
            if (payloadClass != null && payloadClass.getClassLoader() != null) {
                return SemanticUtils.isSemanticTypeGlobal(payloadClass, (RuntimeContext)this.context);
            }
            String dataType = ((AbstractDatagramPrototypeCache)((Object)this.prototypeCache)).getDataType(prototype, event);
            if (dataType != null) {
                SemanticType type = this.context.getSemanticTypeCache().lookupSemanticType(dataType);
                return type != null && SemanticUtils.isSemanticTypeGlobal(type, (RuntimeContext)this.context);
            }
        }
        return true;
    }
}

