/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.sef.dispatcher.DataConstraintPersistentStore;
import com.streamscape.sef.dispatcher.DomainConstraintReferenceImpl;
import com.streamscape.sef.dispatcher.ExchangeDataConstraint;
import com.streamscape.sef.dispatcher.ExchangeDataConstraintStore;
import com.streamscape.sef.dispatcher.ExchangeDateRangeConstraint;
import com.streamscape.sef.dispatcher.ExchangeDomainConstraint;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.ExchangeNumericRangeConstraint;
import com.streamscape.sef.dispatcher.ExchangeRangeConstraint;
import com.streamscape.sef.dispatcher.RangeConstraintReferenceImpl;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import java.lang.reflect.Method;

class RuntimeDataConstraintStore
extends ExchangeDataConstraintStore {
    private RuntimeExchange exchange;
    private DataConstraintPersistentStore persistentStore;
    private static final Method INIT_DOMAIN;
    private static final Method INIT_RANGE;
    private static final String CONSTRAINT_NAMESPACE = "/sys/constraint";

    RuntimeDataConstraintStore(RuntimeExchange exchange) {
        this.exchange = exchange;
    }

    void init(DataConstraintPersistentStore persistentStore) {
        this.persistentStore = persistentStore;
    }

    void load() throws Exception {
        if (!this.loadDataConstraintsFromOldFormat()) {
            this.persistentStore.load();
        }
    }

    void addDomain(ExchangeDomainConstraint domain) throws EventDispatcherException, ExchangeException {
        this.exchange.addDataConstraintReference(new DomainConstraintReferenceImpl(this.createDomainConstraint(domain), this.exchange.node.getFabricAddress()));
    }

    void addRange(ExchangeRangeConstraint range) throws EventDispatcherException, ExchangeException {
        this.exchange.addDataConstraintReference(new RangeConstraintReferenceImpl(this.createRangeConstraint(range), this.exchange.node.getFabricAddress()));
    }

    @Override
    protected void onAddConstraint(ExchangeDataConstraint constraint) throws ExchangeException {
        this.persistentStore.addConstraint(constraint);
    }

    @Override
    protected void onRemoveConstraint(ExchangeDataConstraint constraint) {
        try {
            this.persistentStore.removeConstraint(constraint);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Removing " + constraint.getModel() + " '" + constraint.getModel() + "' from persistent store.");
        }
    }

    @Override
    protected void onUpdateConstraint(ExchangeDataConstraint constraint) throws ExchangeException {
        this.persistentStore.updateConstraint(constraint);
    }

    private boolean loadDataConstraintsFromOldFormat() {
        block5: {
            try {
                ReferenceContext constraintContext = this.exchange.context.repositoryAccessor.lookupReferenceContext(CONSTRAINT_NAMESPACE);
                if (constraintContext == null) break block5;
                try {
                    this.loadDataConstraints("/sys/constraint/global/domain", INIT_DOMAIN);
                    this.loadDataConstraints("/sys/constraint/observable/domain", INIT_DOMAIN);
                    this.loadDataConstraints("/sys/constraint/global/range", INIT_RANGE);
                    this.loadDataConstraints("/sys/constraint/observable/range", INIT_RANGE);
                }
                finally {
                    this.exchange.context.repositoryAccessor.destroyReferenceContext(constraintContext);
                }
                return true;
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Loading Data Constraints from old format failed.");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataConstraints(String namespace, Method initMethod) throws ExchangeException {
        block6: {
            try {
                ReferenceContext oldReferenceContext = this.exchange.context.repositoryAccessor.getReferenceContext();
                ReferenceContext referenceContext = this.exchange.context.repositoryAccessor.lookupReferenceContext(namespace);
                if (referenceContext == null) break block6;
                this.exchange.context.repositoryAccessor.setReferenceContext(referenceContext);
                try {
                    for (String name : this.exchange.context.repositoryAccessor.listObjectNames(null)) {
                        initMethod.invoke((Object)this, name);
                    }
                }
                finally {
                    this.exchange.context.repositoryAccessor.setReferenceContext(oldReferenceContext);
                }
            }
            catch (Exception exception) {
                throw new ExchangeException("Loading Data Constraints from old format failed.", (Throwable)exception);
            }
        }
    }

    private void loadDomainConstraint(String name) {
        try {
            ExchangeDomainConstraint domain = (ExchangeDomainConstraint)this.exchange.context.repositoryAccessor.lookupObject(name);
            this.addDomain(domain);
            this.onAddConstraint(domain);
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, false);
            Trace.logError(this, "Loading Domain '" + name + "' from old format failed.");
        }
    }

    private void loadRangeConstraint(String name) {
        try {
            Object object = this.exchange.context.repositoryAccessor.lookupObject(name);
            if (object instanceof ExchangeNumericRangeConstraint) {
                this.addNumericRange((ExchangeNumericRangeConstraint)object);
            } else if (object instanceof ExchangeDateRangeConstraint) {
                this.addDateRange((ExchangeDateRangeConstraint)object);
            }
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, false);
            Trace.logError(this, "Loading Range '" + name + "' from old format failed.");
        }
    }

    void addNumericRange(ExchangeNumericRangeConstraint oldRange) {
        try {
            ExchangeRangeConstraint range = new ExchangeRangeConstraint(oldRange.getName(), oldRange.getDescription(), oldRange.getMinValue(), oldRange.getMaxValue());
            this.addRange(range);
            this.onAddConstraint(range);
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, false);
            Trace.logError(this, "Loading Range '" + oldRange.getName() + "' from old format failed.");
        }
    }

    void addDateRange(ExchangeDateRangeConstraint oldRange) {
        try {
            ExchangeRangeConstraint range = new ExchangeRangeConstraint(oldRange.getName(), oldRange.getDescription(), oldRange.getMinValue(), oldRange.getMaxValue());
            this.addRange(range);
            this.onAddConstraint(range);
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, false);
            Trace.logError(this, "Loading Range '" + oldRange.getName() + "' from old format failed.");
        }
    }

    static {
        try {
            INIT_DOMAIN = RuntimeDataConstraintStore.class.getDeclaredMethod("loadDomainConstraint", String.class);
            INIT_RANGE = RuntimeDataConstraintStore.class.getDeclaredMethod("loadRangeConstraint", String.class);
        }
        catch (Throwable exception) {
            throw new RuntimeException("RuntimeDataConstraintStore initialization failed.", exception);
        }
    }
}

