/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.Version;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.PingResult;
import com.streamscape.cli.tlp.PingState;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.lib.utils.ArchiveException;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.accessor.FabricComponentAccessor;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractRepositoryAccessor;
import com.streamscape.sef.dispatcher.ClientExchange;
import com.streamscape.sef.dispatcher.ClientRemoteRepositoryAccessorImpl;
import com.streamscape.sef.dispatcher.ClientSecurityManagerProxy;
import com.streamscape.sef.dispatcher.DynamicComponentsManager;
import com.streamscape.sef.dispatcher.FabricEventSourceFactoryImpl;
import com.streamscape.sef.dispatcher.RemoteClientComponent;
import com.streamscape.sef.dispatcher.SLSessionImpl;
import com.streamscape.sef.dispatcher.SecurityContextImpl;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.group.FabricGroupManager;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.slex.slang.SLSessionException;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.naming.NamingException;

class RemoteFabricConnection
extends AbstractFabricConnection {
    int reconnectAttempts;
    long reconnectInterval;
    transient ClientContext context;
    transient ClientExchange exchange;
    transient long connectionTimeout;
    transient boolean isReopening;
    transient ReconnectingWorker reconnectingWorker;

    RemoteFabricConnection(String type, ClientContext context) {
        this.context = context;
        this.exchange = new ClientExchange(this);
        this.authenticationType = AuthenticationType.DIGEST;
        this.bind(new RemoteClientComponent(type, ComponentModel.REMOTE_CLIENT, this));
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public synchronized void setReconnectAttempts(int reconnectAttempts) {
        if (this.reconnectAttempts != reconnectAttempts) {
            this.reconnectAttempts = reconnectAttempts;
            if (this.reconnectingWorker != null && !this.reconnectingWorker.hasRemainingAttempts()) {
                this.stopReconnecting(true);
            }
        }
    }

    @Override
    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public void setReconnectInterval(long reconnectInterval) throws FabricConnectionException {
        if (reconnectInterval <= 0L) {
            throw new FabricConnectionException(1006, "Reconnect interval must be positive.");
        }
        if (this.reconnectInterval != reconnectInterval) {
            this.reconnectInterval = reconnectInterval;
            if (this.reconnectingWorker != null) {
                try {
                    this.reconnectingWorker.setTimeout(reconnectInterval * 1000L);
                }
                catch (FabricException fabricException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void exportExtensionArchive(File jarFile) throws FabricConnectionException, RepositoryException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_REPOSITORY);
        this.checkEventScope(false);
        try {
            this.getRepositoryAccessor().addExtensionArchive(jarFile);
        }
        catch (RepositoryAccessorException exception) {
            throw new FabricConnectionException(1014, (Throwable)exception);
        }
    }

    @Override
    public void importExtensionArchive(String archiveName) throws FabricConnectionException, RepositoryException, ArchiveException {
        byte[] archiveContent;
        this.authorize(AccessControlOperation.CLIENT_ACCESS_REPOSITORY);
        this.checkEventScope(true);
        if (this.context.loaderRegistry.existsArchive(archiveName)) {
            throw new ArchiveException("Archive '" + archiveName + "' already exists.");
        }
        try {
            archiveContent = this.getRepositoryAccessor().getExtensionArchive(archiveName);
        }
        catch (RepositoryAccessorException exception) {
            throw new FabricConnectionException(1014, (Throwable)exception);
        }
        this.context.loaderRegistry.addArchive(archiveName, archiveContent, -1L);
        Trace.logInfo(this, "Extension archive '" + archiveName + "' imported.");
    }

    @Override
    public void importPackage(String packageName) throws FabricConnectionException, NamingException, RepositoryException, ArchiveException {
        Package pkg;
        this.authorize(AccessControlOperation.CLIENT_ACCESS_REPOSITORY);
        this.checkEventScope(true);
        if (this.context.loaderRegistry.existsPackage(packageName)) {
            throw new ArchiveException("Package '" + packageName + "' already exists.");
        }
        try {
            pkg = this.getRepositoryAccessor().getPackage(packageName);
        }
        catch (RepositoryAccessorException exception) {
            throw new FabricConnectionException(1014, (Throwable)exception);
        }
        HashMap<String, byte[]> archives = new HashMap<String, byte[]>();
        for (String archiveName : pkg.listJARs()) {
            try {
                archives.put(archiveName, this.getRepositoryAccessor().getArchive(archiveName));
            }
            catch (RepositoryAccessorException exception) {
                throw new FabricConnectionException(1014, (Throwable)exception);
            }
        }
        this.context.loaderRegistry.addPackage(packageName, archives);
        Trace.logInfo(this, "Package '" + packageName + "' imported.");
    }

    @Override
    public void exportSemanticType(String typeName) throws FabricConnectionException, SemanticTypeFactoryException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_REPOSITORY);
        this.checkEventScope(false);
        SemanticType type = this.context.getSemanticTypeCache().lookupSemanticType(typeName);
        RemoteFabricConnection.checkTypeExistence(typeName, type);
        try {
            this.raiseInternalRequest(37, type);
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof SemanticTypeFactoryException) {
                throw (SemanticTypeFactoryException)exception.getCause();
            }
            this.throwInternalRequestError(37, exception);
        }
    }

    @Override
    public void importSemanticType(String typeName) throws FabricConnectionException, SemanticTypeFactoryException, ArchiveException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_REPOSITORY);
        this.checkEventScope(true);
        if (this.context.getSemanticTypeCache().existsSemanticType(typeName)) {
            RemoteFabricConnection.throwTypeAlreadyExists(typeName);
        }
        AbstractExchange.ImportSemanticTypeData data = null;
        try {
            data = (AbstractExchange.ImportSemanticTypeData)this.raiseInternalRequest(38, new Pair<String, Map<String, Long>>(typeName, this.context.loaderRegistry.getArchiveTimestamps()));
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof SemanticTypeFactoryException) {
                throw (SemanticTypeFactoryException)exception.getCause();
            }
            this.throwInternalRequestError(38, exception);
        }
        this.doImportSemanticType(data);
        Trace.logInfo(this, "Semantic type '" + typeName + "' imported.");
    }

    @Override
    public void exportEventPrototype(String eventId) throws FabricConnectionException, DatagramFactoryException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_REPOSITORY);
        this.checkEventScope(false);
        Pair<Prototype, ImmutableEventDatagram> prototype = this.context.getClientDatagramPrototypeFactory().getPrototype(eventId);
        try {
            this.raiseInternalRequest(39, new AbstractExchange.EventPrototypeData(prototype));
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof DatagramFactoryException) {
                throw (DatagramFactoryException)exception.getCause();
            }
            this.throwInternalRequestError(39, exception);
        }
    }

    @Override
    public void importEventPrototype(String eventId) throws FabricConnectionException, DatagramFactoryException, ArchiveException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_REPOSITORY);
        this.checkEventScope(true);
        Object firstData = null;
        try {
            firstData = this.raiseInternalRequest(40, new AbstractExchange.ImportEventPrototypeData(eventId, this.context.loaderRegistry.getArchiveTimestamps()));
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof DatagramFactoryException) {
                throw (DatagramFactoryException)exception.getCause();
            }
            this.throwInternalRequestError(40, exception);
        }
        AbstractExchange.EventPrototypeData finalData = null;
        if (firstData instanceof AbstractExchange.ImportSemanticTypeData) {
            try {
                this.doImportSemanticType(firstData);
                finalData = (AbstractExchange.EventPrototypeData)this.raiseInternalRequest(40, new AbstractExchange.ImportEventPrototypeData(eventId, null));
            }
            catch (Exception exception) {
                if (exception.getCause() instanceof DatagramFactoryException) {
                    throw (DatagramFactoryException)exception.getCause();
                }
                if (exception instanceof ArchiveException) {
                    throw (ArchiveException)exception;
                }
                this.throwInternalRequestError(40, exception);
            }
        } else {
            finalData = firstData;
        }
        FabricEventSourceFactoryImpl.resolveAnnotations(finalData.event);
        this.context.getClientDatagramPrototypeFactory().doAddEventPrototype(finalData.prototype, finalData.event, false);
        Trace.logInfo(this, "Event prototype [" + eventId + "] imported.");
    }

    protected void throwInternalRequestError(int eventId, Exception exception) throws FabricConnectionException {
        throw new FabricConnectionException(1014, "Raising of internal request [" + this.exchange.getInternalEventName(eventId) + "] failed.", exception);
    }

    private void doImportSemanticType(AbstractExchange.ImportSemanticTypeData data) throws SemanticTypeFactoryException, ArchiveException {
        for (Map.Entry<String, Pair<byte[], Long>> entry : data.archives.entrySet()) {
            this.context.loaderRegistry.addArchive(entry.getKey(), (byte[])entry.getValue().first, (Long)entry.getValue().second);
        }
        for (SemanticType type : data.types) {
            if (this.context.getSemanticTypeCache().existsSemanticType(type.getTypeName())) continue;
            this.context.getSemanticTypeFactory().addSemanticType(type);
        }
    }

    @Override
    protected synchronized PingResult doPing() {
        for (String url : this.urls) {
            try {
                return (PingResult)this.raiseInstantInternalRequest(url, 30, Version.getVersion());
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
        return new PingResult(PingState.UNAVAILABLE);
    }

    @Override
    protected AbstractRepositoryAccessor createLocalRepositoryAccessor() throws FabricConnectionException {
        return new ClientRemoteRepositoryAccessorImpl(this, this.component.moderator.getFabricNode());
    }

    @Override
    protected AbstractRepositoryAccessor createRemoteRepositoryAccessor(FabricNodeReference node) throws FabricConnectionException {
        return new ClientRemoteRepositoryAccessorImpl(this, node);
    }

    @Override
    public synchronized void open() throws FabricConnectionException, SecurityManagerException {
        this.open(10L);
    }

    @Override
    public synchronized void open(long timeout) throws FabricConnectionException, SecurityManagerException {
        this.setConnectionTimeout(timeout);
        if (this.isReconnecting()) {
            this.stopReconnecting(true);
            this.reopen();
        } else {
            super.open();
        }
    }

    void setConnectionTimeout(long timeout) throws FabricConnectionException {
        if (timeout <= 0L) {
            throw new FabricConnectionException(1006, "Connect timeout must be positive.");
        }
        this.connectionTimeout = timeout * 1000L;
    }

    @Override
    protected void doOpen() throws FabricConnectionException, SecurityManagerException {
        if (!this.isReopening) {
            this.component.initInternal(this.context.getDatagramPrototypeCache());
        }
        if (this.component.getEventScope() != EventScope.LOCAL) {
            this.doOpen(false);
        }
    }

    String doOpen(boolean anonymous) throws FabricConnectionException, SecurityManagerException {
        try {
            this.exchange.init();
            this.exchange.start();
            AbstractExchange.ClientConnectReplyData replyData = null;
            Exception connectingException = null;
            for (int i = 0; i < this.urls.size(); ++i) {
                String url = (String)this.urls.get(i);
                try {
                    this.onConnecting(url);
                    replyData = this.connect(new LinkAddress(url), this.connectionTimeout, anonymous, this.isReopening);
                    this.url = url;
                    break;
                }
                catch (Exception exception) {
                    if (this.isReconnecting() || i < this.urls.size() - 1) {
                        this.onConnectingFailure(exception, url);
                    }
                    connectingException = exception;
                    continue;
                }
            }
            if (replyData == null) {
                this.exchange.isStarted = false;
                throw this.isReconnecting() ? new FabricConnectionException(-1, (Throwable)connectingException) : connectingException;
            }
            if (replyData.currentUser != null) {
                if (this.component.securityManager == null) {
                    this.component.securityManager = new ClientSecurityManagerProxy(replyData.currentUser, this);
                } else {
                    this.component.securityManager.setCurrentUser(replyData.currentUser);
                }
                if (this.component.securityContext == null) {
                    this.component.securityContext = new SecurityContextImpl(replyData.currentUser, (Object)this.component.securityManager);
                } else {
                    this.component.securityContext.setUser(replyData.currentUser);
                }
                this.userName = replyData.currentUser.getName().toString();
            }
            this.hostTimezone = TimeZone.getTimeZone(replyData.hostTimezone);
            this.nodeTimezone = TimeZone.getTimeZone(replyData.nodeTimezone);
            Charset charset = this.ccsid = replyData.ccsid != null ? Charset.forName(replyData.ccsid) : Charset.defaultCharset();
            if (!anonymous) {
                this.exchange.bind(this.isReconnecting());
            }
            return replyData.nodeName;
        }
        catch (Exception exception) {
            if (exception instanceof FabricConnectionException) {
                throw (FabricConnectionException)exception;
            }
            throw new FabricConnectionException(1002, "Opening Fabric connection '" + this.component.getFullName() + "' failed.", exception);
        }
    }

    @Override
    protected synchronized void doClose(long timeout) throws FabricConnectionException {
        if (this.isReconnecting()) {
            this.stopReconnecting(true);
            this.isOpened = true;
        }
        super.doClose(timeout);
    }

    @Override
    protected void doCloseInternal(long timeout) throws FabricConnectionException {
        this.component.destroyInternal(timeout);
        if (this.component.getEventScope() != EventScope.LOCAL) {
            this.stopReconnecting(true);
            this.stopExchange(false);
        }
    }

    synchronized void forcedClose(boolean shutdown) {
        if (this.isOpened) {
            this.exchange.forcedClosingInProgress = true;
            boolean finalClose = shutdown || this.reconnectAttempts == 0;
            this.forcedCloseSLSessions(finalClose);
            this.forcedCloseAccessors(finalClose);
            this.closeRepositoryAccessors(finalClose);
            this.closeSecurityManager();
            this.component.destroyInternal(0L, finalClose);
            this.exchange.unbind();
            this.exchange.stop();
            this.exchange.clear();
            this.exchange.forcedClosingInProgress = false;
            this.isOpened = false;
            this.exchange.logInfo("Fabric connection '" + this.component.getFullName() + "' forcibly closed.");
            if (!shutdown && this.reconnectAttempts != 0) {
                this.startReconnecting();
            }
        }
    }

    AbstractExchange.ClientConnectReplyData connect(LinkAddress address, long timeout, boolean anonymous, boolean reconnect) throws Exception {
        if (this.securityToken != null) {
            this.userName = null;
            this.password = this.securityToken;
        }
        return this.exchange.connect(address, timeout, anonymous, false, reconnect);
    }

    void stopExchange(boolean anonymous) throws FabricConnectionException {
        if (this.exchange.isStarted()) {
            try {
                if (!anonymous) {
                    this.exchange.unbind();
                }
                this.exchange.disconnect(anonymous);
                this.exchange.stop();
                this.exchange.clear();
            }
            catch (Exception exception) {
                this.exchange.stop();
                this.exchange.clear();
                throw new FabricConnectionException(1002, "Closing Fabric connection '" + this.component.getFullName() + "' failed.", exception);
            }
        }
    }

    <TReplyData> TReplyData raiseInternalRequest(int eventId, Object data) throws Exception {
        return this.exchange.raiseInternalRequest(eventId, data);
    }

    Object raiseInstantInternalRequest(int eventId, Object data) throws Exception {
        return this.raiseInstantInternalRequest(this.url != null ? this.url : (String)this.urls.iterator().next(), eventId, data);
    }

    Object raiseInstantInternalRequest(String url, int eventId, Object data) throws Exception {
        this.exchange.initCore();
        return this.exchange.raiseInstantInternalRequest(this.getAddress(url), eventId, data);
    }

    private LinkAddress getAddress() throws FabricException {
        return new LinkAddress(this.url != null ? this.url : (String)this.urls.iterator().next());
    }

    private LinkAddress getAddress(String url) throws FabricException {
        return new LinkAddress(url);
    }

    @Override
    AbstractExchange getExchange() {
        return this.exchange;
    }

    @Override
    FabricGroupManager doGetFabricGroupManager() {
        return this.exchange.groupManager;
    }

    @Override
    public boolean isReconnecting() {
        return this.reconnectingWorker != null;
    }

    protected void startReconnecting() {
        if (this.reconnectAttempts != 0 && this.reconnectingWorker == null) {
            try {
                this.reconnectingWorker = new ReconnectingWorker();
            }
            catch (FabricException fabricException) {
                // empty catch block
            }
            this.reconnectingWorker.start();
            this.exchange.logInfo("Reconnecting started.");
        }
    }

    private void stopReconnecting(boolean printLog) {
        if (this.reconnectingWorker != null) {
            this.reconnectingWorker.stop();
            this.reconnectingWorker = null;
            this.onReconnectingStop(printLog);
        }
    }

    private synchronized void reopen() throws FabricConnectionException, SecurityManagerException {
        this.isReopening = true;
        try {
            super.open();
            this.restoreConsumers();
            this.reopenAccessors();
            this.reopenSLSessions();
            this.reopenRepositoryAccessors();
        }
        finally {
            this.isReopening = false;
        }
    }

    private void restoreConsumers() {
        this.exchange.restoreConsumers();
    }

    private void reopenAccessors() {
        this.component.reopenAccessors();
    }

    private void reopenSLSessions() {
        if (this.slSessions != null) {
            for (SLSessionImpl session : new ArrayList(this.slSessions.values())) {
                try {
                    session.reopen();
                }
                catch (SLSessionException exception) {
                    Trace.logException(this, exception, false);
                    Trace.logError(this, "Reopening SLANG session '" + session.getName() + "' failed.");
                }
            }
        }
    }

    @Override
    protected void removeSLSession(SLSessionImpl session) {
        if (this.reconnectAttempts == 0) {
            super.removeSLSession(session);
        }
    }

    private void reopenRepositoryAccessors() {
        if (this.localRepositoryAccessor != null) {
            this.localRepositoryAccessor.open();
        }
        if (this.remoteRepositoryAccessors != null) {
            new ArrayList(this.remoteRepositoryAccessors.values()).forEach(AbstractRepositoryAccessor::open);
        }
    }

    void onConnecting(String url) {
    }

    void onConnectingFailure(Exception exception, String url) {
        this.exchange.logException(exception, false, "Connecting to '" + url + "' failed.");
    }

    void onReconnectingStart(int iAttempt) {
        this.exchange.logInfo("Reconnecting is running (attempt #" + iAttempt + ")...");
    }

    void onReconnectingStop(boolean printLog) {
        if (printLog) {
            this.exchange.logInfo("Reconnecting stopped.");
        }
    }

    void onReconnectingSuccess() {
        this.exchange.logInfo("Reconnecting completed successfully.");
    }

    void onReconnectingFailure(Exception exception) {
        this.exchange.logException(exception, false, "Reconnecting failed.");
    }

    @Override
    protected String createFactoryConnectionComponent(String nodeName, String factoryType, String factoryName, long timeout) throws FabricConnectionException {
        this.checkOpened();
        try {
            return (String)this.exchange.raiseInternalRequest(nodeName, 52, (Object)new DynamicComponentsManager.ComponentData(factoryType, factoryName, this.userName), timeout);
        }
        catch (Exception exception) {
            this.throwInternalRequestError(52, exception);
            return null;
        }
    }

    @Override
    protected void onFactoryConnectionComponentAccessorCreated(String nodeName, FabricComponentAccessor accessor) throws FabricConnectionException {
        this.checkOpened();
        try {
            this.exchange.raiseInternalRequest(nodeName, 53, (Object)new DynamicComponentsManager.AccessorData(accessor.getComponentType(), accessor.getComponentName()));
        }
        catch (Exception exception) {
            this.throwInternalRequestError(53, exception);
        }
    }

    @Override
    void authorize(AccessControlOperation operation) throws FabricConnectionException {
        this.authorizeAnonymous(operation);
        super.authorize(operation);
    }

    @Override
    public TimeZone getHostTimezone() throws FabricConnectionException {
        this.checkOpened();
        return this.hostTimezone;
    }

    @Override
    public TimeZone getNodeTimezone() throws FabricConnectionException {
        this.checkOpened();
        return this.nodeTimezone;
    }

    @Override
    public Charset getCCSID() throws FabricConnectionException {
        this.checkOpened();
        return this.ccsid;
    }

    @Override
    public long nextGlobalCount() throws FabricConnectionException {
        this.checkOpened();
        return this.invokeGlobalCounterOperation(AbstractExchange.GlobalCounterOperation.NEXT);
    }

    @Override
    public long showGlobalCounter() throws FabricConnectionException {
        this.checkOpened();
        return this.invokeGlobalCounterOperation(AbstractExchange.GlobalCounterOperation.SHOW);
    }

    @Override
    public long resetGlobalCounter() throws FabricConnectionException {
        this.checkOpened();
        this.checkResetGlobalCounterRights();
        return this.invokeGlobalCounterOperation(AbstractExchange.GlobalCounterOperation.RESET);
    }

    private long invokeGlobalCounterOperation(AbstractExchange.GlobalCounterOperation operation) throws FabricConnectionException {
        try {
            return (Long)this.raiseInternalRequest(57, (Object)operation);
        }
        catch (Exception exception) {
            this.throwInternalRequestError(57, exception);
            return -1L;
        }
    }

    private class ReconnectingWorker
    extends MonitorWorker {
        int iAttempt;

        ReconnectingWorker() throws FabricException {
            super("EXCH:Reconnecting.Thread", "Performs reconnecting to the sysplex.", RemoteFabricConnection.this.reconnectInterval * 1000L);
            this.iAttempt = 0;
        }

        @Override
        protected void doExecute() throws FabricException {
            block3: {
                RemoteFabricConnection.this.onReconnectingStart(++this.iAttempt);
                try {
                    RemoteFabricConnection.this.reopen();
                    RemoteFabricConnection.this.onReconnectingSuccess();
                    RemoteFabricConnection.this.stopReconnecting(false);
                }
                catch (Exception exception) {
                    if (exception instanceof FabricConnectionException && ((FabricConnectionException)exception).getErrorCode() == -1) break block3;
                    RemoteFabricConnection.this.onReconnectingFailure(exception);
                }
            }
            if (!this.hasRemainingAttempts()) {
                RemoteFabricConnection.this.stopReconnecting(true);
            }
        }

        private boolean hasRemainingAttempts() {
            return RemoteFabricConnection.this.reconnectAttempts == -1 || this.iAttempt < RemoteFabricConnection.this.reconnectAttempts;
        }
    }
}

