/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AsyncConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.ComponentReferenceImpl;
import com.streamscape.sef.dispatcher.DirectConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.EventCacheReferenceImpl;
import com.streamscape.sef.dispatcher.ExchangeDomainConstraint;
import com.streamscape.sef.dispatcher.ExchangeRangeConstraint;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.ReceiverReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationSourceReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationTargetReferenceImpl;
import com.streamscape.sef.dispatcher.RequestConsumerReferenceImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.AccessorReference;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.moderator.AsyncConsumerReference;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.ConsumerReference;
import com.streamscape.sef.moderator.DirectConsumerReference;
import com.streamscape.sef.moderator.DomainConstraintReference;
import com.streamscape.sef.moderator.EndpointReference;
import com.streamscape.sef.moderator.EntityReference;
import com.streamscape.sef.moderator.EventCacheReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.EventFlowMap;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RangeConstraintReference;
import com.streamscape.sef.moderator.ReceiverReference;
import com.streamscape.sef.moderator.ReplicationSourceReference;
import com.streamscape.sef.moderator.ReplicationTargetReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class ModeratorImpl
implements Moderator {
    AbstractExchange exchange;

    public ModeratorImpl(AbstractExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public String getDomain() {
        return this.exchange.getDomain();
    }

    @Override
    public FabricNodeReference getFabricNode() {
        return this.getNode();
    }

    @Override
    public List<FabricNodeReference> getFabricNodes() {
        ArrayList<FabricNodeReference> result = new ArrayList<FabricNodeReference>();
        result.add(this.getNode());
        this.exchange.getFabricNodes().stream().filter(FabricNode::isReady).forEach(result::add);
        return result;
    }

    @Override
    public List<ComponentReference> getComponents(EventScope eventScope) {
        return this.getEndpoints(eventScope, ComponentReference.class, new EndpointsGetter<ComponentReferenceImpl>(this){

            @Override
            Collection<ComponentReferenceImpl> getEndpoints() {
                return this.node.doGetComponents();
            }
        });
    }

    @Override
    public List<ConsumerReference> getConsumers(EventScope eventScope) {
        ArrayList<ConsumerReference> result = new ArrayList<ConsumerReference>();
        result.addAll(this.getDirectConsumers(eventScope));
        result.addAll(this.getAsyncConsumers(eventScope));
        result.addAll(this.getRequestConsumers(eventScope));
        result.addAll(this.getReceivers(eventScope));
        return result;
    }

    @Override
    public List<EventConsumerReference> getEventConsumers(EventScope eventScope) {
        ArrayList<EventConsumerReference> result = new ArrayList<EventConsumerReference>();
        result.addAll(this.getDirectConsumers(eventScope));
        result.addAll(this.getAsyncConsumers(eventScope));
        result.addAll(this.getReceivers(eventScope));
        return result;
    }

    @Override
    public List<DirectConsumerReference> getDirectConsumers(EventScope eventScope) {
        return this.getEndpoints(eventScope, DirectConsumerReference.class, new EndpointsGetter<DirectConsumerReferenceImpl>(this){

            @Override
            Collection<DirectConsumerReferenceImpl> getEndpoints() {
                return this.node.doGetDirectConsumers();
            }
        });
    }

    @Override
    public List<AsyncConsumerReference> getAsyncConsumers(EventScope eventScope) {
        return this.getEndpoints(eventScope, AsyncConsumerReference.class, new EndpointsGetter<AsyncConsumerReferenceImpl>(this){

            @Override
            Collection<AsyncConsumerReferenceImpl> getEndpoints() {
                return this.node.doGetAsyncConsumers();
            }
        });
    }

    @Override
    public List<RequestConsumerReference> getRequestConsumers(EventScope eventScope) {
        return this.getEndpoints(eventScope, RequestConsumerReference.class, new EndpointsGetter<RequestConsumerReferenceImpl>(this){

            @Override
            Collection<RequestConsumerReferenceImpl> getEndpoints() {
                return this.node.doGetRequestConsumers();
            }
        });
    }

    @Override
    public List<ReceiverReference> getReceivers(EventScope eventScope) {
        return this.getEndpoints(eventScope, ReceiverReference.class, new EndpointsGetter<ReceiverReferenceImpl>(this){

            @Override
            Collection<ReceiverReferenceImpl> getEndpoints() {
                return this.node.doGetReceivers();
            }
        });
    }

    @Override
    public List<EventCacheReference> getEventCaches() {
        return this.getEndpoints(EventScope.INHERITED, EventCacheReference.class, new EndpointsGetter<EventCacheReferenceImpl>(this){

            @Override
            Collection<EventCacheReferenceImpl> getEndpoints() {
                return this.node.doGetEventCaches();
            }
        });
    }

    @Override
    public List<DomainConstraintReference> getDomainConstraints() {
        return new ArrayList<DomainConstraintReference>(this.exchange.globalDomainConstraints.values());
    }

    @Override
    public List<RangeConstraintReference> getRangeConstraints() {
        return new ArrayList<RangeConstraintReference>(this.exchange.globalRangeConstraints.values());
    }

    @Override
    public List<DomainConstraintReference> getDomainConstraints(String pattern) {
        return this.exchange.getDataConstraintStore().getDomains(pattern).stream().map(domain -> ((ExchangeDomainConstraint)domain).getReference()).collect(Collectors.toList());
    }

    @Override
    public List<RangeConstraintReference> getRangeConstraints(String pattern) {
        return this.exchange.getDataConstraintStore().getRanges(pattern).stream().map(domain -> ((ExchangeRangeConstraint)domain).getReference()).collect(Collectors.toList());
    }

    @Override
    public List<ReplicationSourceReference> getReplicationSources(EventScope eventScope) {
        return this.getEndpoints(eventScope, ReplicationSourceReference.class, new EndpointsGetter<ReplicationSourceReferenceImpl>(this){

            @Override
            Collection<ReplicationSourceReferenceImpl> getEndpoints() {
                return this.node.doGetReplicationSources();
            }
        });
    }

    @Override
    public List<ReplicationTargetReference> getReplicationTargets(EventScope eventScope) {
        return this.getEndpoints(eventScope, ReplicationTargetReference.class, new EndpointsGetter<ReplicationTargetReferenceImpl>(this){

            @Override
            Collection<ReplicationTargetReferenceImpl> getEndpoints() {
                return this.node.doGetReplicationTargets();
            }
        });
    }

    @Override
    public List<AccessorReference> getAccessors(final EventScope eventScope) {
        return this.getAccessorEntities(eventScope, new EndpointsGetter<AccessorReference>(this){

            @Override
            Collection<AccessorReference> getEndpoints() {
                return this.node.getAccessors(eventScope);
            }
        });
    }

    @Override
    public List<AccessorSessionReference> getAccessorSessions(final EventScope eventScope) {
        return this.getAccessorEntities(eventScope, new EndpointsGetter<AccessorSessionReference>(this){

            @Override
            Collection<AccessorSessionReference> getEndpoints() {
                return this.node.getAccessorSessions(eventScope);
            }
        });
    }

    <TResult extends EntityReference> List<TResult> getAccessorEntities(EventScope eventScope, EndpointsGetter<TResult> getter) {
        eventScope = InternalUtils.checkEventScope(eventScope);
        ArrayList result = new ArrayList();
        this.getEndpointsLocal(eventScope, getter, result);
        this.getEndpointsRemote(eventScope, getter, result);
        return result;
    }

    @Override
    public List<EventConsumerReference> getEventConsumers(String groupName) {
        return this.getGroupConsumers(groupName, new InternalUtils.EventConsumersGetter());
    }

    @Override
    public List<AsyncConsumerReference> getAsyncConsumers(String groupName) {
        return this.getGroupConsumers(groupName, new InternalUtils.AsyncConsumersGetter());
    }

    @Override
    public List<ReceiverReference> getReceivers(String groupName) {
        return this.getGroupConsumers(groupName, new InternalUtils.ReceiversGetter());
    }

    private <T extends EventConsumerReference> List<T> getGroupConsumers(String groupName, InternalUtils.ConsumersGetter<T> getter) {
        return InternalUtils.getGroupConsumers(this.getComponents(EventScope.INHERITED), groupName, getter);
    }

    @Override
    public FabricNodeReference lookupFabricNode(FabricAddress address) {
        return this.exchange.isLocal(address) ? this.getNode() : this.checkNodeReady(this.exchange.getFabricNode(address.getNodeAddress()), true);
    }

    @Override
    public FabricNodeReference lookupFabricNode(String name) {
        return this.lookupFabricNode(name, true);
    }

    FabricNodeReference lookupFabricNode(String name, boolean checkNodeReady) {
        return this.getNode().getName().equals(name) ? this.getNode() : this.checkNodeReady(this.exchange.getFabricNode(name), checkNodeReady);
    }

    @Override
    public ComponentReference lookupComponent(FabricAddress address) {
        return this.lookupEndpoint(new EndpointGetterByAddress<ComponentReference>(this, address){

            @Override
            ComponentReference getEndpoint() {
                return this.node.getComponent(this.address);
            }
        });
    }

    @Override
    public ComponentReference lookupComponent(String name) {
        return this.lookupEndpoint(name, new EndpointGetter<ComponentReference>(this, name){

            @Override
            ComponentReference getEndpoint() {
                return this.node.lookupComponent(this.name);
            }
        });
    }

    @Override
    public ConsumerReference lookupConsumer(FabricAddress address) {
        EventConsumerReference result = this.lookupEventConsumer(address);
        return result != null ? result : this.lookupRequestConsumer(address);
    }

    @Override
    public ConsumerReference lookupConsumer(String name) {
        EventConsumerReference result = this.lookupEventConsumer(name);
        return result != null ? result : this.lookupRequestConsumer(name);
    }

    @Override
    public EventConsumerReference lookupEventConsumer(FabricAddress address) {
        EventConsumerReference result = this.lookupDirectConsumer(address);
        if (result == null && (result = this.lookupAsyncConsumer(address)) == null) {
            result = this.lookupReceiver(address);
        }
        return result;
    }

    @Override
    public EventConsumerReference lookupEventConsumer(String name) {
        EventConsumerReference result = this.lookupDirectConsumer(name);
        if (result == null && (result = this.lookupAsyncConsumer(name)) == null) {
            result = this.lookupReceiver(name);
        }
        return result;
    }

    @Override
    public DirectConsumerReference lookupDirectConsumer(FabricAddress address) {
        return this.lookupEndpoint(new EndpointGetterByAddress<DirectConsumerReference>(this, address){

            @Override
            DirectConsumerReference getEndpoint() {
                return this.node.getDirectConsumer(this.address);
            }
        });
    }

    @Override
    public DirectConsumerReference lookupDirectConsumer(String name) {
        return this.lookupEndpoint(name, new EndpointGetter<DirectConsumerReference>(this, name){

            @Override
            DirectConsumerReference getEndpoint() {
                return this.node.lookupDirectConsumer(this.name);
            }
        });
    }

    @Override
    public AsyncConsumerReference lookupAsyncConsumer(FabricAddress address) {
        return this.lookupEndpoint(new EndpointGetterByAddress<AsyncConsumerReference>(this, address){

            @Override
            AsyncConsumerReference getEndpoint() {
                return this.node.getAsyncConsumer(this.address);
            }
        });
    }

    @Override
    public AsyncConsumerReference lookupAsyncConsumer(String name) {
        return this.lookupEndpoint(name, new EndpointGetter<AsyncConsumerReference>(this, name){

            @Override
            AsyncConsumerReference getEndpoint() {
                return this.node.lookupAsyncConsumer(this.name);
            }
        });
    }

    @Override
    public RequestConsumerReference lookupRequestConsumer(FabricAddress address) {
        return this.lookupEndpoint(new EndpointGetterByAddress<RequestConsumerReference>(this, address){

            @Override
            RequestConsumerReference getEndpoint() {
                return this.node.getRequestConsumer(this.address);
            }
        });
    }

    @Override
    public RequestConsumerReference lookupRequestConsumer(String name) {
        return this.lookupRequestConsumer(name, true);
    }

    RequestConsumerReference lookupRequestConsumer(String name, boolean checkNodeReady) {
        return this.lookupEndpoint(name, new EndpointGetter<RequestConsumerReference>(this, name){

            @Override
            RequestConsumerReference getEndpoint() {
                return this.node.lookupRequestConsumer(this.name);
            }
        }, checkNodeReady);
    }

    @Override
    public ReceiverReference lookupReceiver(FabricAddress address) {
        return this.lookupEndpoint(new EndpointGetterByAddress<ReceiverReference>(this, address){

            @Override
            ReceiverReference getEndpoint() {
                return this.node.getReceiver(this.address);
            }
        });
    }

    @Override
    public ReceiverReference lookupReceiver(String name) {
        return this.lookupEndpoint(name, new EndpointGetter<ReceiverReference>(this, name){

            @Override
            ReceiverReference getEndpoint() {
                return this.node.lookupReceiver(this.name);
            }
        });
    }

    @Override
    public EventCacheReference lookupEventCache(String eventFilter) {
        for (FabricNodeReference node : this.getFabricNodes()) {
            EventCacheReference result = node.lookupEventCache(eventFilter);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public DomainConstraintReference lookupDomainConstraint(String name) {
        return this.exchange.globalDomainConstraints.get(name);
    }

    @Override
    public RangeConstraintReference lookupRangeConstraint(String name) {
        return this.exchange.globalRangeConstraints.get(name);
    }

    @Override
    public ReplicationSourceReference lookupReplicationSource(String name) {
        return this.lookupEndpoint(name, new EndpointGetter<ReplicationSourceReference>(this, name){

            @Override
            ReplicationSourceReference getEndpoint() {
                return this.node.lookupReplicationSource(this.name);
            }
        });
    }

    @Override
    public ReplicationTargetReference lookupReplicationTarget(String name) {
        return this.lookupEndpoint(name, new EndpointGetter<ReplicationTargetReference>(this, name){

            @Override
            ReplicationTargetReference getEndpoint() {
                return this.node.lookupReplicationTarget(this.name);
            }
        });
    }

    @Override
    public AccessorReference lookupAccessor(String name) {
        return this.lookupEndpoint(name, new EndpointGetter<AccessorReference>(this, name){

            @Override
            AccessorReference getEndpoint() {
                return this.node.lookupAccessor(this.name);
            }
        });
    }

    @Override
    public AccessorSessionReference lookupAccessorSession(FabricAddress address) {
        return this.lookupEndpoint(new EndpointGetterByAddress<AccessorSessionReference>(this, address){

            @Override
            AccessorSessionReference getEndpoint() {
                return this.node.getAccessorSession(this.address);
            }
        });
    }

    @Override
    public AccessorSessionReference lookupAccessorSession(String name) {
        return this.lookupEndpoint(name, new EndpointGetter<AccessorSessionReference>(this, name){

            @Override
            AccessorSessionReference getEndpoint() {
                return this.node.lookupAccessorSession(this.name);
            }
        });
    }

    @Override
    public List<String> listFabricNodes() {
        return this.getFabricNodes().stream().map(FabricNodeReference::getName).sorted().collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public List<String> listComponents() {
        return InternalUtils.listEntities(this.getComponents(EventScope.INHERITED));
    }

    @Override
    public List<String> listConsumers() {
        return InternalUtils.listEntities(this.getConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listEventConsumers() {
        return InternalUtils.listEntities(this.getEventConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listDirectConsumers() {
        return InternalUtils.listEntities(this.getDirectConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listAsyncConsumers() {
        return InternalUtils.listEntities(this.getAsyncConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listRequestConsumers() {
        return InternalUtils.listEntities(this.getRequestConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listReceivers() {
        return InternalUtils.listEntities(this.getReceivers(EventScope.INHERITED));
    }

    @Override
    public List<String> listEventCaches() {
        return InternalUtils.listEntities(this.getEventCaches());
    }

    @Override
    public List<String> listDomainConstraints() {
        return InternalUtils.listEntities(this.getDomainConstraints());
    }

    @Override
    public List<String> listRangeConstraints() {
        return InternalUtils.listEntities(this.getRangeConstraints());
    }

    @Override
    public List<String> listReplicationSources() {
        return InternalUtils.listEntities(this.getReplicationSources(EventScope.INHERITED));
    }

    @Override
    public List<String> listReplicationTargets() {
        return InternalUtils.listEntities(this.getReplicationTargets(EventScope.INHERITED));
    }

    @Override
    public List<String> listAccessors() {
        return InternalUtils.listEntities(this.getAccessors(EventScope.INHERITED));
    }

    @Override
    public List<String> listAccessorSessions() {
        return InternalUtils.listEntities(this.getAccessorSessions(EventScope.INHERITED));
    }

    @Override
    public List<String> listClusters() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.exchange.isClustered()) {
            for (FabricNodeReference node : this.getFabricNodes()) {
                if (result.contains(node.getClusterName())) continue;
                result.add(node.getClusterName());
            }
        }
        return result;
    }

    @Override
    public List<String> listFabricNodesInCluster(String clusterName) {
        List<String> result = new ArrayList<String>();
        if (this.exchange.isClustered()) {
            result = this.getFabricNodes().stream().filter(node -> StringUtils.equalsNullSafe(node.getClusterName(), clusterName)).map(FabricNodeReference::getName).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public EventFlowMap getEventFlowMap(boolean all) {
        return this.exchange.getMergedEventFlowMap(all);
    }

    EventFlowMap doGetEventFlowMap(boolean all) {
        return this.exchange.getEventFlowMap(all);
    }

    <TResult extends EntityReference, T extends TResult> List<TResult> getEndpoints(EventScope eventScope, Class<TResult> resultClass, EndpointsGetter<T> consumersGetter) {
        eventScope = InternalUtils.checkEventScope(eventScope);
        ArrayList result = new ArrayList();
        switch (eventScope) {
            case OBSERVABLE: {
                this.getEndpointsLocal(eventScope, consumersGetter, result);
                break;
            }
            case CLUSTER: 
            case GLOBAL: 
            case INHERITED: {
                this.getEndpointsLocal(eventScope, consumersGetter, result);
                this.getEndpointsRemote(eventScope, consumersGetter, result);
            }
        }
        return result;
    }

    <TResult extends EntityReference, T extends TResult> void getEndpointsLocal(EventScope eventScope, EndpointsGetter<T> getter, List<TResult> result) {
        getter.node = this.getNode();
        result.addAll(getter.getEndpoints().stream().filter(endpoint -> InternalUtils.matches(endpoint, eventScope)).collect(Collectors.toList()));
    }

    <TResult extends EntityReference, T extends TResult> void getEndpointsRemote(EventScope eventScope, EndpointsGetter<T> getter, List<TResult> result) {
        this.exchange.getFabricNodes().stream().filter(FabricNode::isReady).forEach(fabricNode -> {
            getter.node = fabricNode;
            result.addAll(getter.getEndpoints().stream().filter(endpoint -> InternalUtils.matches(endpoint, eventScope)).collect(Collectors.toList()));
        });
    }

    <T extends EndpointReference> T lookupEndpoint(EndpointGetterByAddress<T> endpointGetter) {
        return this.isLocal(endpointGetter.address) ? this.lookupEndpointLocal(endpointGetter) : this.lookupEndpointRemote(endpointGetter);
    }

    boolean isLocal(FabricAddress fabricAddress) {
        return fabricAddress.belongsToSameNode(this.getNode().getFabricAddress());
    }

    <T extends EndpointReference> T lookupEndpointLocal(EndpointGetterByAddress<T> endpointGetter) {
        endpointGetter.node = this.getNode();
        return (T)((EndpointReference)endpointGetter.getEndpoint());
    }

    <T extends EndpointReference> T lookupEndpointRemote(EndpointGetterByAddress<T> endpointGetter) {
        endpointGetter.node = this.checkNodeReady(this.exchange.getFabricNode(endpointGetter.address.getNodeAddress()), true);
        return (T)(endpointGetter.node != null ? (EndpointReference)endpointGetter.getEndpoint() : null);
    }

    <T extends EntityReference> T lookupEndpoint(String name, EndpointGetter<T> endpointGetter) {
        return this.lookupEndpoint(name, endpointGetter, true);
    }

    <T extends EntityReference> T lookupEndpoint(String name, EndpointGetter<T> endpointGetter, boolean checkNodeReady) {
        endpointGetter.node = this.lookupFabricNode(this.getNodeName(name), checkNodeReady);
        return (T)(endpointGetter.node != null ? (EntityReference)endpointGetter.getEndpoint() : null);
    }

    String getNodeName(String fullName) {
        int iDelimiter = ModeratorUtils.getNodeNameIndex(fullName);
        return iDelimiter == -1 ? this.getNode().getName() : fullName.substring(0, iDelimiter);
    }

    FabricNode getNode() {
        return this.exchange.getNode();
    }

    FabricNode checkNodeReady(FabricNode node, boolean checkNodeReady) {
        return node != null && (!checkNodeReady || node.isReady()) ? node : null;
    }

    static abstract class EndpointsGetter<T> {
        FabricNode node;

        EndpointsGetter() {
        }

        abstract Collection<T> getEndpoints();
    }

    static abstract class EndpointGetterByAddress<T> {
        FabricAddress address;
        FabricNode node;

        EndpointGetterByAddress(FabricAddress address) {
            this.address = address;
        }

        abstract T getEndpoint();
    }

    static abstract class EndpointGetter<T> {
        String name;
        FabricNodeReference node;

        EndpointGetter(String name) {
            this.name = name;
        }

        abstract T getEndpoint();
    }
}

