/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.PingResult;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.accessor.FabricComponentAccessor;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractFabricConsumer;
import com.streamscape.sef.dispatcher.AbstractRepositoryAccessor;
import com.streamscape.sef.dispatcher.DynamicComponentsManager;
import com.streamscape.sef.dispatcher.LocalClientComponent;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.dispatcher.RuntimeRemoteRepositoryAccessorImpl;
import com.streamscape.sef.dispatcher.RuntimeRepositoryAccessorImpl;
import com.streamscape.sef.dispatcher.RuntimeSecurityManagerProxy;
import com.streamscape.sef.dispatcher.SLSessionImpl;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.group.FabricGroupManager;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.nio.charset.Charset;
import java.util.TimeZone;

public class LocalFabricConnection
extends AbstractFabricConnection {
    protected transient RuntimeContext context;

    protected LocalFabricConnection(String type, String name, RuntimeContext context) {
        this.context = context;
        this.bind(new LocalClientComponent(type, name, ComponentModel.CTX_CLIENT, this));
    }

    @Override
    protected PingResult doPing() {
        return this.context.ping();
    }

    @Override
    protected AbstractRepositoryAccessor createLocalRepositoryAccessor() throws FabricConnectionException {
        try {
            return new RuntimeRepositoryAccessorImpl((AbstractFabricConnection)this, this.component.moderator.getFabricNode(), this.context);
        }
        catch (Exception exception) {
            throw new FabricConnectionException(1002, "Initialization of Repository Accessor failed.", exception);
        }
    }

    @Override
    protected AbstractRepositoryAccessor createRemoteRepositoryAccessor(FabricNodeReference node) throws FabricConnectionException {
        try {
            return new RuntimeRemoteRepositoryAccessorImpl(this, node);
        }
        catch (Exception exception) {
            throw new FabricConnectionException(1002, "Initialization of Repository Accessor failed.", exception);
        }
    }

    @Override
    protected void doOpen() throws FabricConnectionException, SecurityManagerException {
        this.authenticate();
        try {
            this.component.initInternal(this.context.getDatagramPrototypeCache());
            this.context.bind(this.component);
        }
        catch (RuntimeContextException exception) {
            throw new FabricConnectionException(1002, "Opening Fabric connection '" + this.component.getFullName() + "' failed.", exception);
        }
    }

    protected void authenticate() throws FabricConnectionException, SecurityManagerException {
        if (this.isSecurityEnabled()) {
            this.checkSecurityParameters();
            try {
                this.userName = this.securityToken != null ? this.component.authenticate(this.context.securityManagerImpl, null, null, this.securityToken, null, null) : this.component.authenticate(this.context.securityManagerImpl, this.authenticationType, this.userName, this.password, this.authenticationParameters, this.digestCalculator);
            }
            catch (Exception exception) {
                if (exception instanceof SecurityManagerException) {
                    throw (SecurityManagerException)exception;
                }
                throw new FabricConnectionException(1014, (Throwable)exception);
            }
        }
    }

    protected void checkSecurityParameters() throws SecurityManagerException {
        if (this.securityToken == null) {
            if (this.userName == null) {
                this.userName = this.context.ctxDescriptor.getSecurityPrincipal();
                this.doSetPassword(this.context.ctxDescriptor.getSecurityCredentials());
            }
            if (this.authenticationType == AuthenticationType.DIGEST && this.digestCalculator == null && this.getAuthenticationParameter("key") == null) {
                throw new SecurityManagerException(6004, "Null security key specified for default DIGEST authentication type.", this.userName);
            }
        }
    }

    @Override
    protected void doCloseInternal(long timeout) throws FabricConnectionException {
        try {
            this.component.destroyInternal(timeout);
            this.context.unbind(this.component.getContextId());
        }
        catch (RuntimeContextException exception) {
            throw new FabricConnectionException(1002, "Closing Fabric connection '" + this.component.getFullName() + "' failed.", exception);
        }
    }

    protected User createUserAnonymous(String userName, String userPassword, String userDescription, vCard vcard, String groupName, String groupDescription, String domain, boolean dropBoxOwner) throws SecurityManagerException {
        SecurityManager securityManager = this.context.getSecurityManager();
        User user = new RuntimeSecurityManagerProxy(this.context.securityManagerImpl).createUser(userName, userPassword, userDescription, vcard);
        if (dropBoxOwner) {
            user.setDropBoxOwner(true);
            securityManager.updateUser(user);
        }
        if (!securityManager.existsGroup(groupName)) {
            securityManager.createGroup(groupName, groupDescription);
        }
        securityManager.addUserToGroup(userName, groupName);
        securityManager.setUserOrganization(userName, this.lookupOrganization(domain).getName().toString());
        return securityManager.lookupUser(userName);
    }

    protected Organization lookupOrganization(String domain) throws SecurityManagerException {
        SecurityManager securityManager = this.context.getSecurityManager();
        for (Organization organization : securityManager.getOrganizations()) {
            if (!organization.getDomain().equals(domain)) continue;
            return organization;
        }
        throw new SecurityManagerException(6094, "Organization with domain '" + domain + "' does not exist.");
    }

    @Override
    AbstractExchange getExchange() {
        return this.context.exchange;
    }

    @Override
    FabricGroupManager doGetFabricGroupManager() {
        return this.context.exchange.groupManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SLResponse instantSlangRequest(String nodeName, SLStatement statement, User user, long timeout) throws Exception {
        try (SLSessionImpl slSession = new SLSessionImpl(this, nodeName, user, false);){
            SLResponse sLResponse = slSession.slangRequest(statement, timeout);
            return sLResponse;
        }
    }

    @Override
    protected String createFactoryConnectionComponent(String nodeName, String factoryType, String factoryName, long timeout) throws FabricConnectionException {
        try {
            if (this.getEventScope() != EventScope.LOCAL && nodeName != null && !nodeName.equals(this.context.getName())) {
                this.checkOpened();
                try {
                    return (String)this.getExchange().raiseInternalRequest(nodeName, 52, (Object)new DynamicComponentsManager.ComponentData(factoryType, factoryName, this.userName), timeout);
                }
                catch (Exception exception) {
                    throw new FabricConnectionException(1002, "Creating Client Factory Connection component failed.", exception);
                }
            }
            return this.context.getDynamicComponentsManager().createComponent(new DynamicComponentsManager.ComponentData(factoryType, factoryName, this.userName)).getName();
        }
        catch (Exception exception) {
            if (exception instanceof FabricConnectionException) {
                throw (FabricConnectionException)exception;
            }
            throw new FabricConnectionException(1002, "Creating Client Factory Connection component failed.", exception);
        }
    }

    @Override
    protected void onFactoryConnectionComponentAccessorCreated(String nodeName, FabricComponentAccessor accessor) throws FabricConnectionException {
        block6: {
            try {
                if (this.getEventScope() != EventScope.LOCAL && nodeName != null && !nodeName.equals(this.context.getName())) {
                    this.checkOpened();
                    try {
                        this.getExchange().raiseInternalRequest(nodeName, 53, (Object)new DynamicComponentsManager.AccessorData(accessor.getComponentType(), accessor.getComponentName()));
                        break block6;
                    }
                    catch (Exception exception) {
                        throw new FabricConnectionException(1002, "Creating Client Factory Connection component accessor failed.", exception);
                    }
                }
                this.context.getDynamicComponentsManager().onAccessorCreated(new DynamicComponentsManager.AccessorData(accessor.getComponentType(), accessor.getComponentName()));
            }
            catch (Exception exception) {
                if (exception instanceof FabricConnectionException) {
                    throw (FabricConnectionException)exception;
                }
                throw new FabricConnectionException(1002, "Creating Client Factory Connection component accessor failed.", exception);
            }
        }
    }

    @Override
    void onProducerBound(String eventId, EventFlowEntity entity, boolean isSystem) {
        this.component.addSourceEventFlow(eventId, entity, null, this.getEventScope(), isSystem);
    }

    @Override
    void onProducerUnbound(String eventId, EventFlowEntity entity) {
        if (!this.component.dispatcher.isBoundEventId(eventId)) {
            this.component.removeSourceEventFlow(eventId, entity, null);
        }
    }

    @Override
    void onConsumerCreated(AbstractFabricConsumer consumer, boolean isSystem) {
        this.component.addSinkEventFlow(EventFlowEntity.CLIENT_EVENT_CONSUMER, consumer.getName(), consumer, isSystem);
    }

    @Override
    public TimeZone getHostTimezone() throws FabricConnectionException {
        this.checkOpened();
        if (this.hostTimezone == null) {
            this.hostTimezone = this.context.getHostTimezone();
        }
        return this.hostTimezone;
    }

    @Override
    public TimeZone getNodeTimezone() throws FabricConnectionException {
        this.checkOpened();
        if (this.nodeTimezone == null) {
            this.nodeTimezone = this.context.getNodeTimezone();
        }
        return this.nodeTimezone;
    }

    @Override
    public Charset getCCSID() throws FabricConnectionException {
        this.checkOpened();
        return this.context.getCCSID();
    }

    @Override
    public long nextGlobalCount() throws FabricConnectionException {
        this.checkOpened();
        return this.context.exchange.nextGlobalCount();
    }

    @Override
    public long showGlobalCounter() throws FabricConnectionException {
        this.checkOpened();
        return this.context.exchange.showGlobalCounter();
    }

    @Override
    public long resetGlobalCounter() throws FabricConnectionException {
        this.checkOpened();
        this.checkResetGlobalCounterRights();
        return this.context.exchange.resetGlobalCounterNoCheck();
    }

    protected RuntimeExchange.ClientInfo getClientInfo() {
        return null;
    }
}

