/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sef.cli.ClientComponent;
import com.streamscape.sef.dispatcher.AbstractClientComponent;
import com.streamscape.sef.dispatcher.AbstractHTTPServerFabricConnection;
import com.streamscape.sef.dispatcher.AbstractXMPPFabricConnection;
import com.streamscape.sef.dispatcher.ComponentManifestManager;
import com.streamscape.sef.dispatcher.ComponentReferenceImpl;
import com.streamscape.sef.dispatcher.EventFlowImpl;
import com.streamscape.sef.dispatcher.LocalFabricComponent;
import com.streamscape.sef.dispatcher.LocalFabricConnection;
import com.streamscape.sef.dispatcher.SecurityManagerImpl;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.SecurityManagerException;
import java.util.Map;

class LocalClientComponent
extends AbstractClientComponent
implements ClientComponent {
    transient LocalFabricConnection connection;

    LocalClientComponent(String type, String name, ComponentModel model, LocalFabricConnection connection) {
        super(type, name, model);
        this.connection = connection;
        this.initPackageManifestManager();
    }

    @Override
    void initIsSecurityEnabled() {
        this.isSecurityEnabled = this.connection.context.isSecurityEnabled();
    }

    @Override
    void initSecurityManager() throws Exception {
        this.connection.checkOpened();
    }

    @Override
    protected void initPackageManifestManager() {
        this.manifestManager = new ComponentManifestManager(this.connection.context, this);
    }

    @Override
    void addEventFlow(EventFlowImpl flow) {
        LocalFabricComponent.addEventFlow(this.connection.context, flow);
    }

    @Override
    void removeEventFlow(EventFlowImpl flow) {
        LocalFabricComponent.removeEventFlow(this.connection.context, flow);
    }

    @Override
    String authenticate(SecurityManagerImpl securityManagerImpl, AuthenticationType type, String userName, String credentials, Map<String, String> parameters, DigestCalculator calculator) throws Exception {
        try {
            return super.authenticate(securityManagerImpl, type, userName, credentials, parameters, calculator);
        }
        catch (SecurityManagerException exception) {
            this.connection.context.exchange.setLastFailedAttemptTimestamp(ComponentReferenceImpl.getComponentModel(this), this.getType(), userName, exception);
            throw exception;
        }
    }

    boolean isHTTP() {
        return this.connection instanceof AbstractHTTPServerFabricConnection;
    }

    boolean isXMPP() {
        return this.connection instanceof AbstractXMPPFabricConnection;
    }
}

