/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.loader.ClassLoaderReference;
import com.streamscape.lib.loader.ClassLoaderRegistry;
import com.streamscape.lib.loader.FabricClassLoader;
import com.streamscape.lib.loader.FabricURLClassLoader;
import com.streamscape.lib.loader.PackageLoaderRegistry;
import com.streamscape.lib.utils.ArchiveException;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sef.dispatcher.AbstractJSerializerFactory;
import com.streamscape.sef.dispatcher.AbstractLoaderRegistry;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class LoaderRegistry
extends AbstractLoaderRegistry
implements PackageLoaderRegistry,
ClassLoaderRegistry {
    public static final String SYSTEM_CLASS_LOADER_NAME = "SYS$ClassLoader";
    protected static final String EXT_CLASS_LOADER_NAME = "SYS$ExtClassLoader";
    protected String name;

    protected LoaderRegistry(String name, ClassLoader loader, boolean useRealLoaders) {
        this.name = name;
        if (useRealLoaders) {
            loader = ClassLoaderReference.getRealClassLoader(loader);
        }
        this.systemClassLoader = new ClassLoaderReference(loader);
        this.loadersChain.add(loader);
        this.logDebug("Class Loader Registry '" + name + "' initialized.");
    }

    protected String getName() {
        return this.name;
    }

    @Override
    public synchronized void setSystemClassLoaderChain(ClassLoader chainTop) {
        this.systemClassLoader.setReference(chainTop);
    }

    @Override
    public ClassLoader getSystemClassLoaderChain() {
        return this.systemClassLoader;
    }

    @Override
    public List<String> listClassLoaders() {
        ArrayList<String> loaderList = new ArrayList<String>(this.loaders.keySet());
        Collections.sort(loaderList);
        return loaderList;
    }

    public synchronized ClassLoader registerClassLoader(String name, URL[] urls, boolean isChained, boolean isRoot) throws UtilitiesException {
        return this.addClassLoader(name, urls, isChained ? this.getRealClassLoader(this.systemClassLoader) : null, isRoot, true);
    }

    @Override
    public ClassLoader registerClassLoader(Package pkg, URL[] urls, boolean isChained, boolean isRoot) throws UtilitiesException {
        return this.registerClassLoader(pkg, urls, isChained, isRoot, false);
    }

    @Override
    public synchronized ClassLoader registerClassLoader(Package pkg, URL[] urls, boolean isChained, boolean isRoot, boolean isTransient) throws UtilitiesException {
        return this.registerClassLoader(this.checkParameters(pkg, urls, isTransient), urls, isChained, isRoot);
    }

    public synchronized ClassLoader registerChainedClassLoader(Package pkg, URL[] urls, String parentLoaderName, boolean isRoot) throws UtilitiesException {
        ClassLoader parentLoader = parentLoaderName != null ? this.getRealClassLoader((ClassLoader)this.loaders.get(parentLoaderName)) : this.getDefaultParentLoader();
        return this.addClassLoader(this.checkParameters(pkg, urls, false), urls, parentLoader, isRoot, false);
    }

    protected ClassLoader getDefaultParentLoader() {
        return (ClassLoader)this.loaders.get(EXT_CLASS_LOADER_NAME);
    }

    protected ClassLoader getRealClassLoader(ClassLoader loader) {
        return ClassLoaderReference.getRealClassLoader(loader);
    }

    private String checkParameters(Package pkg, URL[] urls, boolean isTransient) throws UtilitiesException {
        String pkgName = LoaderRegistry.getPackageName(pkg.getFullName(), isTransient);
        if (this.loaders.containsKey(pkgName)) {
            throw new UtilitiesException("Class loader for package '" + pkgName + "' is already registered.");
        }
        List<String> pkgJars = pkg.listJARs();
        if (pkgJars.size() != urls.length) {
            throw new UtilitiesException("List of URLs for package '" + pkgName + "' does not match with list of JARs.");
        }
        for (URL url : urls) {
            String jarPath = url.toString();
            String jarName = jarPath.substring(jarPath.lastIndexOf(47) + 1);
            if (pkgJars.contains(jarName)) continue;
            throw new UtilitiesException("List of URLs for package '" + pkgName + "' does not match with list of JARs.");
        }
        this.packages.put(pkgName, pkg);
        return pkgName;
    }

    private synchronized ClassLoader addClassLoader(String name, URL[] urls, ClassLoader parentLoader, boolean isRoot, boolean addToEnd) throws UtilitiesException {
        try {
            FabricClassLoader loader = new FabricClassLoader(name, urls, parentLoader);
            this.addClassLoader(name, loader, parentLoader, addToEnd);
            if (isRoot) {
                this.setSystemClassLoaderChain(loader);
            }
            return loader;
        }
        catch (Exception exception) {
            throw new UtilitiesException("Registering class loader '" + name + "' failed.", exception);
        }
    }

    protected synchronized ClassLoader addClassLoader(String name, FabricClassLoader loader, ClassLoader parentLoader, boolean addToEnd) throws Exception {
        this.loaders.put(name, loader);
        if (parentLoader != null) {
            if (addToEnd) {
                this.loadersChain.add(loader);
            } else {
                this.addLoaderToChain(loader, parentLoader);
            }
        }
        return loader;
    }

    @Override
    public void unregisterClassLoader(String pkgName, boolean isTransient) throws UtilitiesException {
        try {
            this.unregisterClassLoader(pkgName, isTransient, null);
        }
        catch (Exception exception) {
            throw new UtilitiesException("Unregistering class loader '" + pkgName + "' failed.", exception);
        }
    }

    public synchronized void unregisterClassLoader(String pkgName, boolean isTransient, List<SemanticType> relatedTypes) throws Exception {
        if (this.packages.remove(pkgName = LoaderRegistry.getPackageName(pkgName, isTransient)) == null) {
            throw new UtilitiesException("Class loader for package '" + pkgName + "' is not registered.");
        }
        this.doUnregisterClassLoader(LoaderRegistry.getPackageName(pkgName, isTransient), relatedTypes);
    }

    private synchronized void doUnregisterClassLoader(String name, List<SemanticType> relatedTypes) throws Exception {
        if (name.equals(EXT_CLASS_LOADER_NAME)) {
            throw new UtilitiesException("System class loader 'SYS$ExtClassLoader' cannot be unregistered.");
        }
        ClassLoader loader = (ClassLoader)this.loaders.remove(name);
        if (loader == null) {
            throw new UtilitiesException("Class loader '" + name + "' is not registered.");
        }
        loader = ClassLoaderReference.getRealClassLoader(loader);
        this.removeLoaderFromChain(loader);
        if (loader.equals(ClassLoaderReference.getRealClassLoader(this.systemClassLoader))) {
            this.setSystemClassLoaderChain(loader.getParent());
        }
        this.onRemoveFabricClassLoader((FabricClassLoader)loader, relatedTypes);
    }

    @Override
    protected void onRemoveFabricClassLoader(FabricClassLoader loader, List<SemanticType> relatedTypes) throws Exception {
        ((AbstractJSerializerFactory)JSerializerFactory.getInstance()).removeClassLoader(loader, relatedTypes);
        loader.unload();
    }

    @Override
    public boolean existsClassLoader(String loaderName) {
        return this.loaders.containsKey(loaderName);
    }

    @Override
    public boolean existsClassLoader(String pkgName, boolean isTransient) {
        return this.existsClassLoader(LoaderRegistry.getPackageName(pkgName, isTransient));
    }

    @Override
    public ClassLoader lookupClassLoader(String name) {
        return (ClassLoader)this.loaders.get(name);
    }

    @Override
    public ClassLoader lookupClassLoader(String pkgName, boolean isTransient) {
        return this.lookupClassLoader(LoaderRegistry.getPackageName(pkgName, isTransient));
    }

    @Override
    public Package lookupPackage(String pkgName) {
        return this.lookupPackage(pkgName, false);
    }

    @Override
    public Package lookupPackage(String pkgName, boolean isTransient) {
        return (Package)this.packages.get(LoaderRegistry.getPackageName(pkgName, isTransient));
    }

    @Override
    public Package lookupPackageByClass(Class clz) {
        for (Package pkg : this.packages.values()) {
            ClassLoader pkgClassLoader = this.lookupClassLoader(pkg.getFullName(), false);
            if (clz.getClassLoader() != pkgClassLoader) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public Package lookupPackageBySemanticType(SemanticType semanticType) {
        try {
            return this.lookupPackageByClass(ClassUtils.loadClass(semanticType.getClassName(), this.getSystemClassLoaderChain()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isPackageRegistered(String pkgName) {
        return this.isPackageRegistered(pkgName, false);
    }

    @Override
    public boolean isPackageRegistered(String pkgName, boolean isTransient) {
        return this.packages.containsKey(LoaderRegistry.getPackageName(pkgName, isTransient));
    }

    @Override
    public List<String> lookupLoadersByArchive(String jarName) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : this.loaders.entrySet()) {
            result.addAll(ClassUtils.getClassLoaderJars((ClassLoader)entry.getValue()).stream().filter(jarUrl -> jarUrl.endsWith("/" + jarName)).map(jarUrl -> (String)entry.getKey()).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public Package lookupPackageByArchive(String jarName) {
        for (Map.Entry entry : this.loaders.entrySet()) {
            for (String jarUrl : ClassUtils.getClassLoaderJars((ClassLoader)entry.getValue())) {
                Package pkg;
                if (!jarUrl.endsWith("/" + jarName) || (pkg = this.lookupPackage((String)entry.getKey(), ((String)entry.getKey()).startsWith("tmp."))) == null) continue;
                return pkg;
            }
        }
        return null;
    }

    public void addClassLoaderURL(String loaderName, URL url) throws UtilitiesException {
        if (loaderName.equals(EXT_CLASS_LOADER_NAME)) {
            throw new UtilitiesException("System class loader 'SYS$ExtClassLoader' cannot be changed directly.");
        }
        ClassLoader loader = (ClassLoader)this.loaders.get(loaderName);
        if (loader == null) {
            throw new UtilitiesException("Class loader '" + loaderName + "' is not registered.");
        }
        if (!this.doAddClassLoaderURL(loader, url)) {
            throw new UtilitiesException("Class loader '" + loaderName + "' does not support addition of URL to classpath.");
        }
    }

    private boolean doAddClassLoaderURL(ClassLoader loader, URL url) {
        if ((loader = ClassLoaderReference.getRealClassLoader(loader)) instanceof FabricURLClassLoader) {
            ((FabricURLClassLoader)loader).addURL(url);
            return true;
        }
        return false;
    }

    @Override
    public void printClassPath(PrintStream out) {
        this.printClassPath(this.systemClassLoader, SYSTEM_CLASS_LOADER_NAME, out);
    }

    @Override
    public void printClassPath(String loaderName, PrintStream out) {
        this.printClassPath(this.lookupClassLoader(loaderName), loaderName, out);
    }

    private void printClassPath(ClassLoader loader, String loaderName, PrintStream out) {
        List<String> jars = ClassUtils.getClassLoaderJars(loader);
        if (jars.size() > 0) {
            out.println("\n--- Class path for Loader: " + loaderName + " ---");
            out.println(" |");
            for (String jar : jars) {
                out.println(" +-- " + jar);
            }
        } else {
            out.println("\n--- Class path for Loader: " + loaderName + " is not available (not a URLClassLoader/FabricClassLoader instance)");
        }
        out.println("\n");
    }

    @Override
    public void printAllClassPaths(PrintStream out) {
        this.printAllClassPaths(this.systemClassLoader, SYSTEM_CLASS_LOADER_NAME, out);
    }

    @Override
    public void printAllClassPaths(String loaderName, PrintStream out) {
        this.printAllClassPaths(this.lookupClassLoader(loaderName), loaderName, out);
    }

    private void printAllClassPaths(ClassLoader loader, String loaderName, PrintStream out) {
        out.println("\n--- Class path for Loader: " + loaderName + " ---");
        StringBuilder pad = new StringBuilder(" ");
        for (loader = ClassLoaderReference.getRealClassLoader(loader); loader != null; loader = loader.getParent()) {
            List<String> jars = ClassUtils.getClassLoaderJars(loader);
            if (jars.size() > 0) {
                out.println(String.valueOf(pad) + "|");
                for (String jar : jars) {
                    out.println(String.valueOf(pad) + "+-- " + jar);
                }
            } else {
                out.println(String.valueOf(pad) + "|");
                String label = loader.getClass().getCanonicalName() + " (no URLs info)";
                for (Map.Entry entry : this.loaders.entrySet()) {
                    if (entry.getValue() != loader) continue;
                    label = (String)entry.getKey() + " " + label;
                    break;
                }
                out.println(String.valueOf(pad) + "+-- <" + label + ">");
            }
            pad.append(" ");
        }
    }

    @Override
    public List<Pair<String, List<String>>> getAllClassPaths() {
        ArrayList<Pair<String, List<String>>> result = new ArrayList<Pair<String, List<String>>>();
        for (ClassLoader loader = ClassLoaderReference.getRealClassLoader(this.systemClassLoader); loader != null; loader = loader.getParent()) {
            Pair<Object, List<String>> loaderData = new Pair<Object, List<String>>(null, ClassUtils.getClassLoaderJars(loader));
            for (Map.Entry entry : this.loaders.entrySet()) {
                if (entry.getValue() != loader) continue;
                loaderData.first = entry.getKey();
                break;
            }
            if (loaderData.first == null) {
                loaderData.first = loader.toString();
            }
            result.add(loaderData);
        }
        Collections.reverse(result);
        return result;
    }

    @Override
    public List<String> listArchivesByClass(String className) throws ArchiveException {
        throw new ArchiveException("Operation is not supported.");
    }

    @Override
    public List<String> listLibArchivesByClass(String className, Set<String> excludedArchives) throws ArchiveException {
        throw new ArchiveException("Operation is not supported.");
    }

    @Override
    public List<String> listExtArchivesByClass(String className) throws ArchiveException {
        throw new ArchiveException("Operation is not supported.");
    }

    private static String getPackageName(String pkgName, boolean isTransient) {
        return isTransient ? "tmp." + pkgName : pkgName;
    }

    protected void logError(String message) {
        Trace.logError(this, message);
    }

    protected void logInfo(String message) {
        Trace.logInfo(this, message);
    }

    protected void logDebug(String message) {
        Trace.logDebug(this, message);
    }

    protected void logException(Throwable exception) {
        Trace.logException(this, exception, true);
    }
}

