/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSerialOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class ListSerialSchemasOperation
extends AbstractSerialOperation {
    public static final String NAME = "list serial schemas";

    public ListSerialSchemasOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST SERIAL SCHEMAS");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FOR CLASS", false).addParameter(new IdentifierParameter("ClassName"))).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false));
        this.syntax.setDescription("Returns a list of Serial Schemas in the node.");
        this.syntax.setSyntaxDescription("list serial schemas                       - Returns a list of Serial Schemas for all classes in the current node.\nlist serial schemas for class <ClassName> - Returns a list of Serial Schemas for the specified class in the current node.\n\nOptional parameters:\n\n   at node <NodeName> - Returns a list of Serial Schemas at the specified node.");
        this.syntax.setExamples("list serial schemas\nlist serial schemas for class example.Example\nlist serial schemas at node Node1\nlist serial schemas for class example.Example at node Node1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), statement.getParameter("ClassName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, false, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListSerialSchemasOperation.createResultDescriptor(((Definition)statement).className != null));
        this.getManager().fillSerialSchemas(((Definition)statement).className, result);
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor(boolean forClass) {
        RowMetaData result = new RowMetaData();
        if (forClass) {
            ListSerialSchemasOperation.addColumn(result, "Serial Version");
            ListSerialSchemasOperation.addColumn(result, "Unique Schema");
            ListSerialSchemasOperation.addColumn(result, "Reference Version");
        } else {
            ListSerialSchemasOperation.addColumn(result, "Class");
            ListSerialSchemasOperation.addColumn(result, "Semantic Type");
            ListSerialSchemasOperation.addColumn(result, "Unique Schema Count");
            ListSerialSchemasOperation.addColumn(result, "Schema Reference Count");
        }
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private String className;

        public Definition(String nodeName, String className) {
            super(ListSerialSchemasOperation.NAME);
            this.nodeName = nodeName;
            this.className = className;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

