/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.moderator.ListComponentsOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Subject;
import java.util.List;

public class ListClientsOperation
extends AbstractOperation<RuntimeContext> {
    public static final String NAME = "list clients";

    public ListClientsOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST").setPredicate(new ChoiceModifier("Protocol", false).addPossibleValues(Definition.Protocol.class));
        this.syntax.setSubject(new Subject("CLIENTS"));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Returns a list of external clients connected to the node.");
        this.syntax.setSyntaxDescription("list clients                    - Returns a list of external clients in the current node.\nlist clients at node <NodeName> - Returns a list of external clients in the specified node.\nlist clients at domain          - Returns a list of external clients in all nodes of the sysplex.");
        this.syntax.setExamples("list clients\nlist tlp clients at node Node1\nlist http clients at domain");
        this.syntax.addTag(OperationTag.moderator);
        this.syntax.addTag(OperationTag.sysplex);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), statement.existsModifier("Protocol") ? Definition.Protocol.valueOf(statement.getModifier("Protocol").getToken()) : null);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListClientsOperation.createResultDescriptor());
        Definition.Protocol protocol = ((Definition)statement).protocol;
        if (protocol != null) {
            switch (protocol.ordinal()) {
                case 0: {
                    this.addClients(((RuntimeContext)this.callable).exchange.getTLPClients(), session, result);
                    break;
                }
                case 1: {
                    this.addClients(((RuntimeContext)this.callable).exchange.getHTTPClients(), session, result);
                    break;
                }
                case 2: {
                    this.addClients(((RuntimeContext)this.callable).exchange.getXMPPClients(), session, result);
                }
            }
        } else {
            this.addClients(((RuntimeContext)this.callable).exchange.getTLPClients(), session, result);
            this.addClients(((RuntimeContext)this.callable).exchange.getHTTPClients(), session, result);
            this.addClients(((RuntimeContext)this.callable).exchange.getXMPPClients(), session, result);
        }
        return new SLResponse(result);
    }

    private void addClients(List<RuntimeExchange.ClientInfo> clients, MFSession session, RowSet result) throws Exception {
        for (RuntimeExchange.ClientInfo client : clients) {
            if (client == null || client.component == null || client.protocol == null) continue;
            List<String> nameTokens = ModeratorUtils.splitComponentFullName(client.component.getName());
            if (!ListComponentsOperation.checkSysadmin(session, client.component)) continue;
            result.addToRowSet(ListClientsOperation.createRow(nameTokens, client));
        }
    }

    private static Object[] createRow(List<String> nameTokens, RuntimeExchange.ClientInfo client) {
        return new Object[]{nameTokens.get(0), nameTokens.get(1), nameTokens.get(2), client.protocol.name(), client.acceptor, ListClientsOperation.formatHost(client), client.component.getEventScope().name(), client.component.getSecurityContext() != null ? client.component.getSecurityContext().getOwnerName() : "", ListClientsOperation.getCreationTime(client.component)};
    }

    static String formatHost(RuntimeExchange.ClientInfo client) {
        if (client.host != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(client.host.equals("127.0.0.1") ? "localhost" : client.host);
            if (client.ip != null) {
                builder.append("/").append(client.ip);
            }
            return builder.toString();
        }
        if (client.ip != null) {
            return client.ip;
        }
        return "N/A";
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListClientsOperation.addColumn(result, "Node");
        ListClientsOperation.addColumn(result, "Type");
        ListClientsOperation.addColumn(result, "Id");
        ListClientsOperation.addColumn(result, "Protocol");
        ListClientsOperation.addColumn(result, "Acceptor");
        ListClientsOperation.addColumn(result, "Client Host");
        ListClientsOperation.addColumn(result, "Scope");
        ListClientsOperation.addColumn(result, "Owner");
        ListClientsOperation.addColumn(result, "Connected On");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private Protocol protocol;

        Definition(String nodeName, Protocol protocol) {
            super(ListClientsOperation.NAME);
            this.nodeName = nodeName;
            this.protocol = protocol;
        }

        static enum Protocol {
            TLP,
            HTTP,
            XMPP;

        }
    }
}

