/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.LocalDSLOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.pool.AccessorsPool;
import com.streamscape.sef.pool.ObjectsPool;
import com.streamscape.sef.pool.PoolObjectsCreator;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListAccessorPoolsOperation<T extends FabricComponent>
extends AbstractDSLOperation<T>
implements LocalDSLOperation {
    public static final String NAME = "list accessor pools";

    public ListAccessorPoolsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST ACCESSOR POOLS");
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Returns a list of accessors pools in current component.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   at node <NodeName> - Returns a list of accessors pools in the specified node.\n   at domain          - Returns a list of accessors pools in all nodes of the sysplex.\n\n   These parameters are applicable to Runtime context only.");
        this.syntax.addTag(OperationTag.accessor);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        if (this.callable instanceof RuntimeContext) {
            return AbstractOperation.invoke((RuntimeContext)this.callable, this, ((Definition)statement).getNodeName(), statement, session, timeout, true, false);
        }
        return this.invokeLocal(null, statement, (AbstractMFSession)session, timeout);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        RowSet rowSet = new RowSet(ListAccessorPoolsOperation.createResultDescriptor(node != null));
        try {
            if (this.callable instanceof RuntimeContext) {
                for (FabricComponent component : ((RuntimeContext)this.callable).getBoundComponents()) {
                    this.addAccessorsForComponent(rowSet, node, component);
                }
            } else {
                if (((Definition)statement).getNodeName() != null) {
                    throw new Exception("Parameter AT NODE | DOMAIN is applicable to Runtime context only.");
                }
                this.addAccessorsForComponent(rowSet, node, (FabricComponent)this.callable);
            }
            return new SLResponse(rowSet);
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    private void addAccessorsForComponent(RowSet rowSet, FabricNodeReference node, FabricComponent component) throws SQLException {
        AccessorsPool accessorsPool;
        if (component instanceof AbstractFabricComponent && (accessorsPool = ((AbstractFabricComponent)component).getAccessorsPool()) != null) {
            for (ObjectsPool<?> pool : accessorsPool.listPoolMaps()) {
                rowSet.addToRowSet(this.getValues(node, component, pool, pool.getPoolObjectsCreator()).toArray());
            }
        }
    }

    private List<Object> getValues(FabricNodeReference node, FabricComponent component, ObjectsPool pool, PoolObjectsCreator creator) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (node != null) {
            result.add(node.getName());
        }
        result.addAll(Arrays.asList(ModeratorUtils.makeComponentFullName(component), creator.getObjectType(), creator.getComponentFullName(), pool.getMaxPoolSize(), pool.getCurrentPoolSize(), pool.getAvailableObjectsCount(), pool.getCurrentPoolSize() - pool.getAvailableObjectsCount()));
        return result;
    }

    static RowMetaData createResultDescriptor(boolean withNode) {
        RowMetaData result = new RowMetaData();
        if (withNode) {
            ListAccessorPoolsOperation.addColumn(result, "Node");
        }
        ListAccessorPoolsOperation.addColumn(result, "Owner Component Name");
        ListAccessorPoolsOperation.addColumn(result, "Pool Accessor Type");
        ListAccessorPoolsOperation.addColumn(result, "Accessed Component Full Name");
        ListAccessorPoolsOperation.addColumn(result, "Pool Max Size");
        ListAccessorPoolsOperation.addColumn(result, "Active Count");
        ListAccessorPoolsOperation.addColumn(result, "Available Count");
        ListAccessorPoolsOperation.addColumn(result, "Acquired Count");
        return result;
    }

    public static class Definition
    extends AbstractNodeOperation.Definition {
        Definition(String nodeName) {
            super(ListAccessorPoolsOperation.NAME, nodeName);
        }
    }
}

