/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.discovery.AbstractDiscoveryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.dispatcher.AbstractSysplexOperation;
import com.streamscape.sef.dispatcher.AttachNodeOperation;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;
import java.util.stream.Collectors;

public class LinkNodeOperation
extends AbstractSysplexOperation {
    public static final String NAME = "link node";

    public LinkNodeOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LINK NODE");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TO").addParameter((SyntaxParameter)new IdentifierParameter("TargetNode").setCompletionAdviser(new TargetNodeCompletionAdviser()))).setSyntaxHintSpace());
        this.syntax.setDescription("Opens a connection to the specified node using the corresponding discovery link.");
        this.syntax.setExamples("link node to TestNode1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("TargetNode").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.connect(this.getLink(((Definition)statement).getTargetNode()));
        return new SLResponse();
    }

    private DiscoveryLink getLink(String nodeName) throws Exception {
        for (DiscoveryLink link : AbstractDiscoveryOperation.getDirectoryTable((RuntimeContext)this.callable).getLinks(((RuntimeContext)this.callable).getName())) {
            if (!link.getNodeName().equals(nodeName)) continue;
            return link;
        }
        throw new Exception("Discovery link not found in Directory Table.");
    }

    private void connect(DiscoveryLink link) throws Exception {
        FabricNode targetNode = ((RuntimeContext)this.callable).exchange.getFabricNode(link.getNodeName());
        if (targetNode != null) {
            if (((RuntimeContext)this.callable).exchange.existsNodeConnection(targetNode)) {
                throw new Exception("Link already exists.");
            }
            ((RuntimeContext)this.callable).exchange.connectToNode(link);
        } else {
            AttachNodeOperation.invoke((RuntimeContext)this.callable);
        }
    }

    private class TargetNodeCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser {
        private TargetNodeCompletionAdviser() {
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            try {
                DirectoryTable.Node node = AbstractDiscoveryOperation.getDirectoryTable((RuntimeContext)LinkNodeOperation.this.callable).getNode(((RuntimeContext)LinkNodeOperation.this.callable).getName());
                if (node != null) {
                    return node.getLinks().stream().filter(link -> !((RuntimeContext)((LinkNodeOperation)LinkNodeOperation.this).callable).exchange.existsNodeConnection(link.getNodeName())).map(DiscoveryLink::getNodeName).sorted().collect(Collectors.toList());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String targetNode;

        public Definition(String targetNode) {
            super(LinkNodeOperation.NAME);
            this.targetNode = targetNode;
        }

        public String getTargetNode() {
            return this.targetNode;
        }
    }
}

