/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.lib.concurrent.ExecutedTask;
import com.streamscape.lib.concurrent.TaskExecutor;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.parser.SelectorParser;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.event.RowArrayEvent;
import com.streamscape.sdo.event.RowEvent;
import com.streamscape.sdo.event.RowSetEvent;
import com.streamscape.sdo.event.TextEvent;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sdrpath.ReferencePathManager;
import com.streamscape.sdo.sys.Void;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.AbstractEventTrigger;
import com.streamscape.sef.dispatcher.FabricEventSinkFactoryImpl;
import com.streamscape.sef.dispatcher.FabricEventSourceFactoryImpl;
import com.streamscape.sef.dispatcher.ServiceContextImpl;
import com.streamscape.sef.dispatcher.ServicePool;
import com.streamscape.sef.service.advisories.ServiceCallAdvisory;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.eim.EventIdentity;
import com.streamscape.service.osf.eim.EventIdentityPlugin;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.osf.evh.EventHandlerException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;

final class InvokeDelegate
implements FabricEventListener {
    private ServiceContextImpl context;
    private ServicePool servicePool;
    private Class<?> serviceClass;
    private EventHandler handler;
    private Method methodObject;
    private Method methodWithPropertiesObject;
    private boolean requestAsEvent = false;
    private boolean responseAsEvent = false;
    private boolean noReturn = false;
    private boolean noParams = false;
    private String outgoingEventId = "";
    private Class<?> responseObjectClass;
    private ImmutableEventDatagram responseEventPrototype;
    private SelectorExpression selector;
    private ReferencePathManager sdrManager;
    private final Map<String, AbstractEventTrigger> beforeTriggers = new ConcurrentHashMap<String, AbstractEventTrigger>();
    private boolean statsEnabled = false;
    private String methodCallCounterMetric;

    InvokeDelegate() {
    }

    EventHandler getEventHandler() {
        return this.handler;
    }

    void init(Class<?> serviceClass, ServicePool pool, EventHandler evh, ServiceContextImpl ctx, RuntimeContext runtimeCtx) throws EventHandlerException {
        this.handler = evh;
        this.serviceClass = serviceClass;
        this.servicePool = pool;
        this.context = ctx;
        this.methodCallCounterMetric = InvokeDelegate.getMethodCallCounterMetric(evh);
        try {
            Pair<Boolean, ImmutableEventDatagram> verificationResult;
            String requestObjectClassName = this.handler.getRequestObjectClass();
            String responseObjectClassName = this.handler.getResponseObjectClass();
            if (responseObjectClassName.equals(Void.class.getName())) {
                this.noReturn = true;
            }
            if (requestObjectClassName.equals(Void.class.getName())) {
                this.noParams = true;
            }
            Class requestObjectClass = ClassUtils.loadClass(requestObjectClassName, this.context.manifestManager.getManifestClassLoader());
            this.responseObjectClass = ClassUtils.loadClass(responseObjectClassName, this.context.manifestManager.getManifestClassLoader());
            if (!this.noParams) {
                verificationResult = this.verifyPrototypeAndSemanticType(this.handler.getRequestEventId(), this.handler.getRequestSemanticType(), this.handler.getRequestSDRPath(), requestObjectClass, "Request");
                this.requestAsEvent = (Boolean)verificationResult.first;
                if (this.handler.getRequestSDRPath() != null) {
                    this.sdrManager = runtimeCtx.getSDRManagerFactory().createManager();
                }
            }
            if (!this.noReturn) {
                verificationResult = this.verifyPrototypeAndSemanticType(this.handler.getResponseEventId(), this.handler.getResponseSemanticType(), null, this.responseObjectClass, "Response");
                this.responseAsEvent = (Boolean)verificationResult.first;
                this.responseEventPrototype = (ImmutableEventDatagram)verificationResult.second;
            }
            this.methodObject = this.retrieveTargetMethod(new Class[]{requestObjectClass});
            try {
                this.methodWithPropertiesObject = this.retrieveTargetMethod(new Class[]{requestObjectClass, Map.class});
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outgoingEventId = this.handler.getResponseEventId();
            this.initSelectorExpression();
            if (this.context.existsAdvancedProperty("enableServiceStats")) {
                this.statsEnabled = this.context.lookupAdvancedBooleanProperty("enableServiceStats");
            }
        }
        catch (Exception error) {
            Trace.logError(this, error.getMessage());
            ctx.logError("(DII) Initialization Error: " + error.getMessage());
            this.raiseException(new ServiceFrameworkException(6105, (Throwable)error));
            if (error instanceof EventHandlerException) {
                throw (EventHandlerException)error;
            }
            throw new EventHandlerException(error);
        }
    }

    private Method retrieveTargetMethod(Class[] paramTypes) throws Exception {
        Class[] paramTypesWithoutVoid = (Class[])Arrays.stream(paramTypes).filter(c -> !c.equals(Void.class)).toArray(Class[]::new);
        List<Method> suitableMethods = ClassUtils.findSatisfiableMethods(this.serviceClass, this.handler.getMethodName(), paramTypesWithoutVoid, true, false);
        if (suitableMethods.isEmpty()) {
            throw new EventHandlerException("Suitable service method '" + this.handler.getMethodName() + "' not found for event handler '" + this.handler.getHandlerName() + "'.");
        }
        List<Method> targetMethod = this.noReturn ? ClassUtils.findSatisfiableMethodsWithReturnType(suitableMethods.toArray(new Method[suitableMethods.size()]), null, true) : ClassUtils.findSatisfiableMethodsWithReturnType(suitableMethods.toArray(new Method[suitableMethods.size()]), this.responseObjectClass, true);
        if (targetMethod == null || targetMethod.size() != 1) {
            throw new EventHandlerException("Suitable service method '" + this.handler.getMethodName() + "' not found for event handler '" + this.handler.getHandlerName() + "'.");
        }
        return targetMethod.get(0);
    }

    private Pair<Boolean, ImmutableEventDatagram> verifyPrototypeAndSemanticType(String eventId, String semanticType, String sdrPath, Class<?> objectClass, String requestName) throws Exception {
        boolean asEvent = false;
        if (ImmutableEventDatagram.class.isAssignableFrom(objectClass)) {
            asEvent = true;
            return new Pair<Boolean, Object>(asEvent, null);
        }
        EventDatagram event = EventDatagramFactory.getInstance().createEvent(eventId);
        Class actualClass = null;
        if (event instanceof DataEvent) {
            if (((DataEvent)event).getPayloadClass() == null) {
                throw new IllegalArgumentException(this.buildPrototypeVerificationError(eventId, "payload is NULL.", requestName));
            }
            actualClass = ((DataEvent)event).getPayloadClass();
        } else if (event instanceof OpaqueEvent) {
            if (((OpaqueEvent)((Object)event)).getPayloadClass() == null) {
                throw new IllegalArgumentException(this.buildPrototypeVerificationError(eventId, "payload is NULL.", requestName));
            }
            actualClass = ((OpaqueEvent)((Object)event)).getPayloadClass();
        }
        if (event instanceof BytesEvent) {
            actualClass = byte[].class;
        } else if (event instanceof RowSetEvent) {
            actualClass = RowSet.class;
        } else if (event instanceof RowArrayEvent) {
            actualClass = RowArray.class;
        } else if (event instanceof RowEvent) {
            actualClass = Row.class;
        } else if (event instanceof TextEvent || event instanceof XMLEvent) {
            actualClass = String.class;
        }
        if (sdrPath != null) {
            TypeAnalyzer analyzer = TypeAnalyzerFactory.getInstance().createTypeAnalyzer();
            if (!analyzer.assertPath(sdrPath)) {
                throw new EventHandlerException("Invalid SDR Path '" + sdrPath + "'. Specified path does not exist.");
            }
            this.checkObjectClass(analyzer.getFieldClass(sdrPath), objectClass, eventId, requestName);
        } else if (actualClass != null) {
            this.checkObjectClass(actualClass, objectClass, eventId, requestName);
        }
        return new Pair<Boolean, ImmutableEventDatagram>(asEvent, event);
    }

    private void checkObjectClass(Class<?> originalClass, Class<?> userSpecifiedClass, String eventId, String requestName) throws Exception {
        if (!originalClass.isAssignableFrom(userSpecifiedClass)) {
            throw new EventHandlerException(this.buildPrototypeVerificationError(eventId, "does not match specified semantic type. Expected " + originalClass.getName() + " but found " + userSpecifiedClass.getName() + ".", requestName));
        }
    }

    private String buildPrototypeVerificationError(String eventId, String cause, String requestName) {
        return "Prototype verification failed. " + requestName + " prototype [" + eventId + "] " + cause;
    }

    public static String getMethodCallCounterMetric(EventHandler evh) {
        return "Handler" + evh.getHandlerName() + "CallCounter";
    }

    void addBeforeEventTrigger(AbstractEventTrigger trigger) {
        this.beforeTriggers.put(trigger.getName(), trigger);
    }

    void removeBeforeEventTrigger(String triggerName) {
        this.beforeTriggers.remove(triggerName);
    }

    @Override
    public void onEvent(ImmutableEventDatagram event) {
        ImmutableEventDatagram reply = null;
        try {
            reply = (ImmutableEventDatagram)this.invoke(event, true);
        }
        catch (Throwable error) {
            if (error instanceof IAbstractExceptionEvent && this.canExceptionBeThrownByMethod((Exception)error)) {
                this.raiseException((IAbstractExceptionEvent)error, event);
            } else {
                this.raiseException(this.createServiceException(error), event);
            }
            if (this.needsAcknowledgement(event)) {
                ServiceFrameworkException exception = this.createServiceException(error);
                this.suppressStackTrace(exception);
                this.acknowledgeEvent((EventDatagram)event, exception);
            }
            while (error != null) {
                Trace.logError(this, "(DII) Cause: " + error.getClass().getName() + ": " + error.getMessage());
                this.context.logError("(DII) Cause: " + error.getClass().getName() + ": " + error.getMessage());
                error = error.getCause();
            }
        }
        if (reply != null && this.needsAcknowledgement(event)) {
            this.acknowledgeEvent((EventDatagram)event, reply);
        }
    }

    private boolean needsAcknowledgement(ImmutableEventDatagram event) {
        return event instanceof EventDatagram && ((EventDatagram)event).getReplyTo() != null && ((EventDatagram)event).getReplyTo().startsWith("e.reply.");
    }

    Object onRequest(ImmutableEventDatagram event, boolean isEvent) throws FabricRequestException {
        try {
            if (this.selector != null && !this.selector.matches(event)) {
                throw new FabricRequestException("Request event does not match the event handler selector.");
            }
            return this.invoke(event, isEvent);
        }
        catch (Throwable error) {
            throw this.createFabricRequestException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object invokeRequest(Object requestObject) throws Throwable {
        Object object;
        long start;
        block5: {
            start = System.currentTimeMillis();
            Service service = null;
            try {
                Trace.logDebug(InvokeDelegate.class, "(DII) Invoke '" + this.handler.getMethodName() + "' method on '" + this.serviceClass.getName() + "' service.");
                service = this.servicePool.borrowService();
                object = this.invokeMethod(service, requestObject, null, false);
                if (service == null) break block5;
                this.servicePool.releaseService(service);
            }
            catch (Throwable throwable) {
                if (service != null) {
                    this.servicePool.releaseService(service);
                }
                long end = System.currentTimeMillis();
                if (this.statsEnabled) {
                    this.context.raiseSystemAdvisory(new ServiceCallAdvisory(this.handler.getHandlerName(), end - start));
                }
                this.context.getMetricsFactory().nextMetricValue(this.methodCallCounterMetric);
                throw throwable;
            }
        }
        long end = System.currentTimeMillis();
        if (this.statsEnabled) {
            this.context.raiseSystemAdvisory(new ServiceCallAdvisory(this.handler.getHandlerName(), end - start));
        }
        this.context.getMetricsFactory().nextMetricValue(this.methodCallCounterMetric);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(ImmutableEventDatagram event, boolean isEvent) throws Throwable {
        Object object;
        if (event == null) {
            throw new Exception("(DII) Invoke Delegate received a null request datagram.");
        }
        long start = System.currentTimeMillis();
        Service service = null;
        try {
            this.context.getServicePool().setEvent(event);
            for (AbstractEventTrigger trigger : this.beforeTriggers.values()) {
                if (trigger.getState() != EventTriggerState.ENABLED) continue;
                trigger.onEvent(event);
            }
            service = this.servicePool.borrowService();
            this.setIdentity(this.servicePool.getCurrentEIM(), event);
            this.context.getMacroProcessor().setEvent(event);
            if (this.requestAsEvent) {
                FabricEventSinkFactoryImpl.reset(event);
            }
            object = this.invokeMethod(service, this.noParams ? null : this.getSourceObject(event), event, isEvent);
            if (service != null) {
                this.servicePool.releaseService(service);
            }
            this.servicePool.releaseEvent();
        }
        catch (Throwable throwable) {
            if (service != null) {
                this.servicePool.releaseService(service);
            }
            this.servicePool.releaseEvent();
            long end = System.currentTimeMillis();
            if (this.statsEnabled) {
                ServiceCallAdvisory statsAdvisory = new ServiceCallAdvisory(this.handler.getHandlerName(), end - start);
                if (event instanceof EventDatagram) {
                    statsAdvisory.setEventGroupId(((EventDatagram)event).getEventGroupId());
                    statsAdvisory.setCorrelationId(((EventDatagram)event).getCorrelationId());
                    statsAdvisory.setEventKey(((EventDatagram)event).getEventKey());
                }
                this.context.raiseSystemAdvisory(statsAdvisory);
            }
            this.context.getMetricsFactory().nextMetricValue(this.methodCallCounterMetric);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        if (this.statsEnabled) {
            ServiceCallAdvisory statsAdvisory = new ServiceCallAdvisory(this.handler.getHandlerName(), end - start);
            if (event instanceof EventDatagram) {
                statsAdvisory.setEventGroupId(((EventDatagram)event).getEventGroupId());
                statsAdvisory.setCorrelationId(((EventDatagram)event).getCorrelationId());
                statsAdvisory.setEventKey(((EventDatagram)event).getEventKey());
            }
            this.context.raiseSystemAdvisory(statsAdvisory);
        }
        this.context.getMetricsFactory().nextMetricValue(this.methodCallCounterMetric);
        return object;
    }

    private Object invokeMethod(Service service, Object requestObject, ImmutableEventDatagram requestEvent, boolean isEvent) throws Throwable {
        Object result = this.invokeMethodWithoutResultProcessing(service, requestObject, requestEvent);
        if (this.noReturn) {
            return null;
        }
        if (result == null) {
            Trace.logError(InvokeDelegate.class, "(DII) WARNING: Method '" + this.handler.getMethodName() + "' returned NULL result.");
            throw new ServiceFrameworkException(6108, "Method '" + this.handler.getMethodName() + "' returned NULL result, expected object of class '" + this.handler.getResponseObjectClass() + "'.");
        }
        if (isEvent) {
            ImmutableEventDatagram responseEvent = this.createResponseEvent(result);
            if (responseEvent instanceof EventDatagram || responseEvent instanceof ExceptionEventDatagram) {
                ImmutableEventDatagram outgoingEvent = responseEvent;
                String responseEventId = responseEvent.getEventId();
                if (responseEventId != null && !responseEventId.equals(this.outgoingEventId)) {
                    outgoingEvent = responseEvent.clone();
                }
                FabricEventSourceFactoryImpl.setEventId(outgoingEvent, this.outgoingEventId);
                if (responseEvent instanceof EventDatagram) {
                    this.context.raiseEvent(outgoingEvent, 0L);
                } else {
                    this.context.raiseException((ExceptionEventDatagram)outgoingEvent);
                }
                if (responseEvent == outgoingEvent) {
                    FabricEventSinkFactoryImpl.reset(responseEvent);
                    if (responseEventId != null) {
                        FabricEventSourceFactoryImpl.setEventId(responseEvent, responseEventId);
                    }
                }
            } else if (responseEvent instanceof AdvisoryEventDatagram) {
                this.context.raiseAdvisory((AdvisoryEventDatagram)responseEvent);
            } else {
                this.context.logError("(DII) Unsupported event datagram returned as a result of handler execution.");
            }
            return responseEvent;
        }
        return result;
    }

    private Object invokeMethodWithoutResultProcessing(Service service, Object requestObject, ImmutableEventDatagram requestEvent) throws Throwable {
        try {
            Trace.logDebug(InvokeDelegate.class, "(DII) Invoke method '" + this.handler.getMethodName() + "' on '" + this.serviceClass.getName() + "' service...");
            if (this.handler.getTimeout() > 0L) {
                Object object = this.invokeMethodWithTimeout(service, requestObject, requestEvent);
                return object;
            }
            if (this.noParams) {
                if (this.methodWithPropertiesObject != null && requestEvent instanceof IAbstractDataEvent) {
                    Object object = this.methodWithPropertiesObject.invoke((Object)service, InvokeDelegate.getEventProperties((IAbstractDataEvent)requestEvent));
                    return object;
                }
                Object object = this.methodObject.invoke((Object)service, new Object[0]);
                return object;
            }
            if (this.methodWithPropertiesObject != null && requestEvent instanceof IAbstractDataEvent) {
                Object object = this.methodWithPropertiesObject.invoke((Object)service, requestObject, InvokeDelegate.getEventProperties((IAbstractDataEvent)requestEvent));
                return object;
            }
            Object object = this.methodObject.invoke((Object)service, requestObject);
            return object;
        }
        catch (Throwable exception) {
            if (exception instanceof InvocationTargetException) {
                exception = exception.getCause();
            }
            Trace.logError(this, "(DII) Method '" + this.handler.getMethodName() + "' invoke exception: " + exception.getMessage());
            this.context.logError("(DII) Method '" + this.handler.getMethodName() + "' invoke exception: " + exception.getMessage());
            Trace.logException(this, exception, true);
            throw exception;
        }
        finally {
            Trace.logDebug(InvokeDelegate.class, "(DII) Method '" + this.handler.getMethodName() + "' invoked on '" + this.serviceClass.getName() + "' service.");
        }
    }

    private static Map<String, Object> getEventProperties(IAbstractDataEvent event) throws SDOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String propName : event.getEventPropertyNames()) {
            properties.put(propName, event.getEventObjectProperty(propName));
        }
        return properties;
    }

    private Object invokeMethodWithTimeout(Service service, Object requestObject, final ImmutableEventDatagram requestEvent) throws Throwable {
        try {
            final EventIdentityPlugin eim = this.servicePool.getCurrentEIM();
            class ServiceStartTask
            implements ExecutedTask<Object, Pair<Service, Object>> {
                ServiceStartTask() {
                }

                @Override
                public Object execute(Pair<Service, Object> data) throws InvocationTargetException, IllegalAccessException {
                    if (requestEvent != null) {
                        InvokeDelegate.this.servicePool.setEvent(requestEvent);
                    }
                    InvokeDelegate.this.servicePool.setCurrentEIM(eim);
                    try {
                        if (InvokeDelegate.this.noParams) {
                            Object object = InvokeDelegate.this.methodObject.invoke(data.first, new Object[0]);
                            return object;
                        }
                        Object object = InvokeDelegate.this.methodObject.invoke(data.first, data.second);
                        return object;
                    }
                    finally {
                        InvokeDelegate.this.servicePool.releaseEvent();
                        InvokeDelegate.this.servicePool.releaseCurrentEIM();
                    }
                }

                @Override
                public String getType() {
                    return "SVC";
                }

                @Override
                public String getName() {
                    return "Invoke.Delegate:EventHandlerTimer";
                }

                @Override
                public String getDescription() {
                    return "Executes Event Handler '" + InvokeDelegate.this.handler.getHandlerName() + "' request with the " + InvokeDelegate.this.handler.getTimeout() + " timeout.";
                }
            }
            return new TaskExecutor<Object, Pair<Service, Object>>().execute(new ServiceStartTask(), new Pair<Service, Object>(service, requestObject), this.handler.getTimeout());
        }
        catch (Throwable exception) {
            this.context.cancel(service);
            if (exception instanceof TimeoutException) {
                throw new ServiceFrameworkException(6108, "Timeout expired.");
            }
            throw exception;
        }
    }

    private boolean canExceptionBeThrownByMethod(Exception exception) {
        return this.methodObject != null && Arrays.stream(this.methodObject.getExceptionTypes()).anyMatch(exceptionClass -> exceptionClass.isAssignableFrom(exception.getClass()));
    }

    private void raiseException(IAbstractExceptionEvent exceptionEvent) {
        this.raiseException(exceptionEvent, null);
    }

    private void raiseException(IAbstractExceptionEvent exceptionEvent, ImmutableEventDatagram event) {
        try {
            this.suppressStackTrace(exceptionEvent);
            if (event != null) {
                EventIdentityPlugin eim = this.servicePool.getCurrentEIM();
                if (eim == null) {
                    eim = this.servicePool.getDefaultEIM();
                }
                if (eim != null) {
                    this.setIdentity(eim, event);
                    eim.setExceptionIdentity(exceptionEvent);
                }
            }
            this.context.raiseException(exceptionEvent);
        }
        catch (Exception exception) {
            this.context.logError("(DII) Raising exception event failed. Cause: " + exception.toString());
            Trace.logException(this, exception, true);
        }
    }

    private void acknowledgeEvent(EventDatagram event, ImmutableEventDatagram reply) {
        try {
            AcknowledgementEvent ackEvent = EventDatagramFactory.getInstance().createAcknowledgement(event);
            ackEvent.setData(reply);
            this.context.raiseAcknowledgement(ackEvent, -1L);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            this.context.logError("(DII) Raising acknowledgement failed. Cause: " + exception.toString());
        }
    }

    FabricRequestException createFabricRequestException(Throwable error) {
        FabricRequestException result = new FabricRequestException(this.createServiceException(error));
        this.suppressStackTrace(result);
        return result;
    }

    private ServiceFrameworkException createServiceException(Throwable error) {
        if (error instanceof ServiceFrameworkException) {
            return (ServiceFrameworkException)error;
        }
        return error.getMessage() == null ? new ServiceFrameworkException(6108, error.getClass().getName()) : new ServiceFrameworkException(6108, error);
    }

    private void suppressStackTrace(IAbstractExceptionEvent exception) {
        if (this.context.getServiceConfiguration().existsAdvancedProperty("exceptionSuppressStacktrace") && ((Boolean)this.context.getServiceConfiguration().getAdvancedProperty("exceptionSuppressStacktrace").getValue()).booleanValue()) {
            InvokeDelegate.doSuppressStackTrace(exception);
        }
    }

    private static void doSuppressStackTrace(Throwable exception) {
        exception.setStackTrace(new StackTraceElement[0]);
        if (exception.getCause() != null) {
            InvokeDelegate.doSuppressStackTrace(exception.getCause());
        }
    }

    private void setIdentity(EventIdentityPlugin plugin, ImmutableEventDatagram event) {
        if (plugin == null) {
            Trace.logDebug(this, "(DII) Event plugin not set.");
            return;
        }
        if (event instanceof EventDatagram) {
            Trace.logDebug(this, "(DII) Event Datagram identity check.");
            plugin.acceptDatagramIdentity((EventDatagram)event);
        } else if (event instanceof ExceptionEventDatagram) {
            Trace.logDebug(this, "(DII) Exception Datagram identity check.");
            EventIdentity identity = new EventIdentity();
            identity.correlationId = ((ExceptionEventDatagram)event).getCorrelationIdAsBytes();
            identity.eventGroupId = ((ExceptionEventDatagram)event).getEventGroupId();
            identity.eventKey = ((ExceptionEventDatagram)event).getEventKey();
            plugin.acceptIdentity(identity);
        }
    }

    private void initSelectorExpression() {
        String handlerSelector = this.handler.getRequestSelector();
        if (handlerSelector != null) {
            try {
                this.selector = SelectorParser.parse(handlerSelector);
            }
            catch (SelectorFormatException selectorFormatException) {
                // empty catch block
            }
        }
    }

    private Object getSourceObject(ImmutableEventDatagram sourceEvent) throws Exception {
        if (this.requestAsEvent) {
            return sourceEvent;
        }
        if (this.handler.getRequestSDRPath() != null) {
            return this.sdrManager.getValueAtPath(this.handler.getRequestSDRPath(), sourceEvent);
        }
        return InvokeDelegate.getEventData(sourceEvent);
    }

    Object getResponseObject(ImmutableEventDatagram event) throws Exception {
        if (this.noReturn) {
            return null;
        }
        if (this.responseAsEvent) {
            return event;
        }
        return InvokeDelegate.getEventData(event);
    }

    private static Object getEventData(ImmutableEventDatagram event) throws Exception {
        if (event instanceof DataEvent) {
            return ((DataEvent)event).getData();
        }
        if (event instanceof BytesEvent) {
            return ((BytesEvent)event).getBytes();
        }
        if (event instanceof RowSetEvent) {
            return ((RowSetEvent)event).getRowSet();
        }
        if (event instanceof RowArrayEvent) {
            return ((RowArrayEvent)event).getRowArray();
        }
        if (event instanceof RowEvent) {
            return ((RowEvent)event).getRow();
        }
        if (event instanceof TextEvent) {
            return ((TextEvent)event).getText();
        }
        if (event instanceof XMLEvent) {
            return ((XMLEvent)event).getXML();
        }
        if (event instanceof OpaqueEvent) {
            return ((OpaqueEvent)event).getData();
        }
        if (event instanceof FileEvent) {
            return ((FileEvent)event).getFileData();
        }
        if (event instanceof MapEvent) {
            return ((MapEvent)event).getMap();
        }
        throw new IllegalArgumentException("Event type '" + String.valueOf(event.getClass()) + "' is unsupported in services.");
    }

    private ImmutableEventDatagram createResponseEvent(Object invocationResult) throws Exception {
        if (this.responseAsEvent) {
            return (ImmutableEventDatagram)invocationResult;
        }
        this.checkResponseObject(invocationResult);
        ImmutableEventDatagram responseEvent = this.responseEventPrototype.clone();
        InvokeDelegate.fillEvent(responseEvent, invocationResult, null);
        return responseEvent;
    }

    private void checkResponseObject(Object result) throws ServiceFrameworkException {
        if (!this.responseObjectClass.isAssignableFrom(result.getClass())) {
            try {
                this.responseObjectClass = ClassUtils.loadClass(this.responseObjectClass.getName(), this.context.manifestManager.getManifestClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!this.responseObjectClass.isAssignableFrom(result.getClass())) {
                throw new ServiceFrameworkException(6108, "Data object returned from the method incompatible with the response semantic type.");
            }
        }
    }

    static void fillEvent(ImmutableEventDatagram event, Object data, Map<String, Object> properties) throws Exception {
        if (event instanceof DataEvent) {
            ((DataEvent)event).setData(data);
        }
        if (event instanceof BytesEvent && data instanceof byte[]) {
            ((BytesEvent)event).setBytes((byte[])data);
        } else if (event instanceof RowSetEvent && data instanceof RowSet) {
            InvokeDelegate.setRowSet((RowSetEvent)event, (RowSet)data);
        } else if (event instanceof RowArrayEvent && data instanceof RowArray) {
            InvokeDelegate.setRowArray((RowArrayEvent)event, (RowArray)data);
        } else if (event instanceof RowEvent && data instanceof Row) {
            InvokeDelegate.setRow((RowEvent)event, (Row)data);
        } else if (event instanceof TextEvent && data instanceof String) {
            ((TextEvent)event).setText((String)data);
        } else if (event instanceof XMLEvent && data instanceof String) {
            ((XMLEvent)event).setXML((String)data);
        } else if (event instanceof OpaqueEvent) {
            ((OpaqueEvent)event).setData(data);
        } else if (event instanceof FileEvent) {
            ((FileEvent)event).setFileData((byte[])data);
        } else if (event instanceof MapEvent) {
            ((MapEvent)event).setMap((Map)data);
        }
        if (properties != null && event instanceof IAbstractDataEvent) {
            for (String propName : properties.keySet()) {
                ((EventDatagram)event).setEventObjectProperty(propName, properties.get(propName));
            }
        }
    }

    private static void setRowSet(RowSetEvent event, RowSet data) throws Exception {
        InvokeDelegate.setRowData(data.getRowMetaData(), event.getRowSet().getRowMetaData(), event, "rowSet", data);
    }

    private static void setRowArray(RowArrayEvent event, RowArray data) throws Exception {
        InvokeDelegate.setRowData(data.getMetaData(), event.getRowArray().getMetaData(), event, "rowArray", data);
    }

    private static void setRow(RowEvent event, Row data) throws Exception {
        InvokeDelegate.setRowData(data.getMetaData(), event.getRow().getMetaData(), event, "row", data);
    }

    private static void setRowData(RowMetaData resultMeta, RowMetaData protoMeta, ImmutableEventDatagram event, String fieldName, Object data) throws Exception {
        if (protoMeta != null && resultMeta != null) {
            InvokeDelegate.compareRowMetaData(resultMeta, protoMeta);
        }
        InvokeDelegate.setField(event, fieldName, data);
    }

    private static void setField(ImmutableEventDatagram event, String fieldName, Object data) throws Exception {
        Field field = event.getClass().getDeclaredField("rowSet");
        field.setAccessible(true);
        field.set(event, data);
    }

    private static void compareRowMetaData(RowMetaData source, RowMetaData target) throws Exception {
        if (source.getColumnCount() != target.getColumnCount()) {
            throw new IllegalArgumentException("Number of columns in returned row does not match number of columns in prototype.");
        }
        for (int i = 0; i < source.getColumnCount(); ++i) {
            ColumnDescriptor sourceColumn = source.getColumnDescriptor(i);
            ColumnDescriptor targetColumn = target.getColumnDescriptor(i);
            if (sourceColumn.getName().equals(targetColumn.getName()) && sourceColumn.getType() == targetColumn.getType()) continue;
            throw new IllegalArgumentException("Column meta data in returned row does not match the one in prototype.");
        }
    }
}

