/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.loader.PackageLoaderRegistry;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.event.ChunkEvent;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sef.dispatcher.AbstractDatagramPrototypeCache;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.dispatcher.AbstractSemanticTypeFactory;
import com.streamscape.sef.dispatcher.RuntimeSemanticTypeFactory;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.AsyncConsumerReference;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.ConsumerReference;
import com.streamscape.sef.moderator.DirectConsumerReference;
import com.streamscape.sef.moderator.EndpointReference;
import com.streamscape.sef.moderator.EntityReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.ReceiverReference;
import com.streamscape.sef.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class InternalUtils
extends Utils {
    InternalUtils() {
    }

    static boolean matches(EntityReference endpoint, EventScope eventScope) {
        if (eventScope == null) {
            eventScope = EventScope.INHERITED;
        }
        switch (eventScope) {
            case OBSERVABLE: {
                return endpoint.getEventScope() == EventScope.OBSERVABLE;
            }
            case CLUSTER: {
                return endpoint.getEventScope() == EventScope.CLUSTER;
            }
            case GLOBAL: {
                return endpoint.getEventScope() == EventScope.GLOBAL;
            }
            case INHERITED: {
                return true;
            }
        }
        return false;
    }

    static <TResult extends EntityReference, T extends TResult> void getEntities(EventScope eventScope, Collection<T> entities, List<TResult> result) {
        if (entities != null) {
            result.addAll(entities.stream().filter(entity -> InternalUtils.matches(entity, eventScope)).collect(Collectors.toList()));
        }
    }

    static <TResult extends EntityReference, T extends TResult> List<TResult> getEntities(EventScope eventScope, Collection<T> entities) {
        ArrayList result = new ArrayList();
        InternalUtils.getEntities(eventScope, entities, result);
        return result;
    }

    static <T extends EventConsumerReference> List<T> getGroupConsumers(List<T> consumers, String groupName) {
        ArrayList result = new ArrayList();
        InternalUtils.getGroupConsumers(consumers, groupName, result);
        return result;
    }

    static <T extends EventConsumerReference> void getGroupConsumers(List<T> consumers, String groupName, List<T> result) {
        result.addAll(consumers.stream().filter(consumer -> InternalUtils.equalsNullSafe(consumer.getGroupName(), groupName)).collect(Collectors.toList()));
    }

    static <T extends EndpointReference, TResult extends T> TResult getEndpoint(String name, Collection<T> endpoints) {
        return (TResult)(endpoints != null ? (EndpointReference)endpoints.stream().filter(endpoint -> endpoint.getName().equals(name)).findFirst().orElse(null) : null);
    }

    static <T extends EndpointReference> boolean hasEndpoint(String name, Collection<T> endpoints) {
        return endpoints != null && endpoints.stream().anyMatch(endpoint -> endpoint.getName().equals(name));
    }

    static <T extends ConsumerReference> T getConsumerByLocalName(String name, Collection<T> consumers) {
        return (T)(consumers != null ? (ConsumerReference)consumers.stream().filter(consumer -> InternalUtils.getConsumerName(consumer.getName()).equals(name)).findFirst().orElse(null) : null);
    }

    static <T extends EventConsumerReference> List<T> getGroupConsumers(List<ComponentReference> components, String groupName, ConsumersGetter<T> getter) {
        ArrayList result = new ArrayList();
        components.stream().filter(component -> component.isGroupMember(groupName)).forEach(component -> {
            getter.component = component;
            InternalUtils.getGroupConsumers(getter.getConsumers(), groupName, result);
        });
        return result;
    }

    static String getConsumerName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(58) + 1);
    }

    static <T extends EntityReference> List<String> listEntities(List<T> entities) {
        ArrayList<String> result = new ArrayList<String>();
        if (entities != null) {
            result.addAll(entities.stream().map(NamedObject::getName).sorted().collect(Collectors.toList()));
        }
        return result;
    }

    protected static <T> T createProtectedObject(Class<T> objectClass, Class[] parameterTypes, Object ... parameters) {
        return Utils.createProtectedObject(objectClass, parameterTypes, parameters);
    }

    protected static Object invokeProtectedMethod(Object object, String methodName, Class[] parameterTypes, Object ... parameters) {
        return Utils.invokeProtectedMethod(object, methodName, parameterTypes, parameters);
    }

    protected static <T extends Throwable> void throwException(Class<T> objectClass, int errorCode, String message) throws T {
        Utils.throwException(objectClass, errorCode, message);
    }

    protected static <T extends Throwable> void throwException(Class<T> objectClass, int errorCode, Throwable cause) throws T {
        Utils.throwException(objectClass, errorCode, cause);
    }

    protected static <T extends Throwable> void throwException(Class<T> objectClass, int errorCode, String message, Throwable cause) throws T {
        Utils.throwException(objectClass, errorCode, message, cause);
    }

    static void checkRelatedEntities(AbstractRuntimeContext context, List<SemanticType> types, boolean validate, boolean dataspaceOnly) {
        if (!dataspaceOnly) {
            Trace.logDebug(PackageLoaderRegistry.class, "Checking semantic types and prototypes...");
            types.stream().filter(type -> !type.isSystem()).forEach(type -> {
                try {
                    ClassUtils.loadClass(type.getClassName(), context.getPackageManifestManager().getManifestClassLoader());
                    AbstractSemanticTypeFactory.setValid(type, true);
                }
                catch (Exception exception) {
                    AbstractSemanticTypeFactory.setValid(type, false);
                }
                try {
                    ((RuntimeSemanticTypeFactory)context.semanticTypeFactory).doUpdateSemanticType((SemanticType)type);
                    Trace.logInfo(PackageLoaderRegistry.class, type.isValid() ? "Semantic type '" + type.getTypeName() + "' validated." : "WARNING: Semantic type '" + type.getTypeName() + "' invalidated.");
                }
                catch (SemanticTypeFactoryException exception) {
                    Trace.logException(PackageLoaderRegistry.class, exception, true);
                    Trace.logError(PackageLoaderRegistry.class, "Update semantic type '" + type.getTypeName() + "' in repository failed.");
                }
                ((AbstractDatagramPrototypeCache)((Object)context.getDatagramPrototypeCache())).checkEventPrototypes((SemanticType)type);
            });
            Trace.logDebug(PackageLoaderRegistry.class, "Semantic types and event prototypes checked.");
        }
        InternalUtils.checkRelatedDataspaceEntities(context, types, validate);
    }

    static void checkRelatedDataspaceEntities(AbstractRuntimeContext context, List<SemanticType> types, boolean validate) {
        if (context.isDataspaceBound()) {
            Trace.logDebug(PackageLoaderRegistry.class, "Checking Dataspace entities...");
            ((RuntimeContext)context).getDataspaceManager().checkSemanticTypes(types, validate);
            Trace.logDebug(PackageLoaderRegistry.class, "Dataspace entities checked.");
        }
    }

    static Class[] getParameterTypes(Object[] parameters) {
        if (parameters == null) {
            return null;
        }
        return (Class[])Arrays.stream(parameters).map(parameter -> parameter != null ? parameter.getClass() : String.class).toArray(Class[]::new);
    }

    static <T> List<T> convert(List<T> result) {
        return result != null ? result : new ArrayList();
    }

    static String getSystemName(String name) {
        return name.startsWith("sys$") ? name : "sys$" + name;
    }

    static String extractSystemName(String name) {
        return name.startsWith("sys$") ? name.substring("sys$".length()) : name;
    }

    static EventScope checkEventScope(EventScope eventScope) {
        return eventScope == null ? EventScope.INHERITED : eventScope;
    }

    static String getEventModel(String eventId, DatagramPrototypeCache prototypeCache) {
        if (eventId.startsWith("e.chunk.")) {
            return ChunkEvent.class.getSimpleName();
        }
        Prototype prototype = prototypeCache.lookupPrototype(eventId);
        if (prototype != null) {
            return prototype.getModelName();
        }
        return null;
    }

    static byte getClusterNumber(ImmutableEventDatagram event) {
        return event.getEventSource()[1];
    }

    static abstract class ConsumersGetter<T extends EventConsumerReference> {
        ComponentReference component;

        ConsumersGetter() {
        }

        abstract List<T> getConsumers();
    }

    static class ReceiversGetter
    extends ConsumersGetter<ReceiverReference> {
        ReceiversGetter() {
        }

        @Override
        List<ReceiverReference> getConsumers() {
            return this.component.getReceivers(EventScope.INHERITED);
        }
    }

    static class AsyncConsumersGetter
    extends ConsumersGetter<AsyncConsumerReference> {
        AsyncConsumersGetter() {
        }

        @Override
        List<AsyncConsumerReference> getConsumers() {
            return this.component.getAsyncConsumers(EventScope.INHERITED);
        }
    }

    static class DirectConsumersGetter
    extends ConsumersGetter<DirectConsumerReference> {
        DirectConsumersGetter() {
        }

        @Override
        List<DirectConsumerReference> getConsumers() {
            return this.component.getDirectConsumers(EventScope.INHERITED);
        }
    }

    static class EventConsumersGetter
    extends ConsumersGetter<EventConsumerReference> {
        EventConsumersGetter() {
        }

        @Override
        List<EventConsumerReference> getConsumers() {
            return this.component.getEventConsumers(EventScope.INHERITED);
        }
    }
}

