/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.http.HTTPFabricException;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sef.dispatcher.AbstractComponentAccessor;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AccessibleObjectComponent;
import com.streamscape.sef.dispatcher.SLSessionImpl;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.network.http.server.fabric.HTTPEventTransmitter;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.slex.slang.SLMessageListener;
import com.streamscape.slex.slang.SLSessionException;

public class HTTPSLSessionImpl
extends SLSessionImpl
implements AccessibleObjectComponent {
    private HTTPServerFabricConnection fabricConnection;

    public HTTPSLSessionImpl(AbstractFabricConnection owningConnection, String nodeName) throws SLSessionException {
        super(owningConnection, nodeName, null, false);
        this.fabricConnection = (HTTPServerFabricConnection)((Object)owningConnection);
    }

    @Override
    public void setSLMessageListener(SLMessageListener listener) throws SLSessionException {
        super.setSLMessageListener(new SLMessageListener(){

            @Override
            public void onMessage(SLMessage message) {
                try {
                    message.setComponentName(HTTPSLSessionImpl.this.getComponentName());
                    message.setSLSessionName(HTTPSLSessionImpl.this.sessionName);
                    HTTPSLSessionImpl.this.sendJson(new HTTPEventTransmitter("", message), true);
                }
                catch (IAbstractExceptionEvent exception) {
                    Trace.logException(this, exception, true);
                    Trace.logError(this, "Raising SL Message failed.");
                }
            }
        });
    }

    protected void sendJson(Object object, boolean direct) throws IAbstractExceptionEvent {
        String reply = HTTPUtils.getJsonSerializerForFabric(this.fabricConnection.getHttpRequest()).serialize(object);
        if (reply != null) {
            this.fabricConnection.getReverseProcessor().sendReverseMessage(reply, direct);
        }
    }

    @Override
    public String getComponentFullNameWithNode() {
        throw new HTTPFabricException("getComponentFullNameWithNode not supported for HTTP slang sessions.");
    }

    @Override
    public String getActualNodeName() {
        throw new HTTPFabricException("getActualNodeName not supported for HTTP slang sessions.");
    }

    @Override
    public FabricNodeReference lookupFabricNode(String name) {
        throw new HTTPFabricException("lookupFabricNode not supported for HTTP slang sessions.");
    }

    @Override
    public long getRequestTimeout() {
        DataspaceAccessor accessor = this.getDataspaceAccessor();
        if (accessor != null) {
            return accessor.getRequestTimeout();
        }
        throw new HTTPFabricException("HTTPSessionImpl.getRequestTimeout implemented for routed session to dataspace only.");
    }

    public ImmutableEventDatagram raiseSystemRequestInDataspaceAccessor(ImmutableEventDatagram request, long timeout) throws Exception {
        DataspaceAccessor accessor = this.getDataspaceAccessor();
        if (accessor != null) {
            return ((AbstractComponentAccessor)((Object)accessor)).raiseSystemRequest(request, timeout);
        }
        throw new HTTPFabricException("HTTPSessionImpl.raiseSystemRequestInDataspaceAccessor implemented for routed session to dataspace only.");
    }

    private DataspaceAccessor getDataspaceAccessor() {
        if (this.mfSession != null && this.mfSession.getContext() != null && this.mfSession.getContext().accessor instanceof DataspaceAccessor) {
            return (DataspaceAccessor)((Object)this.mfSession.getContext().accessor);
        }
        return null;
    }
}

