/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.globals.GlobalVariable;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.repository.globals.UnresolvedVariableException;
import com.streamscape.runtime.mf.admin.glv.GlobalVariableFactory;
import com.streamscape.runtime.mf.admin.glv.GlobalVariableFactoryException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.SysGlobals;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

class GlobalVariableFactoryImpl
extends AbstractRuntimeFactory
implements GlobalVariableFactory {
    SysGlobals sysGlobals;
    RepositoryContext repositoryContext;

    GlobalVariableFactoryImpl(RepositoryContext repositoryContext) throws Exception {
        this.repositoryContext = repositoryContext;
        if (repositoryContext != null) {
            try {
                this.beginXact();
                this.sysGlobals = (SysGlobals)repositoryContext.getGlobalVariables();
                this.commitXact();
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
        } else {
            this.sysGlobals = GlobalVariableFactoryImpl.createSysGlobals();
        }
    }

    static SysGlobals createSysGlobals() {
        return new SysGlobals();
    }

    @Override
    public GlobalVariableCollection getGlobalVariables() {
        return this.sysGlobals.clone();
    }

    @Override
    public void addLiteralPool(String poolName) throws UnresolvedVariableException, GlobalVariableFactoryException {
        GlobalVariableFactoryImpl.getContext().exchange.updateGlobalVariables("doAddLiteralPool", poolName);
    }

    void doAddLiteralPool(String poolName) throws UnresolvedVariableException, GlobalVariableFactoryException {
        GlobalVariableFactoryImpl.checkPoolName(poolName);
        this.sysGlobals.addLiteralPool(poolName);
    }

    @Override
    public void removeLiteralPool(String poolName) throws UnresolvedVariableException, GlobalVariableFactoryException {
        GlobalVariableFactoryImpl.getContext().exchange.updateGlobalVariables("doRemoveLiteralPool", poolName);
    }

    void doRemoveLiteralPool(String poolName) throws UnresolvedVariableException {
        GlobalVariableFactoryImpl.checkPoolName(poolName);
        this.sysGlobals.removeLiteralPool(poolName);
    }

    @Override
    public boolean existsLiteralPool(String poolName) {
        return this.sysGlobals.existsLiteralPool(poolName);
    }

    @Override
    public List<String> listLiteralPools() {
        return this.sysGlobals.listLiteralPools();
    }

    @Override
    public List<String> listLiteralPoolVariables(String poolName) throws UnresolvedVariableException {
        return this.sysGlobals.listLiteralPoolVariables(poolName);
    }

    @Override
    public List<GlobalVariable> getLiteralPoolVariables(String poolName) throws UnresolvedVariableException {
        return this.sysGlobals.getLiteralPoolVariables(poolName);
    }

    @Override
    public void addVariable(String qualifiedName) throws UnresolvedVariableException, GlobalVariableFactoryException {
        String[] nameTokens = GlobalVariableFactoryImpl.getVariableNameTokens(qualifiedName);
        this.addVariable(nameTokens[0], nameTokens[1]);
    }

    @Override
    public void addVariable(String poolName, String variableName) throws UnresolvedVariableException, GlobalVariableFactoryException {
        GlobalVariableFactoryImpl.getContext().exchange.updateGlobalVariables("doAddVariable", poolName, variableName);
    }

    void doAddVariable(String poolName, String variableName) throws UnresolvedVariableException, GlobalVariableFactoryException {
        GlobalVariableFactoryImpl.checkPoolName(poolName);
        GlobalVariableFactoryImpl.checkVariableName(variableName);
        this.sysGlobals.addVariable(poolName, variableName);
    }

    @Override
    public void removeVariable(String qualifiedName) throws UnresolvedVariableException, GlobalVariableFactoryException {
        String[] nameTokens = GlobalVariableFactoryImpl.getVariableNameTokens(qualifiedName);
        this.removeVariable(nameTokens[0], nameTokens[1]);
    }

    @Override
    public void removeVariable(String poolName, String variableName) throws UnresolvedVariableException, GlobalVariableFactoryException {
        GlobalVariableFactoryImpl.getContext().exchange.updateGlobalVariables("doRemoveVariable", poolName, variableName);
    }

    void doRemoveVariable(String poolName, String variableName) throws UnresolvedVariableException, GlobalVariableFactoryException {
        GlobalVariableFactoryImpl.checkPoolName(poolName);
        GlobalVariableFactoryImpl.checkVariableName(variableName);
        this.sysGlobals.removeVariable(poolName, variableName);
    }

    @Override
    public void setVariable(String qualifiedName, String value) throws UnresolvedVariableException, GlobalVariableFactoryException {
        String[] nameTokens = GlobalVariableFactoryImpl.getVariableNameTokens(qualifiedName);
        this.setVariable(nameTokens[0], nameTokens[1], value);
    }

    @Override
    public void setVariable(String poolName, String variableName, String value) throws UnresolvedVariableException, GlobalVariableFactoryException {
        GlobalVariableFactoryImpl.getContext().exchange.updateGlobalVariables("doSetVariable", poolName, variableName, value);
    }

    void doSetVariable(String poolName, String variableName, String value) throws UnresolvedVariableException, GlobalVariableFactoryException {
        GlobalVariableFactoryImpl.checkPoolName(poolName);
        GlobalVariableFactoryImpl.checkVariableName(variableName);
        GlobalVariableFactoryImpl.checkValue(value);
        this.sysGlobals.setVariable(poolName, variableName, value);
    }

    @Override
    public boolean existsVariable(String qualifiedName) throws UnresolvedVariableException {
        return this.sysGlobals.existsVariable(qualifiedName);
    }

    @Override
    public boolean existsVariable(String poolName, String variableName) throws UnresolvedVariableException {
        return this.sysGlobals.existsVariable(poolName, variableName);
    }

    @Override
    public String getVariable(String qualifiedName) throws UnresolvedVariableException {
        return this.sysGlobals.getVariable(qualifiedName);
    }

    @Override
    public String getVariable(String poolName, String variableName) throws UnresolvedVariableException {
        return this.sysGlobals.getVariable(poolName, variableName);
    }

    void invokeOperation(String methodName, Object ... parameters) throws UnresolvedVariableException, GlobalVariableFactoryException {
        try {
            Method method = GlobalVariableFactoryImpl.class.getDeclaredMethod(methodName, InternalUtils.getParameterTypes(parameters));
            method.invoke((Object)this, parameters);
        }
        catch (Throwable exception) {
            if (exception instanceof InvocationTargetException) {
                exception = exception.getCause();
            }
            if (exception instanceof UnresolvedVariableException) {
                throw (UnresolvedVariableException)exception;
            }
            if (exception instanceof GlobalVariableFactoryException) {
                throw (GlobalVariableFactoryException)exception;
            }
            throw new GlobalVariableFactoryException("Unexpected exception", exception);
        }
        this.putSysGlobals();
    }

    private void beginXact() throws RepositoryException, InterruptedException {
        this.repositoryContext.beginXact(GlobalVariableFactoryImpl.getContext(), GlobalVariableFactoryImpl.getContext().getRepositoryContextTxTimeout());
    }

    private void commitXact() throws RepositoryException {
        this.repositoryContext.commitXact();
    }

    private void putSysGlobals() throws GlobalVariableFactoryException {
        if (this.repositoryContext != null) {
            try {
                this.beginXact();
                this.repositoryContext.putGlobalVariables(this.sysGlobals);
                this.commitXact();
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
        }
    }

    private GlobalVariableFactoryException processException(Exception exception) throws GlobalVariableFactoryException {
        if (exception instanceof RepositoryException) {
            return this.processException((RepositoryException)exception);
        }
        this.repositoryContext.abortXactSafe();
        return new GlobalVariableFactoryException(exception);
    }

    private GlobalVariableFactoryException processException(RepositoryException exception) throws GlobalVariableFactoryException {
        this.repositoryContext.abortXactSafe();
        return new GlobalVariableFactoryException(exception.getCause() != null ? exception.getCause() : exception);
    }

    void replaceSysGlobals(SysGlobals sysGlobals, boolean compare) throws GlobalVariableFactoryException {
        if (!compare || !this.sysGlobals.equals(sysGlobals)) {
            this.sysGlobals.replace(sysGlobals);
            this.putSysGlobals();
        }
    }

    void mergeSysGlobals(SysGlobals sysGlobals) throws GlobalVariableFactoryException {
        if (this.sysGlobals.merge(sysGlobals)) {
            this.putSysGlobals();
        }
    }

    private static String[] getVariableNameTokens(String qualifiedName) throws UnresolvedVariableException {
        if (qualifiedName == null) {
            throw new UnresolvedVariableException("Variable name is null.");
        }
        return SysGlobals.getVariableNameTokens(qualifiedName);
    }

    private static void checkPoolName(String poolName) throws UnresolvedVariableException {
        GlobalVariableFactoryImpl.checkName(poolName, "Pool");
    }

    private static void checkVariableName(String variableName) throws UnresolvedVariableException {
        GlobalVariableFactoryImpl.checkName(variableName, "Variable");
    }

    private static void checkName(String name, String entity) throws UnresolvedVariableException {
        if (name == null) {
            throw new UnresolvedVariableException(entity + " name is null.");
        }
        if (!StringUtils.validateSemanticName(name) || name.indexOf(36) != -1) {
            throw new UnresolvedVariableException(entity + " name '" + name + "' has invalid format.");
        }
    }

    private static void checkValue(String value) throws UnresolvedVariableException {
        if (value == null) {
            throw new UnresolvedVariableException("Value is null.");
        }
    }
}

