/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.lib.http.client.HTTPConnection;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricManagedComponentException;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.db.connection.DBFactoryConnectionService;
import com.streamscape.sef.dispatcher.AbstractDynamicFabricComponent;
import com.streamscape.sef.dispatcher.ComponentManifestManager;
import com.streamscape.sef.dispatcher.FactoryConnectionSessionManager;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.factory.connection.FactoryConnectionComponent;
import com.streamscape.sef.factory.connection.FactoryConnectionService;
import com.streamscape.sef.factory.connection.UsableClientConnection;
import com.streamscape.sef.pkg.PackageLoaderHelper;
import com.streamscape.service.osf.clients.ClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ClientFactoryConfigurationException;
import com.streamscape.service.osf.globals.GlobalVariablesResolverImpl;
import com.streamscape.slex.SemanticLexiconProcessor;

public class FactoryConnectionComponentImpl
extends AbstractDynamicFabricComponent
implements Logger,
FactoryConnectionComponent {
    private RuntimeContext context;
    private FactoryConnectionSessionManager sessionManager;
    private String factoryType;
    private String factoryName;
    private String userName;
    private FactoryConnectionService factoryService;
    private ClientFactory factory;
    private String traceLogPrefix;
    private static final LongNumberAllocatorSimple NAME_ALLOCATOR = new LongNumberAllocatorSimple();

    FactoryConnectionComponentImpl(String factoryType, String factoryName, String userName) throws Exception {
        super(factoryType, factoryName, ComponentModel.CTX_FACTORY_CONNECTION, ComponentState.NOT_INITIALIZED);
        this.factoryType = factoryType;
        this.factoryName = factoryName;
        this.userName = userName;
        long id = NAME_ALLOCATOR.getNumber();
        this.logPrefix = "[Factory Connection Component " + factoryType + "." + factoryName + "#" + id + "] ";
        this.traceLogPrefix = "[" + factoryType + "." + factoryName + "#" + id + "] ";
        this.logDebug("Creating...");
        this.setState(ComponentState.NOT_INITIALIZED);
        this.setModel(ComponentModel.CTX_FACTORY_CONNECTION);
        this.setEventScope(EventScope.GLOBAL);
        this.setType(factoryType, true);
        this.setName("sys$" + factoryName + "#" + id, true);
        this.context = RuntimeContext.getInstance();
        this.description = "Factory Connection";
        this.logInfo("Created.");
    }

    @Override
    public void init() throws Exception {
        try {
            this.logDebug("Initializing...");
            this.setState(ComponentState.INITIALIZING);
            this.initPackageManifestManager();
            this.initInternal(this.context.getDatagramPrototypeCache());
            this.context.bind(this);
            this.sessionManager = new FactoryConnectionSessionManager(this.context, this);
            this.sessionManager.init();
            this.initFactoryConnectionService();
            this.setState(ComponentState.INITIALIZED);
            this.logInfo("Initialized.");
        }
        catch (Exception error) {
            this.logError("Initialization failed. Cause: " + error.getMessage());
            try {
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setState(ComponentState.NOT_INITIALIZED);
            throw new FabricManagedComponentException("Initialization of the Factory Connection Component '" + this.getFullName() + "' failed.", error);
        }
    }

    @Override
    protected void initPackageManifestManager() {
        this.manifestManager = new ComponentManifestManager(this.context, this);
    }

    @Override
    public void destroy() throws Exception {
        try {
            this.logDebug("Destroying...");
            this.setState(ComponentState.DESTROYING);
            this.destroyFactoryService();
            if (this.sessionManager != null) {
                this.sessionManager.destroy();
            }
            this.destroyInternal();
            if (this.manifestManager != null) {
                this.manifestManager.destroy();
            }
            this.context.unbind(this.contextId);
            this.setState(ComponentState.DESTROYED);
            this.logInfo("Destroyed.");
        }
        catch (Exception error) {
            this.setState(ComponentState.DESTROYED);
            this.logError("Destroying failed. Cause: " + error.getMessage());
            throw new FabricManagedComponentException("Destroying Factory Connection Component '" + this.getFullName() + "' failed.", error);
        }
    }

    private void initFactoryConnectionService() throws Exception {
        RepositoryAccessor repository = this.context.getRepositoryAccessor();
        if (this.factoryType.equals("DropBox")) {
            this.factoryService = new DropBoxConnectionService(this.context, this.factoryName, this.userName);
            this.factoryService.init(this, null);
        } else if (repository.existsJDBCFactory(this.factoryName, this.factoryType)) {
            this.factoryService = new DBFactoryConnectionService(this.factoryType, this.factoryName);
            this.factoryService.init(this, null);
        } else {
            Class connectionClass;
            this.factory = ClientConfigurationFactory.loadFactoryObject(this.context, this.factoryName, this.factoryType, false);
            this.factory = new GlobalVariablesResolverImpl(VariableFactory.getGlobalVariables()).resolveVariables(this.factory);
            String packageName = PackageType.client.toString() + "." + this.factoryType;
            if (!PackageLoaderHelper.loadPackageIfRegistered(this.context, packageName)) {
                Trace.logInfo(this, "WARNING: Package '" + packageName + "' not registered.");
            }
            if (!UsableClientConnection.class.isAssignableFrom(connectionClass = ClassUtils.loadClass(this.factory.getConnectionClassName(), this.factory.getClassLoader())) || connectionClass == HTTPConnection.class) {
                throw new Exception("Factory '" + this.factoryType + "." + this.factoryName + "' is not usable.");
            }
            ClientConnection connection = this.factory.createConnection();
            connection.setServiceLogger(this);
            connection.setExceptionEventListener(exception -> this.logError(exception.getMessage()));
            connection.setStateNotificationEventListener(advisory -> this.logInfo("State changed to " + String.valueOf((Object)advisory.getState())));
            this.factoryService = ((UsableClientConnection)((Object)connection)).createConnectionService();
            this.factoryService.init(this, null);
        }
    }

    private void destroyFactoryService() {
        try {
            if (this.factoryService != null) {
                this.factoryService.destroy();
            }
        }
        finally {
            if (this.factory != null) {
                try {
                    this.factory.destroyAll();
                }
                catch (ClientFactoryConfigurationException exception) {
                    this.logError("Destroying connection factory failed. Cause: " + exception.getMessage());
                }
            }
        }
    }

    public SemanticLexiconProcessor getLexiconProcessor() {
        return this.factoryService != null ? this.factoryService.getLexiconProcessor() : null;
    }

    @Override
    public FactoryConnectionService getFactoryService() {
        return this.factoryService;
    }

    @Override
    public void raiseSystemAdvisory(AdvisoryEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        super.raiseSystemAdvisory(event);
    }

    @Override
    public void logDebug(String msg) {
        if (this.logger != null) {
            this.logger.logDebug(this.logPrefix + msg);
        } else {
            Trace.logDebug(this, this.traceLogPrefix + msg);
        }
    }

    @Override
    public void logInfo(String msg) {
        if (this.logger != null) {
            this.logger.logInfo(this.logPrefix + msg);
        } else {
            Trace.logInfo(this, this.traceLogPrefix + msg);
        }
    }

    @Override
    public void logError(String msg) {
        if (this.logger != null) {
            this.logger.logError(this.logPrefix + msg);
        } else {
            Trace.logError(this, this.traceLogPrefix + msg);
        }
    }
}

