/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.ds.mf.SLDataspaceCall;
import com.streamscape.ds.session.Session;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dii.AccessibleObjectsCache;
import com.streamscape.sef.dispatcher.AbstractAccessorProxy;
import com.streamscape.sef.dispatcher.FactoryConnectionComponentImpl;
import com.streamscape.sef.factory.connection.FactoryConnectionMFSession;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SLSessionData;

class FactoryConnectionAccessorProxy
extends AbstractAccessorProxy
implements AccessibleObject {
    private FactoryConnectionComponentImpl component;
    private FactoryConnectionMFSession session;
    private RuntimeContext context;
    private AccessibleObjectsCache cache = new AccessibleObjectsCache();

    FactoryConnectionAccessorProxy(RuntimeContext context, String sessionName, String componentName, ComponentOwner owner, boolean isRouted, FactoryConnectionComponentImpl component, String slSessionName, SLSessionData slSessionData) {
        super(component.getLexiconProcessor());
        this.component = component;
        this.session = new FactoryConnectionMFSession(sessionName, componentName, owner, isRouted, component, slSessionName);
        this.session.setSLSessionData(slSessionData);
        this.context = context;
        this.cache.putAccessibleObject(0L, this);
    }

    @Override
    protected void logError(Throwable exception) {
        Trace.logException(this, exception, true);
        this.component.logError("Processing of DSL statement failed. " + exception.getMessage());
    }

    @Override
    protected MFSession getMFSession() {
        return this.session;
    }

    @Override
    public void close() {
        super.close();
        this.cache.clearAndCloseAll();
        this.context.getDynamicComponentsManager().removeComponent(this.component);
    }

    @Override
    protected ImmutableEventDatagram invokeOtherRequest(ImmutableEventDatagram request) throws FabricRequestException {
        if (request.getEventId().equals("e.sys.sl.DataspaceCall")) {
            try {
                return FactoryConnectionAccessorProxy.createResponseEvent(this.processCall((SLDataspaceCall)((OpaqueEvent)request).getData()));
            }
            catch (Exception exception) {
                this.logError(exception);
                throw new FabricRequestException(exception);
            }
        }
        return super.invokeOtherRequest(request);
    }

    protected SLResponse processCall(SLDataspaceCall call) {
        AccessibleObject object = this.cache.getAccessibleObject(call.objectId());
        if (object != null) {
            try {
                SLResponse response = new SLResponse();
                response.setObject(this.cache.invoke(call));
                return response;
            }
            catch (Exception exception) {
                return new SLResponse(exception);
            }
        }
        return new SLResponse("Unable to find callable object.", false);
    }

    @Override
    protected ImmutableEventDatagram invokeTextRequest(String statement, MFSession session, long timeout) throws Exception {
        Object proxy;
        Object data;
        ImmutableEventDatagram event = super.invokeTextRequest(statement, session, timeout);
        if (event instanceof OpaqueEvent && (data = ((OpaqueEvent)event).getData()) instanceof SLResponse && (proxy = this.cache.putAndConvertToProxy(((SLResponse)data).getObject())) instanceof RowSet) {
            ((SLResponse)data).setRowSet((RowSet)proxy);
            ((SLResponse)data).setObject(null);
        }
        return event;
    }

    public void eraseFromObjectCache(Session session, Long oid) {
        this.cache.removeAccessibleObject(oid);
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return null;
    }
}

