/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.Version;
import com.streamscape.cli.ClientState;
import com.streamscape.runtime.ContextId;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.AbstractNamedObject;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AccessorSessionReferenceImpl;
import com.streamscape.sef.dispatcher.AsyncConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.ClientExchange;
import com.streamscape.sef.dispatcher.ComponentReferenceImpl;
import com.streamscape.sef.dispatcher.DirectConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.EndpointReferenceImpl;
import com.streamscape.sef.dispatcher.EventCacheReferenceImpl;
import com.streamscape.sef.dispatcher.EventConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.ReceiverReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationEntityReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationSourceReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationTargetReferenceImpl;
import com.streamscape.sef.dispatcher.RequestConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.AccessorReference;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.moderator.AsyncConsumerReference;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.ConsumerReference;
import com.streamscape.sef.moderator.DirectConsumerReference;
import com.streamscape.sef.moderator.EndpointReference;
import com.streamscape.sef.moderator.EntityReference;
import com.streamscape.sef.moderator.EventCacheReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.EventFlowMap;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.ReceiverReference;
import com.streamscape.sef.moderator.ReplicationSourceReference;
import com.streamscape.sef.moderator.ReplicationTargetReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.utils.Printer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

class FabricNode
extends AbstractNamedObject
implements FabricNodeReference {
    private transient AbstractExchange exchange;
    private FabricNodeRole role;
    private ContextId contextId;
    private String version;
    private String cluster;
    private List<LinkAddress> acceptors;
    private long weight;
    private boolean isLocal = true;
    private boolean isReady = true;
    private int pid = -1;
    private long startTime;
    private Map<FabricAddress, ComponentReferenceImpl> components = new ConcurrentHashMap<FabricAddress, ComponentReferenceImpl>();
    private transient Map<String, ComponentReferenceImpl> componentsByName = new ConcurrentHashMap<String, ComponentReferenceImpl>();
    private Map<FabricAddress, DirectConsumerReferenceImpl> directConsumers = new ConcurrentHashMap<FabricAddress, DirectConsumerReferenceImpl>();
    private Map<FabricAddress, AsyncConsumerReferenceImpl> asyncConsumers = new ConcurrentHashMap<FabricAddress, AsyncConsumerReferenceImpl>();
    private Map<FabricAddress, RequestConsumerReferenceImpl> requestConsumers = new ConcurrentHashMap<FabricAddress, RequestConsumerReferenceImpl>();
    private Map<FabricAddress, ReceiverReferenceImpl> receivers = new ConcurrentHashMap<FabricAddress, ReceiverReferenceImpl>();
    private Map<FabricAddress, EventCacheReferenceImpl> eventCaches = new ConcurrentHashMap<FabricAddress, EventCacheReferenceImpl>();
    private Map<String, ReplicationSourceReferenceImpl> replicationSources = new ConcurrentHashMap<String, ReplicationSourceReferenceImpl>();
    private Map<String, ReplicationTargetReferenceImpl> replicationTargets = new ConcurrentHashMap<String, ReplicationTargetReferenceImpl>();
    private transient Map<FabricAddress, AccessorSessionReferenceImpl> accessorSessions = new ConcurrentHashMap<FabricAddress, AccessorSessionReferenceImpl>();
    private final Object acceptorMutex = new Object();
    private final Object componentsMutex = new Object();
    private transient long iLastBroadcastEvent = -1L;
    private static final Predicate<EntityReference> IS_SCOPE_GLOBAL = entity -> entity.getEventScope() == EventScope.GLOBAL;
    private static final Predicate<EntityReference> IS_SCOPE_NO_LOCAL = entity -> entity.getEventScope() != EventScope.LOCAL;

    FabricNode(RuntimeExchange exchange, String name, FabricNodeRole role, ContextId contextId, long weight) throws FabricException {
        super(name);
        this.exchange = exchange;
        this.role = role;
        this.contextId = contextId;
        this.version = Version.getVersion();
        if (exchange.context.isClustered()) {
            this.cluster = exchange.context.getClusterName();
        }
        this.weight = weight;
        this.isLocal = true;
        try {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            this.pid = Integer.parseInt(jvmName.substring(0, jvmName.indexOf(64)));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Obtaining JVM process id failed.");
        }
    }

    private FabricNode(FabricNode other, boolean isLocal) {
        super(other.name);
        this.exchange = other.exchange;
        this.role = other.role;
        this.contextId = other.contextId;
        this.version = other.version;
        this.cluster = other.cluster;
        this.acceptors = other.acceptors;
        this.weight = other.weight;
        this.pid = other.pid;
        this.startTime = other.startTime;
        this.isLocal = isLocal;
    }

    synchronized void init() {
        if (this.componentsByName == null) {
            this.componentsByName = new ConcurrentHashMap<String, ComponentReferenceImpl>();
        }
    }

    void resolve(AbstractExchange exchange) {
        this.exchange = exchange;
        for (DirectConsumerReferenceImpl directConsumerReferenceImpl : this.directConsumers.values()) {
            this.addDirectConsumerToComponent(directConsumerReferenceImpl);
            directConsumerReferenceImpl.bind(exchange);
        }
        for (AsyncConsumerReferenceImpl asyncConsumerReferenceImpl : this.asyncConsumers.values()) {
            this.addAsyncConsumerToComponent(asyncConsumerReferenceImpl);
            asyncConsumerReferenceImpl.bind(exchange);
        }
        for (RequestConsumerReferenceImpl requestConsumerReferenceImpl : this.requestConsumers.values()) {
            this.addRequestConsumerToComponent(requestConsumerReferenceImpl);
            requestConsumerReferenceImpl.bind(exchange);
        }
        for (ReceiverReferenceImpl receiverReferenceImpl : this.receivers.values()) {
            this.addReceiverToComponent(receiverReferenceImpl);
            receiverReferenceImpl.bind(exchange);
        }
        for (EventCacheReferenceImpl eventCacheReferenceImpl : this.eventCaches.values()) {
            eventCacheReferenceImpl.bind(exchange);
        }
        this.replicationSources.values().forEach(this::addReplicationSourceToComponent);
        this.replicationTargets.values().forEach(this::addReplicationTargetToComponent);
        this.init();
        for (ComponentReferenceImpl componentReferenceImpl : this.components.values()) {
            this.componentsByName.put(componentReferenceImpl.getName(), componentReferenceImpl);
            componentReferenceImpl.bind(exchange);
            componentReferenceImpl.bind(this);
        }
    }

    @Override
    public FabricNodeRole getRole() {
        return this.role;
    }

    ContextId getContextId() {
        return this.contextId;
    }

    @Override
    public FabricAddress getFabricAddress() {
        return this.contextId.getFabricAddress();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.contextId.getIpAddress();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getClusterName() {
        return this.cluster;
    }

    void setClusterName(String cluster) {
        this.cluster = cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LinkAddress> getAcceptors() {
        Object object = this.acceptorMutex;
        synchronized (object) {
            this.initAcceptors();
            return new ArrayList<LinkAddress>(this.acceptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAcceptor(LinkAddress address) {
        Object object = this.acceptorMutex;
        synchronized (object) {
            this.initAcceptors();
            this.acceptors.add(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAcceptor(LinkAddress address) {
        Object object = this.acceptorMutex;
        synchronized (object) {
            this.initAcceptors();
            this.acceptors.remove(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAcceptors(List<LinkAddress> links) {
        Object object = this.acceptorMutex;
        synchronized (object) {
            this.initAcceptors();
            this.acceptors.addAll(links);
        }
    }

    private void initAcceptors() {
        if (this.acceptors == null) {
            this.acceptors = new ArrayList<LinkAddress>();
        }
    }

    @Override
    public long getWeight() {
        return this.weight;
    }

    void setWeight(long weight) {
        this.weight = weight;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public int getProcessID() {
        return this.pid;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    void setReady(boolean isReady) {
        this.isReady = isReady;
    }

    void initStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    void addEndpoint(EndpointReferenceImpl endpoint) {
        if (endpoint instanceof ComponentReferenceImpl) {
            this.addComponent((ComponentReferenceImpl)endpoint);
        }
        if (endpoint instanceof DirectConsumerReferenceImpl) {
            this.addDirectConsumer((DirectConsumerReferenceImpl)endpoint);
        } else if (endpoint instanceof AsyncConsumerReferenceImpl) {
            this.addAsyncConsumer((AsyncConsumerReferenceImpl)endpoint);
        } else if (endpoint instanceof RequestConsumerReferenceImpl) {
            this.addRequestConsumer((RequestConsumerReferenceImpl)endpoint);
        } else if (endpoint instanceof ReceiverReferenceImpl) {
            this.addReceiver((ReceiverReferenceImpl)endpoint);
        } else if (endpoint instanceof EventCacheReferenceImpl) {
            this.addEventCache((EventCacheReferenceImpl)endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addComponent(ComponentReferenceImpl component) {
        component.bind(this);
        Object object = this.componentsMutex;
        synchronized (object) {
            this.components.put(component.getAddress(), component);
            this.componentsByName.put(component.getName(), component);
        }
    }

    private void addDirectConsumer(DirectConsumerReferenceImpl consumer) {
        this.directConsumers.put(consumer.getAddress(), consumer);
        this.addDirectConsumerToComponent(consumer);
    }

    private void addDirectConsumerToComponent(DirectConsumerReferenceImpl consumer) {
        ComponentReferenceImpl component = this.getComponent(consumer.getComponentAddress());
        if (component != null) {
            component.addDirectConsumer(consumer);
        }
    }

    private void addAsyncConsumer(AsyncConsumerReferenceImpl consumer) {
        this.asyncConsumers.put(consumer.getAddress(), consumer);
        this.addAsyncConsumerToComponent(consumer);
    }

    private void addAsyncConsumerToComponent(AsyncConsumerReferenceImpl consumer) {
        ComponentReferenceImpl component = this.getComponent(consumer.getComponentAddress());
        if (component != null) {
            component.addAsyncConsumer(consumer);
        }
    }

    private void addRequestConsumer(RequestConsumerReferenceImpl consumer) {
        this.requestConsumers.put(consumer.getAddress(), consumer);
        this.addRequestConsumerToComponent(consumer);
    }

    private void addRequestConsumerToComponent(RequestConsumerReferenceImpl consumer) {
        ComponentReferenceImpl component = this.getComponent(consumer.getComponentAddress());
        if (component != null) {
            component.addRequestConsumer(consumer);
        }
    }

    private void addReceiver(ReceiverReferenceImpl receiver) {
        this.receivers.put(receiver.getAddress(), receiver);
        this.addReceiverToComponent(receiver);
    }

    private void addReceiverToComponent(ReceiverReferenceImpl receiver) {
        ComponentReferenceImpl component = this.getComponent(receiver.getComponentAddress());
        if (component != null) {
            component.addReceiver(receiver);
        }
    }

    void addEventCache(EventCacheReferenceImpl cache) {
        this.eventCaches.put(cache.getAddress(), cache);
    }

    void addReplicationEntity(ReplicationEntityReferenceImpl entity) {
        if (entity instanceof ReplicationSourceReferenceImpl) {
            this.addReplicationSource((ReplicationSourceReferenceImpl)entity);
        } else if (entity instanceof ReplicationTargetReferenceImpl) {
            this.addReplicationTarget((ReplicationTargetReferenceImpl)entity);
        }
    }

    private void addReplicationSource(ReplicationSourceReferenceImpl replicationSource) {
        this.replicationSources.put(replicationSource.getName(), replicationSource);
        this.addReplicationSourceToComponent(replicationSource);
    }

    private void addReplicationSourceToComponent(ReplicationSourceReferenceImpl replicationSource) {
        ComponentReferenceImpl component = this.getComponent(replicationSource.getComponentAddress());
        if (component != null) {
            component.addReplicationSource(replicationSource);
        }
    }

    private void addReplicationTarget(ReplicationTargetReferenceImpl replicationTarget) {
        this.replicationTargets.put(replicationTarget.getName(), replicationTarget);
        this.addReplicationTargetToComponent(replicationTarget);
    }

    private void addReplicationTargetToComponent(ReplicationTargetReferenceImpl replicationTarget) {
        ComponentReferenceImpl component = this.getComponent(replicationTarget.getComponentAddress());
        if (component != null) {
            component.addReplicationTarget(replicationTarget);
        }
    }

    void addAccessorSession(AccessorSessionReferenceImpl session) {
        this.initAccessorSessions();
        this.accessorSessions.put(session.getAddress(), session);
        ComponentReferenceImpl component = this.getComponent(session.getComponentAddress());
        if (component != null) {
            component.addAccessorSession(session);
        }
    }

    synchronized void initAccessorSessions() {
        if (this.accessorSessions == null) {
            this.accessorSessions = new ConcurrentHashMap<FabricAddress, AccessorSessionReferenceImpl>();
        }
    }

    EndpointReferenceImpl removeEndpoint(EndpointReferenceImpl endpoint) {
        if (endpoint instanceof ComponentReferenceImpl) {
            return this.removeComponent((ComponentReferenceImpl)endpoint);
        }
        if (endpoint instanceof AccessorSessionReferenceImpl) {
            return this.removeEndpoint(endpoint, this.accessorSessions);
        }
        if (endpoint instanceof DirectConsumerReferenceImpl) {
            return this.removeEndpoint(endpoint, this.directConsumers);
        }
        if (endpoint instanceof AsyncConsumerReferenceImpl) {
            return this.removeEndpoint(endpoint, this.asyncConsumers);
        }
        if (endpoint instanceof RequestConsumerReferenceImpl) {
            return this.removeEndpoint(endpoint, this.requestConsumers);
        }
        if (endpoint instanceof ReceiverReferenceImpl) {
            return this.removeEndpoint(endpoint, this.receivers);
        }
        if (endpoint instanceof EventCacheReferenceImpl) {
            return this.removeEventCache((EventCacheReferenceImpl)endpoint);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentReferenceImpl removeComponent(FabricAddress address) {
        Object object = this.componentsMutex;
        synchronized (object) {
            ComponentReferenceImpl result = this.components.remove(address);
            if (result != null) {
                this.componentsByName.remove(result.getName());
            }
            return result;
        }
    }

    private ComponentReferenceImpl removeComponent(ComponentReferenceImpl component) {
        return this.removeComponent(component.getAddress());
    }

    EventCacheReferenceImpl removeEventCache(EventCacheReferenceImpl cache) {
        return this.removeEventCache(cache.getAddress());
    }

    private EventCacheReferenceImpl removeEventCache(FabricAddress address) {
        return this.eventCaches.remove(address);
    }

    EventCacheReferenceImpl removeEventCache(String name) {
        return this.eventCaches.values().stream().filter(cache -> cache.getName().equals(name)).findFirst().map(cache -> this.eventCaches.remove(cache.getAddress())).orElse(null);
    }

    void removeReplicationEntity(ReplicationEntityReferenceImpl entity) {
        if (entity instanceof ReplicationSourceReferenceImpl) {
            this.removeReplicationEntity(entity, this.replicationSources);
        } else if (entity instanceof ReplicationTargetReferenceImpl) {
            this.removeReplicationEntity(entity, this.replicationTargets);
        }
    }

    private <T extends ReplicationEntityReferenceImpl> T removeReplicationEntity(ReplicationEntityReferenceImpl entity, Map<String, T> entities) {
        ComponentReferenceImpl component;
        ReplicationEntityReferenceImpl result = (ReplicationEntityReferenceImpl)entities.remove(entity.getName());
        if (result != null && (component = this.getComponent(result.getComponentAddress())) != null) {
            component.removeReplicationEntity(result);
        }
        return (T)result;
    }

    AccessorSessionReferenceImpl removeAccessorSession(AccessorSessionReferenceImpl session) {
        return this.removeEndpoint(session, this.accessorSessions);
    }

    private <T extends EndpointReferenceImpl> T removeEndpoint(EndpointReferenceImpl endpoint, Map<FabricAddress, T> endpoints) {
        ComponentReferenceImpl component;
        EndpointReferenceImpl result = (EndpointReferenceImpl)endpoints.remove(endpoint.getAddress());
        if (result != null && (component = this.getComponent(result.getComponentAddress())) != null) {
            component.removeEndpoint(result);
        }
        return (T)result;
    }

    ComponentReferenceImpl changeComponent(AbstractExchange.ChangeComponentData data) {
        ComponentReferenceImpl reference = this.components.get(data.address);
        reference.update(data.type, data.parameter);
        return reference;
    }

    EndpointReferenceImpl changeConsumer(EndpointReferenceImpl reference) {
        EndpointReferenceImpl result;
        if (reference instanceof DirectConsumerReferenceImpl) {
            result = this.directConsumers.get(reference.address);
            ((DirectConsumerReferenceImpl)result).update((DirectConsumerReferenceImpl)reference);
        } else if (reference instanceof AsyncConsumerReferenceImpl) {
            result = this.asyncConsumers.get(reference.address);
            ((AsyncConsumerReferenceImpl)result).update((AsyncConsumerReferenceImpl)reference);
        } else {
            result = this.receivers.get(reference.address);
            ((ReceiverReferenceImpl)result).update((ReceiverReferenceImpl)reference);
        }
        return result;
    }

    void changeEventCache(EventCacheReferenceImpl reference) {
        this.eventCaches.get(reference.address).update(reference);
    }

    void changeReplicationEntity(ReplicationEntityReferenceImpl entity) {
        if (entity instanceof ReplicationSourceReferenceImpl) {
            this.changeReplicationSource((ReplicationSourceReferenceImpl)entity);
        } else if (entity instanceof ReplicationTargetReferenceImpl) {
            this.changeReplicationTarget((ReplicationTargetReferenceImpl)entity);
        }
    }

    private void changeReplicationSource(ReplicationSourceReferenceImpl replicationSource) {
        if (this.replicationSources.containsKey(replicationSource.getName())) {
            this.replicationSources.put(replicationSource.getName(), replicationSource);
        }
    }

    private void changeReplicationTarget(ReplicationTargetReferenceImpl replicationTarget) {
        if (this.replicationTargets.containsKey(replicationTarget.getName())) {
            this.replicationTargets.put(replicationTarget.getName(), replicationTarget);
        }
    }

    Collection<ComponentReferenceImpl> doGetComponents() {
        return this.components.values();
    }

    Collection<DirectConsumerReferenceImpl> doGetDirectConsumers() {
        return this.directConsumers.values();
    }

    Collection<AsyncConsumerReferenceImpl> doGetAsyncConsumers() {
        return this.asyncConsumers.values();
    }

    Collection<RequestConsumerReferenceImpl> doGetRequestConsumers() {
        return this.requestConsumers.values();
    }

    Collection<ReceiverReferenceImpl> doGetReceivers() {
        return this.receivers.values();
    }

    Collection<EventCacheReferenceImpl> doGetEventCaches() {
        return this.eventCaches.values();
    }

    Collection<ReplicationSourceReferenceImpl> doGetReplicationSources() {
        return this.replicationSources.values();
    }

    Collection<ReplicationTargetReferenceImpl> doGetReplicationTargets() {
        return this.replicationTargets.values();
    }

    Collection<AccessorSessionReferenceImpl> doGetAccessorSessions() {
        return this.accessorSessions.values();
    }

    ComponentReferenceImpl getComponent(FabricAddress address) {
        return this.components.get(address);
    }

    ComponentReferenceImpl getComponent(String name) {
        return this.componentsByName.get(name);
    }

    DirectConsumerReferenceImpl getDirectConsumer(FabricAddress address) {
        return this.directConsumers.get(address);
    }

    DirectConsumerReferenceImpl getDirectConsumer(String name) {
        return (DirectConsumerReferenceImpl)InternalUtils.getEndpoint(name, this.directConsumers.values());
    }

    AsyncConsumerReferenceImpl getAsyncConsumer(FabricAddress address) {
        return this.asyncConsumers.get(address);
    }

    AsyncConsumerReferenceImpl getAsyncConsumer(String name) {
        return (AsyncConsumerReferenceImpl)InternalUtils.getEndpoint(name, this.asyncConsumers.values());
    }

    RequestConsumerReferenceImpl getRequestConsumer(FabricAddress address) {
        return this.requestConsumers.get(address);
    }

    RequestConsumerReferenceImpl getRequestConsumer(String name) {
        return (RequestConsumerReferenceImpl)InternalUtils.getEndpoint(name, this.requestConsumers.values());
    }

    ReceiverReferenceImpl getReceiver(FabricAddress address) {
        return this.receivers.get(address);
    }

    ReceiverReferenceImpl getReceiver(String name) {
        return (ReceiverReferenceImpl)InternalUtils.getEndpoint(name, this.receivers.values());
    }

    EventCacheReferenceImpl getEventCache(FabricAddress address) {
        return this.eventCaches.get(address);
    }

    EventCacheReferenceImpl getEventCache(String eventFilter) {
        return (EventCacheReferenceImpl)InternalUtils.getEndpoint(eventFilter, this.eventCaches.values());
    }

    ReplicationSourceReferenceImpl getReplicationSource(String name) {
        return this.replicationSources.get(name);
    }

    ReplicationTargetReferenceImpl getReplicationTarget(String name) {
        return this.replicationTargets.get(name);
    }

    AccessorSessionReferenceImpl getAccessorSession(FabricAddress address) {
        if (this.isLocalRuntime()) {
            return this.doGetAccessorSession(address);
        }
        return (AccessorSessionReferenceImpl)this.invokeModeratorRequest("getAccessorSession", address);
    }

    AccessorSessionReferenceImpl doGetAccessorSession(FabricAddress address) {
        return this.accessorSessions.get(address);
    }

    boolean existsEventCache(String eventFilter) {
        return this.eventCaches.values().stream().anyMatch(cache -> cache.getEventFilter().equals(eventFilter));
    }

    boolean hasEventCaches() {
        return !this.eventCaches.isEmpty();
    }

    void updateAddress(byte clusterNumber, short nodeNumber) {
        if (this.getFabricAddress().needUpdate(clusterNumber, nodeNumber)) {
            this.getFabricAddress().setNumbers(clusterNumber, nodeNumber);
            this.components = this.updateAddress(clusterNumber, nodeNumber, this.components);
            this.directConsumers = this.updateAddress(clusterNumber, nodeNumber, this.directConsumers);
            this.asyncConsumers = this.updateAddress(clusterNumber, nodeNumber, this.asyncConsumers);
            this.requestConsumers = this.updateAddress(clusterNumber, nodeNumber, this.requestConsumers);
            this.receivers = this.updateAddress(clusterNumber, nodeNumber, this.receivers);
            this.eventCaches = this.updateAddress(clusterNumber, nodeNumber, this.eventCaches);
            if (this.accessorSessions != null) {
                this.accessorSessions = this.updateAddress(clusterNumber, nodeNumber, this.accessorSessions);
            }
        }
    }

    void print(Printer printer) {
        printer.add(this.getName() + " [" + String.valueOf(this.getFabricAddress()) + "]");
        printer.increaseIndent();
        this.print(printer, this.components);
        this.print(printer, this.directConsumers);
        this.print(printer, this.asyncConsumers);
        this.print(printer, this.requestConsumers);
        this.print(printer, this.receivers);
        this.print(printer, this.eventCaches);
        this.print(printer, this.accessorSessions);
        this.print1(printer, this.replicationSources);
        this.print1(printer, this.replicationTargets);
        if (!this.acceptors.isEmpty()) {
            printer.newline().add("Acceptors: ").append(this.acceptors.get(0).toString());
            for (LinkAddress linkAddress : this.acceptors.subList(1, this.acceptors.size())) {
                printer.append(", ").append(linkAddress.toString());
            }
        }
        printer.decreaseIndent();
    }

    <T extends EndpointReference> Map<FabricAddress, T> updateAddress(byte clusterNumber, short nodeNumber, Map<FabricAddress, T> endpoints) {
        ConcurrentHashMap<FabricAddress, EndpointReference> newEndpoints = new ConcurrentHashMap<FabricAddress, EndpointReference>();
        for (EndpointReference endpoint : endpoints.values()) {
            endpoint.getAddress().setNumbers(clusterNumber, nodeNumber);
            endpoint.getComponentAddress().setNumbers(clusterNumber, nodeNumber);
            newEndpoints.put(endpoint.getAddress(), endpoint);
        }
        return newEndpoints;
    }

    FabricNode copyWithGlobalScope() {
        FabricNode result = new FabricNode(this, false);
        this.fillWithGlobalScope(this.components, result.components);
        this.fillWithGlobalScope(this.directConsumers, result.directConsumers);
        this.fillWithGlobalScope(this.asyncConsumers, result.asyncConsumers);
        this.fillWithGlobalScope(this.requestConsumers, result.requestConsumers);
        this.fillWithGlobalScope(this.receivers, result.receivers);
        this.fillWithGlobalScope(this.eventCaches, result.eventCaches);
        this.fillWithGlobalScope1(this.replicationSources, result.replicationSources);
        this.fillWithGlobalScope1(this.replicationTargets, result.replicationTargets);
        return result;
    }

    private <T extends EndpointReference> void fillWithGlobalScope(Map<FabricAddress, T> from, Map<FabricAddress, T> to) {
        from.values().stream().filter(IS_SCOPE_GLOBAL).forEach(endpoint -> to.put(endpoint.getAddress(), endpoint));
    }

    private <T extends EntityReference> void fillWithGlobalScope1(Map<String, T> from, Map<String, T> to) {
        from.values().stream().filter(IS_SCOPE_GLOBAL).forEach(entity -> to.put(entity.getName(), entity));
    }

    FabricNode copyWithNonLocalScope() {
        FabricNode result = new FabricNode(this, this.isLocal);
        this.fillWithNonLocalScope(this.components, result.components);
        this.fillWithNonLocalScope(this.directConsumers, result.directConsumers);
        this.fillWithNonLocalScope(this.asyncConsumers, result.asyncConsumers);
        this.fillWithNonLocalScope(this.requestConsumers, result.requestConsumers);
        this.fillWithNonLocalScope(this.receivers, result.receivers);
        this.fillWithNonLocalScope(this.eventCaches, result.eventCaches);
        this.fillWithNonLocalScope1(this.replicationSources, result.replicationSources);
        this.fillWithNonLocalScope1(this.replicationSources, result.replicationSources);
        return result;
    }

    private <T extends EndpointReference> void fillWithNonLocalScope(Map<FabricAddress, T> from, Map<FabricAddress, T> to) {
        from.values().stream().filter(IS_SCOPE_NO_LOCAL).forEach(endpoint -> to.put(endpoint.getAddress(), endpoint));
    }

    private <T extends EntityReference> void fillWithNonLocalScope1(Map<String, T> from, Map<String, T> to) {
        from.values().stream().filter(IS_SCOPE_NO_LOCAL).forEach(entity -> to.put(entity.getName(), entity));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof FabricNode && super.equals(other);
    }

    @Override
    public String toString() {
        Printer printer = new Printer();
        this.print(printer);
        return printer.result();
    }

    <T extends EndpointReference> void print(Printer printer, Map<FabricAddress, T> endpoints) {
        if (endpoints != null) {
            for (EndpointReference endpoint : endpoints.values()) {
                printer.add(endpoint.toString());
            }
        }
    }

    <T extends EntityReference> void print1(Printer printer, Map<String, T> endpoints) {
        for (EntityReference endpoint : endpoints.values()) {
            printer.add(endpoint.toString());
        }
    }

    String getPrintName() {
        return FabricNode.getPrintName(this.getName());
    }

    String getFullPrintName() {
        return "[" + this.getName() + "(" + String.valueOf(this.getFabricAddress()) + ")]";
    }

    static String getPrintName(String nodeName) {
        return "[" + nodeName + "]";
    }

    String getComponentFullName(String componentType, String componentName) {
        return ModeratorUtils.makeComponentFullName(this.getName(), componentType, componentName);
    }

    String getEndpointFullName(String endpointName) {
        return !endpointName.contains("://") ? this.getNameWithDelimiter() + endpointName : endpointName;
    }

    String getNameWithDelimiter() {
        return FabricNode.getNameWithDelimiter(this.getName());
    }

    public static String getNameWithDelimiter(String nodeName) {
        return nodeName + "://";
    }

    synchronized boolean isNewBroadcastEvent(long iEvent) {
        if (this.iLastBroadcastEvent < iEvent) {
            this.iLastBroadcastEvent = iEvent;
            return true;
        }
        return false;
    }

    @Override
    public List<ComponentReference> getComponents(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.doGetComponents());
    }

    @Override
    public List<ConsumerReference> getConsumers(EventScope eventScope) {
        ArrayList<ConsumerReference> result = new ArrayList<ConsumerReference>();
        InternalUtils.getEntities(eventScope, this.doGetDirectConsumers(), result);
        InternalUtils.getEntities(eventScope, this.doGetAsyncConsumers(), result);
        InternalUtils.getEntities(eventScope, this.doGetReceivers(), result);
        InternalUtils.getEntities(eventScope, this.doGetRequestConsumers(), result);
        return result;
    }

    @Override
    public List<EventConsumerReference> getEventConsumers(EventScope eventScope) {
        ArrayList<EventConsumerReference> result = new ArrayList<EventConsumerReference>();
        InternalUtils.getEntities(eventScope, this.doGetDirectConsumers(), result);
        InternalUtils.getEntities(eventScope, this.doGetAsyncConsumers(), result);
        InternalUtils.getEntities(eventScope, this.doGetReceivers(), result);
        return result;
    }

    @Override
    public List<DirectConsumerReference> getDirectConsumers(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.doGetDirectConsumers());
    }

    @Override
    public List<AsyncConsumerReference> getAsyncConsumers(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.doGetAsyncConsumers());
    }

    @Override
    public List<RequestConsumerReference> getRequestConsumers(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.doGetRequestConsumers());
    }

    @Override
    public List<ReceiverReference> getReceivers(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.doGetReceivers());
    }

    @Override
    public List<EventCacheReference> getEventCaches() {
        return new ArrayList<EventCacheReference>(this.doGetEventCaches());
    }

    @Override
    public List<ReplicationSourceReference> getReplicationSources(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.doGetReplicationSources());
    }

    @Override
    public List<ReplicationTargetReference> getReplicationTargets(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.doGetReplicationTargets());
    }

    @Override
    public List<AccessorReference> getAccessors(EventScope eventScope) {
        eventScope = InternalUtils.checkEventScope(eventScope);
        if (this.isLocalRuntime()) {
            return this.doGetAccessors(null, eventScope);
        }
        if (this.isLocalClient()) {
            ArrayList<AccessorReference> result = new ArrayList<AccessorReference>(((ClientExchange)this.exchange).fabricConnection.component.reference.doGetAccessors(eventScope));
            result.addAll((Collection)this.invokeModeratorRequest(true, "doGetAccessors", new Object[]{eventScope}));
            return result;
        }
        return (List)this.invokeModeratorRequest("doGetAccessors", new Object[]{eventScope});
    }

    List<AccessorReference> getAccessors(FabricAddress componentAddress, EventScope eventScope) {
        ComponentReferenceImpl component = this.getComponent(componentAddress);
        return component != null ? component.getAccessors(eventScope) : new ArrayList();
    }

    List<AccessorReference> doGetAccessors(EventScope eventScope) {
        return this.doGetAccessors(null, eventScope);
    }

    List<AccessorReference> doGetAccessors(FabricAddress excludedClientAddress, EventScope eventScope) {
        ArrayList<AccessorReference> result = new ArrayList<AccessorReference>();
        this.components.values().forEach(component -> result.addAll(component.doGetAccessors(eventScope)));
        result.addAll(this.broadcastModeratorRequest(excludedClientAddress, "doGetAccessors", new Object[]{eventScope}));
        return result;
    }

    List<AccessorReference> doGetAccessors() {
        ArrayList<AccessorReference> result = new ArrayList<AccessorReference>();
        this.components.values().forEach(component -> result.addAll(component.doGetAccessors(EventScope.INHERITED)));
        return result;
    }

    @Override
    public List<AccessorSessionReference> getAccessorSessions(EventScope eventScope) {
        eventScope = InternalUtils.checkEventScope(eventScope);
        if (this.isLocalRuntime()) {
            return InternalUtils.getEntities(eventScope, this.doGetAccessorSessions());
        }
        return InternalUtils.convert((List)this.invokeModeratorRequest("getAccessorSessions", new Object[]{eventScope}));
    }

    List<AccessorSessionReference> getAccessorSessions(FabricAddress componentAddress, EventScope eventScope) {
        ComponentReferenceImpl component = this.getComponent(componentAddress);
        return component != null ? component.doGetAccessorSessions(eventScope) : new ArrayList();
    }

    @Override
    public List<EventConsumerReference> getEventConsumers(String groupName) {
        return this.getGroupConsumers(groupName, new InternalUtils.EventConsumersGetter());
    }

    @Override
    public List<AsyncConsumerReference> getAsyncConsumers(String groupName) {
        return this.getGroupConsumers(groupName, new InternalUtils.AsyncConsumersGetter());
    }

    @Override
    public List<ReceiverReference> getReceivers(String groupName) {
        return this.getGroupConsumers(groupName, new InternalUtils.ReceiversGetter());
    }

    private <T extends EventConsumerReference> List<T> getGroupConsumers(String groupName, InternalUtils.ConsumersGetter<T> getter) {
        return InternalUtils.getGroupConsumers(this.getComponents(EventScope.INHERITED), groupName, getter);
    }

    @Override
    public ComponentReference lookupComponent(FabricAddress address) {
        return this.getComponent(address);
    }

    @Override
    public ComponentReference lookupComponent(String name) {
        return this.getComponent(this.getEndpointFullName(name));
    }

    @Override
    public ConsumerReference lookupConsumer(FabricAddress address) {
        EventConsumerReference result = this.lookupEventConsumer(address);
        return result != null ? result : this.lookupRequestConsumer(address);
    }

    @Override
    public ConsumerReference lookupConsumer(String name) {
        EventConsumerReference result = this.lookupEventConsumer(name);
        return result != null ? result : this.lookupRequestConsumer(name);
    }

    @Override
    public EventConsumerReference lookupEventConsumer(FabricAddress address) {
        EventConsumerReference result = this.lookupDirectConsumer(address);
        if (result == null && (result = this.lookupAsyncConsumer(address)) == null) {
            result = this.lookupReceiver(address);
        }
        return result;
    }

    @Override
    public EventConsumerReference lookupEventConsumer(String name) {
        String fullName = this.getEndpointFullName(name);
        EventConsumerReferenceImpl result = this.getDirectConsumer(fullName);
        if (result == null && (result = this.getAsyncConsumer(fullName)) == null) {
            result = this.getReceiver(fullName);
        }
        return result;
    }

    @Override
    public DirectConsumerReference lookupDirectConsumer(FabricAddress address) {
        return this.getDirectConsumer(address);
    }

    @Override
    public DirectConsumerReference lookupDirectConsumer(String name) {
        return this.getDirectConsumer(this.getEndpointFullName(name));
    }

    @Override
    public AsyncConsumerReference lookupAsyncConsumer(FabricAddress address) {
        return this.getAsyncConsumer(address);
    }

    @Override
    public AsyncConsumerReference lookupAsyncConsumer(String name) {
        return this.getAsyncConsumer(this.getEndpointFullName(name));
    }

    @Override
    public RequestConsumerReference lookupRequestConsumer(FabricAddress address) {
        return this.getRequestConsumer(address);
    }

    @Override
    public RequestConsumerReference lookupRequestConsumer(String name) {
        return this.getRequestConsumer(this.getEndpointFullName(name));
    }

    @Override
    public ReceiverReference lookupReceiver(FabricAddress address) {
        return this.getReceiver(address);
    }

    @Override
    public ReceiverReference lookupReceiver(String name) {
        return this.getReceiver(this.getEndpointFullName(name));
    }

    @Override
    public EventCacheReference lookupEventCache(String eventFilter) {
        return this.getEventCache(eventFilter);
    }

    @Override
    public ReplicationSourceReference lookupReplicationSource(String name) {
        return this.getReplicationSource(name);
    }

    @Override
    public ReplicationTargetReference lookupReplicationTarget(String name) {
        return this.getReplicationTarget(name);
    }

    @Override
    public AccessorReference lookupAccessor(String name) {
        ComponentReference component = this.lookupComponent(ModeratorUtils.extractComponentNameFromConsumerName(name));
        return component != null ? component.lookupAccessor(ModeratorUtils.extractConsumerName(name)) : null;
    }

    AccessorReference lookupAccessor(FabricAddress componentAddress, String name) {
        ComponentReference component = this.lookupComponent(componentAddress);
        return component != null ? component.lookupAccessor(name) : null;
    }

    @Override
    public AccessorSessionReference lookupAccessorSession(FabricAddress address) {
        return this.getAccessorSession(address);
    }

    @Override
    public AccessorSessionReference lookupAccessorSession(String name) {
        return (AccessorSessionReference)InternalUtils.getEndpoint(this.getEndpointFullName(name), this.getAccessorSessions(EventScope.INHERITED));
    }

    AccessorSessionReference lookupAccessorSession(FabricAddress componentAddress, FabricAddress sessionAddress) {
        ComponentReferenceImpl component = this.getComponent(componentAddress);
        return component != null ? component.doLookupAccessorSession(sessionAddress) : null;
    }

    @Override
    public List<String> listComponents() {
        return InternalUtils.listEntities(this.getComponents(EventScope.INHERITED));
    }

    @Override
    public List<String> listConsumers() {
        return InternalUtils.listEntities(this.getConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listEventConsumers() {
        return InternalUtils.listEntities(this.getEventConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listDirectConsumers() {
        return InternalUtils.listEntities(this.getDirectConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listAsyncConsumers() {
        return InternalUtils.listEntities(this.getAsyncConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listRequestConsumers() {
        return InternalUtils.listEntities(this.getRequestConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listReceivers() {
        return InternalUtils.listEntities(this.getReceivers(EventScope.INHERITED));
    }

    @Override
    public List<String> listEventCaches() {
        return InternalUtils.listEntities(this.getEventCaches());
    }

    @Override
    public List<String> listReplicationSources() {
        return InternalUtils.listEntities(this.getReplicationSources(EventScope.INHERITED));
    }

    @Override
    public List<String> listReplicationTargets() {
        return InternalUtils.listEntities(this.getReplicationTargets(EventScope.INHERITED));
    }

    @Override
    public List<String> listAccessors() {
        return InternalUtils.listEntities(this.getAccessors(EventScope.INHERITED));
    }

    @Override
    public List<String> listAccessorSessions() {
        return InternalUtils.listEntities(this.getAccessorSessions(EventScope.INHERITED));
    }

    @Override
    public EventFlowMap getEventFlowMap(boolean all) {
        return this.isLocalRuntime() ? this.exchange.getEventFlowMap(all) : (EventFlowMap)this.invokeModeratorRequest("getEventFlowMap", new Class[]{Boolean.TYPE}, new Object[]{all});
    }

    SecurityContext getSecurityContext(FabricAddress address) {
        if (this.isLocal) {
            ComponentReferenceImpl component = this.getComponent(address);
            return component != null ? component.doGetSecurityContext() : null;
        }
        return (SecurityContext)this.invokeModeratorRequest("getSecurityContext", address);
    }

    <TReply> TReply invokeModeratorRequest(String methodName, Object ... parameters) {
        return this.invokeModeratorRequest(false, methodName, parameters);
    }

    <TReply> TReply invokeModeratorRequest(String methodName, Class[] parameterTypes, Object ... parameters) {
        return this.exchange.invokeModeratorRequest(this.isLocalClient() ? FabricAddress.NULL : this.getFabricAddress(), methodName, parameterTypes, parameters);
    }

    <TReply> TReply invokeModeratorRequest(boolean fromLocalClient, String methodName, Object ... parameters) {
        return this.exchange.invokeModeratorRequest(this.isLocalClient() ? FabricAddress.NULL : this.getFabricAddress(), fromLocalClient, methodName, parameters);
    }

    <TReply> TReply invokeModeratorRequest(FabricAddress clientAddress, String methodName, Object ... parameters) {
        return this.exchange.invokeModeratorRequest(clientAddress, false, methodName, parameters);
    }

    <TReply> List<TReply> broadcastModeratorRequest(FabricAddress excludedAddress, String methodName, Object ... parameters) {
        return ((RuntimeExchange)this.exchange).broadcastModeratorRequest(excludedAddress, methodName, InternalUtils.getParameterTypes(parameters), parameters);
    }

    boolean isLocalRuntime() {
        return this.isLocal && RuntimeState.isActive();
    }

    boolean isLocalClient() {
        return this.isLocal && ClientState.isActive();
    }
}

