/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.evqueue.EventQueueInterruptException;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.EventSelectorFormatException;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.StreamInterruptException;
import com.streamscape.sef.dispatcher.AbstractFabricConsumer;
import com.streamscape.sef.dispatcher.ExchangeEventAsyncConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventDispatcherImpl;
import com.streamscape.sef.dispatcher.FabricGroupLinkImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.enums.FlowControlMode;

class FabricEventReceiverImpl
extends AbstractFabricConsumer
implements EventReceiver {
    transient ExchangeEventAsyncConsumerImpl underlyingConsumer;

    FabricEventReceiverImpl(String name, CompositeFilter eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, FabricEventDispatcherImpl dispatcher, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        super(name, eventScope, noLocal, dispatcher, groupLink);
        this.underlyingConsumer = new ExchangeEventAsyncConsumerImpl(dispatcher.makeConsumerFullName(name), eventFilter, null);
        this.underlyingConsumer.setEventSelector(eventSelector, this.createSelectorExpression1(eventSelector));
    }

    @Override
    public String getEventFilter() {
        return this.underlyingConsumer.getEventFilter();
    }

    @Override
    public String getEventSelector() {
        return this.underlyingConsumer.getEventSelector();
    }

    @Override
    CompositeFilter getCompositeFilter() {
        return this.underlyingConsumer.getCompositeFilter();
    }

    @Override
    String getMode() {
        return "Receiver";
    }

    @Override
    public void setEventSelector(String eventSelector) throws EventSelectorFormatException {
        if (!Utils.equalsNullSafe(this.getEventSelector(), eventSelector)) {
            this.underlyingConsumer.setEventSelector(eventSelector, this.createSelectorExpression2(eventSelector));
            this.onChange(true);
        }
    }

    @Override
    public int getMaxDepth() {
        return this.underlyingConsumer.getMaxDepth();
    }

    @Override
    public void setMaxDepth(int maxDepth) {
        if (this.getMaxDepth() != maxDepth) {
            this.underlyingConsumer.setMaxDepth(maxDepth);
            this.onChange(false);
        }
    }

    @Override
    public FlowControlMode getFlowControlMode() {
        return FlowControlMode.convert(this.underlyingConsumer.getFlowControlMode());
    }

    @Override
    public void setFlowControlMode(FlowControlMode flowControlMode) {
        if (this.getFlowControlMode() != flowControlMode) {
            this.underlyingConsumer.setFlowControlMode(flowControlMode.convert());
            this.onChange(false);
        }
    }

    @Override
    public void close() {
        try {
            if (this.getName().startsWith("sys$")) {
                this.dispatcher.dropSystemEventReceiver(this.getName());
            } else {
                this.dispatcher.dropEventReceiver(this.getName(), this.groupLink);
            }
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
    }

    @Override
    public void clear() {
        this.underlyingConsumer.clear();
    }

    @Override
    public int getCurrentDepth() {
        return this.underlyingConsumer.getCurrentDepth();
    }

    @Override
    public ImmutableEventDatagram receive() throws StreamInterruptException {
        try {
            return this.underlyingConsumer.receive();
        }
        catch (EventQueueInterruptException exception) {
            throw new StreamInterruptException("Receiver closed.", exception);
        }
    }

    @Override
    public ImmutableEventDatagram receive(long timeout) throws StreamInterruptException {
        try {
            return this.underlyingConsumer.receive(timeout);
        }
        catch (EventQueueInterruptException exception) {
            throw new StreamInterruptException("Receiver closed.", exception);
        }
    }

    @Override
    public ImmutableEventDatagram receiveNoWait() {
        return this.underlyingConsumer.receiveNoWait();
    }

    @Override
    public ImmutableEventDatagram receive(String eventSelector) throws EventSelectorFormatException, StreamInterruptException {
        try {
            return this.underlyingConsumer.doReceive(this.createSelectorExpression2(eventSelector));
        }
        catch (EventQueueInterruptException exception) {
            throw new StreamInterruptException("Receiver closed.", exception);
        }
    }

    @Override
    public ImmutableEventDatagram receive(String eventSelector, long timeout) throws EventSelectorFormatException, StreamInterruptException {
        try {
            return this.underlyingConsumer.doReceive(this.createSelectorExpression2(eventSelector), timeout);
        }
        catch (EventQueueInterruptException exception) {
            throw new StreamInterruptException("Receiver closed.", exception);
        }
    }

    @Override
    public ImmutableEventDatagram receiveNoWait(String eventSelector) throws EventSelectorFormatException {
        return this.underlyingConsumer.doReceiveNoWait(this.createSelectorExpression2(eventSelector));
    }
}

