/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.dispatcher.EventAsyncConsumerImpl;
import com.streamscape.lib.dispatcher.EventConsumerImpl;
import com.streamscape.lib.dispatcher.EventDispatcher;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.EventException;
import com.streamscape.lib.dispatcher.RequestException;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.selector.SelectorExternalDataSource;
import com.streamscape.lib.selector.SelectorInValues;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.advisory.SystemAdvisories;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.enums.ExceptionStrategy;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.ChunkEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.StreamEvent;
import com.streamscape.sdo.event.SystemEvents;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sef.DomainConstraint;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventCache;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.EventRequestConsumer;
import com.streamscape.sef.FabricEventDispatcher;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.RangeConstraint;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AbstractFabricConsumer;
import com.streamscape.sef.dispatcher.AbstractFabricConsumerStorage;
import com.streamscape.sef.dispatcher.ComponentReferenceImpl;
import com.streamscape.sef.dispatcher.ExchangeEventPublisher;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.ExtendedEventDispatcher;
import com.streamscape.sef.dispatcher.FabricDomainConstraintImpl;
import com.streamscape.sef.dispatcher.FabricEventAsyncConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventDirectConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventReceiverImpl;
import com.streamscape.sef.dispatcher.FabricEventRequestConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventSourceFactoryImpl;
import com.streamscape.sef.dispatcher.FabricGroupLinkImpl;
import com.streamscape.sef.dispatcher.FabricRangeConstraintImpl;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.RequestConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.ReservedNames;
import com.streamscape.sef.dispatcher.ReservedSubjects;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.scheduler.Metaset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;

class FabricEventDispatcherImpl
extends AbstractFabricConsumerStorage
implements FabricEventDispatcher {
    private AbstractFabricComponent component;
    private DatagramPrototypeCache prototypeCache;
    private AbstractExchange exchange;
    private LocalEventDispatcher localDispatcher;
    private ComponentReferenceImpl componentReference;
    private Set<String> boundEventIds = new HashSet<String>();
    private ExceptionStrategy exceptionStrategy = ExceptionStrategy.ABORT;
    private static final List<String> RESERVED_EVENT_FILTER_PREFIXES = ExtendedEventDispatcher.RESERVED_EVENT_FILTER_PREFIXES;

    FabricEventDispatcherImpl(AbstractFabricComponent component, DatagramPrototypeCache prototypeCache) {
        this.component = component;
        this.prototypeCache = prototypeCache;
        this.localDispatcher = new LocalEventDispatcher();
        this.localDispatcher.start();
    }

    @Override
    public void raiseAdvisory(AdvisoryEventDatagram event, EventScope eventScope) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.checkSystemAdvisory(event);
        this.raiseEvent(event, eventScope, 0L);
    }

    private void checkSystemAdvisory(AdvisoryEventDatagram event) throws FabricEventSourceException {
        if (SystemAdvisories.isSystem(event.getEventId())) {
            throw new FabricEventSourceException(6046, "System advisory '" + event.getEventId() + "' cannot be raised directly.");
        }
    }

    void raiseSystemAdvisory(AdvisoryEventDatagram event, EventScope eventScope) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.raiseSystemEvent(event, eventScope);
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, EventScope eventScope, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.raiseEvent(event, eventScope, timeToLive, null);
    }

    void raiseEvent(ImmutableEventDatagram event, EventScope eventScope, long timeToLive, FabricGroupLinkImpl groupLink) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        try {
            this.checkSystemEvent(event);
            eventScope = this.prepareEvent(event, eventScope, false);
            if (event instanceof StreamEvent) {
                this.raiseStreamEvent((StreamEvent)event, eventScope, timeToLive, groupLink);
            } else {
                this.doRaiseEvent(event, eventScope, timeToLive, groupLink);
            }
        }
        catch (IncompatibleScopeException exception) {
            throw new FabricEventSourceException(6044, exception.getMessage());
        }
    }

    private void checkSystemEvent(ImmutableEventDatagram event) throws FabricEventSourceException {
        if (SystemEvents.isSystem(event.getEventId())) {
            throw new FabricEventSourceException(6046, "System event [" + event.getEventId() + "] cannot be raised directly.");
        }
    }

    private void raiseStreamEvent(StreamEvent event, EventScope eventScope, long timeToLive, FabricGroupLinkImpl groupLink) throws FabricEventSourceException, FabricUnboundEventException, IncompatibleScopeException, FabricEventException {
        try {
            long chunkSize = event.getChunkSize();
            long dataSize = event.getBytesLength();
            String chunkEventId = event.getChunkEventId();
            if (chunkSize > 0L && dataSize > 0L) {
                int nChunks = (int)Math.ceil((double)dataSize / (double)chunkSize);
                for (int iChunk = 0; iChunk < nChunks; ++iChunk) {
                    byte[] chunkBytes = new byte[(int)((dataSize -= chunkSize) >= 0L ? chunkSize : dataSize + chunkSize)];
                    event.readBytes(chunkBytes);
                    ChunkEvent chunkEvent = InternalUtils.createProtectedObject(ChunkEvent.class, new Class[]{String.class}, chunkEventId);
                    chunkEvent.setBytes(chunkBytes);
                    InternalUtils.invokeProtectedMethod(chunkEvent, "setChunkNumber", new Class[]{Integer.TYPE}, iChunk + 1);
                    FabricEventSourceFactoryImpl.coalesce((ImmutableEventDatagram)chunkEvent, this.component);
                    this.doRaiseEvent(chunkEvent, eventScope, timeToLive, groupLink);
                    if (event.getChunkDelay() <= 0L) continue;
                    Utils.sleep(event.getChunkDelay());
                }
            }
        }
        catch (SecurityViolationException exception) {
            throw new FabricEventSourceException(exception.getErrorCode(), (Throwable)exception);
        }
        catch (SDOException exception) {
            throw new FabricEventSourceException(5002, (Throwable)exception);
        }
        if (!event.skipFullEvent()) {
            this.doRaiseEvent(event, eventScope, timeToLive, groupLink);
        }
    }

    void raiseSystemEvent(ImmutableEventDatagram event, EventScope eventScope) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        try {
            this.doRaiseEvent(event, this.prepareEvent(event, eventScope, true), -1L, null);
        }
        catch (IncompatibleScopeException exception) {
            throw new FabricEventSourceException(6044, exception.getMessage());
        }
    }

    @Override
    public ImmutableEventDatagram raiseRequest(RequestConsumerReference consumer, ImmutableEventDatagram request, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricRequestException {
        return this.doRaiseRequest(consumer, request, timeout, false);
    }

    ImmutableEventDatagram raiseSystemRequest(RequestConsumerReference consumer, ImmutableEventDatagram request, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricRequestException {
        return this.doRaiseRequest(consumer, request, timeout, true);
    }

    private ImmutableEventDatagram doRaiseRequest(RequestConsumerReference consumer, ImmutableEventDatagram request, long timeout, boolean isSystem) throws FabricEventSourceException, FabricUnboundEventException, FabricRequestException {
        try {
            if (!this.isExchangeReady()) {
                throw new FabricEventSourceException(6012, "Exchange is not ready.");
            }
            if (consumer == null) {
                throw new FabricEventSourceException(6041, "Request consumer not found.");
            }
            this.prepareRequest((RequestConsumerReferenceImpl)consumer, request, isSystem);
            ImmutableEventDatagram reply = this.exchange.raiseRequest((RequestConsumerReferenceImpl)consumer, request, timeout);
            if (reply instanceof FabricEventSourceException) {
                throw (FabricEventSourceException)reply;
            }
            if (reply instanceof FabricRequestException) {
                throw (FabricRequestException)reply;
            }
            return reply;
        }
        catch (IncompatibleScopeException exception) {
            throw new FabricEventSourceException(6044, exception.getMessage());
        }
        catch (RequestException exception) {
            throw (FabricRequestException)exception.getCause();
        }
        catch (EventDispatcherException exception) {
            throw AbstractExchange.createSourceException(exception);
        }
        catch (FabricException exception) {
            throw new FabricEventSourceException(6011, "Raising of request [" + request.getEventId() + "] failed.", exception);
        }
        catch (TimeoutException exception) {
            throw new FabricEventSourceException(6042, (Throwable)exception);
        }
    }

    @Override
    public AcknowledgementEvent raiseRequest(EventDatagram request, EventScope eventScope, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        return this.doRaiseRequest(request, eventScope, distributionStrategy, matchStrategy, timeout, false);
    }

    AcknowledgementEvent raiseSystemRequest(EventDatagram request, EventScope eventScope, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        return this.doRaiseRequest(request, eventScope, distributionStrategy, matchStrategy, timeout, true);
    }

    private AcknowledgementEvent doRaiseRequest(EventDatagram request, EventScope eventScope, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout, boolean isSystem) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        try {
            eventScope = this.prepareRequest(request, eventScope, isSystem);
            if (eventScope == EventScope.LOCAL) {
                return (AcknowledgementEvent)this.localDispatcher.raiseRequest(request, distributionStrategy, matchStrategy, timeout);
            }
            if (this.isExchangeReady()) {
                ExtendedEventDispatcher.ReplyConsumer replyConsumer = this.exchange.createReplyConsumer(request, matchStrategy);
                replyConsumer.setName(this.makeConsumerFullName(replyConsumer.getName()));
                this.addReplyConsumer(replyConsumer, eventScope);
                try {
                    FabricEventSourceFactoryImpl.coalesce((ImmutableEventDatagram)request, this.component);
                    this.raiseRequest(request, distributionStrategy, eventScope);
                    replyConsumer.doWait(timeout > 0L ? timeout : 0L);
                }
                catch (Exception exception) {
                    this.removeReplyConsumer(replyConsumer);
                    if (exception instanceof InterruptedException) {
                        throw new FabricEventSourceException(6049, "Waiting of reply interrupted.");
                    }
                    throw exception;
                }
                this.removeReplyConsumer(replyConsumer);
                if (replyConsumer.getReplyEvent() == null) {
                    throw new FabricEventSourceException(6042, "Reply timeout expired.");
                }
                return (AcknowledgementEvent)replyConsumer.getReplyEvent();
            }
            throw new FabricEventSourceException(6012, "Exchange is not ready.");
        }
        catch (FabricUnboundEventException exception) {
            throw exception;
        }
        catch (FabricEventSourceException exception) {
            throw exception;
        }
        catch (FabricEventException exception) {
            throw exception;
        }
        catch (IncompatibleScopeException exception) {
            throw new FabricEventSourceException(6044, exception.getMessage());
        }
        catch (EventException exception) {
            throw (FabricEventException)exception.getCause();
        }
        catch (EventDispatcherException exception) {
            if (exception.getCause() instanceof FabricEventSourceException) {
                throw (FabricEventSourceException)exception.getCause();
            }
            throw new FabricEventSourceException(6011, "Raising of request [" + request.getEventId() + "] failed.", exception);
        }
        catch (Exception exception) {
            throw new FabricEventSourceException(6011, "Raising of request [" + request.getEventId() + "] failed.", exception);
        }
    }

    private synchronized void addReplyConsumer(ExtendedEventDispatcher.ReplyConsumer consumer, EventScope scope) throws Exception {
        if (this.isExchangeReady()) {
            this.exchange.addReplyConsumer(consumer, this.component.getFabricAddress(), scope);
        }
        this.localDispatcher.addReplyConsumerNonLocal(consumer);
    }

    private synchronized void removeReplyConsumer(ExtendedEventDispatcher.ReplyConsumer consumer) {
        if (consumer != null) {
            this.localDispatcher.removeReplyConsumerNonLocal(consumer);
            try {
                if (this.isExchangeReady()) {
                    this.exchange.removeReplyConsumer(consumer);
                }
            }
            catch (Exception exception) {
                this.logException(exception);
                this.logError("Removing of reply consumer '" + consumer.getUnderlyingConsumer().getName() + "' failed.");
            }
        }
    }

    private void raiseRequest(EventDatagram request, RequestDistributionStrategy distributionStrategy, EventScope eventScope) throws Exception {
        switch (distributionStrategy) {
            case AUCTION: {
                this.localDispatcher.raiseEvent(request, eventScope);
                if (!this.isExchangeReady()) break;
                this.exchange.deliverEvent(request, this.component.getFabricAddress(), eventScope);
                break;
            }
            default: {
                throw new FabricEventSourceException(6048, "Request distribution strategy '" + String.valueOf((Object)distributionStrategy) + "' is not supported.'");
            }
        }
    }

    @Override
    public void raiseException(ExceptionEventDatagram event, EventScope eventScope) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.raiseEvent(event, eventScope, 0L);
    }

    @Override
    public void raiseAcknowledgement(AcknowledgementEvent event, EventScope eventScope, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        try {
            eventScope = this.checkEventScope(eventScope);
        }
        catch (IncompatibleScopeException exception) {
            throw new FabricEventSourceException(6044, exception.getMessage());
        }
        if (!event.getEventId().startsWith("e.reply.") && !event.getEventId().startsWith("e.sys.reply.")) {
            this.checkEventBinding(event);
        }
        FabricEventSourceFactoryImpl.coalesce((ImmutableEventDatagram)event, this.component);
        this.doRaiseEvent(event, eventScope, timeToLive, null);
    }

    private void doRaiseEvent(ImmutableEventDatagram event, EventScope eventScope, long timeToLive, FabricGroupLinkImpl groupLink) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        try {
            (groupLink != null ? groupLink.localDispatcher : this.localDispatcher).raiseEvent(event, eventScope);
            if (eventScope != EventScope.LOCAL && this.isExchangeReady()) {
                ((ExchangeEventPublisher)((Object)(groupLink != null ? groupLink.group : this.exchange))).raiseEvent(event, this.component.getFabricAddress(), eventScope);
            }
        }
        catch (EventException exception) {
            throw (FabricEventException)exception.getCause();
        }
        catch (EventDispatcherException exception) {
            throw new FabricEventSourceException(6016, "Raising of event [" + event.getEventId() + "] failed.", exception);
        }
        catch (FabricException exception) {
            throw new FabricEventSourceException(6011, "Raising of event [" + event.getEventId() + "] failed.", exception);
        }
    }

    @Override
    public void acknowledgeEvent(EventDatagram event, boolean withSourceData, AcknowledgeAction action, String recipientId, EventScope eventScope, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        AcknowledgementEvent ackEvent;
        try {
            ackEvent = EventDatagramFactory.getInstance().createAcknowledgement(event);
            if (withSourceData) {
                FabricEventSourceFactoryImpl.setSourceData(event, ackEvent);
            }
            ackEvent.setAction(action);
            ackEvent.setRecipientID(recipientId);
        }
        catch (Exception exception) {
            if (exception instanceof FabricEventSourceException) {
                throw (FabricEventSourceException)exception;
            }
            throw new FabricEventSourceException(6050, (Throwable)exception);
        }
        this.raiseAcknowledgement(ackEvent, eventScope, timeToLive);
    }

    @Override
    public void acknowledgeException(ExceptionEventDatagram event, AcknowledgeAction action, String recipientId, EventScope eventScope, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        AcknowledgementEvent ackEvent;
        try {
            ackEvent = EventDatagramFactory.getInstance().createAcknowledgement(event);
            ackEvent.setAction(action);
            ackEvent.setRecipientID(recipientId);
        }
        catch (Exception exception) {
            if (exception instanceof FabricEventSourceException) {
                throw (FabricEventSourceException)exception;
            }
            throw new FabricEventSourceException(6050, (Throwable)exception);
        }
        this.raiseAcknowledgement(ackEvent, eventScope, timeToLive);
    }

    @Override
    public void acknowledgeAndForward(EventDatagram event, boolean withSourceData, AcknowledgeAction action, String recipientId, long timeToLive) throws FabricEventSourceException {
    }

    @Override
    public void acknowledgeAndForward(EventDatagram event, AcknowledgementEvent acknowledgementEvent, boolean withSourceData, AcknowledgeAction action, String recipientId, long timeToLive) throws FabricEventSourceException {
    }

    @Override
    public EventConsumer createEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricEventDispatcherException {
        return this.createEventConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, null);
    }

    FabricEventDirectConsumerImpl createEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        return this.doCreateEventConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, false, false, groupLink);
    }

    FabricEventDirectConsumerImpl createSystemEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricEventDispatcherException {
        return this.createSystemEventConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, false);
    }

    EventConsumer createHiddenEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector) throws FabricEventDispatcherException {
        return this.createSystemEventConsumer(consumerName, listener, eventFilter, eventSelector, EventScope.OBSERVABLE, true, true);
    }

    private FabricEventDirectConsumerImpl createSystemEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, boolean isHidden) throws FabricEventDispatcherException {
        return this.doCreateEventConsumer(this.getSystemName(consumerName), listener, eventFilter, eventSelector, eventScope, noLocal, true, isHidden, null);
    }

    private synchronized FabricEventDirectConsumerImpl doCreateEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, boolean isSystem, boolean isHidden, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        CompositeFilter filter = this.createCompositeFilter(eventFilter);
        eventScope = this.checkConsumerParameters(consumerName, filter, eventScope, noLocal, isSystem, groupLink);
        FabricEventDirectConsumerImpl consumer = new FabricEventDirectConsumerImpl(consumerName, filter, eventSelector, listener, eventScope, noLocal, this, groupLink);
        try {
            if (!noLocal) {
                (groupLink != null ? groupLink.localDispatcher : this.localDispatcher).addDirectConsumer(consumer.underlyingConsumer, eventScope, isSystem);
            }
            if (eventScope != EventScope.LOCAL) {
                this.exchange.addDirectConsumer(consumer, this.component.getFabricAddress(), eventScope, noLocal, isSystem, isHidden, groupLink);
            }
            (groupLink != null ? groupLink : this).addDirectConsumer(consumerName, consumer);
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Creation of consumer '" + consumerName + "' failed.", exception);
        }
        this.logDebug("Direct consumer '" + consumer.underlyingConsumer.getName() + "' created.");
        return consumer;
    }

    @Override
    public synchronized void dropEventConsumer(String consumerName) throws FabricEventDispatcherException {
        this.dropEventConsumer(consumerName, null);
    }

    synchronized AbstractFabricConsumer dropEventConsumer(String consumerName, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        this.checkConsumerName(consumerName, false);
        FabricEventDirectConsumerImpl droppedConsumer = (groupLink != null ? groupLink : this).removeDirectConsumer(consumerName);
        if (droppedConsumer != null) {
            this.dropConsumer(droppedConsumer, groupLink);
        }
        return droppedConsumer;
    }

    @Override
    public EventAsyncConsumer createEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricEventDispatcherException {
        return this.createEventAsyncConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, null);
    }

    FabricEventAsyncConsumerImpl createEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        return this.doCreateEventAsyncConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, false, false, groupLink);
    }

    FabricEventAsyncConsumerImpl createSystemEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricEventDispatcherException {
        return this.createSystemEventAsyncConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, false);
    }

    EventAsyncConsumer createHiddenEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector) throws FabricEventDispatcherException {
        return this.createSystemEventAsyncConsumer(consumerName, listener, eventFilter, eventSelector, EventScope.OBSERVABLE, true, true);
    }

    private FabricEventAsyncConsumerImpl createSystemEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, boolean isHidden) throws FabricEventDispatcherException {
        return this.doCreateEventAsyncConsumer(this.getSystemName(consumerName), listener, eventFilter, eventSelector, eventScope, noLocal, true, isHidden, null);
    }

    private synchronized FabricEventAsyncConsumerImpl doCreateEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, boolean isSystem, boolean isHidden, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        CompositeFilter filter = this.createCompositeFilter(eventFilter);
        eventScope = this.checkConsumerParameters(consumerName, filter, eventScope, noLocal, isSystem, groupLink);
        FabricEventAsyncConsumerImpl consumer = new FabricEventAsyncConsumerImpl(consumerName, filter, eventSelector, listener, eventScope, noLocal, this, groupLink);
        try {
            if (!noLocal) {
                (groupLink != null ? groupLink.localDispatcher : this.localDispatcher).addAsyncConsumer(consumer.underlyingConsumer, eventScope, isSystem);
            }
            if (eventScope != EventScope.LOCAL) {
                this.exchange.addAsyncConsumer(consumer, this.component.getFabricAddress(), eventScope, noLocal, isSystem, isHidden, groupLink);
            }
            (groupLink != null ? groupLink : this).addAsyncConsumer(consumerName, consumer);
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Creation of async consumer '" + consumerName + "' failed.", exception);
        }
        this.logDebug("Async consumer '" + consumer.underlyingConsumer.getName() + "' created.");
        return consumer;
    }

    @Override
    public synchronized void dropEventAsyncConsumer(String consumerName) throws FabricEventDispatcherException {
        this.dropEventAsyncConsumer(consumerName, 30000L, null);
    }

    synchronized AbstractFabricConsumer dropEventAsyncConsumer(String consumerName, long timeout, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        this.checkConsumerName(consumerName, false);
        FabricEventAsyncConsumerImpl droppedConsumer = (groupLink != null ? groupLink : this).removeAsyncConsumer(consumerName);
        if (droppedConsumer != null) {
            this.dropConsumer(droppedConsumer, timeout, groupLink);
        }
        return droppedConsumer;
    }

    @Override
    public EventRequestConsumer createRequestConsumer(String consumerName, FabricRequestListener listener, EventScope eventScope) throws FabricEventDispatcherException {
        return this.doCreateRequestConsumer(consumerName, listener, eventScope, false, false);
    }

    FabricEventRequestConsumerImpl createSystemRequestConsumer(String consumerName, FabricRequestListener listener, EventScope eventScope) throws FabricEventDispatcherException {
        return this.createSystemRequestConsumer(consumerName, listener, eventScope, false);
    }

    FabricEventRequestConsumerImpl createSystemRequestConsumer(String consumerName, FabricRequestListener listener, EventScope eventScope, boolean forAccessor) throws FabricEventDispatcherException {
        return this.doCreateRequestConsumer(this.getSystemName(consumerName), listener, eventScope, true, forAccessor);
    }

    synchronized FabricEventRequestConsumerImpl doCreateRequestConsumer(String consumerName, FabricRequestListener listener, EventScope eventScope, boolean isSystem, boolean isAccessorSession) throws FabricEventDispatcherException {
        if ((eventScope = this.checkEventScopeAndExchange(eventScope)) == EventScope.LOCAL) {
            throw new FabricEventDispatcherException(6017, "Request consumer cannot have 'LOCAL' event scope.");
        }
        this.checkConsumerName(consumerName, isSystem, null);
        FabricEventRequestConsumerImpl consumer = new FabricEventRequestConsumerImpl(consumerName, listener, eventScope, this);
        try {
            this.exchange.addRequestConsumer(consumer, this.component.getFabricAddress(), eventScope, isAccessorSession);
            this.addRequestConsumer(consumerName, consumer);
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Creation of request consumer '" + consumerName + "' failed.", exception);
        }
        this.logDebug("Request consumer '" + consumer.underlyingConsumer.getName() + "' created.");
        return consumer;
    }

    @Override
    public synchronized void dropRequestConsumer(String consumerName) throws FabricEventDispatcherException {
        this.checkConsumerName(consumerName, false);
        FabricEventRequestConsumerImpl droppedConsumer = this.removeRequestConsumer(consumerName);
        if (droppedConsumer != null) {
            this.dropConsumer(droppedConsumer);
        }
    }

    @Override
    public void dropConsumer(String consumerName) throws FabricEventDispatcherException {
        this.doDropConsumer(consumerName, 30000L, false);
    }

    AbstractFabricConsumer dropSystemConsumer(String consumerName) {
        try {
            return this.doDropConsumer(this.getSystemName(consumerName), 30000L, true);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            return null;
        }
    }

    synchronized AbstractFabricConsumer doDropConsumer(String consumerName, long timeout, boolean isSystem) throws FabricEventDispatcherException {
        this.checkConsumerName(consumerName, isSystem);
        AbstractFabricConsumer droppedConsumer = this.removeDirectConsumer(consumerName);
        if (droppedConsumer != null) {
            this.dropConsumer((FabricEventDirectConsumerImpl)droppedConsumer);
        } else {
            droppedConsumer = this.removeAsyncConsumer(consumerName);
            if (droppedConsumer != null) {
                this.dropConsumer((FabricEventAsyncConsumerImpl)droppedConsumer, timeout);
            } else {
                droppedConsumer = this.removeRequestConsumer(consumerName);
                if (droppedConsumer != null) {
                    this.dropConsumer((FabricEventRequestConsumerImpl)droppedConsumer);
                }
            }
        }
        return droppedConsumer;
    }

    @Override
    public EventReceiver createEventReceiver(String receiverName, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricEventDispatcherException {
        return this.createEventReceiver(receiverName, eventFilter, eventSelector, eventScope, noLocal, null);
    }

    FabricEventReceiverImpl createEventReceiver(String receiverName, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        return this.doCreateEventReceiver(receiverName, eventFilter, eventSelector, eventScope, noLocal, false, groupLink);
    }

    FabricEventReceiverImpl createSystemEventReceiver(String receiverName, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricEventDispatcherException {
        return this.doCreateEventReceiver(receiverName, eventFilter, eventSelector, eventScope, noLocal, true, null);
    }

    private synchronized FabricEventReceiverImpl doCreateEventReceiver(String receiverName, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, boolean isSystem, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        CompositeFilter filter = this.createCompositeFilter(eventFilter);
        eventScope = this.checkConsumerParameters(receiverName, filter, eventScope, noLocal, isSystem, groupLink);
        FabricEventReceiverImpl receiver = new FabricEventReceiverImpl(receiverName, filter, eventSelector, eventScope, noLocal, this, groupLink);
        try {
            if (!noLocal) {
                (groupLink != null ? groupLink.localDispatcher : this.localDispatcher).addAsyncConsumer(receiver.underlyingConsumer, eventScope, isSystem);
            }
            if (eventScope != EventScope.LOCAL) {
                this.exchange.addReceiver(receiver, this.component.getFabricAddress(), eventScope, noLocal, isSystem, groupLink);
            }
            (groupLink != null ? groupLink : this).addReceiver(receiverName, receiver);
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Creation of receiver '" + receiverName + "' failed.", exception);
        }
        this.logDebug("Receiver '" + receiver.underlyingConsumer.getName() + "' created.");
        return receiver;
    }

    @Override
    public void dropEventReceiver(String receiverName) throws FabricEventDispatcherException {
        this.dropEventReceiver(receiverName, null);
    }

    AbstractFabricConsumer dropEventReceiver(String receiverName, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        return this.doDropEventReceiver(receiverName, false, groupLink);
    }

    AbstractFabricConsumer dropSystemEventReceiver(String receiverName) {
        try {
            return this.doDropEventReceiver(this.getSystemName(receiverName), true, null);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            return null;
        }
    }

    synchronized AbstractFabricConsumer doDropEventReceiver(String receiverName, boolean isSystem, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        this.checkConsumerName(receiverName, isSystem);
        FabricEventReceiverImpl droppedConsumer = (groupLink != null ? groupLink : this).removeReceiver(receiverName);
        if (droppedConsumer != null) {
            this.dropReceiver(droppedConsumer, groupLink);
        }
        return droppedConsumer;
    }

    @Override
    public void addEventCache(String eventFilter, int maxSize, CacheThresholdAction thresholdAction) throws FabricEventDispatcherException {
        this.checkExchange();
        Filter filter = this.createSimpleFilter(eventFilter);
        FabricEventDispatcherImpl.checkEventId(filter.toString(), RESERVED_EVENT_FILTER_PREFIXES);
        try {
            this.exchange.addEventCache(filter, maxSize, thresholdAction, this.component.getFabricAddress());
            this.logDebug("Event cache '" + eventFilter + "' added.");
        }
        catch (ExchangeException exception) {
            throw new FabricEventDispatcherException(exception.getErrorCode(), (Throwable)exception);
        }
        catch (EventDispatcherException exception) {
            throw new FabricEventDispatcherException(6007, (Throwable)exception);
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Adding event cache with filter '" + eventFilter + "' failed.", exception);
        }
    }

    @Override
    public void removeEventCache(String eventFilter) {
        if (this.isExchangeReady()) {
            this.exchange.removeEventCache(eventFilter);
            this.logDebug("Event cache '" + eventFilter + "' removed.");
        }
    }

    @Override
    public EventCache getEventCache(String eventFilter) {
        return this.isExchangeReady() ? this.exchange.getEventCache(eventFilter) : null;
    }

    @Override
    public void bindProducerFor(String eventId) throws FabricEventDispatcherException {
        this.doBindProducerFor(eventId, false);
    }

    void bindProducerForSystem(String eventId) throws FabricEventDispatcherException {
        this.doBindProducerFor(eventId, true);
    }

    private synchronized void doBindProducerFor(String eventId, boolean isSystem) throws FabricEventDispatcherException {
        if (!isSystem && (ReservedSubjects.isReserved(eventId) || SystemEvents.isSystem(eventId) || SystemAdvisories.isSystem(eventId))) {
            throw new FabricEventDispatcherException(6047, "Event id [" + eventId + "] reserved for system purposes.");
        }
        this.checkEventIdUniqueness(eventId);
        this.checkPrototypeExistence(eventId);
        if (this.isExchangeReady() && this.componentReference != null) {
            this.exchange.changeComponent(this.componentReference, ModeratorAdvisoryType.PRODUCER_BOUND, eventId);
        } else {
            this.boundEventIds.add(eventId);
        }
    }

    void checkEventIdUniqueness(String eventId) throws FabricEventDispatcherException {
        if (this.boundEventIds.contains(eventId)) {
            throw new FabricEventDispatcherException(6063, "Event id [" + eventId + "] already bound.");
        }
    }

    @Override
    public synchronized void unbindProducerFor(String eventId) {
        if (this.boundEventIds.remove(eventId) && this.isExchangeReady() && this.componentReference != null) {
            this.doUnbindProducerFor(eventId);
        }
    }

    private synchronized void unbindProducers() {
        if (this.isExchangeReady() && this.componentReference != null) {
            for (String eventId : new ArrayList<String>(this.boundEventIds)) {
                this.doUnbindProducerFor(eventId);
            }
        }
    }

    private void doUnbindProducerFor(String eventId) {
        this.exchange.changeComponent(this.componentReference, ModeratorAdvisoryType.PRODUCER_UNBOUND, eventId);
    }

    @Override
    public boolean hasBoundEventIds() {
        return !this.boundEventIds.isEmpty();
    }

    @Override
    public boolean isBoundEventId(String eventId) {
        return this.boundEventIds.contains(eventId);
    }

    @Override
    public List<String> listBoundEventIds() {
        return new ArrayList<String>(this.boundEventIds);
    }

    @Override
    public ExceptionStrategy getExceptionStrategy() {
        return this.exceptionStrategy;
    }

    @Override
    public synchronized void setExceptionStrategy(ExceptionStrategy exceptionStrategy) {
        if (this.exceptionStrategy != exceptionStrategy) {
            this.exceptionStrategy = exceptionStrategy;
            if (this.isExchangeReady() && this.componentReference != null) {
                this.exchange.changeComponent(this.componentReference, ModeratorAdvisoryType.COMPONENT_CHANGED, (Object)exceptionStrategy);
            }
        }
    }

    void setExchange(AbstractExchange exchange) {
        this.exchange = exchange;
    }

    synchronized void setExchange(AbstractExchange exchange, ComponentReferenceImpl componentReference) {
        this.exchange = exchange;
        this.componentReference = componentReference;
        componentReference.setBoundEventIds(this.boundEventIds);
    }

    synchronized void destroy(long timeout) {
        this.unbindProducers();
        this.destroyConsumers(timeout);
        this.localDispatcher.stop();
        this.localDispatcher = null;
        this.exchange = null;
        this.componentReference = null;
    }

    void raiseActionableEvent(ImmutableEventDatagram event, long timeToLive) throws FabricEventSourceException, FabricEventException {
        try {
            FabricEventSourceFactoryImpl.coalesce(event, this.component);
            this.localDispatcher.raiseEvent(event);
        }
        catch (EventDispatcherException exception) {
            throw new FabricEventSourceException(6016, "Raising of actionable event [" + event.getEventId() + "] failed.", exception);
        }
        catch (EventException exception) {
            throw (FabricEventException)exception.getCause();
        }
    }

    AcknowledgementEvent raiseActionableRequest(EventDatagram request, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws FabricEventSourceException, FabricEventException {
        try {
            return (AcknowledgementEvent)this.localDispatcher.raiseRequest(request, distributionStrategy, matchStrategy, timeout);
        }
        catch (EventException exception) {
            throw (FabricEventException)exception.getCause();
        }
        catch (Exception exception) {
            throw new FabricEventSourceException(6016, "Raising of actionable request [" + request.getEventId() + "] failed.", exception);
        }
    }

    synchronized FabricEventDirectConsumerImpl createActionableConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector) throws FabricEventDispatcherException {
        CompositeFilter filter = this.createCompositeFilter(eventFilter);
        this.checkConsumerName(consumerName);
        this.checkActionableEventFilter(filter);
        FabricEventDirectConsumerImpl result = new FabricEventDirectConsumerImpl(consumerName, filter, eventSelector, listener, EventScope.LOCAL, false, this, null);
        this.localDispatcher.addDirectConsumer(result.underlyingConsumer, true);
        this.addDirectConsumer(consumerName, result);
        return result;
    }

    synchronized FabricEventAsyncConsumerImpl createActionableAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector) throws FabricEventDispatcherException {
        CompositeFilter filter = this.createCompositeFilter(eventFilter);
        this.checkConsumerName(consumerName);
        this.checkActionableEventFilter(filter);
        FabricEventAsyncConsumerImpl result = new FabricEventAsyncConsumerImpl(consumerName, filter, eventSelector, listener, EventScope.LOCAL, false, this, null);
        this.localDispatcher.addAsyncConsumer(result.underlyingConsumer, true);
        this.addAsyncConsumer(consumerName, result);
        return result;
    }

    String makeComponentFullName() {
        return ModeratorUtils.makeComponentFullName(this.exchange != null ? this.exchange.getNode().getName() : null, this.component);
    }

    String makeConsumerFullName(String consumerName) {
        return ModeratorUtils.makeConsumerFullName(this.exchange != null ? this.exchange.getNode().getName() : null, this.component, consumerName);
    }

    @Override
    void dropConsumer(FabricEventDirectConsumerImpl consumer) {
        this.dropConsumer(consumer, null);
    }

    synchronized void dropConsumer(FabricEventDirectConsumerImpl consumer, FabricGroupLinkImpl groupLink) {
        if (consumer != null) {
            (groupLink != null ? groupLink.localDispatcher : this.localDispatcher).dropConsumer(consumer.underlyingConsumer, consumer.eventScope);
            if (consumer.getEventScope() != EventScope.LOCAL && this.isExchangeReady()) {
                this.exchange.removeDirectConsumer(consumer, groupLink);
            }
            this.component.onConsumerRemoved(consumer);
            (groupLink != null ? groupLink : this).logDebug("Direct consumer '" + consumer.underlyingConsumer.getName() + "' removed.");
        }
    }

    @Override
    void dropConsumer(FabricEventAsyncConsumerImpl consumer, long timeout) {
        this.dropConsumer(consumer, timeout, null);
    }

    synchronized void dropConsumer(FabricEventAsyncConsumerImpl consumer, long timeout, FabricGroupLinkImpl groupLink) {
        if (consumer != null) {
            (groupLink != null ? groupLink.localDispatcher : this.localDispatcher).dropAsyncConsumer(consumer.underlyingConsumer, consumer.eventScope);
            if (consumer.getEventScope() != EventScope.LOCAL && this.isExchangeReady()) {
                this.exchange.removeAsyncConsumer(consumer, groupLink);
            }
            consumer.underlyingConsumer.close();
            consumer.underlyingConsumer.stopDelayed(timeout);
            this.component.onConsumerRemoved(consumer);
            (groupLink != null ? groupLink : this).logDebug("Async consumer '" + consumer.underlyingConsumer.getName() + "' removed.");
        }
    }

    @Override
    synchronized void dropConsumer(FabricEventRequestConsumerImpl consumer) {
        if (consumer != null) {
            this.localDispatcher.dropRequestConsumer(consumer.underlyingConsumer.getName());
            if (this.isExchangeReady()) {
                this.exchange.removeRequestConsumer(consumer);
            }
            this.logDebug("Request consumer '" + consumer.underlyingConsumer.getName() + "' removed.");
        }
    }

    @Override
    void dropReceiver(FabricEventReceiverImpl receiver) {
        this.dropReceiver(receiver, null);
    }

    synchronized void dropReceiver(FabricEventReceiverImpl receiver, FabricGroupLinkImpl groupLink) {
        if (receiver != null) {
            (groupLink != null ? groupLink.localDispatcher : this.localDispatcher).dropAsyncConsumer(receiver.underlyingConsumer.getName());
            if (receiver.getEventScope() != EventScope.LOCAL && this.isExchangeReady()) {
                this.exchange.removeReceiver(receiver, groupLink);
            }
            receiver.underlyingConsumer.close();
            receiver.underlyingConsumer.stop();
            this.component.onConsumerRemoved(receiver);
            (groupLink != null ? groupLink : this).logDebug("Receiver '" + receiver.underlyingConsumer.getName() + "' removed.");
        }
    }

    private EventScope prepareEvent(ImmutableEventDatagram event, EventScope eventScope, boolean isSystem) throws IncompatibleScopeException, FabricEventSourceException, FabricUnboundEventException {
        eventScope = this.checkEventScope(eventScope);
        this.checkBindingAndCoalesce(event, isSystem);
        return eventScope;
    }

    private EventScope prepareRequest(RequestConsumerReferenceImpl consumer, ImmutableEventDatagram request, boolean isSystem) throws IncompatibleScopeException, FabricEventSourceException, FabricUnboundEventException {
        EventScope componentScope = this.component.getEventScope();
        if (componentScope == EventScope.LOCAL) {
            throw new FabricEventSourceException(6017, "Component with LOCAL event scope cannot raise direct request.");
        }
        if (componentScope == EventScope.OBSERVABLE) {
            if (!this.exchange.isLocal(consumer.getAddress())) {
                throw new IncompatibleScopeException("Component with OBSERVABLE event scope cannot raise direct request to remote node.");
            }
        } else if (componentScope == EventScope.CLUSTER && !this.exchange.isLocal(consumer.getAddress()) && this.exchange.isClustered() && !this.exchange.matchesCluster(consumer)) {
            throw new IncompatibleScopeException("Component with CLUSTER event scope cannot raise direct request to remote node of another cluster.");
        }
        this.checkBindingAndCoalesce(request, isSystem);
        return componentScope;
    }

    private void checkBindingAndCoalesce(ImmutableEventDatagram event, boolean isSystem) throws FabricUnboundEventException, FabricEventSourceException {
        if (!isSystem) {
            this.checkEventBinding(event);
        }
        FabricEventSourceFactoryImpl.coalesce(event, this.component);
    }

    private EventScope prepareRequest(EventDatagram request, EventScope eventScope, boolean isSystem) throws IncompatibleScopeException, FabricUnboundEventException, FabricEventDispatcherException {
        eventScope = this.checkEventScope(eventScope);
        if (!isSystem) {
            this.checkEventBinding(request);
            String replyTo = request.getReplyTo();
            if (replyTo != null && (ReservedSubjects.isReserved(replyTo) || SystemEvents.isSystem(replyTo) || SystemAdvisories.isSystem(replyTo))) {
                throw new FabricEventDispatcherException(6047, "ReplyTo event id [" + replyTo + "] reserved for system purposes.");
            }
        }
        return eventScope;
    }

    private void checkEventBinding(ImmutableEventDatagram event) throws FabricUnboundEventException {
        if (!this.boundEventIds.contains(event.getEventId())) {
            throw InternalUtils.createProtectedObject(FabricUnboundEventException.class, new Class[]{String.class, String.class}, this.componentReference != null ? this.componentReference.getName() : this.makeComponentFullName(), event.getEventId());
        }
    }

    private EventScope checkConsumerParameters(String name, CompositeFilter filter, EventScope eventScope, boolean noLocal, boolean isSystem, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        eventScope = this.checkConsumerEventScope(eventScope, noLocal, groupLink);
        this.checkConsumerName(name, isSystem, groupLink);
        this.checkEventFilter(filter, isSystem);
        return eventScope;
    }

    private EventScope checkConsumerEventScope(EventScope eventScope, boolean noLocal, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        if ((eventScope = this.checkEventScopeAndExchange(eventScope)) == EventScope.LOCAL && noLocal) {
            throw new FabricEventDispatcherException(6045, "Event scope 'LOCAL' and 'noLocal=true' are incompatible.");
        }
        return eventScope;
    }

    private void checkConsumerName(String name) throws FabricEventDispatcherException {
        this.checkConsumerName(name, false, null);
    }

    private void checkConsumerName(String name, boolean isSystem, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        this.checkConsumerName(name, isSystem);
        if ((groupLink != null ? groupLink : this).existsConsumer(name)) {
            throw new FabricEventDispatcherException(6055, "Consumer '" + name + "' already exists.");
        }
    }

    private void checkConsumerName(String name, boolean isSystem) throws FabricEventDispatcherException {
        if (!StringUtils.validateConsumerName(name)) {
            throw new FabricEventDispatcherException(6054, "Invalid consumer name: '" + name + "'.");
        }
        if (!isSystem && ReservedNames.isReserved(name)) {
            throw new FabricEventDispatcherException(6047, "Illegal use of reserved prefix '" + name.substring(0, name.indexOf("$") + 1) + "'.");
        }
    }

    private String getSystemName(String name) {
        return InternalUtils.getSystemName(name);
    }

    private CompositeFilter createCompositeFilter(String eventFilter) throws FabricEventDispatcherException {
        try {
            return new CompositeFilter(eventFilter);
        }
        catch (FilterFormatException exception) {
            throw new FabricEventDispatcherException(6057, exception.getMessage());
        }
    }

    private Filter createSimpleFilter(String eventFilter) throws FabricEventDispatcherException {
        try {
            return new Filter(eventFilter);
        }
        catch (FilterFormatException exception) {
            throw new FabricEventDispatcherException(6057, exception.getMessage());
        }
    }

    private void checkEventFilter(CompositeFilter compositeFilter, boolean isSystem) throws FabricEventDispatcherException {
        for (Filter filter : compositeFilter.getFilters()) {
            if (!isSystem) {
                FabricEventDispatcherImpl.checkEventId(filter.toString(), RESERVED_EVENT_FILTER_PREFIXES);
            }
            if (filter.hasMetacharacters() || isSystem) continue;
            this.checkPrototypeExistence(filter.toString());
        }
    }

    private void checkActionableEventFilter(CompositeFilter compositeFilter) throws FabricEventDispatcherException {
        if (compositeFilter.getFilters().size() != 1) {
            throw new FabricEventDispatcherException(6057, "Actionable event id cannot be composite.");
        }
        String eventId = compositeFilter.getFilters().get(0).toString();
        if (!eventId.startsWith("e.action.")) {
            FabricEventDispatcherImpl.checkEventId(eventId, RESERVED_EVENT_FILTER_PREFIXES);
            this.checkPrototypeExistence(eventId);
        }
    }

    private static void checkEventId(String eventId, List<String> reservedPrefixes) throws FabricEventDispatcherException {
        for (String reservedPrefix : reservedPrefixes) {
            if (!eventId.startsWith(reservedPrefix)) continue;
            throw new FabricEventDispatcherException(6047, "Illegal use of reserved prefix '" + reservedPrefix + "'.");
        }
    }

    private void checkPrototypeExistence(String eventId) throws FabricEventDispatcherException {
        if (eventId.startsWith("e.chunk.")) {
            if (!this.prototypeCache.existsEventId(ChunkEvent.getStreamEventId(eventId))) {
                throw new FabricEventDispatcherException(6053, "StreamEvent prototype [" + ChunkEvent.getStreamEventId(eventId) + "] does not exist.");
            }
        } else if (!this.prototypeCache.existsEventId(eventId)) {
            throw new FabricEventDispatcherException(6053, "Event prototype [" + eventId + "] does not exist.");
        }
    }

    @Override
    public DomainConstraint createDomainConstraint(String domainName, String description, Set<Object> values) throws FabricEventDispatcherException {
        this.checkExchange();
        try {
            return this.exchange.createDomainConstraint(domainName, this.component.getFabricAddress(), description, values);
        }
        catch (EventDispatcherException exception) {
            throw new FabricEventDispatcherException(6059, "Domain '" + domainName + "' already exists.");
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Creation of domain '" + domainName + "' failed.", exception);
        }
    }

    @Override
    public void dropDomainConstraint(String domainName) throws FabricEventDispatcherException {
        this.checkExchange();
        try {
            this.exchange.dropDomainConstraint(domainName);
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Dropping domain '" + domainName + "' failed.", exception);
        }
    }

    @Override
    public DomainConstraint getDomainConstraint(String domainName) throws FabricEventDispatcherException {
        this.checkExchange();
        return this.exchange.getDomainConstraint(domainName);
    }

    @Override
    public void setDomainConstraint(DomainConstraint domain) throws FabricEventDispatcherException {
        this.checkExchange();
        try {
            FabricDomainConstraintImpl domainImpl = (FabricDomainConstraintImpl)domain;
            this.exchange.setDomainConstraint(domainImpl.getUpdater());
            domainImpl.getUpdater().reset();
        }
        catch (EventDispatcherException exception) {
            throw new FabricEventDispatcherException(6060, "Domain '" + domain.getName() + "' does not exist.");
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Update of domain '" + domain.getName() + "' failed.", exception);
        }
    }

    @Override
    public RangeConstraint createRangeConstraint(String rangeName, String description, Object minValue, Object maxValue) throws FabricEventDispatcherException {
        this.checkExchange();
        try {
            return this.exchange.createRangeConstraint(rangeName, this.component.getFabricAddress(), description, minValue, maxValue);
        }
        catch (EventDispatcherException exception) {
            throw new FabricEventDispatcherException(6061, "Range '" + rangeName + "' already exists.");
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Creation of range '" + rangeName + "' failed.", exception);
        }
    }

    @Override
    public void dropRangeConstraint(String rangeName) throws FabricEventDispatcherException {
        this.checkExchange();
        try {
            this.exchange.dropRangeConstraint(rangeName);
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Dropping range '" + rangeName + "' failed.", exception);
        }
    }

    @Override
    public RangeConstraint getRangeConstraint(String rangeName) throws FabricEventDispatcherException {
        this.checkExchange();
        return this.exchange.getRangeConstraint(rangeName);
    }

    @Override
    public void setRangeConstraint(RangeConstraint range) throws FabricEventDispatcherException {
        this.checkExchange();
        try {
            FabricRangeConstraintImpl rangeImpl = (FabricRangeConstraintImpl)range;
            this.exchange.setRangeConstraint(rangeImpl.getUpdater());
            rangeImpl.getUpdater().reset();
        }
        catch (EventDispatcherException exception) {
            throw new FabricEventDispatcherException(6062, "Range '" + range.getName() + "' does not exist.");
        }
        catch (Exception exception) {
            throw new FabricEventDispatcherException(6011, "Update of range '" + range.getName() + "' failed.", exception);
        }
    }

    private EventScope checkEventScopeAndExchange(EventScope eventScope) throws FabricEventDispatcherException {
        try {
            eventScope = this.checkEventScope(eventScope);
            this.checkExchange(eventScope);
            return eventScope;
        }
        catch (IncompatibleScopeException exception) {
            throw new FabricEventDispatcherException(6044, exception.getMessage());
        }
    }

    private EventScope checkEventScope(EventScope eventScope) throws IncompatibleScopeException {
        if (eventScope != EventScope.INHERITED) {
            if (this.isEventScopeIncompatible(eventScope)) {
                throw new IncompatibleScopeException(eventScope);
            }
            if (!(eventScope != EventScope.CLUSTER || this.exchange != null && this.exchange.isClustered())) {
                throw new IncompatibleScopeException("Event scope CLUSTER is not allowed.");
            }
            return eventScope;
        }
        return this.component.getEventScope();
    }

    private void checkDataScope(EventScope eventScope) throws IncompatibleScopeException {
        if (eventScope == EventScope.CLUSTER) {
            throw new IncompatibleScopeException("Event scope CLUSTER is not supported for Data Constraints.");
        }
        if (this.isDataScopeIncompatible(eventScope)) {
            throw new IncompatibleScopeException(eventScope);
        }
    }

    private void checkExchange(EventScope eventScope) throws FabricEventDispatcherException {
        if (eventScope != EventScope.LOCAL) {
            this.checkExchange();
        }
    }

    private void checkExchange() throws FabricEventDispatcherException {
        if (!this.isExchangeReady()) {
            throw new FabricEventDispatcherException(6012, "Exchange is not ready.");
        }
    }

    private boolean isDataScopeIncompatible(EventScope eventScope) {
        return this.isEventScopeIncompatible(eventScope);
    }

    private boolean isEventScopeIncompatible(EventScope eventScope) {
        return eventScope.ordinal() > this.component.getEventScope().ordinal();
    }

    boolean isExchangeReady() {
        return this.exchange != null && this.exchange.isStarted();
    }

    AbstractExchange getExchange() {
        return this.exchange;
    }

    SelectorExternalDataSource getSelectorDataSource() {
        return new SelectorExternalDataSource(){

            @Override
            public SelectorInValues getInValues() {
                return FabricEventDispatcherImpl.this.exchange != null ? FabricEventDispatcherImpl.this.exchange.getDataConstraintStore() : null;
            }

            @Override
            public Moderator getModerator() {
                return FabricEventDispatcherImpl.this.exchange != null ? FabricEventDispatcherImpl.this.exchange.getModerator() : null;
            }

            @Override
            public Metaset getMetaset() {
                return FabricEventDispatcherImpl.this.component.getMetaset();
            }
        };
    }

    class LocalEventDispatcher
    extends ExtendedEventDispatcher {
        EventDispatcher.EventDispatcherFilterMap localConsumers = new EventDispatcher.EventDispatcherFilterMap();

        LocalEventDispatcher() {
        }

        void addDirectConsumer(EventConsumerImpl consumer, EventScope eventScope, boolean isSystem) {
            this.putLocalConsumer(consumer, eventScope);
            super.addDirectConsumer(consumer, isSystem);
        }

        void addAsyncConsumer(EventAsyncConsumerImpl consumer, EventScope eventScope, boolean isSystem) {
            this.putLocalConsumer(consumer, eventScope);
            super.addAsyncConsumer(consumer, isSystem);
        }

        private void putLocalConsumer(EventConsumerImpl consumer, EventScope eventScope) {
            if (eventScope == EventScope.LOCAL) {
                this.localConsumers.putConsumer(consumer);
            }
        }

        void dropConsumer(EventConsumerImpl consumer, EventScope eventScope) {
            this.removeLocalConsumer(consumer, eventScope);
            super.dropConsumer(consumer.getName());
        }

        void dropAsyncConsumer(EventConsumerImpl consumer, EventScope eventScope) {
            this.removeLocalConsumer(consumer, eventScope);
            super.dropAsyncConsumer(consumer.getName());
        }

        private void removeLocalConsumer(EventConsumerImpl consumer, EventScope eventScope) {
            if (eventScope == EventScope.LOCAL) {
                this.localConsumers.removeConsumer(consumer);
            }
        }

        @Override
        protected void addReplyConsumer(EventDispatcher.ReplyConsumer consumer) {
            this.localConsumers.putReplyConsumer(consumer);
            super.addReplyConsumer(consumer);
        }

        @Override
        protected void removeReplyConsumer(EventDispatcher.ReplyConsumer consumer) {
            this.localConsumers.removeReplyConsumer(consumer);
            super.removeReplyConsumer(consumer);
        }

        void addReplyConsumerNonLocal(ExtendedEventDispatcher.ReplyConsumer consumer) {
            super.addReplyConsumer(consumer);
        }

        void removeReplyConsumerNonLocal(ExtendedEventDispatcher.ReplyConsumer consumer) {
            super.removeReplyConsumer(consumer);
        }

        void raiseEvent(ImmutableEventDatagram event, EventScope eventScope) throws EventDispatcherException, EventException {
            this.checkState();
            if (eventScope == EventScope.LOCAL) {
                this.deliverEvent(event);
            } else {
                this.doDeliverEvent(event, this.localConsumers.get(event.getEventId()));
            }
        }

        @Override
        public void raiseEvent(ImmutableEventDatagram event) throws EventDispatcherException, EventException {
            this.checkState();
            this.deliverEvent(event);
        }

        @Override
        protected void raiseRequest(EventDatagram request, RequestDistributionStrategy distributionStrategy) throws EventDispatcherException, EventException {
            try {
                FabricEventSourceFactoryImpl.coalesce((ImmutableEventDatagram)request, FabricEventDispatcherImpl.this.component);
            }
            catch (FabricEventSourceException exception) {
                throw new EventDispatcherException(exception);
            }
            super.raiseRequest(request, distributionStrategy);
        }

        @Override
        protected void raiseLocalException(ExceptionEventDatagram event) throws FabricEventSourceException {
            FabricEventSourceFactoryImpl.coalesce((ImmutableEventDatagram)event, FabricEventDispatcherImpl.this.component);
            try {
                this.raiseEvent(event);
            }
            catch (Exception exception) {
                throw new FabricEventSourceException(6016, "Raising of local exception '" + event.getEventId() + "' failed.", exception);
            }
        }

        @Override
        protected EventDispatcher.EventProcessor createEventProcessor() {
            return new LocalEventProcessor();
        }

        @Override
        protected EventDispatcher.EventProcessor createEventProcessor(String reservedPrefix) {
            return new LocalEventProcessorWithPrefix(reservedPrefix);
        }

        protected class LocalEventProcessor
        extends EventDispatcher.EventProcessor {
            protected LocalEventProcessor() {
                super(LocalEventDispatcher.this);
            }

            @Override
            protected ExceptionStrategy getExceptionStrategy(ImmutableEventDatagram event) {
                return FabricEventDispatcherImpl.this.exceptionStrategy;
            }
        }

        protected class LocalEventProcessorWithPrefix
        extends ExtendedEventDispatcher.EventProcessorWithPrefix {
            protected LocalEventProcessorWithPrefix(String reservedPrefix) {
                super(LocalEventDispatcher.this, reservedPrefix);
            }

            @Override
            protected ExceptionStrategy getExceptionStrategy(ImmutableEventDatagram event) {
                return FabricEventDispatcherImpl.this.exceptionStrategy;
            }
        }
    }

    private class IncompatibleScopeException
    extends Exception {
        IncompatibleScopeException(EventScope eventScope) {
            this(eventScope, fabricEventDispatcherImpl.component.getEventScope(), "component");
        }

        IncompatibleScopeException(EventScope eventScope, EventScope destinationEventScope, String destinationType) {
            super("Event scope " + String.valueOf((Object)eventScope) + " and " + destinationType + " event scope " + String.valueOf((Object)destinationEventScope) + " incompatible.");
        }

        IncompatibleScopeException(String errorMessage) {
            super(errorMessage);
        }
    }
}

