/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.dispatcher.EventListener;
import com.streamscape.lib.evqueue.DeliveryMode;
import com.streamscape.lib.evqueue.IllegalQueueStateException;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventSelectorFormatException;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.IllegalConsumerStateException;
import com.streamscape.sef.dispatcher.AbstractFabricConsumer;
import com.streamscape.sef.dispatcher.ExchangeEventAsyncConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventDispatcherImpl;
import com.streamscape.sef.dispatcher.FabricGroupLinkImpl;
import com.streamscape.sef.enums.DispatchMode;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.enums.FlowControlMode;

class FabricEventAsyncConsumerImpl
extends AbstractFabricConsumer
implements EventAsyncConsumer {
    transient ExchangeEventAsyncConsumerImpl underlyingConsumer;
    transient FabricEventListener listener;

    FabricEventAsyncConsumerImpl(String name, CompositeFilter eventFilter, String eventSelector, FabricEventListener listener, EventScope eventScope, boolean noLocal, FabricEventDispatcherImpl dispatcher, FabricGroupLinkImpl groupLink) throws FabricEventDispatcherException {
        super(name, eventScope, noLocal, dispatcher, groupLink);
        this.underlyingConsumer = new ExchangeEventAsyncConsumerImpl(dispatcher.makeConsumerFullName(name), eventFilter, (EventListener)new Listener());
        this.listener = listener;
        this.underlyingConsumer.setEventSelector(eventSelector, this.createSelectorExpression1(eventSelector));
    }

    @Override
    public FabricEventListener getEventListener() {
        return this.listener;
    }

    @Override
    public void setEventListener(FabricEventListener listener) {
        this.listener = listener;
    }

    @Override
    public String getEventFilter() {
        return this.underlyingConsumer.getEventFilter();
    }

    @Override
    CompositeFilter getCompositeFilter() {
        return this.underlyingConsumer.getCompositeFilter();
    }

    @Override
    String getMode() {
        return "Async";
    }

    @Override
    public String getEventSelector() {
        return this.underlyingConsumer.getEventSelector();
    }

    @Override
    public void setEventSelector(String eventSelector) throws EventSelectorFormatException {
        if (!Utils.equalsNullSafe(this.getEventSelector(), eventSelector)) {
            this.underlyingConsumer.setEventSelector(eventSelector, this.createSelectorExpression2(eventSelector));
            this.onChange(true);
        }
    }

    @Override
    public DispatchMode getDispatchMode() {
        return DispatchMode.DIRECT;
    }

    @Override
    public int getMaxDepth() {
        return this.underlyingConsumer.getMaxDepth();
    }

    @Override
    public void setMaxDepth(int maxDepth) throws IllegalConsumerStateException {
        if (this.getMaxDepth() != maxDepth) {
            this.underlyingConsumer.setMaxDepth(maxDepth);
            this.onChange(false);
        }
    }

    @Override
    public FlowControlMode getFlowControlMode() {
        return FlowControlMode.convert(this.underlyingConsumer.getFlowControlMode());
    }

    @Override
    public void setFlowControlMode(FlowControlMode flowControlMode) throws IllegalConsumerStateException {
        if (this.getFlowControlMode() != flowControlMode) {
            this.underlyingConsumer.setFlowControlMode(flowControlMode.convert());
            this.onChange(false);
        }
    }

    @Override
    public DeliveryMode getDeliveryMode() {
        return this.underlyingConsumer.getDeliveryMode();
    }

    @Override
    public void setDeliveryMode(DeliveryMode deliveryMode) throws IllegalConsumerStateException {
        if (this.getDeliveryMode() != deliveryMode) {
            try {
                this.underlyingConsumer.setDeliveryMode(deliveryMode);
                this.onChange(false);
            }
            catch (IllegalQueueStateException exception) {
                throw new IllegalConsumerStateException("Changing delivery mode failed.", exception);
            }
        }
    }

    @Override
    public long getDeliverySpinWait() {
        return this.underlyingConsumer.getDeliverySpinWait();
    }

    @Override
    public void setDeliverySpinWait(long deliverySpinWait) {
        if (this.getDeliverySpinWait() != deliverySpinWait) {
            this.underlyingConsumer.setDeliverySpinWait(deliverySpinWait);
            this.onChange(false);
        }
    }

    @Override
    public void start() {
        this.underlyingConsumer.start();
    }

    @Override
    public void stop() {
        this.underlyingConsumer.stop();
    }

    @Override
    public boolean isStarted() {
        return this.underlyingConsumer.isStarted();
    }

    @Override
    public void suspend() {
        this.underlyingConsumer.suspend();
    }

    @Override
    public void resume() {
        this.underlyingConsumer.resume();
    }

    @Override
    public boolean isSuspended() {
        return this.underlyingConsumer.isSuspended();
    }

    @Override
    public void clear() {
        this.underlyingConsumer.clear();
    }

    @Override
    public int getCurrentDepth() {
        return this.underlyingConsumer.getCurrentDepth();
    }

    @Override
    public void close() {
        this.close(30000L);
    }

    @Override
    public void close(long timeout) {
        try {
            if (this.getName().startsWith("sys$")) {
                this.dispatcher.dropSystemConsumer(this.getName());
            } else {
                this.dispatcher.dropEventAsyncConsumer(this.getName(), timeout, this.groupLink);
            }
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
    }

    @Override
    public void forceClose() {
        this.close(0L);
    }

    class Listener
    implements EventListener {
        Listener() {
        }

        @Override
        public void onEvent(ImmutableEventDatagram event) {
            try {
                FabricEventAsyncConsumerImpl.this.listener.onEvent(event);
            }
            catch (FabricEventException exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Exception was thrown by asynchronous listener. Such exception is ignored.");
            }
        }
    }
}

