/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.dispatcher.EventAsyncConsumerImpl;
import com.streamscape.lib.dispatcher.EventConsumerImpl;
import com.streamscape.lib.dispatcher.EventDispatcher;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.EventException;
import com.streamscape.lib.dispatcher.EventListener;
import com.streamscape.lib.dispatcher.EventRequestConsumerImpl;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.filter.FilterUtils;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.dispatcher.ExchangeConsumer;
import com.streamscape.sef.dispatcher.ExchangeEventConsumerImpl;
import com.streamscape.sef.dispatcher.InternalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class ExtendedEventDispatcher
extends EventDispatcher {
    static final List<String> RESERVED_EVENT_ID_PREFIXES = new ArrayList<String>();
    static final List<String> RESERVED_EVENT_FILTER_PREFIXES = new ArrayList<String>();
    private static final String RESERVED_PREFIX_SIGN = "e.";

    ExtendedEventDispatcher() {
    }

    protected void raiseLocalException(ExceptionEventDatagram event) throws FabricEventSourceException, EventException {
    }

    protected void addConsumer(NamedObject consumer, boolean isSystem) {
        if (consumer instanceof EventAsyncConsumerImpl) {
            this.addAsyncConsumer((EventAsyncConsumerImpl)consumer, isSystem);
        } else if (consumer instanceof EventConsumerImpl) {
            this.addDirectConsumer((EventConsumerImpl)consumer, isSystem);
        } else {
            this.addRequestConsumer((EventRequestConsumerImpl)consumer);
        }
    }

    @Override
    protected void addDirectConsumer(EventConsumerImpl consumer, boolean isSystem) {
        this.putDirectConsumer(consumer);
        if (!isSystem) {
            this.processCachedEvents(consumer);
        } else {
            this.setReady(consumer);
        }
    }

    @Override
    protected void addAsyncConsumer(EventAsyncConsumerImpl consumer, boolean isSystem) {
        this.putAsyncConsumer(consumer);
        if (!isSystem) {
            this.processCachedEvents(consumer);
        } else {
            this.setReady(consumer);
        }
    }

    @Override
    protected void addRequestConsumer(EventRequestConsumerImpl consumer) {
        this.putRequestConsumer(consumer);
    }

    protected void dropConsumer(NamedObject consumer) {
        if (consumer instanceof EventAsyncConsumerImpl) {
            this.dropAsyncConsumer(consumer.getName());
        } else if (consumer instanceof EventConsumerImpl) {
            this.dropConsumer(consumer.getName());
        } else {
            this.dropRequestConsumer(consumer.getName());
        }
    }

    @Override
    public void dropAsyncConsumer(String consumerName) {
        EventAsyncConsumerImpl removedConsumer = (EventAsyncConsumerImpl)this.eventAsyncConsumers.remove(consumerName);
        if (removedConsumer != null) {
            this.removeConsumer(removedConsumer);
        }
    }

    @Override
    protected void removeEventCache(Filter eventFilter) {
        super.removeEventCache(eventFilter);
    }

    @Override
    protected void doDeliverEvent(ImmutableEventDatagram event, Collection<EventConsumerImpl> consumers) throws EventException {
        if (consumers != null) {
            String reservedPrefix = ExtendedEventDispatcher.getReservedPrefix(event);
            if (reservedPrefix == null) {
                this.doDeliverEvent(event, consumers, this.createEventProcessor());
            } else {
                this.doDeliverEvent(event, consumers, this.createEventProcessor(reservedPrefix));
            }
        }
    }

    protected static String getReservedPrefix(ImmutableEventDatagram event) {
        if (event.getEventId().startsWith(RESERVED_PREFIX_SIGN)) {
            return RESERVED_EVENT_ID_PREFIXES.stream().filter(prefix -> event.getEventId().startsWith((String)prefix)).findFirst().orElse(null);
        }
        return null;
    }

    protected EventDispatcher.EventProcessor createEventProcessor(String reservedPrefix) {
        return new EventProcessorWithPrefix(this, reservedPrefix);
    }

    protected void addReplyConsumer(ReplyConsumer consumer) {
        super.addReplyConsumer(consumer);
    }

    protected void removeReplyConsumer(ReplyConsumer consumer) {
        super.removeReplyConsumer(consumer);
    }

    @Override
    protected ReplyConsumer createReplyConsumer(EventDatagram request, ReplyMatchStrategy matchStrategy) throws EventDispatcherException {
        return (ReplyConsumer)super.createReplyConsumer(request, matchStrategy);
    }

    @Override
    protected EventDispatcher.ReplyConsumer createReplyConsumerInstance(EventDatagram request) throws EventDispatcherException {
        return new ReplyConsumer(request);
    }

    @Override
    protected EventDispatcher.ReplyConsumer createReplyConsumerWithCorrelationIdInstance(EventDatagram request) throws EventDispatcherException {
        return new ReplyWithCorrelationIdConsumer(this, request);
    }

    @Override
    protected EventConsumerImpl createUnderlyingReplyConsumer(String consumerName, String eventFilter, EventListener listener) throws EventDispatcherException {
        try {
            return new ExchangeEventConsumerImpl(consumerName, eventFilter, listener);
        }
        catch (FilterFormatException exception) {
            throw new EventDispatcherException("Creation of underlying reply consumer failed.", exception);
        }
    }

    static {
        RESERVED_EVENT_ID_PREFIXES.add("e.action.");
        RESERVED_EVENT_ID_PREFIXES.add("e.chunk.");
        RESERVED_EVENT_ID_PREFIXES.add("e.link.");
        RESERVED_EVENT_ID_PREFIXES.add("e.prototype.");
        RESERVED_EVENT_ID_PREFIXES.add("e.replication");
        RESERVED_EVENT_ID_PREFIXES.add("e.reply.");
        RESERVED_EVENT_ID_PREFIXES.add("e.sys.reply.");
        RESERVED_EVENT_ID_PREFIXES.add("e.sys.");
        RESERVED_EVENT_FILTER_PREFIXES.addAll(RESERVED_EVENT_ID_PREFIXES);
        RESERVED_EVENT_FILTER_PREFIXES.remove("e.chunk.");
    }

    protected class EventProcessorWithPrefix
    extends EventDispatcher.EventProcessor {
        private String reservedPrefix;

        protected EventProcessorWithPrefix(ExtendedEventDispatcher this$0, String reservedPrefix) {
            super(this$0);
            this.reservedPrefix = reservedPrefix;
        }

        @Override
        protected boolean matches(EventConsumerImpl consumer, ImmutableEventDatagram event) {
            return this.matchesPrefix((ExchangeConsumer)((Object)consumer), event.getEventId(), this.reservedPrefix) && super.matches(consumer, event);
        }

        protected boolean matchesPrefix(ExchangeConsumer consumer, String eventId, String prefix) {
            return consumer.getCompositeFilter().getFilters().stream().anyMatch(filter -> FilterUtils.matches(eventId, filter) && filter.toString().startsWith(prefix));
        }
    }

    protected class ReplyConsumer
    extends EventDispatcher.ReplyConsumer {
        protected ReplyConsumer(EventDatagram request) throws EventDispatcherException {
            super(ExtendedEventDispatcher.this, request);
        }

        protected ExchangeEventConsumerImpl getUnderlyingConsumer() {
            return (ExchangeEventConsumerImpl)this.underlyingConsumer;
        }

        @Override
        protected boolean checkReceivedEvent(ImmutableEventDatagram event) {
            return super.checkReceivedEvent(event) && this.checkReplyEventType(event);
        }

        protected boolean checkReplyEventType(ImmutableEventDatagram event) {
            if (!(event instanceof AcknowledgementEvent)) {
                try {
                    ExtendedEventDispatcher.this.raiseLocalException(InternalUtils.createProtectedObject(FabricUnboundEventException.class, new Class[]{ImmutableEventDatagram.class}, event));
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
                return false;
            }
            return true;
        }
    }

    protected class ReplyWithCorrelationIdConsumer
    extends ReplyConsumer {
        transient String correlationId;

        protected ReplyWithCorrelationIdConsumer(ExtendedEventDispatcher this$0, EventDatagram request) throws EventDispatcherException {
            super(request);
        }

        @Override
        protected void checkRequest(EventDatagram request) throws EventDispatcherException {
            if (request.getCorrelationIdAsBytes() == null) {
                throw new EventDispatcherException("Creation of reply consumer failed: event field 'correlationId' is null.");
            }
            this.correlationId = request.getCorrelationId();
        }

        @Override
        protected boolean checkReceivedEvent(ImmutableEventDatagram event) {
            return event instanceof EventDatagram && this.correlationId.equals(((EventDatagram)event).getCorrelationId()) && this.checkReplyEventType(event);
        }
    }
}

