/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.dispatcher.DataConstraintStore;
import com.streamscape.lib.dispatcher.EventAsyncConsumerImpl;
import com.streamscape.lib.dispatcher.EventCache;
import com.streamscape.lib.dispatcher.EventConsumerImpl;
import com.streamscape.lib.dispatcher.EventDispatcher;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.EventException;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterUtils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.enums.ExceptionStrategy;
import com.streamscape.sef.FabricEventStreamException;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.ExchangeConsumer;
import com.streamscape.sef.dispatcher.ExchangeEventConsumer;
import com.streamscape.sef.dispatcher.ExchangeEventDispatcherException;
import com.streamscape.sef.dispatcher.ExtendedEventDispatcher;
import com.streamscape.sef.dispatcher.FabricEventSourceFactoryImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.ComponentReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class ExchangeEventDispatcher
extends ExtendedEventDispatcher {
    private final AbstractExchange exchange;

    ExchangeEventDispatcher(AbstractExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    protected DataConstraintStore createDataConstraintStore() {
        return null;
    }

    void addConsumer(NamedObject consumer, List<ImmutableEventDatagram> cachedEvents) {
        if (consumer instanceof EventAsyncConsumerImpl) {
            this.addAsyncConsumer((EventAsyncConsumerImpl)consumer, cachedEvents);
        } else {
            this.addDirectConsumer((EventConsumerImpl)consumer, cachedEvents);
        }
    }

    private void addDirectConsumer(EventConsumerImpl consumer, List<ImmutableEventDatagram> cachedEvents) {
        this.putDirectConsumer(consumer);
        this.processCachedEvents(consumer, cachedEvents);
    }

    private void addAsyncConsumer(EventAsyncConsumerImpl consumer, List<ImmutableEventDatagram> cachedEvents) {
        this.putAsyncConsumer(consumer);
        this.processCachedEvents(consumer, cachedEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreConsumers() {
        Object object = this.consumersMutex;
        synchronized (object) {
            ExchangeEventDispatcher.restoreConsumers(this.eventConsumers);
            ExchangeEventDispatcher.restoreConsumers(this.eventAsyncConsumers);
            ExchangeEventDispatcher.restoreConsumers(this.eventRequestConsumers);
            ExchangeEventDispatcher.restoreConsumers(this.replyConsumers);
        }
    }

    private static <T extends NamedObject> void restoreConsumers(Map<String, T> consumers) {
        if (!consumers.isEmpty()) {
            ArrayList<T> newConsumers = new ArrayList<T>(consumers.values());
            consumers.clear();
            for (NamedObject consumer : newConsumers) {
                consumers.put(consumer.getName(), consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void raiseEvent(ImmutableEventDatagram event, FabricAddress componentAddress, EventScope eventScope) throws EventException {
        this.eventsLock.readLock().lock();
        try {
            this.deliverEvent(event, componentAddress);
            if (event.getDurable()) {
                this.addEventToCaches(event, eventScope);
            }
        }
        finally {
            this.eventsLock.readLock().unlock();
        }
    }

    protected void deliverEvent(ImmutableEventDatagram event, FabricAddress componentAddress) throws EventException {
        Collection<EventConsumerImpl> consumers = this.getConsumers(event);
        if (consumers != null) {
            String reservedPrefix = ExchangeEventDispatcher.getReservedPrefix(event);
            if (reservedPrefix == null) {
                this.doDeliverEvent(event, consumers, new ExchangeEventProcessor(componentAddress));
            } else {
                this.doDeliverEvent(event, consumers, new ExchangeEventProcessorWithPrefix(reservedPrefix, componentAddress));
            }
        }
    }

    public void raiseNetworkEvent(ImmutableEventDatagram event, FabricAddress componentAddress) throws EventException {
        this.eventsLock.readLock().lock();
        try {
            this.deliverNetworkEvent(event, componentAddress);
            if (event.getDurable()) {
                this.addNetworkEventToCaches(event);
            }
        }
        finally {
            this.eventsLock.readLock().unlock();
        }
    }

    protected void deliverNetworkEvent(ImmutableEventDatagram event, FabricAddress componentAddress) throws EventException {
        Collection<EventConsumerImpl> consumers = this.getConsumers(event);
        if (consumers != null) {
            this.doDeliverEvent(event, consumers, new NetworkEventProcessor(componentAddress));
        }
    }

    ExceptionStrategy doGetExceptionStrategy(FabricAddress componentAddress) {
        ComponentReference component = this.exchange.moderator.lookupComponent(componentAddress);
        return component != null ? component.getExceptionStrategy() : ExceptionStrategy.ABORT;
    }

    @Override
    protected void processException(EventDispatcherException exception, ImmutableEventDatagram event) {
        if (exception instanceof ExchangeEventDispatcherException) {
            ExchangeEventDispatcherException exchangeException = (ExchangeEventDispatcherException)exception;
            try {
                FabricEventStreamException exceptionEvent = new FabricEventStreamException(exchangeException.consumer, event);
                FabricEventSourceFactoryImpl.coalesce((ImmutableEventDatagram)exceptionEvent, exchangeException.consumer.getComponentAddress());
                this.exchange.raiseException(exceptionEvent, exchangeException.consumer.getEventScope(), exchangeException.consumer.getComponentAddress(), true);
            }
            catch (Exception internalException) {
                this.logException(internalException);
                this.logError("Raising of exception event [exception.sef.EventStream] failed.");
            }
            this.logException(exchangeException.getCause());
        } else {
            this.logException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventToCaches(ImmutableEventDatagram event, EventScope scope) {
        if (scope != null) {
            Object object = this.cachesMutex;
            synchronized (object) {
                List caches = this.allEventCaches.get(event.getEventId());
                if (caches != null) {
                    for (EventCache cache : caches) {
                        ExchangeEventDispatcher.addEventToCache(new CachedEvent(event, scope == EventScope.OBSERVABLE ? CachedEvent.Scope.OBSERVABLE : CachedEvent.Scope.GLOBAL), cache);
                    }
                }
            }
        } else {
            this.addEventToCaches(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNetworkEventToCaches(ImmutableEventDatagram event) {
        Object object = this.cachesMutex;
        synchronized (object) {
            List caches = this.allEventCaches.get(event.getEventId());
            if (caches != null) {
                for (EventCache cache : caches) {
                    ExchangeEventDispatcher.addEventToCache(new CachedEvent(event, CachedEvent.Scope.NETWORK), cache);
                }
            }
        }
    }

    protected static void addEventToCache(CachedEvent event, EventCache eventCache) {
        EventDispatcher.addEventToCache(event, eventCache);
    }

    @Override
    protected void processCachedEvents(EventConsumerImpl consumer) {
        super.processCachedEvents(consumer, this.getCachedEvents(((ExchangeConsumer)((Object)consumer)).getCompositeFilter(), CachedEvent.Scope.OBSERVABLE));
    }

    @Override
    protected void processCachedEvents(EventConsumerImpl consumer, List<ImmutableEventDatagram> cachedEvents) {
        this.getCachedEvents(((ExchangeConsumer)((Object)consumer)).getCompositeFilter(), cachedEvents, CachedEvent.Scope.GLOBAL);
        super.processCachedEvents(consumer, cachedEvents);
    }

    List<ImmutableEventDatagram> getCachedEvents(CompositeFilter filter, CachedEvent.Scope scope) {
        ArrayList<ImmutableEventDatagram> result = new ArrayList<ImmutableEventDatagram>();
        this.getCachedEvents(filter, result, scope);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getCachedEvents(CompositeFilter filter, List<ImmutableEventDatagram> result, CachedEvent.Scope scope) {
        if (result != null) {
            Object object = this.cachesMutex;
            synchronized (object) {
                for (Map.Entry cacheEntry : this.eventCaches.entrySet()) {
                    List cachedEvents = ExchangeEventDispatcher.getCachedEvents((EventCache)cacheEntry.getValue());
                    result.addAll(cachedEvents.stream().filter(event -> ExchangeEventDispatcher.matches(event, scope, filter)).map(event -> event.event).collect(Collectors.toList()));
                }
            }
        }
    }

    static List<ImmutableEventDatagram> getEvents(EventCache cache, CachedEvent.Scope scope) {
        return cache.getEvents().stream().filter(event -> ExchangeEventDispatcher.matchesScope(event, scope)).map(event -> event.event).collect(Collectors.toList());
    }

    private static boolean matches(CachedEvent cachedEvent, CachedEvent.Scope scope, CompositeFilter filter) {
        return ExchangeEventDispatcher.matchesScope(cachedEvent, scope) && FilterUtils.matches(cachedEvent.event.getEventId(), filter);
    }

    private static boolean matchesScope(CachedEvent cachedEvent, CachedEvent.Scope scope) {
        return scope == CachedEvent.Scope.OBSERVABLE ? cachedEvent.scope != CachedEvent.Scope.NETWORK : scope == CachedEvent.Scope.GLOBAL || cachedEvent.scope != CachedEvent.Scope.OBSERVABLE;
    }

    protected static EventCache createEventCache(Filter eventFilter, int maxSize, CacheThresholdAction thresholdAction, boolean createQueue) throws EventDispatcherException {
        return EventDispatcher.createEventCache(eventFilter, maxSize, thresholdAction, createQueue);
    }

    @Override
    protected void addEventCache(EventCache cache) {
        this.doAddEventCache(cache);
    }

    protected static void initQueue(EventCache eventCache) {
        EventDispatcher.initQueue(eventCache);
    }

    protected class ExchangeEventProcessor
    extends EventDispatcher.EventProcessor {
        private FabricAddress componentAddress;

        protected ExchangeEventProcessor(FabricAddress componentAddress) {
            super(ExchangeEventDispatcher.this);
            this.componentAddress = componentAddress;
        }

        @Override
        protected boolean matches(EventConsumerImpl consumer, ImmutableEventDatagram event) {
            return ((ExchangeEventConsumer)((Object)consumer)).isSuitable(this.componentAddress) && super.matches(consumer, event);
        }

        @Override
        protected ExceptionStrategy getExceptionStrategy(ImmutableEventDatagram event) {
            return ExchangeEventDispatcher.this.doGetExceptionStrategy(this.componentAddress);
        }
    }

    protected class ExchangeEventProcessorWithPrefix
    extends ExtendedEventDispatcher.EventProcessorWithPrefix {
        private FabricAddress componentAddress;

        protected ExchangeEventProcessorWithPrefix(String reservedPrefix, FabricAddress componentAddress) {
            super(ExchangeEventDispatcher.this, reservedPrefix);
            this.componentAddress = componentAddress;
        }

        @Override
        protected boolean matches(EventConsumerImpl consumer, ImmutableEventDatagram event) {
            return ((ExchangeEventConsumer)((Object)consumer)).isSuitable(this.componentAddress) && super.matches(consumer, event);
        }

        @Override
        protected ExceptionStrategy getExceptionStrategy(ImmutableEventDatagram event) {
            return ExchangeEventDispatcher.this.doGetExceptionStrategy(this.componentAddress);
        }
    }

    protected class NetworkEventProcessor
    extends EventDispatcher.EventProcessor {
        private FabricAddress componentAddress;

        protected NetworkEventProcessor(FabricAddress componentAddress) {
            super(ExchangeEventDispatcher.this);
            this.componentAddress = componentAddress;
        }

        @Override
        protected boolean matches(EventConsumerImpl consumer, ImmutableEventDatagram event) {
            ExchangeConsumer exchangeConsumer = (ExchangeConsumer)((Object)consumer);
            return (exchangeConsumer.getEventScope() == EventScope.GLOBAL || this.matchesCluster(exchangeConsumer, event)) && super.matches(consumer, event);
        }

        private boolean matchesCluster(ExchangeConsumer consumer, ImmutableEventDatagram event) {
            return consumer.getEventScope() == EventScope.CLUSTER && consumer.matchesCluster(event);
        }

        @Override
        protected ExceptionStrategy getExceptionStrategy(ImmutableEventDatagram event) {
            return ExchangeEventDispatcher.this.doGetExceptionStrategy(this.componentAddress);
        }
    }

    static class CachedEvent {
        ImmutableEventDatagram event;
        Scope scope;

        CachedEvent(ImmutableEventDatagram event, Scope scope) {
            this.event = event;
            this.scope = scope;
        }

        static enum Scope {
            OBSERVABLE,
            GLOBAL,
            NETWORK;

        }
    }
}

