/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.dispatcher.DomainConstraint;
import com.streamscape.sef.dispatcher.AbstractFabricDataConstraint;
import com.streamscape.sef.dispatcher.ExchangeDataConstraint;
import com.streamscape.sef.dispatcher.FabricDomainConstraintImpl;
import com.streamscape.sef.moderator.DomainConstraintReference;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

class ExchangeDomainConstraint
extends DomainConstraint
implements ExchangeDataConstraint {
    transient FabricDomainConstraintImpl fabricImpl;

    ExchangeDomainConstraint(String name, String description, Set<Object> values) {
        super(name, description, values);
    }

    @Override
    public String getTableName() {
        return "DOMAIN_CONSTRAINTS";
    }

    void bind(FabricDomainConstraintImpl fabricImpl) {
        this.fabricImpl = fabricImpl;
    }

    DomainConstraintReference getReference() {
        return this.fabricImpl.reference;
    }

    @Override
    public synchronized boolean update(AbstractFabricDataConstraint.Updater abstractUpdater) {
        FabricDomainConstraintImpl.Updater updater = (FabricDomainConstraintImpl.Updater)abstractUpdater;
        boolean result = false;
        if (updater.description != null) {
            this.setDescription(updater.description);
            result = true;
        }
        if (!updater.addedValues.isEmpty()) {
            for (Object value : updater.addedValues) {
                this.addValue(value);
            }
            result = true;
        }
        if (!updater.removedValues.isEmpty()) {
            for (Object value : updater.removedValues) {
                this.removeValue(value);
            }
            result = true;
        }
        return result;
    }

    void addValue(Object value) {
        if (value instanceof String) {
            this.addStringValue((String)value);
        } else if (value instanceof Byte) {
            this.addByteValue((Byte)value);
        } else if (value instanceof Short) {
            this.addShortValue((Short)value);
        } else if (value instanceof Integer) {
            this.addIntValue((Integer)value);
        } else if (value instanceof Long) {
            this.addLongValue((Long)value);
        } else if (value instanceof Float) {
            this.addFloatValue(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.addDoubleValue((Double)value);
        } else if (value instanceof BigDecimal) {
            this.addBigDecimalValue((BigDecimal)value);
        } else if (value instanceof Date) {
            this.addDateValue((Date)value);
        }
    }

    void removeValue(Object value) {
        if (value instanceof String) {
            this.removeStringValue((String)value);
        } else if (value instanceof Byte) {
            this.removeByteValue((Byte)value);
        } else if (value instanceof Short) {
            this.removeShortValue((Short)value);
        } else if (value instanceof Integer) {
            this.removeIntValue((Integer)value);
        } else if (value instanceof Long) {
            this.removeLongValue((Long)value);
        } else if (value instanceof Float) {
            this.removeFloatValue(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.removeDoubleValue((Double)value);
        } else if (value instanceof BigDecimal) {
            this.removeBigDecimalValue((BigDecimal)value);
        } else if (value instanceof Date) {
            this.removeDateValue((Date)value);
        }
    }
}

