/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.dispatcher.DataConstraint;
import com.streamscape.lib.dispatcher.DataConstraintStore;
import com.streamscape.lib.dispatcher.DomainConstraint;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.RangeConstraint;
import com.streamscape.sef.dispatcher.AbstractFabricDataConstraint;
import com.streamscape.sef.dispatcher.DomainConstraintReferenceImpl;
import com.streamscape.sef.dispatcher.ExchangeDataConstraint;
import com.streamscape.sef.dispatcher.ExchangeDataConstraintReference;
import com.streamscape.sef.dispatcher.ExchangeDomainConstraint;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.ExchangeRangeConstraint;
import com.streamscape.sef.dispatcher.FabricDomainConstraintImpl;
import com.streamscape.sef.dispatcher.FabricRangeConstraintImpl;
import com.streamscape.sef.dispatcher.RangeConstraintReferenceImpl;
import java.util.Map;
import java.util.Set;

abstract class ExchangeDataConstraintStore
extends DataConstraintStore {
    ExchangeDataConstraintStore() {
    }

    @Override
    protected DomainConstraint createDomainInstance(String name, String description, Set<Object> values) {
        return new ExchangeDomainConstraint(name, description, values);
    }

    @Override
    protected RangeConstraint createRangeInstance(String name, String description, Object minValue, Object maxValue) throws EventDispatcherException {
        return new ExchangeRangeConstraint(name, description, minValue, maxValue);
    }

    @Override
    protected void clear() {
        super.clear();
    }

    synchronized void synchronizeInSysplex(Map<String, DomainConstraintReferenceImpl> domainConstraints, Map<String, RangeConstraintReferenceImpl> rangeConstraints) {
        for (DomainConstraintReferenceImpl domainConstraintReferenceImpl : domainConstraints.values()) {
            this.addConstraint(domainConstraintReferenceImpl, this.domains);
        }
        for (RangeConstraintReferenceImpl rangeConstraintReferenceImpl : rangeConstraints.values()) {
            this.addConstraint(rangeConstraintReferenceImpl, this.ranges);
        }
    }

    synchronized void synchronizeInNode(Map<String, DomainConstraintReferenceImpl> domainConstraints, Map<String, RangeConstraintReferenceImpl> rangeConstraints) {
        for (DomainConstraintReferenceImpl domainConstraintReferenceImpl : domainConstraints.values()) {
            DomainConstraint domain = this.getDomain(domainConstraintReferenceImpl.getName());
            if (domain != null) {
                if (domain.equals(domainConstraintReferenceImpl.getUnderlyingConstraint())) continue;
                this.dropDomain(domainConstraintReferenceImpl.getName());
                this.addConstraint(domainConstraintReferenceImpl, this.domains);
                continue;
            }
            this.addConstraint(domainConstraintReferenceImpl, this.domains);
        }
        for (RangeConstraintReferenceImpl rangeConstraintReferenceImpl : rangeConstraints.values()) {
            RangeConstraint range = this.getRange(rangeConstraintReferenceImpl.getName());
            if (range != null) {
                if (range.equals(rangeConstraintReferenceImpl.getUnderlyingConstraint())) continue;
                this.dropRange(rangeConstraintReferenceImpl.getName());
                this.addConstraint(rangeConstraintReferenceImpl, this.ranges);
                continue;
            }
            this.addConstraint(rangeConstraintReferenceImpl, this.ranges);
        }
    }

    private <Constraint extends DataConstraint> void addConstraint(ExchangeDataConstraintReference<Constraint> reference, DataConstraintStore.Values<Constraint> store) {
        Constraint constraint = reference.getUnderlyingConstraint();
        reference.bind();
        try {
            store.addValue(constraint, null);
            this.onAddConstraint((ExchangeDataConstraint)constraint);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private <Constraint extends DataConstraint> void addToStoreWithoutException(Constraint constraint, DataConstraintStore.Values<Constraint> store) {
        try {
            store.addValue(constraint, null);
        }
        catch (EventDispatcherException eventDispatcherException) {
            // empty catch block
        }
    }

    FabricDomainConstraintImpl createDomainConstraint(String name, String description, Set<Object> values) throws EventDispatcherException, ExchangeException {
        FabricDomainConstraintImpl result = new FabricDomainConstraintImpl((ExchangeDomainConstraint)this.createDomain(name, description, values));
        this.onAddConstraint(result.underlyingDomain);
        return result;
    }

    FabricDomainConstraintImpl createDomainConstraint(ExchangeDomainConstraint domain) throws EventDispatcherException, ExchangeException {
        this.addDomain(domain);
        return new FabricDomainConstraintImpl(domain);
    }

    @Override
    public synchronized DomainConstraint dropDomain(String name) {
        ExchangeDomainConstraint result = (ExchangeDomainConstraint)super.dropDomain(name);
        if (result != null) {
            this.onRemoveConstraint(result);
        }
        return result;
    }

    FabricDomainConstraintImpl getDomainConstraint(String name) {
        ExchangeDomainConstraint domain = (ExchangeDomainConstraint)this.getDomain(name);
        return domain != null ? domain.fabricImpl.prepareForUpdate() : null;
    }

    FabricRangeConstraintImpl createRangeConstraint(String name, String description, Object minValue, Object maxValue) throws EventDispatcherException, ExchangeException {
        FabricRangeConstraintImpl result = new FabricRangeConstraintImpl((ExchangeRangeConstraint)this.createRange(name, description, minValue, maxValue));
        this.onAddConstraint(result.underlyingRange);
        return result;
    }

    FabricRangeConstraintImpl createRangeConstraint(ExchangeRangeConstraint range) throws EventDispatcherException, ExchangeException {
        this.addRange(range);
        return new FabricRangeConstraintImpl(range);
    }

    @Override
    public synchronized RangeConstraint dropRange(String name) {
        ExchangeRangeConstraint result = (ExchangeRangeConstraint)super.dropRange(name);
        if (result != null) {
            this.onRemoveConstraint(result);
        }
        return result;
    }

    FabricRangeConstraintImpl getRangeConstraint(String name) {
        ExchangeRangeConstraint range = (ExchangeRangeConstraint)this.getRange(name);
        return range != null ? range.fabricImpl.prepareForUpdate() : null;
    }

    void addDomain(FabricDomainConstraintImpl domain) throws EventDispatcherException, ExchangeException {
        this.addDomain(domain.underlyingDomain);
        this.onAddConstraint(domain.underlyingDomain);
    }

    void addRange(FabricRangeConstraintImpl range) throws EventDispatcherException, ExchangeException {
        this.addRange(range.underlyingRange);
        this.onAddConstraint(range.underlyingRange);
    }

    boolean setDomain(FabricDomainConstraintImpl.Updater updater) throws EventDispatcherException, ExchangeException {
        ExchangeDomainConstraint domain = (ExchangeDomainConstraint)this.getDomain(updater.name);
        ExchangeDataConstraintStore.checkExistence(domain, "Domain", updater.name);
        return this.update(domain, updater);
    }

    boolean setRange(FabricRangeConstraintImpl.Updater updater) throws EventDispatcherException, ExchangeException {
        ExchangeRangeConstraint range = (ExchangeRangeConstraint)this.getRange(updater.name);
        ExchangeDataConstraintStore.checkExistence(range, "Range", updater.name);
        return this.update(range, updater);
    }

    private boolean update(ExchangeDataConstraint dataConstraint, AbstractFabricDataConstraint.Updater updater) throws ExchangeException {
        boolean updated = dataConstraint.update(updater);
        if (updated) {
            this.onUpdateConstraint(dataConstraint);
        }
        return updated;
    }

    protected abstract void onAddConstraint(ExchangeDataConstraint var1) throws ExchangeException;

    protected abstract void onRemoveConstraint(ExchangeDataConstraint var1);

    protected abstract void onUpdateConstraint(ExchangeDataConstraint var1) throws ExchangeException;

    private static void checkExistence(ExchangeDataConstraint constraint, String model, String name) throws EventDispatcherException {
        if (constraint == null) {
            throw new EventDispatcherException(model + " '" + name + "' does not exist.");
        }
    }
}

