/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

class ExchangeByteArrayOutputStream
extends ByteArrayOutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int LARGE_BUFFER_SIZE = 0x6400000;

    ExchangeByteArrayOutputStream(byte[] buffer) {
        this.buf = buffer;
        this.count = buffer.length;
    }

    ExchangeByteArrayOutputStream(byte[] buffer, int length) {
        this.buf = buffer;
        this.count = length;
    }

    @Override
    public synchronized void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.buf.length;
        int n = newCapacity = oldCapacity > 0x6400000 ? ExchangeByteArrayOutputStream.scaleCapacity(oldCapacity) : oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            int n2 = newCapacity = minCapacity > 0x6400000 ? ExchangeByteArrayOutputStream.scaleCapacity(minCapacity) : minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ExchangeByteArrayOutputStream.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    private static int scaleCapacity(int capacity) {
        return (int)((double)capacity * 1.05);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    byte[] array() {
        return this.buf;
    }

    int length() {
        return this.count;
    }

    ByteBuffer byteBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.count);
    }
}

