/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.ds.schema.SyntaxStore;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import java.util.List;

public class EventTriggerSyntaxStore {
    private static final String TYPE = SqlUtils.getSchemaObjectType(9);

    public static boolean isSyntaxExists(ServiceContext serviceContext, String triggerName) throws ServiceConfigurationException {
        try {
            return SyntaxStore.loadSyntax(serviceContext, TYPE, triggerName) != null;
        }
        catch (Exception exception) {
            throw new ServiceConfigurationException(exception.getMessage());
        }
    }

    public static void saveSyntax(ServiceContext serviceContext, String triggerName, String triggerSyntax) throws ServiceConfigurationException {
        try {
            SyntaxStore.saveSyntax(serviceContext, TYPE, triggerName, triggerSyntax);
        }
        catch (Exception exception) {
            throw new ServiceConfigurationException(exception.getMessage());
        }
    }

    public static void removeSyntax(ServiceContext serviceContext, String triggerName) throws ServiceConfigurationException {
        try {
            SyntaxStore.deleteSyntax(serviceContext, TYPE, triggerName);
        }
        catch (Exception exception) {
            throw new ServiceConfigurationException(exception.getMessage());
        }
    }

    public static void removeSyntaxes(ServiceContext serviceContext) throws ServiceConfigurationException {
        try {
            SyntaxStore.deleteSyntax(serviceContext, TYPE, null);
        }
        catch (Exception exception) {
            throw new ServiceConfigurationException(exception.getMessage());
        }
    }

    public static List<String> listTriggers(ServiceContext serviceContext) throws ServiceConfigurationException {
        try {
            return SyntaxStore.listEntityNames(serviceContext, TYPE);
        }
        catch (Exception exception) {
            throw new ServiceConfigurationException(exception.getMessage());
        }
    }

    public static String loadSyntax(ServiceContext serviceContext, String triggerName) throws ServiceConfigurationException {
        try {
            return SyntaxStore.loadSyntax(serviceContext, TYPE, triggerName);
        }
        catch (Exception exception) {
            throw new ServiceConfigurationException(exception.getMessage());
        }
    }
}

