/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.EventFlowImpl;
import com.streamscape.sef.dispatcher.SinkEventFlowImpl;
import com.streamscape.sef.dispatcher.SourceEventFlowImpl;
import com.streamscape.sef.moderator.EventFlow;
import com.streamscape.sef.moderator.EventFlows;
import com.streamscape.sef.moderator.SinkEventFlow;
import com.streamscape.sef.moderator.SourceEventFlow;
import java.util.ArrayList;
import java.util.List;

public class EventFlowsImpl
extends CloneableDataObject
implements EventFlows {
    private String eventId;
    private String eventModel;
    private ArrayList<SourceEventFlowImpl> sourceEventFlows;
    private ArrayList<SinkEventFlowImpl> sinkEventFlows;

    public EventFlowsImpl(String eventId, String eventModel) {
        this.eventId = eventId;
        this.eventModel = eventModel;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    void setEventId(String eventId) {
        this.eventId = eventId;
    }

    @Override
    public String getEventModel() {
        return this.eventModel;
    }

    void setEventModel(String eventModel) {
        this.eventModel = eventModel;
    }

    @Override
    public List<? extends SourceEventFlow> getSourceEventFlows() {
        return this.sourceEventFlows;
    }

    @Override
    public List<? extends SinkEventFlow> getSinkEventFlows() {
        return this.sinkEventFlows;
    }

    void addEventFlow(EventFlow eventFlow) {
        if (eventFlow instanceof SourceEventFlowImpl) {
            this.addSourceEventFlow((SourceEventFlowImpl)eventFlow);
        } else if (eventFlow instanceof SinkEventFlowImpl) {
            this.addSinkEventFlow((SinkEventFlowImpl)eventFlow);
        }
    }

    private void addSourceEventFlow(SourceEventFlowImpl flow) {
        this.initSourceEventFlows();
        this.doAddEventFlow(flow, this.sourceEventFlows);
    }

    private void addSinkEventFlow(SinkEventFlowImpl flow) {
        this.initSinkEventFlows();
        this.doAddEventFlow(flow, this.sinkEventFlows);
    }

    private <T extends EventFlowImpl> void doAddEventFlow(T flow, List<T> flows) {
        if (!flows.contains(flow)) {
            flows.add(flow);
        }
    }

    void removeSourceEventFlow(SourceEventFlowImpl flow) {
        this.doRemoveEventFlow(flow, this.sourceEventFlows);
        this.destroySourceEventFlows();
    }

    void removeSinkEventFlow(SinkEventFlowImpl flow) {
        this.doRemoveEventFlow(flow, this.sinkEventFlows);
        this.destroySinkEventFlows();
    }

    void removeEventFlow(EventFlowImpl eventFlow) {
        if (eventFlow instanceof SourceEventFlowImpl) {
            this.removeSourceEventFlow((SourceEventFlowImpl)eventFlow);
        } else if (eventFlow instanceof SinkEventFlowImpl) {
            this.removeSinkEventFlow((SinkEventFlowImpl)eventFlow);
        }
    }

    private <T extends EventFlow> void doRemoveEventFlow(T flow, List<T> flows) {
        if (flows != null) {
            flows.remove(flow);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.sourceEventFlows == null && this.sinkEventFlows == null;
    }

    EventFlowsImpl filterByComponent(String componentFullName) {
        EventFlowsImpl result = new EventFlowsImpl(this.eventId, this.eventModel);
        this.doFilterByComponent(this.sourceEventFlows, componentFullName, result);
        this.doFilterByComponent(this.sinkEventFlows, componentFullName, result);
        return result;
    }

    private <T extends EventFlowImpl> void doFilterByComponent(List<T> flows, String componentFullName, EventFlowsImpl result) {
        if (flows != null) {
            flows.stream().filter(flow -> flow.getComponentFullName().equals(componentFullName)).forEach(result::addEventFlow);
        }
    }

    void removeByComponent(String componentFullName) {
        this.doRemoveByComponent(this.sourceEventFlows, componentFullName);
        this.doRemoveByComponent(this.sinkEventFlows, componentFullName);
    }

    private <T extends EventFlowImpl> void doRemoveByComponent(List<T> flows, String componentFullName) {
        if (flows != null) {
            flows.removeIf(flow -> flow.getComponentFullName().equals(componentFullName));
        }
    }

    void normalizeSystemComponents(boolean all) {
        this.doNormalizeSystemComponents(this.sourceEventFlows, all);
        this.destroySourceEventFlows();
        this.doNormalizeSystemComponents(this.sinkEventFlows, all);
        this.destroySinkEventFlows();
    }

    private void doNormalizeSystemComponents(List<? extends EventFlow> flows, boolean all) {
        if (flows != null) {
            flows.removeIf(flow -> AbstractOperation.isSystemComponent(flow.getComponentType(), flow.getComponentName()) && !all);
        }
    }

    void merge(EventFlowsImpl other) {
        if (other.sourceEventFlows != null) {
            this.initSourceEventFlows();
            this.sourceEventFlows.addAll(other.sourceEventFlows);
        }
        if (other.sinkEventFlows != null) {
            this.initSinkEventFlows();
            this.sinkEventFlows.addAll(other.sinkEventFlows);
        }
    }

    private void initSourceEventFlows() {
        if (this.sourceEventFlows == null) {
            this.sourceEventFlows = new ArrayList();
        }
    }

    private void destroySourceEventFlows() {
        if (this.sourceEventFlows != null && this.sourceEventFlows.isEmpty()) {
            this.sourceEventFlows = null;
        }
    }

    private void initSinkEventFlows() {
        if (this.sinkEventFlows == null) {
            this.sinkEventFlows = new ArrayList();
        }
    }

    private void destroySinkEventFlows() {
        if (this.sinkEventFlows != null && this.sinkEventFlows.isEmpty()) {
            this.sinkEventFlows = null;
        }
    }

    @Override
    public EventFlowsImpl clone() {
        EventFlowsImpl result = (EventFlowsImpl)super.clone();
        result.sourceEventFlows = this.sourceEventFlows != null ? (ArrayList)this.sourceEventFlows.clone() : null;
        result.sinkEventFlows = this.sinkEventFlows != null ? (ArrayList)this.sinkEventFlows.clone() : null;
        return result;
    }
}

