/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.filter.FilterUtils;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.EventFlowImpl;
import com.streamscape.sef.dispatcher.EventFlowsImpl;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.dispatcher.SinkEventFlowImpl;
import com.streamscape.sef.dispatcher.SourceEventFlowImpl;
import com.streamscape.sef.moderator.EventFlowMap;
import com.streamscape.sef.moderator.EventFlows;
import com.streamscape.sef.moderator.ModeratorUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class EventFlowMapImpl
extends CloneableDataObject
implements EventFlowMap {
    private String domain;
    private String nodeName;
    private HashMap<String, EventFlowsImpl> eventFlows = new HashMap();
    private long timestamp;
    private transient RuntimeExchange exchange;
    private transient List<SinkEventFlowImpl> genericEventFlows = new ArrayList<SinkEventFlowImpl>();

    EventFlowMapImpl(RuntimeExchange exchange) {
        this(exchange.getDomain(), exchange.getNodeName());
        this.exchange = exchange;
    }

    EventFlowMapImpl(String domain, String nodeName) {
        this.domain = domain;
        this.nodeName = nodeName;
        this.touch();
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp > 0L ? new Date(this.timestamp) : null;
    }

    @Override
    public Map<String, ? extends EventFlows> getEventFlows() {
        return this.eventFlows;
    }

    @Override
    public boolean existsEventFlows(String eventId) {
        EventFlows flows = this.eventFlows.get(eventId);
        return flows != null && !flows.isEmpty();
    }

    synchronized void addEventFlows(String eventId) {
        this.eventFlows.put(eventId, new EventFlowsImpl(eventId, this.getEventModel(eventId)));
    }

    synchronized void removeEventFlows(String eventId) {
        this.eventFlows.remove(eventId);
    }

    synchronized void addEventFlow(EventFlowImpl eventFlow) {
        SinkEventFlowImpl sinkFlow;
        if (eventFlow instanceof SinkEventFlowImpl && FilterUtils.isGenericFilter((sinkFlow = (SinkEventFlowImpl)eventFlow).getEventFilter())) {
            this.addGenericEventFlow(sinkFlow);
            return;
        }
        this.doAddEventFlow(eventFlow);
    }

    private void doAddEventFlow(EventFlowImpl eventFlow) {
        String eventModel = this.getEventModel(eventFlow.getEventId());
        eventFlow.setEventModel(eventModel);
        this.eventFlows.computeIfAbsent(eventFlow.getEventId(), newFlow -> new EventFlowsImpl(eventFlow.getEventId(), eventModel)).addEventFlow(eventFlow);
    }

    synchronized void removeEventFlow(EventFlowImpl eventFlow) {
        SinkEventFlowImpl sinkFlow;
        if (eventFlow instanceof SinkEventFlowImpl && FilterUtils.isGenericFilter((sinkFlow = (SinkEventFlowImpl)eventFlow).getEventFilter())) {
            this.removeGenericEventFlow(sinkFlow);
            return;
        }
        this.doRemoveEventFlow(eventFlow);
    }

    private void doRemoveEventFlow(EventFlowImpl eventFlow) {
        EventFlowsImpl flows = this.eventFlows.get(eventFlow.getEventId());
        if (flows != null) {
            flows.removeEventFlow(eventFlow);
        }
    }

    synchronized void removeSourceEventFlow(SourceEventFlowImpl flow) {
        EventFlowsImpl flows = this.eventFlows.get(flow.getEventId());
        if (flows != null) {
            flows.removeSourceEventFlow(flow);
        }
    }

    synchronized void removeSinkEventFlow(SinkEventFlowImpl flow) {
        EventFlowsImpl flows = this.eventFlows.get(flow.getEventId());
        if (flows != null) {
            flows.removeSinkEventFlow(flow);
        }
    }

    private void addGenericEventFlow(SinkEventFlowImpl flow) {
        this.genericEventFlows.add(flow);
    }

    private void removeGenericEventFlow(SinkEventFlowImpl flow) {
        this.genericEventFlows.remove(flow);
    }

    @Override
    public synchronized List<EventFlows> getComponentEventFlows(String componentName) {
        return this.eventFlows.values().stream().map(flows -> flows.filterByComponent(ModeratorUtils.checkComponentFullName(this.nodeName, componentName))).collect(Collectors.toList());
    }

    synchronized void removeComponentFlows(AbstractFabricComponent component) {
        this.eventFlows.values().forEach(flows -> flows.removeByComponent(component.getFullName()));
    }

    private String getEventModel(String eventId) {
        return InternalUtils.getEventModel(eventId, this.exchange.context.getDatagramPrototypeCache());
    }

    @Override
    public String asXML() throws Exception {
        return XSerializerFactory.getInstance().getDefaultSerializer().serialize(this);
    }

    @Override
    public String asJSON() throws Exception {
        return JSONSerializerFactory.getInstance().getDefaultSerializer().serialize(this);
    }

    private void touch() {
        this.timestamp = System.currentTimeMillis();
    }

    synchronized void merge(EventFlowMapImpl other) {
        if (other != null) {
            other.eventFlows.forEach((key, value) -> {
                EventFlowsImpl flows = this.eventFlows.get(key);
                if (flows != null) {
                    flows.merge((EventFlowsImpl)value);
                } else {
                    this.eventFlows.put((String)key, (EventFlowsImpl)value);
                }
            });
            this.nodeName = null;
            this.touch();
        }
    }

    EventFlowMap normalize(boolean all) {
        EventFlowMapImpl result = this.clone();
        result.normalizeSystemEvents(all);
        result.normalizeSystemComponents(all);
        result.normalizeGenericFlows(all);
        return result;
    }

    private void normalizeSystemEvents(boolean all) {
        this.exchange.context.getDatagramPrototypeCache().listEventIds().forEach(eventId -> {
            if (EventFlowMapImpl.isSystem(eventId, all)) {
                this.removeEventFlows((String)eventId);
            } else if (!this.existsEventFlows((String)eventId)) {
                this.addEventFlows((String)eventId);
            }
        });
    }

    private void normalizeSystemComponents(boolean all) {
        this.eventFlows.values().forEach(flows -> flows.normalizeSystemComponents(all));
    }

    private void normalizeGenericFlows(boolean all) {
        this.genericEventFlows.forEach(flow -> {
            try {
                CompositeFilter filter = new CompositeFilter(flow.getEventFilter());
                this.exchange.context.getDatagramPrototypeCache().listEventIds().forEach(eventId -> {
                    if (!EventFlowMapImpl.isSystem(eventId, all) && FilterUtils.matches(eventId, filter)) {
                        this.doAddEventFlow(flow.clone((String)eventId));
                    }
                });
            }
            catch (FilterFormatException filterFormatException) {
                // empty catch block
            }
        });
    }

    private static boolean isSystem(String eventId, boolean all) {
        return AbstractOperation.isReservedEvent(eventId) || AbstractOperation.isSystemEvent(eventId) && !AbstractOperation.isVisibleEvent(eventId) && !all;
    }

    @Override
    public EventFlowMapImpl clone() {
        EventFlowMapImpl result = (EventFlowMapImpl)super.clone();
        if (this.eventFlows != null) {
            result.eventFlows = new HashMap();
            this.eventFlows.forEach((key, value) -> result.eventFlows.put((String)key, value.clone()));
        }
        return result;
    }

    public String toString() {
        try {
            return this.asJSON();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }
}

