/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.EventFlow;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.moderator.ModeratorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class EventFlowImpl
extends CloneableDataObject
implements EventFlow {
    private String eventId;
    private String eventModel;
    private String nodeName;
    private String componentType;
    private String componentName;
    private ComponentModel componentModel;
    private String ownerName;
    private EventFlowEntity entity;
    private String entityName;
    private EventScope entityScope;
    private HashMap<String, String> entityParameters;
    private boolean isSystem = false;
    private boolean isActive = true;

    EventFlowImpl(String eventId, String nodeName, String componentType, String componentName, ComponentModel componentModel, String ownerName, EventFlowEntity entity, String entityName, EventScope entityScope, boolean isSystem) {
        this.eventId = eventId;
        this.nodeName = nodeName;
        this.componentType = componentType;
        this.componentName = componentName;
        this.componentModel = componentModel;
        this.ownerName = ownerName;
        this.entity = entity;
        this.entityName = entityName;
        this.entityScope = entityScope;
        this.isSystem = isSystem;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    void setEventId(String eventId) {
        this.eventId = eventId;
    }

    @Override
    public String getEventModel() {
        return this.eventModel;
    }

    void setEventModel(String eventModel) {
        this.eventModel = eventModel;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    String getComponentFullName() {
        return ModeratorUtils.makeComponentFullName(this.nodeName, this.componentType, this.componentName);
    }

    @Override
    public ComponentModel getComponentModel() {
        return this.componentModel;
    }

    void setComponentModel(ComponentModel componentModel) {
        this.componentModel = componentModel;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public EventFlowEntity getEntity() {
        return this.entity;
    }

    void setEntity(EventFlowEntity entity) {
        this.entity = entity;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Override
    public EventScope getEntityScope() {
        return this.entityScope;
    }

    void setEntityScope(EventScope entityScope) {
        this.entityScope = entityScope;
    }

    void setEntityParameters(HashMap<String, String> entityParameters) {
        this.entityParameters = entityParameters;
    }

    @Override
    public List<String> listEntityParameterNames() {
        return this.entityParameters != null ? new ArrayList<String>(this.entityParameters.keySet()) : null;
    }

    @Override
    public String getEntityParameter(String name) {
        return this.entityParameters != null ? this.entityParameters.get(name) : null;
    }

    void addEntityParameter(String name, String value) {
        if (this.entityParameters == null) {
            this.entityParameters = new HashMap();
        }
        this.entityParameters.put(name, value);
    }

    @Override
    public boolean isSystem() {
        return this.isSystem;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof EventFlowImpl) {
            EventFlowImpl otherFlow = (EventFlowImpl)other;
            return Utils.equalsNullSafe(this.eventId, otherFlow.eventId) && Utils.equalsNullSafe(this.nodeName, otherFlow.nodeName) && Utils.equalsNullSafe(this.componentType, otherFlow.componentType) && Utils.equalsNullSafe(this.componentName, otherFlow.componentName) && Utils.equalsNullSafe((Object)this.entity, (Object)otherFlow.entity) && Utils.equalsNullSafe(this.entityName, otherFlow.entityName);
        }
        return false;
    }

    @Override
    public EventFlowImpl clone() {
        EventFlowImpl result = (EventFlowImpl)super.clone();
        result.entityParameters = this.entityParameters != null ? (HashMap)this.entityParameters.clone() : null;
        return result;
    }
}

