/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.selector.SelectorExternalDataSource;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sef.EventCache;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.dispatcher.EndpointReferenceImpl;
import com.streamscape.sef.dispatcher.ExchangeEventDispatcher;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.NetworkExchangeConsumer;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.exchange.FabricExchangeException;
import com.streamscape.sef.moderator.EventCacheReference;
import com.streamscape.sef.moderator.ExchangeRole;
import java.util.List;

class EventCacheReferenceImpl
extends EndpointReferenceImpl
implements EventCache,
EventCacheReference,
NetworkExchangeConsumer {
    com.streamscape.lib.dispatcher.EventCache cache;
    transient String repositoryName;

    EventCacheReferenceImpl(FabricAddress componentAddress, FabricAddress address, Filter eventFilter, int maxSize, CacheThresholdAction thresholdAction) throws EventDispatcherException {
        super(ExchangeRole.EVENT_CACHE, componentAddress, EventScope.GLOBAL, address);
        this.cache = ExchangeEventDispatcher.createEventCache(eventFilter, maxSize, thresholdAction, address != null);
    }

    void update(EventCacheReferenceImpl reference) {
        if (reference != this) {
            this.cache = reference.cache;
        }
    }

    @Override
    public String getName() {
        return this.getEventFilter();
    }

    @Override
    public String getEventFilter() {
        return this.cache.getEventFilter().toString();
    }

    @Override
    public int getMaxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void setMaxSize(int maxSize) throws FabricEventDispatcherException, FabricExchangeException {
        if (this.exchange.isRuntime() && this.exchange.isLocal(this.address)) {
            this.doSetMaxSize(maxSize, null);
        } else {
            if (!this.exchange.isRuntime()) {
                this.doSetMaxSize(maxSize);
            }
            this.invokeOperation("setMaxSize", Integer.TYPE, maxSize);
        }
    }

    void doSetMaxSize(int maxSize, FabricAddress clientAddress) throws FabricEventDispatcherException {
        this.doSetMaxSize(maxSize);
        try {
            ((RuntimeExchange)this.exchange).addEventCacheToRepository(this);
            ((RuntimeExchange)this.exchange).changeEventCache(this, clientAddress);
        }
        catch (ExchangeException exception) {
            throw new FabricEventDispatcherException(6011, (Throwable)exception);
        }
    }

    private void doSetMaxSize(int maxSize) throws FabricEventDispatcherException {
        try {
            this.cache.setMaxSize(maxSize);
        }
        catch (EventDispatcherException exception) {
            throw new FabricEventDispatcherException(6007, exception.getMessage());
        }
    }

    @Override
    public CacheThresholdAction getThresholdAction() {
        return this.cache.getThresholdAction();
    }

    @Override
    public int getSize() throws FabricExchangeException {
        if (this.exchange.isRuntime() && this.exchange.isLocal(this.address)) {
            return this.cache.getSize();
        }
        return (Integer)this.invokeOperation("getSize", null, null);
    }

    @Override
    public List<ImmutableEventDatagram> getEvents() throws FabricExchangeException {
        if (this.exchange.isRuntime() && this.exchange.isLocal(this.address)) {
            return this.doGetEvents(ExchangeEventDispatcher.CachedEvent.Scope.GLOBAL);
        }
        return (List)this.invokeOperation("doGetEvents", ExchangeEventDispatcher.CachedEvent.Scope.class, (Object)(this.exchange.isRuntime() ? ExchangeEventDispatcher.CachedEvent.Scope.NETWORK : ExchangeEventDispatcher.CachedEvent.Scope.GLOBAL));
    }

    List<ImmutableEventDatagram> doGetEvents(ExchangeEventDispatcher.CachedEvent.Scope scope) {
        return ExchangeEventDispatcher.getEvents(this.cache, scope);
    }

    @Override
    public void clear() throws FabricExchangeException {
        if (this.exchange.isRuntime() && this.exchange.isLocal(this.address)) {
            this.cache.clear();
        } else {
            this.invokeOperation("clear", null, null);
        }
    }

    private Object invokeOperation(String methodName, Class parameterType, Object parameter) throws FabricExchangeException {
        Object[] objectArray;
        Class[] classArray;
        if (parameterType != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = parameterType;
        } else {
            classArray = new Class[]{};
        }
        if (parameter != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = parameter;
        } else {
            objectArray = new Object[]{};
        }
        return this.invokeOperation(42, methodName, classArray, objectArray);
    }

    @Override
    public CompositeFilter getCompositeFilter() {
        return new CompositeFilter(this.cache.getEventFilter());
    }

    @Override
    public void initSelectorExpression(SelectorExternalDataSource externalDataSource) {
    }

    @Override
    public boolean matches(ImmutableEventDatagram event) {
        return true;
    }

    @Override
    public boolean noLocal() {
        return false;
    }

    @Override
    public String getGroupName() {
        return null;
    }

    @Override
    public boolean isSuitable(FabricAddress componentAddress) {
        return false;
    }
}

