/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.ClusteredEntity;
import com.streamscape.sef.dispatcher.EntityReferenceImpl;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.exchange.FabricExchangeException;
import com.streamscape.sef.moderator.EndpointReference;
import com.streamscape.sef.moderator.ExchangeRole;

abstract class EndpointReferenceImpl
extends EntityReferenceImpl
implements EndpointReference,
ClusteredEntity {
    FabricAddress address;
    transient AbstractExchange exchange;

    EndpointReferenceImpl(ExchangeRole exchangeRole, FabricAddress componentAddress, EventScope eventScope, FabricAddress address) {
        super(exchangeRole, componentAddress, eventScope);
        this.address = address;
    }

    void bind(AbstractExchange exchange) {
        this.exchange = exchange;
    }

    void update(FabricAddress componentAddress, FabricAddress address, AbstractExchange exchange) {
        this.componentAddress = componentAddress;
        this.address = address;
        this.bind(exchange);
    }

    @Override
    public FabricAddress getAddress() {
        return this.address;
    }

    public boolean belongsTo(FabricAddress componentAddress) {
        return this.componentAddress.equals(componentAddress);
    }

    @Override
    public boolean matchesCluster(byte clusterNumber) {
        return this.address.matchesCluster(clusterNumber);
    }

    @Override
    public boolean matchesCluster(ImmutableEventDatagram sourceEvent) {
        return this.matchesCluster(InternalUtils.getClusterNumber(sourceEvent));
    }

    @Override
    public boolean matchesCluster(FabricAddress sourceAddress) {
        return this.matchesCluster(sourceAddress.getClusterNumber());
    }

    Object invokeOperation(int eventId, String methodName, Class[] parameterType, Object[] parameter) throws FabricExchangeException {
        try {
            return this.exchange.raiseInternalRequest(this.address.getNodeAddress(), eventId, (Object)new AbstractExchange.EndpointOperationData(this.address, methodName, parameterType, parameter));
        }
        catch (ExchangeException exception) {
            throw new FabricExchangeException(6011, (Throwable)exception);
        }
        catch (Exception exception) {
            throw new FabricExchangeException(6011, "Raising of internal request [" + this.exchange.getInternalEventName(eventId) + "] failed.", exception);
        }
    }

    @Override
    public String toString() {
        return this.getName() + " [" + String.valueOf(this.address) + "], " + String.valueOf((Object)this.eventScope);
    }
}

