/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractDynamicFabricComponent;
import com.streamscape.sef.dispatcher.FactoryConnectionComponentImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class DynamicComponentsManager {
    private final Monitor monitor = new Monitor();

    DynamicComponentsManager() {
    }

    AbstractDynamicFabricComponent createComponent(ComponentData data) throws Exception {
        FactoryConnectionComponentImpl component = new FactoryConnectionComponentImpl(data.factoryType, data.factoryName, data.userName);
        ((AbstractDynamicFabricComponent)component).init();
        this.monitor.add(component);
        return component;
    }

    void removeComponent(AbstractDynamicFabricComponent component) {
        this.monitor.remove(component.getType(), component.getName());
        this.destroyComponent(component);
    }

    void onAccessorCreated(AccessorData data) {
        this.monitor.remove(data.componentType, data.componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyComponent(AbstractDynamicFabricComponent component) {
        try {
            Monitor monitor = this.monitor;
            synchronized (monitor) {
                component.destroy();
            }
        }
        catch (Exception exception) {
            Trace.logError(this, "Destroying Dynamic Component failed. Cause: " + component.getFullName());
        }
    }

    class Monitor {
        private ComponentsMonitorWorker worker;
        private Map<AbstractDynamicFabricComponent, Long> components = new HashMap<AbstractDynamicFabricComponent, Long>();

        Monitor() {
        }

        private synchronized void add(AbstractDynamicFabricComponent component) {
            if (this.worker == null || !this.worker.isStarted()) {
                try {
                    this.worker = new ComponentsMonitorWorker();
                    this.worker.start();
                }
                catch (Exception exception) {
                    Trace.logError(this, "Starting Dynamic Components monitor failed. Cause: " + exception.getMessage());
                }
            }
            this.components.put(component, System.currentTimeMillis());
        }

        private synchronized void remove(String componentType, String componentName) {
            Iterator<AbstractDynamicFabricComponent> iterator = this.components.keySet().iterator();
            while (iterator.hasNext()) {
                AbstractDynamicFabricComponent component = iterator.next();
                if (!component.getType().equals(componentType) || !component.getName().equals(componentName)) continue;
                iterator.remove();
            }
            if (this.components.size() == 0 && this.worker != null && this.worker.isStarted()) {
                this.worker.stop();
                this.worker = null;
            }
        }

        class ComponentsMonitorWorker
        extends MonitorWorker {
            protected ComponentsMonitorWorker() throws FabricException {
                super("FSYS:ComponentsMonitorWorker", "Monitors Dynamic Connection components without accessors.", 1000L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doExecute() throws FabricException {
                Monitor monitor = Monitor.this;
                synchronized (monitor) {
                    Long now = System.currentTimeMillis();
                    Iterator<Map.Entry<AbstractDynamicFabricComponent, Long>> iterator = Monitor.this.components.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<AbstractDynamicFabricComponent, Long> entry = iterator.next();
                        if (now - entry.getValue() <= 30000L) continue;
                        DynamicComponentsManager.this.destroyComponent(entry.getKey());
                        iterator.remove();
                    }
                    if (Monitor.this.components.size() == 0 && Monitor.this.worker != null && Monitor.this.worker.isStarted()) {
                        this.stop();
                        Monitor.this.worker = null;
                    }
                }
            }
        }
    }

    static class ComponentData
    extends CloneableDataObject {
        String factoryType;
        String factoryName;
        String userName;

        ComponentData(String factoryType, String factoryName, String userName) {
            this.factoryType = factoryType;
            this.factoryName = factoryName;
            this.userName = userName;
        }
    }

    static class AccessorData
    extends CloneableDataObject {
        String componentType;
        String componentName;

        AccessorData(String componentType, String componentName) {
            this.componentType = componentType;
            this.componentName = componentName;
        }
    }
}

