/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCache;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.utils.EIMObject;
import com.streamscape.sef.EventTriggerCompileException;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.accessor.FabricComponentAccessorStateListener;
import com.streamscape.sef.dispatcher.SLRequestRaiser;
import com.streamscape.sef.dispatcher.SLServiceCall;
import com.streamscape.sef.dispatcher.ServiceAccessorProxy;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.service.osf.config.ActiveEvent;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.slex.MFSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DirectServiceAccessor
implements ServiceAccessor {
    private long requestTimeout = 0L;
    private ServiceAccessorProxy serviceAccessorProxy;

    public DirectServiceAccessor(ServiceAccessorProxy serviceAccessorProxy) {
        this.serviceAccessorProxy = serviceAccessorProxy;
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(ImmutableEventDatagram request) throws FabricComponentAccessorException, FabricEventSourceException, ServiceFrameworkException {
        return this.invokeServiceRequest(request, this.requestTimeout);
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(ImmutableEventDatagram request, long timeout) throws FabricComponentAccessorException, FabricEventSourceException, ServiceFrameworkException {
        return this.invokeProxyOnRequest(request);
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, Object data) throws FabricComponentAccessorException, ServiceFrameworkException {
        return this.invokeServiceRequest(eventHandler, data, this.requestTimeout);
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, Object data, long timeout) throws FabricComponentAccessorException, ServiceFrameworkException {
        return this.invokeOperation(SLServiceCall.Operation.INVOKE_BY_EVENT_HANDLER, new Object[]{eventHandler, data}, 6108);
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, Object data, Map<String, Object> properties, long timeout) throws FabricComponentAccessorException, ServiceFrameworkException {
        return this.invokeOperation(SLServiceCall.Operation.INVOKE_BY_EVENT_HANDLER, new Object[]{eventHandler, data, properties}, 6108);
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, EIMObject eimData, Object data) throws FabricComponentAccessorException, ServiceFrameworkException {
        return this.invokeServiceRequest(eventHandler, eimData, data, this.requestTimeout);
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, EIMObject eimData, Object data, long timeout) throws FabricComponentAccessorException, ServiceFrameworkException {
        return this.invokeOperation(SLServiceCall.Operation.INVOKE_BY_EVENT_HANDLER, new Object[]{eventHandler, data, eimData}, 6108);
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(EventDatagram request, RequestDistributionStrategy strategy) throws FabricComponentAccessorException, FabricEventSourceException, ServiceFrameworkException {
        throw new RuntimeException("Operation 'invokeServiceRequest(strategy)' is not supported by DirectServiceAccessor.");
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(EventDatagram request, RequestDistributionStrategy strategy, long timeout) throws FabricComponentAccessorException, FabricEventSourceException, ServiceFrameworkException {
        throw new RuntimeException("Operation 'invokeServiceRequest(strategy)' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void invokeAsyncServiceRequest(ImmutableEventDatagram request) throws FabricComponentAccessorException, FabricEventSourceException {
        throw new RuntimeException("Operation 'invokeAsyncServiceRequest(strategy)' is not supported by DirectServiceAccessor.");
    }

    @Override
    public SLResponse invokeLanguageRequest(SLStatement statement) throws FabricComponentAccessorException {
        return this.invokeLanguageRequest(statement, this.requestTimeout);
    }

    @Override
    public SLResponse invokeLanguageRequest(SLStatement statement, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeLanguageRequest((SLRequestRaiser)new DirectSLRequestRaiser(), statement, timeout);
    }

    @Override
    public SLResponse invokeLanguageRequest(String statement) throws FabricComponentAccessorException {
        return this.invokeLanguageRequest(statement, this.requestTimeout);
    }

    @Override
    public SLResponse invokeLanguageRequest(String statement, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeLanguageRequest((SLRequestRaiser)new DirectSLRequestRaiser(), statement, timeout);
    }

    @Override
    public SLResponse invokeInterruptRequest(String command) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeInterruptRequest(new DirectSLRequestRaiser(), command, this.requestTimeout);
    }

    @Override
    public SLResponse invokeCompleteRequest(String statement) throws FabricComponentAccessorException {
        return this.invokeCompleteRequest(statement, this.requestTimeout);
    }

    @Override
    public SLResponse invokeCompleteRequest(String command, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeCompleteRequest(new DirectSLRequestRaiser(), command, timeout);
    }

    @Override
    public EventHandler lookupEventHandler(String handlerName) throws FabricComponentAccessorException {
        return (EventHandler)this.invokeOperation(SLServiceCall.Operation.LOOKUP_EVENT_HANDLER, new Object[]{handlerName});
    }

    @Override
    public EventHandler lookupEventHandlerByMethod(String methodName) throws FabricComponentAccessorException {
        return (EventHandler)this.invokeOperation(SLServiceCall.Operation.LOOKUP_EVENT_HANDLER_BY_METHOD, new Object[]{methodName});
    }

    @Override
    public boolean isEventHandlerValid(String handlerName) throws FabricComponentAccessorException {
        return (Boolean)this.invokeOperation(SLServiceCall.Operation.IS_EVENT_HANDLER_VALID, new Object[]{handlerName});
    }

    @Override
    public List<EventHandler> getEventHandlers() throws FabricComponentAccessorException {
        return (List)this.invokeOperation(SLServiceCall.Operation.GET_EVENT_HANDLERS, null);
    }

    @Override
    public List<String> listEventHandlers() throws FabricComponentAccessorException {
        return (List)this.invokeOperation(SLServiceCall.Operation.LIST_EVENT_HANDLERS, null);
    }

    @Override
    public List<ActiveEvent> listActiveEvents() throws FabricComponentAccessorException {
        return (List)this.invokeOperation(SLServiceCall.Operation.LIST_ACTIVE_EVENTS, null);
    }

    @Override
    public String getEventHandlerParameterName(String handlerName) throws FabricComponentAccessorException {
        return (String)this.invokeOperation(SLServiceCall.Operation.GET_EVENT_HANDLER_PARAMETER_NAME, new Object[]{handlerName});
    }

    @Override
    public RPLMethodsCache.RPLMethodInfo getEventHandlerRPLMethodInfo(String handlerName) throws FabricComponentAccessorException {
        return (RPLMethodsCache.RPLMethodInfo)this.invokeOperation(SLServiceCall.Operation.GET_EVENT_HANDLER_METHOD_INFO, new Object[]{handlerName});
    }

    @Override
    public List<String> listSinkEvents() {
        try {
            return (List)this.invokeOperation(SLServiceCall.Operation.LIST_SINK_EVENTS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return new ArrayList<String>();
        }
    }

    @Override
    public boolean hasSinkEvents() {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.HAS_SINK_EVENTS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return false;
        }
    }

    @Override
    public List<String> listActionableEvents() {
        try {
            return (List)this.invokeOperation(SLServiceCall.Operation.LIST_ACTIONABLE_EVENTS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return new ArrayList<String>();
        }
    }

    @Override
    public boolean hasActionableEvents() {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.HAS_ACTIONABLE_EVENTS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return false;
        }
    }

    @Override
    public boolean existsActionableEvent(String eventId) {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.EXISTS_ACTIONABLE_EVENTS, new Object[]{eventId});
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return false;
        }
    }

    @Override
    public List<String> listEventTriggers() {
        try {
            return (List)this.invokeOperation(SLServiceCall.Operation.LIST_EVENT_TRIGGERS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return new ArrayList<String>();
        }
    }

    @Override
    public EventTriggerData getEventTriggerData(String triggerName) throws ServiceConfigurationException {
        return (EventTriggerData)this.invokeOperationServiceWithException(SLServiceCall.Operation.GET_EVENT_TRIGGER_DATA, new Object[]{triggerName});
    }

    @Override
    public boolean hasEventTriggers() {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.HAS_EVENT_TRIGGERS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return false;
        }
    }

    @Override
    public boolean existsEventTrigger(String triggerName) {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.EXIST_EVENT_TRIGGER, new Object[]{triggerName});
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return false;
        }
    }

    @Override
    public String getAccessorName() {
        return this.serviceAccessorProxy.accessorSession.getAccessorName();
    }

    @Override
    public String getName() {
        return this.serviceAccessorProxy.accessorSession.getAccessorName();
    }

    @Override
    public EventScope getEventScope() {
        return this.serviceAccessorProxy.accessorSession.getEventScope();
    }

    @Override
    public String getNodeName() {
        return "";
    }

    @Override
    public String getComponentType() {
        return ModeratorUtils.extractComponentNameType(this.serviceAccessorProxy.getMFSession().getResourceName());
    }

    @Override
    public String getComponentName() {
        return ModeratorUtils.extractComponentNameName(this.serviceAccessorProxy.getMFSession().getResourceName());
    }

    @Override
    public ComponentModel getComponentModel() {
        return ComponentModel.SERVICE;
    }

    @Override
    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public void setRequestTimeout(long timeout) {
        this.requestTimeout = timeout;
    }

    @Override
    public boolean isOpened() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public AccessorSessionReference getSession() {
        return this.serviceAccessorProxy.getAccessorSession();
    }

    @Override
    public String getActualNodeName() {
        return ModeratorUtils.extractNodeName(this.serviceAccessorProxy.getMFSession().getResourceName());
    }

    @Override
    public boolean autoSwitching() {
        throw new RuntimeException("Operation 'autoSwitching' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void setAutoSwitching(boolean autoSwitching) throws FabricComponentAccessorException {
        throw new RuntimeException("Operation 'setAutoSwitching' is not supported by DirectServiceAccessor.");
    }

    @Override
    public boolean switchComponent() throws FabricComponentAccessorException {
        throw new RuntimeException("Operation 'switchComponent' is not supported by DirectServiceAccessor.");
    }

    @Override
    public boolean resync() throws FabricComponentAccessorException {
        throw new RuntimeException("Operation 'resync' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void setStateListener(FabricComponentAccessorStateListener listener) {
        throw new RuntimeException("Operation 'setStateListener' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void setStateListener(FabricComponentAccessorStateListener listener, long repeatInterval) {
        throw new RuntimeException("Operation 'setStateListener' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void addEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        throw new RuntimeException("Operation 'addEventTrigger' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void alterEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        throw new RuntimeException("Operation 'alterEventTrigger' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void enableEventTrigger(String triggerName) throws ServiceConfigurationException {
        throw new RuntimeException("Operation 'enableEventTrigger' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void disableEventTrigger(String triggerName) throws ServiceConfigurationException {
        throw new RuntimeException("Operation 'disableEventTrigger' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void removeEventTrigger(String triggerName) throws ServiceConfigurationException {
        throw new RuntimeException("Operation 'removeEventTrigger' is not supported by DirectServiceAccessor.");
    }

    @Override
    public EventTriggerDefinition getEventTriggerDefinition(String triggerName) throws ServiceConfigurationException {
        throw new RuntimeException("Operation 'getEventTriggerDefinition' is not supported by DirectServiceAccessor.");
    }

    @Override
    public List<EventTriggerDefinition> getEventTriggerDefinitions() {
        throw new RuntimeException("Operation 'getEventTriggerDefinitions' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void removeAllEventTriggers() throws ServiceConfigurationException, IllegalTriggerStateException {
        throw new RuntimeException("Operation 'removeAllEventTriggers' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void compileEventTrigger(String triggerName) throws EventTriggerCompileException, IllegalTriggerStateException {
        throw new RuntimeException("Operation 'compileEventTrigger' is not supported by DirectServiceAccessor.");
    }

    @Override
    public String getLastError(String triggerName) {
        throw new RuntimeException("Operation 'getLastError' is not supported by DirectServiceAccessor.");
    }

    @Override
    public EventTriggerState getTriggerState(String triggerName) {
        throw new RuntimeException("Operation 'getTriggerState' is not supported by DirectServiceAccessor.");
    }

    @Override
    public TriggerActionTime getTriggerActionTime(String triggerName) {
        throw new RuntimeException("Operation 'getTriggerActionTime' is not supported by DirectServiceAccessor.");
    }

    @Override
    public String getEventTriggerSyntax(String triggerName) throws ServiceConfigurationException {
        throw new RuntimeException("Operation 'getEventTriggerSyntax' is not supported by DirectServiceAccessor.");
    }

    @Override
    public boolean isEventTriggerAutoEnable(String triggerName) throws IllegalTriggerStateException {
        throw new RuntimeException("Operation 'isEventTriggerAutoEnable' is not supported by DirectServiceAccessor.");
    }

    @Override
    public void setEventTriggerAutoEnable(String triggerName, boolean autoEnable) throws IllegalTriggerStateException, ServiceConfigurationException {
        throw new RuntimeException("Operation 'setEventTriggerAutoEnable' is not supported by DirectServiceAccessor.");
    }

    private ImmutableEventDatagram invokeProxyOnRequest(ImmutableEventDatagram request) throws FabricComponentAccessorException, ServiceFrameworkException {
        try {
            return this.serviceAccessorProxy.onRequest(request);
        }
        catch (FabricRequestException exception) {
            if (exception.getCause() instanceof FabricComponentAccessorException) {
                throw (FabricComponentAccessorException)exception.getCause();
            }
            if (exception.getCause() instanceof ServiceFrameworkException) {
                throw (ServiceFrameworkException)exception.getCause();
            }
            throw new FabricComponentAccessorException(6011, (Throwable)exception);
        }
    }

    protected Object invokeOperation(SLServiceCall.Operation operation, Object[] parameters) throws FabricComponentAccessorException {
        try {
            return this.invokeOperation(operation, parameters, 6011);
        }
        catch (ServiceFrameworkException exception) {
            throw new FabricComponentAccessorException(6011, (Throwable)exception);
        }
    }

    protected Object invokeOperation(SLServiceCall.Operation operation, Object[] parameters, int errorCode) throws FabricComponentAccessorException, ServiceFrameworkException {
        SLResponse response = this.invokeRequest("e.sys.sl.ServiceCall", new SLServiceCall(operation, parameters), this.requestTimeout);
        if (!response.isOK()) {
            if (response.getException() != null) {
                if (response.getException() instanceof FabricComponentAccessorException) {
                    throw (FabricComponentAccessorException)response.getException();
                }
                if (response.getException().getCause() instanceof FabricComponentAccessorException) {
                    throw (FabricComponentAccessorException)response.getException().getCause();
                }
                if (response.getException() instanceof ServiceFrameworkException) {
                    throw (ServiceFrameworkException)response.getException();
                }
                if (response.getException().getCause() instanceof ServiceFrameworkException) {
                    throw (ServiceFrameworkException)response.getException().getCause();
                }
                throw new FabricComponentAccessorException(errorCode, response.getException());
            }
            throw new FabricComponentAccessorException(errorCode, response.getText());
        }
        return response.getObject();
    }

    protected Object invokeOperationServiceWithException(SLServiceCall.Operation operation, Object[] parameters) throws ServiceConfigurationException {
        try {
            return this.invokeOperation(operation, parameters);
        }
        catch (FabricComponentAccessorException e) {
            throw new ServiceConfigurationException(e.getMessage());
        }
    }

    SLResponse invokeRequest(String eventId, Object wrapper, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeRequest(new DirectSLRequestRaiser(), eventId, wrapper, timeout);
    }

    public MFSession getMFSession() {
        return this.serviceAccessorProxy.getMFSession();
    }

    class DirectSLRequestRaiser
    implements SLRequestRaiser {
        DirectSLRequestRaiser() {
        }

        @Override
        public ImmutableEventDatagram raiseSystemRequest(ImmutableEventDatagram request, long timeout) throws Exception {
            return DirectServiceAccessor.this.serviceAccessorProxy.onRequest(request);
        }
    }
}

