/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.dispatcher.ConsumerState;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.selector.SelectorExternalDataSource;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.parser.SelectorParser;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.EventConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.ExchangeConsumerReference;
import com.streamscape.sef.dispatcher.ExchangeEventConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventDirectConsumerImpl;
import com.streamscape.sef.dispatcher.FabricGroupLinkImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.DirectConsumerReference;
import com.streamscape.sef.moderator.ExchangeRole;

class DirectConsumerReferenceImpl
extends EventConsumerReferenceImpl
implements DirectConsumerReference,
ExchangeConsumerReference {
    ExchangeEventConsumerImpl underlyingConsumer;

    DirectConsumerReferenceImpl(FabricEventDirectConsumerImpl fabricImpl, FabricAddress componentAddress, EventScope eventScope, FabricAddress address, boolean noLocal, FabricGroupLinkImpl groupLink) {
        super(ExchangeRole.DIRECT_CONSUMER, componentAddress, eventScope, address, noLocal, groupLink);
        this.bind(fabricImpl.underlyingConsumer);
        fabricImpl.bind(this);
    }

    DirectConsumerReferenceImpl(ExchangeEventConsumerImpl underlyingConsumer, FabricAddress componentAddress, EventScope eventScope, FabricAddress address, boolean noLocal) {
        super(ExchangeRole.DIRECT_CONSUMER, componentAddress, eventScope, address, noLocal, null);
        this.bind(underlyingConsumer);
    }

    void bind(ExchangeEventConsumerImpl underlyingConsumer) {
        this.underlyingConsumer = underlyingConsumer;
        underlyingConsumer.bind(this);
    }

    void update(DirectConsumerReferenceImpl reference) {
        this.bind(reference.underlyingConsumer);
    }

    @Override
    public void update(String name, FabricAddress componentAddress, FabricAddress address, AbstractExchange exchange) {
        this.underlyingConsumer.setName(name);
        this.update(componentAddress, address, exchange);
    }

    @Override
    public String getName() {
        return this.underlyingConsumer.getName();
    }

    @Override
    public String getEventFilter() {
        return this.underlyingConsumer.getEventFilter();
    }

    @Override
    public String getEventSelector() {
        return this.underlyingConsumer.getEventSelector();
    }

    @Override
    public CompositeFilter getCompositeFilter() {
        return this.underlyingConsumer.getCompositeFilter();
    }

    @Override
    public void initSelectorExpression(SelectorExternalDataSource externalDataSource) {
        this.setEventSelector(this.getEventSelector(), externalDataSource);
    }

    private void setEventSelector(String eventSelector, SelectorExternalDataSource externalDataSource) {
        try {
            this.underlyingConsumer.setEventSelector(eventSelector, eventSelector != null ? SelectorParser.parse(eventSelector, externalDataSource) : null);
        }
        catch (SelectorFormatException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Setting of event selector '" + eventSelector + "' for consumer '" + this.getName() + "' failed.");
        }
    }

    @Override
    public boolean matches(ImmutableEventDatagram event) {
        return this.underlyingConsumer.matches(event);
    }

    @Override
    public ConsumerState getCurrentState() {
        return this.underlyingConsumer.getCurrentState();
    }

    @Override
    public boolean matchesEventId(String eventId) {
        return this.underlyingConsumer.matchesEventId(eventId);
    }

    @Override
    public String toString() {
        return String.valueOf((Object)this.exchangeRole) + ": " + super.toString() + ", " + this.getEventFilter();
    }
}

