/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractDetachUnlinkNodeOperation;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;
import java.util.stream.Collectors;

public class DetachNodeOperation
extends AbstractDetachUnlinkNodeOperation {
    public static final String NAME = "detach node";

    public DetachNodeOperation() {
        super(NAME);
        this.syntax.setDescription("Detaches node from the sysplex.");
        this.syntax.setSyntaxDescription("detach node                  - Detaches the current node from the sysplex.\ndetach node <NodeName>       - Detaches the specified node from the sysplex.\n                               Tries to open a session with the specified node and to detach the node then.\ndetach node <NodeName> force - Performs forced detaching the specified node from the sysplex.\n                               Tries to forcibly close all network connections with the specified node.\n                               This operation is potentially unsafe, so use it only if a normal way does not work or\n                               the specified node is not reachable.\n\nOptional parameters:\n\n  with timeout <Timeout> - Wait time (in seconds) for normal detaching the current node.\n                           If the timeout expires before detaching completion, the current node forcibly detaches from the sysplex.\n                           Non-positive value means that forced detaching will not be used. Default is 10 seconds.\n  stop scavenger         - Stops the Scavenger thread in the detached node.\n                           If the parameter 'force' is specified, the Scavenger will be stopped in the current node.");
        this.syntax.setExamples("detach node\ndetach node TestNode1\ndetach node stop scavenger\ndetach node TestNode1 with timeout 30\ndetach node TestNode1 force\ndetach node force with timeout 100");
        this.addCompletionCommandInPreservedOrder("list nodes");
    }

    @Override
    void addNodeModifiers() {
        this.syntax.addModifier(((CompoundModifier)((CompoundModifier)new CompoundModifier(false).setCompactSyntax("[<NodeName> [force]]")).setSyntaxHintSpace()).addParameter((AbstractParameter)((IdentifierParameter)new IdentifierParameter("NodeName").addExclusionValues("FORCE", "WITH", "STOP")).setRequired(false)).addModifier(this.makeForceModifier(false)));
    }

    @Override
    void addOptionalModifiers() {
        this.syntax.addModifier(this.makeWithTimeoutModifier(false));
        this.syntax.addModifier(this.makeStopScavengerModifier());
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getModerator().listFabricNodes().stream().sorted().collect(Collectors.toList()));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(DetachNodeOperation.getTimeoutParameter(statement), DetachNodeOperation.getStopScavengerParameter(statement));
        boolean force = DetachNodeOperation.getForceParameter(statement);
        if (statement.existsParameter("NodeName")) {
            definition.setNode(statement.getParameter("NodeName").getValue(), force);
        } else if (force) {
            throw new ParsingException(this.getSyntaxErrorMessage("Expected parameter with syntax <NodeName>, after 'detach node '."));
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        return definition.force ? this.forcedDetach(definition) : this.invoke(definition.nodeName, statement, session, timeout);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        if (!((RuntimeContext)this.callable).exchange.inSysplex()) {
            throw new FabricException("Node is not in sysplex.");
        }
        Definition definition = (Definition)statement;
        FabricThreadManager.getInstance().createThread("EXCH:Detach.Node", "Detaches the '" + node.getName() + "' node.", () -> {
            Utils.sleep(500L);
            this.detach(definition);
        }).start();
        return new SLResponse();
    }

    private void detach(Definition definition) {
        ((RuntimeContext)this.callable).exchange.detachFromSysplex(true, DetachNodeOperation.getTimeout(definition));
        this.stopScavenger(definition);
    }

    private SLResponse forcedDetach(Definition definition) {
        FabricNodeReference node = ((RuntimeContext)this.callable).getModerator().lookupFabricNode(definition.nodeName);
        if (node == null) {
            return new SLResponse("Node not found.", false);
        }
        if (node.isLocal()) {
            this.detach(definition);
        } else {
            ((RuntimeContext)this.callable).exchange.detachNode((FabricNode)node, DetachNodeOperation.getTimeout(definition));
            this.stopScavenger(definition);
        }
        return new SLResponse();
    }

    static class Definition
    extends AbstractDetachUnlinkNodeOperation.Definition {
        private String nodeName;

        Definition(Long timeout, boolean stopScavenger) {
            super(DetachNodeOperation.NAME, false, timeout, stopScavenger);
        }

        void setNode(String nodeName, boolean force) {
            this.nodeName = nodeName;
            this.force = force;
        }
    }
}

